#!/bin/sh
# Check all wleiden.conf files on valid perl syntax for people not familiar
# with perl to generate right configs

DIRNAME=`dirname $0`

RETVAL=0
for FILE in ${DIRNAME}/*/wleiden.conf; do 
  perl -c $FILE
  if [ $? -ne 0 ]; then
    RETVAL=1
  break
  fi
done

if [ $RETVAL -eq 0 ]; then
    sh ${DIRNAME}/dubbelipcheck.sh
    if [ $? -ne 0 ]; then
        RETVAL=1
    fi
fi

if [ "${RETVAL}" -eq 1 ]; then
  echo "Please fix errors before commit!"
  exit 1
fi
