#!/bin/sh
#
# dubbelipcheck.sh
# Scriptje om in de wleiden.conf files van Wireless Leiden
# te controleren of er geen dubbele ip addressen bestaan
#
# Rick van der Zwet (rick@wirelessleiden.nl)
genesis_nodes_dir="`dirname $0`"
allowed_dubbel_ip="172.31.255.1 172.31.255.2 192.168.1.[0-9]\{1,3\} 0.0.0.0"
TMPDIR=`mktemp -d -t $(basename $0 .sh).XXXXX`

ERRNO=0

#zoek alle ip address in de files op
init()
{
	files=`find $genesis_nodes_dir/*/wleiden.conf | grep -e "[A-Z]Node\|proxy"`
	
	master_ips=`cat $files | grep '^$master_ip' |\
						sed -e 's/[^0-9]*\([0-9]\{1,3\}\.[0-9]\{1,3\}\.[0-9]\{1,3\}\.[0-9]\{1,3\}\).*$/\1/'`
	link_ips=`cat $files | grep ^IP | grep -v '$master_ip' |\
					sed -e 's/IP=//' -e 's/\/[0-9]*//' -e 's/[[:space:]]*$//'`
        echo "$master_ips $link_ips" | sort 
	echo "$master_ips $link_ips" | sort > $TMPDIR/all_ips
	echo "$master_ips $link_ips" | sort -u > $TMPDIR/all_ips_no_double
}


#check up dubbele ip addressen
dubbelIpCheck() {
	dubbel_ips=`comm -23 $TMPDIR/all_ips $TMPDIR/all_ips_no_double | sort -u`
}


#verwijder toegestane dubbele ip's
verwijderToegestaneIps() {
	for allowed in $allowed_dubbel_ip; do
		dubbel_ips=`echo $dubbel_ips | sed s/$allowed//`
	done
}


#print resultaten
results() {
	if [ "$dubbel_ips" ]; then
		for dubbel_ip in $dubbel_ips ; do
			ERRNO=1
			echo ""
			echo "Dubbel ip gevonden: $dubbel_ip"
			echo "Wordt gebruikt in:"
			for file in $files ; do
				grep -v '#' $file | grep "$dubbel_ip/" | grep "^IP\|^$master_ip" > /dev/null && echo "  -$file"
			done
		done
	else
		echo "Geen dubbele ip's gevonden"
	fi
	echo ""
	echo "Toegestane dubbele ip's:"
	for ip in $allowed_dubbel_ip ; do
		echo "   -$ip"
	done
}


#verwijder tijdelijke files
cleanup() {
    rm -R $TMPDIR
}



#hoofdmodule
main() {
	init
	dubbelIpCheck
	verwijderToegestaneIps
	results
	cleanup
}

main
exit $ERRNO

