# zoek de eerste vrije (== niet in een wleiden.conf gedefinieerde) /30
# lvoge@cs.vu.nl
import popen2
import re

ipre = re.compile("^IP=(172\.16\.[0-9]+\.[0-9]+)/30 *")

def parseaddr(s):
	f = s.split('.')
	return (long(f[0]) << 24L) + \
		(long(f[1]) << 16L) + \
		(long(f[2]) << 8L) + \
		long(f[3])

def showaddr(a):
	return "%d.%d.%d.%d" % ((a >> 24) & 0xff, (a >> 16) & 0xff, (a >> 8) & 0xff, a & 0xff)

bezet = {}

(cout, cin) = popen2.popen2("cat */wleiden.conf | grep ^IP | grep 172.16\\\\..*\/30")
cin.close()
for l in cout.readlines():
	l = l[:-1]
	match = ipre.match(l)
	if match == None:
		print "'" + l + "'"
	addr = parseaddr(match.group(1))
	addr = addr & 0xfffffffcL
	bezet[addr] = 1

i = 0xffffffffL
for k in bezet.keys():
	if k < i:
		i = k

while bezet.has_key(i):
	i = i + 4

print "%s/30: %s en %s\n" % (showaddr(i), showaddr(i + 1), showaddr(i + 2))
