#!/bin/sh
#
# Quick and dirty hack to import all data

BASEROOT=`cd $(dirname $0); pwd -P`
DATAROOT=${1:-"$BASEROOT/scan-data"}
MAP_CACHE=${MAP_CACHE:-"/usr/local/var/httpd/cache/maps"}
MANAGE="`dirname $0`/manage.py"
SSH_KEY="`dirname $0`/id_rsa"
export PYTHON_EGG_CACHE=/tmp/

DATAROOT_CHOICES="$DATAROOT /usr/local/scan-data"
if [ "$1" ]; then
  DATAROOT=$1
else
  for D in $DATAROOT_CHOICES; do
    if [ -d $D ]; then
      DATAROOT=$D
    fi
  done
fi
echo "# DATAROOT: $DATAROOT"
echo "# SSH_USER: $SSH_USER"

echo "# rsync webfolder"
if [ -r "$SSH_KEY" ]; then
  SSH_KEY_OPT="-i $SSH_KEY"
  SSH_USER=backup
else
  echo "# warning automatic ssh key $SSH_KEY not readable"
  SSH_KEY_OPT=''
  SSH_USER=${SSH_USER:-$SUDO_USER}
fi
echo rsync -avz -e "ssh $SSH_KEY_OPT -l $SSH_USER -o StrictHostKeyChecking=no" tyan.wirelessleiden.nl:/usr/local/www/webfolder/scan-data/ $DATAROOT


echo "# unzip compressed .tar.gz files"
for FILE in `find $DATAROOT -name '*.tar.gz' | sort`; do
  TARDIR=`dirname $FILE`
  tar -C $TARDIR -xkzf $FILE
done

echo "# unzip compressed .zip files"
for FILE in `find $DATAROOT -name '*.zip' | sort`; do
  ARCHIVEDIR=`dirname $FILE`
  (cd $ARCHIVEDIR; unzip -n $FILE )
done

#Kismet netxml Imports
FILES="`find $DATAROOT -name '*netxml*' | sort`"
[ -n "$FILES" ] && $MANAGE import_datafile $ARGS $FILES

# Import all measure data
for USERDIR in `find $DATAROOT -mindepth 1 -maxdepth 1 -type d | sort`; do
  for DEVICEDIR in `find $USERDIR -mindepth 1 -maxdepth 1 -type d | sort`; do
    USERNAME=`basename $USERDIR`
    DEVICE=`basename $DEVICEDIR`
    ARGS="-g $USERNAME -e $USERNAME@wirelessleiden.nl -k $DEVICE"

    #Kismet gpsxml Imports
    FILES="`find $DEVICEDIR -name '*gpsxml*'`"
    [ -n "$FILES" ] && $MANAGE import_datafile $ARGS $FILES

    # DroidStumber imports
    FILES=`find $DEVICEDIR -name 'ScanResult-*'`
    [ -n "$FILES" ] && $MANAGE import_datafile $ARGS $FILES

    # Kismet imports
    FILES=`find $DEVICEDIR -name '*.ns1'`
    [ -n "$FILES" ] && $MANAGE import_datafile $ARGS $FILES
  done
done

if [ -r $MAP_CACHE ]; then
  echo "# Clear cache $MAP_CACHE"
  htcacheclean -v -l10K -p$MAP_CACHE 
fi

