# Django settings for persisted project.

import os
PROJECT_HOME = os.path.abspath(os.path.dirname(__file__))

DJANGO_PREFIX = '/d'
DJANGO_BALANCERS = OSM_PROXY_BALANCERS = ['a','b','c','d','e','f']
OSM_PROXY_CDN_DOMAINS = [d + '.osmproxy.wirelessleiden.nl' for d in DJANGO_BALANCERS]
OSM_PREFIX = '/osm-tile-proxy'
DJANGO_CDN_DOMAINS = [d + '.maps.wirelessleiden.nl' for d in DJANGO_BALANCERS]

DEBUG = os.path.exists(PROJECT_HOME + '/enable_debug')
TEMPLATE_DEBUG = DEBUG

# Required for Etags Caching Implementation
USE_ETAGS = True

#  Please mind(!), enabling will cause it to send emails when DEBUG=False
ADMINS = (
#      ('Rick van der Zwet', 'info@rickvanderzwet.nl'),
)

MANAGERS = ADMINS

DATABASES = {
    'default': {
        'ENGINE': 'django.db.backends.mysql',
        'NAME': 'project_heatmap',
        'USER': 'root',
        'PASSWORD': '',
        'HOST': 'localhost',
        'PORT': '3306',
    }
}

CACHES = {
    'default': {
        'BACKEND': 'django.core.cache.backends.memcached.MemcachedCache',
        'LOCATION': '127.0.0.1:11211',
        'TIMEOUT': 3600 * 24 * 7,
        'OPTIONS': {
            'MAX_ENTRIES': 100000
        }
    },
    'osm_proxy': {
        'BACKEND': 'django.core.cache.backends.filebased.FileBasedCache',
        'LOCATION': '/usr/local/var/django/cache/osm_proxy',
        'TIMEOUT': 3600 * 24 * 7,
        'OPTIONS': {
            'MAX_ENTRIES': 100000
        }
    },
    'tile_cache': {
        'BACKEND': 'django.core.cache.backends.filebased.FileBasedCache',
        'LOCATION': '/usr/local/var/django/cache/tile_cache',
        'TIMEOUT': 3600 * 24,
        'OPTIONS': {
            'MAX_ENTRIES': 100000
        }
    },
}


# Local time zone for this installation. Choices can be found here:
# http://en.wikipedia.org/wiki/List_of_tz_zones_by_name
# although not all choices may be available on all operating systems.
# If running in a Windows environment this must be set to the same as your
# system time zone.
TIME_ZONE = 'America/Chicago'

# Language code for this installation. All choices can be found here:
# http://www.i18nguy.com/unicode/language-identifiers.html
LANGUAGE_CODE = 'en-us'

SITE_ID = 1

# If you set this to False, Django will make some optimizations so as not
# to load the internationalization machinery.
USE_I18N = True

# Absolute path to the directory that holds media.
# Example: "/home/media/media.lawrence.com/"
MEDIA_ROOT = os.path.join(PROJECT_HOME,'sitemedia')


# URL that handles the media served from MEDIA_ROOT. Make sure to use a
# trailing slash if there is a path component (optional in other cases).
# Examples: "http://media.lawrence.com", "http://example.com/media/"
MEDIA_URL = DJANGO_PREFIX + '/media/'

# Absolute path to the directory static files should be collected to.
# Don't put anything in this directory yourself; store your static files
# in apps' "static/" subdirectories and in STATICFILES_DIRS.
# Example: "/home/media/media.lawrence.com/static/"
STATIC_ROOT =  os.path.join(PROJECT_HOME,'sitestatic')


# URL prefix for static files.
# Example: "http://media.lawrence.com/static/"
STATIC_URL = DJANGO_PREFIX + '/static/'

# URL prefix for admin static files -- CSS, JavaScript and images.
# Make sure to use a trailing slash.
# Examples: "http://foo.com/static/admin/", "/static/admin/".
ADMIN_MEDIA_PREFIX = DJANGO_PREFIX + '/static/admin/'

# Additional locations of static files
STATICFILES_DIRS = (
    # PROJECT_HOME + '/static',
    # Put strings here, like "/home/html/static" or "C:/www/django/static".
    # Always use forward slashes, even on Windows.
    # Don't forget to use absolute paths, not relative paths.
)

# List of finder classes that know how to find static files in
# various locations.
STATICFILES_FINDERS = (
    'django.contrib.staticfiles.finders.FileSystemFinder',
    'django.contrib.staticfiles.finders.AppDirectoriesFinder',
#    'django.contrib.staticfiles.finders.DefaultStorageFinder',
)

# Make this unique, and don't share it with anybody.
SECRET_KEY = '=wg@x19kr@26sibiaynb9ax5ddp1&yu^+$3n++^_lz1ms80syb'

# List of callables that know how to import templates from various sources.
TEMPLATE_LOADERS = (
    'django.template.loaders.filesystem.Loader',
    'django.template.loaders.app_directories.Loader',
    'django.template.loaders.eggs.Loader',
)

MIDDLEWARE_CLASSES = (
    'django.middleware.cache.UpdateCacheMiddleware',
    'django.middleware.common.CommonMiddleware',
    'django.middleware.cache.FetchFromCacheMiddleware',
    'django.middleware.http.ConditionalGetMiddleware',
    'django.contrib.sessions.middleware.SessionMiddleware',
    'django.contrib.auth.middleware.AuthenticationMiddleware',
)

ROOT_URLCONF = 'urls'

TEMPLATE_DIRS = (
    # Put strings here, like "/home/html/django_templates" or "C:/www/django/templates".
    # Always use forward slashes, even on Windows.
    # Don't forget to use absolute paths, not relative paths.
    os.path.join(PROJECT_HOME, 'templates'),
)

INSTALLED_APPS = (
    'django.contrib.admin',
    'django.contrib.auth',
    'django.contrib.contenttypes',
    'django.contrib.sessions',
    'django.contrib.sites',
    'django.contrib.staticfiles',
    'django_extensions',
    'gheat',
    'wlheatmap',
)

# Include and custom local stuff
if os.path.isfile(PROJECT_HOME + '/local_settings.py'):
  from local_settings import *
