#!/bin/sh
#
# Quick and dirty hack to import all data


DATAROOT="$HOME/scan-data"
MANAGE="$HOME/django_gheat/manage.py"

echo "# rsync webfolder"
rsync -az rvdzwet@tyan.wirelessleiden.nl:/usr/local/www/webfolder/scan-data/ $DATAROOT

echo "# unzip compressed .tar.gz files"
for FILE in `find $DATAROOT -name '*.tar.gz'`; do
  TARDIR=`dirname $FILE`
  if [ \! -r "$TARDIR/`tar -tf $FILE | head -1`" ]; then
    tar -C $TARDIR -xzf $file
  fi
done

# Import all data
for USERDIR in `find $DATAROOT -depth 1 -type d`; do
  for DEVICEDIR in `find $USERDIR -depth 1 -type d`; do
    USERNAME=`basename $USERDIR`
    DEVICE=`basename $DEVICEDIR`
    ARGS="-g $USERNAME -e $USERNAME@wirelessleiden.nl -k $DEVICE"
    # Kismet Imports
    for FILE in `find $DEVICEDIR -name 'Kismet*gpsxml*'`; do
      $MANAGE import_kismet $ARGS -m `basename $FILE` $FILE
    done
    
    # DroidStumber imports
    for FILE in `find $DEVICEDIR -name 'ScanResult-*'`; do
      $MANAGE import_droidstumbler $ARGS -m `basename $FILE` $FILE
    done
  done
done

# Clear cache
sudo -u www htcacheclean -l10K -p/usr/local/var/apache/cache/maps

