// Uses zoomlevel en mouseposition to call the nodelist.py view. View returns nodes in json format which is read and printed in document element.
function getNodeList(zoomlevel, mousepos){
  var nodelist;

  if (window.XMLHttpRequest){
    nodelist=new XMLHttpRequest();
  }
  else{
    nodelist=new ActiveXObject("Microsoft.XMLHTTP");
  }

  nodelist.onreadystatechange=function(){
    if (nodelist.readyState==4 && nodelist.status==200){
      json=eval('(' + nodelist.responseText + ')');
      var list;
      if (json.length>0){
        list = '<center>Wireless Leiden nodes on mouseposition:<br /><b>';
        for (var i=0; i<json.length; i++){
          list += json[i].fields.ssid + '<br />';
        }
        list += '</b></center>';
      }
      else{
        list = '<center>No nodes to display.</center>';
      }
      document.getElementById('node_list').innerHTML=list;
    }
  }
  nodelist.open("GET","/website/nodelist/" + zoomlevel + "," + mousepos.lat + "," + mousepos.lon,true);
  nodelist.send();
}


// Get filter values from django view and serve as option list
function getFilters(){
  var filterlist;

  if (window.XMLHttpRequest){
    filterlist=new XMLHttpRequest();
  }
  else{
    filterlist=new ActiveXObject("Microsoft.XMLHTTP");
  }

  filterlist.onreadystatechange=function(){
    if (filterlist.readyState==4 && filterlist.status==200){
      json=eval('(' + filterlist.responseText + ')');
      var list = '<form method="get" action="">';
      list += '<select id="wlnode" style="width:104px"><option></option>';
      for (var i=0; i<json.length; i++){
        list += '<option>' + json[i].fields.ssid + '</option>';
      }
      list += '</select> WLnode<br />';
      list += '<input type="text" id="colour" name="colour" size="10"/> Colour<br />';
      list += '<input type="text" id="lname" name="lname" size="10"/> Layername<br />';
      list += '<input type="button" value="Add filter" onClick="addFilter()"/>';
      list += '</form>';
      document.getElementById('filter_list').innerHTML=list;
    }
  }
  filterlist.open("GET","/website/filters",true);
  filterlist.send();
}


// Some value checks, create an overlay using these values and place it on the map.
function addFilter(){

  var user = '';
  var dataset = '';
  var wlnode = encodeURIComponent(document.getElementById("wlnode").value);
  var enc ='';
  var date = '';
  var colour = encodeURIComponent(document.getElementById("colour").value);
  var lname = encodeURIComponent(document.getElementById("lname").value);

  if (user != ''){user='&accespoint__id='+user;} 
  if (dataset != ''){dataset='&meetrondje__naam='+dataset;} 
  if (wlnode != ''){wlnode='&accespoint__ssid='+wlnode;} 
  if (enc != ''){enc='&accespoint__encryptie='+enc;} 
  if (date != ''){date='&meetrondje__datum='+date;} 
  if (colour != ''){colour='colour='+colour;} 
  else {colour = '&colour='+Math.floor(Math.random()*256)+','+Math.floor(Math.random()*256)+','+Math.floor(Math.random()*256);}
  if (lname != ''){lname=lname;} 
  else {lname = 'Custom Filter';}

  var baseurl = "/website/tile/${z}/${x},${y}.png?";

  OpenLayers.Layer.OSM.Overlay = OpenLayers.Class(OpenLayers.Layer.OSM, {
    initialize: function(name, options) {
      var url = [
        baseurl + colour + user + dataset + wlnode + enc + date
      ];
      options = OpenLayers.Util.extend({ numZoomLevels: 21 }, options);
      var newArguments = [name, url, options];
      OpenLayers.Layer.OSM.prototype.initialize.apply(this, newArguments);
    },
  CLASS_NAME: "OpenLayers.Layer.Overlay"
  });

  filterlayer = new OpenLayers.Layer.OSM.Overlay(lname, {isBaseLayer: false, visibility: true});
  map.addLayer(filterlayer);
}
