#
# Fabric files for deployment and management of django_gheat application 
#
# Rick van der Zwet - <info@rickvanderzwet.nl>
#
from __future__ import with_statement
from fabric.api import local, settings, abort, run, cd, env, sudo
from fabric.contrib.console import confirm

env.shell = "/bin/sh -c"

env.hosts = ['sunfire.wirelessleiden.nl']

def hello():
  print("Hello World!")

def test():
  local("./manage.py runserver 0.0.0.0:8000")

def reset():
  local("./manage.py sqlreset gheat | ./manage.py dbshell")
  local("./manage.py syncdb")

def import_nodes():
  local("../genesis/tools/genesis-to-yaml.pl")
  local("../genesis/tools/gformat.py cleanup")
  local("../genesis/tools/gformat.py full-export | ./manage.py import_nodes -")

def refresh():
  code_dir = '/usr/local/django_gheat'
  with cd(code_dir):
    sudo("svn up")
    sudo("./manage.py collectstatic --noinput")
    sudo("apachectl -k graceful")
 
def deploy():
  code_dir = '/usr/local/django_gheat'
  with cd(code_dir):
    sudo("svn up")
    sudo("apachectl -k graceful")
    run("./manage.py sqlreset gheat | ./manage.py dbshell")
    sudo("./import_scan_data.sh")
    sudo("svn up ../genesis")
    sudo("../genesis/tools/genesis-to-yaml.pl")
    sudo("../genesis/tools/gformat.py cleanup")
    run("../genesis/tools/gformat.py full-export | ./manage.py import_nodes -")
