from django.conf.urls.defaults import *
from django.contrib.staticfiles.urls import staticfiles_urlpatterns
from django.views.decorators.cache import cache_page
from django.views.generic.simple import redirect_to, direct_to_template

# Uncomment the next two lines to enable the admin:
from django.contrib import admin
from django.conf import settings
admin.autodiscover()


urlpatterns = patterns('',
    # Example:
    (r'^robots.txt$', cache_page(60 * 15)(direct_to_template), {'template' : 'robots.txt', 'mimetype' : 'text/plain'}),
    (r'^$', redirect_to, { 'url' : 'wlheatmap/', 'permanent' : False }),
    (r'^wlheatmap/', include('wlheatmap.urls')),
    (r'^gheat/', include('gheat.urls')),
    (r'^admin/', include(admin.site.urls)),
)

urlpatterns += patterns('wlheatmap.osm_proxy',
    url(
        # Example : today/fire/12/3,2.png
        regex = r'^osm-proxy/(?P<zoom>\d+)/(?P<x>\d+)[,/](?P<y>\d+).png$',
        view = 'osm_proxy',
        name = 'osm_proxy',
       ),
    )

if settings.DEBUG:
  urlpatterns += staticfiles_urlpatterns()

