/*

  OpenLayers.js -- OpenLayers Map Viewer Library

  Copyright 2005-2011 OpenLayers Contributors, released under the FreeBSD
  license. Please see http://svn.openlayers.org/trunk/openlayers/license.txt
  for the full text of the license.

  Includes compressed code under the following licenses:

  (For uncompressed versions of the code used please see the
  OpenLayers SVN repository: <http://openlayers.org/>)

*/

/* Contains portions of Prototype.js:
 *
 * Prototype JavaScript framework, version 1.4.0
 *  (c) 2005 Sam Stephenson <sam@conio.net>
 *
 *  Prototype is freely distributable under the terms of an MIT-style license.
 *  For details, see the Prototype web site: http://prototype.conio.net/
 *
 *--------------------------------------------------------------------------*/

/**  
*  
*  Contains portions of Rico <http://openrico.org/>
* 
*  Copyright 2005 Sabre Airline Solutions  
*  
*  Licensed under the Apache License, Version 2.0 (the "License"); you
*  may not use this file except in compliance with the License. You
*  may obtain a copy of the License at
*  
*         http://www.apache.org/licenses/LICENSE-2.0  
*  
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
*  implied. See the License for the specific language governing
*  permissions and limitations under the License. 
*
**/

/**
 * Contains XMLHttpRequest.js <http://code.google.com/p/xmlhttprequest/>
 * Copyright 2007 Sergey Ilinsky (http://www.ilinsky.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0
 */

/**
 * Contains portions of Gears <http://code.google.com/apis/gears/>
 *
 * Copyright 2007, Google Inc.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *  1. Redistributions of source code must retain the above copyright notice,
 *     this list of conditions and the following disclaimer.
 *  2. Redistributions in binary form must reproduce the above copyright notice,
 *     this list of conditions and the following disclaimer in the documentation
 *     and/or other materials provided with the distribution.
 *  3. Neither the name of Google Inc. nor the names of its contributors may be
 *     used to endorse or promote products derived from this software without
 *     specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * Sets up google.gears.*, which is *the only* supported way to access Gears.
 *
 * Circumvent this file at your own risk!
 *
 * In the future, Gears may automatically define google.gears.* without this
 * file. Gears may use these objects to transparently fix bugs and compatibility
 * issues. Applications that use the code below will continue to work seamlessly
 * when that happens.
 */

/**
 * OpenLayers.Util.pagePosition is based on Yahoo's getXY method, which is
 * Copyright (c) 2006, Yahoo! Inc.
 * All rights reserved.
 * 
 * Redistribution and use of this software in source and binary forms, with or
 * without modification, are permitted provided that the following conditions
 * are met:
 * 
 * * Redistributions of source code must retain the above copyright notice,
 *   this list of conditions and the following disclaimer.
 * 
 * * Redistributions in binary form must reproduce the above copyright notice,
 *   this list of conditions and the following disclaimer in the documentation
 *   and/or other materials provided with the distribution.
 * 
 * * Neither the name of Yahoo! Inc. nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission of Yahoo! Inc.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 */(function(){if(!(window.google&&google.gears)){var a=null;if(typeof GearsFactory!="undefined")a=new GearsFactory;else try{a=new ActiveXObject("Gears.Factory");a.getBuildInfo().indexOf("ie_mobile")!=-1&&a.privateSetGlobalObject(this)}catch(b){if(typeof navigator.mimeTypes!="undefined"&&navigator.mimeTypes["application/x-googlegears"]){a=document.createElement("object");a.style.display="none";a.width=0;a.height=0;a.type="application/x-googlegears";document.documentElement.appendChild(a)}}if(a){window.google||
(google={});if(!google.gears)google.gears={factory:a}}}})();var OpenLayers={VERSION_NUMBER:"$Revision: 10995 $",singleFile:true,_getScriptLocation:function(){for(var a=/(^|(.*?\/))(OpenLayers.js)(\?|$)/,b=document.getElementsByTagName("script"),c,d="",e=0,f=b.length;e<f;e++)if(c=b[e].getAttribute("src"))if(c=c.match(a)){d=c[1];break}return function(){return d}}()};
OpenLayers.Class=function(){var a=arguments.length,b=arguments[0],c=arguments[a-1],d=typeof c.initialize=="function"?c.initialize:function(){b.prototype.initialize.apply(this,arguments)};if(a>1){a=[d,b].concat(Array.prototype.slice.call(arguments).slice(1,a-1),c);OpenLayers.inherit.apply(null,a)}else d.prototype=c;return d};OpenLayers.Class.isPrototype=function(){};
OpenLayers.Class.create=function(){return function(){arguments&&arguments[0]!=OpenLayers.Class.isPrototype&&this.initialize.apply(this,arguments)}};OpenLayers.Class.inherit=function(a){var b=function(){a.call(this)},c=[b].concat(Array.prototype.slice.call(arguments));OpenLayers.inherit.apply(null,c);return b.prototype};
OpenLayers.inherit=function(a,b){var c=function(){};c.prototype=b.prototype;a.prototype=new c;var d,e;c=2;for(d=arguments.length;c<d;c++){e=arguments[c];if(typeof e==="function")e=e.prototype;OpenLayers.Util.extend(a.prototype,e)}};OpenLayers.Util=OpenLayers.Util||{};OpenLayers.Util.extend=function(a,b){a=a||{};if(b){for(var c in b){var d=b[c];if(d!==undefined)a[c]=d}if(!(typeof window.Event=="function"&&b instanceof window.Event)&&b.hasOwnProperty&&b.hasOwnProperty("toString"))a.toString=b.toString}return a};
OpenLayers.Protocol=OpenLayers.Class({format:null,options:null,autoDestroy:true,defaultFilter:null,initialize:function(a){a=a||{};OpenLayers.Util.extend(this,a);this.options=a},mergeWithDefaultFilter:function(a){return a&&this.defaultFilter?new OpenLayers.Filter.Logical({type:OpenLayers.Filter.Logical.AND,filters:[this.defaultFilter,a]}):a||this.defaultFilter||undefined},destroy:function(){this.format=this.options=null},read:function(a){a=a||{};a.filter=this.mergeWithDefaultFilter(a.filter)},create:function(){},
update:function(){},"delete":function(){},commit:function(){},abort:function(){},createCallback:function(a,b,c){return OpenLayers.Function.bind(function(){a.apply(this,[b,c])},this)},CLASS_NAME:"OpenLayers.Protocol"});OpenLayers.Protocol.Response=OpenLayers.Class({code:null,requestType:null,last:true,features:null,reqFeatures:null,priv:null,error:null,initialize:function(a){OpenLayers.Util.extend(this,a)},success:function(){return this.code>0},CLASS_NAME:"OpenLayers.Protocol.Response"});
OpenLayers.Protocol.Response.SUCCESS=1;OpenLayers.Protocol.Response.FAILURE=0;OpenLayers.Protocol.SQL=OpenLayers.Class(OpenLayers.Protocol,{databaseName:"ol",tableName:"ol_vector_features",postReadFiltering:true,initialize:function(a){OpenLayers.Protocol.prototype.initialize.apply(this,[a])},destroy:function(){OpenLayers.Protocol.prototype.destroy.apply(this)},supported:function(){return false},evaluateFilter:function(a,b){return b&&this.postReadFiltering?b.evaluate(a):true},CLASS_NAME:"OpenLayers.Protocol.SQL"});
OpenLayers.Console={log:function(){},debug:function(){},info:function(){},warn:function(){},error:function(){},userError:function(a){alert(a)},assert:function(){},dir:function(){},dirxml:function(){},trace:function(){},group:function(){},groupEnd:function(){},time:function(){},timeEnd:function(){},profile:function(){},profileEnd:function(){},count:function(){},CLASS_NAME:"OpenLayers.Console"};
(function(){for(var a=document.getElementsByTagName("script"),b=0,c=a.length;b<c;++b)if(a[b].src.indexOf("firebug.js")!=-1)if(console){OpenLayers.Util.extend(OpenLayers.Console,console);break}})();
OpenLayers.Lang={code:null,defaultCode:"en",getCode:function(){OpenLayers.Lang.code||OpenLayers.Lang.setCode();return OpenLayers.Lang.code},setCode:function(a){var b;a||(a=OpenLayers.BROWSER_NAME=="msie"?navigator.userLanguage:navigator.language);a=a.split("-");a[0]=a[0].toLowerCase();if(typeof OpenLayers.Lang[a[0]]=="object")b=a[0];if(a[1]){var c=a[0]+"-"+a[1].toUpperCase();if(typeof OpenLayers.Lang[c]=="object")b=c}if(!b){OpenLayers.Console.warn("Failed to find OpenLayers.Lang."+a.join("-")+" dictionary, falling back to default language");
b=OpenLayers.Lang.defaultCode}OpenLayers.Lang.code=b},translate:function(a,b){var c=OpenLayers.Lang[OpenLayers.Lang.getCode()];(c=c&&c[a])||(c=a);if(b)c=OpenLayers.String.format(c,b);return c}};OpenLayers.i18n=OpenLayers.Lang.translate;
OpenLayers.String={startsWith:function(a,b){return a.indexOf(b)==0},contains:function(a,b){return a.indexOf(b)!=-1},trim:function(a){return a.replace(/^\s\s*/,"").replace(/\s\s*$/,"")},camelize:function(a){a=a.split("-");for(var b=a[0],c=1,d=a.length;c<d;c++){var e=a[c];b+=e.charAt(0).toUpperCase()+e.substring(1)}return b},format:function(a,b,c){b||(b=window);return a.replace(OpenLayers.String.tokenRegEx,function(d,e){for(var f,g=e.split(/\.+/),h=0;h<g.length;h++){if(h==0)f=b;f=f[g[h]]}if(typeof f==
"function")f=c?f.apply(null,c):f();return typeof f=="undefined"?"undefined":f})},tokenRegEx:/\$\{([\w.]+?)\}/g,numberRegEx:/^([+-]?)(?=\d|\.\d)\d*(\.\d*)?([Ee]([+-]?\d+))?$/,isNumeric:function(a){return OpenLayers.String.numberRegEx.test(a)},numericIf:function(a){return OpenLayers.String.isNumeric(a)?parseFloat(a):a}};
if(!String.prototype.startsWith)String.prototype.startsWith=function(a){OpenLayers.Console.warn(OpenLayers.i18n("methodDeprecated",{newMethod:"OpenLayers.String.startsWith"}));return OpenLayers.String.startsWith(this,a)};if(!String.prototype.contains)String.prototype.contains=function(a){OpenLayers.Console.warn(OpenLayers.i18n("methodDeprecated",{newMethod:"OpenLayers.String.contains"}));return OpenLayers.String.contains(this,a)};
if(!String.prototype.trim)String.prototype.trim=function(){OpenLayers.Console.warn(OpenLayers.i18n("methodDeprecated",{newMethod:"OpenLayers.String.trim"}));return OpenLayers.String.trim(this)};if(!String.prototype.camelize)String.prototype.camelize=function(){OpenLayers.Console.warn(OpenLayers.i18n("methodDeprecated",{newMethod:"OpenLayers.String.camelize"}));return OpenLayers.String.camelize(this)};
OpenLayers.Number={decimalSeparator:".",thousandsSeparator:",",limitSigDigs:function(a,b){var c=0;if(b>0)c=parseFloat(a.toPrecision(b));return c},format:function(a,b,c,d){b=typeof b!="undefined"?b:0;c=typeof c!="undefined"?c:OpenLayers.Number.thousandsSeparator;d=typeof d!="undefined"?d:OpenLayers.Number.decimalSeparator;if(b!=null)a=parseFloat(a.toFixed(b));var e=a.toString().split(".");if(e.length==1&&b==null)b=0;a=e[0];if(c)for(var f=/(-?[0-9]+)([0-9]{3})/;f.test(a);)a=a.replace(f,"$1"+c+"$2");
if(b==0)b=a;else{c=e.length>1?e[1]:"0";if(b!=null)c+=Array(b-c.length+1).join("0");b=a+d+c}return b}};if(!Number.prototype.limitSigDigs)Number.prototype.limitSigDigs=function(a){OpenLayers.Console.warn(OpenLayers.i18n("methodDeprecated",{newMethod:"OpenLayers.Number.limitSigDigs"}));return OpenLayers.Number.limitSigDigs(this,a)};
OpenLayers.Function={bind:function(a,b){var c=Array.prototype.slice.apply(arguments,[2]);return function(){var d=c.concat(Array.prototype.slice.apply(arguments,[0]));return a.apply(b,d)}},bindAsEventListener:function(a,b){return function(c){return a.call(b,c||window.event)}},False:function(){return false},True:function(){return true},Void:function(){}};
if(!Function.prototype.bind)Function.prototype.bind=function(){OpenLayers.Console.warn(OpenLayers.i18n("methodDeprecated",{newMethod:"OpenLayers.Function.bind"}));Array.prototype.unshift.apply(arguments,[this]);return OpenLayers.Function.bind.apply(null,arguments)};
if(!Function.prototype.bindAsEventListener)Function.prototype.bindAsEventListener=function(a){OpenLayers.Console.warn(OpenLayers.i18n("methodDeprecated",{newMethod:"OpenLayers.Function.bindAsEventListener"}));return OpenLayers.Function.bindAsEventListener(this,a)};OpenLayers.Array={filter:function(a,b,c){var d=[];if(Array.prototype.filter)d=a.filter(b,c);else{var e=a.length;if(typeof b!="function")throw new TypeError;for(var f=0;f<e;f++)if(f in a){var g=a[f];b.call(c,g,f,a)&&d.push(g)}}return d}};
OpenLayers.Bounds=OpenLayers.Class({left:null,bottom:null,right:null,top:null,centerLonLat:null,initialize:function(a,b,c,d){if(a!=null)this.left=OpenLayers.Util.toFloat(a);if(b!=null)this.bottom=OpenLayers.Util.toFloat(b);if(c!=null)this.right=OpenLayers.Util.toFloat(c);if(d!=null)this.top=OpenLayers.Util.toFloat(d)},clone:function(){return new OpenLayers.Bounds(this.left,this.bottom,this.right,this.top)},equals:function(a){var b=false;if(a!=null)b=this.left==a.left&&this.right==a.right&&this.top==
a.top&&this.bottom==a.bottom;return b},toString:function(){return[this.left,this.bottom,this.right,this.top].join(",")},toArray:function(a){return a===true?[this.bottom,this.left,this.top,this.right]:[this.left,this.bottom,this.right,this.top]},toBBOX:function(a,b){if(a==null)a=6;var c=Math.pow(10,a),d=Math.round(this.left*c)/c,e=Math.round(this.bottom*c)/c,f=Math.round(this.right*c)/c;c=Math.round(this.top*c)/c;return b===true?e+","+d+","+c+","+f:d+","+e+","+f+","+c},toGeometry:function(){return new OpenLayers.Geometry.Polygon([new OpenLayers.Geometry.LinearRing([new OpenLayers.Geometry.Point(this.left,
this.bottom),new OpenLayers.Geometry.Point(this.right,this.bottom),new OpenLayers.Geometry.Point(this.right,this.top),new OpenLayers.Geometry.Point(this.left,this.top)])])},getWidth:function(){return this.right-this.left},getHeight:function(){return this.top-this.bottom},getSize:function(){return new OpenLayers.Size(this.getWidth(),this.getHeight())},getCenterPixel:function(){return new OpenLayers.Pixel((this.left+this.right)/2,(this.bottom+this.top)/2)},getCenterLonLat:function(){if(!this.centerLonLat)this.centerLonLat=
new OpenLayers.LonLat((this.left+this.right)/2,(this.bottom+this.top)/2);return this.centerLonLat},scale:function(a,b){if(b==null)b=this.getCenterLonLat();var c,d;if(b.CLASS_NAME=="OpenLayers.LonLat"){c=b.lon;d=b.lat}else{c=b.x;d=b.y}return new OpenLayers.Bounds((this.left-c)*a+c,(this.bottom-d)*a+d,(this.right-c)*a+c,(this.top-d)*a+d)},add:function(a,b){if(a==null||b==null){var c=OpenLayers.i18n("boundsAddError");OpenLayers.Console.error(c);return null}return new OpenLayers.Bounds(this.left+a,this.bottom+
b,this.right+a,this.top+b)},extend:function(a){var b=null;if(a){switch(a.CLASS_NAME){case "OpenLayers.LonLat":b=new OpenLayers.Bounds(a.lon,a.lat,a.lon,a.lat);break;case "OpenLayers.Geometry.Point":b=new OpenLayers.Bounds(a.x,a.y,a.x,a.y);break;case "OpenLayers.Bounds":b=a}if(b){this.centerLonLat=null;if(this.left==null||b.left<this.left)this.left=b.left;if(this.bottom==null||b.bottom<this.bottom)this.bottom=b.bottom;if(this.right==null||b.right>this.right)this.right=b.right;if(this.top==null||b.top>
this.top)this.top=b.top}}},containsLonLat:function(a,b){return this.contains(a.lon,a.lat,b)},containsPixel:function(a,b){return this.contains(a.x,a.y,b)},contains:function(a,b,c){if(c==null)c=true;if(a==null||b==null)return false;a=OpenLayers.Util.toFloat(a);b=OpenLayers.Util.toFloat(b);var d=false;return d=c?a>=this.left&&a<=this.right&&b>=this.bottom&&b<=this.top:a>this.left&&a<this.right&&b>this.bottom&&b<this.top},intersectsBounds:function(a,b){if(b==null)b=true;var c=false,d=this.left==a.right||
this.right==a.left||this.top==a.bottom||this.bottom==a.top;if(b||!d){c=a.top>=this.bottom&&a.top<=this.top||this.top>a.bottom&&this.top<a.top;d=a.left>=this.left&&a.left<=this.right||this.left>=a.left&&this.left<=a.right;var e=a.right>=this.left&&a.right<=this.right||this.right>=a.left&&this.right<=a.right;c=(a.bottom>=this.bottom&&a.bottom<=this.top||this.bottom>=a.bottom&&this.bottom<=a.top||c)&&(d||e)}return c},containsBounds:function(a,b,c){if(b==null)b=false;if(c==null)c=true;var d=this.contains(a.left,
a.bottom,c),e=this.contains(a.right,a.bottom,c),f=this.contains(a.left,a.top,c);a=this.contains(a.right,a.top,c);return b?d||e||f||a:d&&e&&f&&a},determineQuadrant:function(a){var b="",c=this.getCenterLonLat();b+=a.lat<c.lat?"b":"t";b+=a.lon<c.lon?"l":"r";return b},transform:function(a,b){this.centerLonLat=null;var c=OpenLayers.Projection.transform({x:this.left,y:this.bottom},a,b),d=OpenLayers.Projection.transform({x:this.right,y:this.bottom},a,b),e=OpenLayers.Projection.transform({x:this.left,y:this.top},
a,b),f=OpenLayers.Projection.transform({x:this.right,y:this.top},a,b);this.left=Math.min(c.x,e.x);this.bottom=Math.min(c.y,d.y);this.right=Math.max(d.x,f.x);this.top=Math.max(e.y,f.y);return this},wrapDateLine:function(a,b){b=b||{};var c=b.leftTolerance||0,d=b.rightTolerance||0,e=this.clone();if(a){for(;e.left<a.left&&e.right-d<=a.left;)e=e.add(a.getWidth(),0);for(;e.left+c>=a.right&&e.right>a.right;)e=e.add(-a.getWidth(),0)}return e},CLASS_NAME:"OpenLayers.Bounds"});
OpenLayers.Bounds.fromString=function(a,b){var c=a.split(",");return OpenLayers.Bounds.fromArray(c,b)};OpenLayers.Bounds.fromArray=function(a,b){return b===true?new OpenLayers.Bounds(parseFloat(a[1]),parseFloat(a[0]),parseFloat(a[3]),parseFloat(a[2])):new OpenLayers.Bounds(parseFloat(a[0]),parseFloat(a[1]),parseFloat(a[2]),parseFloat(a[3]))};OpenLayers.Bounds.fromSize=function(a){return new OpenLayers.Bounds(0,a.h,a.w,0)};
OpenLayers.Bounds.oppositeQuadrant=function(a){var b="";b+=a.charAt(0)=="t"?"b":"t";b+=a.charAt(1)=="l"?"r":"l";return b};
OpenLayers.Element={visible:function(a){return OpenLayers.Util.getElement(a).style.display!="none"},toggle:function(){for(var a=0,b=arguments.length;a<b;a++){var c=OpenLayers.Util.getElement(arguments[a]),d=OpenLayers.Element.visible(c)?"hide":"show";OpenLayers.Element[d](c)}},hide:function(){OpenLayers.Console.warn(OpenLayers.i18n("methodDeprecated",{newMethod:"element.style.display = 'none';"}));for(var a=0,b=arguments.length;a<b;a++){var c=OpenLayers.Util.getElement(arguments[a]);if(c)c.style.display=
"none"}},show:function(){OpenLayers.Console.warn(OpenLayers.i18n("methodDeprecated",{newMethod:"element.style.display = '';"}));for(var a=0,b=arguments.length;a<b;a++){var c=OpenLayers.Util.getElement(arguments[a]);if(c)c.style.display=""}},remove:function(a){a=OpenLayers.Util.getElement(a);a.parentNode.removeChild(a)},getHeight:function(a){a=OpenLayers.Util.getElement(a);return a.offsetHeight},getDimensions:function(a){a=OpenLayers.Util.getElement(a);if(OpenLayers.Element.getStyle(a,"display")!=
"none")return{width:a.offsetWidth,height:a.offsetHeight};var b=a.style,c=b.visibility,d=b.position,e=b.display;b.visibility="hidden";b.position="absolute";b.display="";var f=a.clientWidth;a=a.clientHeight;b.display=e;b.position=d;b.visibility=c;return{width:f,height:a}},hasClass:function(a,b){var c=a.className;return!!c&&RegExp("(^|\\s)"+b+"(\\s|$)").test(c)},addClass:function(a,b){OpenLayers.Element.hasClass(a,b)||(a.className+=(a.className?" ":"")+b);return a},removeClass:function(a,b){var c=a.className;
if(c)a.className=OpenLayers.String.trim(c.replace(RegExp("(^|\\s+)"+b+"(\\s+|$)")," "));return a},toggleClass:function(a,b){OpenLayers.Element.hasClass(a,b)?OpenLayers.Element.removeClass(a,b):OpenLayers.Element.addClass(a,b);return a},getStyle:function(a,b){a=OpenLayers.Util.getElement(a);var c=null;if(a&&a.style){c=a.style[OpenLayers.String.camelize(b)];if(!c)if(document.defaultView&&document.defaultView.getComputedStyle)c=(c=document.defaultView.getComputedStyle(a,null))?c.getPropertyValue(b):
null;else if(a.currentStyle)c=a.currentStyle[OpenLayers.String.camelize(b)];var d=["left","top","right","bottom"];if(window.opera&&OpenLayers.Util.indexOf(d,b)!=-1&&OpenLayers.Element.getStyle(a,"position")=="static")c="auto"}return c=="auto"?null:c}};
OpenLayers.LonLat=OpenLayers.Class({lon:0,lat:0,initialize:function(a,b){this.lon=OpenLayers.Util.toFloat(a);this.lat=OpenLayers.Util.toFloat(b)},toString:function(){return"lon="+this.lon+",lat="+this.lat},toShortString:function(){return this.lon+", "+this.lat},clone:function(){return new OpenLayers.LonLat(this.lon,this.lat)},add:function(a,b){if(a==null||b==null){var c=OpenLayers.i18n("lonlatAddError");OpenLayers.Console.error(c);return null}return new OpenLayers.LonLat(this.lon+OpenLayers.Util.toFloat(a),
this.lat+OpenLayers.Util.toFloat(b))},equals:function(a){var b=false;if(a!=null)b=this.lon==a.lon&&this.lat==a.lat||isNaN(this.lon)&&isNaN(this.lat)&&isNaN(a.lon)&&isNaN(a.lat);return b},transform:function(a,b){var c=OpenLayers.Projection.transform({x:this.lon,y:this.lat},a,b);this.lon=c.x;this.lat=c.y;return this},wrapDateLine:function(a){var b=this.clone();if(a){for(;b.lon<a.left;)b.lon+=a.getWidth();for(;b.lon>a.right;)b.lon-=a.getWidth()}return b},CLASS_NAME:"OpenLayers.LonLat"});
OpenLayers.LonLat.fromString=function(a){a=a.split(",");return new OpenLayers.LonLat(a[0],a[1])};OpenLayers.LonLat.fromArray=function(a){var b=OpenLayers.Util.isArray(a);return new OpenLayers.LonLat(b&&a[0],b&&a[1])};
OpenLayers.Pixel=OpenLayers.Class({x:0,y:0,initialize:function(a,b){this.x=parseFloat(a);this.y=parseFloat(b)},toString:function(){return"x="+this.x+",y="+this.y},clone:function(){return new OpenLayers.Pixel(this.x,this.y)},equals:function(a){var b=false;if(a!=null)b=this.x==a.x&&this.y==a.y||isNaN(this.x)&&isNaN(this.y)&&isNaN(a.x)&&isNaN(a.y);return b},distanceTo:function(a){return Math.sqrt(Math.pow(this.x-a.x,2)+Math.pow(this.y-a.y,2))},add:function(a,b){if(a==null||b==null){var c=OpenLayers.i18n("pixelAddError");
OpenLayers.Console.error(c);return null}return new OpenLayers.Pixel(this.x+a,this.y+b)},offset:function(a){var b=this.clone();if(a)b=this.add(a.x,a.y);return b},CLASS_NAME:"OpenLayers.Pixel"});
OpenLayers.Size=OpenLayers.Class({w:0,h:0,initialize:function(a,b){this.w=parseFloat(a);this.h=parseFloat(b)},toString:function(){return"w="+this.w+",h="+this.h},clone:function(){return new OpenLayers.Size(this.w,this.h)},equals:function(a){var b=false;if(a!=null)b=this.w==a.w&&this.h==a.h||isNaN(this.w)&&isNaN(this.h)&&isNaN(a.w)&&isNaN(a.h);return b},CLASS_NAME:"OpenLayers.Size"});OpenLayers.Util=OpenLayers.Util||{};
OpenLayers.Util.getElement=function(){for(var a=[],b=0,c=arguments.length;b<c;b++){var d=arguments[b];if(typeof d=="string")d=document.getElementById(d);if(arguments.length==1)return d;a.push(d)}return a};OpenLayers.Util.isElement=function(a){return!!(a&&a.nodeType===1)};OpenLayers.Util.isArray=function(a){return Object.prototype.toString.call(a)==="[object Array]"};if(typeof window.$==="undefined")window.$=OpenLayers.Util.getElement;
OpenLayers.Util.removeItem=function(a,b){for(var c=a.length-1;c>=0;c--)a[c]==b&&a.splice(c,1);return a};OpenLayers.Util.clearArray=function(a){OpenLayers.Console.warn(OpenLayers.i18n("methodDeprecated",{newMethod:"array = []"}));a.length=0};OpenLayers.Util.indexOf=function(a,b){if(typeof a.indexOf=="function")return a.indexOf(b);else{for(var c=0,d=a.length;c<d;c++)if(a[c]==b)return c;return-1}};
OpenLayers.Util.modifyDOMElement=function(a,b,c,d,e,f,g,h){if(b)a.id=b;if(c){a.style.left=c.x+"px";a.style.top=c.y+"px"}if(d){a.style.width=d.w+"px";a.style.height=d.h+"px"}if(e)a.style.position=e;if(f)a.style.border=f;if(g)a.style.overflow=g;if(parseFloat(h)>=0&&parseFloat(h)<1){a.style.filter="alpha(opacity="+h*100+")";a.style.opacity=h}else if(parseFloat(h)==1){a.style.filter="";a.style.opacity=""}};
OpenLayers.Util.createDiv=function(a,b,c,d,e,f,g,h){var j=document.createElement("div");if(d)j.style.backgroundImage="url("+d+")";a||(a=OpenLayers.Util.createUniqueID("OpenLayersDiv"));e||(e="absolute");OpenLayers.Util.modifyDOMElement(j,a,b,c,e,f,g,h);return j};
OpenLayers.Util.createImage=function(a,b,c,d,e,f,g,h){var j=document.createElement("img");a||(a=OpenLayers.Util.createUniqueID("OpenLayersDiv"));e||(e="relative");OpenLayers.Util.modifyDOMElement(j,a,b,c,e,f,null,g);if(h){j.style.display="none";OpenLayers.Event.observe(j,"load",OpenLayers.Function.bind(OpenLayers.Util.onImageLoad,j));OpenLayers.Event.observe(j,"error",OpenLayers.Function.bind(OpenLayers.Util.onImageLoadError,j))}j.style.alt=a;j.galleryImg="no";if(d)j.src=d;return j};
OpenLayers.Util.setOpacity=function(a,b){OpenLayers.Util.modifyDOMElement(a,null,null,null,null,null,null,b)};OpenLayers.Util.onImageLoad=function(){if(!this.viewRequestID||this.map&&this.viewRequestID==this.map.viewRequestID)this.style.display="";OpenLayers.Element.removeClass(this,"olImageLoadError")};OpenLayers.IMAGE_RELOAD_ATTEMPTS=0;
OpenLayers.Util.onImageLoadError=function(){this._attempts=this._attempts?this._attempts+1:1;if(this._attempts<=OpenLayers.IMAGE_RELOAD_ATTEMPTS){var a=this.urls;if(a&&OpenLayers.Util.isArray(a)&&a.length>1){var b=this.src.toString(),c,d;for(d=0;c=a[d];d++)if(b.indexOf(c)!=-1)break;var e=Math.floor(a.length*Math.random());e=a[e];for(d=0;e==c&&d++<4;){e=Math.floor(a.length*Math.random());e=a[e]}this.src=b.replace(c,e)}else this.src=this.src}else OpenLayers.Element.addClass(this,"olImageLoadError");
this.style.display=""};OpenLayers.Util.alphaHackNeeded=null;OpenLayers.Util.alphaHack=function(){if(OpenLayers.Util.alphaHackNeeded==null){var a=navigator.appVersion.split("MSIE");a=parseFloat(a[1]);var b=false;try{b=!!document.body.filters}catch(c){}OpenLayers.Util.alphaHackNeeded=b&&a>=5.5&&a<7}return OpenLayers.Util.alphaHackNeeded};
OpenLayers.Util.modifyAlphaImageDiv=function(a,b,c,d,e,f,g,h,j){OpenLayers.Util.modifyDOMElement(a,b,c,d,f,null,null,j);b=a.childNodes[0];if(e)b.src=e;OpenLayers.Util.modifyDOMElement(b,a.id+"_innerImage",null,d,"relative",g);if(OpenLayers.Util.alphaHack()){if(a.style.display!="none")a.style.display="inline-block";if(h==null)h="scale";a.style.filter="progid:DXImageTransform.Microsoft.AlphaImageLoader(src='"+b.src+"', sizingMethod='"+h+"')";if(parseFloat(a.style.opacity)>=0&&parseFloat(a.style.opacity)<
1)a.style.filter+=" alpha(opacity="+a.style.opacity*100+")";b.style.filter="alpha(opacity=0)"}};
OpenLayers.Util.createAlphaImageDiv=function(a,b,c,d,e,f,g,h,j){var i=OpenLayers.Util.createDiv(),k=OpenLayers.Util.createImage(null,null,null,null,null,null,null,false);i.appendChild(k);if(j){k.style.display="none";OpenLayers.Event.observe(k,"load",OpenLayers.Function.bind(OpenLayers.Util.onImageLoad,i));OpenLayers.Event.observe(k,"error",OpenLayers.Function.bind(OpenLayers.Util.onImageLoadError,i))}OpenLayers.Util.modifyAlphaImageDiv(i,a,b,c,d,e,f,g,h);return i};
OpenLayers.Util.upperCaseObject=function(a){var b={},c;for(c in a)b[c.toUpperCase()]=a[c];return b};OpenLayers.Util.applyDefaults=function(a,b){a=a||{};var c=typeof window.Event=="function"&&b instanceof window.Event,d;for(d in b)if(a[d]===undefined||!c&&b.hasOwnProperty&&b.hasOwnProperty(d)&&!a.hasOwnProperty(d))a[d]=b[d];if(!c&&b&&b.hasOwnProperty&&b.hasOwnProperty("toString")&&!a.hasOwnProperty("toString"))a.toString=b.toString;return a};
OpenLayers.Util.getParameterString=function(a){var b=[],c;for(c in a){var d=a[c];if(d!=null&&typeof d!="function"){if(typeof d=="object"&&d.constructor==Array){for(var e=[],f,g=0,h=d.length;g<h;g++){f=d[g];e.push(encodeURIComponent(f===null||f===undefined?"":f))}d=e.join(",")}else d=encodeURIComponent(d);b.push(encodeURIComponent(c)+"="+d)}}return b.join("&")};OpenLayers.Util.urlAppend=function(a,b){var c=a;if(b){var d=(a+" ").split(/[?&]/);c+=d.pop()===" "?b:d.length?"&"+b:"?"+b}return c};
OpenLayers.ImgPath="";OpenLayers.Util.getImagesLocation=function(){return OpenLayers.ImgPath||OpenLayers._getScriptLocation()+"img/"};OpenLayers.Util.Try=function(){for(var a=null,b=0,c=arguments.length;b<c;b++){var d=arguments[b];try{a=d();break}catch(e){}}return a};OpenLayers.Util.getXmlNodeValue=function(a){var b=null;OpenLayers.Util.Try(function(){b=a.text;if(!b)b=a.textContent;if(!b)b=a.firstChild.nodeValue},function(){b=a.textContent});return b};
OpenLayers.Util.mouseLeft=function(a,b){for(var c=a.relatedTarget?a.relatedTarget:a.toElement;c!=b&&c!=null;)c=c.parentNode;return c!=b};OpenLayers.Util.DEFAULT_PRECISION=14;OpenLayers.Util.toFloat=function(a,b){if(b==null)b=OpenLayers.Util.DEFAULT_PRECISION;if(typeof a!=="number")a=parseFloat(a);return b===0?a:parseFloat(a.toPrecision(b))};OpenLayers.Util.rad=function(a){return a*Math.PI/180};OpenLayers.Util.deg=function(a){return a*180/Math.PI};
OpenLayers.Util.VincentyConstants={a:6378137,b:6356752.3142,f:1/298.257223563};
OpenLayers.Util.distVincenty=function(a,b){var c=OpenLayers.Util.VincentyConstants,d=c.a,e=c.b;c=c.f;var f=OpenLayers.Util.rad(b.lon-a.lon),g=Math.atan((1-c)*Math.tan(OpenLayers.Util.rad(a.lat))),h=Math.atan((1-c)*Math.tan(OpenLayers.Util.rad(b.lat))),j=Math.sin(g);g=Math.cos(g);var i=Math.sin(h);h=Math.cos(h);for(var k=f,l=2*Math.PI,m=20;Math.abs(k-l)>1.0E-12&&--m>0;){var n=Math.sin(k),p=Math.cos(k),r=Math.sqrt(h*n*h*n+(g*i-j*h*p)*(g*i-j*h*p));if(r==0)return 0;p=j*i+g*h*p;var t=Math.atan2(r,p),s=
Math.asin(g*h*n/r),v=Math.cos(s)*Math.cos(s);n=p-2*j*i/v;var x=c/16*v*(4+c*(4-3*v));l=k;k=f+(1-x)*c*Math.sin(s)*(t+x*r*(n+x*p*(-1+2*n*n)))}if(m==0)return NaN;d=v*(d*d-e*e)/(e*e);c=d/1024*(256+d*(-128+d*(74-47*d)));return(e*(1+d/16384*(4096+d*(-768+d*(320-175*d))))*(t-c*r*(n+c/4*(p*(-1+2*n*n)-c/6*n*(-3+4*r*r)*(-3+4*n*n))))).toFixed(3)/1E3};
OpenLayers.Util.destinationVincenty=function(a,b,c){var d=OpenLayers.Util,e=d.VincentyConstants,f=e.a,g=e.b;e=e.f;var h=a.lon,j=a.lat;a=d.rad(b);b=Math.sin(a);a=Math.cos(a);var i=(1-e)*Math.tan(d.rad(j));j=1/Math.sqrt(1+i*i);var k=i*j,l=Math.atan2(i,a);i=j*b;var m=1-i*i;f=m*(f*f-g*g)/(g*g);var n=1+f/16384*(4096+f*(-768+f*(320-175*f))),p=f/1024*(256+f*(-128+f*(74-47*f)));f=c/(g*n);for(var r=2*Math.PI;Math.abs(f-r)>1.0E-12;){var t=Math.cos(2*l+f),s=Math.sin(f),v=Math.cos(f),x=p*s*(t+p/4*(v*(-1+2*t*
t)-p/6*t*(-3+4*s*s)*(-3+4*t*t)));r=f;f=c/(g*n)+x}c=k*s-j*v*a;c=Math.atan2(k*v+j*s*a,(1-e)*Math.sqrt(i*i+c*c));g=e/16*m*(4+e*(4-3*m));return new OpenLayers.LonLat(h+d.deg(Math.atan2(s*b,j*v-k*s*a)-(1-g)*e*i*(f+g*s*(t+g*v*(-1+2*t*t)))),d.deg(c))};
OpenLayers.Util.getParameters=function(a){a=a===null||a===undefined?window.location.href:a;var b="";if(OpenLayers.String.contains(a,"?")){b=a.indexOf("?")+1;var c=OpenLayers.String.contains(a,"#")?a.indexOf("#"):a.length;b=a.substring(b,c)}a={};b=b.split(/[&;]/);c=0;for(var d=b.length;c<d;++c){var e=b[c].split("=");if(e[0]){var f=e[0];try{f=decodeURIComponent(f)}catch(g){f=unescape(f)}e=(e[1]||"").replace(/\+/g," ");try{e=decodeURIComponent(e)}catch(h){e=unescape(e)}e=e.split(",");if(e.length==1)e=
e[0];a[f]=e}}return a};OpenLayers.Util.getArgs=function(a){OpenLayers.Console.warn(OpenLayers.i18n("methodDeprecated",{newMethod:"OpenLayers.Util.getParameters"}));return OpenLayers.Util.getParameters(a)};OpenLayers.Util.lastSeqID=0;OpenLayers.Util.createUniqueID=function(a){if(a==null)a="id_";OpenLayers.Util.lastSeqID+=1;return a+OpenLayers.Util.lastSeqID};OpenLayers.INCHES_PER_UNIT={inches:1,ft:12,mi:63360,m:39.3701,km:39370.1,dd:4374754,yd:36};OpenLayers.INCHES_PER_UNIT["in"]=OpenLayers.INCHES_PER_UNIT.inches;
OpenLayers.INCHES_PER_UNIT.degrees=OpenLayers.INCHES_PER_UNIT.dd;OpenLayers.INCHES_PER_UNIT.nmi=1852*OpenLayers.INCHES_PER_UNIT.m;OpenLayers.METERS_PER_INCH=0.0254000508001016;
OpenLayers.Util.extend(OpenLayers.INCHES_PER_UNIT,{Inch:OpenLayers.INCHES_PER_UNIT.inches,Meter:1/OpenLayers.METERS_PER_INCH,Foot:0.3048006096012192/OpenLayers.METERS_PER_INCH,IFoot:0.3048/OpenLayers.METERS_PER_INCH,ClarkeFoot:0.3047972651151/OpenLayers.METERS_PER_INCH,SearsFoot:0.30479947153867626/OpenLayers.METERS_PER_INCH,GoldCoastFoot:0.3047997101815088/OpenLayers.METERS_PER_INCH,IInch:0.0254/OpenLayers.METERS_PER_INCH,MicroInch:2.54E-5/OpenLayers.METERS_PER_INCH,Mil:2.54E-8/OpenLayers.METERS_PER_INCH,
Centimeter:0.01/OpenLayers.METERS_PER_INCH,Kilometer:1E3/OpenLayers.METERS_PER_INCH,Yard:0.9144018288036576/OpenLayers.METERS_PER_INCH,SearsYard:0.914398414616029/OpenLayers.METERS_PER_INCH,IndianYard:0.9143985307444408/OpenLayers.METERS_PER_INCH,IndianYd37:0.91439523/OpenLayers.METERS_PER_INCH,IndianYd62:0.9143988/OpenLayers.METERS_PER_INCH,IndianYd75:0.9143985/OpenLayers.METERS_PER_INCH,IndianFoot:0.30479951/OpenLayers.METERS_PER_INCH,IndianFt37:0.30479841/OpenLayers.METERS_PER_INCH,IndianFt62:0.3047996/
OpenLayers.METERS_PER_INCH,IndianFt75:0.3047995/OpenLayers.METERS_PER_INCH,Mile:1609.3472186944373/OpenLayers.METERS_PER_INCH,IYard:0.9144/OpenLayers.METERS_PER_INCH,IMile:1609.344/OpenLayers.METERS_PER_INCH,NautM:1852/OpenLayers.METERS_PER_INCH,"Lat-66":110943.31648893273/OpenLayers.METERS_PER_INCH,"Lat-83":110946.25736872235/OpenLayers.METERS_PER_INCH,Decimeter:0.1/OpenLayers.METERS_PER_INCH,Millimeter:0.001/OpenLayers.METERS_PER_INCH,Dekameter:10/OpenLayers.METERS_PER_INCH,Decameter:10/OpenLayers.METERS_PER_INCH,
Hectometer:100/OpenLayers.METERS_PER_INCH,GermanMeter:1.0000135965/OpenLayers.METERS_PER_INCH,CaGrid:0.999738/OpenLayers.METERS_PER_INCH,ClarkeChain:20.1166194976/OpenLayers.METERS_PER_INCH,GunterChain:20.11684023368047/OpenLayers.METERS_PER_INCH,BenoitChain:20.116782494375872/OpenLayers.METERS_PER_INCH,SearsChain:20.11676512155/OpenLayers.METERS_PER_INCH,ClarkeLink:0.201166194976/OpenLayers.METERS_PER_INCH,GunterLink:0.2011684023368047/OpenLayers.METERS_PER_INCH,BenoitLink:0.20116782494375873/OpenLayers.METERS_PER_INCH,
SearsLink:0.2011676512155/OpenLayers.METERS_PER_INCH,Rod:5.02921005842012/OpenLayers.METERS_PER_INCH,IntnlChain:20.1168/OpenLayers.METERS_PER_INCH,IntnlLink:0.201168/OpenLayers.METERS_PER_INCH,Perch:5.02921005842012/OpenLayers.METERS_PER_INCH,Pole:5.02921005842012/OpenLayers.METERS_PER_INCH,Furlong:201.1684023368046/OpenLayers.METERS_PER_INCH,Rood:3.778266898/OpenLayers.METERS_PER_INCH,CapeFoot:0.3047972615/OpenLayers.METERS_PER_INCH,Brealey:375/OpenLayers.METERS_PER_INCH,ModAmFt:0.304812252984506/
OpenLayers.METERS_PER_INCH,Fathom:1.8288/OpenLayers.METERS_PER_INCH,"NautM-UK":1853.184/OpenLayers.METERS_PER_INCH,"50kilometers":5E4/OpenLayers.METERS_PER_INCH,"150kilometers":15E4/OpenLayers.METERS_PER_INCH});
OpenLayers.Util.extend(OpenLayers.INCHES_PER_UNIT,{mm:OpenLayers.INCHES_PER_UNIT.Meter/1E3,cm:OpenLayers.INCHES_PER_UNIT.Meter/100,dm:OpenLayers.INCHES_PER_UNIT.Meter*100,km:OpenLayers.INCHES_PER_UNIT.Meter*1E3,kmi:OpenLayers.INCHES_PER_UNIT.nmi,fath:OpenLayers.INCHES_PER_UNIT.Fathom,ch:OpenLayers.INCHES_PER_UNIT.IntnlChain,link:OpenLayers.INCHES_PER_UNIT.IntnlLink,"us-in":OpenLayers.INCHES_PER_UNIT.inches,"us-ft":OpenLayers.INCHES_PER_UNIT.Foot,"us-yd":OpenLayers.INCHES_PER_UNIT.Yard,"us-ch":OpenLayers.INCHES_PER_UNIT.GunterChain,
"us-mi":OpenLayers.INCHES_PER_UNIT.Mile,"ind-yd":OpenLayers.INCHES_PER_UNIT.IndianYd37,"ind-ft":OpenLayers.INCHES_PER_UNIT.IndianFt37,"ind-ch":20.11669506/OpenLayers.METERS_PER_INCH});OpenLayers.DOTS_PER_INCH=72;OpenLayers.Util.normalizeScale=function(a){return a>1?1/a:a};OpenLayers.Util.getResolutionFromScale=function(a,b){var c;if(a){if(b==null)b="degrees";c=1/(OpenLayers.Util.normalizeScale(a)*OpenLayers.INCHES_PER_UNIT[b]*OpenLayers.DOTS_PER_INCH)}return c};
OpenLayers.Util.getScaleFromResolution=function(a,b){if(b==null)b="degrees";return a*OpenLayers.INCHES_PER_UNIT[b]*OpenLayers.DOTS_PER_INCH};OpenLayers.Util.safeStopPropagation=function(a){OpenLayers.Event.stop(a,true)};
OpenLayers.Util.pagePosition=function(a){var b=[0,0],c=OpenLayers.Util.getViewportElement();if(!a||a==window||a==c)return b;var d=OpenLayers.IS_GECKO&&document.getBoxObjectFor&&OpenLayers.Element.getStyle(a,"position")=="absolute"&&(a.style.top==""||a.style.left==""),e=null;if(a.getBoundingClientRect){a=a.getBoundingClientRect();e=c.scrollTop;b[0]=a.left+c.scrollLeft;b[1]=a.top+e}else if(document.getBoxObjectFor&&!d){a=document.getBoxObjectFor(a);c=document.getBoxObjectFor(c);b[0]=a.screenX-c.screenX;
b[1]=a.screenY-c.screenY}else{b[0]=a.offsetLeft;b[1]=a.offsetTop;e=a.offsetParent;if(e!=a)for(;e;){b[0]+=e.offsetLeft;b[1]+=e.offsetTop;e=e.offsetParent}c=OpenLayers.BROWSER_NAME;if(c=="opera"||c=="safari"&&OpenLayers.Element.getStyle(a,"position")=="absolute")b[1]-=document.body.offsetTop;for(e=a.offsetParent;e&&e!=document.body;){b[0]-=e.scrollLeft;if(c!="opera"||e.tagName!="TR")b[1]-=e.scrollTop;e=e.offsetParent}}return b};
OpenLayers.Util.getViewportElement=function(){var a=arguments.callee.viewportElement;if(a==undefined){a=OpenLayers.BROWSER_NAME=="msie"&&document.compatMode!="CSS1Compat"?document.body:document.documentElement;arguments.callee.viewportElement=a}return a};
OpenLayers.Util.isEquivalentUrl=function(a,b,c){c=c||{};OpenLayers.Util.applyDefaults(c,{ignoreCase:true,ignorePort80:true,ignoreHash:true});a=OpenLayers.Util.createUrlObject(a,c);b=OpenLayers.Util.createUrlObject(b,c);for(var d in a)if(d!=="args")if(a[d]!=b[d])return false;for(d in a.args){if(a.args[d]!=b.args[d])return false;delete b.args[d]}for(d in b.args)return false;return true};
OpenLayers.Util.createUrlObject=function(a,b){b=b||{};if(!/^\w+:\/\//.test(a)){var c=window.location,d=c.port?":"+c.port:"";d=c.protocol+"//"+c.host.split(":").shift()+d;if(a.indexOf("/")===0)a=d+a;else{c=c.pathname.split("/");c.pop();a=d+c.join("/")+"/"+a}}if(b.ignoreCase)a=a.toLowerCase();c=document.createElement("a");c.href=a;d={};d.host=c.host.split(":").shift();d.protocol=c.protocol;d.port=b.ignorePort80?c.port=="80"||c.port=="0"?"":c.port:c.port==""||c.port=="0"?"80":c.port;d.hash=b.ignoreHash||
c.hash==="#"?"":c.hash;var e=c.search;if(!e){e=a.indexOf("?");e=e!=-1?a.substr(e):""}d.args=OpenLayers.Util.getParameters(e);d.pathname=c.pathname.charAt(0)=="/"?c.pathname:"/"+c.pathname;return d};OpenLayers.Util.removeTail=function(a){var b=null;b=a.indexOf("?");var c=a.indexOf("#");return b=b==-1?c!=-1?a.substr(0,c):a:c!=-1?a.substr(0,Math.min(b,c)):a.substr(0,b)};OpenLayers.IS_GECKO=function(){var a=navigator.userAgent.toLowerCase();return a.indexOf("webkit")==-1&&a.indexOf("gecko")!=-1}();
OpenLayers.BROWSER_NAME=function(){var a="",b=navigator.userAgent.toLowerCase();if(b.indexOf("opera")!=-1)a="opera";else if(b.indexOf("msie")!=-1)a="msie";else if(b.indexOf("safari")!=-1)a="safari";else if(b.indexOf("mozilla")!=-1)a=b.indexOf("firefox")!=-1?"firefox":"mozilla";return a}();OpenLayers.Util.getBrowserName=function(){return OpenLayers.BROWSER_NAME};
OpenLayers.Util.getRenderedDimensions=function(a,b,c){var d,e,f=document.createElement("div");f.style.visibility="hidden";var g=c&&c.containerElement?c.containerElement:document.body;if(b)if(b.w){d=b.w;f.style.width=d+"px"}else if(b.h){e=b.h;f.style.height=e+"px"}if(c&&c.displayClass)f.className=c.displayClass;b=document.createElement("div");b.innerHTML=a;b.style.overflow="visible";if(b.childNodes){a=0;for(c=b.childNodes.length;a<c;a++)if(b.childNodes[a].style)b.childNodes[a].style.overflow="visible"}f.appendChild(b);
g.appendChild(f);a=false;for(c=f.parentNode;c&&c.tagName.toLowerCase()!="body";){var h=OpenLayers.Element.getStyle(c,"position");if(h=="absolute"){a=true;break}else if(h&&h!="static")break;c=c.parentNode}if(!a)f.style.position="absolute";if(!d){d=parseInt(b.scrollWidth);f.style.width=d+"px"}e||(e=parseInt(b.scrollHeight));f.removeChild(b);g.removeChild(f);return new OpenLayers.Size(d,e)};
OpenLayers.Util.getScrollbarWidth=function(){var a=OpenLayers.Util._scrollbarWidth;if(a==null){var b=null,c=null;b=a=0;b=document.createElement("div");b.style.position="absolute";b.style.top="-1000px";b.style.left="-1000px";b.style.width="100px";b.style.height="50px";b.style.overflow="hidden";c=document.createElement("div");c.style.width="100%";c.style.height="200px";b.appendChild(c);document.body.appendChild(b);a=c.offsetWidth;b.style.overflow="scroll";b=c.offsetWidth;document.body.removeChild(document.body.lastChild);
OpenLayers.Util._scrollbarWidth=a-b;a=OpenLayers.Util._scrollbarWidth}return a};
OpenLayers.Util.getFormattedLonLat=function(a,b,c){c||(c="dms");a=(a+540)%360-180;var d=Math.abs(a),e=Math.floor(d),f=d=(d-e)/(1/60);d=Math.floor(d);f=Math.round((f-d)/(1/60)*10);f/=10;if(f>=60){f-=60;d+=1;if(d>=60){d-=60;e+=1}}if(e<10)e="0"+e;e+="\u00b0";if(c.indexOf("dm")>=0){if(d<10)d="0"+d;e+=d+"'";if(c.indexOf("dms")>=0){if(f<10)f="0"+f;e+=f+'"'}}e+=b=="lon"?a<0?OpenLayers.i18n("W"):OpenLayers.i18n("E"):a<0?OpenLayers.i18n("S"):OpenLayers.i18n("N");return e};
OpenLayers.Format=OpenLayers.Class({options:null,externalProjection:null,internalProjection:null,data:null,keepData:false,initialize:function(a){OpenLayers.Util.extend(this,a);this.options=a},destroy:function(){},read:function(){OpenLayers.Console.userError(OpenLayers.i18n("readNotImplemented"))},write:function(){OpenLayers.Console.userError(OpenLayers.i18n("writeNotImplemented"))},CLASS_NAME:"OpenLayers.Format"});
OpenLayers.Format.JSON=OpenLayers.Class(OpenLayers.Format,{indent:"    ",space:" ",newline:"\n",level:0,pretty:false,nativeJSON:function(){return!!(window.JSON&&typeof JSON.parse=="function"&&typeof JSON.stringify=="function")}(),read:function(a,b){var c;if(this.nativeJSON)c=JSON.parse(a,b);else try{if(/^[\],:{}\s]*$/.test(a.replace(/\\["\\\/bfnrtu]/g,"@").replace(/"[^"\\\n\r]*"|true|false|null|-?\d+(?:\.\d*)?(?:[eE][+\-]?\d+)?/g,"]").replace(/(?:^|:|,)(?:\s*\[)+/g,""))){c=eval("("+a+")");if(typeof b===
"function"){var d=function(f,g){if(g&&typeof g==="object")for(var h in g)if(g.hasOwnProperty(h))g[h]=d(h,g[h]);return b(f,g)};c=d("",c)}}}catch(e){}if(this.keepData)this.data=c;return c},write:function(a,b){this.pretty=!!b;var c=null,d=typeof a;if(this.serialize[d])try{c=!this.pretty&&this.nativeJSON?JSON.stringify(a):this.serialize[d].apply(this,[a])}catch(e){OpenLayers.Console.error("Trouble serializing: "+e)}return c},writeIndent:function(){var a=[];if(this.pretty)for(var b=0;b<this.level;++b)a.push(this.indent);
return a.join("")},writeNewline:function(){return this.pretty?this.newline:""},writeSpace:function(){return this.pretty?this.space:""},serialize:{object:function(a){if(a==null)return"null";if(a.constructor==Date)return this.serialize.date.apply(this,[a]);if(a.constructor==Array)return this.serialize.array.apply(this,[a]);var b=["{"];this.level+=1;var c,d,e,f=false;for(c in a)if(a.hasOwnProperty(c)){d=OpenLayers.Format.JSON.prototype.write.apply(this,[c,this.pretty]);e=OpenLayers.Format.JSON.prototype.write.apply(this,
[a[c],this.pretty]);if(d!=null&&e!=null){f&&b.push(",");b.push(this.writeNewline(),this.writeIndent(),d,":",this.writeSpace(),e);f=true}}this.level-=1;b.push(this.writeNewline(),this.writeIndent(),"}");return b.join("")},array:function(a){var b,c=["["];this.level+=1;for(var d=0,e=a.length;d<e;++d){b=OpenLayers.Format.JSON.prototype.write.apply(this,[a[d],this.pretty]);if(b!=null){d>0&&c.push(",");c.push(this.writeNewline(),this.writeIndent(),b)}}this.level-=1;c.push(this.writeNewline(),this.writeIndent(),
"]");return c.join("")},string:function(a){var b={"\u0008":"\\b","\t":"\\t","\n":"\\n","\u000c":"\\f","\r":"\\r",'"':'\\"',"\\":"\\\\"};if(/["\\\x00-\x1f]/.test(a))return'"'+a.replace(/([\x00-\x1f\\"])/g,function(c,d){var e=b[d];if(e)return e;e=d.charCodeAt();return"\\u00"+Math.floor(e/16).toString(16)+(e%16).toString(16)})+'"';return'"'+a+'"'},number:function(a){return isFinite(a)?String(a):"null"},"boolean":function(a){return String(a)},date:function(a){function b(c){return c<10?"0"+c:c}return'"'+
a.getFullYear()+"-"+b(a.getMonth()+1)+"-"+b(a.getDate())+"T"+b(a.getHours())+":"+b(a.getMinutes())+":"+b(a.getSeconds())+'"'}},CLASS_NAME:"OpenLayers.Format.JSON"});
OpenLayers.Feature=OpenLayers.Class({layer:null,id:null,lonlat:null,data:null,marker:null,popupClass:null,popup:null,initialize:function(a,b,c){this.layer=a;this.lonlat=b;this.data=c!=null?c:{};this.id=OpenLayers.Util.createUniqueID(this.CLASS_NAME+"_")},destroy:function(){this.layer!=null&&this.layer.map!=null&&this.popup!=null&&this.layer.map.removePopup(this.popup);this.layer!=null&&this.marker!=null&&this.layer.removeMarker(this.marker);this.data=this.lonlat=this.id=this.layer=null;if(this.marker!=
null){this.destroyMarker(this.marker);this.marker=null}if(this.popup!=null){this.destroyPopup(this.popup);this.popup=null}},onScreen:function(){var a=false;if(this.layer!=null&&this.layer.map!=null)a=this.layer.map.getExtent().containsLonLat(this.lonlat);return a},createMarker:function(){if(this.lonlat!=null)this.marker=new OpenLayers.Marker(this.lonlat,this.data.icon);return this.marker},destroyMarker:function(){this.marker.destroy()},createPopup:function(a){if(this.lonlat!=null){if(!this.popup)this.popup=
new (this.popupClass?this.popupClass:OpenLayers.Popup.AnchoredBubble)(this.id+"_popup",this.lonlat,this.data.popupSize,this.data.popupContentHTML,this.marker?this.marker.icon:null,a);if(this.data.overflow!=null)this.popup.contentDiv.style.overflow=this.data.overflow;this.popup.feature=this}return this.popup},destroyPopup:function(){if(this.popup){this.popup.feature=null;this.popup.destroy();this.popup=null}},CLASS_NAME:"OpenLayers.Feature"});
OpenLayers.State={UNKNOWN:"Unknown",INSERT:"Insert",UPDATE:"Update",DELETE:"Delete"};
OpenLayers.Feature.Vector=OpenLayers.Class(OpenLayers.Feature,{fid:null,geometry:null,attributes:null,bounds:null,state:null,style:null,url:null,renderIntent:"default",modified:null,initialize:function(a,b,c){OpenLayers.Feature.prototype.initialize.apply(this,[null,null,b]);this.lonlat=null;this.geometry=a?a:null;this.state=null;this.attributes={};if(b)this.attributes=OpenLayers.Util.extend(this.attributes,b);this.style=c?c:null},destroy:function(){if(this.layer){this.layer.removeFeatures(this);this.layer=
null}this.modified=this.geometry=null;OpenLayers.Feature.prototype.destroy.apply(this,arguments)},clone:function(){return new OpenLayers.Feature.Vector(this.geometry?this.geometry.clone():null,this.attributes,this.style)},onScreen:function(a){var b=false;if(this.layer&&this.layer.map){b=this.layer.map.getExtent();if(a){a=this.geometry.getBounds();b=b.intersectsBounds(a)}else b=b.toGeometry().intersects(this.geometry)}return b},getVisibility:function(){return!(this.style&&this.style.display=="none"||
!this.layer||this.layer&&this.layer.styleMap&&this.layer.styleMap.createSymbolizer(this,this.renderIntent).display=="none"||this.layer&&!this.layer.getVisibility())},createMarker:function(){return null},destroyMarker:function(){},createPopup:function(){return null},atPoint:function(a,b,c){var d=false;if(this.geometry)d=this.geometry.atPoint(a,b,c);return d},destroyPopup:function(){},move:function(a){if(this.layer&&this.geometry.move){a=a.CLASS_NAME=="OpenLayers.LonLat"?this.layer.getViewPortPxFromLonLat(a):
a;var b=this.layer.getViewPortPxFromLonLat(this.geometry.getBounds().getCenterLonLat()),c=this.layer.map.getResolution();this.geometry.move(c*(a.x-b.x),c*(b.y-a.y));this.layer.drawFeature(this);return b}},toState:function(a){if(a==OpenLayers.State.UPDATE)switch(this.state){case OpenLayers.State.UNKNOWN:case OpenLayers.State.DELETE:this.state=a}else if(a==OpenLayers.State.INSERT)switch(this.state){case OpenLayers.State.UNKNOWN:break;default:this.state=a}else if(a==OpenLayers.State.DELETE)switch(this.state){case OpenLayers.State.UNKNOWN:case OpenLayers.State.UPDATE:this.state=
a}else if(a==OpenLayers.State.UNKNOWN)this.state=a},CLASS_NAME:"OpenLayers.Feature.Vector"});
OpenLayers.Feature.Vector.style={"default":{fillColor:"#ee9900",fillOpacity:0.4,hoverFillColor:"white",hoverFillOpacity:0.8,strokeColor:"#ee9900",strokeOpacity:1,strokeWidth:1,strokeLinecap:"round",strokeDashstyle:"solid",hoverStrokeColor:"red",hoverStrokeOpacity:1,hoverStrokeWidth:0.2,pointRadius:6,hoverPointRadius:1,hoverPointUnit:"%",pointerEvents:"visiblePainted",cursor:"inherit"},select:{fillColor:"blue",fillOpacity:0.4,hoverFillColor:"white",hoverFillOpacity:0.8,strokeColor:"blue",strokeOpacity:1,
strokeWidth:2,strokeLinecap:"round",strokeDashstyle:"solid",hoverStrokeColor:"red",hoverStrokeOpacity:1,hoverStrokeWidth:0.2,pointRadius:6,hoverPointRadius:1,hoverPointUnit:"%",pointerEvents:"visiblePainted",cursor:"pointer"},temporary:{fillColor:"#66cccc",fillOpacity:0.2,hoverFillColor:"white",hoverFillOpacity:0.8,strokeColor:"#66cccc",strokeOpacity:1,strokeLinecap:"round",strokeWidth:2,strokeDashstyle:"solid",hoverStrokeColor:"red",hoverStrokeOpacity:1,hoverStrokeWidth:0.2,pointRadius:6,hoverPointRadius:1,
hoverPointUnit:"%",pointerEvents:"visiblePainted",cursor:"inherit"},"delete":{display:"none"}};
OpenLayers.Format.WKT=OpenLayers.Class(OpenLayers.Format,{initialize:function(a){this.regExes={typeStr:/^\s*(\w+)\s*\(\s*(.*)\s*\)\s*$/,spaces:/\s+/,parenComma:/\)\s*,\s*\(/,doubleParenComma:/\)\s*\)\s*,\s*\(\s*\(/,trimParens:/^\s*\(?(.*?)\)?\s*$/};OpenLayers.Format.prototype.initialize.apply(this,[a])},read:function(a){var b,c;a=a.replace(/[\n\r]/g," ");if(c=this.regExes.typeStr.exec(a)){a=c[1].toLowerCase();c=c[2];if(this.parse[a])b=this.parse[a].apply(this,[c]);if(this.internalProjection&&this.externalProjection)if(b&&
b.CLASS_NAME=="OpenLayers.Feature.Vector")b.geometry.transform(this.externalProjection,this.internalProjection);else if(b&&a!="geometrycollection"&&typeof b=="object"){a=0;for(c=b.length;a<c;a++)b[a].geometry.transform(this.externalProjection,this.internalProjection)}}return b},write:function(a){var b,c;if(a.constructor==Array)c=true;else{a=[a];c=false}var d=[];c&&d.push("GEOMETRYCOLLECTION(");for(var e=0,f=a.length;e<f;++e){c&&e>0&&d.push(",");b=a[e].geometry;d.push(this.extractGeometry(b))}c&&d.push(")");
return d.join("")},extractGeometry:function(a){var b=a.CLASS_NAME.split(".")[2].toLowerCase();if(!this.extract[b])return null;if(this.internalProjection&&this.externalProjection){a=a.clone();a.transform(this.internalProjection,this.externalProjection)}return(b=="collection"?"GEOMETRYCOLLECTION":b.toUpperCase())+"("+this.extract[b].apply(this,[a])+")"},extract:{point:function(a){return a.x+" "+a.y},multipoint:function(a){for(var b=[],c=0,d=a.components.length;c<d;++c)b.push("("+this.extract.point.apply(this,
[a.components[c]])+")");return b.join(",")},linestring:function(a){for(var b=[],c=0,d=a.components.length;c<d;++c)b.push(this.extract.point.apply(this,[a.components[c]]));return b.join(",")},multilinestring:function(a){for(var b=[],c=0,d=a.components.length;c<d;++c)b.push("("+this.extract.linestring.apply(this,[a.components[c]])+")");return b.join(",")},polygon:function(a){for(var b=[],c=0,d=a.components.length;c<d;++c)b.push("("+this.extract.linestring.apply(this,[a.components[c]])+")");return b.join(",")},
multipolygon:function(a){for(var b=[],c=0,d=a.components.length;c<d;++c)b.push("("+this.extract.polygon.apply(this,[a.components[c]])+")");return b.join(",")},collection:function(a){for(var b=[],c=0,d=a.components.length;c<d;++c)b.push(this.extractGeometry.apply(this,[a.components[c]]));return b.join(",")}},parse:{point:function(a){a=OpenLayers.String.trim(a).split(this.regExes.spaces);return new OpenLayers.Feature.Vector(new OpenLayers.Geometry.Point(a[0],a[1]))},multipoint:function(a){for(var b=
OpenLayers.String.trim(a).split(","),c=[],d=0,e=b.length;d<e;++d){a=b[d].replace(this.regExes.trimParens,"$1");c.push(this.parse.point.apply(this,[a]).geometry)}return new OpenLayers.Feature.Vector(new OpenLayers.Geometry.MultiPoint(c))},linestring:function(a){a=OpenLayers.String.trim(a).split(",");for(var b=[],c=0,d=a.length;c<d;++c)b.push(this.parse.point.apply(this,[a[c]]).geometry);return new OpenLayers.Feature.Vector(new OpenLayers.Geometry.LineString(b))},multilinestring:function(a){for(var b=
OpenLayers.String.trim(a).split(this.regExes.parenComma),c=[],d=0,e=b.length;d<e;++d){a=b[d].replace(this.regExes.trimParens,"$1");c.push(this.parse.linestring.apply(this,[a]).geometry)}return new OpenLayers.Feature.Vector(new OpenLayers.Geometry.MultiLineString(c))},polygon:function(a){var b;a=OpenLayers.String.trim(a).split(this.regExes.parenComma);for(var c=[],d=0,e=a.length;d<e;++d){b=a[d].replace(this.regExes.trimParens,"$1");b=this.parse.linestring.apply(this,[b]).geometry;b=new OpenLayers.Geometry.LinearRing(b.components);
c.push(b)}return new OpenLayers.Feature.Vector(new OpenLayers.Geometry.Polygon(c))},multipolygon:function(a){for(var b=OpenLayers.String.trim(a).split(this.regExes.doubleParenComma),c=[],d=0,e=b.length;d<e;++d){a=b[d].replace(this.regExes.trimParens,"$1");c.push(this.parse.polygon.apply(this,[a]).geometry)}return new OpenLayers.Feature.Vector(new OpenLayers.Geometry.MultiPolygon(c))},geometrycollection:function(a){a=a.replace(/,\s*([A-Za-z])/g,"|$1");a=OpenLayers.String.trim(a).split("|");for(var b=
[],c=0,d=a.length;c<d;++c)b.push(OpenLayers.Format.WKT.prototype.read.apply(this,[a[c]]));return b}},CLASS_NAME:"OpenLayers.Format.WKT"});
OpenLayers.Protocol.SQL.Gears=OpenLayers.Class(OpenLayers.Protocol.SQL,{FID_PREFIX:"__gears_fid__",NULL_GEOMETRY:"__gears_null_geometry__",NULL_FEATURE_STATE:"__gears_null_feature_state__",jsonParser:null,wktParser:null,fidRegExp:null,saveFeatureState:true,typeOfFid:"string",db:null,initialize:function(a){if(this.supported()){OpenLayers.Protocol.SQL.prototype.initialize.apply(this,[a]);this.jsonParser=new OpenLayers.Format.JSON;this.wktParser=new OpenLayers.Format.WKT;this.fidRegExp=RegExp("^"+this.FID_PREFIX);
this.initializeDatabase()}},initializeDatabase:function(){this.db=google.gears.factory.create("beta.database");this.db.open(this.databaseName);this.db.execute("CREATE TABLE IF NOT EXISTS "+this.tableName+" (fid TEXT UNIQUE, geometry TEXT, properties TEXT,  state TEXT)")},destroy:function(){this.db.close();this.wktParser=this.jsonParser=this.db=null;OpenLayers.Protocol.SQL.prototype.destroy.apply(this)},supported:function(){return!!(window.google&&google.gears)},read:function(a){OpenLayers.Protocol.prototype.read.apply(this,
arguments);a=OpenLayers.Util.applyDefaults(a,this.options);for(var b,c=[],d=this.db.execute("SELECT * FROM "+this.tableName);d.isValidRow();){b=this.unfreezeFeature(d);if(this.evaluateFilter(b,a.filter)){if(!a.noFeatureStateReset)b.state=null;c.push(b)}d.next()}d.close();b=new OpenLayers.Protocol.Response({code:OpenLayers.Protocol.Response.SUCCESS,requestType:"read",features:c});a&&a.callback&&a.callback.call(a.scope,b);return b},unfreezeFeature:function(a){var b;b=a.fieldByName("geometry");b=b==
this.NULL_GEOMETRY?new OpenLayers.Feature.Vector:this.wktParser.read(b);b.attributes=this.jsonParser.read(a.fieldByName("properties"));b.fid=this.extractFidFromField(a.fieldByName("fid"));a=a.fieldByName("state");if(a==this.NULL_FEATURE_STATE)a=null;b.state=a;return b},extractFidFromField:function(a){if(!a.match(this.fidRegExp)&&this.typeOfFid=="number")a=parseFloat(a);return a},create:function(a,b){b=OpenLayers.Util.applyDefaults(b,this.options);var c=this.createOrUpdate(a);c.requestType="create";
b&&b.callback&&b.callback.call(b.scope,c);return c},update:function(a,b){b=OpenLayers.Util.applyDefaults(b,this.options);var c=this.createOrUpdate(a);c.requestType="update";b&&b.callback&&b.callback.call(b.scope,c);return c},createOrUpdate:function(a){OpenLayers.Util.isArray(a)||(a=[a]);var b,c=a.length,d,e=Array(c);for(b=0;b<c;b++){d=a[b];var f=this.freezeFeature(d);this.db.execute("REPLACE INTO "+this.tableName+" (fid, geometry, properties, state) VALUES (?, ?, ?, ?)",f);d=d.clone();d.fid=this.extractFidFromField(f[0]);
e[b]=d}return new OpenLayers.Protocol.Response({code:OpenLayers.Protocol.Response.SUCCESS,features:e,reqFeatures:a})},freezeFeature:function(a){a.fid=a.fid!=null?""+a.fid:OpenLayers.Util.createUniqueID(this.FID_PREFIX);var b=a.geometry!=null?a.geometry.toString():this.NULL_GEOMETRY,c=this.jsonParser.write(a.attributes),d=this.getFeatureStateForFreeze(a);return[a.fid,b,c,d]},getFeatureStateForFreeze:function(a){return this.saveFeatureState?this.createdOffline(a)?OpenLayers.State.INSERT:a.state:this.NULL_FEATURE_STATE},
"delete":function(a,b){OpenLayers.Util.isArray(a)||(a=[a]);b=OpenLayers.Util.applyDefaults(b,this.options);var c,d,e;c=0;for(d=a.length;c<d;c++){e=a[c];if(this.saveFeatureState&&!this.createdOffline(e)){var f=e.clone();f.fid=e.fid;if(f.geometry){f.geometry.destroy();f.geometry=null}f.state=e.state;this.createOrUpdate(f)}else this.db.execute("DELETE FROM "+this.tableName+" WHERE fid = ?",[e.fid])}c=new OpenLayers.Protocol.Response({code:OpenLayers.Protocol.Response.SUCCESS,requestType:"delete",reqFeatures:a});
b&&b.callback&&b.callback.call(b.scope,c);return c},createdOffline:function(a){return typeof a.fid=="string"&&!!a.fid.match(this.fidRegExp)},commit:function(a,b){function c(l){if(++g<f)l.last=false;this.callUserCallback(b,l)}for(var d,e=[],f=0,g=0,h=[],j=[],i=[],k=a.length-1;k>=0;k--){d=a[k];switch(d.state){case OpenLayers.State.INSERT:h.push(d);break;case OpenLayers.State.UPDATE:j.push(d);break;case OpenLayers.State.DELETE:i.push(d)}}if(h.length>0){f++;d=OpenLayers.Util.applyDefaults({callback:c,
scope:this},b.create);e.push(this.create(h,d))}if(j.length>0){f++;d=OpenLayers.Util.applyDefaults({callback:c,scope:this},b.update);e.push(this.update(j,d))}if(i.length>0){f++;d=OpenLayers.Util.applyDefaults({callback:c,scope:this},b["delete"]);e.push(this["delete"](i,d))}return e},clear:function(){this.db.execute("DELETE FROM "+this.tableName)},callUserCallback:function(a,b){var c=a[b.requestType];c&&c.callback&&c.callback.call(c.scope,b);b.last&&a.callback&&a.callback.call(a.scope)},CLASS_NAME:"OpenLayers.Protocol.SQL.Gears"});
OpenLayers.Event={observers:false,KEY_BACKSPACE:8,KEY_TAB:9,KEY_RETURN:13,KEY_ESC:27,KEY_LEFT:37,KEY_UP:38,KEY_RIGHT:39,KEY_DOWN:40,KEY_DELETE:46,element:function(a){return a.target||a.srcElement},isSingleTouch:function(a){return a.touches&&a.touches.length==1},isMultiTouch:function(a){return a.touches&&a.touches.length>1},isLeftClick:function(a){return a.which&&a.which==1||a.button&&a.button==1},isRightClick:function(a){return a.which&&a.which==3||a.button&&a.button==2},stop:function(a,b){if(!b)if(a.preventDefault)a.preventDefault();
else a.returnValue=false;if(a.stopPropagation)a.stopPropagation();else a.cancelBubble=true},findElement:function(a,b){for(var c=OpenLayers.Event.element(a);c.parentNode&&(!c.tagName||c.tagName.toUpperCase()!=b.toUpperCase());)c=c.parentNode;return c},observe:function(a,b,c,d){a=OpenLayers.Util.getElement(a);d=d||false;if(b=="keypress"&&(navigator.appVersion.match(/Konqueror|Safari|KHTML/)||a.attachEvent))b="keydown";if(!this.observers)this.observers={};if(!a._eventCacheID){var e="eventCacheID_";if(a.id)e=
a.id+"_"+e;a._eventCacheID=OpenLayers.Util.createUniqueID(e)}e=a._eventCacheID;this.observers[e]||(this.observers[e]=[]);this.observers[e].push({element:a,name:b,observer:c,useCapture:d});if(a.addEventListener)a.addEventListener(b,c,d);else a.attachEvent&&a.attachEvent("on"+b,c)},stopObservingElement:function(a){a=OpenLayers.Util.getElement(a)._eventCacheID;this._removeElementObservers(OpenLayers.Event.observers[a])},_removeElementObservers:function(a){if(a)for(var b=a.length-1;b>=0;b--){var c=a[b];
OpenLayers.Event.stopObserving.apply(this,[c.element,c.name,c.observer,c.useCapture])}},stopObserving:function(a,b,c,d){d=d||false;a=OpenLayers.Util.getElement(a);var e=a._eventCacheID;if(b=="keypress")if(navigator.appVersion.match(/Konqueror|Safari|KHTML/)||a.detachEvent)b="keydown";var f=false,g=OpenLayers.Event.observers[e];if(g)for(var h=0;!f&&h<g.length;){var j=g[h];if(j.name==b&&j.observer==c&&j.useCapture==d){g.splice(h,1);g.length==0&&delete OpenLayers.Event.observers[e];f=true;break}h++}if(f)if(a.removeEventListener)a.removeEventListener(b,
c,d);else a&&a.detachEvent&&a.detachEvent("on"+b,c);return f},unloadCache:function(){if(OpenLayers.Event&&OpenLayers.Event.observers){for(var a in OpenLayers.Event.observers)OpenLayers.Event._removeElementObservers.apply(this,[OpenLayers.Event.observers[a]]);OpenLayers.Event.observers=false}},CLASS_NAME:"OpenLayers.Event"};OpenLayers.Event.observe(window,"unload",OpenLayers.Event.unloadCache,false);if(window.Event)OpenLayers.Util.applyDefaults(window.Event,OpenLayers.Event);else var Event=OpenLayers.Event;
OpenLayers.Events=OpenLayers.Class({BROWSER_EVENTS:["mouseover","mouseout","mousedown","mouseup","mousemove","click","dblclick","rightclick","dblrightclick","resize","focus","blur","touchstart","touchmove","touchend"],listeners:null,object:null,element:null,eventTypes:null,eventHandler:null,fallThrough:null,includeXY:false,clearMouseListener:null,initialize:function(a,b,c,d,e){OpenLayers.Util.extend(this,e);this.object=a;this.fallThrough=d;this.listeners={};this.eventHandler=OpenLayers.Function.bindAsEventListener(this.handleBrowserEvent,
this);this.clearMouseListener=OpenLayers.Function.bind(this.clearMouseCache,this);this.eventTypes=[];if(c!=null){a=0;for(d=c.length;a<d;a++)this.addEventType(c[a])}b!=null&&this.attachToElement(b)},destroy:function(){if(this.element){OpenLayers.Event.stopObservingElement(this.element);this.element.hasScrollEvent&&OpenLayers.Event.stopObserving(window,"scroll",this.clearMouseListener)}this.eventHandler=this.fallThrough=this.eventTypes=this.object=this.listeners=this.element=null},addEventType:function(a){if(!this.listeners[a]){this.eventTypes.push(a);
this.listeners[a]=[]}},attachToElement:function(a){this.element&&OpenLayers.Event.stopObservingElement(this.element);this.element=a;for(var b=0,c=this.BROWSER_EVENTS.length;b<c;b++){var d=this.BROWSER_EVENTS[b];this.addEventType(d);OpenLayers.Event.observe(a,d,this.eventHandler)}OpenLayers.Event.observe(a,"dragstart",OpenLayers.Event.stop)},on:function(a){for(var b in a)b!="scope"&&this.register(b,a.scope,a[b])},register:function(a,b,c){if(c!=null&&OpenLayers.Util.indexOf(this.eventTypes,a)!=-1){if(b==
null)b=this.object;this.listeners[a].push({obj:b,func:c})}},registerPriority:function(a,b,c){if(c!=null){if(b==null)b=this.object;a=this.listeners[a];a!=null&&a.unshift({obj:b,func:c})}},un:function(a){for(var b in a)b!="scope"&&this.unregister(b,a.scope,a[b])},unregister:function(a,b,c){if(b==null)b=this.object;a=this.listeners[a];if(a!=null)for(var d=0,e=a.length;d<e;d++)if(a[d].obj==b&&a[d].func==c){a.splice(d,1);break}},remove:function(a){if(this.listeners[a]!=null)this.listeners[a]=[]},triggerEvent:function(a,
b){var c=this.listeners[a];if(!(!c||c.length==0)){if(b==null)b={};b.object=this.object;b.element=this.element;if(!b.type)b.type=a;c=c.slice();for(var d,e=0,f=c.length;e<f;e++){d=c[e];d=d.func.apply(d.obj,[b]);if(d!=undefined&&d==false)break}this.fallThrough||OpenLayers.Event.stop(b,true);return d}},handleBrowserEvent:function(a){var b=a.type,c=this.listeners[b];if(!(!c||c.length==0)){if((c=a.touches)&&c[0]){for(var d=0,e=0,f=c.length,g,h=0;h<f;++h){g=c[h];d+=g.clientX;e+=g.clientY}a.clientX=d/f;a.clientY=
e/f}if(this.includeXY)a.xy=this.getMousePosition(a);this.triggerEvent(b,a)}},clearMouseCache:function(){this.element.scrolls=null;this.element.lefttop=null;var a=document.body;if(a&&!((a.scrollTop!=0||a.scrollLeft!=0)&&navigator.userAgent.match(/iPhone/i)))this.element.offsets=null},getMousePosition:function(a){if(this.includeXY){if(!this.element.hasScrollEvent){OpenLayers.Event.observe(window,"scroll",this.clearMouseListener);this.element.hasScrollEvent=true}}else this.clearMouseCache();if(!this.element.scrolls){var b=
OpenLayers.Util.getViewportElement();this.element.scrolls=[b.scrollLeft,b.scrollTop]}if(!this.element.lefttop)this.element.lefttop=[document.documentElement.clientLeft||0,document.documentElement.clientTop||0];if(!this.element.offsets)this.element.offsets=OpenLayers.Util.pagePosition(this.element);return new OpenLayers.Pixel(a.clientX+this.element.scrolls[0]-this.element.offsets[0]-this.element.lefttop[0],a.clientY+this.element.scrolls[1]-this.element.offsets[1]-this.element.lefttop[1])},CLASS_NAME:"OpenLayers.Events"});
OpenLayers.Tween=OpenLayers.Class({INTERVAL:10,easing:null,begin:null,finish:null,duration:null,callbacks:null,time:null,interval:null,playing:false,initialize:function(a){this.easing=a?a:OpenLayers.Easing.Expo.easeOut},start:function(a,b,c,d){this.playing=true;this.begin=a;this.finish=b;this.duration=c;this.callbacks=d.callbacks;this.time=0;if(this.interval){window.clearInterval(this.interval);this.interval=null}this.callbacks&&this.callbacks.start&&this.callbacks.start.call(this,this.begin);this.interval=
window.setInterval(OpenLayers.Function.bind(this.play,this),this.INTERVAL)},stop:function(){if(this.playing){this.callbacks&&this.callbacks.done&&this.callbacks.done.call(this,this.finish);window.clearInterval(this.interval);this.interval=null;this.playing=false}},play:function(){var a={},b;for(b in this.begin){var c=this.begin[b],d=this.finish[b];if(c==null||d==null||isNaN(c)||isNaN(d))OpenLayers.Console.error("invalid value for Tween");a[b]=this.easing.apply(this,[this.time,c,d-c,this.duration])}this.time++;
this.callbacks&&this.callbacks.eachStep&&this.callbacks.eachStep.call(this,a);this.time>this.duration&&this.stop()},CLASS_NAME:"OpenLayers.Tween"});OpenLayers.Easing={CLASS_NAME:"OpenLayers.Easing"};OpenLayers.Easing.Linear={easeIn:function(a,b,c,d){return c*a/d+b},easeOut:function(a,b,c,d){return c*a/d+b},easeInOut:function(a,b,c,d){return c*a/d+b},CLASS_NAME:"OpenLayers.Easing.Linear"};
OpenLayers.Easing.Expo={easeIn:function(a,b,c,d){return a==0?b:c*Math.pow(2,10*(a/d-1))+b},easeOut:function(a,b,c,d){return a==d?b+c:c*(-Math.pow(2,-10*a/d)+1)+b},easeInOut:function(a,b,c,d){if(a==0)return b;if(a==d)return b+c;if((a/=d/2)<1)return c/2*Math.pow(2,10*(a-1))+b;return c/2*(-Math.pow(2,-10*--a)+2)+b},CLASS_NAME:"OpenLayers.Easing.Expo"};
OpenLayers.Easing.Quad={easeIn:function(a,b,c,d){return c*(a/=d)*a+b},easeOut:function(a,b,c,d){return-c*(a/=d)*(a-2)+b},easeInOut:function(a,b,c,d){if((a/=d/2)<1)return c/2*a*a+b;return-c/2*(--a*(a-2)-1)+b},CLASS_NAME:"OpenLayers.Easing.Quad"};
OpenLayers.Map=OpenLayers.Class({Z_INDEX_BASE:{BaseLayer:100,Overlay:325,Feature:725,Popup:750,Control:1E3},EVENT_TYPES:["preaddlayer","addlayer","preremovelayer","removelayer","changelayer","movestart","move","moveend","zoomend","popupopen","popupclose","addmarker","removemarker","clearmarkers","mouseover","mouseout","mousemove","dragstart","drag","dragend","changebaselayer"],id:null,fractionalZoom:false,events:null,allOverlays:false,div:null,dragging:false,size:null,viewPortDiv:null,layerContainerOrigin:null,
layerContainerDiv:null,layers:null,controls:null,popups:null,baseLayer:null,center:null,resolution:null,zoom:0,panRatio:1.5,viewRequestID:0,tileSize:null,projection:"EPSG:4326",units:"degrees",resolutions:null,maxResolution:1.40625,minResolution:null,maxScale:null,minScale:null,maxExtent:null,minExtent:null,restrictedExtent:null,numZoomLevels:16,theme:null,displayProjection:null,fallThrough:true,panTween:null,eventListeners:null,panMethod:OpenLayers.Easing.Expo.easeOut,panDuration:50,paddingForPopups:null,
minPx:null,maxPx:null,initialize:function(a,b){if(arguments.length===1&&typeof a==="object")a=(b=a)&&b.div;this.tileSize=new OpenLayers.Size(OpenLayers.Map.TILE_WIDTH,OpenLayers.Map.TILE_HEIGHT);this.maxExtent=new OpenLayers.Bounds(-180,-90,180,90);this.paddingForPopups=new OpenLayers.Bounds(15,15,15,15);this.theme=OpenLayers._getScriptLocation()+"theme/default/style.css";OpenLayers.Util.extend(this,b);this.layers=[];this.id=OpenLayers.Util.createUniqueID("OpenLayers.Map_");this.div=OpenLayers.Util.getElement(a);
if(!this.div){this.div=document.createElement("div");this.div.style.height="1px";this.div.style.width="1px"}OpenLayers.Element.addClass(this.div,"olMap");var c=this.id+"_OpenLayers_ViewPort";this.viewPortDiv=OpenLayers.Util.createDiv(c,null,null,null,"relative",null,"hidden");this.viewPortDiv.style.width="100%";this.viewPortDiv.style.height="100%";this.viewPortDiv.className="olMapViewport";this.div.appendChild(this.viewPortDiv);c=document.createElement("div");c.id=this.id+"_events";c.style.position=
"absolute";c.style.width="100%";c.style.height="100%";c.style.zIndex=this.Z_INDEX_BASE.Control-1;this.viewPortDiv.appendChild(c);this.eventsDiv=c;this.events=new OpenLayers.Events(this,this.eventsDiv,this.EVENT_TYPES,this.fallThrough,{includeXY:true});c=this.id+"_OpenLayers_Container";this.layerContainerDiv=OpenLayers.Util.createDiv(c);this.layerContainerDiv.style.zIndex=this.Z_INDEX_BASE.Popup-1;this.eventsDiv.appendChild(this.layerContainerDiv);this.updateSize();if(this.eventListeners instanceof
Object)this.events.on(this.eventListeners);this.events.register("movestart",this,this.updateSize);if(OpenLayers.String.contains(navigator.appName,"Microsoft"))this.events.register("resize",this,this.updateSize);else{this.updateSizeDestroy=OpenLayers.Function.bind(this.updateSize,this);OpenLayers.Event.observe(window,"resize",this.updateSizeDestroy)}if(this.theme){c=true;for(var d=document.getElementsByTagName("link"),e=0,f=d.length;e<f;++e)if(OpenLayers.Util.isEquivalentUrl(d.item(e).href,this.theme)){c=
false;break}if(c){c=document.createElement("link");c.setAttribute("rel","stylesheet");c.setAttribute("type","text/css");c.setAttribute("href",this.theme);document.getElementsByTagName("head")[0].appendChild(c)}}if(this.controls==null)this.controls=OpenLayers.Control!=null?[new OpenLayers.Control.Navigation,new OpenLayers.Control.PanZoom,new OpenLayers.Control.ArgParser,new OpenLayers.Control.Attribution]:[];e=0;for(f=this.controls.length;e<f;e++)this.addControlToMap(this.controls[e]);this.popups=
[];this.unloadDestroy=OpenLayers.Function.bind(this.destroy,this);OpenLayers.Event.observe(window,"unload",this.unloadDestroy);if(b&&b.layers){delete this.center;this.addLayers(b.layers);b.center&&this.setCenter(b.center,b.zoom)}},render:function(a){this.div=OpenLayers.Util.getElement(a);OpenLayers.Element.addClass(this.div,"olMap");this.viewPortDiv.parentNode.removeChild(this.viewPortDiv);this.div.appendChild(this.viewPortDiv);this.updateSize()},unloadDestroy:null,updateSizeDestroy:null,destroy:function(){if(!this.unloadDestroy)return false;
if(this.panTween){this.panTween.stop();this.panTween=null}OpenLayers.Event.stopObserving(window,"unload",this.unloadDestroy);this.unloadDestroy=null;this.updateSizeDestroy?OpenLayers.Event.stopObserving(window,"resize",this.updateSizeDestroy):this.events.unregister("resize",this,this.updateSize);this.paddingForPopups=null;if(this.controls!=null){for(var a=this.controls.length-1;a>=0;--a)this.controls[a].destroy();this.controls=null}if(this.layers!=null){for(a=this.layers.length-1;a>=0;--a)this.layers[a].destroy(false);
this.layers=null}this.viewPortDiv&&this.div.removeChild(this.viewPortDiv);this.viewPortDiv=null;if(this.eventListeners){this.events.un(this.eventListeners);this.eventListeners=null}this.events.destroy();this.events=null},setOptions:function(a){var b=this.minPx&&a.restrictedExtent!=this.restrictedExtent;OpenLayers.Util.extend(this,a);b&&this.moveTo(this.getCachedCenter(),this.zoom,{forceZoomChange:true})},getTileSize:function(){return this.tileSize},getBy:function(a,b,c){var d=typeof c.test=="function";
return OpenLayers.Array.filter(this[a],function(e){return e[b]==c||d&&c.test(e[b])})},getLayersBy:function(a,b){return this.getBy("layers",a,b)},getLayersByName:function(a){return this.getLayersBy("name",a)},getLayersByClass:function(a){return this.getLayersBy("CLASS_NAME",a)},getControlsBy:function(a,b){return this.getBy("controls",a,b)},getControlsByClass:function(a){return this.getControlsBy("CLASS_NAME",a)},getLayer:function(a){for(var b=null,c=0,d=this.layers.length;c<d;c++){var e=this.layers[c];
if(e.id==a){b=e;break}}return b},setLayerZIndex:function(a,b){a.setZIndex(this.Z_INDEX_BASE[a.isBaseLayer?"BaseLayer":"Overlay"]+b*5)},resetLayersZIndex:function(){for(var a=0,b=this.layers.length;a<b;a++)this.setLayerZIndex(this.layers[a],a)},addLayer:function(a){for(var b=0,c=this.layers.length;b<c;b++)if(this.layers[b]==a){a=OpenLayers.i18n("layerAlreadyAdded",{layerName:a.name});OpenLayers.Console.warn(a);return false}if(this.events.triggerEvent("preaddlayer",{layer:a})!==false){if(this.allOverlays)a.isBaseLayer=
false;a.div.className="olLayerDiv";a.div.style.overflow="";this.setLayerZIndex(a,this.layers.length);a.isFixed?this.viewPortDiv.appendChild(a.div):this.layerContainerDiv.appendChild(a.div);this.layers.push(a);a.setMap(this);if(a.isBaseLayer||this.allOverlays&&!this.baseLayer)this.baseLayer==null?this.setBaseLayer(a):a.setVisibility(false);else a.redraw();this.events.triggerEvent("addlayer",{layer:a});a.events.triggerEvent("added",{map:this,layer:a});a.afterAdd()}},addLayers:function(a){for(var b=
0,c=a.length;b<c;b++)this.addLayer(a[b])},removeLayer:function(a,b){if(this.events.triggerEvent("preremovelayer",{layer:a})!==false){if(b==null)b=true;a.isFixed?this.viewPortDiv.removeChild(a.div):this.layerContainerDiv.removeChild(a.div);OpenLayers.Util.removeItem(this.layers,a);a.removeMap(this);a.map=null;if(this.baseLayer==a){this.baseLayer=null;if(b)for(var c=0,d=this.layers.length;c<d;c++){var e=this.layers[c];if(e.isBaseLayer||this.allOverlays){this.setBaseLayer(e);break}}}this.resetLayersZIndex();
this.events.triggerEvent("removelayer",{layer:a});a.events.triggerEvent("removed",{map:this,layer:a})}},getNumLayers:function(){return this.layers.length},getLayerIndex:function(a){return OpenLayers.Util.indexOf(this.layers,a)},setLayerIndex:function(a,b){var c=this.getLayerIndex(a);if(b<0)b=0;else if(b>this.layers.length)b=this.layers.length;if(c!=b){this.layers.splice(c,1);this.layers.splice(b,0,a);c=0;for(var d=this.layers.length;c<d;c++)this.setLayerZIndex(this.layers[c],c);this.events.triggerEvent("changelayer",
{layer:a,property:"order"});if(this.allOverlays)if(b===0)this.setBaseLayer(a);else this.baseLayer!==this.layers[0]&&this.setBaseLayer(this.layers[0])}},raiseLayer:function(a,b){var c=this.getLayerIndex(a)+b;this.setLayerIndex(a,c)},setBaseLayer:function(a){if(a!=this.baseLayer)if(OpenLayers.Util.indexOf(this.layers,a)!=-1){var b=this.getCachedCenter(),c=OpenLayers.Util.getResolutionFromScale(this.getScale(),a.units);this.baseLayer!=null&&!this.allOverlays&&this.baseLayer.setVisibility(false);this.baseLayer=
a;this.viewRequestID++;if(!this.allOverlays||this.baseLayer.visibility)this.baseLayer.setVisibility(true);if(b!=null){a=this.getZoomForResolution(c||this.resolution,true);this.setCenter(b,a,false,true)}this.events.triggerEvent("changebaselayer",{layer:this.baseLayer})}},addControl:function(a,b){this.controls.push(a);this.addControlToMap(a,b)},addControls:function(a,b){for(var c=arguments.length===1?[]:b,d=0,e=a.length;d<e;d++)this.addControl(a[d],c[d]?c[d]:null)},addControlToMap:function(a,b){a.outsideViewport=
a.div!=null;if(this.displayProjection&&!a.displayProjection)a.displayProjection=this.displayProjection;a.setMap(this);var c=a.draw(b);if(c)if(!a.outsideViewport){c.style.zIndex=this.Z_INDEX_BASE.Control+this.controls.length;this.viewPortDiv.appendChild(c)}a.autoActivate&&a.activate()},getControl:function(a){for(var b=null,c=0,d=this.controls.length;c<d;c++){var e=this.controls[c];if(e.id==a){b=e;break}}return b},removeControl:function(a){if(a&&a==this.getControl(a.id)){a.div&&a.div.parentNode==this.viewPortDiv&&
this.viewPortDiv.removeChild(a.div);OpenLayers.Util.removeItem(this.controls,a)}},addPopup:function(a,b){if(b)for(var c=this.popups.length-1;c>=0;--c)this.removePopup(this.popups[c]);a.map=this;this.popups.push(a);if(c=a.draw()){c.style.zIndex=this.Z_INDEX_BASE.Popup+this.popups.length;this.layerContainerDiv.appendChild(c)}},removePopup:function(a){OpenLayers.Util.removeItem(this.popups,a);if(a.div)try{this.layerContainerDiv.removeChild(a.div)}catch(b){}a.map=null},getSize:function(){var a=null;if(this.size!=
null)a=this.size.clone();return a},updateSize:function(){var a=this.getCurrentSize();if(a&&!isNaN(a.h)&&!isNaN(a.w)){this.events.clearMouseCache();var b=this.getSize();if(b==null)this.size=b=a;if(!a.equals(b)){this.size=a;a=0;for(b=this.layers.length;a<b;a++)this.layers[a].onMapResize();a=this.getCachedCenter();if(this.baseLayer!=null&&a!=null){b=this.getZoom();this.zoom=null;this.setCenter(a,b)}}}},getCurrentSize:function(){var a=new OpenLayers.Size(this.div.clientWidth,this.div.clientHeight);if(a.w==
0&&a.h==0||isNaN(a.w)&&isNaN(a.h)){a.w=this.div.offsetWidth;a.h=this.div.offsetHeight}if(a.w==0&&a.h==0||isNaN(a.w)&&isNaN(a.h)){a.w=parseInt(this.div.style.width);a.h=parseInt(this.div.style.height)}return a},calculateBounds:function(a,b){var c=null;if(a==null)a=this.getCachedCenter();if(b==null)b=this.getResolution();if(a!=null&&b!=null){var d=this.getSize();c=d.w*b;d=d.h*b;c=new OpenLayers.Bounds(a.lon-c/2,a.lat-d/2,a.lon+c/2,a.lat+d/2)}return c},getCenter:function(){var a=null,b=this.getCachedCenter();
if(b)a=b.clone();return a},getCachedCenter:function(){if(!this.center&&this.size)this.center=this.getLonLatFromViewPortPx(new OpenLayers.Pixel(this.size.w/2,this.size.h/2));return this.center},getZoom:function(){return this.zoom},pan:function(a,b,c){c=OpenLayers.Util.applyDefaults(c,{animate:true,dragging:false});if(c.dragging){if(a!=0||b!=0)this.moveByPx(a,b)}else{var d=this.getViewPortPxFromLonLat(this.getCachedCenter());a=d.add(a,b);if(this.dragging||!a.equals(d)){d=this.getLonLatFromViewPortPx(a);
if(c.animate)this.panTo(d);else{this.moveTo(d);this.dragging=false;this.events.triggerEvent("moveend")}}}},panTo:function(a){if(this.panMethod&&this.getExtent().scale(this.panRatio).containsLonLat(a)){if(!this.panTween)this.panTween=new OpenLayers.Tween(this.panMethod);var b=this.getCachedCenter();if(!a.equals(b)){b=this.getPixelFromLonLat(b);var c=this.getPixelFromLonLat(a),d={x:0,y:0};this.panTween.start({x:0,y:0},{x:c.x-b.x,y:c.y-b.y},this.panDuration,{callbacks:{eachStep:OpenLayers.Function.bind(function(e){this.moveByPx(e.x-
d.x,e.y-d.y);d.x=Math.round(e.x);d.y=Math.round(e.y)},this),done:OpenLayers.Function.bind(function(){this.moveTo(a);this.dragging=false;this.events.triggerEvent("moveend")},this)}})}}else this.setCenter(a)},setCenter:function(a,b,c,d){this.panTween&&this.panTween.stop();this.moveTo(a,b,{dragging:c,forceZoomChange:d})},moveByPx:function(a,b){var c=this.size.w/2,d=this.size.h/2,e=c+a,f=d+b,g=this.baseLayer.wrapDateLine,h=0,j=0;if(this.restrictedExtent){h=c;j=d;g=false}a=g||e<=this.maxPx.x-h&&e>=this.minPx.x+
h?Math.round(a):0;b=f<=this.maxPx.y-j&&f>=this.minPx.y+j?Math.round(b):0;c=this.minPx.x;d=this.maxPx.x;if(a||b){if(!this.dragging){this.dragging=true;this.events.triggerEvent("movestart")}this.center=null;if(a){this.layerContainerDiv.style.left=parseInt(this.layerContainerDiv.style.left)-a+"px";this.minPx.x-=a;this.maxPx.x-=a;if(g){if(this.maxPx.x>d)this.maxPx.x-=d-c;if(this.minPx.x<c)this.minPx.x+=d-c}}if(b){this.layerContainerDiv.style.top=parseInt(this.layerContainerDiv.style.top)-b+"px";this.minPx.y-=
b;this.maxPx.y-=b}c=0;for(d=this.layers.length;c<d;++c){g=this.layers[c];if(g.visibility&&(g===this.baseLayer||g.inRange)){g.moveByPx(a,b);g.events.triggerEvent("move")}}this.events.triggerEvent("move")}},moveTo:function(a,b,c){c||(c={});if(b!=null){b=parseFloat(b);this.fractionalZoom||(b=Math.round(b))}var d=c.dragging||this.dragging,e=c.forceZoomChange;if(!this.getCachedCenter()&&!this.isValidLonLat(a)){a=this.maxExtent.getCenterLonLat();this.center=a.clone()}if(this.restrictedExtent!=null){if(a==
null)a=this.center;if(b==null)b=this.getZoom();var f=this.getResolutionForZoom(b);f=this.calculateBounds(a,f);if(!this.restrictedExtent.containsBounds(f)){var g=this.restrictedExtent.getCenterLonLat();if(f.getWidth()>this.restrictedExtent.getWidth())a=new OpenLayers.LonLat(g.lon,a.lat);else if(f.left<this.restrictedExtent.left)a=a.add(this.restrictedExtent.left-f.left,0);else if(f.right>this.restrictedExtent.right)a=a.add(this.restrictedExtent.right-f.right,0);if(f.getHeight()>this.restrictedExtent.getHeight())a=
new OpenLayers.LonLat(a.lon,g.lat);else if(f.bottom<this.restrictedExtent.bottom)a=a.add(0,this.restrictedExtent.bottom-f.bottom);else if(f.top>this.restrictedExtent.top)a=a.add(0,this.restrictedExtent.top-f.top)}}e=e||this.isValidZoomLevel(b)&&b!=this.getZoom();f=this.isValidLonLat(a)&&!a.equals(this.center);if(e||f||d){d||this.events.triggerEvent("movestart");if(f){!e&&this.center&&this.centerLayerContainer(a);this.center=a.clone()}a=e?this.getResolutionForZoom(b):this.getResolution();if(e||this.layerContainerOrigin==
null){this.layerContainerOrigin=this.getCachedCenter();this.layerContainerDiv.style.left="0px";this.layerContainerDiv.style.top="0px";var h=this.getMaxExtent({restricted:true});f=h.getCenterLonLat();g=this.center.lon-f.lon;var j=f.lat-this.center.lat;f=Math.round(h.getWidth()/a);h=Math.round(h.getHeight()/a);g=(this.size.w-f)/2-g/a;j=(this.size.h-h)/2-j/a;this.minPx=new OpenLayers.Pixel(g,j);this.maxPx=new OpenLayers.Pixel(g+f,j+h)}if(e){this.zoom=b;this.resolution=a;this.viewRequestID++}a=this.getExtent();
if(this.baseLayer.visibility){this.baseLayer.moveTo(a,e,c.dragging);c.dragging||this.baseLayer.events.triggerEvent("moveend",{zoomChanged:e})}a=this.baseLayer.getExtent();for(b=this.layers.length-1;b>=0;--b){f=this.layers[b];if(f!==this.baseLayer&&!f.isBaseLayer){g=f.calculateInRange();if(f.inRange!=g){(f.inRange=g)||f.display(false);this.events.triggerEvent("changelayer",{layer:f,property:"visibility"})}if(g&&f.visibility){f.moveTo(a,e,c.dragging);c.dragging||f.events.triggerEvent("moveend",{zoomChanged:e})}}}this.events.triggerEvent("move");
d||this.events.triggerEvent("moveend");if(e){b=0;for(c=this.popups.length;b<c;b++)this.popups[b].updatePosition();this.events.triggerEvent("zoomend")}}},centerLayerContainer:function(a){var b=this.getViewPortPxFromLonLat(this.layerContainerOrigin),c=this.getViewPortPxFromLonLat(a);if(b!=null&&c!=null){var d=parseInt(this.layerContainerDiv.style.left);a=parseInt(this.layerContainerDiv.style.top);var e=Math.round(b.x-c.x);b=Math.round(b.y-c.y);this.layerContainerDiv.style.left=e+"px";this.layerContainerDiv.style.top=
b+"px";d-=e;a-=b;this.minPx.x-=d;this.maxPx.x-=d;this.minPx.y-=a;this.maxPx.y-=a}},isValidZoomLevel:function(a){return a!=null&&a>=0&&a<this.getNumZoomLevels()},isValidLonLat:function(a){var b=false;if(a!=null)b=this.getMaxExtent().containsLonLat(a);return b},getProjection:function(){var a=this.getProjectionObject();return a?a.getCode():null},getProjectionObject:function(){var a=null;if(this.baseLayer!=null)a=this.baseLayer.projection;return a},getMaxResolution:function(){var a=null;if(this.baseLayer!=
null)a=this.baseLayer.maxResolution;return a},getMaxExtent:function(a){var b=null;if(a&&a.restricted&&this.restrictedExtent)b=this.restrictedExtent;else if(this.baseLayer!=null)b=this.baseLayer.maxExtent;return b},getNumZoomLevels:function(){var a=null;if(this.baseLayer!=null)a=this.baseLayer.numZoomLevels;return a},getExtent:function(){var a=null;if(this.baseLayer!=null)a=this.baseLayer.getExtent();return a},getResolution:function(){var a=null;if(this.baseLayer!=null)a=this.baseLayer.getResolution();
else if(this.allOverlays===true&&this.layers.length>0)a=this.layers[0].getResolution();return a},getUnits:function(){var a=null;if(this.baseLayer!=null)a=this.baseLayer.units;return a},getScale:function(){var a=null;if(this.baseLayer!=null){a=this.getResolution();a=OpenLayers.Util.getScaleFromResolution(a,this.baseLayer.units)}return a},getZoomForExtent:function(a,b){var c=null;if(this.baseLayer!=null)c=this.baseLayer.getZoomForExtent(a,b);return c},getResolutionForZoom:function(a){var b=null;if(this.baseLayer)b=
this.baseLayer.getResolutionForZoom(a);return b},getZoomForResolution:function(a,b){var c=null;if(this.baseLayer!=null)c=this.baseLayer.getZoomForResolution(a,b);return c},zoomTo:function(a){this.isValidZoomLevel(a)&&this.setCenter(null,a)},zoomIn:function(){this.zoomTo(this.getZoom()+1)},zoomOut:function(){this.zoomTo(this.getZoom()-1)},zoomToExtent:function(a,b){var c=a.getCenterLonLat();if(this.baseLayer.wrapDateLine){c=this.getMaxExtent();for(a=a.clone();a.right<a.left;)a.right+=c.getWidth();
c=a.getCenterLonLat().wrapDateLine(c)}this.setCenter(c,this.getZoomForExtent(a,b))},zoomToMaxExtent:function(a){this.zoomToExtent(this.getMaxExtent({restricted:a?a.restricted:true}))},zoomToScale:function(a,b){var c=OpenLayers.Util.getResolutionFromScale(a,this.baseLayer.units),d=this.getSize(),e=d.w*c;c*=d.h;d=this.getCachedCenter();this.zoomToExtent(new OpenLayers.Bounds(d.lon-e/2,d.lat-c/2,d.lon+e/2,d.lat+c/2),b)},getLonLatFromViewPortPx:function(a){var b=null;if(this.baseLayer!=null)b=this.baseLayer.getLonLatFromViewPortPx(a);
return b},getViewPortPxFromLonLat:function(a){var b=null;if(this.baseLayer!=null)b=this.baseLayer.getViewPortPxFromLonLat(a);return b},getLonLatFromPixel:function(a){return this.getLonLatFromViewPortPx(a)},getPixelFromLonLat:function(a){a=this.getViewPortPxFromLonLat(a);a.x=Math.round(a.x);a.y=Math.round(a.y);return a},getGeodesicPixelSize:function(a){var b=a?this.getLonLatFromPixel(a):this.getCachedCenter()||new OpenLayers.LonLat(0,0),c=this.getResolution();a=b.add(-c/2,0);var d=b.add(c/2,0),e=b.add(0,
-c/2);b=b.add(0,c/2);c=new OpenLayers.Projection("EPSG:4326");var f=this.getProjectionObject()||c;if(!f.equals(c)){a.transform(f,c);d.transform(f,c);e.transform(f,c);b.transform(f,c)}return new OpenLayers.Size(OpenLayers.Util.distVincenty(a,d),OpenLayers.Util.distVincenty(e,b))},getViewPortPxFromLayerPx:function(a){var b=null;if(a!=null){b=parseInt(this.layerContainerDiv.style.left);var c=parseInt(this.layerContainerDiv.style.top);b=a.add(b,c)}return b},getLayerPxFromViewPortPx:function(a){var b=
null;if(a!=null){b=-parseInt(this.layerContainerDiv.style.left);var c=-parseInt(this.layerContainerDiv.style.top);b=a.add(b,c);if(isNaN(b.x)||isNaN(b.y))b=null}return b},getLonLatFromLayerPx:function(a){a=this.getViewPortPxFromLayerPx(a);return this.getLonLatFromViewPortPx(a)},getLayerPxFromLonLat:function(a){return this.getLayerPxFromViewPortPx(this.getPixelFromLonLat(a))},CLASS_NAME:"OpenLayers.Map"});OpenLayers.Map.TILE_WIDTH=256;OpenLayers.Map.TILE_HEIGHT=256;
OpenLayers.Projection=OpenLayers.Class({proj:null,projCode:null,titleRegEx:/\+title=[^\+]*/,initialize:function(a,b){OpenLayers.Util.extend(this,b);this.projCode=a;if(window.Proj4js)this.proj=new Proj4js.Proj(a)},getCode:function(){return this.proj?this.proj.srsCode:this.projCode},getUnits:function(){return this.proj?this.proj.units:null},toString:function(){return this.getCode()},equals:function(a){var b=false;if(a)if(window.Proj4js&&this.proj.defData&&a.proj.defData)b=this.proj.defData.replace(this.titleRegEx,
"")==a.proj.defData.replace(this.titleRegEx,"");else if(a.getCode){b=this.getCode();a=a.getCode();b=b==a||!!OpenLayers.Projection.transforms[b]&&OpenLayers.Projection.transforms[b][a]===OpenLayers.Projection.nullTransform}return b},destroy:function(){delete this.proj;delete this.projCode},CLASS_NAME:"OpenLayers.Projection"});OpenLayers.Projection.transforms={};
OpenLayers.Projection.addTransform=function(a,b,c){OpenLayers.Projection.transforms[a]||(OpenLayers.Projection.transforms[a]={});OpenLayers.Projection.transforms[a][b]=c};OpenLayers.Projection.transform=function(a,b,c){if(b.proj&&c.proj)a=Proj4js.transform(b.proj,c.proj,a);else if(b&&c&&OpenLayers.Projection.transforms[b.getCode()]&&OpenLayers.Projection.transforms[b.getCode()][c.getCode()])OpenLayers.Projection.transforms[b.getCode()][c.getCode()](a);return a};
OpenLayers.Projection.nullTransform=function(a){return a};
OpenLayers.Layer=OpenLayers.Class({id:null,name:null,div:null,opacity:1,alwaysInRange:null,EVENT_TYPES:["loadstart","loadend","loadcancel","visibilitychanged","move","moveend","added","removed"],RESOLUTION_PROPERTIES:["scales","resolutions","maxScale","minScale","maxResolution","minResolution","numZoomLevels","maxZoomLevel"],events:null,map:null,isBaseLayer:false,alpha:false,displayInLayerSwitcher:true,visibility:true,attribution:null,inRange:false,imageSize:null,imageOffset:null,options:null,eventListeners:null,
gutter:0,projection:null,units:null,scales:null,resolutions:null,maxExtent:null,minExtent:null,maxResolution:null,minResolution:null,numZoomLevels:null,minScale:null,maxScale:null,displayOutsideMaxExtent:false,wrapDateLine:false,transitionEffect:null,SUPPORTED_TRANSITIONS:["resize"],metadata:{},initialize:function(a,b){this.addOptions(b);this.name=a;if(this.id==null){this.id=OpenLayers.Util.createUniqueID(this.CLASS_NAME+"_");this.div=OpenLayers.Util.createDiv(this.id);this.div.style.width="100%";
this.div.style.height="100%";this.div.dir="ltr";this.events=new OpenLayers.Events(this,this.div,this.EVENT_TYPES);if(this.eventListeners instanceof Object)this.events.on(this.eventListeners)}if(this.wrapDateLine)this.displayOutsideMaxExtent=true},destroy:function(a){if(a==null)a=true;this.map!=null&&this.map.removeLayer(this,a);this.options=this.div=this.name=this.map=this.projection=null;if(this.events){this.eventListeners&&this.events.un(this.eventListeners);this.events.destroy()}this.events=this.eventListeners=
null},clone:function(a){if(a==null)a=new OpenLayers.Layer(this.name,this.getOptions());OpenLayers.Util.applyDefaults(a,this);a.map=null;return a},getOptions:function(){var a={},b;for(b in this.options)a[b]=this[b];return a},setName:function(a){if(a!=this.name){this.name=a;this.map!=null&&this.map.events.triggerEvent("changelayer",{layer:this,property:"name"})}},addOptions:function(a,b){if(this.options==null)this.options={};OpenLayers.Util.extend(this.options,a);OpenLayers.Util.extend(this,a);if(typeof this.projection==
"string")this.projection=new OpenLayers.Projection(this.projection);if(this.projection&&this.projection.getUnits())this.units=this.projection.getUnits();if(this.map){var c=this.map.getResolution(),d=this.RESOLUTION_PROPERTIES.concat(["projection","units","minExtent","maxExtent"]),e;for(e in a)if(a.hasOwnProperty(e)&&OpenLayers.Util.indexOf(d,e)>=0){this.initResolutions();if(b&&this.map.baseLayer===this){this.map.setCenter(this.map.getCenter(),this.map.getZoomForResolution(c),false,true);this.map.events.triggerEvent("changebaselayer",
{layer:this})}break}}},onMapResize:function(){},redraw:function(){var a=false;if(this.map){this.inRange=this.calculateInRange();var b=this.getExtent();if(b&&this.inRange&&this.visibility){this.moveTo(b,true,false);this.events.triggerEvent("moveend",{zoomChanged:true});a=true}}return a},moveTo:function(){var a=this.visibility;this.isBaseLayer||(a=a&&this.inRange);this.display(a)},moveByPx:function(){},setMap:function(a){if(this.map==null){this.map=a;this.maxExtent=this.maxExtent||this.map.maxExtent;
this.minExtent=this.minExtent||this.map.minExtent;this.projection=this.projection||this.map.projection;if(typeof this.projection=="string")this.projection=new OpenLayers.Projection(this.projection);this.units=this.projection.getUnits()||this.units||this.map.units;this.initResolutions();if(!this.isBaseLayer){this.inRange=this.calculateInRange();this.div.style.display=this.visibility&&this.inRange?"":"none"}this.setTileSize()}},afterAdd:function(){},removeMap:function(){},getImageSize:function(){return this.imageSize||
this.tileSize},setTileSize:function(a){this.tileSize=a=a?a:this.tileSize?this.tileSize:this.map.getTileSize();if(this.gutter){this.imageOffset=new OpenLayers.Pixel(-this.gutter,-this.gutter);this.imageSize=new OpenLayers.Size(a.w+2*this.gutter,a.h+2*this.gutter)}},getVisibility:function(){return this.visibility},setVisibility:function(a){if(a!=this.visibility){this.visibility=a;this.display(a);this.redraw();this.map!=null&&this.map.events.triggerEvent("changelayer",{layer:this,property:"visibility"});
this.events.triggerEvent("visibilitychanged")}},display:function(a){if(a!=(this.div.style.display!="none"))this.div.style.display=a&&this.calculateInRange()?"block":"none"},calculateInRange:function(){var a=false;if(this.alwaysInRange)a=true;else if(this.map){a=this.map.getResolution();a=a>=this.minResolution&&a<=this.maxResolution}return a},setIsBaseLayer:function(a){if(a!=this.isBaseLayer){this.isBaseLayer=a;this.map!=null&&this.map.events.triggerEvent("changebaselayer",{layer:this})}},initResolutions:function(){var a,
b,c,d={},e=true;a=0;for(b=this.RESOLUTION_PROPERTIES.length;a<b;a++){c=this.RESOLUTION_PROPERTIES[a];d[c]=this.options[c];if(e&&this.options[c])e=false}if(this.alwaysInRange==null)this.alwaysInRange=e;if(d.resolutions==null)d.resolutions=this.resolutionsFromScales(d.scales);if(d.resolutions==null)d.resolutions=this.calculateResolutions(d);if(d.resolutions==null){a=0;for(b=this.RESOLUTION_PROPERTIES.length;a<b;a++){c=this.RESOLUTION_PROPERTIES[a];d[c]=this.options[c]!=null?this.options[c]:this.map[c]}if(d.resolutions==
null)d.resolutions=this.resolutionsFromScales(d.scales);if(d.resolutions==null)d.resolutions=this.calculateResolutions(d)}var f;if(this.options.maxResolution&&this.options.maxResolution!=="auto")f=this.options.maxResolution;if(this.options.minScale)f=OpenLayers.Util.getResolutionFromScale(this.options.minScale,this.units);var g;if(this.options.minResolution&&this.options.minResolution!=="auto")g=this.options.minResolution;if(this.options.maxScale)g=OpenLayers.Util.getResolutionFromScale(this.options.maxScale,
this.units);if(d.resolutions){d.resolutions.sort(function(h,j){return j-h});f||(f=d.resolutions[0]);g||(g=d.resolutions[d.resolutions.length-1])}if(this.resolutions=d.resolutions){b=this.resolutions.length;this.scales=Array(b);for(a=0;a<b;a++)this.scales[a]=OpenLayers.Util.getScaleFromResolution(this.resolutions[a],this.units);this.numZoomLevels=b}if(this.minResolution=g)this.maxScale=OpenLayers.Util.getScaleFromResolution(g,this.units);if(this.maxResolution=f)this.minScale=OpenLayers.Util.getScaleFromResolution(f,
this.units)},resolutionsFromScales:function(a){if(a!=null){var b,c,d;d=a.length;b=Array(d);for(c=0;c<d;c++)b[c]=OpenLayers.Util.getResolutionFromScale(a[c],this.units);return b}},calculateResolutions:function(a){var b,c,d=a.maxResolution;if(a.minScale!=null)d=OpenLayers.Util.getResolutionFromScale(a.minScale,this.units);else if(d=="auto"&&this.maxExtent!=null){b=this.map.getSize();c=this.maxExtent.getWidth()/b.w;b=this.maxExtent.getHeight()/b.h;d=Math.max(c,b)}c=a.minResolution;if(a.maxScale!=null)c=
OpenLayers.Util.getResolutionFromScale(a.maxScale,this.units);else if(a.minResolution=="auto"&&this.minExtent!=null){b=this.map.getSize();c=this.minExtent.getWidth()/b.w;b=this.minExtent.getHeight()/b.h;c=Math.max(c,b)}b=a.maxZoomLevel;a=a.numZoomLevels;if(typeof c==="number"&&typeof d==="number"&&a===undefined)a=Math.floor(Math.log(d/c)/Math.log(2))+1;else if(a===undefined&&b!=null)a=b+1;if(!(typeof a!=="number"||a<=0||typeof d!=="number"&&typeof c!=="number")){b=Array(a);var e=2;if(typeof c=="number"&&
typeof d=="number")e=Math.pow(d/c,1/(a-1));var f;if(typeof d==="number")for(f=0;f<a;f++)b[f]=d/Math.pow(e,f);else for(f=0;f<a;f++)b[a-1-f]=c*Math.pow(e,f);return b}},getResolution:function(){return this.getResolutionForZoom(this.map.getZoom())},getExtent:function(){return this.map.calculateBounds()},getZoomForExtent:function(a,b){var c=this.map.getSize();return this.getZoomForResolution(Math.max(a.getWidth()/c.w,a.getHeight()/c.h),b)},getDataExtent:function(){},getResolutionForZoom:function(a){a=
Math.max(0,Math.min(a,this.resolutions.length-1));if(this.map.fractionalZoom){var b=Math.floor(a);a=this.resolutions[b]-(a-b)*(this.resolutions[b]-this.resolutions[Math.ceil(a)])}else a=this.resolutions[Math.round(a)];return a},getZoomForResolution:function(a,b){var c,d;if(this.map.fractionalZoom){var e=0,f=this.resolutions[e],g=this.resolutions[this.resolutions.length-1],h;c=0;for(d=this.resolutions.length;c<d;++c){h=this.resolutions[c];if(h>=a){f=h;e=c}if(h<=a){g=h;break}}c=f-g;c=c>0?e+(f-a)/c:
e}else{f=Number.POSITIVE_INFINITY;c=0;for(d=this.resolutions.length;c<d;c++)if(b){e=Math.abs(this.resolutions[c]-a);if(e>f)break;f=e}else if(this.resolutions[c]<a)break;c=Math.max(0,c-1)}return c},getLonLatFromViewPortPx:function(a){var b=null,c=this.map;if(a!=null&&c.minPx){b=c.getResolution();var d=c.getMaxExtent({restricted:true});b=new OpenLayers.LonLat((a.x-c.minPx.x)*b+d.left,(c.minPx.y-a.y)*b+d.top);if(this.wrapDateLine)b=b.wrapDateLine(this.maxExtent)}return b},getViewPortPxFromLonLat:function(a){var b=
null;if(a!=null){b=this.map.getResolution();var c=this.map.getExtent();b=new OpenLayers.Pixel(1/b*(a.lon-c.left),1/b*(c.top-a.lat))}return b},setOpacity:function(a){if(a!=this.opacity){this.opacity=a;for(var b=0,c=this.div.childNodes.length;b<c;++b)OpenLayers.Util.modifyDOMElement(this.div.childNodes[b].firstChild,null,null,null,null,null,null,a);this.map!=null&&this.map.events.triggerEvent("changelayer",{layer:this,property:"opacity"})}},getZIndex:function(){return this.div.style.zIndex},setZIndex:function(a){this.div.style.zIndex=
a},adjustBounds:function(a){if(this.gutter){var b=this.gutter*this.map.getResolution();a=new OpenLayers.Bounds(a.left-b,a.bottom-b,a.right+b,a.top+b)}if(this.wrapDateLine){b={rightTolerance:this.getResolution(),leftTolerance:this.getResolution()};a=a.wrapDateLine(this.maxExtent,b)}return a},CLASS_NAME:"OpenLayers.Layer"});
OpenLayers.Layer.SphericalMercator={getExtent:function(){var a=null;return a=this.sphericalMercator?this.map.calculateBounds():OpenLayers.Layer.FixedZoomLevels.prototype.getExtent.apply(this)},getLonLatFromViewPortPx:function(){return OpenLayers.Layer.prototype.getLonLatFromViewPortPx.apply(this,arguments)},getViewPortPxFromLonLat:function(){return OpenLayers.Layer.prototype.getViewPortPxFromLonLat.apply(this,arguments)},initMercatorParameters:function(){this.RESOLUTIONS=[];for(var a=0;a<=this.MAX_ZOOM_LEVEL;++a)this.RESOLUTIONS[a]=
156543.03390625/Math.pow(2,a);this.units="m";this.projection=this.projection||"EPSG:900913"},forwardMercator:function(a,b){var c;c=Math.log(Math.tan((90+b)*Math.PI/360))/(Math.PI/180);return new OpenLayers.LonLat(a*2.003750834E7/180,c*2.003750834E7/180)},inverseMercator:function(a,b){var c;c=180/Math.PI*(2*Math.atan(Math.exp(b/2.003750834E7*180*Math.PI/180))-Math.PI/2);return new OpenLayers.LonLat(a/2.003750834E7*180,c)},projectForward:function(a){var b=OpenLayers.Layer.SphericalMercator.forwardMercator(a.x,
a.y);a.x=b.lon;a.y=b.lat;return a},projectInverse:function(a){var b=OpenLayers.Layer.SphericalMercator.inverseMercator(a.x,a.y);a.x=b.lon;a.y=b.lat;return a}};(function(){var a=["EPSG:900913","EPSG:3857","EPSG:102113","EPSG:102100"],b=OpenLayers.Projection.addTransform,c=OpenLayers.Layer.SphericalMercator,d=OpenLayers.Projection.nullTransform,e,f,g,h,j;e=0;for(f=a.length;e<f;++e){g=a[e];b("EPSG:4326",g,c.projectForward);b(g,"EPSG:4326",c.projectInverse);for(j=e+1;j<f;++j){h=a[j];b(g,h,d);b(h,g,d)}}})();
OpenLayers.Layer.EventPane=OpenLayers.Class(OpenLayers.Layer,{smoothDragPan:true,isBaseLayer:true,isFixed:true,pane:null,mapObject:null,initialize:function(){OpenLayers.Layer.prototype.initialize.apply(this,arguments);if(this.pane==null)this.pane=OpenLayers.Util.createDiv(this.div.id+"_EventPane")},destroy:function(){this.pane=this.mapObject=null;OpenLayers.Layer.prototype.destroy.apply(this,arguments)},setMap:function(){OpenLayers.Layer.prototype.setMap.apply(this,arguments);this.pane.style.zIndex=
parseInt(this.div.style.zIndex)+1;this.pane.style.display=this.div.style.display;this.pane.style.width="100%";this.pane.style.height="100%";if(OpenLayers.BROWSER_NAME=="msie")this.pane.style.background="url("+OpenLayers.Util.getImagesLocation()+"blank.gif)";this.isFixed?this.map.eventsDiv.appendChild(this.pane):this.map.layerContainerDiv.appendChild(this.pane);this.loadMapObject();this.mapObject==null&&this.loadWarningMessage()},removeMap:function(){this.pane&&this.pane.parentNode&&this.pane.parentNode.removeChild(this.pane);
OpenLayers.Layer.prototype.removeMap.apply(this,arguments)},loadWarningMessage:function(){this.div.style.backgroundColor="darkblue";var a=this.map.getSize(),b=new OpenLayers.Size(Math.min(a.w,300),Math.min(a.h,200));a=(new OpenLayers.Pixel(a.w/2,a.h/2)).add(-b.w/2,-b.h/2);b=OpenLayers.Util.createDiv(this.name+"_warning",a,b,null,null,null,"auto");b.style.padding="7px";b.style.backgroundColor="yellow";b.innerHTML=this.getWarningHTML();this.div.appendChild(b)},getWarningHTML:function(){return""},display:function(){OpenLayers.Layer.prototype.display.apply(this,
arguments);this.pane.style.display=this.div.style.display},setZIndex:function(){OpenLayers.Layer.prototype.setZIndex.apply(this,arguments);this.pane.style.zIndex=parseInt(this.div.style.zIndex)+1},moveByPx:function(a,b){OpenLayers.Layer.prototype.moveByPx.apply(this,arguments);this.dragPanMapObject?this.dragPanMapObject(a,-b):this.moveTo(this.map.getCachedCenter())},moveTo:function(a,b,c){OpenLayers.Layer.prototype.moveTo.apply(this,arguments);if(this.mapObject!=null){var d=this.map.getCenter(),e=
this.map.getZoom();if(d!=null){var f=this.getOLLonLatFromMapObjectLonLat(this.getMapObjectCenter()),g=this.getOLZoomFromMapObjectZoom(this.getMapObjectZoom());if(!d.equals(f)||e!=g)if(!b&&f&&this.dragPanMapObject&&this.smoothDragPan){e=this.map.getViewPortPxFromLonLat(f);d=this.map.getViewPortPxFromLonLat(d);this.dragPanMapObject(d.x-e.x,e.y-d.y)}else{d=this.getMapObjectLonLatFromOLLonLat(d);e=this.getMapObjectZoomFromOLZoom(e);this.setMapObjectCenter(d,e,c)}}}},getLonLatFromViewPortPx:function(a){var b=
null;if(this.mapObject!=null&&this.getMapObjectCenter()!=null)b=this.getOLLonLatFromMapObjectLonLat(this.getMapObjectLonLatFromMapObjectPixel(this.getMapObjectPixelFromOLPixel(a)));return b},getViewPortPxFromLonLat:function(a){var b=null;if(this.mapObject!=null&&this.getMapObjectCenter()!=null)b=this.getOLPixelFromMapObjectPixel(this.getMapObjectPixelFromMapObjectLonLat(this.getMapObjectLonLatFromOLLonLat(a)));return b},getOLLonLatFromMapObjectLonLat:function(a){var b=null;if(a!=null){b=this.getLongitudeFromMapObjectLonLat(a);
a=this.getLatitudeFromMapObjectLonLat(a);b=new OpenLayers.LonLat(b,a)}return b},getMapObjectLonLatFromOLLonLat:function(a){var b=null;if(a!=null)b=this.getMapObjectLonLatFromLonLat(a.lon,a.lat);return b},getOLPixelFromMapObjectPixel:function(a){var b=null;if(a!=null){b=this.getXFromMapObjectPixel(a);a=this.getYFromMapObjectPixel(a);b=new OpenLayers.Pixel(b,a)}return b},getMapObjectPixelFromOLPixel:function(a){var b=null;if(a!=null)b=this.getMapObjectPixelFromXY(a.x,a.y);return b},CLASS_NAME:"OpenLayers.Layer.EventPane"});
OpenLayers.Layer.FixedZoomLevels=OpenLayers.Class({initialize:function(){},initResolutions:function(){for(var a=["minZoomLevel","maxZoomLevel","numZoomLevels"],b=0,c=a.length;b<c;b++){var d=a[b];this[d]=this.options[d]!=null?this.options[d]:this.map[d]}if(this.minZoomLevel==null||this.minZoomLevel<this.MIN_ZOOM_LEVEL)this.minZoomLevel=this.MIN_ZOOM_LEVEL;a=this.MAX_ZOOM_LEVEL-this.minZoomLevel+1;b=this.options.numZoomLevels==null&&this.options.maxZoomLevel!=null||this.numZoomLevels==null&&this.maxZoomLevel!=
null?this.maxZoomLevel-this.minZoomLevel+1:this.numZoomLevels;this.numZoomLevels=b!=null?Math.min(b,a):a;this.maxZoomLevel=this.minZoomLevel+this.numZoomLevels-1;if(this.RESOLUTIONS!=null){a=0;this.resolutions=[];for(b=this.minZoomLevel;b<=this.maxZoomLevel;b++)this.resolutions[a++]=this.RESOLUTIONS[b];this.maxResolution=this.resolutions[0];this.minResolution=this.resolutions[this.resolutions.length-1]}},getResolution:function(){if(this.resolutions!=null)return OpenLayers.Layer.prototype.getResolution.apply(this,
arguments);else{var a=null,b=this.map.getSize(),c=this.getExtent();if(b!=null&&c!=null)a=Math.max(c.getWidth()/b.w,c.getHeight()/b.h);return a}},getExtent:function(){var a=null,b=this.map.getSize(),c=this.getLonLatFromViewPortPx(new OpenLayers.Pixel(0,0));b=this.getLonLatFromViewPortPx(new OpenLayers.Pixel(b.w,b.h));if(c!=null&&b!=null)a=new OpenLayers.Bounds(c.lon,b.lat,b.lon,c.lat);return a},getZoomForResolution:function(){return this.resolutions!=null?OpenLayers.Layer.prototype.getZoomForResolution.apply(this,
arguments):this.getZoomForExtent(OpenLayers.Layer.prototype.getExtent.apply(this,[]))},getOLZoomFromMapObjectZoom:function(a){var b=null;if(a!=null){b=a-this.minZoomLevel;if(this.map.baseLayer!==this)b=this.map.baseLayer.getZoomForResolution(this.getResolutionForZoom(b))}return b},getMapObjectZoomFromOLZoom:function(a){var b=null;if(a!=null){b=a+this.minZoomLevel;if(this.map.baseLayer!==this)b=this.getZoomForResolution(this.map.baseLayer.getResolutionForZoom(b))}return b},CLASS_NAME:"OpenLayers.Layer.FixedZoomLevels"});
OpenLayers.Layer.VirtualEarth=OpenLayers.Class(OpenLayers.Layer.EventPane,OpenLayers.Layer.FixedZoomLevels,{MIN_ZOOM_LEVEL:1,MAX_ZOOM_LEVEL:19,RESOLUTIONS:[1.40625,0.703125,0.3515625,0.17578125,0.087890625,0.0439453125,0.02197265625,0.010986328125,0.0054931640625,0.00274658203125,0.001373291015625,6.866455078125E-4,3.4332275390625E-4,1.71661376953125E-4,8.58306884765625E-5,4.291534423828125E-5,2.145767211914062E-5,1.072883605957031E-5,5.36441802978515E-6],type:null,wrapDateLine:true,sphericalMercator:false,
animationEnabled:true,initialize:function(){OpenLayers.Layer.EventPane.prototype.initialize.apply(this,arguments);OpenLayers.Layer.FixedZoomLevels.prototype.initialize.apply(this,arguments);if(this.sphericalMercator){OpenLayers.Util.extend(this,OpenLayers.Layer.SphericalMercator);this.initMercatorParameters()}},loadMapObject:function(){var a=OpenLayers.Util.createDiv(this.name),b=this.map.getSize();a.style.width=b.w+"px";a.style.height=b.h+"px";this.div.appendChild(a);try{this.mapObject=new VEMap(this.name)}catch(c){}if(this.mapObject!=
null){try{this.mapObject.LoadMap(null,null,this.type,true);this.mapObject.AttachEvent("onmousedown",OpenLayers.Function.True)}catch(d){}this.mapObject.HideDashboard();typeof this.mapObject.SetAnimationEnabled=="function"&&this.mapObject.SetAnimationEnabled(this.animationEnabled)}if(!this.mapObject||!this.mapObject.vemapcontrol||!this.mapObject.vemapcontrol.PanMap||typeof this.mapObject.vemapcontrol.PanMap!="function")this.dragPanMapObject=null},onMapResize:function(){this.mapObject.Resize(this.map.size.w,
this.map.size.h)},getWarningHTML:function(){return OpenLayers.i18n("getLayerWarning",{layerType:"VE",layerLib:"VirtualEarth"})},setMapObjectCenter:function(a,b){this.mapObject.SetCenterAndZoom(a,b)},getMapObjectCenter:function(){return this.mapObject.GetCenter()},dragPanMapObject:function(a,b){this.mapObject.vemapcontrol.PanMap(a,-b)},getMapObjectZoom:function(){return this.mapObject.GetZoomLevel()},getMapObjectLonLatFromMapObjectPixel:function(a){return typeof VEPixel!="undefined"?this.mapObject.PixelToLatLong(a):
this.mapObject.PixelToLatLong(a.x,a.y)},getMapObjectPixelFromMapObjectLonLat:function(a){return this.mapObject.LatLongToPixel(a)},getLongitudeFromMapObjectLonLat:function(a){return this.sphericalMercator?this.forwardMercator(a.Longitude,a.Latitude).lon:a.Longitude},getLatitudeFromMapObjectLonLat:function(a){return this.sphericalMercator?this.forwardMercator(a.Longitude,a.Latitude).lat:a.Latitude},getMapObjectLonLatFromLonLat:function(a,b){var c;if(this.sphericalMercator){c=this.inverseMercator(a,
b);c=new VELatLong(c.lat,c.lon)}else c=new VELatLong(b,a);return c},getXFromMapObjectPixel:function(a){return a.x},getYFromMapObjectPixel:function(a){return a.y},getMapObjectPixelFromXY:function(a,b){return typeof VEPixel!="undefined"?new VEPixel(a,b):new Msn.VE.Pixel(a,b)},CLASS_NAME:"OpenLayers.Layer.VirtualEarth"});
OpenLayers.Format.XML=OpenLayers.Class(OpenLayers.Format,{namespaces:null,namespaceAlias:null,defaultPrefix:null,readers:{},writers:{},xmldom:null,initialize:function(a){if(window.ActiveXObject)this.xmldom=new ActiveXObject("Microsoft.XMLDOM");OpenLayers.Format.prototype.initialize.apply(this,[a]);this.namespaces=OpenLayers.Util.extend({},this.namespaces);this.namespaceAlias={};for(var b in this.namespaces)this.namespaceAlias[this.namespaces[b]]=b},destroy:function(){this.xmldom=null;OpenLayers.Format.prototype.destroy.apply(this,
arguments)},setNamespace:function(a,b){this.namespaces[a]=b;this.namespaceAlias[b]=a},read:function(a){var b=a.indexOf("<");if(b>0)a=a.substring(b);b=OpenLayers.Util.Try(OpenLayers.Function.bind(function(){var c;c=window.ActiveXObject&&!this.xmldom?new ActiveXObject("Microsoft.XMLDOM"):this.xmldom;c.loadXML(a);return c},this),function(){return(new DOMParser).parseFromString(a,"text/xml")},function(){var c=new XMLHttpRequest;c.open("GET","data:text/xml;charset=utf-8,"+encodeURIComponent(a),false);
c.overrideMimeType&&c.overrideMimeType("text/xml");c.send(null);return c.responseXML});if(this.keepData)this.data=b;return b},write:function(a){if(this.xmldom)a=a.xml;else{var b=new XMLSerializer;if(a.nodeType==1){var c=document.implementation.createDocument("","",null);if(c.importNode)a=c.importNode(a,true);c.appendChild(a);a=b.serializeToString(c)}else a=b.serializeToString(a)}return a},createElementNS:function(a,b){return this.xmldom?typeof a=="string"?this.xmldom.createNode(1,b,a):this.xmldom.createNode(1,
b,""):document.createElementNS(a,b)},createTextNode:function(a){if(typeof a!=="string")a=String(a);return this.xmldom?this.xmldom.createTextNode(a):document.createTextNode(a)},getElementsByTagNameNS:function(a,b,c){var d=[];if(a.getElementsByTagNameNS)d=a.getElementsByTagNameNS(b,c);else{a=a.getElementsByTagName("*");for(var e,f,g=0,h=a.length;g<h;++g){e=a[g];f=e.prefix?e.prefix+":"+c:c;if(c=="*"||f==e.nodeName)if(b=="*"||b==e.namespaceURI)d.push(e)}}return d},getAttributeNodeNS:function(a,b,c){var d=
null;if(a.getAttributeNodeNS)d=a.getAttributeNodeNS(b,c);else{a=a.attributes;for(var e,f,g=0,h=a.length;g<h;++g){e=a[g];if(e.namespaceURI==b){f=e.prefix?e.prefix+":"+c:c;if(f==e.nodeName){d=e;break}}}}return d},getAttributeNS:function(a,b,c){var d="";if(a.getAttributeNS)d=a.getAttributeNS(b,c)||"";else if(a=this.getAttributeNodeNS(a,b,c))d=a.nodeValue;return d},getChildValue:function(a,b){var c=b||"";if(a)for(var d=a.firstChild;d;d=d.nextSibling)switch(d.nodeType){case 3:case 4:c+=d.nodeValue}return c},
concatChildValues:function(a,b){for(var c="",d=a.firstChild,e;d;){if(e=d.nodeValue)c+=e;d=d.nextSibling}if(c==""&&b!=undefined)c=b;return c},isSimpleContent:function(a){var b=true;for(a=a.firstChild;a;a=a.nextSibling)if(a.nodeType===1){b=false;break}return b},contentType:function(a){var b=false,c=false,d=OpenLayers.Format.XML.CONTENT_TYPE.EMPTY;for(a=a.firstChild;a;a=a.nextSibling){switch(a.nodeType){case 1:c=true;break;case 8:break;default:b=true}if(c&&b)break}if(c&&b)d=OpenLayers.Format.XML.CONTENT_TYPE.MIXED;
else if(c)return OpenLayers.Format.XML.CONTENT_TYPE.COMPLEX;else if(b)return OpenLayers.Format.XML.CONTENT_TYPE.SIMPLE;return d},hasAttributeNS:function(a,b,c){var d=false;return d=a.hasAttributeNS?a.hasAttributeNS(b,c):!!this.getAttributeNodeNS(a,b,c)},setAttributeNS:function(a,b,c,d){if(a.setAttributeNS)a.setAttributeNS(b,c,d);else if(this.xmldom)if(b){b=a.ownerDocument.createNode(2,c,b);b.nodeValue=d;a.setAttributeNode(b)}else a.setAttribute(c,d);else throw"setAttributeNS not implemented";},createElementNSPlus:function(a,
b){b=b||{};var c=b.uri||this.namespaces[b.prefix];if(!c){c=a.indexOf(":");c=this.namespaces[a.substring(0,c)]}c||(c=this.namespaces[this.defaultPrefix]);c=this.createElementNS(c,a);b.attributes&&this.setAttributes(c,b.attributes);var d=b.value;d!=null&&c.appendChild(this.createTextNode(d));return c},setAttributes:function(a,b){var c,d,e;for(e in b)if(b[e]!=null&&b[e].toString){c=b[e].toString();d=this.namespaces[e.substring(0,e.indexOf(":"))]||null;this.setAttributeNS(a,d,e,c)}},readNode:function(a,
b){b||(b={});var c=this.readers[a.namespaceURI?this.namespaceAlias[a.namespaceURI]:this.defaultPrefix];if(c){var d=a.localName||a.nodeName.split(":").pop();(c=c[d]||c["*"])&&c.apply(this,[a,b])}return b},readChildNodes:function(a,b){b||(b={});for(var c=a.childNodes,d,e=0,f=c.length;e<f;++e){d=c[e];d.nodeType==1&&this.readNode(d,b)}return b},writeNode:function(a,b,c){var d,e=a.indexOf(":");if(e>0){d=a.substring(0,e);a=a.substring(e+1)}else d=c?this.namespaceAlias[c.namespaceURI]:this.defaultPrefix;
b=this.writers[d][a].apply(this,[b]);c&&c.appendChild(b);return b},getChildEl:function(a,b,c){return a&&this.getThisOrNextEl(a.firstChild,b,c)},getNextEl:function(a,b,c){return a&&this.getThisOrNextEl(a.nextSibling,b,c)},getThisOrNextEl:function(a,b,c){a:for(;a;a=a.nextSibling)switch(a.nodeType){case 1:if((!b||b===(a.localName||a.nodeName.split(":").pop()))&&(!c||c===a.namespaceURI))break a;a=null;break a;case 3:if(/^\s*$/.test(a.nodeValue))break;case 4:case 6:case 12:case 10:case 11:a=null;break a}return a||
null},lookupNamespaceURI:function(a,b){var c=null;if(a)if(a.lookupNamespaceURI)c=a.lookupNamespaceURI(b);else a:switch(a.nodeType){case 1:if(a.namespaceURI!==null&&a.prefix===b){c=a.namespaceURI;break a}if(c=a.attributes.length)for(var d,e=0;e<c;++e){d=a.attributes[e];if(d.prefix==="xmlns"&&d.name==="xmlns:"+b){c=d.value||null;break a}else if(d.name==="xmlns"&&b===null){c=d.value||null;break a}}c=this.lookupNamespaceURI(a.parentNode,b);break a;case 2:c=this.lookupNamespaceURI(a.ownerElement,b);break a;
case 9:c=this.lookupNamespaceURI(a.documentElement,b);break a;case 6:case 12:case 10:case 11:break a;default:c=this.lookupNamespaceURI(a.parentNode,b)}return c},getXMLDoc:function(){if(!OpenLayers.Format.XML.document&&!this.xmldom)if(document.implementation&&document.implementation.createDocument)OpenLayers.Format.XML.document=document.implementation.createDocument("","",null);else if(!this.xmldom&&window.ActiveXObject)this.xmldom=new ActiveXObject("Microsoft.XMLDOM");return OpenLayers.Format.XML.document||
this.xmldom},CLASS_NAME:"OpenLayers.Format.XML"});OpenLayers.Format.XML.CONTENT_TYPE={EMPTY:0,SIMPLE:1,COMPLEX:2,MIXED:3};OpenLayers.Format.XML.lookupNamespaceURI=OpenLayers.Function.bind(OpenLayers.Format.XML.prototype.lookupNamespaceURI,OpenLayers.Format.XML.prototype);OpenLayers.Format.XML.document=null;
OpenLayers.Geometry=OpenLayers.Class({id:null,parent:null,bounds:null,initialize:function(){this.id=OpenLayers.Util.createUniqueID(this.CLASS_NAME+"_")},destroy:function(){this.bounds=this.id=null},clone:function(){return new OpenLayers.Geometry},setBounds:function(a){if(a)this.bounds=a.clone()},clearBounds:function(){this.bounds=null;this.parent&&this.parent.clearBounds()},extendBounds:function(a){this.getBounds()?this.bounds.extend(a):this.setBounds(a)},getBounds:function(){this.bounds==null&&this.calculateBounds();
return this.bounds},calculateBounds:function(){},distanceTo:function(){},getVertices:function(){},atPoint:function(a,b,c){var d=false;if(this.getBounds()!=null&&a!=null){b=b!=null?b:0;c=c!=null?c:0;d=(new OpenLayers.Bounds(this.bounds.left-b,this.bounds.bottom-c,this.bounds.right+b,this.bounds.top+c)).containsLonLat(a)}return d},getLength:function(){return 0},getArea:function(){return 0},getCentroid:function(){return null},toString:function(){return OpenLayers.Format.WKT.prototype.write(new OpenLayers.Feature.Vector(this))},
CLASS_NAME:"OpenLayers.Geometry"});OpenLayers.Geometry.fromWKT=function(a){var b=arguments.callee.format;if(!b){b=new OpenLayers.Format.WKT;arguments.callee.format=b}var c;b=b.read(a);if(b instanceof OpenLayers.Feature.Vector)c=b.geometry;else if(OpenLayers.Util.isArray(b)){c=b.length;for(var d=Array(c),e=0;e<c;++e)d[e]=b[e].geometry;c=new OpenLayers.Geometry.Collection(d)}return c};
OpenLayers.Geometry.segmentsIntersect=function(a,b,c){var d=c&&c.point;c=c&&c.tolerance;var e=false,f=a.x1-b.x1,g=a.y1-b.y1,h=a.x2-a.x1,j=a.y2-a.y1,i=b.y2-b.y1,k=b.x2-b.x1,l=i*h-k*j;i=k*g-i*f;g=h*g-j*f;if(l==0){if(i==0&&g==0)e=true}else{f=i/l;l=g/l;if(f>=0&&f<=1&&l>=0&&l<=1)if(d){h=a.x1+f*h;l=a.y1+f*j;e=new OpenLayers.Geometry.Point(h,l)}else e=true}if(c)if(e){if(d){a=[a,b];b=0;a:for(;b<2;++b){f=a[b];for(j=1;j<3;++j){h=f["x"+j];l=f["y"+j];d=Math.sqrt(Math.pow(h-e.x,2)+Math.pow(l-e.y,2));if(d<c){e.x=
h;e.y=l;break a}}}}}else{a=[a,b];b=0;a:for(;b<2;++b){h=a[b];l=a[(b+1)%2];for(j=1;j<3;++j){f={x:h["x"+j],y:h["y"+j]};g=OpenLayers.Geometry.distanceToSegment(f,l);if(g.distance<c){e=d?new OpenLayers.Geometry.Point(f.x,f.y):true;break a}}}}return e};
OpenLayers.Geometry.distanceToSegment=function(a,b){var c=a.x,d=a.y,e=b.x1,f=b.y1,g=b.x2,h=b.y2,j=g-e,i=h-f,k=(j*(c-e)+i*(d-f))/(Math.pow(j,2)+Math.pow(i,2));if(!(k<=0))if(k>=1){e=g;f=h}else{e+=k*j;f+=k*i}return{distance:Math.sqrt(Math.pow(e-c,2)+Math.pow(f-d,2)),x:e,y:f}};
OpenLayers.Geometry.Point=OpenLayers.Class(OpenLayers.Geometry,{x:null,y:null,initialize:function(a,b){OpenLayers.Geometry.prototype.initialize.apply(this,arguments);this.x=parseFloat(a);this.y=parseFloat(b)},clone:function(a){if(a==null)a=new OpenLayers.Geometry.Point(this.x,this.y);OpenLayers.Util.applyDefaults(a,this);return a},calculateBounds:function(){this.bounds=new OpenLayers.Bounds(this.x,this.y,this.x,this.y)},distanceTo:function(a,b){var c=!(b&&b.edge===false)&&b&&b.details,d,e,f,g,h;if(a instanceof
OpenLayers.Geometry.Point){e=this.x;f=this.y;g=a.x;h=a.y;d=Math.sqrt(Math.pow(e-g,2)+Math.pow(f-h,2));d=!c?d:{x0:e,y0:f,x1:g,y1:h,distance:d}}else{d=a.distanceTo(this,b);if(c)d={x0:d.x1,y0:d.y1,x1:d.x0,y1:d.y0,distance:d.distance}}return d},equals:function(a){var b=false;if(a!=null)b=this.x==a.x&&this.y==a.y||isNaN(this.x)&&isNaN(this.y)&&isNaN(a.x)&&isNaN(a.y);return b},toShortString:function(){return this.x+", "+this.y},move:function(a,b){this.x+=a;this.y+=b;this.clearBounds()},rotate:function(a,
b){a*=Math.PI/180;var c=this.distanceTo(b),d=a+Math.atan2(this.y-b.y,this.x-b.x);this.x=b.x+c*Math.cos(d);this.y=b.y+c*Math.sin(d);this.clearBounds()},getCentroid:function(){return new OpenLayers.Geometry.Point(this.x,this.y)},resize:function(a,b,c){this.x=b.x+a*(c==undefined?1:c)*(this.x-b.x);this.y=b.y+a*(this.y-b.y);this.clearBounds();return this},intersects:function(a){var b=false;return b=a.CLASS_NAME=="OpenLayers.Geometry.Point"?this.equals(a):a.intersects(this)},transform:function(a,b){if(a&&
b){OpenLayers.Projection.transform(this,a,b);this.bounds=null}return this},getVertices:function(){return[this]},CLASS_NAME:"OpenLayers.Geometry.Point"});
OpenLayers.Geometry.Collection=OpenLayers.Class(OpenLayers.Geometry,{components:null,componentTypes:null,initialize:function(a){OpenLayers.Geometry.prototype.initialize.apply(this,arguments);this.components=[];a!=null&&this.addComponents(a)},destroy:function(){this.components.length=0;this.components=null;OpenLayers.Geometry.prototype.destroy.apply(this,arguments)},clone:function(){for(var a=eval("new "+this.CLASS_NAME+"()"),b=0,c=this.components.length;b<c;b++)a.addComponent(this.components[b].clone());
OpenLayers.Util.applyDefaults(a,this);return a},getComponentsString:function(){for(var a=[],b=0,c=this.components.length;b<c;b++)a.push(this.components[b].toShortString());return a.join(",")},calculateBounds:function(){this.bounds=null;var a=new OpenLayers.Bounds,b=this.components;if(b)for(var c=0,d=b.length;c<d;c++)a.extend(b[c].getBounds());a.left!=null&&a.bottom!=null&&a.right!=null&&a.top!=null&&this.setBounds(a)},addComponents:function(a){OpenLayers.Util.isArray(a)||(a=[a]);for(var b=0,c=a.length;b<
c;b++)this.addComponent(a[b])},addComponent:function(a,b){var c=false;if(a)if(this.componentTypes==null||OpenLayers.Util.indexOf(this.componentTypes,a.CLASS_NAME)>-1){if(b!=null&&b<this.components.length){c=this.components.slice(0,b);var d=this.components.slice(b,this.components.length);c.push(a);this.components=c.concat(d)}else this.components.push(a);a.parent=this;this.clearBounds();c=true}return c},removeComponents:function(a){var b=false;OpenLayers.Util.isArray(a)||(a=[a]);for(var c=a.length-
1;c>=0;--c)b=this.removeComponent(a[c])||b;return b},removeComponent:function(a){OpenLayers.Util.removeItem(this.components,a);this.clearBounds();return true},getLength:function(){for(var a=0,b=0,c=this.components.length;b<c;b++)a+=this.components[b].getLength();return a},getArea:function(){for(var a=0,b=0,c=this.components.length;b<c;b++)a+=this.components[b].getArea();return a},getGeodesicArea:function(a){for(var b=0,c=0,d=this.components.length;c<d;c++)b+=this.components[c].getGeodesicArea(a);
return b},getCentroid:function(a){if(!a)return this.components.length&&this.components[0].getCentroid();a=this.components.length;if(!a)return false;for(var b=[],c=[],d=0,e=Number.MAX_VALUE,f,g=0;g<a;++g){f=this.components[g];var h=f.getArea();f=f.getCentroid(true);if(!(isNaN(h)||isNaN(f.x)||isNaN(f.y))){b.push(h);d+=h;e=h<e&&h>0?h:e;c.push(f)}}a=b.length;if(d===0){for(g=0;g<a;++g)b[g]=1;d=b.length}else{for(g=0;g<a;++g)b[g]/=e;d/=e}var j=e=0;for(g=0;g<a;++g){f=c[g];h=b[g];e+=f.x*h;j+=f.y*h}return new OpenLayers.Geometry.Point(e/
d,j/d)},getGeodesicLength:function(a){for(var b=0,c=0,d=this.components.length;c<d;c++)b+=this.components[c].getGeodesicLength(a);return b},move:function(a,b){for(var c=0,d=this.components.length;c<d;c++)this.components[c].move(a,b)},rotate:function(a,b){for(var c=0,d=this.components.length;c<d;++c)this.components[c].rotate(a,b)},resize:function(a,b,c){for(var d=0;d<this.components.length;++d)this.components[d].resize(a,b,c);return this},distanceTo:function(a,b){for(var c=!(b&&b.edge===false)&&b&&
b.details,d,e,f,g=Number.POSITIVE_INFINITY,h=0,j=this.components.length;h<j;++h){d=this.components[h].distanceTo(a,b);f=c?d.distance:d;if(f<g){g=f;e=d;if(g==0)break}}return e},equals:function(a){var b=true;if(!a||!a.CLASS_NAME||this.CLASS_NAME!=a.CLASS_NAME)b=false;else if(!OpenLayers.Util.isArray(a.components)||a.components.length!=this.components.length)b=false;else for(var c=0,d=this.components.length;c<d;++c)if(!this.components[c].equals(a.components[c])){b=false;break}return b},transform:function(a,
b){if(a&&b){for(var c=0,d=this.components.length;c<d;c++)this.components[c].transform(a,b);this.bounds=null}return this},intersects:function(a){for(var b=false,c=0,d=this.components.length;c<d;++c)if(b=a.intersects(this.components[c]))break;return b},getVertices:function(a){for(var b=[],c=0,d=this.components.length;c<d;++c)Array.prototype.push.apply(b,this.components[c].getVertices(a));return b},CLASS_NAME:"OpenLayers.Geometry.Collection"});
OpenLayers.Geometry.MultiPoint=OpenLayers.Class(OpenLayers.Geometry.Collection,{componentTypes:["OpenLayers.Geometry.Point"],initialize:function(){OpenLayers.Geometry.Collection.prototype.initialize.apply(this,arguments)},addPoint:function(a,b){this.addComponent(a,b)},removePoint:function(a){this.removeComponent(a)},CLASS_NAME:"OpenLayers.Geometry.MultiPoint"});
OpenLayers.Geometry.Curve=OpenLayers.Class(OpenLayers.Geometry.MultiPoint,{componentTypes:["OpenLayers.Geometry.Point"],initialize:function(){OpenLayers.Geometry.MultiPoint.prototype.initialize.apply(this,arguments)},getLength:function(){var a=0;if(this.components&&this.components.length>1)for(var b=1,c=this.components.length;b<c;b++)a+=this.components[b-1].distanceTo(this.components[b]);return a},getGeodesicLength:function(a){var b=this;if(a){var c=new OpenLayers.Projection("EPSG:4326");c.equals(a)||
(b=this.clone().transform(a,c))}a=0;if(b.components&&b.components.length>1)for(var d,e=1,f=b.components.length;e<f;e++){c=b.components[e-1];d=b.components[e];a+=OpenLayers.Util.distVincenty({lon:c.x,lat:c.y},{lon:d.x,lat:d.y})}return a*1E3},CLASS_NAME:"OpenLayers.Geometry.Curve"});
OpenLayers.Geometry.LineString=OpenLayers.Class(OpenLayers.Geometry.Curve,{initialize:function(){OpenLayers.Geometry.Curve.prototype.initialize.apply(this,arguments)},removeComponent:function(){var a=this.components&&this.components.length>2;a&&OpenLayers.Geometry.Collection.prototype.removeComponent.apply(this,arguments);return a},intersects:function(a){var b=false,c=a.CLASS_NAME;if(c=="OpenLayers.Geometry.LineString"||c=="OpenLayers.Geometry.LinearRing"||c=="OpenLayers.Geometry.Point"){var d=this.getSortedSegments();
a=c=="OpenLayers.Geometry.Point"?[{x1:a.x,y1:a.y,x2:a.x,y2:a.y}]:a.getSortedSegments();var e,f,g,h,j,i,k,l=0,m=d.length;a:for(;l<m;++l){c=d[l];e=c.x1;f=c.x2;g=c.y1;h=c.y2;var n=0,p=a.length;for(;n<p;++n){j=a[n];if(j.x1>f)break;if(!(j.x2<e)){i=j.y1;k=j.y2;if(!(Math.min(i,k)>Math.max(g,h)))if(!(Math.max(i,k)<Math.min(g,h)))if(OpenLayers.Geometry.segmentsIntersect(c,j)){b=true;break a}}}}}else b=a.intersects(this);return b},getSortedSegments:function(){for(var a=this.components.length-1,b=Array(a),c,
d,e=0;e<a;++e){c=this.components[e];d=this.components[e+1];b[e]=c.x<d.x?{x1:c.x,y1:c.y,x2:d.x,y2:d.y}:{x1:d.x,y1:d.y,x2:c.x,y2:c.y}}return b.sort(function(f,g){return f.x1-g.x1})},splitWithSegment:function(a,b){for(var c=!(b&&b.edge===false),d=b&&b.tolerance,e=[],f=this.getVertices(),g=[],h=[],j=false,i,k,l,m={point:true,tolerance:d},n=null,p=0,r=f.length-2;p<=r;++p){d=f[p];g.push(d.clone());i=f[p+1];k={x1:d.x,y1:d.y,x2:i.x,y2:i.y};k=OpenLayers.Geometry.segmentsIntersect(a,k,m);if(k instanceof OpenLayers.Geometry.Point)if((l=
k.x===a.x1&&k.y===a.y1||k.x===a.x2&&k.y===a.y2||k.equals(d)||k.equals(i)?true:false)||c){k.equals(h[h.length-1])||h.push(k.clone());if(p===0)if(k.equals(d))continue;if(!k.equals(i)){j=true;k.equals(d)||g.push(k);e.push(new OpenLayers.Geometry.LineString(g));g=[k.clone()]}}}if(j){g.push(i.clone());e.push(new OpenLayers.Geometry.LineString(g))}if(h.length>0){var t=a.x1<a.x2?1:-1,s=a.y1<a.y2?1:-1;n={lines:e,points:h.sort(function(v,x){return t*v.x-t*x.x||s*v.y-s*x.y})}}return n},split:function(a,b){var c=
null,d=b&&b.mutual,e,f,g,h;if(a instanceof OpenLayers.Geometry.LineString){var j=this.getVertices(),i,k,l,m,n,p=[];g=[];for(var r=0,t=j.length-2;r<=t;++r){i=j[r];k=j[r+1];l={x1:i.x,y1:i.y,x2:k.x,y2:k.y};h=h||[a];d&&p.push(i.clone());for(var s=0;s<h.length;++s)if(m=h[s].splitWithSegment(l,b)){n=m.lines;if(n.length>0){n.unshift(s,1);Array.prototype.splice.apply(h,n);s+=n.length-2}if(d)for(var v=0,x=m.points.length;v<x;++v){n=m.points[v];if(!n.equals(i)){p.push(n);g.push(new OpenLayers.Geometry.LineString(p));
p=n.equals(k)?[]:[n.clone()]}}}}if(d&&g.length>0&&p.length>0){p.push(k.clone());g.push(new OpenLayers.Geometry.LineString(p))}}else c=a.splitWith(this,b);if(h&&h.length>1)f=true;else h=[];if(g&&g.length>1)e=true;else g=[];if(f||e)c=d?[g,h]:h;return c},splitWith:function(a,b){return a.split(this,b)},getVertices:function(a){return a===true?[this.components[0],this.components[this.components.length-1]]:a===false?this.components.slice(1,this.components.length-1):this.components.slice()},distanceTo:function(a,
b){var c=!(b&&b.edge===false)&&b&&b.details,d,e={},f=Number.POSITIVE_INFINITY;if(a instanceof OpenLayers.Geometry.Point){for(var g=this.getSortedSegments(),h=a.x,j=a.y,i,k=0,l=g.length;k<l;++k){i=g[k];d=OpenLayers.Geometry.distanceToSegment(a,i);if(d.distance<f){f=d.distance;e=d;if(f===0)break}else if(i.x2>h&&(j>i.y1&&j<i.y2||j<i.y1&&j>i.y2))break}e=c?{distance:e.distance,x0:e.x,y0:e.y,x1:h,y1:j}:e.distance}else if(a instanceof OpenLayers.Geometry.LineString){g=this.getSortedSegments();h=a.getSortedSegments();
var m,n,p=h.length,r={point:true};k=0;l=g.length;a:for(;k<l;++k){j=g[k];i=j.x1;n=j.y1;for(var t=0;t<p;++t){d=h[t];if(m=OpenLayers.Geometry.segmentsIntersect(j,d,r)){f=0;e={distance:0,x0:m.x,y0:m.y,x1:m.x,y1:m.y};break a}else{d=OpenLayers.Geometry.distanceToSegment({x:i,y:n},d);if(d.distance<f){f=d.distance;e={distance:f,x0:i,y0:n,x1:d.x,y1:d.y}}}}}if(!c)e=e.distance;if(f!==0)if(j){d=a.distanceTo(new OpenLayers.Geometry.Point(j.x2,j.y2),b);k=c?d.distance:d;if(k<f)e=c?{distance:f,x0:d.x1,y0:d.y1,x1:d.x0,
y1:d.y0}:k}}else{e=a.distanceTo(this,b);if(c)e={distance:e.distance,x0:e.x1,y0:e.y1,x1:e.x0,y1:e.y0}}return e},simplify:function(a){if(this&&this!==null){var b=this.getVertices();if(b.length<3)return this;var c=function(f,g,h,j){for(var i=0,k=0,l=g,m;l<h;l++){m=Math.abs(0.5*(f[g].x*f[h].y+f[h].x*f[l].y+f[l].x*f[g].y-f[h].x*f[g].y-f[l].x*f[h].y-f[g].x*f[l].y))/Math.sqrt(Math.pow(f[g].x-f[h].x,2)+Math.pow(f[g].y-f[h].y,2))*2;if(m>i){i=m;k=l}}if(i>j&&k!=g){e.push(k);c(f,g,k,j);c(f,k,h,j)}},d=b.length-
1,e=[];e.push(0);for(e.push(d);b[0].equals(b[d]);){d--;e.push(d)}c(b,0,d,a);a=[];e.sort(function(f,g){return f-g});for(d=0;d<e.length;d++)a.push(b[e[d]]);return new OpenLayers.Geometry.LineString(a)}else return this},CLASS_NAME:"OpenLayers.Geometry.LineString"});
OpenLayers.Geometry.LinearRing=OpenLayers.Class(OpenLayers.Geometry.LineString,{componentTypes:["OpenLayers.Geometry.Point"],initialize:function(){OpenLayers.Geometry.LineString.prototype.initialize.apply(this,arguments)},addComponent:function(a,b){var c=false,d=this.components.pop();if(b!=null||!a.equals(d))c=OpenLayers.Geometry.Collection.prototype.addComponent.apply(this,arguments);OpenLayers.Geometry.Collection.prototype.addComponent.apply(this,[this.components[0]]);return c},removeComponent:function(){var a=
this.components&&this.components.length>3;if(a){this.components.pop();OpenLayers.Geometry.Collection.prototype.removeComponent.apply(this,arguments);OpenLayers.Geometry.Collection.prototype.addComponent.apply(this,[this.components[0]])}return a},move:function(a,b){for(var c=0,d=this.components.length;c<d-1;c++)this.components[c].move(a,b)},rotate:function(a,b){for(var c=0,d=this.components.length;c<d-1;++c)this.components[c].rotate(a,b)},resize:function(a,b,c){for(var d=0,e=this.components.length;d<
e-1;++d)this.components[d].resize(a,b,c);return this},transform:function(a,b){if(a&&b){for(var c=0,d=this.components.length;c<d-1;c++)this.components[c].transform(a,b);this.bounds=null}return this},getCentroid:function(){if(this.components&&this.components.length>2){for(var a=0,b=0,c=0;c<this.components.length-1;c++){var d=this.components[c],e=this.components[c+1];a+=(d.x+e.x)*(d.x*e.y-e.x*d.y);b+=(d.y+e.y)*(d.x*e.y-e.x*d.y)}c=-1*this.getArea();return new OpenLayers.Geometry.Point(a/(6*c),b/(6*c))}else return null},
getArea:function(){var a=0;if(this.components&&this.components.length>2){for(var b=a=0,c=this.components.length;b<c-1;b++){var d=this.components[b],e=this.components[b+1];a+=(d.x+e.x)*(e.y-d.y)}a=-a/2}return a},getGeodesicArea:function(a){var b=this;if(a){var c=new OpenLayers.Projection("EPSG:4326");c.equals(a)||(b=this.clone().transform(a,c))}a=0;c=b.components&&b.components.length;if(c>2){for(var d,e,f=0;f<c-1;f++){d=b.components[f];e=b.components[f+1];a+=OpenLayers.Util.rad(e.x-d.x)*(2+Math.sin(OpenLayers.Util.rad(d.y))+
Math.sin(OpenLayers.Util.rad(e.y)))}a=a*40680631590769/2}return a},containsPoint:function(a){var b=OpenLayers.Number.limitSigDigs,c=b(a.x,14);a=b(a.y,14);for(var d=this.components.length-1,e,f,g,h,j,i=0,k=0;k<d;++k){e=this.components[k];g=b(e.x,14);e=b(e.y,14);f=this.components[k+1];h=b(f.x,14);f=b(f.y,14);if(e==f){if(a==e)if(g<=h&&c>=g&&c<=h||g>=h&&c<=g&&c>=h){i=-1;break}}else{j=b(((g-h)*a+(h*e-g*f))/(e-f),14);if(j==c)if(e<f&&a>=e&&a<=f||e>f&&a<=e&&a>=f){i=-1;break}if(!(j<=c))if(!(g!=h&&(j<Math.min(g,
h)||j>Math.max(g,h))))if(e<f&&a>=e&&a<f||e>f&&a<e&&a>=f)++i}}return i==-1?1:!!(i&1)},intersects:function(a){var b=false;if(a.CLASS_NAME=="OpenLayers.Geometry.Point")b=this.containsPoint(a);else if(a.CLASS_NAME=="OpenLayers.Geometry.LineString")b=a.intersects(this);else if(a.CLASS_NAME=="OpenLayers.Geometry.LinearRing")b=OpenLayers.Geometry.LineString.prototype.intersects.apply(this,[a]);else for(var c=0,d=a.components.length;c<d;++c)if(b=a.components[c].intersects(this))break;return b},getVertices:function(a){return a===
true?[]:this.components.slice(0,this.components.length-1)},CLASS_NAME:"OpenLayers.Geometry.LinearRing"});
OpenLayers.Geometry.Polygon=OpenLayers.Class(OpenLayers.Geometry.Collection,{componentTypes:["OpenLayers.Geometry.LinearRing"],initialize:function(){OpenLayers.Geometry.Collection.prototype.initialize.apply(this,arguments)},getArea:function(){var a=0;if(this.components&&this.components.length>0){a+=Math.abs(this.components[0].getArea());for(var b=1,c=this.components.length;b<c;b++)a-=Math.abs(this.components[b].getArea())}return a},getGeodesicArea:function(a){var b=0;if(this.components&&this.components.length>
0){b+=Math.abs(this.components[0].getGeodesicArea(a));for(var c=1,d=this.components.length;c<d;c++)b-=Math.abs(this.components[c].getGeodesicArea(a))}return b},containsPoint:function(a){var b=this.components.length,c=false;if(b>0){c=this.components[0].containsPoint(a);if(c!==1)if(c&&b>1)for(var d,e=1;e<b;++e)if(d=this.components[e].containsPoint(a)){c=d===1?1:false;break}}return c},intersects:function(a){var b=false,c,d;if(a.CLASS_NAME=="OpenLayers.Geometry.Point")b=this.containsPoint(a);else if(a.CLASS_NAME==
"OpenLayers.Geometry.LineString"||a.CLASS_NAME=="OpenLayers.Geometry.LinearRing"){c=0;for(d=this.components.length;c<d;++c)if(b=a.intersects(this.components[c]))break;if(!b){c=0;for(d=a.components.length;c<d;++c)if(b=this.containsPoint(a.components[c]))break}}else{c=0;for(d=a.components.length;c<d;++c)if(b=this.intersects(a.components[c]))break}if(!b&&a.CLASS_NAME=="OpenLayers.Geometry.Polygon"){var e=this.components[0];c=0;for(d=e.components.length;c<d;++c)if(b=a.containsPoint(e.components[c]))break}return b},
distanceTo:function(a,b){return b&&b.edge===false&&this.intersects(a)?0:OpenLayers.Geometry.Collection.prototype.distanceTo.apply(this,[a,b])},CLASS_NAME:"OpenLayers.Geometry.Polygon"});OpenLayers.Geometry.Polygon.createRegularPolygon=function(a,b,c,d){var e=Math.PI*(1/c-0.5);if(d)e+=d/180*Math.PI;for(var f,g=[],h=0;h<c;++h){f=e+h*2*Math.PI/c;d=a.x+b*Math.cos(f);f=a.y+b*Math.sin(f);g.push(new OpenLayers.Geometry.Point(d,f))}a=new OpenLayers.Geometry.LinearRing(g);return new OpenLayers.Geometry.Polygon([a])};
OpenLayers.Format.GeoRSS=OpenLayers.Class(OpenLayers.Format.XML,{rssns:"http://backend.userland.com/rss2",featureNS:"http://mapserver.gis.umn.edu/mapserver",georssns:"http://www.georss.org/georss",geons:"http://www.w3.org/2003/01/geo/wgs84_pos#",featureTitle:"Untitled",featureDescription:"No Description",gmlParser:null,xy:false,createGeometryFromItem:function(a){var b=this.getElementsByTagNameNS(a,this.georssns,"point"),c=this.getElementsByTagNameNS(a,this.geons,"lat"),d=this.getElementsByTagNameNS(a,
this.geons,"long"),e=this.getElementsByTagNameNS(a,this.georssns,"line"),f=this.getElementsByTagNameNS(a,this.georssns,"polygon"),g=this.getElementsByTagNameNS(a,this.georssns,"where");a=this.getElementsByTagNameNS(a,this.georssns,"box");if(b.length>0||c.length>0&&d.length>0){if(b.length>0){c=OpenLayers.String.trim(b[0].firstChild.nodeValue).split(/\s+/);if(c.length!=2)c=OpenLayers.String.trim(b[0].firstChild.nodeValue).split(/\s*,\s*/)}else c=[parseFloat(c[0].firstChild.nodeValue),parseFloat(d[0].firstChild.nodeValue)];
var h=new OpenLayers.Geometry.Point(parseFloat(c[1]),parseFloat(c[0]))}else if(e.length>0){c=OpenLayers.String.trim(this.concatChildValues(e[0])).split(/\s+/);d=[];e=0;for(f=c.length;e<f;e+=2){b=new OpenLayers.Geometry.Point(parseFloat(c[e+1]),parseFloat(c[e]));d.push(b)}h=new OpenLayers.Geometry.LineString(d)}else if(f.length>0){c=OpenLayers.String.trim(this.concatChildValues(f[0])).split(/\s+/);d=[];e=0;for(f=c.length;e<f;e+=2){b=new OpenLayers.Geometry.Point(parseFloat(c[e+1]),parseFloat(c[e]));
d.push(b)}h=new OpenLayers.Geometry.Polygon([new OpenLayers.Geometry.LinearRing(d)])}else if(g.length>0){if(!this.gmlParser)this.gmlParser=new OpenLayers.Format.GML({xy:this.xy});h=this.gmlParser.parseFeature(g[0]).geometry}else if(a.length>0){c=OpenLayers.String.trim(a[0].firstChild.nodeValue).split(/\s+/);d=[];if(c.length>3){b=new OpenLayers.Geometry.Point(parseFloat(c[1]),parseFloat(c[0]));d.push(b);b=new OpenLayers.Geometry.Point(parseFloat(c[1]),parseFloat(c[2]));d.push(b);b=new OpenLayers.Geometry.Point(parseFloat(c[3]),
parseFloat(c[2]));d.push(b);b=new OpenLayers.Geometry.Point(parseFloat(c[3]),parseFloat(c[0]));d.push(b);b=new OpenLayers.Geometry.Point(parseFloat(c[1]),parseFloat(c[0]));d.push(b)}h=new OpenLayers.Geometry.Polygon([new OpenLayers.Geometry.LinearRing(d)])}h&&this.internalProjection&&this.externalProjection&&h.transform(this.externalProjection,this.internalProjection);return h},createFeatureFromItem:function(a){var b=this.createGeometryFromItem(a),c=this.getChildValue(a,"*","title",this.featureTitle),
d=this.getChildValue(a,"*","description",this.getChildValue(a,"*","content",this.getChildValue(a,"*","summary",this.featureDescription))),e=this.getChildValue(a,"*","link");if(!e)try{e=this.getElementsByTagNameNS(a,"*","link")[0].getAttribute("href")}catch(f){e=null}a=this.getChildValue(a,"*","id",null);b=new OpenLayers.Feature.Vector(b,{title:c,description:d,link:e});b.fid=a;return b},getChildValue:function(a,b,c,d){return(a=this.getElementsByTagNameNS(a,b,c))&&a[0]&&a[0].firstChild&&a[0].firstChild.nodeValue?
OpenLayers.Format.XML.prototype.getChildValue(a[0]):d==undefined?"":d},read:function(a){if(typeof a=="string")a=OpenLayers.Format.XML.prototype.read.apply(this,[a]);var b=null;b=this.getElementsByTagNameNS(a,"*","item");if(b.length==0)b=this.getElementsByTagNameNS(a,"*","entry");a=b.length;for(var c=Array(a),d=0;d<a;d++)c[d]=this.createFeatureFromItem(b[d]);return c},write:function(a){var b;if(OpenLayers.Util.isArray(a)){b=this.createElementNS(this.rssns,"rss");for(var c=0,d=a.length;c<d;c++)b.appendChild(this.createFeatureXML(a[c]))}else b=
this.createFeatureXML(a);return OpenLayers.Format.XML.prototype.write.apply(this,[b])},createFeatureXML:function(a){var b=this.buildGeometryNode(a.geometry),c=this.createElementNS(this.rssns,"item"),d=this.createElementNS(this.rssns,"title");d.appendChild(this.createTextNode(a.attributes.title?a.attributes.title:""));var e=this.createElementNS(this.rssns,"description");e.appendChild(this.createTextNode(a.attributes.description?a.attributes.description:""));c.appendChild(d);c.appendChild(e);if(a.attributes.link){d=
this.createElementNS(this.rssns,"link");d.appendChild(this.createTextNode(a.attributes.link));c.appendChild(d)}for(var f in a.attributes)if(!(f=="link"||f=="title"||f=="description")){d=this.createTextNode(a.attributes[f]);e=f;if(f.search(":")!=-1)e=f.split(":")[1];e=this.createElementNS(this.featureNS,"feature:"+e);e.appendChild(d);c.appendChild(e)}c.appendChild(b);return c},buildGeometryNode:function(a){if(this.internalProjection&&this.externalProjection){a=a.clone();a.transform(this.internalProjection,
this.externalProjection)}var b;if(a.CLASS_NAME=="OpenLayers.Geometry.Polygon"){b=this.createElementNS(this.georssns,"georss:polygon");b.appendChild(this.buildCoordinatesNode(a.components[0]))}else if(a.CLASS_NAME=="OpenLayers.Geometry.LineString"){b=this.createElementNS(this.georssns,"georss:line");b.appendChild(this.buildCoordinatesNode(a))}else if(a.CLASS_NAME=="OpenLayers.Geometry.Point"){b=this.createElementNS(this.georssns,"georss:point");b.appendChild(this.buildCoordinatesNode(a))}else throw"Couldn't parse "+
a.CLASS_NAME;return b},buildCoordinatesNode:function(a){var b=null;if(a.components)b=a.components;if(b){a=b.length;for(var c=Array(a),d=0;d<a;d++)c[d]=b[d].y+" "+b[d].x;b=c.join(" ")}else b=a.y+" "+a.x;return this.createTextNode(b)},CLASS_NAME:"OpenLayers.Format.GeoRSS"});
OpenLayers.Layer.Google=OpenLayers.Class(OpenLayers.Layer.EventPane,OpenLayers.Layer.FixedZoomLevels,{MIN_ZOOM_LEVEL:0,MAX_ZOOM_LEVEL:21,RESOLUTIONS:[1.40625,0.703125,0.3515625,0.17578125,0.087890625,0.0439453125,0.02197265625,0.010986328125,0.0054931640625,0.00274658203125,0.001373291015625,6.866455078125E-4,3.4332275390625E-4,1.71661376953125E-4,8.58306884765625E-5,4.291534423828125E-5,2.145767211914062E-5,1.072883605957031E-5,5.36441802978515E-6,2.68220901489257E-6,1.341104507446289E-6,6.705522537231445E-7],
type:null,wrapDateLine:true,sphericalMercator:false,version:null,initialize:function(a,b){b=b||{};if(!b.version)b.version=typeof GMap2==="function"?"2":"3";var c=OpenLayers.Layer.Google["v"+b.version.replace(/\./g,"_")];if(c)OpenLayers.Util.applyDefaults(b,c);else throw"Unsupported Google Maps API version: "+b.version;OpenLayers.Util.applyDefaults(b,c.DEFAULTS);if(b.maxExtent)b.maxExtent=b.maxExtent.clone();OpenLayers.Layer.EventPane.prototype.initialize.apply(this,[a,b]);OpenLayers.Layer.FixedZoomLevels.prototype.initialize.apply(this,
[a,b]);if(this.sphericalMercator){OpenLayers.Util.extend(this,OpenLayers.Layer.SphericalMercator);this.initMercatorParameters()}},clone:function(){return new OpenLayers.Layer.Google(this.name,this.getOptions())},setVisibility:function(){var a=this.opacity==null?1:this.opacity;OpenLayers.Layer.EventPane.prototype.setVisibility.apply(this,arguments);this.setOpacity(a)},display:function(a){this._dragging||this.setGMapVisibility(a);OpenLayers.Layer.EventPane.prototype.display.apply(this,arguments)},moveTo:function(a,
b,c){this._dragging=c;OpenLayers.Layer.EventPane.prototype.moveTo.apply(this,arguments);delete this._dragging},setOpacity:function(a){if(a!==this.opacity){this.map!=null&&this.map.events.triggerEvent("changelayer",{layer:this,property:"opacity"});this.opacity=a}if(this.getVisibility()){var b=this.getMapContainer();OpenLayers.Util.modifyDOMElement(b,null,null,null,null,null,null,a)}},destroy:function(){if(this.map){this.setGMapVisibility(false);var a=OpenLayers.Layer.Google.cache[this.map.id];a&&a.count<=
1&&this.removeGMapElements()}OpenLayers.Layer.EventPane.prototype.destroy.apply(this,arguments)},removeGMapElements:function(){var a=OpenLayers.Layer.Google.cache[this.map.id];if(a){var b=this.mapObject&&this.getMapContainer();b&&b.parentNode&&b.parentNode.removeChild(b);(b=a.termsOfUse)&&b.parentNode&&b.parentNode.removeChild(b);(a=a.poweredBy)&&a.parentNode&&a.parentNode.removeChild(a)}},removeMap:function(a){this.visibility&&this.mapObject&&this.setGMapVisibility(false);var b=OpenLayers.Layer.Google.cache[a.id];
if(b)if(b.count<=1){this.removeGMapElements();delete OpenLayers.Layer.Google.cache[a.id]}else--b.count;delete this.termsOfUse;delete this.poweredBy;delete this.mapObject;delete this.dragObject;OpenLayers.Layer.EventPane.prototype.removeMap.apply(this,arguments)},getOLBoundsFromMapObjectBounds:function(a){var b=null;if(a!=null){b=a.getSouthWest();a=a.getNorthEast();if(this.sphericalMercator){b=this.forwardMercator(b.lng(),b.lat());a=this.forwardMercator(a.lng(),a.lat())}else{b=new OpenLayers.LonLat(b.lng(),
b.lat());a=new OpenLayers.LonLat(a.lng(),a.lat())}b=new OpenLayers.Bounds(b.lon,b.lat,a.lon,a.lat)}return b},getWarningHTML:function(){return OpenLayers.i18n("googleWarning")},getMapObjectCenter:function(){return this.mapObject.getCenter()},getMapObjectZoom:function(){return this.mapObject.getZoom()},getLongitudeFromMapObjectLonLat:function(a){return this.sphericalMercator?this.forwardMercator(a.lng(),a.lat()).lon:a.lng()},getLatitudeFromMapObjectLonLat:function(a){return this.sphericalMercator?this.forwardMercator(a.lng(),
a.lat()).lat:a.lat()},getXFromMapObjectPixel:function(a){return a.x},getYFromMapObjectPixel:function(a){return a.y},CLASS_NAME:"OpenLayers.Layer.Google"});OpenLayers.Layer.Google.cache={};
OpenLayers.Layer.Google.v2={termsOfUse:null,poweredBy:null,dragObject:null,loadMapObject:function(){if(!this.type)this.type=G_NORMAL_MAP;var a,b,c,d=OpenLayers.Layer.Google.cache[this.map.id];if(d){a=d.mapObject;b=d.termsOfUse;c=d.poweredBy;++d.count}else{d=this.map.viewPortDiv;var e=document.createElement("div");e.id=this.map.id+"_GMap2Container";e.style.position="absolute";e.style.width="100%";e.style.height="100%";d.appendChild(e);try{a=new GMap2(e);b=e.lastChild;d.appendChild(b);b.style.zIndex=
"1100";b.style.right="";b.style.bottom="";b.className="olLayerGoogleCopyright";c=e.lastChild;d.appendChild(c);c.style.zIndex="1100";c.style.right="";c.style.bottom="";c.className="olLayerGooglePoweredBy gmnoprint"}catch(f){throw f;}OpenLayers.Layer.Google.cache[this.map.id]={mapObject:a,termsOfUse:b,poweredBy:c,count:1}}this.mapObject=a;this.termsOfUse=b;this.poweredBy=c;OpenLayers.Util.indexOf(this.mapObject.getMapTypes(),this.type)===-1&&this.mapObject.addMapType(this.type);if(typeof a.getDragObject==
"function")this.dragObject=a.getDragObject();else this.dragPanMapObject=null;this.isBaseLayer===false&&this.setGMapVisibility(this.div.style.display!=="none")},onMapResize:function(){if(this.visibility&&this.mapObject.isLoaded())this.mapObject.checkResize();else{if(!this._resized)var a=this,b=GEvent.addListener(this.mapObject,"load",function(){GEvent.removeListener(b);delete a._resized;a.mapObject.checkResize();a.moveTo(a.map.getCenter(),a.map.getZoom())});this._resized=true}},setGMapVisibility:function(a){var b=
OpenLayers.Layer.Google.cache[this.map.id];if(b){var c=this.mapObject.getContainer();if(a===true){this.mapObject.setMapType(this.type);c.style.display="";this.termsOfUse.style.left="";this.termsOfUse.style.display="";this.poweredBy.style.display="";b.displayed=this.id}else{b.displayed===this.id&&delete b.displayed;if(!b.displayed){c.style.display="none";this.termsOfUse.style.display="none";this.termsOfUse.style.left="-9999px";this.poweredBy.style.display="none"}}}},getMapContainer:function(){return this.mapObject.getContainer()},
getMapObjectBoundsFromOLBounds:function(a){var b=null;if(a!=null){b=this.sphericalMercator?this.inverseMercator(a.bottom,a.left):new OpenLayers.LonLat(a.bottom,a.left);a=this.sphericalMercator?this.inverseMercator(a.top,a.right):new OpenLayers.LonLat(a.top,a.right);b=new GLatLngBounds(new GLatLng(b.lat,b.lon),new GLatLng(a.lat,a.lon))}return b},setMapObjectCenter:function(a,b){this.mapObject.setCenter(a,b)},dragPanMapObject:function(a,b){this.dragObject.moveBy(new GSize(-a,b))},getMapObjectLonLatFromMapObjectPixel:function(a){return this.mapObject.fromContainerPixelToLatLng(a)},
getMapObjectPixelFromMapObjectLonLat:function(a){return this.mapObject.fromLatLngToContainerPixel(a)},getMapObjectZoomFromMapObjectBounds:function(a){return this.mapObject.getBoundsZoomLevel(a)},getMapObjectLonLatFromLonLat:function(a,b){var c;if(this.sphericalMercator){c=this.inverseMercator(a,b);c=new GLatLng(c.lat,c.lon)}else c=new GLatLng(b,a);return c},getMapObjectPixelFromXY:function(a,b){return new GPoint(a,b)}};
OpenLayers.Format.WFST=function(a){a=OpenLayers.Util.applyDefaults(a,OpenLayers.Format.WFST.DEFAULTS);var b=OpenLayers.Format.WFST["v"+a.version.replace(/\./g,"_")];if(!b)throw"Unsupported WFST version: "+a.version;return new b(a)};OpenLayers.Format.WFST.DEFAULTS={version:"1.0.0"};
OpenLayers.Format.WFST.v1=OpenLayers.Class(OpenLayers.Format.XML,{namespaces:{xlink:"http://www.w3.org/1999/xlink",xsi:"http://www.w3.org/2001/XMLSchema-instance",wfs:"http://www.opengis.net/wfs",gml:"http://www.opengis.net/gml",ogc:"http://www.opengis.net/ogc",ows:"http://www.opengis.net/ows"},defaultPrefix:"wfs",version:null,schemaLocations:null,srsName:null,extractAttributes:true,xy:true,stateName:null,initialize:function(a){this.stateName={};this.stateName[OpenLayers.State.INSERT]="wfs:Insert";
this.stateName[OpenLayers.State.UPDATE]="wfs:Update";this.stateName[OpenLayers.State.DELETE]="wfs:Delete";OpenLayers.Format.XML.prototype.initialize.apply(this,[a])},getSrsName:function(a,b){var c=b&&b.srsName;c||(c=a&&a.layer?a.layer.projection.getCode():this.srsName);return c},read:function(a,b){b=b||{};OpenLayers.Util.applyDefaults(b,{output:"features"});if(typeof a=="string")a=OpenLayers.Format.XML.prototype.read.apply(this,[a]);if(a&&a.nodeType==9)a=a.documentElement;var c={};a&&this.readNode(a,
c,true);if(c.features&&b.output==="features")c=c.features;return c},readers:{wfs:{FeatureCollection:function(a,b){b.features=[];this.readChildNodes(a,b)}}},write:function(a,b){var c=this.writeNode("wfs:Transaction",{features:a,options:b}),d=this.schemaLocationAttr();d&&this.setAttributeNS(c,this.namespaces.xsi,"xsi:schemaLocation",d);return OpenLayers.Format.XML.prototype.write.apply(this,[c])},writers:{wfs:{GetFeature:function(a){var b=this.createElementNSPlus("wfs:GetFeature",{attributes:{service:"WFS",
version:this.version,handle:a&&a.handle,outputFormat:a&&a.outputFormat,maxFeatures:a&&a.maxFeatures,"xsi:schemaLocation":this.schemaLocationAttr(a)}});if(typeof this.featureType=="string")this.writeNode("Query",a,b);else for(var c=0,d=this.featureType.length;c<d;c++){a.featureType=this.featureType[c];this.writeNode("Query",a,b)}return b},Transaction:function(a){a=a||{};var b=a.options||{},c=this.createElementNSPlus("wfs:Transaction",{attributes:{service:"WFS",version:this.version,handle:b.handle}}),
d,e=a.features;if(e){if(b.multi===true)OpenLayers.Util.extend(this.geometryTypes,{"OpenLayers.Geometry.Point":"MultiPoint","OpenLayers.Geometry.LineString":this.multiCurve===true?"MultiCurve":"MultiLineString","OpenLayers.Geometry.Polygon":this.multiSurface===true?"MultiSurface":"MultiPolygon"});var f,g;a=0;for(d=e.length;a<d;++a){g=e[a];(f=this.stateName[g.state])&&this.writeNode(f,{feature:g,options:b},c)}b.multi===true&&this.setGeometryTypes()}if(b.nativeElements){a=0;for(d=b.nativeElements.length;a<
d;++a)this.writeNode("wfs:Native",b.nativeElements[a],c)}return c},Native:function(a){return this.createElementNSPlus("wfs:Native",{attributes:{vendorId:a.vendorId,safeToIgnore:a.safeToIgnore},value:a.value})},Insert:function(a){var b=a.feature;a=a.options;a=this.createElementNSPlus("wfs:Insert",{attributes:{handle:a&&a.handle}});this.srsName=this.getSrsName(b);this.writeNode("feature:_typeName",b,a);return a},Update:function(a){var b=a.feature;a=a.options;a=this.createElementNSPlus("wfs:Update",
{attributes:{handle:a&&a.handle,typeName:(this.featureNS?this.featurePrefix+":":"")+this.featureType}});this.featureNS&&a.setAttribute("xmlns:"+this.featurePrefix,this.featureNS);var c=b.modified;if(this.geometryName!==null&&(!c||c.geometry!==undefined)){this.srsName=this.getSrsName(b);this.writeNode("Property",{name:this.geometryName,value:b.geometry},a)}for(var d in b.attributes)if(b.attributes[d]!==undefined&&(!c||!c.attributes||c.attributes&&c.attributes[d]!==undefined))this.writeNode("Property",
{name:d,value:b.attributes[d]},a);this.writeNode("ogc:Filter",new OpenLayers.Filter.FeatureId({fids:[b.fid]}),a);return a},Property:function(a){var b=this.createElementNSPlus("wfs:Property");this.writeNode("Name",a.name,b);a.value!==null&&this.writeNode("Value",a.value,b);return b},Name:function(a){return this.createElementNSPlus("wfs:Name",{value:a})},Value:function(a){var b;if(a instanceof OpenLayers.Geometry){b=this.createElementNSPlus("wfs:Value");a=this.writeNode("feature:_geometry",a).firstChild;
b.appendChild(a)}else b=this.createElementNSPlus("wfs:Value",{value:a});return b},Delete:function(a){var b=a.feature;a=a.options;a=this.createElementNSPlus("wfs:Delete",{attributes:{handle:a&&a.handle,typeName:(this.featureNS?this.featurePrefix+":":"")+this.featureType}});this.featureNS&&a.setAttribute("xmlns:"+this.featurePrefix,this.featureNS);this.writeNode("ogc:Filter",new OpenLayers.Filter.FeatureId({fids:[b.fid]}),a);return a}}},schemaLocationAttr:function(a){a=OpenLayers.Util.extend({featurePrefix:this.featurePrefix,
schema:this.schema},a);var b=OpenLayers.Util.extend({},this.schemaLocations);if(a.schema)b[a.featurePrefix]=a.schema;a=[];var c,d;for(d in b)(c=this.namespaces[d])&&a.push(c+" "+b[d]);return a.join(" ")||undefined},setFilterProperty:function(a){if(a.filters)for(var b=0,c=a.filters.length;b<c;++b)this.setFilterProperty(a.filters[b]);else if(a instanceof OpenLayers.Filter.Spatial)a.property=this.geometryName},CLASS_NAME:"OpenLayers.Format.WFST.v1"});
OpenLayers.Format.OGCExceptionReport=OpenLayers.Class(OpenLayers.Format.XML,{namespaces:{ogc:"http://www.opengis.net/ogc"},regExes:{trimSpace:/^\s*|\s*$/g,removeSpace:/\s*/g,splitSpace:/\s+/,trimComma:/\s*,\s*/g},defaultPrefix:"ogc",read:function(a){if(typeof a=="string")a=OpenLayers.Format.XML.prototype.read.apply(this,[a]);var b={exceptionReport:null};if(a.documentElement){this.readChildNodes(a,b);if(b.exceptionReport===null)b=(new OpenLayers.Format.OWSCommon).read(a)}return b},readers:{ogc:{ServiceExceptionReport:function(a,
b){b.exceptionReport={exceptions:[]};this.readChildNodes(a,b.exceptionReport)},ServiceException:function(a,b){var c={code:a.getAttribute("code"),locator:a.getAttribute("locator"),text:this.getChildValue(a)};b.exceptions.push(c)}}},CLASS_NAME:"OpenLayers.Format.OGCExceptionReport"});
OpenLayers.Format.XML.VersionedOGC=OpenLayers.Class(OpenLayers.Format.XML,{defaultVersion:null,version:null,profile:null,errorProperty:null,name:null,stringifyOutput:false,parser:null,initialize:function(a){OpenLayers.Format.XML.prototype.initialize.apply(this,[a]);a=this.CLASS_NAME;this.name=a.substring(a.lastIndexOf(".")+1)},getVersion:function(a,b){var c;if(a){c=this.version;if(!c){c=a.getAttribute("version");if(!c)c=this.defaultVersion}}else c=b&&b.version||this.version||this.defaultVersion;return c},
getParser:function(a){a=a||this.defaultVersion;var b=this.profile?"_"+this.profile:"";if(!this.parser||this.parser.VERSION!=a){var c=OpenLayers.Format[this.name]["v"+a.replace(/\./g,"_")+b];if(!c)throw"Can't find a "+this.name+" parser for version "+a+b;this.parser=new c(this.options)}return this.parser},write:function(a,b){this.parser=this.getParser(this.getVersion(null,b));var c=this.parser.write(a,b);return this.stringifyOutput===false?c:OpenLayers.Format.XML.prototype.write.apply(this,[c])},read:function(a,
b){if(typeof a=="string")a=OpenLayers.Format.XML.prototype.read.apply(this,[a]);var c=this.getVersion(a.documentElement);this.parser=this.getParser(c);var d=this.parser.read(a,b);if(this.errorProperty!==null&&d[this.errorProperty]===undefined){var e=new OpenLayers.Format.OGCExceptionReport;d.error=e.read(a)}d.version=c;return d},CLASS_NAME:"OpenLayers.Format.XML.VersionedOGC"});
OpenLayers.Style=OpenLayers.Class({id:null,name:null,title:null,description:null,layerName:null,isDefault:false,rules:null,context:null,defaultStyle:null,defaultsPerSymbolizer:false,propertyStyles:null,initialize:function(a,b){OpenLayers.Util.extend(this,b);this.rules=[];b&&b.rules&&this.addRules(b.rules);this.setDefaultStyle(a||OpenLayers.Feature.Vector.style["default"]);this.id=OpenLayers.Util.createUniqueID(this.CLASS_NAME+"_")},destroy:function(){for(var a=0,b=this.rules.length;a<b;a++){this.rules[a].destroy();
this.rules[a]=null}this.defaultStyle=this.rules=null},createSymbolizer:function(a){for(var b=this.defaultsPerSymbolizer?{}:this.createLiterals(OpenLayers.Util.extend({},this.defaultStyle),a),c=this.rules,d,e=[],f=false,g=0,h=c.length;g<h;g++){d=c[g];if(d.evaluate(a))if(d instanceof OpenLayers.Rule&&d.elseFilter)e.push(d);else{f=true;this.applySymbolizer(d,b,a)}}if(f==false&&e.length>0){f=true;g=0;for(h=e.length;g<h;g++)this.applySymbolizer(e[g],b,a)}if(c.length>0&&f==false)b.display="none";if(b.label&&
typeof b.label!=="string")b.label=String(b.label);return b},applySymbolizer:function(a,b,c){var d=c.geometry?this.getSymbolizerPrefix(c.geometry):OpenLayers.Style.SYMBOLIZER_PREFIXES[0];a=a.symbolizer[d]||a.symbolizer;if(this.defaultsPerSymbolizer===true){d=this.defaultStyle;OpenLayers.Util.applyDefaults(a,{pointRadius:d.pointRadius});if(a.stroke===true||a.graphic===true)OpenLayers.Util.applyDefaults(a,{strokeWidth:d.strokeWidth,strokeColor:d.strokeColor,strokeOpacity:d.strokeOpacity,strokeDashstyle:d.strokeDashstyle,
strokeLinecap:d.strokeLinecap});if(a.fill===true||a.graphic===true)OpenLayers.Util.applyDefaults(a,{fillColor:d.fillColor,fillOpacity:d.fillOpacity});a.graphic===true&&OpenLayers.Util.applyDefaults(a,{pointRadius:this.defaultStyle.pointRadius,externalGraphic:this.defaultStyle.externalGraphic,graphicName:this.defaultStyle.graphicName,graphicOpacity:this.defaultStyle.graphicOpacity,graphicWidth:this.defaultStyle.graphicWidth,graphicHeight:this.defaultStyle.graphicHeight,graphicXOffset:this.defaultStyle.graphicXOffset,
graphicYOffset:this.defaultStyle.graphicYOffset})}return this.createLiterals(OpenLayers.Util.extend(b,a),c)},createLiterals:function(a,b){var c=OpenLayers.Util.extend({},b.attributes||b.data);OpenLayers.Util.extend(c,this.context);for(var d in this.propertyStyles)a[d]=OpenLayers.Style.createLiteral(a[d],c,b,d);return a},findPropertyStyles:function(){var a={};this.addPropertyStyles(a,this.defaultStyle);for(var b=this.rules,c,d,e=0,f=b.length;e<f;e++){c=b[e].symbolizer;for(var g in c){d=c[g];if(typeof d==
"object")this.addPropertyStyles(a,d);else{this.addPropertyStyles(a,c);break}}}return a},addPropertyStyles:function(a,b){var c,d;for(d in b){c=b[d];if(typeof c=="string"&&c.match(/\$\{\w+\}/))a[d]=true}return a},addRules:function(a){Array.prototype.push.apply(this.rules,a);this.propertyStyles=this.findPropertyStyles()},setDefaultStyle:function(a){this.defaultStyle=a;this.propertyStyles=this.findPropertyStyles()},getSymbolizerPrefix:function(a){for(var b=OpenLayers.Style.SYMBOLIZER_PREFIXES,c=0,d=b.length;c<
d;c++)if(a.CLASS_NAME.indexOf(b[c])!=-1)return b[c]},clone:function(){var a=OpenLayers.Util.extend({},this);if(this.rules){a.rules=[];for(var b=0,c=this.rules.length;b<c;++b)a.rules.push(this.rules[b].clone())}a.context=this.context&&OpenLayers.Util.extend({},this.context);b=OpenLayers.Util.extend({},this.defaultStyle);return new OpenLayers.Style(b,a)},CLASS_NAME:"OpenLayers.Style"});
OpenLayers.Style.createLiteral=function(a,b,c,d){if(typeof a=="string"&&a.indexOf("${")!=-1){a=OpenLayers.String.format(a,b,[c,d]);a=isNaN(a)||!a?a:parseFloat(a)}return a};OpenLayers.Style.SYMBOLIZER_PREFIXES=["Point","Line","Polygon","Text","Raster"];OpenLayers.Filter=OpenLayers.Class({initialize:function(a){OpenLayers.Util.extend(this,a)},destroy:function(){},evaluate:function(){return true},clone:function(){return null},CLASS_NAME:"OpenLayers.Filter"});
OpenLayers.Filter.FeatureId=OpenLayers.Class(OpenLayers.Filter,{fids:null,type:"FID",initialize:function(a){this.fids=[];OpenLayers.Filter.prototype.initialize.apply(this,[a])},evaluate:function(a){for(var b=0,c=this.fids.length;b<c;b++)if((a.fid||a.id)==this.fids[b])return true;return false},clone:function(){var a=new OpenLayers.Filter.FeatureId;OpenLayers.Util.extend(a,this);a.fids=this.fids.slice();return a},CLASS_NAME:"OpenLayers.Filter.FeatureId"});
OpenLayers.Filter.Logical=OpenLayers.Class(OpenLayers.Filter,{filters:null,type:null,initialize:function(a){this.filters=[];OpenLayers.Filter.prototype.initialize.apply(this,[a])},destroy:function(){this.filters=null;OpenLayers.Filter.prototype.destroy.apply(this)},evaluate:function(a){var b,c;switch(this.type){case OpenLayers.Filter.Logical.AND:b=0;for(c=this.filters.length;b<c;b++)if(this.filters[b].evaluate(a)==false)return false;return true;case OpenLayers.Filter.Logical.OR:b=0;for(c=this.filters.length;b<
c;b++)if(this.filters[b].evaluate(a)==true)return true;return false;case OpenLayers.Filter.Logical.NOT:return!this.filters[0].evaluate(a)}},clone:function(){for(var a=[],b=0,c=this.filters.length;b<c;++b)a.push(this.filters[b].clone());return new OpenLayers.Filter.Logical({type:this.type,filters:a})},CLASS_NAME:"OpenLayers.Filter.Logical"});OpenLayers.Filter.Logical.AND="&&";OpenLayers.Filter.Logical.OR="||";OpenLayers.Filter.Logical.NOT="!";
OpenLayers.Filter.Comparison=OpenLayers.Class(OpenLayers.Filter,{type:null,property:null,value:null,matchCase:true,lowerBoundary:null,upperBoundary:null,initialize:function(a){OpenLayers.Filter.prototype.initialize.apply(this,[a]);if(this.type===OpenLayers.Filter.Comparison.LIKE&&a.matchCase===undefined)this.matchCase=null},evaluate:function(a){if(a instanceof OpenLayers.Feature.Vector)a=a.attributes;var b=false;a=a[this.property];switch(this.type){case OpenLayers.Filter.Comparison.EQUAL_TO:b=this.value;
b=!this.matchCase&&typeof a=="string"&&typeof b=="string"?a.toUpperCase()==b.toUpperCase():a==b;break;case OpenLayers.Filter.Comparison.NOT_EQUAL_TO:b=this.value;b=!this.matchCase&&typeof a=="string"&&typeof b=="string"?a.toUpperCase()!=b.toUpperCase():a!=b;break;case OpenLayers.Filter.Comparison.LESS_THAN:b=a<this.value;break;case OpenLayers.Filter.Comparison.GREATER_THAN:b=a>this.value;break;case OpenLayers.Filter.Comparison.LESS_THAN_OR_EQUAL_TO:b=a<=this.value;break;case OpenLayers.Filter.Comparison.GREATER_THAN_OR_EQUAL_TO:b=
a>=this.value;break;case OpenLayers.Filter.Comparison.BETWEEN:b=a>=this.lowerBoundary&&a<=this.upperBoundary;break;case OpenLayers.Filter.Comparison.LIKE:b=RegExp(this.value,"gi").test(a)}return b},value2regex:function(a,b,c){if(a=="."){OpenLayers.Console.error("'.' is an unsupported wildCard character for OpenLayers.Filter.Comparison");return null}a=a?a:"*";b=b?b:".";this.value=this.value.replace(RegExp("\\"+(c?c:"!")+"(.|$)","g"),"\\$1");this.value=this.value.replace(RegExp("\\"+b,"g"),".");this.value=
this.value.replace(RegExp("\\"+a,"g"),".*");this.value=this.value.replace(RegExp("\\\\.\\*","g"),"\\"+a);return this.value=this.value.replace(RegExp("\\\\\\.","g"),"\\"+b)},regex2value:function(){var a=this.value;a=a.replace(/!/g,"!!");a=a.replace(/(\\)?\\\./g,function(b,c){return c?b:"!."});a=a.replace(/(\\)?\\\*/g,function(b,c){return c?b:"!*"});a=a.replace(/\\\\/g,"\\");return a=a.replace(/\.\*/g,"*")},clone:function(){return OpenLayers.Util.extend(new OpenLayers.Filter.Comparison,this)},CLASS_NAME:"OpenLayers.Filter.Comparison"});
OpenLayers.Filter.Comparison.EQUAL_TO="==";OpenLayers.Filter.Comparison.NOT_EQUAL_TO="!=";OpenLayers.Filter.Comparison.LESS_THAN="<";OpenLayers.Filter.Comparison.GREATER_THAN=">";OpenLayers.Filter.Comparison.LESS_THAN_OR_EQUAL_TO="<=";OpenLayers.Filter.Comparison.GREATER_THAN_OR_EQUAL_TO=">=";OpenLayers.Filter.Comparison.BETWEEN="..";OpenLayers.Filter.Comparison.LIKE="~";OpenLayers.Format.Filter=OpenLayers.Class(OpenLayers.Format.XML.VersionedOGC,{defaultVersion:"1.0.0",CLASS_NAME:"OpenLayers.Format.Filter"});
OpenLayers.Filter.Function=OpenLayers.Class(OpenLayers.Filter,{name:null,params:null,initialize:function(a){OpenLayers.Filter.prototype.initialize.apply(this,[a])},CLASS_NAME:"OpenLayers.Filter.Function"});
OpenLayers.Format.Filter.v1=OpenLayers.Class(OpenLayers.Format.XML,{namespaces:{ogc:"http://www.opengis.net/ogc",gml:"http://www.opengis.net/gml",xlink:"http://www.w3.org/1999/xlink",xsi:"http://www.w3.org/2001/XMLSchema-instance"},defaultPrefix:"ogc",schemaLocation:null,initialize:function(a){OpenLayers.Format.XML.prototype.initialize.apply(this,[a])},read:function(a){var b={};this.readers.ogc.Filter.apply(this,[a,b]);return b.filter},readers:{ogc:{Filter:function(a,b){var c={fids:[],filters:[]};
this.readChildNodes(a,c);if(c.fids.length>0)b.filter=new OpenLayers.Filter.FeatureId({fids:c.fids});else if(c.filters.length>0)b.filter=c.filters[0]},FeatureId:function(a,b){var c=a.getAttribute("fid");c&&b.fids.push(c)},And:function(a,b){var c=new OpenLayers.Filter.Logical({type:OpenLayers.Filter.Logical.AND});this.readChildNodes(a,c);b.filters.push(c)},Or:function(a,b){var c=new OpenLayers.Filter.Logical({type:OpenLayers.Filter.Logical.OR});this.readChildNodes(a,c);b.filters.push(c)},Not:function(a,
b){var c=new OpenLayers.Filter.Logical({type:OpenLayers.Filter.Logical.NOT});this.readChildNodes(a,c);b.filters.push(c)},PropertyIsLessThan:function(a,b){var c=new OpenLayers.Filter.Comparison({type:OpenLayers.Filter.Comparison.LESS_THAN});this.readChildNodes(a,c);b.filters.push(c)},PropertyIsGreaterThan:function(a,b){var c=new OpenLayers.Filter.Comparison({type:OpenLayers.Filter.Comparison.GREATER_THAN});this.readChildNodes(a,c);b.filters.push(c)},PropertyIsLessThanOrEqualTo:function(a,b){var c=
new OpenLayers.Filter.Comparison({type:OpenLayers.Filter.Comparison.LESS_THAN_OR_EQUAL_TO});this.readChildNodes(a,c);b.filters.push(c)},PropertyIsGreaterThanOrEqualTo:function(a,b){var c=new OpenLayers.Filter.Comparison({type:OpenLayers.Filter.Comparison.GREATER_THAN_OR_EQUAL_TO});this.readChildNodes(a,c);b.filters.push(c)},PropertyIsBetween:function(a,b){var c=new OpenLayers.Filter.Comparison({type:OpenLayers.Filter.Comparison.BETWEEN});this.readChildNodes(a,c);b.filters.push(c)},Literal:function(a,
b){b.value=OpenLayers.String.numericIf(this.getChildValue(a))},PropertyName:function(a,b){b.property=this.getChildValue(a)},LowerBoundary:function(a,b){b.lowerBoundary=OpenLayers.String.numericIf(this.readOgcExpression(a))},UpperBoundary:function(a,b){b.upperBoundary=OpenLayers.String.numericIf(this.readOgcExpression(a))},Intersects:function(a,b){this.readSpatial(a,b,OpenLayers.Filter.Spatial.INTERSECTS)},Within:function(a,b){this.readSpatial(a,b,OpenLayers.Filter.Spatial.WITHIN)},Contains:function(a,
b){this.readSpatial(a,b,OpenLayers.Filter.Spatial.CONTAINS)},DWithin:function(a,b){this.readSpatial(a,b,OpenLayers.Filter.Spatial.DWITHIN)},Distance:function(a,b){b.distance=parseInt(this.getChildValue(a));b.distanceUnits=a.getAttribute("units")},Function:function(){}}},readSpatial:function(a,b,c){c=new OpenLayers.Filter.Spatial({type:c});this.readChildNodes(a,c);c.value=c.components[0];delete c.components;b.filters.push(c)},readOgcExpression:function(a){var b={};this.readChildNodes(a,b);b=b.value;
if(b===undefined)b=this.getChildValue(a);return b},writeOgcExpression:function(a,b){if(a instanceof OpenLayers.Filter.Function){var c=this.writeNode("Function",a,b);b.appendChild(c)}else this.writeNode("Literal",a,b);return b},write:function(a){return this.writers.ogc.Filter.apply(this,[a])},writeFeatureIdNodes:function(a,b){for(var c=0,d=a.fids.length;c<d;++c)this.writeNode("FeatureId",a.fids[c],b)},writers:{ogc:{Filter:function(a){var b=this.createElementNSPlus("ogc:Filter");a.type==="FID"?this.writeFeatureIdNodes(a,
b):this.writeNode(this.getFilterType(a),a,b);return b},FeatureId:function(a){return this.createElementNSPlus("ogc:FeatureId",{attributes:{fid:a}})},And:function(a){for(var b=this.createElementNSPlus("ogc:And"),c,d=0,e=a.filters.length;d<e;++d){c=a.filters[d];c.type==="FID"?this.writeFeatureIdNodes(c,b):this.writeNode(this.getFilterType(c),c,b)}return b},Or:function(a){for(var b=this.createElementNSPlus("ogc:Or"),c,d=0,e=a.filters.length;d<e;++d){c=a.filters[d];c.type==="FID"?this.writeFeatureIdNodes(c,
b):this.writeNode(this.getFilterType(c),c,b)}return b},Not:function(a){var b=this.createElementNSPlus("ogc:Not");a=a.filters[0];a.type==="FID"?this.writeFeatureIdNodes(a,b):this.writeNode(this.getFilterType(a),a,b);return b},PropertyIsLessThan:function(a){var b=this.createElementNSPlus("ogc:PropertyIsLessThan");this.writeNode("PropertyName",a,b);this.writeOgcExpression(a.value,b);return b},PropertyIsGreaterThan:function(a){var b=this.createElementNSPlus("ogc:PropertyIsGreaterThan");this.writeNode("PropertyName",
a,b);this.writeOgcExpression(a.value,b);return b},PropertyIsLessThanOrEqualTo:function(a){var b=this.createElementNSPlus("ogc:PropertyIsLessThanOrEqualTo");this.writeNode("PropertyName",a,b);this.writeOgcExpression(a.value,b);return b},PropertyIsGreaterThanOrEqualTo:function(a){var b=this.createElementNSPlus("ogc:PropertyIsGreaterThanOrEqualTo");this.writeNode("PropertyName",a,b);this.writeOgcExpression(a.value,b);return b},PropertyIsBetween:function(a){var b=this.createElementNSPlus("ogc:PropertyIsBetween");
this.writeNode("PropertyName",a,b);this.writeNode("LowerBoundary",a,b);this.writeNode("UpperBoundary",a,b);return b},PropertyName:function(a){return this.createElementNSPlus("ogc:PropertyName",{value:a.property})},Literal:function(a){return this.createElementNSPlus("ogc:Literal",{value:a})},LowerBoundary:function(a){var b=this.createElementNSPlus("ogc:LowerBoundary");this.writeOgcExpression(a.lowerBoundary,b);return b},UpperBoundary:function(a){var b=this.createElementNSPlus("ogc:UpperBoundary");
this.writeNode("Literal",a.upperBoundary,b);return b},INTERSECTS:function(a){return this.writeSpatial(a,"Intersects")},WITHIN:function(a){return this.writeSpatial(a,"Within")},CONTAINS:function(a){return this.writeSpatial(a,"Contains")},DWITHIN:function(a){var b=this.writeSpatial(a,"DWithin");this.writeNode("Distance",a,b);return b},Distance:function(a){return this.createElementNSPlus("ogc:Distance",{attributes:{units:a.distanceUnits},value:a.distance})},Function:function(a){var b=this.createElementNSPlus("ogc:Function",
{attributes:{name:a.name}});a=a.params;for(var c=0,d=a.length;c<d;c++)this.writeOgcExpression(a[c],b);return b}}},getFilterType:function(a){var b=this.filterMap[a.type];if(!b)throw"Filter writing not supported for rule type: "+a.type;return b},filterMap:{"&&":"And","||":"Or","!":"Not","==":"PropertyIsEqualTo","!=":"PropertyIsNotEqualTo","<":"PropertyIsLessThan",">":"PropertyIsGreaterThan","<=":"PropertyIsLessThanOrEqualTo",">=":"PropertyIsGreaterThanOrEqualTo","..":"PropertyIsBetween","~":"PropertyIsLike",
BBOX:"BBOX",DWITHIN:"DWITHIN",WITHIN:"WITHIN",CONTAINS:"CONTAINS",INTERSECTS:"INTERSECTS",FID:"FeatureId"},CLASS_NAME:"OpenLayers.Format.Filter.v1"});
OpenLayers.Geometry.MultiLineString=OpenLayers.Class(OpenLayers.Geometry.Collection,{componentTypes:["OpenLayers.Geometry.LineString"],initialize:function(){OpenLayers.Geometry.Collection.prototype.initialize.apply(this,arguments)},split:function(a,b){for(var c=null,d=b&&b.mutual,e,f,g,h,j=[],i=[a],k=0,l=this.components.length;k<l;++k){f=this.components[k];g=false;for(var m=0;m<i.length;++m)if(e=f.split(i[m],b)){if(d){g=e[0];for(var n=0,p=g.length;n<p;++n)n===0&&j.length?j[j.length-1].addComponent(g[n]):
j.push(new OpenLayers.Geometry.MultiLineString([g[n]]));g=true;e=e[1]}if(e.length){e.unshift(m,1);Array.prototype.splice.apply(i,e);break}}if(!g)if(j.length)j[j.length-1].addComponent(f.clone());else j=[new OpenLayers.Geometry.MultiLineString(f.clone())]}if(j&&j.length>1)g=true;else j=[];if(i&&i.length>1)h=true;else i=[];if(g||h)c=d?[j,i]:i;return c},splitWith:function(a,b){var c=null,d=b&&b.mutual,e,f,g,h,j,i;if(a instanceof OpenLayers.Geometry.LineString){i=[];j=[a];for(var k=0,l=this.components.length;k<
l;++k){g=false;f=this.components[k];for(var m=0;m<j.length;++m)if(e=j[m].split(f,b)){if(d){g=e[0];if(g.length){g.unshift(m,1);Array.prototype.splice.apply(j,g);m+=g.length-2}e=e[1];if(e.length===0)e=[f.clone()]}g=0;for(var n=e.length;g<n;++g)g===0&&i.length?i[i.length-1].addComponent(e[g]):i.push(new OpenLayers.Geometry.MultiLineString([e[g]]));g=true}if(!g)if(i.length)i[i.length-1].addComponent(f.clone());else i=[new OpenLayers.Geometry.MultiLineString([f.clone()])]}}else c=a.split(this);if(j&&j.length>
1)h=true;else j=[];if(i&&i.length>1)g=true;else i=[];if(h||g)c=d?[j,i]:i;return c},CLASS_NAME:"OpenLayers.Geometry.MultiLineString"});OpenLayers.Geometry.MultiPolygon=OpenLayers.Class(OpenLayers.Geometry.Collection,{componentTypes:["OpenLayers.Geometry.Polygon"],initialize:function(){OpenLayers.Geometry.Collection.prototype.initialize.apply(this,arguments)},CLASS_NAME:"OpenLayers.Geometry.MultiPolygon"});
OpenLayers.Format.GML=OpenLayers.Class(OpenLayers.Format.XML,{featureNS:"http://mapserver.gis.umn.edu/mapserver",featurePrefix:"feature",featureName:"featureMember",layerName:"features",geometryName:"geometry",collectionName:"FeatureCollection",gmlns:"http://www.opengis.net/gml",extractAttributes:true,xy:true,initialize:function(a){this.regExes={trimSpace:/^\s*|\s*$/g,removeSpace:/\s*/g,splitSpace:/\s+/,trimComma:/\s*,\s*/g};OpenLayers.Format.XML.prototype.initialize.apply(this,[a])},read:function(a){if(typeof a==
"string")a=OpenLayers.Format.XML.prototype.read.apply(this,[a]);a=this.getElementsByTagNameNS(a.documentElement,this.gmlns,this.featureName);for(var b=[],c=0;c<a.length;c++){var d=this.parseFeature(a[c]);d&&b.push(d)}return b},parseFeature:function(a){var b=["MultiPolygon","Polygon","MultiLineString","LineString","MultiPoint","Point","Envelope"],c,d,e,f;for(f=0;f<b.length;++f){c=b[f];d=this.getElementsByTagNameNS(a,this.gmlns,c);if(d.length>0){if(f=this.parseGeometry[c.toLowerCase()]){e=f.apply(this,
[d[0]]);this.internalProjection&&this.externalProjection&&e.transform(this.externalProjection,this.internalProjection)}else OpenLayers.Console.error(OpenLayers.i18n("unsupportedGeometryType",{geomType:c}));break}}var g;c=this.getElementsByTagNameNS(a,this.gmlns,"Box");for(f=0;f<c.length;++f){b=c[f];d=this.parseGeometry.box.apply(this,[b]);b=b.parentNode;if((b.localName||b.nodeName.split(":").pop())==="boundedBy")g=d;else e=d.toGeometry()}var h;if(this.extractAttributes)h=this.parseAttributes(a);e=
new OpenLayers.Feature.Vector(e,h);e.bounds=g;e.gml={featureType:a.firstChild.nodeName.split(":")[1],featureNS:a.firstChild.namespaceURI,featureNSPrefix:a.firstChild.prefix};a=a.firstChild;for(var j;a;){if(a.nodeType==1)if(j=a.getAttribute("fid")||a.getAttribute("id"))break;a=a.nextSibling}e.fid=j;return e},parseGeometry:{point:function(a){var b,c;c=[];b=this.getElementsByTagNameNS(a,this.gmlns,"pos");if(b.length>0){c=b[0].firstChild.nodeValue;c=c.replace(this.regExes.trimSpace,"");c=c.split(this.regExes.splitSpace)}if(c.length==
0){b=this.getElementsByTagNameNS(a,this.gmlns,"coordinates");if(b.length>0){c=b[0].firstChild.nodeValue;c=c.replace(this.regExes.removeSpace,"");c=c.split(",")}}if(c.length==0){b=this.getElementsByTagNameNS(a,this.gmlns,"coord");if(b.length>0){a=this.getElementsByTagNameNS(b[0],this.gmlns,"X");b=this.getElementsByTagNameNS(b[0],this.gmlns,"Y");if(a.length>0&&b.length>0)c=[a[0].firstChild.nodeValue,b[0].firstChild.nodeValue]}}if(c.length==2)c[2]=null;return this.xy?new OpenLayers.Geometry.Point(c[0],
c[1],c[2]):new OpenLayers.Geometry.Point(c[1],c[0],c[2])},multipoint:function(a){a=this.getElementsByTagNameNS(a,this.gmlns,"Point");var b=[];if(a.length>0)for(var c,d=0;d<a.length;++d)(c=this.parseGeometry.point.apply(this,[a[d]]))&&b.push(c);return new OpenLayers.Geometry.MultiPoint(b)},linestring:function(a,b){var c,d;d=[];var e=[];c=this.getElementsByTagNameNS(a,this.gmlns,"posList");if(c.length>0){d=this.getChildValue(c[0]);d=d.replace(this.regExes.trimSpace,"");d=d.split(this.regExes.splitSpace);
var f=parseInt(c[0].getAttribute("dimension")),g,h,j;for(c=0;c<d.length/f;++c){g=c*f;h=d[g];j=d[g+1];g=f==2?null:d[g+2];this.xy?e.push(new OpenLayers.Geometry.Point(h,j,g)):e.push(new OpenLayers.Geometry.Point(j,h,g))}}if(d.length==0){c=this.getElementsByTagNameNS(a,this.gmlns,"coordinates");if(c.length>0){d=this.getChildValue(c[0]);d=d.replace(this.regExes.trimSpace,"");d=d.replace(this.regExes.trimComma,",");f=d.split(this.regExes.splitSpace);for(c=0;c<f.length;++c){d=f[c].split(",");if(d.length==
2)d[2]=null;this.xy?e.push(new OpenLayers.Geometry.Point(d[0],d[1],d[2])):e.push(new OpenLayers.Geometry.Point(d[1],d[0],d[2]))}}}d=null;if(e.length!=0)d=b?new OpenLayers.Geometry.LinearRing(e):new OpenLayers.Geometry.LineString(e);return d},multilinestring:function(a){a=this.getElementsByTagNameNS(a,this.gmlns,"LineString");var b=[];if(a.length>0)for(var c,d=0;d<a.length;++d)(c=this.parseGeometry.linestring.apply(this,[a[d]]))&&b.push(c);return new OpenLayers.Geometry.MultiLineString(b)},polygon:function(a){a=
this.getElementsByTagNameNS(a,this.gmlns,"LinearRing");var b=[];if(a.length>0)for(var c,d=0;d<a.length;++d)(c=this.parseGeometry.linestring.apply(this,[a[d],true]))&&b.push(c);return new OpenLayers.Geometry.Polygon(b)},multipolygon:function(a){a=this.getElementsByTagNameNS(a,this.gmlns,"Polygon");var b=[];if(a.length>0)for(var c,d=0;d<a.length;++d)(c=this.parseGeometry.polygon.apply(this,[a[d]]))&&b.push(c);return new OpenLayers.Geometry.MultiPolygon(b)},envelope:function(a){var b=[],c,d,e=this.getElementsByTagNameNS(a,
this.gmlns,"lowerCorner");if(e.length>0){c=[];if(e.length>0){c=e[0].firstChild.nodeValue;c=c.replace(this.regExes.trimSpace,"");c=c.split(this.regExes.splitSpace)}if(c.length==2)c[2]=null;var f=this.xy?new OpenLayers.Geometry.Point(c[0],c[1],c[2]):new OpenLayers.Geometry.Point(c[1],c[0],c[2])}a=this.getElementsByTagNameNS(a,this.gmlns,"upperCorner");if(a.length>0){c=[];if(a.length>0){c=a[0].firstChild.nodeValue;c=c.replace(this.regExes.trimSpace,"");c=c.split(this.regExes.splitSpace)}if(c.length==
2)c[2]=null;var g=this.xy?new OpenLayers.Geometry.Point(c[0],c[1],c[2]):new OpenLayers.Geometry.Point(c[1],c[0],c[2])}if(f&&g){b.push(new OpenLayers.Geometry.Point(f.x,f.y));b.push(new OpenLayers.Geometry.Point(g.x,f.y));b.push(new OpenLayers.Geometry.Point(g.x,g.y));b.push(new OpenLayers.Geometry.Point(f.x,g.y));b.push(new OpenLayers.Geometry.Point(f.x,f.y));b=new OpenLayers.Geometry.LinearRing(b);d=new OpenLayers.Geometry.Polygon([b])}return d},box:function(a){var b=this.getElementsByTagNameNS(a,
this.gmlns,"coordinates");var c=a=null;if(b.length>0){b=b[0].firstChild.nodeValue;b=b.split(" ");if(b.length==2){a=b[0].split(",");c=b[1].split(",")}}if(a!==null&&c!==null)return new OpenLayers.Bounds(parseFloat(a[0]),parseFloat(a[1]),parseFloat(c[0]),parseFloat(c[1]))}},parseAttributes:function(a){var b={};a=a.firstChild;for(var c,d,e;a;){if(a.nodeType==1){a=a.childNodes;for(c=0;c<a.length;++c){d=a[c];if(d.nodeType==1){e=d.childNodes;if(e.length==1){e=e[0];if(e.nodeType==3||e.nodeType==4){d=d.prefix?
d.nodeName.split(":")[1]:d.nodeName;e=e.nodeValue.replace(this.regExes.trimSpace,"");b[d]=e}}else b[d.nodeName.split(":").pop()]=null}}break}a=a.nextSibling}return b},write:function(a){OpenLayers.Util.isArray(a)||(a=[a]);for(var b=this.createElementNS("http://www.opengis.net/wfs","wfs:"+this.collectionName),c=0;c<a.length;c++)b.appendChild(this.createFeatureXML(a[c]));return OpenLayers.Format.XML.prototype.write.apply(this,[b])},createFeatureXML:function(a){var b=this.buildGeometryNode(a.geometry),
c=this.createElementNS(this.featureNS,this.featurePrefix+":"+this.geometryName);c.appendChild(b);b=this.createElementNS(this.gmlns,"gml:"+this.featureName);var d=this.createElementNS(this.featureNS,this.featurePrefix+":"+this.layerName);d.setAttribute("fid",a.fid||a.id);d.appendChild(c);for(var e in a.attributes){c=this.createTextNode(a.attributes[e]);var f=this.createElementNS(this.featureNS,this.featurePrefix+":"+e.substring(e.lastIndexOf(":")+1));f.appendChild(c);d.appendChild(f)}b.appendChild(d);
return b},buildGeometryNode:function(a){if(this.externalProjection&&this.internalProjection){a=a.clone();a.transform(this.internalProjection,this.externalProjection)}var b=a.CLASS_NAME;return this.buildGeometry[b.substring(b.lastIndexOf(".")+1).toLowerCase()].apply(this,[a])},buildGeometry:{point:function(a){var b=this.createElementNS(this.gmlns,"gml:Point");b.appendChild(this.buildCoordinatesNode(a));return b},multipoint:function(a){var b=this.createElementNS(this.gmlns,"gml:MultiPoint");a=a.components;
for(var c,d,e=0;e<a.length;e++){c=this.createElementNS(this.gmlns,"gml:pointMember");d=this.buildGeometry.point.apply(this,[a[e]]);c.appendChild(d);b.appendChild(c)}return b},linestring:function(a){var b=this.createElementNS(this.gmlns,"gml:LineString");b.appendChild(this.buildCoordinatesNode(a));return b},multilinestring:function(a){var b=this.createElementNS(this.gmlns,"gml:MultiLineString");a=a.components;for(var c,d,e=0;e<a.length;++e){c=this.createElementNS(this.gmlns,"gml:lineStringMember");
d=this.buildGeometry.linestring.apply(this,[a[e]]);c.appendChild(d);b.appendChild(c)}return b},linearring:function(a){var b=this.createElementNS(this.gmlns,"gml:LinearRing");b.appendChild(this.buildCoordinatesNode(a));return b},polygon:function(a){var b=this.createElementNS(this.gmlns,"gml:Polygon");a=a.components;for(var c,d,e=0;e<a.length;++e){c=e==0?"outerBoundaryIs":"innerBoundaryIs";c=this.createElementNS(this.gmlns,"gml:"+c);d=this.buildGeometry.linearring.apply(this,[a[e]]);c.appendChild(d);
b.appendChild(c)}return b},multipolygon:function(a){var b=this.createElementNS(this.gmlns,"gml:MultiPolygon");a=a.components;for(var c,d,e=0;e<a.length;++e){c=this.createElementNS(this.gmlns,"gml:polygonMember");d=this.buildGeometry.polygon.apply(this,[a[e]]);c.appendChild(d);b.appendChild(c)}return b},bounds:function(a){var b=this.createElementNS(this.gmlns,"gml:Box");b.appendChild(this.buildCoordinatesNode(a));return b}},buildCoordinatesNode:function(a){var b=this.createElementNS(this.gmlns,"gml:coordinates");
b.setAttribute("decimal",".");b.setAttribute("cs",",");b.setAttribute("ts"," ");var c=[];if(a instanceof OpenLayers.Bounds){c.push(a.left+","+a.bottom);c.push(a.right+","+a.top)}else{a=a.components?a.components:[a];for(var d=0;d<a.length;d++)c.push(a[d].x+","+a[d].y)}c=this.createTextNode(c.join(" "));b.appendChild(c);return b},CLASS_NAME:"OpenLayers.Format.GML"});if(!OpenLayers.Format.GML)OpenLayers.Format.GML={};
OpenLayers.Format.GML.Base=OpenLayers.Class(OpenLayers.Format.XML,{namespaces:{gml:"http://www.opengis.net/gml",xlink:"http://www.w3.org/1999/xlink",xsi:"http://www.w3.org/2001/XMLSchema-instance",wfs:"http://www.opengis.net/wfs"},defaultPrefix:"gml",schemaLocation:null,featureType:null,featureNS:null,geometryName:"geometry",extractAttributes:true,srsName:null,xy:true,geometryTypes:null,singleFeatureType:null,regExes:{trimSpace:/^\s*|\s*$/g,removeSpace:/\s*/g,splitSpace:/\s+/,trimComma:/\s*,\s*/g,
featureMember:/^(.*:)?featureMembers?$/},initialize:function(a){OpenLayers.Format.XML.prototype.initialize.apply(this,[a]);this.setGeometryTypes();a&&a.featureNS&&this.setNamespace("feature",a.featureNS);this.singleFeatureType=!a||typeof a.featureType==="string"},read:function(a){if(typeof a=="string")a=OpenLayers.Format.XML.prototype.read.apply(this,[a]);if(a&&a.nodeType==9)a=a.documentElement;var b=[];this.readNode(a,{features:b},true);if(b.length==0){var c=this.getElementsByTagNameNS(a,this.namespaces.gml,
"featureMember");if(c.length){a=0;for(var d=c.length;a<d;++a)this.readNode(c[a],{features:b},true)}else{c=this.getElementsByTagNameNS(a,this.namespaces.gml,"featureMembers");c.length&&this.readNode(c[0],{features:b},true)}}return b},readNode:function(a,b,c){if(c===true&&this.autoConfig===true){this.featureType=null;delete this.namespaceAlias[this.featureNS];delete this.namespaces.feature;this.featureNS=null}if(!this.featureNS&&!(a.prefix in this.namespaces)&&a.parentNode.namespaceURI==this.namespaces.gml&&
this.regExes.featureMember.test(a.parentNode.nodeName)){this.featureType=a.nodeName.split(":").pop();this.setNamespace("feature",a.namespaceURI);this.featureNS=a.namespaceURI;this.autoConfig=true}return OpenLayers.Format.XML.prototype.readNode.apply(this,[a,b])},readers:{gml:{featureMember:function(a,b){this.readChildNodes(a,b)},featureMembers:function(a,b){this.readChildNodes(a,b)},name:function(a,b){b.name=this.getChildValue(a)},boundedBy:function(a,b){var c={};this.readChildNodes(a,c);if(c.components&&
c.components.length>0)b.bounds=c.components[0]},Point:function(a,b){var c={points:[]};this.readChildNodes(a,c);if(!b.components)b.components=[];b.components.push(c.points[0])},coordinates:function(a,b){var c=this.getChildValue(a).replace(this.regExes.trimSpace,"");c=c.replace(this.regExes.trimComma,",");c=c.split(this.regExes.splitSpace);for(var d,e=c.length,f=Array(e),g=0;g<e;++g){d=c[g].split(",");f[g]=this.xy?new OpenLayers.Geometry.Point(d[0],d[1],d[2]):new OpenLayers.Geometry.Point(d[1],d[0],
d[2])}b.points=f},coord:function(a,b){var c={};this.readChildNodes(a,c);if(!b.points)b.points=[];b.points.push(new OpenLayers.Geometry.Point(c.x,c.y,c.z))},X:function(a,b){b.x=this.getChildValue(a)},Y:function(a,b){b.y=this.getChildValue(a)},Z:function(a,b){b.z=this.getChildValue(a)},MultiPoint:function(a,b){var c={components:[]};this.readChildNodes(a,c);b.components=[new OpenLayers.Geometry.MultiPoint(c.components)]},pointMember:function(a,b){this.readChildNodes(a,b)},LineString:function(a,b){var c=
{};this.readChildNodes(a,c);if(!b.components)b.components=[];b.components.push(new OpenLayers.Geometry.LineString(c.points))},MultiLineString:function(a,b){var c={components:[]};this.readChildNodes(a,c);b.components=[new OpenLayers.Geometry.MultiLineString(c.components)]},lineStringMember:function(a,b){this.readChildNodes(a,b)},Polygon:function(a,b){var c={outer:null,inner:[]};this.readChildNodes(a,c);c.inner.unshift(c.outer);if(!b.components)b.components=[];b.components.push(new OpenLayers.Geometry.Polygon(c.inner))},
LinearRing:function(a,b){var c={};this.readChildNodes(a,c);b.components=[new OpenLayers.Geometry.LinearRing(c.points)]},MultiPolygon:function(a,b){var c={components:[]};this.readChildNodes(a,c);b.components=[new OpenLayers.Geometry.MultiPolygon(c.components)]},polygonMember:function(a,b){this.readChildNodes(a,b)},GeometryCollection:function(a,b){var c={components:[]};this.readChildNodes(a,c);b.components=[new OpenLayers.Geometry.Collection(c.components)]},geometryMember:function(a,b){this.readChildNodes(a,
b)}},feature:{"*":function(a,b){var c,d=a.localName||a.nodeName.split(":").pop();if(b.features)if(!this.singleFeatureType&&OpenLayers.Util.indexOf(this.featureType,d)!==-1)c="_typeName";else{if(d===this.featureType)c="_typeName"}else if(a.childNodes.length==0||a.childNodes.length==1&&a.firstChild.nodeType==3){if(this.extractAttributes)c="_attribute"}else c="_geometry";c&&this.readers.feature[c].apply(this,[a,b])},_typeName:function(a,b){var c={components:[],attributes:{}};this.readChildNodes(a,c);
if(c.name)c.attributes.name=c.name;var d=new OpenLayers.Feature.Vector(c.components[0],c.attributes);if(!this.singleFeatureType){d.type=a.nodeName.split(":").pop();d.namespace=a.namespaceURI}var e=a.getAttribute("fid")||this.getAttributeNS(a,this.namespaces.gml,"id");if(e)d.fid=e;this.internalProjection&&this.externalProjection&&d.geometry&&d.geometry.transform(this.externalProjection,this.internalProjection);if(c.bounds)d.bounds=c.bounds;b.features.push(d)},_geometry:function(a,b){if(!this.geometryName)this.geometryName=
a.nodeName.split(":").pop();this.readChildNodes(a,b)},_attribute:function(a,b){var c=a.localName||a.nodeName.split(":").pop(),d=this.getChildValue(a);b.attributes[c]=d}},wfs:{FeatureCollection:function(a,b){this.readChildNodes(a,b)}}},write:function(a){a=this.writeNode("gml:"+(OpenLayers.Util.isArray(a)?"featureMembers":"featureMember"),a);this.setAttributeNS(a,this.namespaces.xsi,"xsi:schemaLocation",this.schemaLocation);return OpenLayers.Format.XML.prototype.write.apply(this,[a])},writers:{gml:{featureMember:function(a){var b=
this.createElementNSPlus("gml:featureMember");this.writeNode("feature:_typeName",a,b);return b},MultiPoint:function(a){var b=this.createElementNSPlus("gml:MultiPoint");a=a.components||[a];for(var c=0,d=a.length;c<d;++c)this.writeNode("pointMember",a[c],b);return b},pointMember:function(a){var b=this.createElementNSPlus("gml:pointMember");this.writeNode("Point",a,b);return b},MultiLineString:function(a){var b=this.createElementNSPlus("gml:MultiLineString");a=a.components||[a];for(var c=0,d=a.length;c<
d;++c)this.writeNode("lineStringMember",a[c],b);return b},lineStringMember:function(a){var b=this.createElementNSPlus("gml:lineStringMember");this.writeNode("LineString",a,b);return b},MultiPolygon:function(a){var b=this.createElementNSPlus("gml:MultiPolygon");a=a.components||[a];for(var c=0,d=a.length;c<d;++c)this.writeNode("polygonMember",a[c],b);return b},polygonMember:function(a){var b=this.createElementNSPlus("gml:polygonMember");this.writeNode("Polygon",a,b);return b},GeometryCollection:function(a){for(var b=
this.createElementNSPlus("gml:GeometryCollection"),c=0,d=a.components.length;c<d;++c)this.writeNode("geometryMember",a.components[c],b);return b},geometryMember:function(a){var b=this.createElementNSPlus("gml:geometryMember");a=this.writeNode("feature:_geometry",a);b.appendChild(a.firstChild);return b}},feature:{_typeName:function(a){var b=this.createElementNSPlus("feature:"+this.featureType,{attributes:{fid:a.fid}});a.geometry&&this.writeNode("feature:_geometry",a.geometry,b);for(var c in a.attributes){var d=
a.attributes[c];d!=null&&this.writeNode("feature:_attribute",{name:c,value:d},b)}return b},_geometry:function(a){if(this.externalProjection&&this.internalProjection)a=a.clone().transform(this.internalProjection,this.externalProjection);var b=this.createElementNSPlus("feature:"+this.geometryName);a=this.writeNode("gml:"+this.geometryTypes[a.CLASS_NAME],a,b);this.srsName&&a.setAttribute("srsName",this.srsName);return b},_attribute:function(a){return this.createElementNSPlus("feature:"+a.name,{value:a.value})}},
wfs:{FeatureCollection:function(a){for(var b=this.createElementNSPlus("wfs:FeatureCollection"),c=0,d=a.length;c<d;++c)this.writeNode("gml:featureMember",a[c],b);return b}}},setGeometryTypes:function(){this.geometryTypes={"OpenLayers.Geometry.Point":"Point","OpenLayers.Geometry.MultiPoint":"MultiPoint","OpenLayers.Geometry.LineString":"LineString","OpenLayers.Geometry.MultiLineString":"MultiLineString","OpenLayers.Geometry.Polygon":"Polygon","OpenLayers.Geometry.MultiPolygon":"MultiPolygon","OpenLayers.Geometry.Collection":"GeometryCollection"}},
CLASS_NAME:"OpenLayers.Format.GML.Base"});
OpenLayers.Format.GML.v3=OpenLayers.Class(OpenLayers.Format.GML.Base,{schemaLocation:"http://www.opengis.net/gml http://schemas.opengis.net/gml/3.1.1/profiles/gmlsfProfile/1.0.0/gmlsf.xsd",curve:false,multiCurve:true,surface:false,multiSurface:true,initialize:function(a){OpenLayers.Format.GML.Base.prototype.initialize.apply(this,[a])},readers:{gml:OpenLayers.Util.applyDefaults({featureMembers:function(a,b){this.readChildNodes(a,b)},Curve:function(a,b){var c={points:[]};this.readChildNodes(a,c);if(!b.components)b.components=
[];b.components.push(new OpenLayers.Geometry.LineString(c.points))},segments:function(a,b){this.readChildNodes(a,b)},LineStringSegment:function(a,b){var c={};this.readChildNodes(a,c);c.points&&Array.prototype.push.apply(b.points,c.points)},pos:function(a,b){var c=this.getChildValue(a).replace(this.regExes.trimSpace,"").split(this.regExes.splitSpace);c=this.xy?new OpenLayers.Geometry.Point(c[0],c[1],c[2]):new OpenLayers.Geometry.Point(c[1],c[0],c[2]);b.points=[c]},posList:function(a,b){for(var c=this.getChildValue(a).replace(this.regExes.trimSpace,
"").split(this.regExes.splitSpace),d=parseInt(a.getAttribute("dimension"))||2,e,f,g,h=Array(c.length/d),j=0,i=c.length;j<i;j+=d){e=c[j];f=c[j+1];g=d==2?undefined:c[j+2];h[j/d]=this.xy?new OpenLayers.Geometry.Point(e,f,g):new OpenLayers.Geometry.Point(f,e,g)}b.points=h},Surface:function(a,b){this.readChildNodes(a,b)},patches:function(a,b){this.readChildNodes(a,b)},PolygonPatch:function(a,b){this.readers.gml.Polygon.apply(this,[a,b])},exterior:function(a,b){var c={};this.readChildNodes(a,c);b.outer=
c.components[0]},interior:function(a,b){var c={};this.readChildNodes(a,c);b.inner.push(c.components[0])},MultiCurve:function(a,b){var c={components:[]};this.readChildNodes(a,c);if(c.components.length>0)b.components=[new OpenLayers.Geometry.MultiLineString(c.components)]},curveMember:function(a,b){this.readChildNodes(a,b)},MultiSurface:function(a,b){var c={components:[]};this.readChildNodes(a,c);if(c.components.length>0)b.components=[new OpenLayers.Geometry.MultiPolygon(c.components)]},surfaceMember:function(a,
b){this.readChildNodes(a,b)},surfaceMembers:function(a,b){this.readChildNodes(a,b)},pointMembers:function(a,b){this.readChildNodes(a,b)},lineStringMembers:function(a,b){this.readChildNodes(a,b)},polygonMembers:function(a,b){this.readChildNodes(a,b)},geometryMembers:function(a,b){this.readChildNodes(a,b)},Envelope:function(a,b){var c={points:Array(2)};this.readChildNodes(a,c);if(!b.components)b.components=[];var d=c.points[0];c=c.points[1];b.components.push(new OpenLayers.Bounds(d.x,d.y,c.x,c.y))},
lowerCorner:function(a,b){var c={};this.readers.gml.pos.apply(this,[a,c]);b.points[0]=c.points[0]},upperCorner:function(a,b){var c={};this.readers.gml.pos.apply(this,[a,c]);b.points[1]=c.points[0]}},OpenLayers.Format.GML.Base.prototype.readers.gml),feature:OpenLayers.Format.GML.Base.prototype.readers.feature,wfs:OpenLayers.Format.GML.Base.prototype.readers.wfs},write:function(a){a=this.writeNode("gml:"+(OpenLayers.Util.isArray(a)?"featureMembers":"featureMember"),a);this.setAttributeNS(a,this.namespaces.xsi,
"xsi:schemaLocation",this.schemaLocation);return OpenLayers.Format.XML.prototype.write.apply(this,[a])},writers:{gml:OpenLayers.Util.applyDefaults({featureMembers:function(a){for(var b=this.createElementNSPlus("gml:featureMembers"),c=0,d=a.length;c<d;++c)this.writeNode("feature:_typeName",a[c],b);return b},Point:function(a){var b=this.createElementNSPlus("gml:Point");this.writeNode("pos",a,b);return b},pos:function(a){return this.createElementNSPlus("gml:pos",{value:this.xy?a.x+" "+a.y:a.y+" "+a.x})},
LineString:function(a){var b=this.createElementNSPlus("gml:LineString");this.writeNode("posList",a.components,b);return b},Curve:function(a){var b=this.createElementNSPlus("gml:Curve");this.writeNode("segments",a,b);return b},segments:function(a){var b=this.createElementNSPlus("gml:segments");this.writeNode("LineStringSegment",a,b);return b},LineStringSegment:function(a){var b=this.createElementNSPlus("gml:LineStringSegment");this.writeNode("posList",a.components,b);return b},posList:function(a){for(var b=
a.length,c=Array(b),d,e=0;e<b;++e){d=a[e];c[e]=this.xy?d.x+" "+d.y:d.y+" "+d.x}return this.createElementNSPlus("gml:posList",{value:c.join(" ")})},Surface:function(a){var b=this.createElementNSPlus("gml:Surface");this.writeNode("patches",a,b);return b},patches:function(a){var b=this.createElementNSPlus("gml:patches");this.writeNode("PolygonPatch",a,b);return b},PolygonPatch:function(a){var b=this.createElementNSPlus("gml:PolygonPatch",{attributes:{interpolation:"planar"}});this.writeNode("exterior",
a.components[0],b);for(var c=1,d=a.components.length;c<d;++c)this.writeNode("interior",a.components[c],b);return b},Polygon:function(a){var b=this.createElementNSPlus("gml:Polygon");this.writeNode("exterior",a.components[0],b);for(var c=1,d=a.components.length;c<d;++c)this.writeNode("interior",a.components[c],b);return b},exterior:function(a){var b=this.createElementNSPlus("gml:exterior");this.writeNode("LinearRing",a,b);return b},interior:function(a){var b=this.createElementNSPlus("gml:interior");
this.writeNode("LinearRing",a,b);return b},LinearRing:function(a){var b=this.createElementNSPlus("gml:LinearRing");this.writeNode("posList",a.components,b);return b},MultiCurve:function(a){var b=this.createElementNSPlus("gml:MultiCurve");a=a.components||[a];for(var c=0,d=a.length;c<d;++c)this.writeNode("curveMember",a[c],b);return b},curveMember:function(a){var b=this.createElementNSPlus("gml:curveMember");this.curve?this.writeNode("Curve",a,b):this.writeNode("LineString",a,b);return b},MultiSurface:function(a){var b=
this.createElementNSPlus("gml:MultiSurface");a=a.components||[a];for(var c=0,d=a.length;c<d;++c)this.writeNode("surfaceMember",a[c],b);return b},surfaceMember:function(a){var b=this.createElementNSPlus("gml:surfaceMember");this.surface?this.writeNode("Surface",a,b):this.writeNode("Polygon",a,b);return b},Envelope:function(a){var b=this.createElementNSPlus("gml:Envelope");this.writeNode("lowerCorner",a,b);this.writeNode("upperCorner",a,b);this.srsName&&b.setAttribute("srsName",this.srsName);return b},
lowerCorner:function(a){return this.createElementNSPlus("gml:lowerCorner",{value:this.xy?a.left+" "+a.bottom:a.bottom+" "+a.left})},upperCorner:function(a){return this.createElementNSPlus("gml:upperCorner",{value:this.xy?a.right+" "+a.top:a.top+" "+a.right})}},OpenLayers.Format.GML.Base.prototype.writers.gml),feature:OpenLayers.Format.GML.Base.prototype.writers.feature,wfs:OpenLayers.Format.GML.Base.prototype.writers.wfs},setGeometryTypes:function(){this.geometryTypes={"OpenLayers.Geometry.Point":"Point",
"OpenLayers.Geometry.MultiPoint":"MultiPoint","OpenLayers.Geometry.LineString":this.curve===true?"Curve":"LineString","OpenLayers.Geometry.MultiLineString":this.multiCurve===false?"MultiLineString":"MultiCurve","OpenLayers.Geometry.Polygon":this.surface===true?"Surface":"Polygon","OpenLayers.Geometry.MultiPolygon":this.multiSurface===false?"MultiPolygon":"MultiSurface","OpenLayers.Geometry.Collection":"GeometryCollection"}},CLASS_NAME:"OpenLayers.Format.GML.v3"});
OpenLayers.Format.Filter.v1_1_0=OpenLayers.Class(OpenLayers.Format.GML.v3,OpenLayers.Format.Filter.v1,{VERSION:"1.1.0",schemaLocation:"http://www.opengis.net/ogc/filter/1.1.0/filter.xsd",initialize:function(a){OpenLayers.Format.GML.v3.prototype.initialize.apply(this,[a])},readers:{ogc:OpenLayers.Util.applyDefaults({PropertyIsEqualTo:function(a,b){var c=a.getAttribute("matchCase");c=new OpenLayers.Filter.Comparison({type:OpenLayers.Filter.Comparison.EQUAL_TO,matchCase:!(c==="false"||c==="0")});this.readChildNodes(a,
c);b.filters.push(c)},PropertyIsNotEqualTo:function(a,b){var c=a.getAttribute("matchCase");c=new OpenLayers.Filter.Comparison({type:OpenLayers.Filter.Comparison.NOT_EQUAL_TO,matchCase:!(c==="false"||c==="0")});this.readChildNodes(a,c);b.filters.push(c)},PropertyIsLike:function(a,b){var c=new OpenLayers.Filter.Comparison({type:OpenLayers.Filter.Comparison.LIKE});this.readChildNodes(a,c);var d=a.getAttribute("wildCard"),e=a.getAttribute("singleChar"),f=a.getAttribute("escapeChar");c.value2regex(d,e,
f);b.filters.push(c)}},OpenLayers.Format.Filter.v1.prototype.readers.ogc),gml:OpenLayers.Format.GML.v3.prototype.readers.gml,feature:OpenLayers.Format.GML.v3.prototype.readers.feature},writers:{ogc:OpenLayers.Util.applyDefaults({PropertyIsEqualTo:function(a){var b=this.createElementNSPlus("ogc:PropertyIsEqualTo",{attributes:{matchCase:a.matchCase}});this.writeNode("PropertyName",a,b);this.writeOgcExpression(a.value,b);return b},PropertyIsNotEqualTo:function(a){var b=this.createElementNSPlus("ogc:PropertyIsNotEqualTo",
{attributes:{matchCase:a.matchCase}});this.writeNode("PropertyName",a,b);this.writeOgcExpression(a.value,b);return b},PropertyIsLike:function(a){var b=this.createElementNSPlus("ogc:PropertyIsLike",{attributes:{matchCase:a.matchCase,wildCard:"*",singleChar:".",escapeChar:"!"}});this.writeNode("PropertyName",a,b);this.writeNode("Literal",a.regex2value(),b);return b},BBOX:function(a){var b=this.createElementNSPlus("ogc:BBOX");a.property&&this.writeNode("PropertyName",a,b);var c=this.writeNode("gml:Envelope",
a.value);a.projection&&c.setAttribute("srsName",a.projection);b.appendChild(c);return b},SortBy:function(a){for(var b=this.createElementNSPlus("ogc:SortBy"),c=0,d=a.length;c<d;c++)this.writeNode("ogc:SortProperty",a[c],b);return b},SortProperty:function(a){var b=this.createElementNSPlus("ogc:SortProperty");this.writeNode("ogc:PropertyName",a,b);this.writeNode("ogc:SortOrder",a.order=="DESC"?"DESC":"ASC",b);return b},SortOrder:function(a){return this.createElementNSPlus("ogc:SortOrder",{value:a})}},
OpenLayers.Format.Filter.v1.prototype.writers.ogc),gml:OpenLayers.Format.GML.v3.prototype.writers.gml,feature:OpenLayers.Format.GML.v3.prototype.writers.feature},writeSpatial:function(a,b){var c=this.createElementNSPlus("ogc:"+b);this.writeNode("PropertyName",a,c);if(a.value instanceof OpenLayers.Filter.Function)this.writeNode("Function",a.value,c);else{var d;d=a.value instanceof OpenLayers.Geometry?this.writeNode("feature:_geometry",a.value).firstChild:this.writeNode("gml:Envelope",a.value);a.projection&&
d.setAttribute("srsName",a.projection);c.appendChild(d)}return c},CLASS_NAME:"OpenLayers.Format.Filter.v1_1_0"});OpenLayers.Format.OWSCommon=OpenLayers.Class(OpenLayers.Format.XML.VersionedOGC,{defaultVersion:"1.0.0",getVersion:function(a){var b=this.version;if(!b){if((a=a.getAttribute("xmlns:ows"))&&a.substring(a.lastIndexOf("/")+1)==="1.1")b="1.1.0";if(!b)b=this.defaultVersion}return b},CLASS_NAME:"OpenLayers.Format.OWSCommon"});
OpenLayers.Format.OWSCommon.v1=OpenLayers.Class(OpenLayers.Format.XML,{regExes:{trimSpace:/^\s*|\s*$/g,removeSpace:/\s*/g,splitSpace:/\s+/,trimComma:/\s*,\s*/g},read:function(a,b){OpenLayers.Util.applyDefaults(b,this.options);var c={};this.readChildNodes(a,c);return c},readers:{ows:{Exception:function(a,b){var c={code:a.getAttribute("exceptionCode"),locator:a.getAttribute("locator"),texts:[]};b.exceptions.push(c);this.readChildNodes(a,c)},ExceptionText:function(a,b){var c=this.getChildValue(a);b.texts.push(c)},
ServiceIdentification:function(a,b){b.serviceIdentification={};this.readChildNodes(a,b.serviceIdentification)},Title:function(a,b){b.title=this.getChildValue(a)},Abstract:function(a,b){b["abstract"]=this.getChildValue(a)},Keywords:function(a,b){b.keywords={};this.readChildNodes(a,b.keywords)},Keyword:function(a,b){b[this.getChildValue(a)]=true},ServiceType:function(a,b){b.serviceType={codeSpace:a.getAttribute("codeSpace"),value:this.getChildValue(a)}},ServiceTypeVersion:function(a,b){b.serviceTypeVersion=
this.getChildValue(a)},Fees:function(a,b){b.fees=this.getChildValue(a)},AccessConstraints:function(a,b){b.accessConstraints=this.getChildValue(a)},ServiceProvider:function(a,b){b.serviceProvider={};this.readChildNodes(a,b.serviceProvider)},ProviderName:function(a,b){b.providerName=this.getChildValue(a)},ProviderSite:function(a,b){b.providerSite=this.getAttributeNS(a,this.namespaces.xlink,"href")},ServiceContact:function(a,b){b.serviceContact={};this.readChildNodes(a,b.serviceContact)},IndividualName:function(a,
b){b.individualName=this.getChildValue(a)},PositionName:function(a,b){b.positionName=this.getChildValue(a)},ContactInfo:function(a,b){b.contactInfo={};this.readChildNodes(a,b.contactInfo)},Phone:function(a,b){b.phone={};this.readChildNodes(a,b.phone)},Voice:function(a,b){b.voice=this.getChildValue(a)},Address:function(a,b){b.address={};this.readChildNodes(a,b.address)},DeliveryPoint:function(a,b){b.deliveryPoint=this.getChildValue(a)},City:function(a,b){b.city=this.getChildValue(a)},AdministrativeArea:function(a,
b){b.administrativeArea=this.getChildValue(a)},PostalCode:function(a,b){b.postalCode=this.getChildValue(a)},Country:function(a,b){b.country=this.getChildValue(a)},ElectronicMailAddress:function(a,b){b.electronicMailAddress=this.getChildValue(a)},Role:function(a,b){b.role=this.getChildValue(a)},OperationsMetadata:function(a,b){b.operationsMetadata={};this.readChildNodes(a,b.operationsMetadata)},Operation:function(a,b){var c=a.getAttribute("name");b[c]={};this.readChildNodes(a,b[c])},DCP:function(a,
b){b.dcp={};this.readChildNodes(a,b.dcp)},HTTP:function(a,b){b.http={};this.readChildNodes(a,b.http)},Get:function(a,b){b.get=this.getAttributeNS(a,this.namespaces.xlink,"href")},Post:function(a,b){b.post=this.getAttributeNS(a,this.namespaces.xlink,"href")},Parameter:function(a,b){if(!b.parameters)b.parameters={};var c=a.getAttribute("name");b.parameters[c]={};this.readChildNodes(a,b.parameters[c])},Value:function(a,b){b[this.getChildValue(a)]=true},OutputFormat:function(a,b){b.formats.push({value:this.getChildValue(a)});
this.readChildNodes(a,b)},WGS84BoundingBox:function(a,b){var c={};c.crs=a.getAttribute("crs");if(b.BoundingBox)b.BoundingBox.push(c);else{b.projection=c.crs;c=b}this.readChildNodes(a,c)},BoundingBox:function(a,b){this.readers.ows.WGS84BoundingBox.apply(this,[a,b])},LowerCorner:function(a,b){var c=this.getChildValue(a).replace(this.regExes.trimSpace,"");c=c.replace(this.regExes.trimComma,",");c=c.split(this.regExes.splitSpace);b.left=c[0];b.bottom=c[1]},UpperCorner:function(a,b){var c=this.getChildValue(a).replace(this.regExes.trimSpace,
"");c=c.replace(this.regExes.trimComma,",");c=c.split(this.regExes.splitSpace);b.right=c[0];b.top=c[1];b.bounds=new OpenLayers.Bounds(b.left,b.bottom,b.right,b.top);delete b.left;delete b.bottom;delete b.right;delete b.top},Language:function(a,b){b.language=this.getChildValue(a)}}},writers:{ows:{BoundingBox:function(a){var b=this.createElementNSPlus("ows:BoundingBox",{attributes:{crs:a.projection}});this.writeNode("ows:LowerCorner",a,b);this.writeNode("ows:UpperCorner",a,b);return b},LowerCorner:function(a){return this.createElementNSPlus("ows:LowerCorner",
{value:a.bounds.left+" "+a.bounds.bottom})},UpperCorner:function(a){return this.createElementNSPlus("ows:UpperCorner",{value:a.bounds.right+" "+a.bounds.top})},Identifier:function(a){return this.createElementNSPlus("ows:Identifier",{value:a})},Title:function(a){return this.createElementNSPlus("ows:Title",{value:a})},Abstract:function(a){return this.createElementNSPlus("ows:Abstract",{value:a})},OutputFormat:function(a){return this.createElementNSPlus("ows:OutputFormat",{value:a})}}},CLASS_NAME:"OpenLayers.Format.OWSCommon.v1"});
OpenLayers.Format.OWSCommon.v1_0_0=OpenLayers.Class(OpenLayers.Format.OWSCommon.v1,{namespaces:{ows:"http://www.opengis.net/ows",xlink:"http://www.w3.org/1999/xlink"},readers:{ows:OpenLayers.Util.applyDefaults({ExceptionReport:function(a,b){b.success=false;b.exceptionReport={version:a.getAttribute("version"),language:a.getAttribute("language"),exceptions:[]};this.readChildNodes(a,b.exceptionReport)}},OpenLayers.Format.OWSCommon.v1.prototype.readers.ows)},writers:{ows:OpenLayers.Format.OWSCommon.v1.prototype.writers.ows},
CLASS_NAME:"OpenLayers.Format.OWSCommon.v1_0_0"});
OpenLayers.Format.WFST.v1_1_0=OpenLayers.Class(OpenLayers.Format.Filter.v1_1_0,OpenLayers.Format.WFST.v1,{version:"1.1.0",schemaLocations:{wfs:"http://schemas.opengis.net/wfs/1.1.0/wfs.xsd"},initialize:function(a){OpenLayers.Format.Filter.v1_1_0.prototype.initialize.apply(this,[a]);OpenLayers.Format.WFST.v1.prototype.initialize.apply(this,[a])},readNode:function(a,b){return OpenLayers.Format.GML.v3.prototype.readNode.apply(this,[a,b])},readers:{wfs:OpenLayers.Util.applyDefaults({FeatureCollection:function(a,b){b.numberOfFeatures=
parseInt(a.getAttribute("numberOfFeatures"));OpenLayers.Format.WFST.v1.prototype.readers.wfs.FeatureCollection.apply(this,arguments)},TransactionResponse:function(a,b){b.insertIds=[];b.success=false;this.readChildNodes(a,b)},TransactionSummary:function(a,b){b.success=true},InsertResults:function(a,b){this.readChildNodes(a,b)},Feature:function(a,b){var c={fids:[]};this.readChildNodes(a,c);b.insertIds.push(c.fids[0])}},OpenLayers.Format.WFST.v1.prototype.readers.wfs),gml:OpenLayers.Format.GML.v3.prototype.readers.gml,
feature:OpenLayers.Format.GML.v3.prototype.readers.feature,ogc:OpenLayers.Format.Filter.v1_1_0.prototype.readers.ogc,ows:OpenLayers.Format.OWSCommon.v1_0_0.prototype.readers.ows},writers:{wfs:OpenLayers.Util.applyDefaults({GetFeature:function(a){var b=OpenLayers.Format.WFST.v1.prototype.writers.wfs.GetFeature.apply(this,arguments);a&&this.setAttributes(b,{resultType:a.resultType,startIndex:a.startIndex,count:a.count});return b},Query:function(a){a=OpenLayers.Util.extend({featureNS:this.featureNS,
featurePrefix:this.featurePrefix,featureType:this.featureType,srsName:this.srsName},a);var b=a.featurePrefix,c=this.createElementNSPlus("wfs:Query",{attributes:{typeName:(b?b+":":"")+a.featureType,srsName:a.srsName}});a.featureNS&&c.setAttribute("xmlns:"+b,a.featureNS);if(a.propertyNames){b=0;for(var d=a.propertyNames.length;b<d;b++)this.writeNode("wfs:PropertyName",{property:a.propertyNames[b]},c)}if(a.filter){this.setFilterProperty(a.filter);this.writeNode("ogc:Filter",a.filter,c)}return c},PropertyName:function(a){return this.createElementNSPlus("wfs:PropertyName",
{value:a.property})}},OpenLayers.Format.WFST.v1.prototype.writers.wfs),gml:OpenLayers.Format.GML.v3.prototype.writers.gml,feature:OpenLayers.Format.GML.v3.prototype.writers.feature,ogc:OpenLayers.Format.Filter.v1_1_0.prototype.writers.ogc},CLASS_NAME:"OpenLayers.Format.WFST.v1_1_0"});
OpenLayers.Lang.is=OpenLayers.Util.applyDefaults({Permalink:"Varanlegur tengill",Overlays:"\u00deekjur","Base Layer":"Grunnlag",readNotImplemented:"Skrifun er \u00f3\u00fatf\u00e6r\u00f0.",writeNotImplemented:"Lestur er \u00f3\u00fatf\u00e6r\u00f0ur.",errorLoadingGML:"Villa kom upp vi\u00f0 a\u00f0 hla\u00f0a inn GML skr\u00e1nni ${url}","Scale = 1 : ${scaleDenom}":"Skali = 1 : ${scaleDenom}",layerAlreadyAdded:"\u00de\u00fa reyndir a\u00f0 b\u00e6ta laginu ${layerName} \u00e1 korti\u00f0 en \u00fea\u00f0 er \u00feegar b\u00fai\u00f0 a\u00f0 b\u00e6ta \u00fev\u00ed vi\u00f0",
methodDeprecated:"\u00deetta fall hefur veri\u00f0 \u00farelt og ver\u00f0ur fjarl\u00e6gt \u00ed 3.0. Nota\u00f0u ${newMethod} \u00ed sta\u00f0in."});
OpenLayers.Format.GeoJSON=OpenLayers.Class(OpenLayers.Format.JSON,{ignoreExtraDims:false,read:function(a,b,c){b=b?b:"FeatureCollection";var d=null,e=null;if(e=typeof a=="string"?OpenLayers.Format.JSON.prototype.read.apply(this,[a,c]):a)if(typeof e.type!="string")OpenLayers.Console.error("Bad GeoJSON - no type: "+a);else{if(this.isValidType(e,b))switch(b){case "Geometry":try{d=this.parseGeometry(e)}catch(f){OpenLayers.Console.error(f)}break;case "Feature":try{d=this.parseFeature(e);d.type="Feature"}catch(g){OpenLayers.Console.error(g)}break;
case "FeatureCollection":d=[];switch(e.type){case "Feature":try{d.push(this.parseFeature(e))}catch(h){d=null;OpenLayers.Console.error(h)}break;case "FeatureCollection":a=0;for(b=e.features.length;a<b;++a)try{d.push(this.parseFeature(e.features[a]))}catch(j){d=null;OpenLayers.Console.error(j)}break;default:try{var i=this.parseGeometry(e);d.push(new OpenLayers.Feature.Vector(i))}catch(k){d=null;OpenLayers.Console.error(k)}}}}else OpenLayers.Console.error("Bad JSON: "+a);return d},isValidType:function(a,
b){var c=false;switch(b){case "Geometry":if(OpenLayers.Util.indexOf(["Point","MultiPoint","LineString","MultiLineString","Polygon","MultiPolygon","Box","GeometryCollection"],a.type)==-1)OpenLayers.Console.error("Unsupported geometry type: "+a.type);else c=true;break;case "FeatureCollection":c=true;break;default:if(a.type==b)c=true;else OpenLayers.Console.error("Cannot convert types from "+a.type+" to "+b)}return c},parseFeature:function(a){var b,c,d;c=a.properties?a.properties:{};d=a.geometry&&a.geometry.bbox||
a.bbox;try{b=this.parseGeometry(a.geometry)}catch(e){throw e;}b=new OpenLayers.Feature.Vector(b,c);if(d)b.bounds=OpenLayers.Bounds.fromArray(d);if(a.id)b.fid=a.id;return b},parseGeometry:function(a){if(a==null)return null;var b,c=false;if(a.type=="GeometryCollection"){if(!OpenLayers.Util.isArray(a.geometries))throw"GeometryCollection must have geometries array: "+a;b=a.geometries.length;c=Array(b);for(var d=0;d<b;++d)c[d]=this.parseGeometry.apply(this,[a.geometries[d]]);b=new OpenLayers.Geometry.Collection(c);
c=true}else{if(!OpenLayers.Util.isArray(a.coordinates))throw"Geometry must have coordinates array: "+a;if(!this.parseCoords[a.type.toLowerCase()])throw"Unsupported geometry type: "+a.type;try{b=this.parseCoords[a.type.toLowerCase()].apply(this,[a.coordinates])}catch(e){throw e;}}this.internalProjection&&this.externalProjection&&!c&&b.transform(this.externalProjection,this.internalProjection);return b},parseCoords:{point:function(a){if(this.ignoreExtraDims==false&&a.length!=2)throw"Only 2D points are supported: "+
a;return new OpenLayers.Geometry.Point(a[0],a[1])},multipoint:function(a){for(var b=[],c=null,d=0,e=a.length;d<e;++d){try{c=this.parseCoords.point.apply(this,[a[d]])}catch(f){throw f;}b.push(c)}return new OpenLayers.Geometry.MultiPoint(b)},linestring:function(a){for(var b=[],c=null,d=0,e=a.length;d<e;++d){try{c=this.parseCoords.point.apply(this,[a[d]])}catch(f){throw f;}b.push(c)}return new OpenLayers.Geometry.LineString(b)},multilinestring:function(a){for(var b=[],c=null,d=0,e=a.length;d<e;++d){try{c=
this.parseCoords.linestring.apply(this,[a[d]])}catch(f){throw f;}b.push(c)}return new OpenLayers.Geometry.MultiLineString(b)},polygon:function(a){for(var b=[],c,d,e=0,f=a.length;e<f;++e){try{d=this.parseCoords.linestring.apply(this,[a[e]])}catch(g){throw g;}c=new OpenLayers.Geometry.LinearRing(d.components);b.push(c)}return new OpenLayers.Geometry.Polygon(b)},multipolygon:function(a){for(var b=[],c=null,d=0,e=a.length;d<e;++d){try{c=this.parseCoords.polygon.apply(this,[a[d]])}catch(f){throw f;}b.push(c)}return new OpenLayers.Geometry.MultiPolygon(b)},
box:function(a){if(a.length!=2)throw"GeoJSON box coordinates must have 2 elements";return new OpenLayers.Geometry.Polygon([new OpenLayers.Geometry.LinearRing([new OpenLayers.Geometry.Point(a[0][0],a[0][1]),new OpenLayers.Geometry.Point(a[1][0],a[0][1]),new OpenLayers.Geometry.Point(a[1][0],a[1][1]),new OpenLayers.Geometry.Point(a[0][0],a[1][1]),new OpenLayers.Geometry.Point(a[0][0],a[0][1])])])}},write:function(a,b){var c={type:null};if(OpenLayers.Util.isArray(a)){c.type="FeatureCollection";var d=
a.length;c.features=Array(d);for(var e=0;e<d;++e){var f=a[e];if(!f instanceof OpenLayers.Feature.Vector)throw"FeatureCollection only supports collections of features: "+f;c.features[e]=this.extract.feature.apply(this,[f])}}else if(a.CLASS_NAME.indexOf("OpenLayers.Geometry")==0)c=this.extract.geometry.apply(this,[a]);else if(a instanceof OpenLayers.Feature.Vector){c=this.extract.feature.apply(this,[a]);if(a.layer&&a.layer.projection)c.crs=this.createCRSObject(a)}return OpenLayers.Format.JSON.prototype.write.apply(this,
[c,b])},createCRSObject:function(a){a=a.layer.projection.toString();var b={};if(a.match(/epsg:/i)){a=parseInt(a.substring(a.indexOf(":")+1));b=a==4326?{type:"name",properties:{name:"urn:ogc:def:crs:OGC:1.3:CRS84"}}:{type:"name",properties:{name:"EPSG:"+a}}}return b},extract:{feature:function(a){var b=this.extract.geometry.apply(this,[a.geometry]);b={type:"Feature",properties:a.attributes,geometry:b};if(a.fid!=null)b.id=a.fid;return b},geometry:function(a){if(a==null)return null;if(this.internalProjection&&
this.externalProjection){a=a.clone();a.transform(this.internalProjection,this.externalProjection)}var b=a.CLASS_NAME.split(".")[2];a=this.extract[b.toLowerCase()].apply(this,[a]);return b=="Collection"?{type:"GeometryCollection",geometries:a}:{type:b,coordinates:a}},point:function(a){return[a.x,a.y]},multipoint:function(a){for(var b=[],c=0,d=a.components.length;c<d;++c)b.push(this.extract.point.apply(this,[a.components[c]]));return b},linestring:function(a){for(var b=[],c=0,d=a.components.length;c<
d;++c)b.push(this.extract.point.apply(this,[a.components[c]]));return b},multilinestring:function(a){for(var b=[],c=0,d=a.components.length;c<d;++c)b.push(this.extract.linestring.apply(this,[a.components[c]]));return b},polygon:function(a){for(var b=[],c=0,d=a.components.length;c<d;++c)b.push(this.extract.linestring.apply(this,[a.components[c]]));return b},multipolygon:function(a){for(var b=[],c=0,d=a.components.length;c<d;++c)b.push(this.extract.polygon.apply(this,[a.components[c]]));return b},collection:function(a){for(var b=
a.components.length,c=Array(b),d=0;d<b;++d)c[d]=this.extract.geometry.apply(this,[a.components[d]]);return c}},CLASS_NAME:"OpenLayers.Format.GeoJSON"});
OpenLayers.Protocol.Script=OpenLayers.Class(OpenLayers.Protocol,{url:null,params:null,callback:null,scope:null,format:null,callbackKey:"callback",callbackPrefix:"",pendingRequests:null,srsInBBOX:false,initialize:function(){this.params={};this.pendingRequests={};OpenLayers.Protocol.prototype.initialize.apply(this,arguments);if(!this.format)this.format=new OpenLayers.Format.GeoJSON;if(!this.filterToParams&&OpenLayers.Format.QueryStringFilter){var a=new OpenLayers.Format.QueryStringFilter({srsInBBOX:this.srsInBBOX});
this.filterToParams=function(b,c){return a.write(b,c)}}},read:function(a){OpenLayers.Protocol.prototype.read.apply(this,arguments);a=OpenLayers.Util.applyDefaults(a,this.options);a.params=OpenLayers.Util.applyDefaults(a.params,this.options.params);if(a.filter&&this.filterToParams)a.params=this.filterToParams(a.filter,a.params);var b=new OpenLayers.Protocol.Response({requestType:"read"}),c=this.createRequest(a.url,a.params,OpenLayers.Function.bind(function(d){b.data=d;this.handleRead(b,a)},this));
b.priv=c;return b},createRequest:function(a,b,c){c=OpenLayers.Protocol.Script.register(c);var d="OpenLayers.Protocol.Script.registry["+c+"]";b=OpenLayers.Util.extend({},b);b[this.callbackKey]=this.callbackPrefix+d;a=OpenLayers.Util.urlAppend(a,OpenLayers.Util.getParameterString(b));b=document.createElement("script");b.type="text/javascript";b.src=a;b.id="OpenLayers_Protocol_Script_"+c;this.pendingRequests[b.id]=b;document.getElementsByTagName("head")[0].appendChild(b);return b},destroyRequest:function(a){OpenLayers.Protocol.Script.unregister(a.id.split("_").pop());
delete this.pendingRequests[a.id];a.parentNode&&a.parentNode.removeChild(a)},handleRead:function(a,b){this.handleResponse(a,b)},handleResponse:function(a,b){if(b.callback){if(a.data){a.features=this.parseFeatures(a.data);a.code=OpenLayers.Protocol.Response.SUCCESS}else a.code=OpenLayers.Protocol.Response.FAILURE;this.destroyRequest(a.priv);b.callback.call(b.scope,a)}},parseFeatures:function(a){return this.format.read(a)},abort:function(a){if(a)this.destroyRequest(a.priv);else for(var b in this.pendingRequests)this.destroyRequest(this.pendingRequests[b])},
destroy:function(){this.abort();delete this.params;delete this.format;OpenLayers.Protocol.prototype.destroy.apply(this)},CLASS_NAME:"OpenLayers.Protocol.Script"});(function(){var a=OpenLayers.Protocol.Script,b=0;a.registry=[];a.register=function(c){var d=++b;a.registry[d]=function(){a.unregister(d);c.apply(this,arguments)};return d};a.unregister=function(c){delete a.registry[c]}})();
OpenLayers.Format.CSWGetRecords=function(a){a=OpenLayers.Util.applyDefaults(a,OpenLayers.Format.CSWGetRecords.DEFAULTS);var b=OpenLayers.Format.CSWGetRecords["v"+a.version.replace(/\./g,"_")];if(!b)throw"Unsupported CSWGetRecords version: "+a.version;return new b(a)};OpenLayers.Format.CSWGetRecords.DEFAULTS={version:"2.0.2"};
OpenLayers.Control=OpenLayers.Class({id:null,map:null,div:null,type:null,allowSelection:false,displayClass:"",title:"",autoActivate:false,active:null,handler:null,eventListeners:null,events:null,EVENT_TYPES:["activate","deactivate"],initialize:function(a){this.displayClass=this.CLASS_NAME.replace("OpenLayers.","ol").replace(/\./g,"");OpenLayers.Util.extend(this,a);this.events=new OpenLayers.Events(this,null,this.EVENT_TYPES);if(this.eventListeners instanceof Object)this.events.on(this.eventListeners);
if(this.id==null)this.id=OpenLayers.Util.createUniqueID(this.CLASS_NAME+"_")},destroy:function(){if(this.events){this.eventListeners&&this.events.un(this.eventListeners);this.events.destroy();this.events=null}this.eventListeners=null;if(this.handler){this.handler.destroy();this.handler=null}if(this.handlers){for(var a in this.handlers)this.handlers.hasOwnProperty(a)&&typeof this.handlers[a].destroy=="function"&&this.handlers[a].destroy();this.handlers=null}if(this.map){this.map.removeControl(this);
this.map=null}this.div=null},setMap:function(a){this.map=a;this.handler&&this.handler.setMap(a)},draw:function(a){if(this.div==null){this.div=OpenLayers.Util.createDiv(this.id);this.div.className=this.displayClass;if(!this.allowSelection){this.div.className+=" olControlNoSelect";this.div.setAttribute("unselectable","on",0);this.div.onselectstart=OpenLayers.Function.False}if(this.title!="")this.div.title=this.title}if(a!=null)this.position=a.clone();this.moveTo(this.position);return this.div},moveTo:function(a){if(a!=
null&&this.div!=null){this.div.style.left=a.x+"px";this.div.style.top=a.y+"px"}},activate:function(){if(this.active)return false;this.handler&&this.handler.activate();this.active=true;this.map&&OpenLayers.Element.addClass(this.map.viewPortDiv,this.displayClass.replace(/ /g,"")+"Active");this.events.triggerEvent("activate");return true},deactivate:function(){if(this.active){this.handler&&this.handler.deactivate();this.active=false;this.map&&OpenLayers.Element.removeClass(this.map.viewPortDiv,this.displayClass.replace(/ /g,
"")+"Active");this.events.triggerEvent("deactivate");return true}return false},CLASS_NAME:"OpenLayers.Control"});OpenLayers.Control.TYPE_BUTTON=1;OpenLayers.Control.TYPE_TOGGLE=2;OpenLayers.Control.TYPE_TOOL=3;
OpenLayers.Control.Panel=OpenLayers.Class(OpenLayers.Control,{controls:null,autoActivate:true,defaultControl:null,saveState:false,allowDepress:false,activeState:null,initialize:function(a){OpenLayers.Control.prototype.initialize.apply(this,[a]);this.controls=[];this.activeState={}},destroy:function(){OpenLayers.Control.prototype.destroy.apply(this,arguments);for(var a,b=this.controls.length-1;b>=0;b--){a=this.controls[b];a.events&&a.events.un({activate:this.iconOn,deactivate:this.iconOff});OpenLayers.Event.stopObservingElement(a.panel_div);
a.panel_div=null}this.activeState=null},activate:function(){if(OpenLayers.Control.prototype.activate.apply(this,arguments)){for(var a,b=0,c=this.controls.length;b<c;b++){a=this.controls[b];if(a===this.defaultControl||this.saveState&&this.activeState[a.id])a.activate()}if(this.saveState===true)this.defaultControl=null;this.redraw();return true}else return false},deactivate:function(){if(OpenLayers.Control.prototype.deactivate.apply(this,arguments)){for(var a,b=0,c=this.controls.length;b<c;b++){a=this.controls[b];
this.activeState[a.id]=a.deactivate()}this.redraw();return true}else return false},draw:function(){OpenLayers.Control.prototype.draw.apply(this,arguments);this.addControlsToMap(this.controls);return this.div},redraw:function(){for(var a=this.div.childNodes.length-1;a>=0;a--)this.div.removeChild(this.div.childNodes[a]);this.div.innerHTML="";if(this.active){a=0;for(var b=this.controls.length;a<b;a++)this.div.appendChild(this.controls[a].panel_div)}},activateControl:function(a){if(!this.active)return false;
if(a.type==OpenLayers.Control.TYPE_BUTTON)a.trigger();else if(a.type==OpenLayers.Control.TYPE_TOGGLE)a.active?a.deactivate():a.activate();else if(this.allowDepress&&a.active)a.deactivate();else{for(var b,c=0,d=this.controls.length;c<d;c++){b=this.controls[c];if(b!=a&&(b.type===OpenLayers.Control.TYPE_TOOL||b.type==null))b.deactivate()}a.activate()}},addControls:function(a){OpenLayers.Util.isArray(a)||(a=[a]);this.controls=this.controls.concat(a);for(var b=0,c=a.length;b<c;b++){var d=document.createElement("div");
d.className=a[b].displayClass+"ItemInactive";a[b].panel_div=d;if(a[b].title!="")a[b].panel_div.title=a[b].title;OpenLayers.Event.observe(a[b].panel_div,"click",OpenLayers.Function.bind(this.onClick,this,a[b]));OpenLayers.Event.observe(a[b].panel_div,"dblclick",OpenLayers.Function.bind(this.onDoubleClick,this,a[b]));OpenLayers.Event.observe(a[b].panel_div,"mousedown",OpenLayers.Function.bindAsEventListener(OpenLayers.Event.stop))}if(this.map){this.addControlsToMap(a);this.redraw()}},addControlsToMap:function(a){for(var b,
c=0,d=a.length;c<d;c++){b=a[c];if(b.autoActivate===true){b.autoActivate=false;this.map.addControl(b);b.autoActivate=true}else{this.map.addControl(b);b.deactivate()}b.events.on({activate:this.iconOn,deactivate:this.iconOff})}},iconOn:function(){var a=this.panel_div;a.className=a.className.replace(/ItemInactive$/,"ItemActive")},iconOff:function(){var a=this.panel_div;a.className=a.className.replace(/ItemActive$/,"ItemInactive")},onClick:function(a,b){OpenLayers.Event.stop(b?b:window.event);this.activateControl(a)},
onDoubleClick:function(a,b){OpenLayers.Event.stop(b?b:window.event)},getControlsBy:function(a,b){var c=typeof b.test=="function";return OpenLayers.Array.filter(this.controls,function(d){return d[a]==b||c&&b.test(d[a])})},getControlsByName:function(a){return this.getControlsBy("name",a)},getControlsByClass:function(a){return this.getControlsBy("CLASS_NAME",a)},CLASS_NAME:"OpenLayers.Control.Panel"});
OpenLayers.Control.ZoomIn=OpenLayers.Class(OpenLayers.Control,{type:OpenLayers.Control.TYPE_BUTTON,trigger:function(){this.map.zoomIn()},CLASS_NAME:"OpenLayers.Control.ZoomIn"});OpenLayers.Control.ZoomOut=OpenLayers.Class(OpenLayers.Control,{type:OpenLayers.Control.TYPE_BUTTON,trigger:function(){this.map.zoomOut()},CLASS_NAME:"OpenLayers.Control.ZoomOut"});
OpenLayers.Control.ZoomToMaxExtent=OpenLayers.Class(OpenLayers.Control,{type:OpenLayers.Control.TYPE_BUTTON,trigger:function(){this.map&&this.map.zoomToMaxExtent()},CLASS_NAME:"OpenLayers.Control.ZoomToMaxExtent"});OpenLayers.Control.ZoomPanel=OpenLayers.Class(OpenLayers.Control.Panel,{initialize:function(a){OpenLayers.Control.Panel.prototype.initialize.apply(this,[a]);this.addControls([new OpenLayers.Control.ZoomIn,new OpenLayers.Control.ZoomToMaxExtent,new OpenLayers.Control.ZoomOut])},CLASS_NAME:"OpenLayers.Control.ZoomPanel"});
OpenLayers.Layer.HTTPRequest=OpenLayers.Class(OpenLayers.Layer,{URL_HASH_FACTOR:(Math.sqrt(5)-1)/2,url:null,params:null,reproject:false,initialize:function(a,b,c,d){OpenLayers.Layer.prototype.initialize.apply(this,[a,d]);this.url=b;this.params=OpenLayers.Util.extend({},c)},destroy:function(){this.params=this.url=null;OpenLayers.Layer.prototype.destroy.apply(this,arguments)},clone:function(a){if(a==null)a=new OpenLayers.Layer.HTTPRequest(this.name,this.url,this.params,this.getOptions());return a=OpenLayers.Layer.prototype.clone.apply(this,
[a])},setUrl:function(a){this.url=a},mergeNewParams:function(a){this.params=OpenLayers.Util.extend(this.params,a);a=this.redraw();this.map!=null&&this.map.events.triggerEvent("changelayer",{layer:this,property:"params"});return a},redraw:function(a){return a?this.mergeNewParams({_olSalt:Math.random()}):OpenLayers.Layer.prototype.redraw.apply(this,[])},selectUrl:function(a,b){for(var c=1,d=0,e=a.length;d<e;d++){c*=a.charCodeAt(d)*this.URL_HASH_FACTOR;c-=Math.floor(c)}return b[Math.floor(c*b.length)]},
getFullRequestString:function(a,b){var c=b||this.url,d=OpenLayers.Util.extend({},this.params);d=OpenLayers.Util.extend(d,a);var e=OpenLayers.Util.getParameterString(d);if(OpenLayers.Util.isArray(c))c=this.selectUrl(e,c);e=OpenLayers.Util.upperCaseObject(OpenLayers.Util.getParameters(c));for(var f in d)f.toUpperCase()in e&&delete d[f];e=OpenLayers.Util.getParameterString(d);return OpenLayers.Util.urlAppend(c,e)},CLASS_NAME:"OpenLayers.Layer.HTTPRequest"});
OpenLayers.Layer.Grid=OpenLayers.Class(OpenLayers.Layer.HTTPRequest,{tileSize:null,tileOriginCorner:"bl",tileOrigin:null,tileOptions:null,grid:null,singleTile:false,ratio:1.5,buffer:0,numLoadingTiles:0,tileLoadingDelay:100,timerId:null,initialize:function(){OpenLayers.Layer.HTTPRequest.prototype.initialize.apply(this,arguments);this.events.addEventType("tileloaded");this.grid=[];this._moveGriddedTiles=OpenLayers.Function.bind(this.moveGriddedTiles,this)},removeMap:function(){if(this.timerId!=null){window.clearTimeout(this.timerId);
this.timerId=null}},destroy:function(){this.clearGrid();this.tileSize=this.grid=null;OpenLayers.Layer.HTTPRequest.prototype.destroy.apply(this,arguments)},clearGrid:function(){if(this.grid){for(var a=0,b=this.grid.length;a<b;a++)for(var c=this.grid[a],d=0,e=c.length;d<e;d++){var f=c[d];this.removeTileMonitoringHooks(f);f.destroy()}this.grid=[]}},clone:function(a){if(a==null)a=new OpenLayers.Layer.Grid(this.name,this.url,this.params,this.getOptions());a=OpenLayers.Layer.HTTPRequest.prototype.clone.apply(this,
[a]);if(this.tileSize!=null)a.tileSize=this.tileSize.clone();a.grid=[];return a},moveTo:function(a,b,c){OpenLayers.Layer.HTTPRequest.prototype.moveTo.apply(this,arguments);a=a||this.map.getExtent();if(a!=null){var d=!this.grid.length||b,e=this.getTilesBounds();if(this.singleTile){if(d||!c&&!e.containsBounds(a))this.initSingleTile(a)}else d||!e.containsBounds(a,true)?this.initGriddedTiles(a):this.scheduleMoveGriddedTiles()}},moveByPx:function(){this.singleTile||this.scheduleMoveGriddedTiles()},scheduleMoveGriddedTiles:function(){this.timerId!=
null&&window.clearTimeout(this.timerId);this.timerId=window.setTimeout(this._moveGriddedTiles,this.tileLoadingDelay)},setTileSize:function(a){if(this.singleTile){a=this.map.getSize();a.h=parseInt(a.h*this.ratio);a.w=parseInt(a.w*this.ratio)}OpenLayers.Layer.HTTPRequest.prototype.setTileSize.apply(this,[a])},getGridBounds:function(){OpenLayers.Console.warn("The getGridBounds() function is deprecated. It will be removed in 3.0. Please use getTilesBounds() instead.");return this.getTilesBounds()},getTilesBounds:function(){var a=
null;if(this.grid.length){a=this.grid[this.grid.length-1][0];var b=this.grid[0][this.grid[0].length-1];a=new OpenLayers.Bounds(a.bounds.left,a.bounds.bottom,b.bounds.right,b.bounds.top)}return a},initSingleTile:function(a){var b=a.getCenterLonLat(),c=a.getWidth()*this.ratio;a=a.getHeight()*this.ratio;b=new OpenLayers.Bounds(b.lon-c/2,b.lat-a/2,b.lon+c/2,b.lat+a/2);c=this.map.getLayerPxFromLonLat(new OpenLayers.LonLat(b.left,b.top));this.grid.length||(this.grid[0]=[]);if(a=this.grid[0][0])a.moveTo(b,
c);else{a=this.addTile(b,c);this.addTileMonitoringHooks(a);a.draw();this.grid[0][0]=a}this.removeExcessTiles(1,1)},calculateGridLayout:function(a,b,c){var d=c*this.tileSize.w;c*=this.tileSize.h;var e=a.left-b.lon,f=Math.floor(e/d)-this.buffer;a=a.top-(b.lat+c);var g=Math.ceil(a/c)+this.buffer;return{tilelon:d,tilelat:c,tileoffsetlon:b.lon+f*d,tileoffsetlat:b.lat+g*c,tileoffsetx:-(e/d-f)*this.tileSize.w,tileoffsety:-(g-a/c)*this.tileSize.h}},getTileOrigin:function(){var a=this.tileOrigin;if(!a){a=
this.getMaxExtent();var b={tl:["left","top"],tr:["right","top"],bl:["left","bottom"],br:["right","bottom"]}[this.tileOriginCorner];a=new OpenLayers.LonLat(a[b[0]],a[b[1]])}return a},initGriddedTiles:function(a){var b=this.map.getSize(),c=Math.ceil(b.h/this.tileSize.h)+Math.max(1,2*this.buffer);b=Math.ceil(b.w/this.tileSize.w)+Math.max(1,2*this.buffer);var d=this.getTileOrigin(),e=this.map.getResolution(),f=this.calculateGridLayout(a,d,e);d=Math.round(f.tileoffsetx);e=Math.round(f.tileoffsety);var g=
f.tileoffsetlon,h=f.tileoffsetlat,j=f.tilelon;f=f.tilelat;this.origin=new OpenLayers.Pixel(d,e);var i=d,k=g,l=0,m=parseInt(this.map.layerContainerDiv.style.left),n=parseInt(this.map.layerContainerDiv.style.top);do{var p=this.grid[l++];if(!p){p=[];this.grid.push(p)}g=k;d=i;var r=0;do{var t=new OpenLayers.Bounds(g,h,g+j,h+f),s=d;s-=m;var v=e;v-=n;s=new OpenLayers.Pixel(s,v);if(v=p[r++])v.moveTo(t,s,false);else{v=this.addTile(t,s);this.addTileMonitoringHooks(v);p.push(v)}g+=j;d+=this.tileSize.w}while(g<=
a.right+j*this.buffer||r<b);h-=f;e+=this.tileSize.h}while(h>=a.bottom-f*this.buffer||l<c);this.removeExcessTiles(l,r);this.spiralTileLoad()},getMaxExtent:function(){return this.maxExtent},spiralTileLoad:function(){for(var a=[],b=["right","down","left","up"],c=0,d=-1,e=OpenLayers.Util.indexOf(b,"right"),f=0;f<b.length;){var g=c,h=d;switch(b[e]){case "right":h++;break;case "down":g++;break;case "left":h--;break;case "up":g--}var j=null;if(g<this.grid.length&&g>=0&&h<this.grid[0].length&&h>=0)j=this.grid[g][h];
if(j!=null&&!j.queued){a.unshift(j);j.queued=true;f=0;c=g;d=h}else{e=(e+1)%4;f++}}b=0;for(c=a.length;b<c;b++){j=a[b];j.draw();j.queued=false}},addTile:function(a,b){return new OpenLayers.Tile.Image(this,b,a,null,this.tileSize,this.tileOptions)},addTileMonitoringHooks:function(a){a.onLoadStart=function(){this.numLoadingTiles==0&&this.events.triggerEvent("loadstart");this.numLoadingTiles++};a.events.register("loadstart",this,a.onLoadStart);a.onLoadEnd=function(){this.numLoadingTiles--;this.events.triggerEvent("tileloaded");
this.numLoadingTiles==0&&this.events.triggerEvent("loadend")};a.events.register("loadend",this,a.onLoadEnd);a.events.register("unload",this,a.onLoadEnd)},removeTileMonitoringHooks:function(a){a.unload();a.events.un({loadstart:a.onLoadStart,loadend:a.onLoadEnd,unload:a.onLoadEnd,scope:this})},moveGriddedTiles:function(){var a=true,b=this.buffer||1,c=this.grid[0][0].position,d=parseInt(this.map.layerContainerDiv.style.left),e=parseInt(this.map.layerContainerDiv.style.top);c=c.add(d,e);if(c.x>-this.tileSize.w*
(b-1))this.shiftColumn(true);else if(c.x<-this.tileSize.w*b)this.shiftColumn(false);else if(c.y>-this.tileSize.h*(b-1))this.shiftRow(true);else if(c.y<-this.tileSize.h*b)this.shiftRow(false);else a=false;if(a)this.timerId=window.setTimeout(this._moveGriddedTiles,0)},shiftRow:function(a){var b=this.grid,c=b[a?0:this.grid.length-1],d=this.map.getResolution(),e=a?-this.tileSize.h:this.tileSize.h;d*=-e;for(var f=a?b.pop():b.shift(),g=0,h=c.length;g<h;g++){var j=c[g],i=j.bounds.clone();j=j.position.clone();
i.bottom+=d;i.top+=d;j.y+=e;f[g].moveTo(i,j)}a?b.unshift(f):b.push(f)},shiftColumn:function(a){for(var b=a?-this.tileSize.w:this.tileSize.w,c=this.map.getResolution()*b,d=0,e=this.grid.length;d<e;d++){var f=this.grid[d],g=f[a?0:f.length-1],h=g.bounds.clone();g=g.position.clone();h.left+=c;h.right+=c;g.x+=b;var j=a?this.grid[d].pop():this.grid[d].shift();j.moveTo(h,g);a?f.unshift(j):f.push(j)}},removeExcessTiles:function(a,b){for(;this.grid.length>a;)for(var c=this.grid.pop(),d=0,e=c.length;d<e;d++){var f=
c[d];this.removeTileMonitoringHooks(f);f.destroy()}for(;this.grid[0].length>b;){d=0;for(e=this.grid.length;d<e;d++){c=this.grid[d];f=c.pop();this.removeTileMonitoringHooks(f);f.destroy()}}},onMapResize:function(){if(this.singleTile){this.clearGrid();this.setTileSize()}},getTileBounds:function(a){var b=this.maxExtent,c=this.getResolution(),d=c*this.tileSize.w;c*=this.tileSize.h;var e=this.getLonLatFromViewPortPx(a);a=b.left+d*Math.floor((e.lon-b.left)/d);b=b.bottom+c*Math.floor((e.lat-b.bottom)/c);
return new OpenLayers.Bounds(a,b,a+d,b+c)},CLASS_NAME:"OpenLayers.Layer.Grid"});
OpenLayers.Tile=OpenLayers.Class({EVENT_TYPES:["loadstart","loadend","reload","unload"],events:null,id:null,layer:null,url:null,bounds:null,size:null,position:null,isLoading:false,initialize:function(a,b,c,d,e,f){this.layer=a;this.position=b.clone();this.bounds=c.clone();this.url=d;if(e)this.size=e.clone();this.id=OpenLayers.Util.createUniqueID("Tile_");this.events=new OpenLayers.Events(this,null,this.EVENT_TYPES);OpenLayers.Util.extend(this,f)},unload:function(){if(this.isLoading){this.isLoading=
false;this.events.triggerEvent("unload")}},destroy:function(){this.position=this.size=this.bounds=this.layer=null;this.events.destroy();this.events=null},draw:function(){this.clear();return this.shouldDraw()},shouldDraw:function(){var a=this.layer.maxExtent;return a&&this.bounds.intersectsBounds(a,false)||this.layer.displayOutsideMaxExtent},moveTo:function(a,b,c){if(c==null)c=true;this.bounds=a.clone();this.position=b.clone();c&&this.draw()},clear:function(){},getBoundsFromBaseLayer:function(a){var b=
OpenLayers.i18n("reprojectDeprecated",{layerName:this.layer.name});OpenLayers.Console.warn(b);b=this.layer.map.getLonLatFromLayerPx(a);a=a.clone();a.x+=this.size.w;a.y+=this.size.h;a=this.layer.map.getLonLatFromLayerPx(a);if(b.lon>a.lon)if(b.lon<0)b.lon=-180-(b.lon+180);else a.lon=180+a.lon+180;return new OpenLayers.Bounds(b.lon,a.lat,a.lon,b.lat)},CLASS_NAME:"OpenLayers.Tile"});
OpenLayers.Tile.BackBufferable=OpenLayers.Class(OpenLayers.Tile,{backBufferMode:null,backBufferData:null,initialize:function(){OpenLayers.Tile.prototype.initialize.apply(this,arguments);this.backBufferMode=(this.layer.singleTile&&1)|(OpenLayers.Util.indexOf(this.layer.SUPPORTED_TRANSITIONS,this.layer.transitionEffect)!=-1&&2);this.backBufferData={};if(!this.size)this.size=new OpenLayers.Size(256,256)},draw:function(){var a=OpenLayers.Tile.prototype.shouldDraw.apply(this,arguments);a&&this.updateBackBuffer();
this.clear();a||this.resetBackBuffer();return a},setBackBufferData:function(){this.backBufferData=OpenLayers.Util.extend(this.backBufferData,{bounds:this.bounds,resolution:this.layer.map.getResolution()})},updateBackBuffer:function(){var a=this.layer,b=a.map,c=this.backBufferMode,d=this.backBufferData,e=this.getTile(),f=d.tile,g=d.resolution;g=g?g/b.getResolution():1;var h=e&&e.parentNode!==a.div,j=!(e&&e.childNodes.length>0),i=!f&&this.isLoading;if(!(g==1?c&1:c&2)||h||j||i)this.setBackBufferData();
else{if(!f){f=this.createBackBuffer();a.events.register("loadend",this,this.resetBackBuffer);d.tile=f;a.div.insertBefore(f,e)}a=b.getPixelFromLonLat({lon:d.bounds.left,lat:d.bounds.top});c=b.layerContainerDiv.style;b=parseInt(c.left,10);c=parseInt(c.top,10);d=f.style;d.left=a.x-b+"px";d.top=a.y-c+"px";d.width=this.size.w*g+"px";d.height=this.size.h*g+"px";return f}},resetBackBuffer:function(){this.layer.events.unregister("loadend",this,this.resetBackBuffer);this.removeBackBuffer();this.setBackBufferData()},
removeBackBuffer:function(){var a=this.backBufferData,b=a.tile;delete a.tile;a=b&&b.parentNode;b&&a.removeChild(b)},destroy:function(){this.removeBackBuffer();this.layer.events.unregister("loadend",this,this.resetBackBuffer);this.backBufferData=null;OpenLayers.Tile.prototype.destroy.apply(this,arguments)}});
OpenLayers.Tile.Image=OpenLayers.Class(OpenLayers.Tile.BackBufferable,{url:null,imgDiv:null,frame:null,imageReloadAttempts:null,layerAlphaHack:null,asyncRequestId:null,blankImageUrl:"data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///yH5BAEAAAAALAAAAAABAAEAQAIBRAA7",maxGetUrlLength:null,initialize:function(a,b,c,d){OpenLayers.Tile.BackBufferable.prototype.initialize.apply(this,arguments);this.url=d;this.frame=document.createElement("div");this.frame.style.position="absolute";this.frame.style.overflow=
"hidden";this.layerAlphaHack=this.layer.alpha&&OpenLayers.Util.alphaHack();this.maxGetUrlLength!=null&&OpenLayers.Util.extend(this,OpenLayers.Tile.Image.IFrame)},destroy:function(){if(this.frame!=null){this.clear();this.frame=this.imgDiv=null}this.asyncRequestId=null;OpenLayers.Tile.BackBufferable.prototype.destroy.apply(this,arguments)},draw:function(){var a=OpenLayers.Tile.BackBufferable.prototype.draw.apply(this,arguments);if(a){if(this.layer!=this.layer.map.baseLayer&&this.layer.reproject)this.bounds=
this.getBoundsFromBaseLayer(this.position);if(this.isLoading)this.events.triggerEvent("reload");else{this.isLoading=true;this.events.triggerEvent("loadstart")}this.positionTile();this.renderTile()}else this.unload();return a},renderTile:function(){this.layer.div.appendChild(this.frame);if(this.layer.async){var a=this.asyncRequestId=(this.asyncRequestId||0)+1;this.layer.getURLasync(this.bounds,this,"url",function(){a==this.asyncRequestId&&this.initImage()})}else{this.url=this.layer.getURL(this.bounds);
this.initImage()}},positionTile:function(){var a=this.frame.style;a.left=this.position.x+"px";a.top=this.position.y+"px";a.width=this.size.w+"px";a.height=this.size.h+"px"},clear:function(){var a=this.imgDiv;if(a){OpenLayers.Event.stopObservingElement(a);this.frame.parentNode===this.layer.div&&this.layer.div.removeChild(this.frame);this.setImgSrc();if(this.layerAlphaHack===true)a.style.filter="";OpenLayers.Element.removeClass(a,"olImageLoadError")}},createImage:function(){var a=document.createElement("img");
this.imgDiv=a;a.className="olTileImage";a.galleryImg="no";var b=a.style,c=this.layer.gutter;if(c){var d=this.layer.tileSize,e=c/d.w*100;c=c/d.h*100;b.left=-e+"%";b.top=-c+"%";b.width=2*e+100+"%";b.height=2*c+100+"%";b.position="absolute"}else{b.width="100%";b.height="100%"}b.display="none";this.layer.opacity<1&&OpenLayers.Util.modifyDOMElement(a,null,null,null,null,null,null,this.layer.opacity);if(this.layerAlphaHack){b.paddingTop=b.height;b.height="0"}this.frame.appendChild(a);return a},initImage:function(){var a=
this.imgDiv||this.createImage();if(this.url&&a.getAttribute("src")==this.url)this.onImageLoad();else{var b=OpenLayers.Function.bind(function(){OpenLayers.Event.stopObservingElement(a);OpenLayers.Event.observe(a,"load",OpenLayers.Function.bind(this.onImageLoad,this));OpenLayers.Event.observe(a,"error",OpenLayers.Function.bind(this.onImageError,this));this.imageReloadAttempts=0;this.setImgSrc(this.url)},this);if(a.getAttribute("src")==this.blankImageUrl)b();else{OpenLayers.Event.observe(a,"load",b);
OpenLayers.Event.observe(a,"error",b);a.src=this.blankImageUrl}}},setImgSrc:function(a){var b=this.imgDiv;b.style.display="none";if(a)b.src=a},getTile:function(){return this.frame},createBackBuffer:function(){var a=this.frame.cloneNode(false);OpenLayers.Event.stopObservingElement(this.imgDiv);a.appendChild(this.imgDiv);this.imgDiv=null;return a},onImageLoad:function(){var a=this.imgDiv;a.style.display="";this.isLoading=false;this.events.triggerEvent("loadend");if(this.layerAlphaHack===true)a.style.filter=
"progid:DXImageTransform.Microsoft.AlphaImageLoader(src='"+a.src+"', sizingMethod='scale')"},onImageError:function(){var a=this.imgDiv;if(a.src!=null){this.imageReloadAttempts++;if(this.imageReloadAttempts<=OpenLayers.IMAGE_RELOAD_ATTEMPTS)this.setImgSrc(this.layer.getURL(this.bounds));else{OpenLayers.Element.addClass(a,"olImageLoadError");this.onImageLoad()}}},CLASS_NAME:"OpenLayers.Tile.Image"});
OpenLayers.Format.ArcXML=OpenLayers.Class(OpenLayers.Format.XML,{fontStyleKeys:["antialiasing","blockout","font","fontcolor","fontsize","fontstyle","glowing","interval","outline","printmode","shadow","transparency"],request:null,response:null,initialize:function(a){this.request=new OpenLayers.Format.ArcXML.Request;this.response=new OpenLayers.Format.ArcXML.Response;if(a)if(a.requesttype=="feature"){this.request.get_image=null;var b=this.request.get_feature.query;this.addCoordSys(b.featurecoordsys,
a.featureCoordSys);this.addCoordSys(b.filtercoordsys,a.filterCoordSys);if(a.polygon){b.isspatial=true;b.spatialfilter.polygon=a.polygon}else if(a.envelope){b.isspatial=true;b.spatialfilter.envelope={minx:0,miny:0,maxx:0,maxy:0};this.parseEnvelope(b.spatialfilter.envelope,a.envelope)}}else if(a.requesttype=="image"){this.request.get_feature=null;b=this.request.get_image.properties;this.parseEnvelope(b.envelope,a.envelope);this.addLayers(b.layerlist,a.layers);this.addImageSize(b.imagesize,a.tileSize);
this.addCoordSys(b.featurecoordsys,a.featureCoordSys);this.addCoordSys(b.filtercoordsys,a.filterCoordSys)}else this.request=null;OpenLayers.Format.XML.prototype.initialize.apply(this,[a])},parseEnvelope:function(a,b){if(b&&b.length==4){a.minx=b[0];a.miny=b[1];a.maxx=b[2];a.maxy=b[3]}},addLayers:function(a,b){for(var c=0,d=b.length;c<d;c++)a.push(b[c])},addImageSize:function(a,b){if(b!==null){a.width=b.w;a.height=b.h;a.printwidth=b.w;a.printheight=b.h}},addCoordSys:function(a,b){if(typeof b=="string"){a.id=
parseInt(b);a.string=b}else if(typeof b=="object"&&b.proj!==null){a.id=b.proj.srsProjNumber;a.string=b.proj.srsCode}},iserror:function(a){var b=null;if(a){a=OpenLayers.Format.XML.prototype.read.apply(this,[a]);a=a.documentElement.getElementsByTagName("ERROR");b=a!==null&&a.length>0}else b=this.response.error!=="";return b},read:function(a){if(typeof a=="string")a=OpenLayers.Format.XML.prototype.read.apply(this,[a]);var b=null;if(a&&a.documentElement)b=a.documentElement.nodeName=="ARCXML"?a.documentElement:
a.documentElement.getElementsByTagName("ARCXML")[0];if(!b||b.firstChild.nodeName==="parsererror"){var c,d;try{c=a.firstChild.nodeValue;d=a.firstChild.childNodes[1].firstChild.nodeValue}catch(e){}throw{message:"Error parsing the ArcXML request",error:c,source:d};}return this.parseResponse(b)},write:function(a){if(!a)a=this.request;var b=this.createElementNS("","ARCXML");b.setAttribute("version","1.1");var c=this.createElementNS("","REQUEST");if(a.get_image!=null){var d=this.createElementNS("","GET_IMAGE");
c.appendChild(d);var e=this.createElementNS("","PROPERTIES");d.appendChild(e);a=a.get_image.properties;if(a.featurecoordsys!=null){d=this.createElementNS("","FEATURECOORDSYS");e.appendChild(d);a.featurecoordsys.id===0?d.setAttribute("string",a.featurecoordsys.string):d.setAttribute("id",a.featurecoordsys.id)}if(a.filtercoordsys!=null){d=this.createElementNS("","FILTERCOORDSYS");e.appendChild(d);a.filtercoordsys.id===0?d.setAttribute("string",a.filtercoordsys.string):d.setAttribute("id",a.filtercoordsys.id)}if(a.envelope!=
null){d=this.createElementNS("","ENVELOPE");e.appendChild(d);d.setAttribute("minx",a.envelope.minx);d.setAttribute("miny",a.envelope.miny);d.setAttribute("maxx",a.envelope.maxx);d.setAttribute("maxy",a.envelope.maxy)}d=this.createElementNS("","IMAGESIZE");e.appendChild(d);d.setAttribute("height",a.imagesize.height);d.setAttribute("width",a.imagesize.width);if(a.imagesize.height!=a.imagesize.printheight||a.imagesize.width!=a.imagesize.printwidth){d.setAttribute("printheight",a.imagesize.printheight);
d.setArrtibute("printwidth",a.imagesize.printwidth)}if(a.background!=null){d=this.createElementNS("","BACKGROUND");e.appendChild(d);d.setAttribute("color",a.background.color.r+","+a.background.color.g+","+a.background.color.b);a.background.transcolor!==null&&d.setAttribute("transcolor",a.background.transcolor.r+","+a.background.transcolor.g+","+a.background.transcolor.b)}if(a.layerlist!=null&&a.layerlist.length>0){d=this.createElementNS("","LAYERLIST");e.appendChild(d);for(e=0;e<a.layerlist.length;e++){var f=
this.createElementNS("","LAYERDEF");d.appendChild(f);f.setAttribute("id",a.layerlist[e].id);f.setAttribute("visible",a.layerlist[e].visible);if(typeof a.layerlist[e].query=="object"){var g=a.layerlist[e].query;if(g.where.length<0)continue;var h=null;h=typeof g.spatialfilter=="boolean"&&g.spatialfilter?this.createElementNS("","SPATIALQUERY"):this.createElementNS("","QUERY");h.setAttribute("where",g.where);typeof g.accuracy=="number"&&g.accuracy>0&&h.setAttribute("accuracy",g.accuracy);typeof g.featurelimit==
"number"&&g.featurelimit<2E3&&h.setAttribute("featurelimit",g.featurelimit);typeof g.subfields=="string"&&g.subfields!="#ALL#"&&h.setAttribute("subfields",g.subfields);typeof g.joinexpression=="string"&&g.joinexpression.length>0&&h.setAttribute("joinexpression",g.joinexpression);typeof g.jointables=="string"&&g.jointables.length>0&&h.setAttribute("jointables",g.jointables);f.appendChild(h)}typeof a.layerlist[e].renderer=="object"&&this.addRenderer(f,a.layerlist[e].renderer)}}}else if(a.get_feature!=
null){d=this.createElementNS("","GET_FEATURES");d.setAttribute("outputmode","newxml");d.setAttribute("checkesc","true");a.get_feature.geometry?d.setAttribute("geometry",a.get_feature.geometry):d.setAttribute("geometry","false");a.get_feature.compact&&d.setAttribute("compact",a.get_feature.compact);a.get_feature.featurelimit=="number"&&d.setAttribute("featurelimit",a.get_feature.featurelimit);d.setAttribute("globalenvelope","true");c.appendChild(d);if(a.get_feature.layer!=null&&a.get_feature.layer.length>
0){e=this.createElementNS("","LAYER");e.setAttribute("id",a.get_feature.layer);d.appendChild(e)}a=a.get_feature.query;if(a!=null){e=null;e=a.isspatial?this.createElementNS("","SPATIALQUERY"):this.createElementNS("","QUERY");d.appendChild(e);typeof a.accuracy=="number"&&e.setAttribute("accuracy",a.accuracy);if(a.featurecoordsys!=null){d=this.createElementNS("","FEATURECOORDSYS");a.featurecoordsys.id==0?d.setAttribute("string",a.featurecoordsys.string):d.setAttribute("id",a.featurecoordsys.id);e.appendChild(d)}if(a.filtercoordsys!=
null){d=this.createElementNS("","FILTERCOORDSYS");a.filtercoordsys.id===0?d.setAttribute("string",a.filtercoordsys.string):d.setAttribute("id",a.filtercoordsys.id);e.appendChild(d)}if(a.buffer>0){d=this.createElementNS("","BUFFER");d.setAttribute("distance",a.buffer);e.appendChild(d)}if(a.isspatial){d=this.createElementNS("","SPATIALFILTER");d.setAttribute("relation",a.spatialfilter.relation);e.appendChild(d);if(a.spatialfilter.envelope){f=this.createElementNS("","ENVELOPE");f.setAttribute("minx",
a.spatialfilter.envelope.minx);f.setAttribute("miny",a.spatialfilter.envelope.miny);f.setAttribute("maxx",a.spatialfilter.envelope.maxx);f.setAttribute("maxy",a.spatialfilter.envelope.maxy);d.appendChild(f)}else typeof a.spatialfilter.polygon=="object"&&d.appendChild(this.writePolygonGeometry(a.spatialfilter.polygon))}a.where!=null&&a.where.length>0&&e.setAttribute("where",a.where)}}b.appendChild(c);return OpenLayers.Format.XML.prototype.write.apply(this,[b])},addGroupRenderer:function(a,b){var c=
this.createElementNS("","GROUPRENDERER");a.appendChild(c);for(var d=0;d<b.length;d++)this.addRenderer(c,b[d])},addRenderer:function(a,b){if(OpenLayers.Util.isArray(b))this.addGroupRenderer(a,b);else{var c=this.createElementNS("",b.type.toUpperCase()+"RENDERER");a.appendChild(c);if(c.tagName=="VALUEMAPRENDERER")this.addValueMapRenderer(c,b);else if(c.tagName=="VALUEMAPLABELRENDERER")this.addValueMapLabelRenderer(c,b);else if(c.tagName=="SIMPLELABELRENDERER")this.addSimpleLabelRenderer(c,b);else c.tagName==
"SCALEDEPENDENTRENDERER"&&this.addScaleDependentRenderer(c,b)}},addScaleDependentRenderer:function(a,b){if(typeof b.lower=="string"||typeof b.lower=="number")a.setAttribute("lower",b.lower);if(typeof b.upper=="string"||typeof b.upper=="number")a.setAttribute("upper",b.upper);this.addRenderer(a,b.renderer)},addValueMapLabelRenderer:function(a,b){a.setAttribute("lookupfield",b.lookupfield);a.setAttribute("labelfield",b.labelfield);if(typeof b.exacts=="object")for(var c=0,d=b.exacts.length;c<d;c++){var e=
b.exacts[c],f=this.createElementNS("","EXACT");typeof e.value=="string"&&f.setAttribute("value",e.value);typeof e.label=="string"&&f.setAttribute("label",e.label);typeof e.method=="string"&&f.setAttribute("method",e.method);a.appendChild(f);if(typeof e.symbol=="object"){var g=null;if(e.symbol.type=="text")g=this.createElementNS("","TEXTSYMBOL");if(g!=null){for(var h=this.fontStyleKeys,j=0,i=h.length;j<i;j++){var k=h[j];e.symbol[k]&&g.setAttribute(k,e.symbol[k])}f.appendChild(g)}}}},addValueMapRenderer:function(a,
b){a.setAttribute("lookupfield",b.lookupfield);if(typeof b.ranges=="object")for(var c=0,d=b.ranges.length;c<d;c++){var e=b.ranges[c],f=this.createElementNS("","RANGE");f.setAttribute("lower",e.lower);f.setAttribute("upper",e.upper);a.appendChild(f);if(typeof e.symbol=="object"){var g=null;if(e.symbol.type=="simplepolygon")g=this.createElementNS("","SIMPLEPOLYGONSYMBOL");if(g!=null){typeof e.symbol.boundarycolor=="string"&&g.setAttribute("boundarycolor",e.symbol.boundarycolor);typeof e.symbol.fillcolor==
"string"&&g.setAttribute("fillcolor",e.symbol.fillcolor);typeof e.symbol.filltransparency=="number"&&g.setAttribute("filltransparency",e.symbol.filltransparency);f.appendChild(g)}}}else if(typeof b.exacts=="object"){c=0;for(d=b.exacts.length;c<d;c++){e=b.exacts[c];f=this.createElementNS("","EXACT");typeof e.value=="string"&&f.setAttribute("value",e.value);typeof e.label=="string"&&f.setAttribute("label",e.label);typeof e.method=="string"&&f.setAttribute("method",e.method);a.appendChild(f);if(typeof e.symbol==
"object"){g=null;if(e.symbol.type=="simplemarker")g=this.createElementNS("","SIMPLEMARKERSYMBOL");if(g!=null){typeof e.symbol.antialiasing=="string"&&g.setAttribute("antialiasing",e.symbol.antialiasing);typeof e.symbol.color=="string"&&g.setAttribute("color",e.symbol.color);typeof e.symbol.outline=="string"&&g.setAttribute("outline",e.symbol.outline);typeof e.symbol.overlap=="string"&&g.setAttribute("overlap",e.symbol.overlap);typeof e.symbol.shadow=="string"&&g.setAttribute("shadow",e.symbol.shadow);
typeof e.symbol.transparency=="number"&&g.setAttribute("transparency",e.symbol.transparency);typeof e.symbol.usecentroid=="string"&&g.setAttribute("usecentroid",e.symbol.usecentroid);typeof e.symbol.width=="number"&&g.setAttribute("width",e.symbol.width);f.appendChild(g)}}}}},addSimpleLabelRenderer:function(a,b){a.setAttribute("field",b.field);for(var c=["featureweight","howmanylabels","labelbufferratio","labelpriorities","labelweight","linelabelposition","rotationalangles"],d=0,e=c.length;d<e;d++){var f=
c[d];b[f]&&a.setAttribute(f,b[f])}if(b.symbol.type=="text"){var g=b.symbol,h=this.createElementNS("","TEXTSYMBOL");a.appendChild(h);c=this.fontStyleKeys;d=0;for(e=c.length;d<e;d++){f=c[d];g[f]&&h.setAttribute(f,b[f])}}},writePolygonGeometry:function(a){if(!(a instanceof OpenLayers.Geometry.Polygon))throw{message:"Cannot write polygon geometry to ArcXML with an "+a.CLASS_NAME+" object.",geometry:a};for(var b=this.createElementNS("","POLYGON"),c=0,d=a.components.length;c<d;c++){for(var e=a.components[c],
f=this.createElementNS("","RING"),g=0,h=e.components.length;g<h;g++){var j=e.components[g],i=this.createElementNS("","POINT");i.setAttribute("x",j.x);i.setAttribute("y",j.y);f.appendChild(i)}b.appendChild(f)}return b},parseResponse:function(a){if(typeof a=="string")a=(new OpenLayers.Format.XML).read(a);var b=new OpenLayers.Format.ArcXML.Response,c=a.getElementsByTagName("ERROR");if(c!=null&&c.length>0)b.error=this.getChildValue(c,"Unknown error.");else{c=a.getElementsByTagName("RESPONSE");if(c==null||
c.length==0){b.error="No RESPONSE tag found in ArcXML response.";return b}var d=c[0].firstChild.nodeName;if(d=="#text")d=c[0].firstChild.nextSibling.nodeName;if(d=="IMAGE"){c=a.getElementsByTagName("ENVELOPE");a=a.getElementsByTagName("OUTPUT");if(c==null||c.length==0)b.error="No ENVELOPE tag found in ArcXML response.";else if(a==null||a.length==0)b.error="No OUTPUT tag found in ArcXML response.";else{c=this.parseAttributes(c[0]);d=this.parseAttributes(a[0]);b.image=typeof d.type=="string"?{envelope:c,
output:{type:d.type,data:this.getChildValue(a[0])}}:{envelope:c,output:d}}}else if(d=="FEATURES"){a=c[0].getElementsByTagName("FEATURES");c=a[0].getElementsByTagName("FEATURECOUNT");b.features.featurecount=c[0].getAttribute("count");if(b.features.featurecount>0){c=a[0].getElementsByTagName("ENVELOPE");b.features.envelope=this.parseAttributes(c[0],"number");a=a[0].getElementsByTagName("FEATURE");for(c=0;c<a.length;c++){d=new OpenLayers.Feature.Vector;for(var e=a[c].getElementsByTagName("FIELD"),f=
0;f<e.length;f++){var g=e[f].getAttribute("name"),h=e[f].getAttribute("value");d.attributes[g]=h}e=a[c].getElementsByTagName("POLYGON");if(e.length>0){e=e[0].getElementsByTagName("RING");f=[];for(g=0;g<e.length;g++){h=[];h.push(this.parsePointGeometry(e[g]));for(var j=e[g].getElementsByTagName("HOLE"),i=0;i<j.length;i++)h.push(this.parsePointGeometry(j[i]));f.push(new OpenLayers.Geometry.Polygon(h))}d.geometry=f.length==1?f[0]:new OpenLayers.Geometry.MultiPolygon(f)}b.features.feature.push(d)}}}else b.error=
"Unidentified response type."}return b},parseAttributes:function(a,b){for(var c={},d=0;d<a.attributes.length;d++)c[a.attributes[d].nodeName]=b=="number"?parseFloat(a.attributes[d].nodeValue):a.attributes[d].nodeValue;return c},parsePointGeometry:function(a){var b=[],c=a.getElementsByTagName("COORDS");if(c.length>0){a=this.getChildValue(c[0]);a=a.split(/;/);for(c=0;c<a.length;c++){var d=a[c].split(/ /);b.push(new OpenLayers.Geometry.Point(parseFloat(d[0]),parseFloat(d[1])))}}else{a=a.getElementsByTagName("POINT");
if(a.length>0)for(c=0;c<a.length;c++)b.push(new OpenLayers.Geometry.Point(parseFloat(a[c].getAttribute("x")),parseFloat(a[c].getAttribute("y"))))}return new OpenLayers.Geometry.LinearRing(b)},CLASS_NAME:"OpenLayers.Format.ArcXML"});
OpenLayers.Format.ArcXML.Request=OpenLayers.Class({initialize:function(){return OpenLayers.Util.extend(this,{get_image:{properties:{background:null,draw:true,envelope:{minx:0,miny:0,maxx:0,maxy:0},featurecoordsys:{id:0,string:"",datumtransformid:0,datumtransformstring:""},filtercoordsys:{id:0,string:"",datumtransformid:0,datumtransformstring:""},imagesize:{height:0,width:0,dpi:96,printheight:0,printwidth:0,scalesymbols:false},layerlist:[],output:{baseurl:"",legendbaseurl:"",legendname:"",legendpath:"",
legendurl:"",name:"",path:"",type:"jpg",url:""}}},get_feature:{layer:"",query:{isspatial:false,featurecoordsys:{id:0,string:"",datumtransformid:0,datumtransformstring:""},filtercoordsys:{id:0,string:"",datumtransformid:0,datumtransformstring:""},buffer:0,where:"",spatialfilter:{relation:"envelope_intersection",envelope:null}}},environment:{separators:{cs:" ",ts:";"}},layer:[],workspaces:[]})},CLASS_NAME:"OpenLayers.Format.ArcXML.Request"});
OpenLayers.Format.ArcXML.Response=OpenLayers.Class({initialize:function(){return OpenLayers.Util.extend(this,{image:{envelope:null,output:""},features:{featurecount:0,envelope:null,feature:[]},error:""})},CLASS_NAME:"OpenLayers.Format.ArcXML.Response"});
OpenLayers.Request={DEFAULT_CONFIG:{method:"GET",url:window.location.href,async:true,user:undefined,password:undefined,params:null,proxy:OpenLayers.ProxyHost,headers:{},data:null,callback:function(){},success:null,failure:null,scope:null},URL_SPLIT_REGEX:/([^:]*:)\/\/([^:]*:?[^@]*@)?([^:\/\?]*):?([^\/\?]*)/,events:new OpenLayers.Events(this,null,["complete","success","failure"]),issue:function(a){var b=OpenLayers.Util.extend(this.DEFAULT_CONFIG,{proxy:OpenLayers.ProxyHost});a=OpenLayers.Util.applyDefaults(a,
b);var c=new OpenLayers.Request.XMLHttpRequest,d=OpenLayers.Util.urlAppend(a.url,OpenLayers.Util.getParameterString(a.params||{}));b=d.indexOf("http")!=0;var e=!b&&d.match(this.URL_SPLIT_REGEX);if(e){var f=window.location;b=e[1]==f.protocol&&e[3]==f.hostname;e=e[4];f=f.port;if(e!=80&&e!=""||f!="80"&&f!="")b=b&&e==f}if(!b)if(a.proxy)d=typeof a.proxy=="function"?a.proxy(d):a.proxy+encodeURIComponent(d);else OpenLayers.Console.warn(OpenLayers.i18n("proxyNeeded"),{url:d});c.open(a.method,d,a.async,a.user,
a.password);for(var g in a.headers)c.setRequestHeader(g,a.headers[g]);var h=this.events,j=this;c.onreadystatechange=function(){c.readyState==OpenLayers.Request.XMLHttpRequest.DONE&&h.triggerEvent("complete",{request:c,config:a,requestUrl:d})!==false&&j.runCallbacks({request:c,config:a,requestUrl:d})};a.async===false?c.send(a.data):window.setTimeout(function(){c.readyState!==0&&c.send(a.data)},0);return c},runCallbacks:function(a){var b=a.request,c=a.config,d=c.scope?OpenLayers.Function.bind(c.callback,
c.scope):c.callback,e;if(c.success)e=c.scope?OpenLayers.Function.bind(c.success,c.scope):c.success;var f;if(c.failure)f=c.scope?OpenLayers.Function.bind(c.failure,c.scope):c.failure;if(OpenLayers.Util.createUrlObject(c.url).protocol=="file:"&&b.responseText)b.status=200;d(b);if(!b.status||b.status>=200&&b.status<300){this.events.triggerEvent("success",a);e&&e(b)}if(b.status&&(b.status<200||b.status>=300)){this.events.triggerEvent("failure",a);f&&f(b)}},GET:function(a){a=OpenLayers.Util.extend(a,{method:"GET"});
return OpenLayers.Request.issue(a)},POST:function(a){a=OpenLayers.Util.extend(a,{method:"POST"});a.headers=a.headers?a.headers:{};"CONTENT-TYPE"in OpenLayers.Util.upperCaseObject(a.headers)||(a.headers["Content-Type"]="application/xml");return OpenLayers.Request.issue(a)},PUT:function(a){a=OpenLayers.Util.extend(a,{method:"PUT"});a.headers=a.headers?a.headers:{};"CONTENT-TYPE"in OpenLayers.Util.upperCaseObject(a.headers)||(a.headers["Content-Type"]="application/xml");return OpenLayers.Request.issue(a)},
DELETE:function(a){a=OpenLayers.Util.extend(a,{method:"DELETE"});return OpenLayers.Request.issue(a)},HEAD:function(a){a=OpenLayers.Util.extend(a,{method:"HEAD"});return OpenLayers.Request.issue(a)},OPTIONS:function(a){a=OpenLayers.Util.extend(a,{method:"OPTIONS"});return OpenLayers.Request.issue(a)}};
OpenLayers.Layer.ArcIMS=OpenLayers.Class(OpenLayers.Layer.Grid,{DEFAULT_PARAMS:{ClientVersion:"9.2",ServiceName:""},tileSize:null,featureCoordSys:"4326",filterCoordSys:"4326",layers:null,async:true,name:"ArcIMS",isBaseLayer:true,DEFAULT_OPTIONS:{tileSize:new OpenLayers.Size(512,512),featureCoordSys:"4326",filterCoordSys:"4326",layers:null,isBaseLayer:true,async:true,name:"ArcIMS"},initialize:function(a,b,c){this.tileSize=new OpenLayers.Size(512,512);this.params=OpenLayers.Util.applyDefaults({ServiceName:c.serviceName},
this.DEFAULT_PARAMS);this.options=OpenLayers.Util.applyDefaults(c,this.DEFAULT_OPTIONS);OpenLayers.Layer.Grid.prototype.initialize.apply(this,[a,b,this.params,c]);if(this.transparent){if(!this.isBaseLayer)this.isBaseLayer=false;if(this.format=="image/jpeg")this.format=OpenLayers.Util.alphaHack()?"image/gif":"image/png"}if(this.options.layers===null)this.options.layers=[]},destroy:function(){OpenLayers.Layer.Grid.prototype.destroy.apply(this,arguments)},getURL:function(a){var b="";a=this.adjustBounds(a);
a=new OpenLayers.Format.ArcXML(OpenLayers.Util.extend(this.options,{requesttype:"image",envelope:a.toArray(),tileSize:this.tileSize}));a=new OpenLayers.Request.POST({url:this.getFullRequestString(),data:a.write(),async:false});if(a!=null){b=a.responseXML;if(!b||!b.documentElement)b=a.responseText;b=this.getUrlOrImage((new OpenLayers.Format.ArcXML).read(b).image.output)}return b},getURLasync:function(a,b,c,d){a=this.adjustBounds(a);a=new OpenLayers.Format.ArcXML(OpenLayers.Util.extend(this.options,
{requesttype:"image",envelope:a.toArray(),tileSize:this.tileSize}));OpenLayers.Request.POST({url:this.getFullRequestString(),async:true,data:a.write(),callback:function(e){var f=e.responseXML;if(!f||!f.documentElement)f=e.responseText;e=(new OpenLayers.Format.ArcXML).read(f);b[c]=this.getUrlOrImage(e.image.output);d.apply(b)},scope:this})},getUrlOrImage:function(a){var b="";if(a.url)b=a.url;else if(a.data)b="data:image/"+a.type+";base64,"+a.data;return b},setLayerQuery:function(a,b){for(var c=0;c<
this.options.layers.length;c++)if(a==this.options.layers[c].id){this.options.layers[c].query=b;return}this.options.layers.push({id:a,visible:true,query:b})},getFeatureInfo:function(a,b,c){var d=c.buffer||1,e=c.callback||function(){},f=c.scope||window,g={};OpenLayers.Util.extend(g,this.options);g.requesttype="feature";if(a instanceof OpenLayers.LonLat){g.polygon=null;g.envelope=[a.lon-d,a.lat-d,a.lon+d,a.lat+d]}else if(a instanceof OpenLayers.Geometry.Polygon){g.envelope=null;g.polygon=a}var h=new OpenLayers.Format.ArcXML(g);
OpenLayers.Util.extend(h.request.get_feature,c);h.request.get_feature.layer=b.id;if(typeof b.query.accuracy=="number")h.request.get_feature.query.accuracy=b.query.accuracy;else{a=this.map.getCenter();c=this.map.getViewPortPxFromLonLat(a);c.x++;c=this.map.getLonLatFromPixel(c);h.request.get_feature.query.accuracy=c.lon-a.lon}h.request.get_feature.query.where=b.query.where;h.request.get_feature.query.spatialfilter.relation="area_intersection";OpenLayers.Request.POST({url:this.getFullRequestString({CustomService:"Query"}),
data:h.write(),callback:function(j){j=h.parseResponse(j.responseText);h.iserror()?e.call(f,null):e.call(f,j.features)}})},clone:function(a){if(a==null)a=new OpenLayers.Layer.ArcIMS(this.name,this.url,this.getOptions());return a=OpenLayers.Layer.Grid.prototype.clone.apply(this,[a])},CLASS_NAME:"OpenLayers.Layer.ArcIMS"});OpenLayers.Lang.te=OpenLayers.Util.applyDefaults({Permalink:"\u0c38\u0c4d\u0c25\u0c3f\u0c30\u0c32\u0c3f\u0c02\u0c15\u0c41",W:"\u0c2a",E:"\u0c24\u0c42",N:"\u0c09",S:"\u0c26"});
OpenLayers.Control.PanZoom=OpenLayers.Class(OpenLayers.Control,{slideFactor:50,slideRatio:null,buttons:null,position:null,initialize:function(){this.position=new OpenLayers.Pixel(OpenLayers.Control.PanZoom.X,OpenLayers.Control.PanZoom.Y);OpenLayers.Control.prototype.initialize.apply(this,arguments)},destroy:function(){this.removeButtons();this.position=this.buttons=null;OpenLayers.Control.prototype.destroy.apply(this,arguments)},draw:function(a){OpenLayers.Control.prototype.draw.apply(this,arguments);
a=this.position;this.buttons=[];var b=new OpenLayers.Size(18,18),c=new OpenLayers.Pixel(a.x+b.w/2,a.y);this._addButton("panup","north-mini.png",c,b);a.y=c.y+b.h;this._addButton("panleft","west-mini.png",a,b);this._addButton("panright","east-mini.png",a.add(b.w,0),b);this._addButton("pandown","south-mini.png",c.add(0,b.h*2),b);this._addButton("zoomin","zoom-plus-mini.png",c.add(0,b.h*3+5),b);this._addButton("zoomworld","zoom-world-mini.png",c.add(0,b.h*4+5),b);this._addButton("zoomout","zoom-minus-mini.png",
c.add(0,b.h*5+5),b);return this.div},_addButton:function(a,b,c,d){b=OpenLayers.Util.getImagesLocation()+b;c=OpenLayers.Util.createAlphaImageDiv(this.id+"_"+a,c,d,b,"absolute");c.style.cursor="pointer";this.div.appendChild(c);OpenLayers.Event.observe(c,"mousedown",OpenLayers.Function.bindAsEventListener(this.buttonDown,c));OpenLayers.Event.observe(c,"dblclick",OpenLayers.Function.bindAsEventListener(this.doubleClick,c));OpenLayers.Event.observe(c,"click",OpenLayers.Function.bindAsEventListener(this.doubleClick,
c));c.action=a;c.map=this.map;if(this.slideRatio){var e=this.slideRatio;a=function(g){return this.map.getSize()[g]*e}}else{var f=this.slideFactor;a=function(){return f}}c.getSlideFactor=a;this.buttons.push(c);return c},_removeButton:function(a){OpenLayers.Event.stopObservingElement(a);a.map=null;a.getSlideFactor=null;this.div.removeChild(a);OpenLayers.Util.removeItem(this.buttons,a)},removeButtons:function(){for(var a=this.buttons.length-1;a>=0;--a)this._removeButton(this.buttons[a])},doubleClick:function(a){OpenLayers.Event.stop(a);
return false},buttonDown:function(a){if(OpenLayers.Event.isLeftClick(a)){switch(this.action){case "panup":this.map.pan(0,-this.getSlideFactor("h"));break;case "pandown":this.map.pan(0,this.getSlideFactor("h"));break;case "panleft":this.map.pan(-this.getSlideFactor("w"),0);break;case "panright":this.map.pan(this.getSlideFactor("w"),0);break;case "zoomin":this.map.zoomIn();break;case "zoomout":this.map.zoomOut();break;case "zoomworld":this.map.zoomToMaxExtent()}OpenLayers.Event.stop(a)}},CLASS_NAME:"OpenLayers.Control.PanZoom"});
OpenLayers.Control.PanZoom.X=4;OpenLayers.Control.PanZoom.Y=4;
OpenLayers.Control.PanZoomBar=OpenLayers.Class(OpenLayers.Control.PanZoom,{zoomStopWidth:18,zoomStopHeight:11,slider:null,sliderEvents:null,zoombarDiv:null,divEvents:null,zoomWorldIcon:false,panIcons:true,forceFixedZoomLevel:false,mouseDragStart:null,deltaY:null,zoomStart:null,destroy:function(){this._removeZoomBar();this.map.events.un({changebaselayer:this.redraw,scope:this});OpenLayers.Control.PanZoom.prototype.destroy.apply(this,arguments);delete this.mouseDragStart;delete this.zoomStart},setMap:function(){OpenLayers.Control.PanZoom.prototype.setMap.apply(this,
arguments);this.map.events.register("changebaselayer",this,this.redraw)},redraw:function(){if(this.div!=null){this.removeButtons();this._removeZoomBar()}this.draw()},draw:function(a){OpenLayers.Control.prototype.draw.apply(this,arguments);a=this.position.clone();this.buttons=[];var b=new OpenLayers.Size(18,18);if(this.panIcons){var c=new OpenLayers.Pixel(a.x+b.w/2,a.y),d=b.w;if(this.zoomWorldIcon)c=new OpenLayers.Pixel(a.x+b.w,a.y);this._addButton("panup","north-mini.png",c,b);a.y=c.y+b.h;this._addButton("panleft",
"west-mini.png",a,b);if(this.zoomWorldIcon){this._addButton("zoomworld","zoom-world-mini.png",a.add(b.w,0),b);d*=2}this._addButton("panright","east-mini.png",a.add(d,0),b);this._addButton("pandown","south-mini.png",c.add(0,b.h*2),b);this._addButton("zoomin","zoom-plus-mini.png",c.add(0,b.h*3+5),b);c=this._addZoomBar(c.add(0,b.h*4+5));this._addButton("zoomout","zoom-minus-mini.png",c,b)}else{this._addButton("zoomin","zoom-plus-mini.png",a,b);c=this._addZoomBar(a.add(0,b.h));this._addButton("zoomout",
"zoom-minus-mini.png",c,b);if(this.zoomWorldIcon){c=c.add(0,b.h+3);this._addButton("zoomworld","zoom-world-mini.png",c,b)}}return this.div},_addZoomBar:function(a){var b=OpenLayers.Util.getImagesLocation(),c=this.id+"_"+this.map.id,d=this.map.getNumZoomLevels()-1-this.map.getZoom();d=OpenLayers.Util.createAlphaImageDiv(c,a.add(-1,d*this.zoomStopHeight),new OpenLayers.Size(20,9),b+"slider.png","absolute");d.style.cursor="move";this.slider=d;this.sliderEvents=new OpenLayers.Events(this,d,null,true,
{includeXY:true});this.sliderEvents.on({touchstart:this.zoomBarDown,touchmove:this.zoomBarDrag,touchend:this.zoomBarUp,mousedown:this.zoomBarDown,mousemove:this.zoomBarDrag,mouseup:this.zoomBarUp,dblclick:this.doubleClick,click:this.doubleClick});var e=new OpenLayers.Size;e.h=this.zoomStopHeight*this.map.getNumZoomLevels();e.w=this.zoomStopWidth;c=null;if(OpenLayers.Util.alphaHack()){c=this.id+"_"+this.map.id;c=OpenLayers.Util.createAlphaImageDiv(c,a,new OpenLayers.Size(e.w,this.zoomStopHeight),b+
"zoombar.png","absolute",null,"crop");c.style.height=e.h+"px"}else c=OpenLayers.Util.createDiv("OpenLayers_Control_PanZoomBar_Zoombar"+this.map.id,a,e,b+"zoombar.png");c.style.cursor="pointer";this.zoombarDiv=c;this.divEvents=new OpenLayers.Events(this,c,null,true,{includeXY:true});this.divEvents.on({touchmove:this.passEventToSlider,mousedown:this.divClick,mousemove:this.passEventToSlider,dblclick:this.doubleClick,click:this.doubleClick});this.div.appendChild(c);this.startTop=parseInt(c.style.top);
this.div.appendChild(d);this.map.events.register("zoomend",this,this.moveZoomBar);return a=a.add(0,this.zoomStopHeight*this.map.getNumZoomLevels())},_removeZoomBar:function(){this.sliderEvents.un({touchmove:this.zoomBarDrag,mousedown:this.zoomBarDown,mousemove:this.zoomBarDrag,mouseup:this.zoomBarUp,dblclick:this.doubleClick,click:this.doubleClick});this.sliderEvents.destroy();this.divEvents.un({touchmove:this.passEventToSlider,mousedown:this.divClick,mousemove:this.passEventToSlider,dblclick:this.doubleClick,
click:this.doubleClick});this.divEvents.destroy();this.div.removeChild(this.zoombarDiv);this.zoombarDiv=null;this.div.removeChild(this.slider);this.slider=null;this.map.events.unregister("zoomend",this,this.moveZoomBar)},passEventToSlider:function(a){this.sliderEvents.handleBrowserEvent(a)},divClick:function(a){if(OpenLayers.Event.isLeftClick(a)){var b=a.xy.y/this.zoomStopHeight;if(this.forceFixedZoomLevel||!this.map.fractionalZoom)b=Math.floor(b);b=this.map.getNumZoomLevels()-1-b;b=Math.min(Math.max(b,
0),this.map.getNumZoomLevels()-1);this.map.zoomTo(b);OpenLayers.Event.stop(a)}},zoomBarDown:function(a){if(OpenLayers.Event.isLeftClick(a)||OpenLayers.Event.isSingleTouch(a)){this.map.events.on({touchmove:this.passEventToSlider,mousemove:this.passEventToSlider,mouseup:this.passEventToSlider,scope:this});this.mouseDragStart=a.xy.clone();this.zoomStart=a.xy.clone();this.div.style.cursor="move";this.zoombarDiv.offsets=null;OpenLayers.Event.stop(a)}},zoomBarDrag:function(a){if(this.mouseDragStart!=null){var b=
this.mouseDragStart.y-a.xy.y,c=OpenLayers.Util.pagePosition(this.zoombarDiv);if(a.clientY-c[1]>0&&a.clientY-c[1]<parseInt(this.zoombarDiv.style.height)-2){this.slider.style.top=parseInt(this.slider.style.top)-b+"px";this.mouseDragStart=a.xy.clone()}this.deltaY=this.zoomStart.y-a.xy.y;OpenLayers.Event.stop(a)}},zoomBarUp:function(a){if(!(!OpenLayers.Event.isLeftClick(a)&&a.type!=="touchend"))if(this.mouseDragStart){this.div.style.cursor="";this.map.events.un({touchmove:this.passEventToSlider,mouseup:this.passEventToSlider,
mousemove:this.passEventToSlider,scope:this});var b=this.map.zoom;if(!this.forceFixedZoomLevel&&this.map.fractionalZoom){b+=this.deltaY/this.zoomStopHeight;b=Math.min(Math.max(b,0),this.map.getNumZoomLevels()-1)}else{b+=this.deltaY/this.zoomStopHeight;b=Math.max(Math.round(b),0)}this.map.zoomTo(b);this.zoomStart=this.mouseDragStart=null;this.deltaY=0;OpenLayers.Event.stop(a)}},moveZoomBar:function(){this.slider.style.top=(this.map.getNumZoomLevels()-1-this.map.getZoom())*this.zoomStopHeight+this.startTop+
1+"px"},CLASS_NAME:"OpenLayers.Control.PanZoomBar"});
OpenLayers.Layer.Image=OpenLayers.Class(OpenLayers.Layer,{isBaseLayer:true,url:null,extent:null,size:null,tile:null,aspectRatio:null,initialize:function(a,b,c,d,e){this.url=b;this.maxExtent=this.extent=c;this.size=d;OpenLayers.Layer.prototype.initialize.apply(this,[a,e]);this.aspectRatio=this.extent.getHeight()/this.size.h/(this.extent.getWidth()/this.size.w)},destroy:function(){if(this.tile){this.removeTileMonitoringHooks(this.tile);this.tile.destroy();this.tile=null}OpenLayers.Layer.prototype.destroy.apply(this,
arguments)},clone:function(a){if(a==null)a=new OpenLayers.Layer.Image(this.name,this.url,this.extent,this.size,this.getOptions());return a=OpenLayers.Layer.prototype.clone.apply(this,[a])},setMap:function(){if(this.options.maxResolution==null)this.options.maxResolution=this.aspectRatio*this.extent.getWidth()/this.size.w;OpenLayers.Layer.prototype.setMap.apply(this,arguments)},moveTo:function(a,b){OpenLayers.Layer.prototype.moveTo.apply(this,arguments);var c=this.tile==null;if(b||c){this.setTileSize();
var d=this.map.getLayerPxFromLonLat(new OpenLayers.LonLat(this.extent.left,this.extent.top));if(c){this.tile=new OpenLayers.Tile.Image(this,d,this.extent,null,this.tileSize);this.addTileMonitoringHooks(this.tile)}else{this.tile.size=this.tileSize.clone();this.tile.position=d.clone()}this.tile.draw()}},setTileSize:function(){var a=this.extent.getWidth()/this.map.getResolution(),b=this.extent.getHeight()/this.map.getResolution();this.tileSize=new OpenLayers.Size(a,b)},addTileMonitoringHooks:function(a){a.onLoadStart=
function(){this.events.triggerEvent("loadstart")};a.events.register("loadstart",this,a.onLoadStart);a.onLoadEnd=function(){this.events.triggerEvent("loadend")};a.events.register("loadend",this,a.onLoadEnd);a.events.register("unload",this,a.onLoadEnd)},removeTileMonitoringHooks:function(a){a.unload();a.events.un({loadstart:a.onLoadStart,loadend:a.onLoadEnd,unload:a.onLoadEnd,scope:this})},setUrl:function(a){this.url=a;this.tile.draw()},getURL:function(){return this.url},CLASS_NAME:"OpenLayers.Layer.Image"});
OpenLayers.Strategy=OpenLayers.Class({layer:null,options:null,active:null,autoActivate:true,autoDestroy:true,initialize:function(a){OpenLayers.Util.extend(this,a);this.options=a;this.active=false},destroy:function(){this.deactivate();this.options=this.layer=null},setLayer:function(a){this.layer=a},activate:function(){if(!this.active)return this.active=true;return false},deactivate:function(){if(this.active){this.active=false;return true}return false},CLASS_NAME:"OpenLayers.Strategy"});
OpenLayers.Strategy.Save=OpenLayers.Class(OpenLayers.Strategy,{EVENT_TYPES:["start","success","fail"],events:null,auto:false,timer:null,initialize:function(a){OpenLayers.Strategy.prototype.initialize.apply(this,[a]);this.events=new OpenLayers.Events(this,null,this.EVENT_TYPES)},activate:function(){var a=OpenLayers.Strategy.prototype.activate.call(this);if(a)if(this.auto)if(typeof this.auto==="number")this.timer=window.setInterval(OpenLayers.Function.bind(this.save,this),this.auto*1E3);else this.layer.events.on({featureadded:this.triggerSave,
afterfeaturemodified:this.triggerSave,scope:this});return a},deactivate:function(){var a=OpenLayers.Strategy.prototype.deactivate.call(this);if(a)if(this.auto)typeof this.auto==="number"?window.clearInterval(this.timer):this.layer.events.un({featureadded:this.triggerSave,afterfeaturemodified:this.triggerSave,scope:this});return a},triggerSave:function(a){var b=a.feature;if(b.state===OpenLayers.State.INSERT||b.state===OpenLayers.State.UPDATE||b.state===OpenLayers.State.DELETE)this.save([a.feature])},
save:function(a){if(!a)a=this.layer.features;this.events.triggerEvent("start",{features:a});var b=this.layer.projection,c=this.layer.map.getProjectionObject();if(!c.equals(b)){for(var d=a.length,e=Array(d),f,g,h=0;h<d;++h){f=a[h];g=f.clone();g.fid=f.fid;g.state=f.state;if(f.url)g.url=f.url;g._original=f;g.geometry.transform(c,b);e[h]=g}a=e}this.layer.protocol.commit(a,{callback:this.onCommit,scope:this})},onCommit:function(a){var b={response:a};if(a.success()){for(var c=a.reqFeatures,d,e=[],f=a.insertIds||
[],g=0,h=0,j=c.length;h<j;++h){d=c[h];d=d._original||d;if(a=d.state){if(a==OpenLayers.State.DELETE)e.push(d);else if(a==OpenLayers.State.INSERT){d.fid=f[g];++g}d.state=null}}e.length>0&&this.layer.destroyFeatures(e);this.events.triggerEvent("success",b)}else this.events.triggerEvent("fail",b)},CLASS_NAME:"OpenLayers.Strategy.Save"});
OpenLayers.Format.GPX=OpenLayers.Class(OpenLayers.Format.XML,{extractWaypoints:true,extractTracks:true,extractRoutes:true,extractAttributes:true,initialize:function(a){this.externalProjection=new OpenLayers.Projection("EPSG:4326");OpenLayers.Format.XML.prototype.initialize.apply(this,[a])},read:function(a){if(typeof a=="string")a=OpenLayers.Format.XML.prototype.read.apply(this,[a]);var b=[];if(this.extractTracks)for(var c=a.getElementsByTagName("trk"),d=0,e=c.length;d<e;d++){var f={};if(this.extractAttributes)f=
this.parseAttributes(c[d]);for(var g=this.getElementsByTagNameNS(c[d],c[d].namespaceURI,"trkseg"),h=0,j=g.length;h<j;h++){var i=this.extractSegment(g[h],"trkpt");b.push(new OpenLayers.Feature.Vector(i,f))}}if(this.extractRoutes){e=a.getElementsByTagName("rte");c=0;for(d=e.length;c<d;c++){f={};if(this.extractAttributes)f=this.parseAttributes(e[c]);g=this.extractSegment(e[c],"rtept");b.push(new OpenLayers.Feature.Vector(g,f))}}if(this.extractWaypoints){a=a.getElementsByTagName("wpt");c=0;for(e=a.length;c<
e;c++){f={};if(this.extractAttributes)f=this.parseAttributes(a[c]);d=new OpenLayers.Geometry.Point(a[c].getAttribute("lon"),a[c].getAttribute("lat"));b.push(new OpenLayers.Feature.Vector(d,f))}}if(this.internalProjection&&this.externalProjection){f=0;for(a=b.length;f<a;f++)b[f].geometry.transform(this.externalProjection,this.internalProjection)}return b},extractSegment:function(a,b){for(var c=this.getElementsByTagNameNS(a,a.namespaceURI,b),d=[],e=0,f=c.length;e<f;e++)d.push(new OpenLayers.Geometry.Point(c[e].getAttribute("lon"),
c[e].getAttribute("lat")));return new OpenLayers.Geometry.LineString(d)},parseAttributes:function(a){var b={};a=a.firstChild;for(var c,d;a;){if(a.nodeType==1){c=a.firstChild;if(c.nodeType==3||c.nodeType==4){d=a.prefix?a.nodeName.split(":")[1]:a.nodeName;if(d!="trkseg"&&d!="rtept")b[d]=c.nodeValue}}a=a.nextSibling}return b},CLASS_NAME:"OpenLayers.Format.GPX"});
OpenLayers.Control.OverviewMap=OpenLayers.Class(OpenLayers.Control,{element:null,ovmap:null,size:new OpenLayers.Size(180,90),layers:null,minRectSize:15,minRectDisplayClass:"RectReplacement",minRatio:8,maxRatio:32,mapOptions:null,autoPan:false,handlers:null,resolutionFactor:1,maximized:false,initialize:function(a){this.layers=[];this.handlers={};OpenLayers.Control.prototype.initialize.apply(this,[a])},destroy:function(){if(this.mapDiv){this.handlers.click&&this.handlers.click.destroy();this.handlers.drag&&
this.handlers.drag.destroy();this.ovmap&&this.ovmap.eventsDiv.removeChild(this.extentRectangle);this.extentRectangle=null;if(this.rectEvents){this.rectEvents.destroy();this.rectEvents=null}if(this.ovmap){this.ovmap.destroy();this.ovmap=null}this.element.removeChild(this.mapDiv);this.mapDiv=null;this.div.removeChild(this.element);this.element=null;if(this.maximizeDiv){OpenLayers.Event.stopObservingElement(this.maximizeDiv);this.div.removeChild(this.maximizeDiv);this.maximizeDiv=null}if(this.minimizeDiv){OpenLayers.Event.stopObservingElement(this.minimizeDiv);
this.div.removeChild(this.minimizeDiv);this.minimizeDiv=null}this.map.events.un({moveend:this.update,changebaselayer:this.baseLayerDraw,scope:this});OpenLayers.Control.prototype.destroy.apply(this,arguments)}},draw:function(){OpenLayers.Control.prototype.draw.apply(this,arguments);if(!(this.layers.length>0))if(this.map.baseLayer)this.layers=[this.map.baseLayer.clone()];else{this.map.events.register("changebaselayer",this,this.baseLayerDraw);return this.div}this.element=document.createElement("div");
this.element.className=this.displayClass+"Element";this.element.style.display="none";this.mapDiv=document.createElement("div");this.mapDiv.style.width=this.size.w+"px";this.mapDiv.style.height=this.size.h+"px";this.mapDiv.style.position="relative";this.mapDiv.style.overflow="hidden";this.mapDiv.id=OpenLayers.Util.createUniqueID("overviewMap");this.extentRectangle=document.createElement("div");this.extentRectangle.style.position="absolute";this.extentRectangle.style.zIndex=1E3;this.extentRectangle.className=
this.displayClass+"ExtentRectangle";this.element.appendChild(this.mapDiv);this.div.appendChild(this.element);if(this.outsideViewport)this.element.style.display="";else{this.div.className+=" "+this.displayClass+"Container";var a=OpenLayers.Util.getImagesLocation();this.maximizeDiv=OpenLayers.Util.createAlphaImageDiv(this.displayClass+"MaximizeButton",null,new OpenLayers.Size(18,18),a+"layer-switcher-maximize.png","absolute");this.maximizeDiv.style.display="none";this.maximizeDiv.className=this.displayClass+
"MaximizeButton";OpenLayers.Event.observe(this.maximizeDiv,"click",OpenLayers.Function.bindAsEventListener(this.maximizeControl,this));this.div.appendChild(this.maximizeDiv);this.minimizeDiv=OpenLayers.Util.createAlphaImageDiv("OpenLayers_Control_minimizeDiv",null,new OpenLayers.Size(18,18),a+"layer-switcher-minimize.png","absolute");this.minimizeDiv.style.display="none";this.minimizeDiv.className=this.displayClass+"MinimizeButton";OpenLayers.Event.observe(this.minimizeDiv,"click",OpenLayers.Function.bindAsEventListener(this.minimizeControl,
this));this.div.appendChild(this.minimizeDiv);a=["dblclick","mousedown"];for(var b=0,c=a.length;b<c;b++){OpenLayers.Event.observe(this.maximizeDiv,a[b],OpenLayers.Event.stop);OpenLayers.Event.observe(this.minimizeDiv,a[b],OpenLayers.Event.stop)}this.minimizeControl()}this.map.getExtent()&&this.update();this.map.events.register("moveend",this,this.update);this.maximized&&this.maximizeControl();return this.div},baseLayerDraw:function(){this.draw();this.map.events.unregister("changebaselayer",this,this.baseLayerDraw)},
rectDrag:function(a){var b=this.handlers.drag.last.x-a.x,c=this.handlers.drag.last.y-a.y;if(b!=0||c!=0){var d=this.rectPxBounds.top,e=this.rectPxBounds.left;a=Math.abs(this.rectPxBounds.getHeight());var f=this.rectPxBounds.getWidth();c=Math.max(0,d-c);c=Math.min(c,this.ovmap.size.h-this.hComp-a);b=Math.max(0,e-b);b=Math.min(b,this.ovmap.size.w-this.wComp-f);this.setRectPxBounds(new OpenLayers.Bounds(b,c+a,b+f,c))}},mapDivClick:function(a){var b=this.rectPxBounds.getCenterPixel(),c=a.xy.x-b.x,d=a.xy.y-
b.y,e=this.rectPxBounds.top,f=this.rectPxBounds.left;a=Math.abs(this.rectPxBounds.getHeight());b=this.rectPxBounds.getWidth();d=Math.max(0,e+d);d=Math.min(d,this.ovmap.size.h-a);c=Math.max(0,f+c);c=Math.min(c,this.ovmap.size.w-b);this.setRectPxBounds(new OpenLayers.Bounds(c,d+a,c+b,d));this.updateMapToRect()},maximizeControl:function(a){this.element.style.display="";this.showToggle(false);a!=null&&OpenLayers.Event.stop(a)},minimizeControl:function(a){this.element.style.display="none";this.showToggle(true);
a!=null&&OpenLayers.Event.stop(a)},showToggle:function(a){this.maximizeDiv.style.display=a?"":"none";this.minimizeDiv.style.display=a?"none":""},update:function(){this.ovmap==null&&this.createMap();if(this.autoPan||!this.isSuitableOverview())this.updateOverview();this.updateRectToMap()},isSuitableOverview:function(){var a=this.map.getExtent(),b=this.map.maxExtent;a=new OpenLayers.Bounds(Math.max(a.left,b.left),Math.max(a.bottom,b.bottom),Math.min(a.right,b.right),Math.min(a.top,b.top));if(this.ovmap.getProjection()!=
this.map.getProjection())a=a.transform(this.map.getProjectionObject(),this.ovmap.getProjectionObject());b=this.ovmap.getResolution()/this.map.getResolution();return b>this.minRatio&&b<=this.maxRatio&&this.ovmap.getExtent().containsBounds(a)},updateOverview:function(){var a=this.map.getResolution(),b=this.ovmap.getResolution(),c=b/a;if(c>this.maxRatio)b=this.minRatio*a;else if(c<=this.minRatio)b=this.maxRatio*a;if(this.ovmap.getProjection()!=this.map.getProjection()){a=this.map.center.clone();a.transform(this.map.getProjectionObject(),
this.ovmap.getProjectionObject())}else a=this.map.center;this.ovmap.setCenter(a,this.ovmap.getZoomForResolution(b*this.resolutionFactor));this.updateRectToMap()},createMap:function(){var a=OpenLayers.Util.extend({controls:[],maxResolution:"auto",fallThrough:false},this.mapOptions);this.ovmap=new OpenLayers.Map(this.mapDiv,a);this.ovmap.eventsDiv.appendChild(this.extentRectangle);OpenLayers.Event.stopObserving(window,"unload",this.ovmap.unloadDestroy);this.ovmap.addLayers(this.layers);this.ovmap.zoomToMaxExtent();
this.wComp=(this.wComp=parseInt(OpenLayers.Element.getStyle(this.extentRectangle,"border-left-width"))+parseInt(OpenLayers.Element.getStyle(this.extentRectangle,"border-right-width")))?this.wComp:2;this.hComp=(this.hComp=parseInt(OpenLayers.Element.getStyle(this.extentRectangle,"border-top-width"))+parseInt(OpenLayers.Element.getStyle(this.extentRectangle,"border-bottom-width")))?this.hComp:2;this.handlers.drag=new OpenLayers.Handler.Drag(this,{move:this.rectDrag,done:this.updateMapToRect},{map:this.ovmap});
this.handlers.click=new OpenLayers.Handler.Click(this,{click:this.mapDivClick},{single:true,"double":false,stopSingle:true,stopDouble:true,pixelTolerance:1,map:this.ovmap});this.handlers.click.activate();this.rectEvents=new OpenLayers.Events(this,this.extentRectangle,null,true);this.rectEvents.register("mouseover",this,function(){!this.handlers.drag.active&&!this.map.dragging&&this.handlers.drag.activate()});this.rectEvents.register("mouseout",this,function(){this.handlers.drag.dragging||this.handlers.drag.deactivate()});
if(this.ovmap.getProjection()!=this.map.getProjection()){a=this.map.getProjectionObject().getUnits()||this.map.units||this.map.baseLayer.units;var b=this.ovmap.getProjectionObject().getUnits()||this.ovmap.units||this.ovmap.baseLayer.units;this.resolutionFactor=a&&b?OpenLayers.INCHES_PER_UNIT[a]/OpenLayers.INCHES_PER_UNIT[b]:1}},updateRectToMap:function(){var a=this.getRectBoundsFromMapBounds(this.ovmap.getProjection()!=this.map.getProjection()?this.map.getExtent().transform(this.map.getProjectionObject(),
this.ovmap.getProjectionObject()):this.map.getExtent());a&&this.setRectPxBounds(a)},updateMapToRect:function(){var a=this.getMapBoundsFromRectBounds(this.rectPxBounds);if(this.ovmap.getProjection()!=this.map.getProjection())a=a.transform(this.ovmap.getProjectionObject(),this.map.getProjectionObject());this.map.panTo(a.getCenterLonLat())},setRectPxBounds:function(a){var b=Math.max(a.top,0),c=Math.max(a.left,0),d=Math.min(a.top+Math.abs(a.getHeight()),this.ovmap.size.h-this.hComp);a=Math.min(a.left+
a.getWidth(),this.ovmap.size.w-this.wComp);var e=Math.max(a-c,0),f=Math.max(d-b,0);if(e<this.minRectSize||f<this.minRectSize){this.extentRectangle.className=this.displayClass+this.minRectDisplayClass;e=c+e/2-this.minRectSize/2;this.extentRectangle.style.top=Math.round(b+f/2-this.minRectSize/2)+"px";this.extentRectangle.style.left=Math.round(e)+"px";this.extentRectangle.style.height=this.minRectSize+"px";this.extentRectangle.style.width=this.minRectSize+"px"}else{this.extentRectangle.className=this.displayClass+
"ExtentRectangle";this.extentRectangle.style.top=Math.round(b)+"px";this.extentRectangle.style.left=Math.round(c)+"px";this.extentRectangle.style.height=Math.round(f)+"px";this.extentRectangle.style.width=Math.round(e)+"px"}this.rectPxBounds=new OpenLayers.Bounds(Math.round(c),Math.round(d),Math.round(a),Math.round(b))},getRectBoundsFromMapBounds:function(a){var b=new OpenLayers.LonLat(a.left,a.bottom);a=new OpenLayers.LonLat(a.right,a.top);b=this.getOverviewPxFromLonLat(b);a=this.getOverviewPxFromLonLat(a);
var c=null;if(b&&a)c=new OpenLayers.Bounds(b.x,b.y,a.x,a.y);return c},getMapBoundsFromRectBounds:function(a){var b=new OpenLayers.Pixel(a.left,a.bottom);a=new OpenLayers.Pixel(a.right,a.top);b=this.getLonLatFromOverviewPx(b);a=this.getLonLatFromOverviewPx(a);return new OpenLayers.Bounds(b.lon,b.lat,a.lon,a.lat)},getLonLatFromOverviewPx:function(a){var b=this.ovmap.size,c=this.ovmap.getResolution(),d=this.ovmap.getExtent().getCenterLonLat();return new OpenLayers.LonLat(d.lon+(a.x-b.w/2)*c,d.lat-(a.y-
b.h/2)*c)},getOverviewPxFromLonLat:function(a){var b=this.ovmap.getResolution(),c=this.ovmap.getExtent(),d=null;if(c)d=new OpenLayers.Pixel(Math.round(1/b*(a.lon-c.left)),Math.round(1/b*(c.top-a.lat)));return d},CLASS_NAME:"OpenLayers.Control.OverviewMap"});
OpenLayers.Format.WMSDescribeLayer=OpenLayers.Class(OpenLayers.Format.XML.VersionedOGC,{defaultVersion:"1.1.1",getVersion:function(){var a=OpenLayers.Format.XML.VersionedOGC.prototype.getVersion.apply(this,arguments);if(a=="1.1.1"||a=="1.1.0")a="1.1";return a},CLASS_NAME:"OpenLayers.Format.WMSDescribeLayer"});
OpenLayers.Format.WMSDescribeLayer.v1_1=OpenLayers.Class(OpenLayers.Format.WMSDescribeLayer,{initialize:function(a){OpenLayers.Format.WMSDescribeLayer.prototype.initialize.apply(this,[a])},read:function(a){if(typeof a=="string")a=OpenLayers.Format.XML.prototype.read.apply(this,[a]);a=a.documentElement.childNodes;for(var b=[],c,d,e=0;e<a.length;++e){c=a[e];d=c.nodeName;if(d=="LayerDescription"){d=c.getAttribute("name");var f="",g="",h="";if(c.getAttribute("owsType")){f=c.getAttribute("owsType");g=
c.getAttribute("owsURL")}else if(c.getAttribute("wfs")!=""){f="WFS";g=c.getAttribute("wfs")}else if(c.getAttribute("wcs")!=""){f="WCS";g=c.getAttribute("wcs")}c=c.getElementsByTagName("Query");if(c.length>0)(h=c[0].getAttribute("typeName"))||(h=c[0].getAttribute("typename"));b.push({layerName:d,owsType:f,owsURL:g,typeName:h})}}return b},CLASS_NAME:"OpenLayers.Format.WMSDescribeLayer.v1_1"});
OpenLayers.Format.WFSDescribeFeatureType=OpenLayers.Class(OpenLayers.Format.XML,{namespaces:{xsd:"http://www.w3.org/2001/XMLSchema"},readers:{xsd:{schema:function(a,b){var c=[],d={};this.readChildNodes(a,{complexTypes:c,customTypes:d});for(var e=a.attributes,f,g,h=0,j=e.length;h<j;++h){f=e[h];g=f.name;if(g.indexOf("xmlns")==0)this.setNamespace(g.split(":")[1]||"",f.value);else b[g]=f.value}b.featureTypes=c;b.targetPrefix=this.namespaceAlias[b.targetNamespace];h=0;for(j=c.length;h<j;++h){e=c[h];f=
d[e.typeName];if(d[e.typeName])e.typeName=f.name}},complexType:function(a,b){var c={typeName:a.getAttribute("name")};this.readChildNodes(a,c);b.complexTypes.push(c)},complexContent:function(a,b){this.readChildNodes(a,b)},extension:function(a,b){this.readChildNodes(a,b)},sequence:function(a,b){var c={elements:[]};this.readChildNodes(a,c);b.properties=c.elements},element:function(a,b){if(b.elements){for(var c={},d=a.attributes,e,f=0,g=d.length;f<g;++f){e=d[f];c[e.name]=e.value}d=c.type;if(!d){d={};
this.readChildNodes(a,d);c.restriction=d;c.type=d.base}c.localType=(d.base||d).split(":").pop();b.elements.push(c)}if(b.complexTypes){d=a.getAttribute("type");c=d.split(":").pop();b.customTypes[c]={name:a.getAttribute("name"),type:d}}},simpleType:function(a,b){this.readChildNodes(a,b)},restriction:function(a,b){b.base=a.getAttribute("base");this.readRestriction(a,b)}}},readRestriction:function(a,b){for(var c=a.childNodes,d,e,f=0,g=c.length;f<g;++f){d=c[f];if(d.nodeType==1){e=d.nodeName.split(":").pop();
d=d.getAttribute("value");if(b[e]){if(typeof b[e]=="string")b[e]=[b[e]];b[e].push(d)}else b[e]=d}}},read:function(a){if(typeof a=="string")a=OpenLayers.Format.XML.prototype.read.apply(this,[a]);if(a&&a.nodeType==9)a=a.documentElement;var b={};this.readNode(a,b);return b},CLASS_NAME:"OpenLayers.Format.WFSDescribeFeatureType"});
OpenLayers.Renderer=OpenLayers.Class({container:null,root:null,extent:null,locked:false,size:null,resolution:null,map:null,initialize:function(a,b){this.container=OpenLayers.Util.getElement(a);OpenLayers.Util.extend(this,b)},destroy:function(){this.map=this.resolution=this.size=this.extent=this.container=null},supported:function(){return false},setExtent:function(a,b){this.extent=a.clone();if(b)this.resolution=null},setSize:function(a){this.size=a.clone();this.resolution=null},getResolution:function(){return this.resolution=
this.resolution||this.map.getResolution()},drawFeature:function(a,b){if(b==null)b=a.style;if(a.geometry){var c=a.geometry.getBounds();if(c){c.intersectsBounds(this.extent)||(b={display:"none"});c=this.drawGeometry(a.geometry,b,a.id);if(b.display!="none"&&b.label&&c!==false){var d=a.geometry.getCentroid();if(b.labelXOffset||b.labelYOffset){var e=isNaN(b.labelXOffset)?0:b.labelXOffset,f=isNaN(b.labelYOffset)?0:b.labelYOffset,g=this.getResolution();d.move(e*g,f*g)}this.drawText(a.id,b,d)}else this.removeText(a.id);
return c}}},drawGeometry:function(){},drawText:function(){},removeText:function(){},clear:function(){},getFeatureIdFromEvent:function(){},eraseFeatures:function(a){OpenLayers.Util.isArray(a)||(a=[a]);for(var b=0,c=a.length;b<c;++b){var d=a[b];this.eraseGeometry(d.geometry,d.id);this.removeText(d.id)}},eraseGeometry:function(){},moveRoot:function(){},getRenderLayerId:function(){return this.container.id},applyDefaultSymbolizer:function(a){var b=OpenLayers.Util.extend({},OpenLayers.Renderer.defaultSymbolizer);
if(a.stroke===false){delete b.strokeWidth;delete b.strokeColor}a.fill===false&&delete b.fillColor;OpenLayers.Util.extend(b,a);return b},CLASS_NAME:"OpenLayers.Renderer"});OpenLayers.Renderer.defaultSymbolizer={fillColor:"#000000",strokeColor:"#000000",strokeWidth:2,fillOpacity:1,strokeOpacity:1,pointRadius:0};
OpenLayers.Renderer.Canvas=OpenLayers.Class(OpenLayers.Renderer,{hitDetection:true,hitOverflow:0,canvas:null,features:null,pendingRedraw:false,initialize:function(){OpenLayers.Renderer.prototype.initialize.apply(this,arguments);this.root=document.createElement("canvas");this.container.appendChild(this.root);this.canvas=this.root.getContext("2d");this.features={};if(this.hitDetection){this.hitCanvas=document.createElement("canvas");this.hitContext=this.hitCanvas.getContext("2d")}},eraseGeometry:function(a,
b){this.eraseFeatures(this.features[b][0])},supported:function(){return!!document.createElement("canvas").getContext},setSize:function(a){this.size=a.clone();var b=this.root;b.style.width=a.w+"px";b.style.height=a.h+"px";b.width=a.w;b.height=a.h;this.resolution=null;if(this.hitDetection){b=this.hitCanvas;b.style.width=a.w+"px";b.style.height=a.h+"px";b.width=a.w;b.height=a.h}},drawFeature:function(a,b){var c;if(a.geometry){b=this.applyDefaultSymbolizer(b||a.style);c=a.geometry.getBounds();if(c=b.display!==
"none"&&!!c&&c.intersectsBounds(this.extent))this.features[a.id]=[a,b];else delete this.features[a.id];this.pendingRedraw=true}if(this.pendingRedraw&&!this.locked){this.redraw();this.pendingRedraw=false}return c},drawGeometry:function(a,b,c){var d=a.CLASS_NAME;if(d=="OpenLayers.Geometry.Collection"||d=="OpenLayers.Geometry.MultiPoint"||d=="OpenLayers.Geometry.MultiLineString"||d=="OpenLayers.Geometry.MultiPolygon")for(d=0;d<a.components.length;d++)this.drawGeometry(a.components[d],b,c);else switch(a.CLASS_NAME){case "OpenLayers.Geometry.Point":this.drawPoint(a,
b,c);break;case "OpenLayers.Geometry.LineString":this.drawLineString(a,b,c);break;case "OpenLayers.Geometry.LinearRing":this.drawLinearRing(a,b,c);break;case "OpenLayers.Geometry.Polygon":this.drawPolygon(a,b,c)}},drawExternalGraphic:function(a,b,c){var d=new Image;if(b.graphicTitle)d.title=b.graphicTitle;var e=b.graphicWidth||b.graphicHeight,f=b.graphicHeight||b.graphicWidth;e=e?e:b.pointRadius*2;f=f?f:b.pointRadius*2;var g=b.graphicXOffset!=undefined?b.graphicXOffset:-(0.5*e),h=b.graphicYOffset!=
undefined?b.graphicYOffset:-(0.5*f),j=b.graphicOpacity||b.fillOpacity;d.onload=OpenLayers.Function.bind(function(){if(this.features[c]){var i=this.getLocalXY(a),k=i[0];i=i[1];if(!isNaN(k)&&!isNaN(i)){k=k+g|0;i=i+h|0;var l=this.canvas;l.globalAlpha=j;var m=OpenLayers.Renderer.Canvas.drawImageScaleFactor||(OpenLayers.Renderer.Canvas.drawImageScaleFactor=/android 2.1/.test(navigator.userAgent.toLowerCase())?320/window.screen.width:1);l.drawImage(d,k*m,i*m,e*m,f*m);if(this.hitDetection){this.setHitContextStyle("fill",
c);this.hitContext.fillRect(k,i,e,f)}}}},this);d.src=b.externalGraphic},setCanvasStyle:function(a,b){if(a==="fill"){this.canvas.globalAlpha=b.fillOpacity;this.canvas.fillStyle=b.fillColor}else if(a==="stroke"){this.canvas.globalAlpha=b.strokeOpacity;this.canvas.strokeStyle=b.strokeColor;this.canvas.lineWidth=b.strokeWidth}else{this.canvas.globalAlpha=0;this.canvas.lineWidth=1}},featureIdToHex:function(a){a=Number(a.split("_").pop())+1;if(a>=16777216){this.hitOverflow=a-16777215;a=a%16777216+1}a="000000"+
a.toString(16);var b=a.length;return a="#"+a.substring(b-6,b)},setHitContextStyle:function(a,b,c){b=this.featureIdToHex(b);if(a=="fill"){this.hitContext.globalAlpha=1;this.hitContext.fillStyle=b}else if(a=="stroke"){this.hitContext.globalAlpha=1;this.hitContext.strokeStyle=b;this.hitContext.lineWidth=c.strokeWidth+2}else{this.hitContext.globalAlpha=0;this.hitContext.lineWidth=1}},drawPoint:function(a,b,c){if(b.graphic!==false)if(b.externalGraphic)this.drawExternalGraphic(a,b,c);else{var d=this.getLocalXY(a);
a=d[0];d=d[1];if(!isNaN(a)&&!isNaN(d)){var e=Math.PI*2,f=b.pointRadius;if(b.fill!==false){this.setCanvasStyle("fill",b);this.canvas.beginPath();this.canvas.arc(a,d,f,0,e,true);this.canvas.fill();if(this.hitDetection){this.setHitContextStyle("fill",c,b);this.hitContext.beginPath();this.hitContext.arc(a,d,f,0,e,true);this.hitContext.fill()}}if(b.stroke!==false){this.setCanvasStyle("stroke",b);this.canvas.beginPath();this.canvas.arc(a,d,f,0,e,true);this.canvas.stroke();if(this.hitDetection){this.setHitContextStyle("stroke",
c,b);this.hitContext.beginPath();this.hitContext.arc(a,d,f,0,e,true);this.hitContext.stroke()}this.setCanvasStyle("reset")}}}},drawLineString:function(a,b,c){b=OpenLayers.Util.applyDefaults({fill:false},b);this.drawLinearRing(a,b,c)},drawLinearRing:function(a,b,c){if(b.fill!==false){this.setCanvasStyle("fill",b);this.renderPath(this.canvas,a,b,c,"fill");if(this.hitDetection){this.setHitContextStyle("fill",c,b);this.renderPath(this.hitContext,a,b,c,"fill")}}if(b.stroke!==false){this.setCanvasStyle("stroke",
b);this.renderPath(this.canvas,a,b,c,"stroke");if(this.hitDetection){this.setHitContextStyle("stroke",c,b);this.renderPath(this.hitContext,a,b,c,"stroke")}}this.setCanvasStyle("reset")},renderPath:function(a,b,c,d,e){b=b.components;c=b.length;a.beginPath();d=this.getLocalXY(b[0]);var f=d[1];if(!isNaN(d[0])&&!isNaN(f)){a.moveTo(d[0],d[1]);for(d=1;d<c;++d){f=this.getLocalXY(b[d]);a.lineTo(f[0],f[1])}e==="fill"?a.fill():a.stroke()}},drawPolygon:function(a,b,c){a=a.components;var d=a.length;this.drawLinearRing(a[0],
b,c);for(var e=1;e<d;++e){this.canvas.globalCompositeOperation="destination-out";if(this.hitDetection)this.hitContext.globalCompositeOperation="destination-out";this.drawLinearRing(a[e],OpenLayers.Util.applyDefaults({stroke:false,fillOpacity:1},b),c);this.canvas.globalCompositeOperation="source-over";if(this.hitDetection)this.hitContext.globalCompositeOperation="source-over";this.drawLinearRing(a[e],OpenLayers.Util.applyDefaults({fill:false},b),c)}},drawText:function(a,b){b=OpenLayers.Util.extend({fontColor:"#000000",
labelAlign:"cm"},b);var c=this.getLocalXY(a);this.setCanvasStyle("reset");this.canvas.fillStyle=b.fontColor;this.canvas.globalAlpha=b.fontOpacity||1;var d=[b.fontStyle?b.fontStyle:"normal","normal",b.fontWeight?b.fontWeight:"normal",b.fontSize?b.fontSize:"1em",b.fontFamily?b.fontFamily:"sans-serif"].join(" "),e=b.label.split("\n"),f=e.length;if(this.canvas.fillText){this.canvas.font=d;this.canvas.textAlign=OpenLayers.Renderer.Canvas.LABEL_ALIGN[b.labelAlign[0]]||"center";this.canvas.textBaseline=
OpenLayers.Renderer.Canvas.LABEL_ALIGN[b.labelAlign[1]]||"middle";var g=OpenLayers.Renderer.Canvas.LABEL_FACTOR[b.labelAlign[1]];if(g==null)g=-0.5;d=this.canvas.measureText("Mg").height||this.canvas.measureText("xx").width;c[1]+=d*g*(f-1);for(g=0;g<f;g++)this.canvas.fillText(e[g],c[0],c[1]+d*g)}else if(this.canvas.mozDrawText){this.canvas.mozTextStyle=d;var h=OpenLayers.Renderer.Canvas.LABEL_FACTOR[b.labelAlign[0]];if(h==null)h=-0.5;g=OpenLayers.Renderer.Canvas.LABEL_FACTOR[b.labelAlign[1]];if(g==
null)g=-0.5;d=this.canvas.mozMeasureText("xx");c[1]+=d*(1+g*f);for(g=0;g<f;g++){var j=c[0]+h*this.canvas.mozMeasureText(e[g]),i=c[1]+g*d;this.canvas.translate(j,i);this.canvas.mozDrawText(e[g]);this.canvas.translate(-j,-i)}}this.setCanvasStyle("reset")},getLocalXY:function(a){var b=this.getResolution(),c=this.extent;return[a.x/b+-c.left/b,c.top/b-a.y/b]},clear:function(){var a=this.root.height,b=this.root.width;this.canvas.clearRect(0,0,b,a);this.features={};this.hitDetection&&this.hitContext.clearRect(0,
0,b,a)},getFeatureIdFromEvent:function(a){var b=null;if(this.hitDetection)if(!this.map.dragging){a=a.xy;a=this.hitContext.getImageData(a.x|0,a.y|0,1,1).data;if(a[3]===255)if(a=a[2]+256*(a[1]+256*a[0]))b=this.features["OpenLayers.Feature.Vector_"+(a-1+this.hitOverflow)][0]}return b},eraseFeatures:function(a){OpenLayers.Util.isArray(a)||(a=[a]);for(var b=0;b<a.length;++b)delete this.features[a[b].id];this.redraw()},redraw:function(){if(!this.locked){var a=this.root.height,b=this.root.width;this.canvas.clearRect(0,
0,b,a);this.hitDetection&&this.hitContext.clearRect(0,0,b,a);a=[];var c,d;for(d in this.features)if(this.features.hasOwnProperty(d)){b=this.features[d][0];c=this.features[d][1];this.drawGeometry(b.geometry,c,b.id);c.label&&a.push([b,c])}b=0;for(c=a.length;b<c;++b){d=a[b];this.drawText(d[0].geometry.getCentroid(),d[1])}}},CLASS_NAME:"OpenLayers.Renderer.Canvas"});OpenLayers.Renderer.Canvas.LABEL_ALIGN={l:"left",r:"right",t:"top",b:"bottom"};OpenLayers.Renderer.Canvas.LABEL_FACTOR={l:0,r:-1,t:0,b:-1};
OpenLayers.Renderer.Canvas.drawImageScaleFactor=null;
OpenLayers.Format.OSM=OpenLayers.Class(OpenLayers.Format.XML,{checkTags:false,interestingTagsExclude:null,areaTags:null,initialize:function(a){var b={interestingTagsExclude:["source","source_ref","source:ref","history","attribution","created_by"],areaTags:["area","building","leisure","tourism","ruins","historic","landuse","military","natural","sport"]};b=OpenLayers.Util.extend(b,a);var c={};for(a=0;a<b.interestingTagsExclude.length;a++)c[b.interestingTagsExclude[a]]=true;b.interestingTagsExclude=
c;c={};for(a=0;a<b.areaTags.length;a++)c[b.areaTags[a]]=true;b.areaTags=c;this.externalProjection=new OpenLayers.Projection("EPSG:4326");OpenLayers.Format.XML.prototype.initialize.apply(this,[b])},read:function(a){if(typeof a=="string")a=OpenLayers.Format.XML.prototype.read.apply(this,[a]);var b=this.getNodes(a),c=this.getWays(a);a=Array(c.length);for(var d=0;d<c.length;d++){for(var e=Array(c[d].nodes.length),f=this.isWayArea(c[d])?1:0,g=0;g<c[d].nodes.length;g++){var h=b[c[d].nodes[g]],j=new OpenLayers.Geometry.Point(h.lon,
h.lat);j.osm_id=parseInt(c[d].nodes[g]);e[g]=j;h.used=true}h=null;h=f?new OpenLayers.Geometry.Polygon(new OpenLayers.Geometry.LinearRing(e)):new OpenLayers.Geometry.LineString(e);this.internalProjection&&this.externalProjection&&h.transform(this.externalProjection,this.internalProjection);e=new OpenLayers.Feature.Vector(h,c[d].tags);e.osm_id=parseInt(c[d].id);e.fid="way."+e.osm_id;a[d]=e}for(var i in b){h=b[i];if(!h.used||this.checkTags){c=null;if(this.checkTags){c=this.getTags(h.node,true);if(h.used&&
!c[1])continue;c=c[0]}else c=this.getTags(h.node);e=new OpenLayers.Feature.Vector(new OpenLayers.Geometry.Point(h.lon,h.lat),c);this.internalProjection&&this.externalProjection&&e.geometry.transform(this.externalProjection,this.internalProjection);e.osm_id=parseInt(i);e.fid="node."+e.osm_id;a.push(e)}h.node=null}return a},getNodes:function(a){a=a.getElementsByTagName("node");for(var b={},c=0;c<a.length;c++){var d=a[c],e=d.getAttribute("id");b[e]={lat:d.getAttribute("lat"),lon:d.getAttribute("lon"),
node:d}}return b},getWays:function(a){a=a.getElementsByTagName("way");for(var b=[],c=0;c<a.length;c++){var d=a[c],e={id:d.getAttribute("id")};e.tags=this.getTags(d);d=d.getElementsByTagName("nd");e.nodes=Array(d.length);for(var f=0;f<d.length;f++)e.nodes[f]=d[f].getAttribute("ref");b.push(e)}return b},getTags:function(a,b){for(var c=a.getElementsByTagName("tag"),d={},e=false,f=0;f<c.length;f++){var g=c[f].getAttribute("k");d[g]=c[f].getAttribute("v");if(b)this.interestingTagsExclude[g]||(e=true)}return b?
[d,e]:d},isWayArea:function(a){var b=false,c=false;if(a.nodes[0]==a.nodes[a.nodes.length-1])b=true;if(this.checkTags)for(var d in a.tags)if(this.areaTags[d]){c=true;break}return b&&(this.checkTags?c:true)},write:function(a){OpenLayers.Util.isArray(a)||(a=[a]);this.osm_id=1;this.created_nodes={};var b=this.createElementNS(null,"osm");b.setAttribute("version","0.5");b.setAttribute("generator","OpenLayers "+OpenLayers.VERSION_NUMBER);for(var c=a.length-1;c>=0;c--)for(var d=this.createFeatureNodes(a[c]),
e=0;e<d.length;e++)b.appendChild(d[e]);return OpenLayers.Format.XML.prototype.write.apply(this,[b])},createFeatureNodes:function(a){var b=[],c=a.geometry.CLASS_NAME;c=c.substring(c.lastIndexOf(".")+1);c=c.toLowerCase();if(c=this.createXML[c])b=c.apply(this,[a]);return b},createXML:{point:function(a){var b=null,c=a.geometry?a.geometry:a;if(this.internalProjection&&this.externalProjection){c=c.clone();c.transform(this.internalProjection,this.externalProjection)}var d=false;if(a.osm_id){b=a.osm_id;if(this.created_nodes[b])d=
true}else{b=-this.osm_id;this.osm_id++}var e=d?this.created_nodes[b]:this.createElementNS(null,"node");this.created_nodes[b]=e;e.setAttribute("id",b);e.setAttribute("lon",c.x);e.setAttribute("lat",c.y);a.attributes&&this.serializeTags(a,e);this.setState(a,e);return d?[]:[e]},linestring:function(a){var b,c=[],d=a.geometry;if(a.osm_id)b=a.osm_id;else{b=-this.osm_id;this.osm_id++}var e=this.createElementNS(null,"way");e.setAttribute("id",b);for(b=0;b<d.components.length;b++){var f=this.createXML.point.apply(this,
[d.components[b]]);if(f.length){f=f[0];var g=f.getAttribute("id");c.push(f)}else{g=d.components[b].osm_id;f=this.created_nodes[g]}this.setState(a,f);f=this.createElementNS(null,"nd");f.setAttribute("ref",g);e.appendChild(f)}this.serializeTags(a,e);c.push(e);return c},polygon:function(a){var b=OpenLayers.Util.extend({area:"yes"},a.attributes);b=new OpenLayers.Feature.Vector(a.geometry.components[0],b);b.osm_id=a.osm_id;return this.createXML.linestring.apply(this,[b])}},serializeTags:function(a,b){for(var c in a.attributes){var d=
this.createElementNS(null,"tag");d.setAttribute("k",c);d.setAttribute("v",a.attributes[c]);b.appendChild(d)}},setState:function(a,b){if(a.state){var c=null;switch(a.state){case OpenLayers.State.UPDATE:case OpenLayers.State.DELETE:c="delete"}c&&b.setAttribute("action",c)}},CLASS_NAME:"OpenLayers.Format.OSM"});
OpenLayers.Handler=OpenLayers.Class({id:null,control:null,map:null,keyMask:null,active:false,evt:null,initialize:function(a,b,c){OpenLayers.Util.extend(this,c);this.control=a;this.callbacks=b;(a=this.map||a.map)&&this.setMap(a);this.id=OpenLayers.Util.createUniqueID(this.CLASS_NAME+"_")},setMap:function(a){this.map=a},checkModifiers:function(a){if(this.keyMask==null)return true;return((a.shiftKey?OpenLayers.Handler.MOD_SHIFT:0)|(a.ctrlKey?OpenLayers.Handler.MOD_CTRL:0)|(a.altKey?OpenLayers.Handler.MOD_ALT:
0))==this.keyMask},activate:function(){if(this.active)return false;for(var a=OpenLayers.Events.prototype.BROWSER_EVENTS,b=0,c=a.length;b<c;b++)this[a[b]]&&this.register(a[b],this[a[b]]);return this.active=true},deactivate:function(){if(!this.active)return false;for(var a=OpenLayers.Events.prototype.BROWSER_EVENTS,b=0,c=a.length;b<c;b++)this[a[b]]&&this.unregister(a[b],this[a[b]]);this.active=false;return true},callback:function(a,b){a&&this.callbacks[a]&&this.callbacks[a].apply(this.control,b)},register:function(a,
b){this.map.events.registerPriority(a,this,b);this.map.events.registerPriority(a,this,this.setEvent)},unregister:function(a,b){this.map.events.unregister(a,this,b);this.map.events.unregister(a,this,this.setEvent)},setEvent:function(a){this.evt=a;return true},destroy:function(){this.deactivate();this.control=this.map=null},CLASS_NAME:"OpenLayers.Handler"});OpenLayers.Handler.MOD_NONE=0;OpenLayers.Handler.MOD_SHIFT=1;OpenLayers.Handler.MOD_CTRL=2;OpenLayers.Handler.MOD_ALT=4;
OpenLayers.Handler.Drag=OpenLayers.Class(OpenLayers.Handler,{started:false,stopDown:true,dragging:false,touch:false,last:null,start:null,lastMoveEvt:null,oldOnselectstart:null,interval:0,timeoutId:null,documentDrag:false,documentEvents:null,initialize:function(){OpenLayers.Handler.prototype.initialize.apply(this,arguments);if(this.documentDrag===true){var a=this;this._docMove=function(b){a.mousemove({xy:{x:b.clientX,y:b.clientY},element:document})};this._docUp=function(b){a.mouseup({xy:{x:b.clientX,
y:b.clientY}})}}},dragstart:function(a){var b=true;this.dragging=false;if(this.checkModifiers(a)&&(OpenLayers.Event.isLeftClick(a)||OpenLayers.Event.isSingleTouch(a))){this.started=true;this.last=this.start=a.xy;OpenLayers.Element.addClass(this.map.viewPortDiv,"olDragDown");this.down(a);this.callback("down",[a.xy]);OpenLayers.Event.stop(a);if(!this.oldOnselectstart)this.oldOnselectstart=document.onselectstart?document.onselectstart:OpenLayers.Function.True;document.onselectstart=OpenLayers.Function.False;
b=!this.stopDown}else{this.started=false;this.last=this.start=null}return b},dragmove:function(a){this.lastMoveEvt=a;if(this.started&&!this.timeoutId&&(a.xy.x!=this.last.x||a.xy.y!=this.last.y)){if(this.documentDrag===true&&this.documentEvents)if(a.element===document){this.adjustXY(a);this.setEvent(a)}else this.removeDocumentEvents();if(this.interval>0)this.timeoutId=setTimeout(OpenLayers.Function.bind(this.removeTimeout,this),this.interval);this.dragging=true;this.move(a);this.callback("move",[a.xy]);
if(!this.oldOnselectstart){this.oldOnselectstart=document.onselectstart;document.onselectstart=OpenLayers.Function.False}this.last=a.xy}return true},dragend:function(a){if(this.started){if(this.documentDrag===true&&this.documentEvents){this.adjustXY(a);this.removeDocumentEvents()}var b=this.start!=this.last;this.dragging=this.started=false;OpenLayers.Element.removeClass(this.map.viewPortDiv,"olDragDown");this.up(a);this.callback("up",[a.xy]);b&&this.callback("done",[a.xy]);document.onselectstart=
this.oldOnselectstart}return true},down:function(){},move:function(){},up:function(){},out:function(){},mousedown:function(a){return this.dragstart(a)},touchstart:function(a){if(!this.touch){this.touch=true;this.map.events.un({mousedown:this.mousedown,mouseup:this.mouseup,mousemove:this.mousemove,click:this.click,scope:this})}return this.dragstart(a)},mousemove:function(a){return this.dragmove(a)},touchmove:function(a){return this.dragmove(a)},removeTimeout:function(){this.timeoutId=null;this.dragging&&
this.mousemove(this.lastMoveEvt)},mouseup:function(a){return this.dragend(a)},touchend:function(a){a.xy=this.last;return this.dragend(a)},mouseout:function(a){if(this.started&&OpenLayers.Util.mouseLeft(a,this.map.eventsDiv))if(this.documentDrag===true)this.addDocumentEvents();else{var b=this.start!=this.last;this.dragging=this.started=false;OpenLayers.Element.removeClass(this.map.viewPortDiv,"olDragDown");this.out(a);this.callback("out",[]);b&&this.callback("done",[a.xy]);if(document.onselectstart)document.onselectstart=
this.oldOnselectstart}return true},click:function(){return this.start==this.last},activate:function(){var a=false;if(OpenLayers.Handler.prototype.activate.apply(this,arguments)){this.dragging=false;a=true}return a},deactivate:function(){var a=false;if(OpenLayers.Handler.prototype.deactivate.apply(this,arguments)){this.dragging=this.started=this.touch=false;this.last=this.start=null;a=true;OpenLayers.Element.removeClass(this.map.viewPortDiv,"olDragDown")}return a},adjustXY:function(a){var b=OpenLayers.Util.pagePosition(this.map.viewPortDiv);
a.xy.x-=b[0];a.xy.y-=b[1]},addDocumentEvents:function(){OpenLayers.Element.addClass(document.body,"olDragDown");this.documentEvents=true;OpenLayers.Event.observe(document,"mousemove",this._docMove);OpenLayers.Event.observe(document,"mouseup",this._docUp)},removeDocumentEvents:function(){OpenLayers.Element.removeClass(document.body,"olDragDown");this.documentEvents=false;OpenLayers.Event.stopObserving(document,"mousemove",this._docMove);OpenLayers.Event.stopObserving(document,"mouseup",this._docUp)},
CLASS_NAME:"OpenLayers.Handler.Drag"});
OpenLayers.Handler.Feature=OpenLayers.Class(OpenLayers.Handler,{EVENTMAP:{click:{"in":"click",out:"clickout"},mousemove:{"in":"over",out:"out"},dblclick:{"in":"dblclick",out:null},mousedown:{"in":null,out:null},mouseup:{"in":null,out:null},touchstart:{"in":"click",out:"clickout"}},feature:null,lastFeature:null,down:null,up:null,touch:false,clickTolerance:4,geometryTypes:null,stopClick:true,stopDown:true,stopUp:false,initialize:function(a,b,c,d){OpenLayers.Handler.prototype.initialize.apply(this,[a,
c,d]);this.layer=b},touchstart:function(a){if(!this.touch){this.touch=true;this.map.events.un({mousedown:this.mousedown,mouseup:this.mouseup,mousemove:this.mousemove,click:this.click,dblclick:this.dblclick,scope:this})}return OpenLayers.Event.isMultiTouch(a)?true:this.mousedown(a)},touchmove:function(a){OpenLayers.Event.stop(a)},mousedown:function(a){this.down=a.xy;return this.handle(a)?!this.stopDown:true},mouseup:function(a){this.up=a.xy;return this.handle(a)?!this.stopUp:true},click:function(a){return this.handle(a)?
!this.stopClick:true},mousemove:function(a){if(!this.callbacks.over&&!this.callbacks.out)return true;this.handle(a);return true},dblclick:function(a){return!this.handle(a)},geometryTypeMatches:function(a){return this.geometryTypes==null||OpenLayers.Util.indexOf(this.geometryTypes,a.geometry.CLASS_NAME)>-1},handle:function(a){if(this.feature&&!this.feature.layer)this.feature=null;var b=a.type,c=false,d=!!this.feature,e=b=="click"||b=="dblclick"||b=="touchstart";if((this.feature=this.layer.getFeatureFromEvent(a))&&
!this.feature.layer)this.feature=null;if(this.lastFeature&&!this.lastFeature.layer)this.lastFeature=null;if(this.feature){b==="touchstart"&&OpenLayers.Event.stop(a);a=this.feature!=this.lastFeature;if(this.geometryTypeMatches(this.feature)){if(d&&a){this.lastFeature&&this.triggerCallback(b,"out",[this.lastFeature]);this.triggerCallback(b,"in",[this.feature])}else if(!d||e)this.triggerCallback(b,"in",[this.feature]);this.lastFeature=this.feature;c=true}else{if(this.lastFeature&&(d&&a||e))this.triggerCallback(b,
"out",[this.lastFeature]);this.feature=null}}else if(this.lastFeature&&(d||e))this.triggerCallback(b,"out",[this.lastFeature]);return c},triggerCallback:function(a,b,c){if(b=this.EVENTMAP[a][b])if(a=="click"&&this.up&&this.down)Math.sqrt(Math.pow(this.up.x-this.down.x,2)+Math.pow(this.up.y-this.down.y,2))<=this.clickTolerance&&this.callback(b,c);else this.callback(b,c)},activate:function(){var a=false;if(OpenLayers.Handler.prototype.activate.apply(this,arguments)){this.moveLayerToTop();this.map.events.on({removelayer:this.handleMapEvents,
changelayer:this.handleMapEvents,scope:this});a=true}return a},deactivate:function(){var a=false;if(OpenLayers.Handler.prototype.deactivate.apply(this,arguments)){this.moveLayerBack();this.up=this.down=this.lastFeature=this.feature=null;this.touch=false;this.map.events.un({removelayer:this.handleMapEvents,changelayer:this.handleMapEvents,scope:this});a=true}return a},handleMapEvents:function(a){if(a.type=="removelayer"||a.property=="order")this.moveLayerToTop()},moveLayerToTop:function(){this.layer.setZIndex(Math.max(this.map.Z_INDEX_BASE.Feature-
1,this.layer.getZIndex())+1)},moveLayerBack:function(){var a=this.layer.getZIndex()-1;a>=this.map.Z_INDEX_BASE.Feature?this.layer.setZIndex(a):this.map.setLayerZIndex(this.layer,this.map.getLayerIndex(this.layer))},CLASS_NAME:"OpenLayers.Handler.Feature"});
OpenLayers.Control.DragFeature=OpenLayers.Class(OpenLayers.Control,{geometryTypes:null,onStart:function(){},onDrag:function(){},onComplete:function(){},onEnter:function(){},onLeave:function(){},documentDrag:false,layer:null,feature:null,dragCallbacks:{},featureCallbacks:{},lastPixel:null,initialize:function(a,b){OpenLayers.Control.prototype.initialize.apply(this,[b]);this.layer=a;this.handlers={drag:new OpenLayers.Handler.Drag(this,OpenLayers.Util.extend({down:this.downFeature,move:this.moveFeature,
up:this.upFeature,out:this.cancel,done:this.doneDragging},this.dragCallbacks),{documentDrag:this.documentDrag}),feature:new OpenLayers.Handler.Feature(this,this.layer,OpenLayers.Util.extend({click:this.clickFeature,clickout:this.clickoutFeature,over:this.overFeature,out:this.outFeature},this.featureCallbacks),{geometryTypes:this.geometryTypes})}},clickFeature:function(a){if(this.handlers.feature.touch&&!this.over&&this.overFeature(a)){this.handlers.drag.dragstart(this.handlers.feature.evt);this.handlers.drag.stopDown=
false}},clickoutFeature:function(a){if(this.handlers.feature.touch&&this.over){this.outFeature(a);this.handlers.drag.stopDown=true}},destroy:function(){this.layer=null;OpenLayers.Control.prototype.destroy.apply(this,[])},activate:function(){return this.handlers.feature.activate()&&OpenLayers.Control.prototype.activate.apply(this,arguments)},deactivate:function(){this.handlers.drag.deactivate();this.handlers.feature.deactivate();this.feature=null;this.dragging=false;this.lastPixel=null;OpenLayers.Element.removeClass(this.map.viewPortDiv,
this.displayClass+"Over");return OpenLayers.Control.prototype.deactivate.apply(this,arguments)},overFeature:function(a){var b=false;if(this.handlers.drag.dragging)this.over=this.feature.id==a.id?true:false;else{this.feature=a;this.handlers.drag.activate();this.over=b=true;OpenLayers.Element.addClass(this.map.viewPortDiv,this.displayClass+"Over");this.onEnter(a)}return b},downFeature:function(a){this.lastPixel=a;this.onStart(this.feature,a)},moveFeature:function(a){var b=this.map.getResolution();this.feature.geometry.move(b*
(a.x-this.lastPixel.x),b*(this.lastPixel.y-a.y));this.layer.drawFeature(this.feature);this.lastPixel=a;this.onDrag(this.feature,a)},upFeature:function(){this.over||this.handlers.drag.deactivate()},doneDragging:function(a){this.onComplete(this.feature,a)},outFeature:function(a){if(this.handlers.drag.dragging){if(this.feature.id==a.id)this.over=false}else{this.over=false;this.handlers.drag.deactivate();OpenLayers.Element.removeClass(this.map.viewPortDiv,this.displayClass+"Over");this.onLeave(a);this.feature=
null}},cancel:function(){this.handlers.drag.deactivate();this.over=false},setMap:function(a){this.handlers.drag.setMap(a);this.handlers.feature.setMap(a);OpenLayers.Control.prototype.setMap.apply(this,arguments)},CLASS_NAME:"OpenLayers.Control.DragFeature"});
OpenLayers.StyleMap=OpenLayers.Class({styles:null,extendDefault:true,initialize:function(a,b){this.styles={"default":new OpenLayers.Style(OpenLayers.Feature.Vector.style["default"]),select:new OpenLayers.Style(OpenLayers.Feature.Vector.style.select),temporary:new OpenLayers.Style(OpenLayers.Feature.Vector.style.temporary),"delete":new OpenLayers.Style(OpenLayers.Feature.Vector.style["delete"])};if(a instanceof OpenLayers.Style){this.styles["default"]=a;this.styles.select=a;this.styles.temporary=a;
this.styles["delete"]=a}else if(typeof a=="object")for(var c in a)if(a[c]instanceof OpenLayers.Style)this.styles[c]=a[c];else if(typeof a[c]=="object")this.styles[c]=new OpenLayers.Style(a[c]);else{this.styles["default"]=new OpenLayers.Style(a);this.styles.select=new OpenLayers.Style(a);this.styles.temporary=new OpenLayers.Style(a);this.styles["delete"]=new OpenLayers.Style(a);break}OpenLayers.Util.extend(this,b)},destroy:function(){for(var a in this.styles)this.styles[a].destroy();this.styles=null},
createSymbolizer:function(a,b){a||(a=new OpenLayers.Feature.Vector);this.styles[b]||(b="default");a.renderIntent=b;var c={};if(this.extendDefault&&b!="default")c=this.styles["default"].createSymbolizer(a);return OpenLayers.Util.extend(c,this.styles[b].createSymbolizer(a))},addUniqueValueRules:function(a,b,c,d){var e=[],f;for(f in c)e.push(new OpenLayers.Rule({symbolizer:c[f],context:d,filter:new OpenLayers.Filter.Comparison({type:OpenLayers.Filter.Comparison.EQUAL_TO,property:b,value:f})}));this.styles[a].addRules(e)},
CLASS_NAME:"OpenLayers.StyleMap"});
OpenLayers.Layer.Vector=OpenLayers.Class(OpenLayers.Layer,{EVENT_TYPES:["beforefeatureadded","beforefeaturesadded","featureadded","featuresadded","beforefeatureremoved","beforefeaturesremoved","featureremoved","featuresremoved","beforefeatureselected","featureselected","featureunselected","beforefeaturemodified","featuremodified","afterfeaturemodified","vertexmodified","vertexremoved","sketchstarted","sketchmodified","sketchcomplete","refresh"],isBaseLayer:false,isFixed:false,features:null,filter:null,
selectedFeatures:null,unrenderedFeatures:null,reportError:true,style:null,styleMap:null,strategies:null,protocol:null,renderers:["SVG","VML","Canvas"],renderer:null,rendererOptions:null,geometryType:null,drawn:false,initialize:function(){this.EVENT_TYPES=OpenLayers.Layer.Vector.prototype.EVENT_TYPES.concat(OpenLayers.Layer.prototype.EVENT_TYPES);OpenLayers.Layer.prototype.initialize.apply(this,arguments);if(!this.renderer||!this.renderer.supported())this.assignRenderer();if(!this.renderer||!this.renderer.supported()){this.renderer=
null;this.displayError()}if(!this.styleMap)this.styleMap=new OpenLayers.StyleMap;this.features=[];this.selectedFeatures=[];this.unrenderedFeatures={};if(this.strategies)for(var a=0,b=this.strategies.length;a<b;a++)this.strategies[a].setLayer(this)},destroy:function(){if(this.strategies){var a,b,c;b=0;for(c=this.strategies.length;b<c;b++){a=this.strategies[b];a.autoDestroy&&a.destroy()}this.strategies=null}if(this.protocol){this.protocol.autoDestroy&&this.protocol.destroy();this.protocol=null}this.destroyFeatures();
this.unrenderedFeatures=this.selectedFeatures=this.features=null;this.renderer&&this.renderer.destroy();this.drawn=this.geometryType=this.renderer=null;OpenLayers.Layer.prototype.destroy.apply(this,arguments)},clone:function(a){if(a==null)a=new OpenLayers.Layer.Vector(this.name,this.getOptions());a=OpenLayers.Layer.prototype.clone.apply(this,[a]);for(var b=this.features,c=b.length,d=Array(c),e=0;e<c;++e)d[e]=b[e].clone();a.features=d;return a},refresh:function(a){this.calculateInRange()&&this.visibility&&
this.events.triggerEvent("refresh",a)},assignRenderer:function(){for(var a=0,b=this.renderers.length;a<b;a++){var c=this.renderers[a];if((c=typeof c=="function"?c:OpenLayers.Renderer[c])&&c.prototype.supported()){this.renderer=new c(this.div,this.rendererOptions);break}}},displayError:function(){this.reportError&&OpenLayers.Console.userError(OpenLayers.i18n("browserNotSupported",{renderers:this.renderers.join("\n")}))},setMap:function(){OpenLayers.Layer.prototype.setMap.apply(this,arguments);if(this.renderer){this.renderer.map=
this.map;this.renderer.setSize(this.map.getSize())}else this.map.removeLayer(this)},afterAdd:function(){if(this.strategies){var a,b,c;b=0;for(c=this.strategies.length;b<c;b++){a=this.strategies[b];a.autoActivate&&a.activate()}}},removeMap:function(){this.drawn=false;if(this.strategies){var a,b,c;b=0;for(c=this.strategies.length;b<c;b++){a=this.strategies[b];a.autoActivate&&a.deactivate()}}},onMapResize:function(){OpenLayers.Layer.prototype.onMapResize.apply(this,arguments);this.renderer.setSize(this.map.getSize())},
moveTo:function(a,b,c){OpenLayers.Layer.prototype.moveTo.apply(this,arguments);var d=OpenLayers.Renderer.NG&&this.renderer instanceof OpenLayers.Renderer.NG;if(d)c||this.renderer.updateDimensions(b);else{var e=true;if(!c){this.renderer.root.style.visibility="hidden";this.div.style.left=-parseInt(this.map.layerContainerDiv.style.left)+"px";this.div.style.top=-parseInt(this.map.layerContainerDiv.style.top)+"px";e=this.renderer.setExtent(this.map.getExtent(),b);this.renderer.root.style.visibility="visible";
if(OpenLayers.IS_GECKO===true)this.div.scrollLeft=this.div.scrollLeft;if(!b&&e)for(var f in this.unrenderedFeatures){var g=this.unrenderedFeatures[f];this.drawFeature(g)}}}if(!this.drawn||!d&&(b||!e)){this.drawn=true;f=0;for(d=this.features.length;f<d;f++){this.renderer.locked=f!==d-1;g=this.features[f];this.drawFeature(g)}}},redraw:function(){if(OpenLayers.Renderer.NG&&this.renderer instanceof OpenLayers.Renderer.NG)this.drawn=false;return OpenLayers.Layer.prototype.redraw.apply(this,arguments)},
display:function(){OpenLayers.Layer.prototype.display.apply(this,arguments);var a=this.div.style.display;if(a!=this.renderer.root.style.display)this.renderer.root.style.display=a},addFeatures:function(a,b){OpenLayers.Util.isArray(a)||(a=[a]);var c=!b||!b.silent;if(c){var d={features:a};if(this.events.triggerEvent("beforefeaturesadded",d)===false)return;a=d.features}d=[];for(var e=0,f=a.length;e<f;e++){this.renderer.locked=e!=a.length-1?true:false;var g=a[e];if(this.geometryType&&!(g.geometry instanceof
this.geometryType))throw OpenLayers.i18n("componentShouldBe",{geomType:this.geometryType.prototype.CLASS_NAME});g.layer=this;if(!g.style&&this.style)g.style=OpenLayers.Util.extend({},this.style);if(c){if(this.events.triggerEvent("beforefeatureadded",{feature:g})===false)continue;this.preFeatureInsert(g)}d.push(g);this.features.push(g);this.drawFeature(g);if(c){this.events.triggerEvent("featureadded",{feature:g});this.onFeatureInsert(g)}}c&&this.events.triggerEvent("featuresadded",{features:d})},removeFeatures:function(a,
b){if(!(!a||a.length===0)){if(a===this.features)return this.removeAllFeatures(b);OpenLayers.Util.isArray(a)||(a=[a]);if(a===this.selectedFeatures)a=a.slice();var c=!b||!b.silent;c&&this.events.triggerEvent("beforefeaturesremoved",{features:a});for(var d=a.length-1;d>=0;d--){this.renderer.locked=d!=0&&a[d-1].geometry?true:false;var e=a[d];delete this.unrenderedFeatures[e.id];c&&this.events.triggerEvent("beforefeatureremoved",{feature:e});this.features=OpenLayers.Util.removeItem(this.features,e);e.layer=
null;e.geometry&&this.renderer.eraseFeatures(e);OpenLayers.Util.indexOf(this.selectedFeatures,e)!=-1&&OpenLayers.Util.removeItem(this.selectedFeatures,e);c&&this.events.triggerEvent("featureremoved",{feature:e})}c&&this.events.triggerEvent("featuresremoved",{features:a})}},removeAllFeatures:function(a){a=!a||!a.silent;var b=this.features;a&&this.events.triggerEvent("beforefeaturesremoved",{features:b});for(var c,d=b.length-1;d>=0;d--){c=b[d];a&&this.events.triggerEvent("beforefeatureremoved",{feature:c});
c.layer=null;a&&this.events.triggerEvent("featureremoved",{feature:c})}this.renderer.clear();this.features=[];this.unrenderedFeatures={};this.selectedFeatures=[];a&&this.events.triggerEvent("featuresremoved",{features:b})},destroyFeatures:function(a,b){if(a==undefined)a=this.features;if(a){this.removeFeatures(a,b);for(var c=a.length-1;c>=0;c--)a[c].destroy()}},drawFeature:function(a,b){if(this.drawn){if(typeof b!="object"){if(!b&&a.state===OpenLayers.State.DELETE)b="delete";var c=b||a.renderIntent;
(b=a.style||this.style)||(b=this.styleMap.createSymbolizer(a,c))}c=this.renderer.drawFeature(a,b);if(c===false||c===null)this.unrenderedFeatures[a.id]=a;else delete this.unrenderedFeatures[a.id]}},eraseFeatures:function(a){this.renderer.eraseFeatures(a)},getFeatureFromEvent:function(a){if(!this.renderer){OpenLayers.Console.error(OpenLayers.i18n("getFeatureError"));return null}var b=null;if(a=this.renderer.getFeatureIdFromEvent(a))b=typeof a==="string"?this.getFeatureById(a):a;return b},getFeatureBy:function(a,
b){for(var c=null,d=0,e=this.features.length;d<e;++d)if(this.features[d][a]==b){c=this.features[d];break}return c},getFeatureById:function(a){return this.getFeatureBy("id",a)},getFeatureByFid:function(a){return this.getFeatureBy("fid",a)},getFeaturesByAttribute:function(a,b){var c,d,e=this.features.length,f=[];for(c=0;c<e;c++)(d=this.features[c])&&d.attributes&&d.attributes[a]===b&&f.push(d);return f},onFeatureInsert:function(){},preFeatureInsert:function(){},getDataExtent:function(){var a=null,b=
this.features;if(b&&b.length>0)for(var c=null,d=0,e=b.length;d<e;d++)if(c=b[d].geometry){if(a===null)a=new OpenLayers.Bounds;a.extend(c.getBounds())}return a},CLASS_NAME:"OpenLayers.Layer.Vector"});
OpenLayers.Layer.Vector.RootContainer=OpenLayers.Class(OpenLayers.Layer.Vector,{displayInLayerSwitcher:false,layers:null,initialize:function(){OpenLayers.Layer.Vector.prototype.initialize.apply(this,arguments)},display:function(){},getFeatureFromEvent:function(a){for(var b=this.layers,c,d=0;d<b.length;d++)if(c=b[d].getFeatureFromEvent(a))return c},setMap:function(a){OpenLayers.Layer.Vector.prototype.setMap.apply(this,arguments);this.collectRoots();a.events.register("changelayer",this,this.handleChangeLayer)},
removeMap:function(a){a.events.unregister("changelayer",this,this.handleChangeLayer);this.resetRoots();OpenLayers.Layer.Vector.prototype.removeMap.apply(this,arguments)},collectRoots:function(){for(var a,b=0;b<this.map.layers.length;++b){a=this.map.layers[b];OpenLayers.Util.indexOf(this.layers,a)!=-1&&a.renderer.moveRoot(this.renderer)}},resetRoots:function(){for(var a,b=0;b<this.layers.length;++b){a=this.layers[b];this.renderer&&a.renderer.getRenderLayerId()==this.id&&this.renderer.moveRoot(a.renderer)}},
handleChangeLayer:function(a){var b=a.layer;if(a.property=="order"&&OpenLayers.Util.indexOf(this.layers,b)!=-1){this.resetRoots();this.collectRoots()}},CLASS_NAME:"OpenLayers.Layer.Vector.RootContainer"});
OpenLayers.Control.SelectFeature=OpenLayers.Class(OpenLayers.Control,{EVENT_TYPES:["beforefeaturehighlighted","featurehighlighted","featureunhighlighted"],multipleKey:null,toggleKey:null,multiple:false,clickout:true,toggle:false,hover:false,highlightOnly:false,box:false,onBeforeSelect:function(){},onSelect:function(){},onUnselect:function(){},scope:null,geometryTypes:null,layer:null,layers:null,callbacks:null,selectStyle:null,renderIntent:"select",handlers:null,initialize:function(a,b){this.EVENT_TYPES=
OpenLayers.Control.SelectFeature.prototype.EVENT_TYPES.concat(OpenLayers.Control.prototype.EVENT_TYPES);OpenLayers.Control.prototype.initialize.apply(this,[b]);if(this.scope===null)this.scope=this;this.initLayer(a);var c={click:this.clickFeature,clickout:this.clickoutFeature};if(this.hover){c.over=this.overFeature;c.out=this.outFeature}this.callbacks=OpenLayers.Util.extend(c,this.callbacks);this.handlers={feature:new OpenLayers.Handler.Feature(this,this.layer,this.callbacks,{geometryTypes:this.geometryTypes})};
if(this.box)this.handlers.box=new OpenLayers.Handler.Box(this,{done:this.selectBox},{boxDivClassName:"olHandlerBoxSelectFeature"})},initLayer:function(a){if(OpenLayers.Util.isArray(a)){this.layers=a;this.layer=new OpenLayers.Layer.Vector.RootContainer(this.id+"_container",{layers:a})}else this.layer=a},destroy:function(){this.active&&this.layers&&this.map.removeLayer(this.layer);OpenLayers.Control.prototype.destroy.apply(this,arguments);this.layers&&this.layer.destroy()},activate:function(){if(!this.active){this.layers&&
this.map.addLayer(this.layer);this.handlers.feature.activate();this.box&&this.handlers.box&&this.handlers.box.activate()}return OpenLayers.Control.prototype.activate.apply(this,arguments)},deactivate:function(){if(this.active){this.handlers.feature.deactivate();this.handlers.box&&this.handlers.box.deactivate();this.layers&&this.map.removeLayer(this.layer)}return OpenLayers.Control.prototype.deactivate.apply(this,arguments)},unselectAll:function(a){for(var b=this.layers||[this.layer],c,d,e=0;e<b.length;++e){c=
b[e];for(var f=c.selectedFeatures.length-1;f>=0;--f){d=c.selectedFeatures[f];if(!a||a.except!=d)this.unselect(d)}}},clickFeature:function(a){if(!this.hover)if(OpenLayers.Util.indexOf(a.layer.selectedFeatures,a)>-1)if(this.toggleSelect())this.unselect(a);else this.multipleSelect()||this.unselectAll({except:a});else{this.multipleSelect()||this.unselectAll({except:a});this.select(a)}},multipleSelect:function(){return this.multiple||this.handlers.feature.evt&&this.handlers.feature.evt[this.multipleKey]},
toggleSelect:function(){return this.toggle||this.handlers.feature.evt&&this.handlers.feature.evt[this.toggleKey]},clickoutFeature:function(){!this.hover&&this.clickout&&this.unselectAll()},overFeature:function(a){var b=a.layer;if(this.hover)if(this.highlightOnly)this.highlight(a);else OpenLayers.Util.indexOf(b.selectedFeatures,a)==-1&&this.select(a)},outFeature:function(a){if(this.hover)if(this.highlightOnly){if(a._lastHighlighter==this.id)if(a._prevHighlighter&&a._prevHighlighter!=this.id){delete a._lastHighlighter;
var b=this.map.getControl(a._prevHighlighter);b&&b.highlight(a)}else this.unhighlight(a)}else this.unselect(a)},highlight:function(a){var b=a.layer;if(this.events.triggerEvent("beforefeaturehighlighted",{feature:a})!==false){a._prevHighlighter=a._lastHighlighter;a._lastHighlighter=this.id;b.drawFeature(a,this.selectStyle||this.renderIntent);this.events.triggerEvent("featurehighlighted",{feature:a})}},unhighlight:function(a){var b=a.layer;if(a._prevHighlighter==undefined)delete a._lastHighlighter;
else{if(a._prevHighlighter!=this.id)a._lastHighlighter=a._prevHighlighter;delete a._prevHighlighter}b.drawFeature(a,a.style||a.layer.style||"default");this.events.triggerEvent("featureunhighlighted",{feature:a})},select:function(a){var b=this.onBeforeSelect.call(this.scope,a),c=a.layer;if(b!==false){b=c.events.triggerEvent("beforefeatureselected",{feature:a});if(b!==false){c.selectedFeatures.push(a);this.highlight(a);if(!this.handlers.feature.lastFeature)this.handlers.feature.lastFeature=c.selectedFeatures[0];
c.events.triggerEvent("featureselected",{feature:a});this.onSelect.call(this.scope,a)}}},unselect:function(a){var b=a.layer;this.unhighlight(a);OpenLayers.Util.removeItem(b.selectedFeatures,a);b.events.triggerEvent("featureunselected",{feature:a});this.onUnselect.call(this.scope,a)},selectBox:function(a){if(a instanceof OpenLayers.Bounds){var b=this.map.getLonLatFromPixel(new OpenLayers.Pixel(a.left,a.bottom));a=this.map.getLonLatFromPixel(new OpenLayers.Pixel(a.right,a.top));b=new OpenLayers.Bounds(b.lon,
b.lat,a.lon,a.lat);this.multipleSelect()||this.unselectAll();a=this.multiple;this.multiple=true;for(var c=this.layers||[this.layer],d,e=0;e<c.length;++e){d=c[e];for(var f=0,g=d.features.length;f<g;++f){var h=d.features[f];if(h.getVisibility())if(this.geometryTypes==null||OpenLayers.Util.indexOf(this.geometryTypes,h.geometry.CLASS_NAME)>-1)b.toGeometry().intersects(h.geometry)&&OpenLayers.Util.indexOf(d.selectedFeatures,h)==-1&&this.select(h)}}this.multiple=a}},setMap:function(a){this.handlers.feature.setMap(a);
this.box&&this.handlers.box.setMap(a);OpenLayers.Control.prototype.setMap.apply(this,arguments)},setLayer:function(a){var b=this.active;this.unselectAll();this.deactivate();if(this.layers){this.layer.destroy();this.layers=null}this.initLayer(a);this.handlers.feature.layer=this.layer;b&&this.activate()},CLASS_NAME:"OpenLayers.Control.SelectFeature"});
OpenLayers.Handler.Keyboard=OpenLayers.Class(OpenLayers.Handler,{KEY_EVENTS:["keydown","keyup"],eventListener:null,initialize:function(){OpenLayers.Handler.prototype.initialize.apply(this,arguments);this.eventListener=OpenLayers.Function.bindAsEventListener(this.handleKeyEvent,this)},destroy:function(){this.deactivate();this.eventListener=null;OpenLayers.Handler.prototype.destroy.apply(this,arguments)},activate:function(){if(OpenLayers.Handler.prototype.activate.apply(this,arguments)){for(var a=0,
b=this.KEY_EVENTS.length;a<b;a++)OpenLayers.Event.observe(document,this.KEY_EVENTS[a],this.eventListener);return true}else return false},deactivate:function(){var a=false;if(OpenLayers.Handler.prototype.deactivate.apply(this,arguments)){a=0;for(var b=this.KEY_EVENTS.length;a<b;a++)OpenLayers.Event.stopObserving(document,this.KEY_EVENTS[a],this.eventListener);a=true}return a},handleKeyEvent:function(a){this.checkModifiers(a)&&this.callback(a.type,[a])},CLASS_NAME:"OpenLayers.Handler.Keyboard"});
OpenLayers.Control.ModifyFeature=OpenLayers.Class(OpenLayers.Control,{geometryTypes:null,clickout:true,toggle:true,standalone:false,layer:null,feature:null,vertices:null,virtualVertices:null,selectControl:null,dragControl:null,handlers:null,deleteCodes:null,virtualStyle:null,vertexRenderIntent:null,mode:null,modified:false,radiusHandle:null,dragHandle:null,onModificationStart:function(){},onModification:function(){},onModificationEnd:function(){},initialize:function(a,b){b=b||{};this.layer=a;this.vertices=
[];this.virtualVertices=[];this.virtualStyle=OpenLayers.Util.extend({},this.layer.style||this.layer.styleMap.createSymbolizer(null,b.vertexRenderIntent));this.virtualStyle.fillOpacity=0.3;this.virtualStyle.strokeOpacity=0.3;this.deleteCodes=[46,68];this.mode=OpenLayers.Control.ModifyFeature.RESHAPE;OpenLayers.Control.prototype.initialize.apply(this,[b]);if(!OpenLayers.Util.isArray(this.deleteCodes))this.deleteCodes=[this.deleteCodes];var c=this,d={geometryTypes:this.geometryTypes,clickout:this.clickout,
toggle:this.toggle,onBeforeSelect:this.beforeSelectFeature,onSelect:this.selectFeature,onUnselect:this.unselectFeature,scope:this};if(this.standalone===false)this.selectControl=new OpenLayers.Control.SelectFeature(a,d);this.dragControl=new OpenLayers.Control.DragFeature(a,{geometryTypes:["OpenLayers.Geometry.Point"],snappingOptions:this.snappingOptions,onStart:function(e,f){c.dragStart.apply(c,[e,f])},onDrag:function(e,f){c.dragVertex.apply(c,[e,f])},onComplete:function(e){c.dragComplete.apply(c,
[e])},featureCallbacks:{over:function(e){if(c.standalone!==true||e._sketch||c.feature===e)c.dragControl.overFeature.apply(c.dragControl,[e])}}});this.handlers={keyboard:new OpenLayers.Handler.Keyboard(this,{keydown:this.handleKeypress})}},destroy:function(){this.layer=null;this.standalone||this.selectControl.destroy();this.dragControl.destroy();OpenLayers.Control.prototype.destroy.apply(this,[])},activate:function(){return(this.standalone||this.selectControl.activate())&&this.handlers.keyboard.activate()&&
OpenLayers.Control.prototype.activate.apply(this,arguments)},deactivate:function(){var a=false;if(OpenLayers.Control.prototype.deactivate.apply(this,arguments)){this.layer.removeFeatures(this.vertices,{silent:true});this.layer.removeFeatures(this.virtualVertices,{silent:true});this.vertices=[];this.dragControl.deactivate();var b=(a=this.feature)&&a.geometry&&a.layer;if(this.standalone===false){b&&this.selectControl.unselect.apply(this.selectControl,[a]);this.selectControl.deactivate()}else b&&this.unselectFeature(a);
this.handlers.keyboard.deactivate();a=true}return a},beforeSelectFeature:function(a){return this.layer.events.triggerEvent("beforefeaturemodified",{feature:a})},selectFeature:function(a){if(!this.standalone||this.beforeSelectFeature(a)!==false){this.feature=a;this.modified=false;this.resetVertices();this.dragControl.activate();this.onModificationStart(this.feature)}var b=a.modified;if(a.geometry&&!(b&&b.geometry))this._originalGeometry=a.geometry.clone()},unselectFeature:function(a){this.layer.removeFeatures(this.vertices,
{silent:true});this.vertices=[];this.layer.destroyFeatures(this.virtualVertices,{silent:true});this.virtualVertices=[];if(this.dragHandle){this.layer.destroyFeatures([this.dragHandle],{silent:true});delete this.dragHandle}if(this.radiusHandle){this.layer.destroyFeatures([this.radiusHandle],{silent:true});delete this.radiusHandle}this.feature=null;this.dragControl.deactivate();this.onModificationEnd(a);this.layer.events.triggerEvent("afterfeaturemodified",{feature:a,modified:this.modified});this.modified=
false},dragStart:function(a,b){if(a!=this.feature&&!a.geometry.parent&&a!=this.dragHandle&&a!=this.radiusHandle){this.standalone===false&&this.feature&&this.selectControl.clickFeature.apply(this.selectControl,[this.feature]);if(this.geometryTypes==null||OpenLayers.Util.indexOf(this.geometryTypes,a.geometry.CLASS_NAME)!=-1){this.standalone||this.selectControl.clickFeature.apply(this.selectControl,[a]);this.dragControl.overFeature.apply(this.dragControl,[a]);this.dragControl.lastPixel=b;this.dragControl.handlers.drag.started=
true;this.dragControl.handlers.drag.start=b;this.dragControl.handlers.drag.last=b}}},dragVertex:function(a,b){this.modified=true;if(this.feature.geometry.CLASS_NAME=="OpenLayers.Geometry.Point"){if(this.feature!=a)this.feature=a;this.layer.events.triggerEvent("vertexmodified",{vertex:a.geometry,feature:this.feature,pixel:b})}else{if(a._index){a.geometry.parent.addComponent(a.geometry,a._index);delete a._index;OpenLayers.Util.removeItem(this.virtualVertices,a);this.vertices.push(a)}else if(a==this.dragHandle){this.layer.removeFeatures(this.vertices,
{silent:true});this.vertices=[];if(this.radiusHandle){this.layer.destroyFeatures([this.radiusHandle],{silent:true});this.radiusHandle=null}}else a!==this.radiusHandle&&this.layer.events.triggerEvent("vertexmodified",{vertex:a.geometry,feature:this.feature,pixel:b});if(this.virtualVertices.length>0){this.layer.destroyFeatures(this.virtualVertices,{silent:true});this.virtualVertices=[]}this.layer.drawFeature(this.feature,this.standalone?undefined:this.selectControl.renderIntent)}this.layer.drawFeature(a)},
dragComplete:function(){this.resetVertices();this.setFeatureState();this.onModification(this.feature);this.layer.events.triggerEvent("featuremodified",{feature:this.feature})},setFeatureState:function(){if(this.feature.state!=OpenLayers.State.INSERT&&this.feature.state!=OpenLayers.State.DELETE){this.feature.state=OpenLayers.State.UPDATE;if(this.modified&&this._originalGeometry){var a=this.feature;a.modified=OpenLayers.Util.extend(a.modified,{geometry:this._originalGeometry});delete this._originalGeometry}}},
resetVertices:function(){this.dragControl.feature&&this.dragControl.outFeature(this.dragControl.feature);if(this.vertices.length>0){this.layer.removeFeatures(this.vertices,{silent:true});this.vertices=[]}if(this.virtualVertices.length>0){this.layer.removeFeatures(this.virtualVertices,{silent:true});this.virtualVertices=[]}if(this.dragHandle){this.layer.destroyFeatures([this.dragHandle],{silent:true});this.dragHandle=null}if(this.radiusHandle){this.layer.destroyFeatures([this.radiusHandle],{silent:true});
this.radiusHandle=null}if(this.feature&&this.feature.geometry.CLASS_NAME!="OpenLayers.Geometry.Point"){this.mode&OpenLayers.Control.ModifyFeature.DRAG&&this.collectDragHandle();this.mode&(OpenLayers.Control.ModifyFeature.ROTATE|OpenLayers.Control.ModifyFeature.RESIZE)&&this.collectRadiusHandle();if(this.mode&OpenLayers.Control.ModifyFeature.RESHAPE)this.mode&OpenLayers.Control.ModifyFeature.RESIZE||this.collectVertices()}},handleKeypress:function(a){var b=a.keyCode;if(this.feature&&OpenLayers.Util.indexOf(this.deleteCodes,
b)!=-1)if((b=this.dragControl.feature)&&OpenLayers.Util.indexOf(this.vertices,b)!=-1&&!this.dragControl.handlers.drag.dragging&&b.geometry.parent){b.geometry.parent.removeComponent(b.geometry);this.layer.events.triggerEvent("vertexremoved",{vertex:b.geometry,feature:this.feature,pixel:a.xy});this.layer.drawFeature(this.feature,this.standalone?undefined:this.selectControl.renderIntent);this.modified=true;this.resetVertices();this.setFeatureState();this.onModification(this.feature);this.layer.events.triggerEvent("featuremodified",
{feature:this.feature})}},collectVertices:function(){function a(c){var d,e,f;if(c.CLASS_NAME=="OpenLayers.Geometry.Point"){e=new OpenLayers.Feature.Vector(c);e._sketch=true;e.renderIntent=b.vertexRenderIntent;b.vertices.push(e)}else{f=c.components.length;if(c.CLASS_NAME=="OpenLayers.Geometry.LinearRing")f-=1;for(d=0;d<f;++d){e=c.components[d];if(e.CLASS_NAME=="OpenLayers.Geometry.Point"){e=new OpenLayers.Feature.Vector(e);e._sketch=true;e.renderIntent=b.vertexRenderIntent;b.vertices.push(e)}else a(e)}if(c.CLASS_NAME!=
"OpenLayers.Geometry.MultiPoint"){d=0;for(f=c.components.length;d<f-1;++d){e=c.components[d];var g=c.components[d+1];if(e.CLASS_NAME=="OpenLayers.Geometry.Point"&&g.CLASS_NAME=="OpenLayers.Geometry.Point"){e=new OpenLayers.Feature.Vector(new OpenLayers.Geometry.Point((e.x+g.x)/2,(e.y+g.y)/2),null,b.virtualStyle);e.geometry.parent=c;e._index=d+1;e._sketch=true;b.virtualVertices.push(e)}}}}}this.vertices=[];this.virtualVertices=[];var b=this;a.call(this,this.feature.geometry);this.layer.addFeatures(this.virtualVertices,
{silent:true});this.layer.addFeatures(this.vertices,{silent:true})},collectDragHandle:function(){var a=this.feature.geometry,b=a.getBounds().getCenterLonLat();b=new OpenLayers.Geometry.Point(b.lon,b.lat);var c=new OpenLayers.Feature.Vector(b);b.move=function(d,e){OpenLayers.Geometry.Point.prototype.move.call(this,d,e);a.move(d,e)};c._sketch=true;this.dragHandle=c;this.layer.addFeatures([this.dragHandle],{silent:true})},collectRadiusHandle:function(){var a=this.feature.geometry,b=a.getBounds(),c=b.getCenterLonLat(),
d=new OpenLayers.Geometry.Point(c.lon,c.lat);b=new OpenLayers.Geometry.Point(b.right,b.bottom);c=new OpenLayers.Feature.Vector(b);var e=this.mode&OpenLayers.Control.ModifyFeature.RESIZE,f=this.mode&OpenLayers.Control.ModifyFeature.RESHAPE,g=this.mode&OpenLayers.Control.ModifyFeature.ROTATE;b.move=function(h,j){OpenLayers.Geometry.Point.prototype.move.call(this,h,j);var i=this.x-d.x,k=this.y-d.y,l=i-h,m=k-j;if(g){var n=Math.atan2(k,i)-Math.atan2(m,l);n*=180/Math.PI;a.rotate(n,d)}if(e){var p;if(f){k/=
m;p=i/l/k}else k=Math.sqrt(i*i+k*k)/Math.sqrt(l*l+m*m);a.resize(k,d,p)}};c._sketch=true;this.radiusHandle=c;this.layer.addFeatures([this.radiusHandle],{silent:true})},setMap:function(a){this.standalone||this.selectControl.setMap(a);this.dragControl.setMap(a);OpenLayers.Control.prototype.setMap.apply(this,arguments)},CLASS_NAME:"OpenLayers.Control.ModifyFeature"});OpenLayers.Control.ModifyFeature.RESHAPE=1;OpenLayers.Control.ModifyFeature.RESIZE=2;OpenLayers.Control.ModifyFeature.ROTATE=4;
OpenLayers.Control.ModifyFeature.DRAG=8;
OpenLayers.Layer.XYZ=OpenLayers.Class(OpenLayers.Layer.Grid,{isBaseLayer:true,sphericalMercator:false,zoomOffset:0,serverResolutions:null,initialize:function(a,b,c){if(c&&c.sphericalMercator||this.sphericalMercator)c=OpenLayers.Util.extend({maxExtent:new OpenLayers.Bounds(-2.003750834E7,-2.003750834E7,2.003750834E7,2.003750834E7),maxResolution:156543.03390625,numZoomLevels:19,units:"m",projection:"EPSG:900913"},c);b=b||this.url;a=a||this.name;OpenLayers.Layer.Grid.prototype.initialize.apply(this,[a,
b,{},c])},clone:function(a){if(a==null)a=new OpenLayers.Layer.XYZ(this.name,this.url,this.getOptions());return a=OpenLayers.Layer.Grid.prototype.clone.apply(this,[a])},getURL:function(a){a=this.getXYZ(a);var b=this.url;if(OpenLayers.Util.isArray(b))b=this.selectUrl(""+a.x+a.y+a.z,b);return OpenLayers.String.format(b,a)},getXYZ:function(a){var b=this.map.getResolution(),c=Math.round((a.left-this.maxExtent.left)/(b*this.tileSize.w));a=Math.round((this.maxExtent.top-a.top)/(b*this.tileSize.h));b=this.serverResolutions!=
null?OpenLayers.Util.indexOf(this.serverResolutions,b):this.map.getZoom()+this.zoomOffset;var d=Math.pow(2,b);if(this.wrapDateLine)c=(c%d+d)%d;return{x:c,y:a,z:b}},setMap:function(){OpenLayers.Layer.Grid.prototype.setMap.apply(this,arguments);if(!this.tileOrigin)this.tileOrigin=new OpenLayers.LonLat(this.maxExtent.left,this.maxExtent.bottom)},CLASS_NAME:"OpenLayers.Layer.XYZ"});
OpenLayers.Layer.OSM=OpenLayers.Class(OpenLayers.Layer.XYZ,{name:"OpenStreetMap",attribution:"Data CC-By-SA by <a href='http://openstreetmap.org/'>OpenStreetMap</a>",sphericalMercator:true,url:"http://tile.openstreetmap.org/${z}/${x}/${y}.png",clone:function(a){if(a==null)a=new OpenLayers.Layer.OSM(this.name,this.url,this.getOptions());return a=OpenLayers.Layer.XYZ.prototype.clone.apply(this,[a])},wrapDateLine:true,CLASS_NAME:"OpenLayers.Layer.OSM"});
OpenLayers.Layer.Bing=OpenLayers.Class(OpenLayers.Layer.XYZ,{serverResolutions:[156543.03390625,78271.516953125,39135.7584765625,19567.87923828125,9783.939619140625,4891.9698095703125,2445.9849047851562,1222.9924523925781,611.4962261962891,305.74811309814453,152.87405654907226,76.43702827453613,38.218514137268066,19.109257068634033,9.554628534317017,4.777314267158508,2.388657133579254,1.194328566789627,0.5971642833948135,0.29858214169740677,0.14929107084870338,0.07464553542435169],attributionTemplate:'<span class="olBingAttribution ${type}"><div><a target="_blank" href="http://www.bing.com/maps/"><img src="${logo}" /></a></div>${copyrights}<a style="white-space: nowrap" target="_blank" href="http://www.microsoft.com/maps/product/terms.html">Terms of Use</a></span>',
metadata:null,type:"Road",metadataParams:null,initialize:function(a){a=OpenLayers.Util.applyDefaults({sphericalMercator:true},a);OpenLayers.Layer.XYZ.prototype.initialize.apply(this,[a.name||"Bing "+(a.type||this.type),null,a]);this.loadMetadata()},loadMetadata:function(){this._callbackId="_callback_"+this.id.replace(/\./g,"_");window[this._callbackId]=OpenLayers.Function.bind(OpenLayers.Layer.Bing.processMetadata,this);var a=OpenLayers.Util.applyDefaults({key:this.key,jsonp:this._callbackId,include:"ImageryProviders"},
this.metadataParams);a="http://dev.virtualearth.net/REST/v1/Imagery/Metadata/"+this.type+"?"+OpenLayers.Util.getParameterString(a);var b=document.createElement("script");b.type="text/javascript";b.src=a;b.id=this._callbackId;document.getElementsByTagName("head")[0].appendChild(b)},initLayer:function(){var a=this.metadata.resourceSets[0].resources[0],b=a.imageUrl.replace("{quadkey}","${quadkey}");this.url=[];for(var c=0;c<a.imageUrlSubdomains.length;++c)this.url.push(b.replace("{subdomain}",a.imageUrlSubdomains[c]));
this.addOptions({maxResolution:Math.min(this.serverResolutions[a.zoomMin],this.maxResolution),zoomOffset:a.zoomMin,numZoomLevels:Math.min(a.zoomMax+1-a.zoomMin,this.numZoomLevels)},true)},getURL:function(a){if(this.url){var b=this.getXYZ(a);a=b.x;var c=b.y;b=b.z;for(var d=[],e=b;e>0;--e){var f="0",g=1<<e-1;(a&g)!=0&&f++;if((c&g)!=0){f++;f++}d.push(f)}d=d.join("");a=this.selectUrl(""+a+c+b,this.url);return OpenLayers.String.format(a,{quadkey:d})}},updateAttribution:function(){var a=this.metadata;if(!(!a||
!this.map||!this.map.center)){var b=a.resourceSets[0].resources[0],c=this.map.getExtent().transform(this.map.getProjectionObject(),new OpenLayers.Projection("EPSG:4326"));b=b.imageryProviders;var d=this.map.getZoom()+1,e="",f,g,h,j,i,k,l;g=0;for(h=b.length;g<h;++g){f=b[g];j=0;for(i=f.coverageAreas.length;j<i;++j){l=f.coverageAreas[j];k=OpenLayers.Bounds.fromArray(l.bbox);if(c.intersectsBounds(k)&&d<=l.zoomMax&&d>=l.zoomMin)e+=f.attribution+" "}}this.attribution=OpenLayers.String.format(this.attributionTemplate,
{type:this.type.toLowerCase(),logo:a.brandLogoUri,copyrights:e});this.map&&this.map.events.triggerEvent("changelayer",{layer:this,property:"attribution"})}},setMap:function(){OpenLayers.Layer.XYZ.prototype.setMap.apply(this,arguments);this.updateAttribution();this.map.events.register("moveend",this,this.updateAttribution)},clone:function(a){if(a==null)a=new OpenLayers.Layer.Bing(this.options);return a=OpenLayers.Layer.XYZ.prototype.clone.apply(this,[a])},destroy:function(){this.map&&this.map.events.unregister("moveend",
this,this.updateAttribution);OpenLayers.Layer.XYZ.prototype.destroy.apply(this,arguments)},CLASS_NAME:"OpenLayers.Layer.Bing"});OpenLayers.Layer.Bing.processMetadata=function(a){this.metadata=a;this.initLayer();a=document.getElementById(this._callbackId);a.parentNode.removeChild(a);window[this._callbackId]=undefined;delete this._callbackId};
OpenLayers.Layer.PointGrid=OpenLayers.Class(OpenLayers.Layer.Vector,{dx:null,dy:null,ratio:1.5,maxFeatures:250,rotation:0,origin:null,gridBounds:null,initialize:function(a){a=a||{};OpenLayers.Layer.Vector.prototype.initialize.apply(this,[a.name,a])},setMap:function(a){OpenLayers.Layer.Vector.prototype.setMap.apply(this,arguments);a.events.register("moveend",this,this.onMoveEnd)},removeMap:function(a){a.events.unregister("moveend",this,this.onMoveEnd);OpenLayers.Layer.Vector.prototype.removeMap.apply(this,
arguments)},setRatio:function(a){this.ratio=a;this.updateGrid(true)},setMaxFeatures:function(a){this.maxFeatures=a;this.updateGrid(true)},setSpacing:function(a,b){this.dx=a;this.dy=b||a;this.updateGrid(true)},setOrigin:function(a){this.origin=a;this.updateGrid(true)},getOrigin:function(){if(!this.origin)this.origin=this.map.getExtent().getCenterLonLat();return this.origin},setRotation:function(a){this.rotation=a;this.updateGrid(true)},onMoveEnd:function(){this.updateGrid()},getViewBounds:function(){var a=
this.map.getExtent();if(this.rotation){var b=this.getOrigin();b=new OpenLayers.Geometry.Point(b.lon,b.lat);a=a.toGeometry();a.rotate(-this.rotation,b);a=a.getBounds()}return a},updateGrid:function(a){if(a||this.invalidBounds()){var b=this.getViewBounds(),c=this.getOrigin();a=new OpenLayers.Geometry.Point(c.lon,c.lat);var d=b.getWidth(),e=b.getHeight(),f=d/e,g=Math.sqrt(this.dx*this.dy*this.maxFeatures/f);d=Math.min(d*this.ratio,g*f);e=Math.min(e*this.ratio,g);b=b.getCenterLonLat();this.gridBounds=
new OpenLayers.Bounds(b.lon-d/2,b.lat-e/2,b.lon+d/2,b.lat+e/2);b=Math.floor(e/this.dy);d=Math.floor(d/this.dx);e=c.lon+this.dx*Math.ceil((this.gridBounds.left-c.lon)/this.dx);c=c.lat+this.dy*Math.ceil((this.gridBounds.bottom-c.lat)/this.dy);g=Array(b*d);for(var h,j=0;j<d;++j){f=e+j*this.dx;for(var i=0;i<b;++i){h=c+i*this.dy;h=new OpenLayers.Geometry.Point(f,h);this.rotation&&h.rotate(this.rotation,a);g[j*b+i]=new OpenLayers.Feature.Vector(h)}}this.destroyFeatures(this.features,{silent:true});this.addFeatures(g,
{silent:true})}},invalidBounds:function(){return!this.gridBounds||!this.gridBounds.containsBounds(this.getViewBounds())},CLASS_NAME:"OpenLayers.Layer.PointGrid"});
OpenLayers.Handler.MouseWheel=OpenLayers.Class(OpenLayers.Handler,{wheelListener:null,mousePosition:null,interval:0,delta:0,cumulative:true,initialize:function(){OpenLayers.Handler.prototype.initialize.apply(this,arguments);this.wheelListener=OpenLayers.Function.bindAsEventListener(this.onWheelEvent,this)},destroy:function(){OpenLayers.Handler.prototype.destroy.apply(this,arguments);this.wheelListener=null},onWheelEvent:function(a){if(this.map&&this.checkModifiers(a)){for(var b=false,c=false,d=false,
e=OpenLayers.Event.element(a);e!=null&&!d&&!b;){if(!b)try{var f=e.currentStyle?e.currentStyle.overflow:document.defaultView.getComputedStyle(e,null).getPropertyValue("overflow");b=f&&f=="auto"||f=="scroll"}catch(g){}if(!c){d=0;for(var h=this.map.layers.length;d<h;d++)if(e==this.map.layers[d].div||e==this.map.layers[d].pane){c=true;break}}d=e==this.map.div;e=e.parentNode}if(!b&&d){if(c){b=0;if(!a)a=window.event;if(a.wheelDelta){b=a.wheelDelta/120;if(window.opera&&window.opera.version()<9.2)b=-b}else if(a.detail)b=
-a.detail/3;this.delta+=b;if(this.interval){window.clearTimeout(this._timeoutId);this._timeoutId=window.setTimeout(OpenLayers.Function.bind(function(){this.wheelZoom(a)},this),this.interval)}else this.wheelZoom(a)}OpenLayers.Event.stop(a)}}},wheelZoom:function(a){var b=this.delta;this.delta=0;if(b){if(this.mousePosition)a.xy=this.mousePosition;if(!a.xy)a.xy=this.map.getPixelFromLonLat(this.map.getCenter());b<0?this.callback("down",[a,this.cumulative?b:-1]):this.callback("up",[a,this.cumulative?b:
1])}},mousemove:function(a){this.mousePosition=a.xy},activate:function(){if(OpenLayers.Handler.prototype.activate.apply(this,arguments)){var a=this.wheelListener;OpenLayers.Event.observe(window,"DOMMouseScroll",a);OpenLayers.Event.observe(window,"mousewheel",a);OpenLayers.Event.observe(document,"mousewheel",a);return true}else return false},deactivate:function(){if(OpenLayers.Handler.prototype.deactivate.apply(this,arguments)){var a=this.wheelListener;OpenLayers.Event.stopObserving(window,"DOMMouseScroll",
a);OpenLayers.Event.stopObserving(window,"mousewheel",a);OpenLayers.Event.stopObserving(document,"mousewheel",a);return true}else return false},CLASS_NAME:"OpenLayers.Handler.MouseWheel"});OpenLayers.Symbolizer=OpenLayers.Class({zIndex:0,initialize:function(a){OpenLayers.Util.extend(this,a)},clone:function(){return new (eval(this.CLASS_NAME))(OpenLayers.Util.extend({},this))},CLASS_NAME:"OpenLayers.Symbolizer"});
OpenLayers.Symbolizer.Raster=OpenLayers.Class(OpenLayers.Symbolizer,{initialize:function(){OpenLayers.Symbolizer.prototype.initialize.apply(this,arguments)},CLASS_NAME:"OpenLayers.Symbolizer.Raster"});OpenLayers.Format.WMSCapabilities=OpenLayers.Class(OpenLayers.Format.XML.VersionedOGC,{defaultVersion:"1.1.1",profile:null,CLASS_NAME:"OpenLayers.Format.WMSCapabilities"});
OpenLayers.Format.WMSCapabilities.v1=OpenLayers.Class(OpenLayers.Format.XML,{namespaces:{wms:"http://www.opengis.net/wms",xlink:"http://www.w3.org/1999/xlink",xsi:"http://www.w3.org/2001/XMLSchema-instance"},defaultPrefix:"wms",initialize:function(a){OpenLayers.Format.XML.prototype.initialize.apply(this,[a])},read:function(a){if(typeof a=="string")a=OpenLayers.Format.XML.prototype.read.apply(this,[a]);var b=a;if(a&&a.nodeType==9)a=a.documentElement;var c={};this.readNode(a,c);if(c.service===undefined){a=
new OpenLayers.Format.OGCExceptionReport;c.error=a.read(b)}else this.postProcessLayers(c);return c},postProcessLayers:function(a){if(a.capability){a.capability.layers=[];for(var b=a.capability.nestedLayers,c=0,d=b.length;c<d;++c)this.processLayer(a.capability,b[c])}},processLayer:function(a,b,c){if(b.formats===undefined)b.formats=a.request.getmap.formats;var d,e;if(c){b.styles=b.styles.concat(c.styles);var f=["queryable","cascaded","fixedWidth","fixedHeight","opaque","noSubsets","llbbox","minScale",
"maxScale","attribution"],g=["srs","bbox","dimensions","authorityURLs"],h;d=0;for(e=f.length;d<e;d++){h=f[d];if(h in c){if(b[h]==null)b[h]=c[h];if(b[h]==null){if(OpenLayers.Util.indexOf(["cascaded","fixedWidth","fixedHeight"],h)!=-1)b[h]=0;if(OpenLayers.Util.indexOf(["queryable","opaque","noSubsets"],h)!=-1)b[h]=false}}}d=0;for(e=g.length;d<e;d++){h=g[d];b[h]=OpenLayers.Util.applyDefaults(b[h],c[h])}}d=0;for(e=b.nestedLayers.length;d<e;d++)this.processLayer(a,b.nestedLayers[d],b);b.name&&a.layers.push(b)},
readers:{wms:{Service:function(a,b){b.service={};this.readChildNodes(a,b.service)},Name:function(a,b){b.name=this.getChildValue(a)},Title:function(a,b){b.title=this.getChildValue(a)},Abstract:function(a,b){b["abstract"]=this.getChildValue(a)},BoundingBox:function(a){var b={};b.bbox=[parseFloat(a.getAttribute("minx")),parseFloat(a.getAttribute("miny")),parseFloat(a.getAttribute("maxx")),parseFloat(a.getAttribute("maxy"))];a={x:parseFloat(a.getAttribute("resx")),y:parseFloat(a.getAttribute("resy"))};
if(!(isNaN(a.x)&&isNaN(a.y)))b.res=a;return b},OnlineResource:function(a,b){b.href=this.getAttributeNS(a,this.namespaces.xlink,"href")},ContactInformation:function(a,b){b.contactInformation={};this.readChildNodes(a,b.contactInformation)},ContactPersonPrimary:function(a,b){b.personPrimary={};this.readChildNodes(a,b.personPrimary)},ContactPerson:function(a,b){b.person=this.getChildValue(a)},ContactOrganization:function(a,b){b.organization=this.getChildValue(a)},ContactPosition:function(a,b){b.position=
this.getChildValue(a)},ContactAddress:function(a,b){b.contactAddress={};this.readChildNodes(a,b.contactAddress)},AddressType:function(a,b){b.type=this.getChildValue(a)},Address:function(a,b){b.address=this.getChildValue(a)},City:function(a,b){b.city=this.getChildValue(a)},StateOrProvince:function(a,b){b.stateOrProvince=this.getChildValue(a)},PostCode:function(a,b){b.postcode=this.getChildValue(a)},Country:function(a,b){b.country=this.getChildValue(a)},ContactVoiceTelephone:function(a,b){b.phone=this.getChildValue(a)},
ContactFacsimileTelephone:function(a,b){b.fax=this.getChildValue(a)},ContactElectronicMailAddress:function(a,b){b.email=this.getChildValue(a)},Fees:function(a,b){var c=this.getChildValue(a);if(c&&c.toLowerCase()!="none")b.fees=c},AccessConstraints:function(a,b){var c=this.getChildValue(a);if(c&&c.toLowerCase()!="none")b.accessConstraints=c},Capability:function(a,b){b.capability={nestedLayers:[]};this.readChildNodes(a,b.capability)},Request:function(a,b){b.request={};this.readChildNodes(a,b.request)},
GetCapabilities:function(a,b){b.getcapabilities={formats:[]};this.readChildNodes(a,b.getcapabilities)},Format:function(a,b){if(OpenLayers.Util.isArray(b.formats))b.formats.push(this.getChildValue(a));else b.format=this.getChildValue(a)},DCPType:function(a,b){this.readChildNodes(a,b)},HTTP:function(a,b){this.readChildNodes(a,b)},Get:function(a,b){b.get={};this.readChildNodes(a,b.get);if(!b.href)b.href=b.get.href},Post:function(a,b){b.post={};this.readChildNodes(a,b.post);if(!b.href)b.href=b.get.href},
GetMap:function(a,b){b.getmap={formats:[]};this.readChildNodes(a,b.getmap)},GetFeatureInfo:function(a,b){b.getfeatureinfo={formats:[]};this.readChildNodes(a,b.getfeatureinfo)},Exception:function(a,b){b.exception={formats:[]};this.readChildNodes(a,b.exception)},Layer:function(a,b){var c=a.getAttributeNode("queryable"),d=c&&c.specified?a.getAttribute("queryable"):null,e=(c=a.getAttributeNode("cascaded"))&&c.specified?a.getAttribute("cascaded"):null;c=(c=a.getAttributeNode("opaque"))&&c.specified?a.getAttribute("opaque"):
null;var f=a.getAttribute("noSubsets"),g=a.getAttribute("fixedWidth"),h=a.getAttribute("fixedHeight");d={nestedLayers:[],styles:[],srs:{},metadataURLs:[],bbox:{},dimensions:{},authorityURLs:{},identifiers:{},keywords:[],queryable:d&&d!==""?d==="1"||d==="true":null,cascaded:e!==null?parseInt(e):null,opaque:c?c==="1"||c==="true":null,noSubsets:f!==null?f==="1"||f==="true":null,fixedWidth:g!=null?parseInt(g):null,fixedHeight:h!=null?parseInt(h):null};b.nestedLayers.push(d);this.readChildNodes(a,d);if(d.name){e=
d.name.split(":");if(e.length>0)d.prefix=e[0]}},Attribution:function(a,b){b.attribution={};this.readChildNodes(a,b.attribution)},LogoURL:function(a,b){b.logo={width:a.getAttribute("width"),height:a.getAttribute("height")};this.readChildNodes(a,b.logo)},Style:function(a,b){var c={};b.styles.push(c);this.readChildNodes(a,c)},LegendURL:function(a,b){var c={width:a.getAttribute("width"),height:a.getAttribute("height")};b.legend=c;this.readChildNodes(a,c)},MetadataURL:function(a,b){var c={type:a.getAttribute("type")};
b.metadataURLs.push(c);this.readChildNodes(a,c)},DataURL:function(a,b){b.dataURL={};this.readChildNodes(a,b.dataURL)},FeatureListURL:function(a,b){b.featureListURL={};this.readChildNodes(a,b.featureListURL)},AuthorityURL:function(a,b){var c=a.getAttribute("name"),d={};this.readChildNodes(a,d);b.authorityURLs[c]=d.href},Identifier:function(a,b){var c=a.getAttribute("authority");b.identifiers[c]=this.getChildValue(a)},KeywordList:function(a,b){this.readChildNodes(a,b)},SRS:function(a,b){b.srs[this.getChildValue(a)]=
true}}},CLASS_NAME:"OpenLayers.Format.WMSCapabilities.v1"});
OpenLayers.Format.WMSCapabilities.v1_3=OpenLayers.Class(OpenLayers.Format.WMSCapabilities.v1,{readers:{wms:OpenLayers.Util.applyDefaults({WMS_Capabilities:function(a,b){this.readChildNodes(a,b)},LayerLimit:function(a,b){b.layerLimit=parseInt(this.getChildValue(a))},MaxWidth:function(a,b){b.maxWidth=parseInt(this.getChildValue(a))},MaxHeight:function(a,b){b.maxHeight=parseInt(this.getChildValue(a))},BoundingBox:function(a,b){var c=OpenLayers.Format.WMSCapabilities.v1.prototype.readers.wms.BoundingBox.apply(this,[a,
b]);c.srs=a.getAttribute("CRS");b.bbox[c.srs]=c},CRS:function(a,b){this.readers.wms.SRS.apply(this,[a,b])},EX_GeographicBoundingBox:function(a,b){b.llbbox=[];this.readChildNodes(a,b.llbbox)},westBoundLongitude:function(a,b){b[0]=this.getChildValue(a)},eastBoundLongitude:function(a,b){b[2]=this.getChildValue(a)},southBoundLatitude:function(a,b){b[1]=this.getChildValue(a)},northBoundLatitude:function(a,b){b[3]=this.getChildValue(a)},MinScaleDenominator:function(a,b){b.maxScale=parseFloat(this.getChildValue(a)).toPrecision(16)},
MaxScaleDenominator:function(a,b){b.minScale=parseFloat(this.getChildValue(a)).toPrecision(16)},Dimension:function(a,b){var c={name:a.getAttribute("name").toLowerCase(),units:a.getAttribute("units"),unitsymbol:a.getAttribute("unitSymbol"),nearestVal:a.getAttribute("nearestValue")==="1",multipleVal:a.getAttribute("multipleValues")==="1","default":a.getAttribute("default")||"",current:a.getAttribute("current")==="1",values:this.getChildValue(a).split(",")};b.dimensions[c.name]=c},Keyword:function(a,
b){var c={value:this.getChildValue(a),vocabulary:a.getAttribute("vocabulary")};b.keywords&&b.keywords.push(c)}},OpenLayers.Format.WMSCapabilities.v1.prototype.readers.wms),sld:{UserDefinedSymbolization:function(a,b){this.readers.wms.UserDefinedSymbolization.apply(this,[a,b]);b.userSymbols.inlineFeature=parseInt(a.getAttribute("InlineFeature"))==1;b.userSymbols.remoteWCS=parseInt(a.getAttribute("RemoteWCS"))==1},DescribeLayer:function(a,b){this.readers.wms.DescribeLayer.apply(this,[a,b])},GetLegendGraphic:function(a,
b){this.readers.wms.GetLegendGraphic.apply(this,[a,b])}}},CLASS_NAME:"OpenLayers.Format.WMSCapabilities.v1_3"});OpenLayers.Format.WMSCapabilities.v1_3_0=OpenLayers.Class(OpenLayers.Format.WMSCapabilities.v1_3,{version:"1.3.0",CLASS_NAME:"OpenLayers.Format.WMSCapabilities.v1_3_0"});OpenLayers.Symbolizer.Polygon=OpenLayers.Class(OpenLayers.Symbolizer,{initialize:function(){OpenLayers.Symbolizer.prototype.initialize.apply(this,arguments)},CLASS_NAME:"OpenLayers.Symbolizer.Polygon"});
OpenLayers.Lang.nb={unhandledRequest:"Ubehandlet foresp\u00f8rsel returnerte ${statusText}",Permalink:"Kobling til denne siden",Overlays:"Kartlag","Base Layer":"Bakgrunnskart",readNotImplemented:"Lesing er ikke implementert.",writeNotImplemented:"Skriving er ikke implementert.",noFID:"Kan ikke oppdatere et feature (et objekt) som ikke har FID.",errorLoadingGML:"Feil under lasting av GML-fil ${url}",browserNotSupported:"Din nettleser st\u00f8tter ikke vektortegning. Tegnemetodene som st\u00f8ttes er:\n${renderers}",
componentShouldBe:"addFeatures : komponenten m\u00e5 v\u00e6re en ${geomType}",getFeatureError:"getFeatureFromEvent har blitt kj\u00f8rt mot et lag uten noen tegnemetode. Dette betyr som regel at du fjernet et lag uten \u00e5 fjerne alle h\u00e5ndterere tilknyttet laget.",minZoomLevelError:"Egenskapen minZoomLevel er kun ment til bruk p\u00e5 lag basert p\u00e5 FixedZoomLevels. At dette wfs-laget sjekker minZoomLevel er en etterlevning fra tidligere versjoner. Det kan dog ikke tas bort uten \u00e5 risikere at OL-baserte applikasjoner slutter \u00e5 virke, s\u00e5 det er merket som foreldet: minZoomLevel i sjekken nedenfor vil fjernes i 3.0. Vennligst bruk innstillingene for min/maks oppl\u00f8sning som er beskrevet her: http://trac.openlayers.org/wiki/SettingZoomLevels",
commitSuccess:"WFS-transaksjon: LYKTES ${response}",commitFailed:"WFS-transaksjon: MISLYKTES ${response}",googleWarning:"Google-laget kunne ikke lastes.<br><br>Bytt til et annet bakgrunnslag i lagvelgeren i \u00f8vre h\u00f8yre hj\u00f8rne for \u00e5 slippe denne meldingen.<br><br>Sannsynligvis for\u00e5rsakes feilen av at Google Maps-biblioteket ikke er riktig inkludert p\u00e5 nettsiden, eller at det ikke er angitt riktig API-n\u00f8kkel for nettstedet.<br><br>Utviklere: For hjelp til \u00e5 f\u00e5 dette til \u00e5 virke se <a href='http://trac.openlayers.org/wiki/Google' target='_blank'>her</a>.",
getLayerWarning:"${layerType}-laget kunne ikke lastes.<br><br>Bytt til et annet bakgrunnslag i lagvelgeren i \u00f8vre h\u00f8yre hj\u00f8rne for \u00e5 slippe denne meldingen.<br><br>Sannsynligvis for\u00e5rsakes feilen av at ${layerLib}-biblioteket ikke var riktig inkludert p\u00e5 nettsiden.<br><br>Utviklere: For hjelp til \u00e5 f\u00e5 dette til \u00e5 virke se <a href='http://trac.openlayers.org/wiki/${layerLib}' target='_blank'>her</a>.","Scale = 1 : ${scaleDenom}":"<strong>Skala</strong> 1 : ${scaleDenom}",
layerAlreadyAdded:"Du fors\u00f8kte \u00e5 legge til laget ${layerName} p\u00e5 kartet, men det er allerede lagt til",reprojectDeprecated:"Du bruker innstillingen 'reproject' p\u00e5 laget ${layerName}. Denne innstillingen er foreldet, den var ment for \u00e5 st\u00f8tte visning av kartdata over kommersielle bakgrunnskart, men det b\u00f8r n\u00e5 gj\u00f8res med st\u00f8tten for Spherical Mercator. Mer informasjon finnes p\u00e5 http://trac.openlayers.org/wiki/SphericalMercator.",methodDeprecated:"Denne metoden er markert som foreldet og vil bli fjernet i 3.0. Vennligst bruk ${newMethod} i stedet.",
boundsAddError:"Du m\u00e5 gi b\u00e5de x- og y-verdier til funksjonen add.",lonlatAddError:"Du m\u00e5 gi b\u00e5de lon- og lat-verdier til funksjonen add.",pixelAddError:"Du m\u00e5 gi b\u00e5de x- og y-verdier til funksjonen add.",unsupportedGeometryType:"Geometritypen ${geomType} er ikke st\u00f8ttet",end:""};OpenLayers.Lang.no=OpenLayers.Lang.nb;
OpenLayers.ElementsIndexer=OpenLayers.Class({maxZIndex:null,order:null,indices:null,compare:null,initialize:function(a){this.compare=a?OpenLayers.ElementsIndexer.IndexingMethods.Z_ORDER_Y_ORDER:OpenLayers.ElementsIndexer.IndexingMethods.Z_ORDER_DRAWING_ORDER;this.clear()},insert:function(a){this.exists(a)&&this.remove(a);var b=a.id;this.determineZIndex(a);for(var c=-1,d=this.order.length,e;d-c>1;){e=parseInt((c+d)/2);if(this.compare(this,a,OpenLayers.Util.getElement(this.order[e]))>0)c=e;else d=e}this.order.splice(d,
0,b);this.indices[b]=this.getZIndex(a);return this.getNextElement(d)},remove:function(a){a=a.id;var b=OpenLayers.Util.indexOf(this.order,a);if(b>=0){this.order.splice(b,1);delete this.indices[a];this.maxZIndex=this.order.length>0?this.indices[this.order[this.order.length-1]]:0}},clear:function(){this.order=[];this.indices={};this.maxZIndex=0},exists:function(a){return this.indices[a.id]!=null},getZIndex:function(a){return a._style.graphicZIndex},determineZIndex:function(a){var b=a._style.graphicZIndex;
if(b==null){b=this.maxZIndex;a._style.graphicZIndex=b}else if(b>this.maxZIndex)this.maxZIndex=b},getNextElement:function(a){a+=1;if(a<this.order.length){var b=OpenLayers.Util.getElement(this.order[a]);if(b==undefined)b=this.getNextElement(a);return b}else return null},CLASS_NAME:"OpenLayers.ElementsIndexer"});
OpenLayers.ElementsIndexer.IndexingMethods={Z_ORDER:function(a,b,c){b=a.getZIndex(b);var d=0;if(c){a=a.getZIndex(c);d=b-a}return d},Z_ORDER_DRAWING_ORDER:function(a,b,c){a=OpenLayers.ElementsIndexer.IndexingMethods.Z_ORDER(a,b,c);if(c&&a==0)a=1;return a},Z_ORDER_Y_ORDER:function(a,b,c){a=OpenLayers.ElementsIndexer.IndexingMethods.Z_ORDER(a,b,c);if(c&&a===0){b=c._boundsBottom-b._boundsBottom;a=b===0?1:b}return a}};
OpenLayers.Renderer.Elements=OpenLayers.Class(OpenLayers.Renderer,{rendererRoot:null,root:null,vectorRoot:null,textRoot:null,xmlns:null,indexer:null,BACKGROUND_ID_SUFFIX:"_background",LABEL_ID_SUFFIX:"_label",initialize:function(a,b){OpenLayers.Renderer.prototype.initialize.apply(this,arguments);this.rendererRoot=this.createRenderRoot();this.root=this.createRoot("_root");this.vectorRoot=this.createRoot("_vroot");this.textRoot=this.createRoot("_troot");this.root.appendChild(this.vectorRoot);this.root.appendChild(this.textRoot);
this.rendererRoot.appendChild(this.root);this.container.appendChild(this.rendererRoot);if(b&&(b.zIndexing||b.yOrdering))this.indexer=new OpenLayers.ElementsIndexer(b.yOrdering)},destroy:function(){this.clear();this.xmlns=this.root=this.rendererRoot=null;OpenLayers.Renderer.prototype.destroy.apply(this,arguments)},clear:function(){var a,b=this.vectorRoot;if(b)for(;a=b.firstChild;)b.removeChild(a);if(b=this.textRoot)for(;a=b.firstChild;)b.removeChild(a);this.indexer&&this.indexer.clear()},getNodeType:function(){},
drawGeometry:function(a,b,c){var d=a.CLASS_NAME,e=true;if(d=="OpenLayers.Geometry.Collection"||d=="OpenLayers.Geometry.MultiPoint"||d=="OpenLayers.Geometry.MultiLineString"||d=="OpenLayers.Geometry.MultiPolygon"){d=0;for(var f=a.components.length;d<f;d++)e=this.drawGeometry(a.components[d],b,c)&&e;return e}d=e=false;if(b.display!="none"){if(b.backgroundGraphic)this.redrawBackgroundNode(a.id,a,b,c);else d=true;e=this.redrawNode(a.id,a,b,c)}if(e==false)if(b=document.getElementById(a.id)){if(b._style.backgroundGraphic)d=
true;b.parentNode.removeChild(b)}if(d)(b=document.getElementById(a.id+this.BACKGROUND_ID_SUFFIX))&&b.parentNode.removeChild(b);return e},redrawNode:function(a,b,c,d){c=this.applyDefaultSymbolizer(c);a=this.nodeFactory(a,this.getNodeType(b,c));a._featureId=d;a._boundsBottom=b.getBounds().bottom;a._geometryClass=b.CLASS_NAME;a._style=c;b=this.drawGeometryNode(a,b,c);if(b===false)return false;a=b.node;if(this.indexer)(c=this.indexer.insert(a))?this.vectorRoot.insertBefore(a,c):this.vectorRoot.appendChild(a);
else a.parentNode!==this.vectorRoot&&this.vectorRoot.appendChild(a);this.postDraw(a);return b.complete},redrawBackgroundNode:function(a,b,c){c=OpenLayers.Util.extend({},c);c.externalGraphic=c.backgroundGraphic;c.graphicXOffset=c.backgroundXOffset;c.graphicYOffset=c.backgroundYOffset;c.graphicZIndex=c.backgroundGraphicZIndex;c.graphicWidth=c.backgroundWidth||c.graphicWidth;c.graphicHeight=c.backgroundHeight||c.graphicHeight;c.backgroundGraphic=null;c.backgroundXOffset=null;c.backgroundYOffset=null;
c.backgroundGraphicZIndex=null;return this.redrawNode(a+this.BACKGROUND_ID_SUFFIX,b,c,null)},drawGeometryNode:function(a,b,c){c=c||a._style;var d={isFilled:c.fill===undefined?true:c.fill,isStroked:c.stroke===undefined?!!c.strokeWidth:c.stroke},e;switch(b.CLASS_NAME){case "OpenLayers.Geometry.Point":if(c.graphic===false){d.isFilled=false;d.isStroked=false}e=this.drawPoint(a,b);break;case "OpenLayers.Geometry.LineString":d.isFilled=false;e=this.drawLineString(a,b);break;case "OpenLayers.Geometry.LinearRing":e=
this.drawLinearRing(a,b);break;case "OpenLayers.Geometry.Polygon":e=this.drawPolygon(a,b);break;case "OpenLayers.Geometry.Surface":e=this.drawSurface(a,b);break;case "OpenLayers.Geometry.Rectangle":e=this.drawRectangle(a,b)}a._options=d;return e!=false?{node:this.setStyle(a,c,d,b),complete:e}:false},postDraw:function(){},drawPoint:function(){},drawLineString:function(){},drawLinearRing:function(){},drawPolygon:function(){},drawRectangle:function(){},drawCircle:function(){},drawSurface:function(){},
removeText:function(a){(a=document.getElementById(a+this.LABEL_ID_SUFFIX))&&this.textRoot.removeChild(a)},getFeatureIdFromEvent:function(a){var b=a.target,c=b&&b.correspondingUseElement;return(c?c:b||a.srcElement)._featureId},eraseGeometry:function(a,b){if(a.CLASS_NAME=="OpenLayers.Geometry.MultiPoint"||a.CLASS_NAME=="OpenLayers.Geometry.MultiLineString"||a.CLASS_NAME=="OpenLayers.Geometry.MultiPolygon"||a.CLASS_NAME=="OpenLayers.Geometry.Collection")for(var c=0,d=a.components.length;c<d;c++)this.eraseGeometry(a.components[c],
b);else if((c=OpenLayers.Util.getElement(a.id))&&c.parentNode){if(c.geometry){c.geometry.destroy();c.geometry=null}c.parentNode.removeChild(c);this.indexer&&this.indexer.remove(c);if(c._style.backgroundGraphic)(c=OpenLayers.Util.getElement(a.id+this.BACKGROUND_ID_SUFFIX))&&c.parentNode&&c.parentNode.removeChild(c)}},nodeFactory:function(a,b){var c=OpenLayers.Util.getElement(a);if(c){if(!this.nodeTypeCompare(c,b)){c.parentNode.removeChild(c);c=this.nodeFactory(a,b)}}else c=this.createNode(b,a);return c},
nodeTypeCompare:function(){},createNode:function(){},moveRoot:function(a){var b=this.root;if(a.root.parentNode==this.rendererRoot)b=a.root;b.parentNode.removeChild(b);a.rendererRoot.appendChild(b)},getRenderLayerId:function(){return this.root.parentNode.parentNode.id},isComplexSymbol:function(a){return a!="circle"&&!!a},CLASS_NAME:"OpenLayers.Renderer.Elements"});
OpenLayers.Renderer.symbol={star:[350,75,379,161,469,161,397,215,423,301,350,250,277,301,303,215,231,161,321,161,350,75],cross:[4,0,6,0,6,4,10,4,10,6,6,6,6,10,4,10,4,6,0,6,0,4,4,4,4,0],x:[0,0,25,0,50,35,75,0,100,0,65,50,100,100,75,100,50,65,25,100,0,100,35,50,0,0],square:[0,0,0,1,1,1,1,0,0,0],triangle:[0,10,10,10,5,0,0,10]};
OpenLayers.Control.ArgParser=OpenLayers.Class(OpenLayers.Control,{center:null,zoom:null,layers:null,displayProjection:null,getParameters:function(a){a=a||window.location.href;var b=OpenLayers.Util.getParameters(a),c=a.indexOf("#");if(c>0){a="?"+a.substring(c+1,a.length);OpenLayers.Util.extend(b,OpenLayers.Util.getParameters(a))}return b},setMap:function(){OpenLayers.Control.prototype.setMap.apply(this,arguments);for(var a=0,b=this.map.controls.length;a<b;a++){var c=this.map.controls[a];if(c!=this&&
c.CLASS_NAME=="OpenLayers.Control.ArgParser"){if(c.displayProjection!=this.displayProjection)this.displayProjection=c.displayProjection;break}}if(a==this.map.controls.length){a=this.getParameters();if(a.layers){this.layers=a.layers;this.map.events.register("addlayer",this,this.configureLayers);this.configureLayers()}if(a.lat&&a.lon){this.center=new OpenLayers.LonLat(parseFloat(a.lon),parseFloat(a.lat));if(a.zoom)this.zoom=parseInt(a.zoom);this.map.events.register("changebaselayer",this,this.setCenter);
this.setCenter()}}},setCenter:function(){if(this.map.baseLayer){this.map.events.unregister("changebaselayer",this,this.setCenter);this.displayProjection&&this.center.transform(this.displayProjection,this.map.getProjectionObject());this.map.setCenter(this.center,this.zoom)}},configureLayers:function(){if(this.layers.length==this.map.layers.length){this.map.events.unregister("addlayer",this,this.configureLayers);for(var a=0,b=this.layers.length;a<b;a++){var c=this.map.layers[a],d=this.layers.charAt(a);
if(d=="B")this.map.setBaseLayer(c);else if(d=="T"||d=="F")c.setVisibility(d=="T")}}},CLASS_NAME:"OpenLayers.Control.ArgParser"});
OpenLayers.Control.Permalink=OpenLayers.Class(OpenLayers.Control,{argParserClass:OpenLayers.Control.ArgParser,element:null,anchor:false,base:"",displayProjection:null,initialize:function(a,b,c){if(a!==null&&typeof a=="object"&&!OpenLayers.Util.isElement(a)){this.base=document.location.href;OpenLayers.Control.prototype.initialize.apply(this,[a]);if(this.element!=null)this.element=OpenLayers.Util.getElement(this.element)}else{OpenLayers.Control.prototype.initialize.apply(this,[c]);this.element=OpenLayers.Util.getElement(a);
this.base=b||document.location.href}},destroy:function(){this.element.parentNode==this.div&&this.div.removeChild(this.element);this.element=null;this.map.events.unregister("moveend",this,this.updateLink);OpenLayers.Control.prototype.destroy.apply(this,arguments)},setMap:function(){OpenLayers.Control.prototype.setMap.apply(this,arguments);for(var a=0,b=this.map.controls.length;a<b;a++){var c=this.map.controls[a];if(c.CLASS_NAME==this.argParserClass.CLASS_NAME){if(c.displayProjection!=this.displayProjection)this.displayProjection=
c.displayProjection;break}}a==this.map.controls.length&&this.map.addControl(new this.argParserClass({displayProjection:this.displayProjection}))},draw:function(){OpenLayers.Control.prototype.draw.apply(this,arguments);if(!this.element&&!this.anchor){this.element=document.createElement("a");this.element.innerHTML=OpenLayers.i18n("Permalink");this.element.href="";this.div.appendChild(this.element)}this.map.events.on({moveend:this.updateLink,changelayer:this.updateLink,changebaselayer:this.updateLink,
scope:this});this.updateLink();return this.div},updateLink:function(){var a=this.anchor?"#":"?",b=this.base;if(b.indexOf(a)!=-1)b=b.substring(0,b.indexOf(a));b+=a+OpenLayers.Util.getParameterString(this.createParams());if(this.anchor&&!this.element)window.location.href=b;else this.element.href=b},createParams:function(a,b,c){a=a||this.map.getCenter();var d=OpenLayers.Util.getParameters(this.base);if(a){d.zoom=b||this.map.getZoom();b=a.lat;a=a.lon;if(this.displayProjection){b=OpenLayers.Projection.transform({x:a,
y:b},this.map.getProjectionObject(),this.displayProjection);a=b.x;b=b.y}d.lat=Math.round(b*1E5)/1E5;d.lon=Math.round(a*1E5)/1E5;c=c||this.map.layers;d.layers="";a=0;for(b=c.length;a<b;a++){var e=c[a];d.layers+=e.isBaseLayer?e==this.map.baseLayer?"B":"0":e.getVisibility()?"T":"F"}}return d},CLASS_NAME:"OpenLayers.Control.Permalink"});
OpenLayers.Layer.TMS=OpenLayers.Class(OpenLayers.Layer.Grid,{serviceVersion:"1.0.0",layername:null,type:null,isBaseLayer:true,tileOrigin:null,serverResolutions:null,zoomOffset:0,initialize:function(a,b,c){var d=[];d.push(a,b,{},c);OpenLayers.Layer.Grid.prototype.initialize.apply(this,d)},destroy:function(){OpenLayers.Layer.Grid.prototype.destroy.apply(this,arguments)},clone:function(a){if(a==null)a=new OpenLayers.Layer.TMS(this.name,this.url,this.getOptions());return a=OpenLayers.Layer.Grid.prototype.clone.apply(this,
[a])},getURL:function(a){a=this.adjustBounds(a);var b=this.map.getResolution(),c=Math.round((a.left-this.tileOrigin.lon)/(b*this.tileSize.w));a=Math.round((a.bottom-this.tileOrigin.lat)/(b*this.tileSize.h));b=this.serviceVersion+"/"+this.layername+"/"+(this.serverResolutions!=null?OpenLayers.Util.indexOf(this.serverResolutions,b):this.map.getZoom()+this.zoomOffset)+"/"+c+"/"+a+"."+this.type;c=this.url;if(OpenLayers.Util.isArray(c))c=this.selectUrl(b,c);return c+b},setMap:function(){OpenLayers.Layer.Grid.prototype.setMap.apply(this,
arguments);if(!this.tileOrigin)this.tileOrigin=new OpenLayers.LonLat(this.map.maxExtent.left,this.map.maxExtent.bottom)},CLASS_NAME:"OpenLayers.Layer.TMS"});
OpenLayers.Lang.sv=OpenLayers.Util.applyDefaults({unhandledRequest:"Ej hanterad fr\u00e5ga retur ${statusText}",Permalink:"Permal\u00e4nk",Overlays:"Kartlager","Base Layer":"Bakgrundskarta",readNotImplemented:"L\u00e4sning ej implementerad.",writeNotImplemented:"Skrivning ej implementerad.",noFID:"Kan ej uppdatera feature (objekt) f\u00f6r vilket FID saknas.",errorLoadingGML:"Fel i laddning av GML-fil ${url}",browserNotSupported:"Din webbl\u00e4sare st\u00f6der inte vektorvisning. F\u00f6r n\u00e4rvarande st\u00f6ds f\u00f6ljande visning:\n${renderers}",
componentShouldBe:"addFeatures : komponenten skall vara en ${geomType}",getFeatureError:"getFeatureFromEvent anropad f\u00f6r lager utan utritning. Detta betyder oftast att man raderat ett lager, men inte en hanterare som \u00e4r knuten till lagret.",minZoomLevelError:"Egenskapen minZoomLevel \u00e4r endast avsedd att anv\u00e4ndas med lager med FixedZoomLevels. Att detta WFS-lager kontrollerar minZoomLevel \u00e4r en relik fr\u00e5n \u00e4ldre versioner. Vi kan dock inte ta bort det utan att riskera att OL-baserade till\u00e4mpningar som anv\u00e4nder detta slutar fungera. D\u00e4rf\u00f6r \u00e4r det satt som deprecated, minZoomLevel kommer att tas bort i version 3.0. Anv\u00e4nd i st\u00e4llet inst\u00e4llning av min/max resolution som beskrivs h\u00e4r: http://trac.openlayers.org/wiki/SettingZoomLevels",
commitSuccess:"WFS-transaktion: LYCKADES ${response}",commitFailed:"WFS-transaktion: MISSLYCKADES ${response}",googleWarning:"Google-lagret kunde inte laddas korrekt.<br><br>F\u00f6r att slippa detta meddelande, v\u00e4lj en annan bakgrundskarta i lagerv\u00e4ljaren i \u00f6vre h\u00f6gra h\u00f6rnet.<br><br>Sannolikt beror felet p\u00e5 att Google Maps-biblioteket inte \u00e4r inkluderat p\u00e5 webbsidan eller p\u00e5 att sidan inte anger korrekt API-nyckel f\u00f6r webbplatsen.<br><br>Utvecklare: hj\u00e4lp f\u00f6r att \u00e5tg\u00e4rda detta, <a href='http://trac.openlayers.org/wiki/Google' target='_blank'>klicka h\u00e4r</a>.",
getLayerWarning:"${layerType}-lagret kunde inte laddas korrekt.<br><br>F\u00f6r att slippa detta meddelande, v\u00e4lj en annan bakgrundskarta i lagerv\u00e4ljaren i \u00f6vre h\u00f6gra h\u00f6rnet.<br><br>Sannolikt beror felet p\u00e5 att ${layerLib}-biblioteket inte \u00e4r inkluderat p\u00e5 webbsidan.<br><br>Utvecklare: hj\u00e4lp f\u00f6r att \u00e5tg\u00e4rda detta, <a href='http://trac.openlayers.org/wiki/${layerLib}' target='_blank'>klicka h\u00e4r</a>.","Scale = 1 : ${scaleDenom}":"<strong>Skala</strong> 1 : ${scaleDenom}",
layerAlreadyAdded:"Du f\u00f6rs\u00f6kte l\u00e4gga till lagret: ${layerName} p\u00e5 kartan, men det har lagts till tidigare",reprojectDeprecated:"Du anv\u00e4nder inst\u00e4llningen 'reproject' p\u00e5 lagret ${layerName}. Denna inst\u00e4llning markerad som deprecated: den var avsedd att anv\u00e4ndas f\u00f6r att st\u00f6dja visning av kartdata p\u00e5 kommersiella bakgrundskartor, men nu b\u00f6r man i st\u00e4llet anv\u00e4nda Spherical Mercator-st\u00f6d f\u00f6r den funktionaliteten. Mer information finns p\u00e5 http://trac.openlayers.org/wiki/SphericalMercator.",
methodDeprecated:"Denna metod \u00e4r markerad som deprecated och kommer att tas bort i 3.0. Anv\u00e4nd ${newMethod} i st\u00e4llet.",boundsAddError:"Du m\u00e5ste skicka b\u00e5de x- och y-v\u00e4rde till funktionen add.",lonlatAddError:"Du m\u00e5ste skicka b\u00e5de lon- och lat-v\u00e4rde till funktionen add.",pixelAddError:"Du m\u00e5ste skicka b\u00e5de x- och y-v\u00e4rde till funktionen add.",unsupportedGeometryType:"St\u00f6d saknas f\u00f6r geometritypen: ${geomType}",filterEvaluateNotImplemented:"evaluering har ej implementerats f\u00f6r denna typ av filter."});
OpenLayers.Strategy.Fixed=OpenLayers.Class(OpenLayers.Strategy,{preload:false,activate:function(){if(OpenLayers.Strategy.prototype.activate.apply(this,arguments)){this.layer.events.on({refresh:this.load,scope:this});if(this.layer.visibility==true||this.preload)this.load();else this.layer.events.on({visibilitychanged:this.load,scope:this});return true}return false},deactivate:function(){var a=OpenLayers.Strategy.prototype.deactivate.call(this);a&&this.layer.events.un({refresh:this.load,visibilitychanged:this.load,
scope:this});return a},load:function(a){var b=this.layer;b.events.triggerEvent("loadstart");b.protocol.read(OpenLayers.Util.applyDefaults({callback:OpenLayers.Function.bind(this.merge,this,b.map.getProjectionObject()),filter:b.filter},a));b.events.un({visibilitychanged:this.load,scope:this})},merge:function(a,b){var c=this.layer;c.destroyFeatures();var d=b.features;if(d&&d.length>0){if(!a.equals(c.projection))for(var e,f=0,g=d.length;f<g;++f)(e=d[f].geometry)&&e.transform(c.projection,a);c.addFeatures(d)}c.events.triggerEvent("loadend")},
CLASS_NAME:"OpenLayers.Strategy.Fixed"});OpenLayers.Symbolizer.Line=OpenLayers.Class(OpenLayers.Symbolizer,{initialize:function(){OpenLayers.Symbolizer.prototype.initialize.apply(this,arguments)},CLASS_NAME:"OpenLayers.Symbolizer.Line"});OpenLayers.Format.WFSCapabilities=OpenLayers.Class(OpenLayers.Format.XML.VersionedOGC,{defaultVersion:"1.1.0",errorProperty:"service",CLASS_NAME:"OpenLayers.Format.WFSCapabilities"});
OpenLayers.Format.WFSCapabilities.v1=OpenLayers.Class(OpenLayers.Format.WFSCapabilities,{initialize:function(a){OpenLayers.Format.XML.prototype.initialize.apply(this,[a]);this.options=a},read:function(a){if(typeof a=="string")a=OpenLayers.Format.XML.prototype.read.apply(this,[a]);var b={};this.runChildNodes(b,a.documentElement);return b},runChildNodes:function(a,b){for(var c=b.childNodes,d,e,f=0;f<c.length;++f){d=c[f];if(d.nodeType==1)(e=this["read_cap_"+d.nodeName])&&e.apply(this,[a,d])}},read_cap_FeatureTypeList:function(a,
b){var c={featureTypes:[]};this.runChildNodes(c,b);a.featureTypeList=c},read_cap_FeatureType:function(a,b){var c={};this.runChildNodes(c,b);a.featureTypes.push(c)},read_cap_Name:function(a,b){var c=this.getChildValue(b);if(c){c=c.split(":");a.name=c.pop();if(c.length>0)a.featureNS=this.lookupNamespaceURI(b,c[0])}},read_cap_Title:function(a,b){var c=this.getChildValue(b);if(c)a.title=c},read_cap_Abstract:function(a,b){var c=this.getChildValue(b);if(c)a["abstract"]=c},CLASS_NAME:"OpenLayers.Format.WFSCapabilities.v1"});
OpenLayers.Format.WFSCapabilities.v1_1_0=OpenLayers.Class(OpenLayers.Format.WFSCapabilities.v1,{initialize:function(a){OpenLayers.Format.WFSCapabilities.v1.prototype.initialize.apply(this,[a])},read_cap_DefaultSRS:function(a,b){var c=this.getChildValue(b);if(c)a.srs=c},CLASS_NAME:"OpenLayers.Format.WFSCapabilities.v1_1_0"});
OpenLayers.Layer.PointTrack=OpenLayers.Class(OpenLayers.Layer.Vector,{dataFrom:null,styleFrom:null,initialize:function(){OpenLayers.Layer.Vector.prototype.initialize.apply(this,arguments)},addNodes:function(a,b){if(a.length<2)OpenLayers.Console.error("At least two point features have to be added to createa line from");else{for(var c=Array(a.length-1),d,e,f,g=0,h=a.length;g<h;g++){d=a[g];if(f=d.geometry){if(f.CLASS_NAME!="OpenLayers.Geometry.Point"){OpenLayers.Console.error("Only features with point geometries are supported.");
return}}else{f=d.lonlat;f=new OpenLayers.Geometry.Point(f.lon,f.lat)}if(g>0){d=this.dataFrom!=null?a[g+this.dataFrom].data||a[g+this.dataFrom].attributes:null;var j=this.styleFrom!=null?a[g+this.styleFrom].style:null;e=new OpenLayers.Geometry.LineString([e,f]);c[g-1]=new OpenLayers.Feature.Vector(e,d,j)}e=f}this.addFeatures(c,b)}},CLASS_NAME:"OpenLayers.Layer.PointTrack"});OpenLayers.Layer.PointTrack.SOURCE_NODE=-1;OpenLayers.Layer.PointTrack.TARGET_NODE=0;
OpenLayers.Layer.PointTrack.dataFrom={SOURCE_NODE:-1,TARGET_NODE:0};OpenLayers.Protocol.WFS=function(a){a=OpenLayers.Util.applyDefaults(a,OpenLayers.Protocol.WFS.DEFAULTS);var b=OpenLayers.Protocol.WFS["v"+a.version.replace(/\./g,"_")];if(!b)throw"Unsupported WFS version: "+a.version;return new b(a)};
OpenLayers.Protocol.WFS.fromWMSLayer=function(a,b){var c,d;c=a.params.LAYERS;c=(OpenLayers.Util.isArray(c)?c[0]:c).split(":");if(c.length>1)d=c[0];c=c.pop();d={url:a.url,featureType:c,featurePrefix:d,srsName:a.projection&&a.projection.getCode()||a.map&&a.map.getProjectionObject().getCode(),version:"1.1.0"};return new OpenLayers.Protocol.WFS(OpenLayers.Util.applyDefaults(b,d))};OpenLayers.Protocol.WFS.DEFAULTS={version:"1.0.0"};
OpenLayers.Layer.Markers=OpenLayers.Class(OpenLayers.Layer,{isBaseLayer:false,markers:null,drawn:false,initialize:function(){OpenLayers.Layer.prototype.initialize.apply(this,arguments);this.markers=[]},destroy:function(){this.clearMarkers();this.markers=null;OpenLayers.Layer.prototype.destroy.apply(this,arguments)},setOpacity:function(a){if(a!=this.opacity){this.opacity=a;a=0;for(var b=this.markers.length;a<b;a++)this.markers[a].setOpacity(this.opacity)}},moveTo:function(a,b){OpenLayers.Layer.prototype.moveTo.apply(this,
arguments);if(b||!this.drawn){for(var c=0,d=this.markers.length;c<d;c++)this.drawMarker(this.markers[c]);this.drawn=true}},addMarker:function(a){this.markers.push(a);this.opacity<1&&a.setOpacity(this.opacity);if(this.map&&this.map.getExtent()){a.map=this.map;this.drawMarker(a)}},removeMarker:function(a){if(this.markers&&this.markers.length){OpenLayers.Util.removeItem(this.markers,a);a.erase()}},clearMarkers:function(){if(this.markers!=null)for(;this.markers.length>0;)this.removeMarker(this.markers[0])},
drawMarker:function(a){var b=this.map.getLayerPxFromLonLat(a.lonlat);if(b==null)a.display(false);else if(a.isDrawn())a.icon&&a.icon.moveTo(b);else this.div.appendChild(a.draw(b))},getDataExtent:function(){var a=null;if(this.markers&&this.markers.length>0){a=new OpenLayers.Bounds;for(var b=0,c=this.markers.length;b<c;b++)a.extend(this.markers[b].lonlat)}return a},CLASS_NAME:"OpenLayers.Layer.Markers"});
OpenLayers.Control.Pan=OpenLayers.Class(OpenLayers.Control,{slideFactor:50,slideRatio:null,direction:null,type:OpenLayers.Control.TYPE_BUTTON,initialize:function(a,b){this.direction=a;this.CLASS_NAME+=this.direction;OpenLayers.Control.prototype.initialize.apply(this,[b])},trigger:function(){var a=OpenLayers.Function.bind(function(b){return this.slideRatio?this.map.getSize()[b]*this.slideRatio:this.slideFactor},this);switch(this.direction){case OpenLayers.Control.Pan.NORTH:this.map.pan(0,-a("h"));
break;case OpenLayers.Control.Pan.SOUTH:this.map.pan(0,a("h"));break;case OpenLayers.Control.Pan.WEST:this.map.pan(-a("w"),0);break;case OpenLayers.Control.Pan.EAST:this.map.pan(a("w"),0)}},CLASS_NAME:"OpenLayers.Control.Pan"});OpenLayers.Control.Pan.NORTH="North";OpenLayers.Control.Pan.SOUTH="South";OpenLayers.Control.Pan.EAST="East";OpenLayers.Control.Pan.WEST="West";
OpenLayers.Layer.WMS=OpenLayers.Class(OpenLayers.Layer.Grid,{DEFAULT_PARAMS:{service:"WMS",version:"1.1.1",request:"GetMap",styles:"",format:"image/jpeg"},reproject:false,isBaseLayer:true,encodeBBOX:false,noMagic:false,yx:{"EPSG:4326":true},initialize:function(a,b,c,d){var e=[];c=OpenLayers.Util.upperCaseObject(c);if(parseFloat(c.VERSION)>=1.3&&!c.EXCEPTIONS)c.EXCEPTIONS="INIMAGE";e.push(a,b,c,d);OpenLayers.Layer.Grid.prototype.initialize.apply(this,e);OpenLayers.Util.applyDefaults(this.params,OpenLayers.Util.upperCaseObject(this.DEFAULT_PARAMS));
if(!this.noMagic&&this.params.TRANSPARENT&&this.params.TRANSPARENT.toString().toLowerCase()=="true"){if(d==null||!d.isBaseLayer)this.isBaseLayer=false;if(this.params.FORMAT=="image/jpeg")this.params.FORMAT=OpenLayers.Util.alphaHack()?"image/gif":"image/png"}},destroy:function(){OpenLayers.Layer.Grid.prototype.destroy.apply(this,arguments)},clone:function(a){if(a==null)a=new OpenLayers.Layer.WMS(this.name,this.url,this.params,this.getOptions());return a=OpenLayers.Layer.Grid.prototype.clone.apply(this,
[a])},reverseAxisOrder:function(){return parseFloat(this.params.VERSION)>=1.3&&!!this.yx[this.map.getProjectionObject().getCode()]},getURL:function(a){a=this.adjustBounds(a);var b=this.getImageSize(),c={},d=this.reverseAxisOrder();c.BBOX=this.encodeBBOX?a.toBBOX(null,d):a.toArray(d);c.WIDTH=b.w;c.HEIGHT=b.h;return this.getFullRequestString(c)},mergeNewParams:function(a){a=[OpenLayers.Util.upperCaseObject(a)];return OpenLayers.Layer.Grid.prototype.mergeNewParams.apply(this,a)},getFullRequestString:function(a){var b=
this.map.getProjectionObject();b=this.projection&&this.projection.equals(b)?this.projection.getCode():b.getCode();b=b=="none"?null:b;if(parseFloat(this.params.VERSION)>=1.3)this.params.CRS=b;else this.params.SRS=b;if(typeof this.params.TRANSPARENT=="boolean")a.TRANSPARENT=this.params.TRANSPARENT?"TRUE":"FALSE";return OpenLayers.Layer.Grid.prototype.getFullRequestString.apply(this,arguments)},CLASS_NAME:"OpenLayers.Layer.WMS"});
OpenLayers.Layer.WMS.Untiled=OpenLayers.Class(OpenLayers.Layer.WMS,{singleTile:true,initialize:function(){OpenLayers.Layer.WMS.prototype.initialize.apply(this,arguments);OpenLayers.Console.warn("The OpenLayers.Layer.WMS.Untiled class is deprecated and will be removed in 3.0. Instead, you should use the normal OpenLayers.Layer.WMS class, passing it the option 'singleTile' as true.")},clone:function(a){if(a==null)a=new OpenLayers.Layer.WMS.Untiled(this.name,this.url,this.params,this.getOptions());return a=
OpenLayers.Layer.WMS.prototype.clone.apply(this,[a])},CLASS_NAME:"OpenLayers.Layer.WMS.Untiled"});OpenLayers.Geometry.Surface=OpenLayers.Class(OpenLayers.Geometry,{initialize:function(){OpenLayers.Geometry.prototype.initialize.apply(this,arguments)},CLASS_NAME:"OpenLayers.Geometry.Surface"});OpenLayers.Format.ArcXML.Features=OpenLayers.Class(OpenLayers.Format.XML,{initialize:function(a){OpenLayers.Format.XML.prototype.initialize.apply(this,[a])},read:function(a){return(new OpenLayers.Format.ArcXML).read(a).features.feature}});
OpenLayers.Lang.gsw=OpenLayers.Util.applyDefaults({unhandledRequest:"Nit behandleti Aafrogsruckm\u00e4ldig ${statusText}",Permalink:"Permalink",Overlays:"Iberlagerige","Base Layer":"Grundcharte",readNotImplemented:"L\u00e4se nit implementiert.",writeNotImplemented:"Schrybe nit implementiert.",noFID:"E Feature, wu s kei FID derfir git, cha nit aktualisiert w\u00e4re.",errorLoadingGML:"F\u00e4hler bim Lade vu dr GML-Datei ${url}",browserNotSupported:"Dyy Browser unterstitzt kei Vektordarstellig. Aktu\u00e4ll unterstitzti Renderer:\n${renderers}",
componentShouldBe:"addFeatures : Kompon\u00e4nt sott dr Typ ${geomType} syy",getFeatureError:"getFeatureFromEvent isch uf eme Layer ohni Renderer ufgruefe wore. Des heisst normalerwys, ass Du e Layer kaputt gmacht hesch, aber nit dr Handler, wu derzue ghert.",minZoomLevelError:"D minZoomLevel-Eigeschaft isch nume d\u00e4nk fir d Layer, wu vu dr FixedZoomLevels abstamme. Ass d\u00e4\u00e4 wfs-Layer minZoomLevel prieft, scih e Relikt us dr Vergangeheit. Mir chenne s aber nit \u00e4ndere ohni OL_basierti Aaw\u00e4ndige villicht kaputt gehn, wu dervu abh\u00e4nge.  Us d\u00e4m Grund het die Funktion d Eigeschaft 'deprecated' iberchuu. D minZoomLevel-Priefig unte wird in dr Version 3.0 usegnuu. Bitte verw\u00e4nd statt d\u00e4m e min/max-Uflesig wie s do bschriben isch: http://trac.openlayers.org/wiki/SettingZoomLevels",
commitSuccess:"WFS-Transaktion: ERFOLGRYCH ${response}",commitFailed:"WFS-Transaktion: F\u00c4HLGSCHLAA ${response}",googleWarning:"Dr Google-Layer het nit korr\u00e4kt chenne glade w\u00e4re.<br><br>Go die M\u00e4ldig nimi z kriege, wehl e andere Hintergrundlayer us em LayerSwitcher im r\u00e4chte obere Ecke.<br><br>D\u00e4\u00e4 F\u00e4hler git s seli hyfig, wel s Skript vu dr Google-Maps-Bibliothek nit yybunde woren isch oder wel s kei giltige API-Schlissel fir Dyy URL din het.<br><br>Entwickler: Fir Hilf zum korr\u00e4kte Yybinde vum Google-Layer <a href='http://trac.openlayers.org/wiki/Google' target='_blank'>doo drucke</a>",
getLayerWarning:"Dr ${layerType}-Layer het nit korr\u00e4kt chenne glade w\u00e4re.<br><br>Go die M\u00e4ldig nimi z kriege, wehl e andere Hintergrundlayer us em LayerSwitcher im r\u00e4chte obere Ecke.<br><br>D\u00e4\u00e4 F\u00e4hler git s seli hyfig, wel s Skript vu dr '${layerLib}'-Bibliothek nit yybunde woren isch oder wel s kei giltige API-Schlissel fir Dyy URL din het.<br><br>Entwickler: Fir Hilf zum korr\u00e4kte Yybinde vu Layer <a href='http://trac.openlayers.org/wiki/${layerLib}' target='_blank'>doo drucke</a>",
"Scale = 1 : ${scaleDenom}":"Ma\u00dfstab = 1 : ${scaleDenom}",W:"W",E:"O",N:"N",S:"S",layerAlreadyAdded:"Du hesch versuecht d\u00e4\u00e4 Layer in d Charte yyzfiege: ${layerName}, aber \u00e4r isch schoi yygfiegt",reprojectDeprecated:"Du bruchsch d 'reproject'-Option bim ${layerName}-Layer. Die Option isch nimi giltig: si isch aagleit wore go   Date iber kommerzi\u00e4lli Grundcharte lege, aber des sott mer jetz mache mit dr Unterstitzig vu Spherical Mercator. Meh Informatione git s uf http://trac.openlayers.org/wiki/SphericalMercator.",
methodDeprecated:"Die Methode isch veraltet un wird us dr Version 3.0 usegnuu. Bitte verw\u00e4bnd statt d\u00e4m ${newMethod}.",boundsAddError:"Du muesch e x-W\u00e4rt un e y-W\u00e4rt yygee bi dr Zuefieg-Funktion",lonlatAddError:"Du meusch e Lengi- un e Breiti-Grad yygee bi dr Zuefieg-Funktion.",pixelAddError:"Du muesch x- un y-W\u00e4rt aagee bi dr Zuefieg-Funktion.",unsupportedGeometryType:"Nit unterstitze Geometrii-Typ: ${geomType}",filterEvaluateNotImplemented:"evaluiere isch nit implem\u00e4ntiert in d\u00e4m Filtertyp."});
OpenLayers.Control.Snapping=OpenLayers.Class(OpenLayers.Control,{EVENT_TYPES:["beforesnap","snap","unsnap"],DEFAULTS:{tolerance:10,node:true,edge:true,vertex:true},greedy:true,precedence:["node","vertex","edge"],resolution:null,geoToleranceCache:null,layer:null,feature:null,point:null,initialize:function(a){Array.prototype.push.apply(this.EVENT_TYPES,OpenLayers.Control.prototype.EVENT_TYPES);OpenLayers.Control.prototype.initialize.apply(this,[a]);this.options=a||{};this.options.layer&&this.setLayer(this.options.layer);
a=OpenLayers.Util.extend({},this.options.defaults);this.defaults=OpenLayers.Util.applyDefaults(a,this.DEFAULTS);this.setTargets(this.options.targets);this.targets.length===0&&this.layer&&this.addTargetLayer(this.layer);this.geoToleranceCache={}},setLayer:function(a){if(this.active){this.deactivate();this.layer=a;this.activate()}else this.layer=a},setTargets:function(a){this.targets=[];if(a&&a.length)for(var b,c=0,d=a.length;c<d;++c){b=a[c];b instanceof OpenLayers.Layer.Vector?this.addTargetLayer(b):
this.addTarget(b)}},addTargetLayer:function(a){this.addTarget({layer:a})},addTarget:function(a){a=OpenLayers.Util.applyDefaults(a,this.defaults);a.nodeTolerance=a.nodeTolerance||a.tolerance;a.vertexTolerance=a.vertexTolerance||a.tolerance;a.edgeTolerance=a.edgeTolerance||a.tolerance;this.targets.push(a)},removeTargetLayer:function(a){for(var b,c=this.targets.length-1;c>=0;--c){b=this.targets[c];b.layer===a&&this.removeTarget(b)}},removeTarget:function(a){return OpenLayers.Util.removeItem(this.targets,
a)},activate:function(){var a=OpenLayers.Control.prototype.activate.call(this);if(a)if(this.layer&&this.layer.events)this.layer.events.on({sketchstarted:this.onSketchModified,sketchmodified:this.onSketchModified,vertexmodified:this.onVertexModified,scope:this});return a},deactivate:function(){var a=OpenLayers.Control.prototype.deactivate.call(this);a&&this.layer&&this.layer.events&&this.layer.events.un({sketchstarted:this.onSketchModified,sketchmodified:this.onSketchModified,vertexmodified:this.onVertexModified,
scope:this});this.point=this.feature=null;return a},onSketchModified:function(a){this.feature=a.feature;this.considerSnapping(a.vertex,a.vertex)},onVertexModified:function(a){this.feature=a.feature;var b=this.layer.map.getLonLatFromViewPortPx(a.pixel);this.considerSnapping(a.vertex,new OpenLayers.Geometry.Point(b.lon,b.lat))},considerSnapping:function(a,b){for(var c={rank:Number.POSITIVE_INFINITY,dist:Number.POSITIVE_INFINITY,x:null,y:null},d=false,e,f,g=0,h=this.targets.length;g<h;++g){f=this.targets[g];
if(e=this.testTarget(f,b))if(this.greedy){c=e;c.target=f;d=true;break}else if(e.rank<c.rank||e.rank===c.rank&&e.dist<c.dist){c=e;c.target=f;d=true}}if(d)if(this.events.triggerEvent("beforesnap",{point:a,x:c.x,y:c.y,distance:c.dist,layer:c.target.layer,snapType:this.precedence[c.rank]})!==false){a.x=c.x;a.y=c.y;this.point=a;this.events.triggerEvent("snap",{point:a,snapType:this.precedence[c.rank],layer:c.target.layer,distance:c.dist})}else d=false;if(this.point&&!d){a.x=b.x;a.y=b.y;this.point=null;
this.events.triggerEvent("unsnap",{point:a})}},testTarget:function(a,b){var c=this.layer.map.getResolution();if("minResolution"in a)if(c<a.minResolution)return null;if("maxResolution"in a)if(c>=a.maxResolution)return null;c={node:this.getGeoTolerance(a.nodeTolerance,c),vertex:this.getGeoTolerance(a.vertexTolerance,c),edge:this.getGeoTolerance(a.edgeTolerance,c)};for(var d=Math.max(c.node,c.vertex,c.edge),e={rank:Number.POSITIVE_INFINITY,dist:Number.POSITIVE_INFINITY},f=false,g=a.layer.features,h,
j,i,k,l,m,n=this.precedence.length,p=new OpenLayers.LonLat(b.x,b.y),r=0,t=g.length;r<t;++r){h=g[r];if(h!==this.feature&&!h._sketch&&h.state!==OpenLayers.State.DELETE&&(!a.filter||a.filter.evaluate(h)))if(h.atPoint(p,d,d))for(var s=0,v=Math.min(e.rank+1,n);s<v;++s){j=this.precedence[s];if(a[j])if(j==="edge"){i=h.geometry.distanceTo(b,{details:true});l=i.distance;if(l<=c[j]&&l<e.dist){e={rank:s,dist:l,x:i.x0,y:i.y0};f=true;break}}else{i=h.geometry.getVertices(j==="node");m=false;for(var x=0,C=i.length;x<
C;++x){k=i[x];l=k.distanceTo(b);if(l<=c[j]&&(s<e.rank||s===e.rank&&l<e.dist)){e={rank:s,dist:l,x:k.x,y:k.y};m=f=true}}if(m)break}}}return f?e:null},getGeoTolerance:function(a,b){if(b!==this.resolution){this.resolution=b;this.geoToleranceCache={}}var c=this.geoToleranceCache[a];if(c===undefined){c=a*b;this.geoToleranceCache[a]=c}return c},destroy:function(){this.active&&this.deactivate();delete this.layer;delete this.targets;OpenLayers.Control.prototype.destroy.call(this)},CLASS_NAME:"OpenLayers.Control.Snapping"});
OpenLayers.Format.OWSCommon.v1_1_0=OpenLayers.Class(OpenLayers.Format.OWSCommon.v1,{namespaces:{ows:"http://www.opengis.net/ows/1.1",xlink:"http://www.w3.org/1999/xlink"},readers:{ows:OpenLayers.Util.applyDefaults({ExceptionReport:function(a,b){b.exceptionReport={version:a.getAttribute("version"),language:a.getAttribute("xml:lang"),exceptions:[]};this.readChildNodes(a,b.exceptionReport)},AllowedValues:function(a,b){b.allowedValues={};this.readChildNodes(a,b.allowedValues)},AnyValue:function(a,b){b.anyValue=
true},DataType:function(a,b){b.dataType=this.getChildValue(a)},Range:function(a,b){b.range={};this.readChildNodes(a,b.range)},MinimumValue:function(a,b){b.minValue=this.getChildValue(a)},MaximumValue:function(a,b){b.maxValue=this.getChildValue(a)},Identifier:function(a,b){b.identifier=this.getChildValue(a)},SupportedCRS:function(a,b){b.supportedCRS=this.getChildValue(a)}},OpenLayers.Format.OWSCommon.v1.prototype.readers.ows)},writers:{ows:OpenLayers.Util.applyDefaults({Range:function(a){var b=this.createElementNSPlus("ows:Range",
{attributes:{"ows:rangeClosure":a.closure}});this.writeNode("ows:MinimumValue",a.minValue,b);this.writeNode("ows:MaximumValue",a.maxValue,b);return b},MinimumValue:function(a){return this.createElementNSPlus("ows:MinimumValue",{value:a})},MaximumValue:function(a){return this.createElementNSPlus("ows:MaximumValue",{value:a})},Value:function(a){return this.createElementNSPlus("ows:Value",{value:a})}},OpenLayers.Format.OWSCommon.v1.prototype.writers.ows)},CLASS_NAME:"OpenLayers.Format.OWSCommon.v1_1_0"});
OpenLayers.Format.WCSGetCoverage=OpenLayers.Class(OpenLayers.Format.XML,{namespaces:{ows:"http://www.opengis.net/ows/1.1",wcs:"http://www.opengis.net/wcs/1.1",xlink:"http://www.w3.org/1999/xlink",xsi:"http://www.w3.org/2001/XMLSchema-instance"},regExes:{trimSpace:/^\s*|\s*$/g,removeSpace:/\s*/g,splitSpace:/\s+/,trimComma:/\s*,\s*/g},VERSION:"1.1.2",schemaLocation:"http://www.opengis.net/wcs/1.1 http://schemas.opengis.net/wcs/1.1/wcsGetCoverage.xsd",write:function(a){a=this.writeNode("wcs:GetCoverage",
a);this.setAttributeNS(a,this.namespaces.xsi,"xsi:schemaLocation",this.schemaLocation);return OpenLayers.Format.XML.prototype.write.apply(this,[a])},writers:{wcs:{GetCoverage:function(a){var b=this.createElementNSPlus("wcs:GetCoverage",{attributes:{version:a.version||this.VERSION,service:"WCS"}});this.writeNode("ows:Identifier",a.identifier,b);this.writeNode("wcs:DomainSubset",a.domainSubset,b);this.writeNode("wcs:Output",a.output,b);return b},DomainSubset:function(a){var b=this.createElementNSPlus("wcs:DomainSubset",
{});this.writeNode("ows:BoundingBox",a.boundingBox,b);a.temporalSubset&&this.writeNode("wcs:TemporalSubset",a.temporalSubset,b);return b},TemporalSubset:function(a){for(var b=this.createElementNSPlus("wcs:TemporalSubset",{}),c=0,d=a.timePeriods.length;c<d;++c)this.writeNode("wcs:TimePeriod",a.timePeriods[c],b);return b},TimePeriod:function(a){var b=this.createElementNSPlus("wcs:TimePeriod",{});this.writeNode("wcs:BeginPosition",a.begin,b);this.writeNode("wcs:EndPosition",a.end,b);a.resolution&&this.writeNode("wcs:TimeResolution",
a.resolution,b);return b},BeginPosition:function(a){return this.createElementNSPlus("wcs:BeginPosition",{value:a})},EndPosition:function(a){return this.createElementNSPlus("wcs:EndPosition",{value:a})},TimeResolution:function(a){return this.createElementNSPlus("wcs:TimeResolution",{value:a})},Output:function(a){var b=this.createElementNSPlus("wcs:Output",{attributes:{format:a.format,store:a.store}});a.gridCRS&&this.writeNode("wcs:GridCRS",a.gridCRS,b);return b},GridCRS:function(a){var b=this.createElementNSPlus("wcs:GridCRS",
{});this.writeNode("wcs:GridBaseCRS",a.baseCRS,b);a.type&&this.writeNode("wcs:GridType",a.type,b);a.origin&&this.writeNode("wcs:GridOrigin",a.origin,b);this.writeNode("wcs:GridOffsets",a.offsets,b);a.CS&&this.writeNode("wcs:GridCS",a.CS,b);return b},GridBaseCRS:function(a){return this.createElementNSPlus("wcs:GridBaseCRS",{value:a})},GridOrigin:function(a){return this.createElementNSPlus("wcs:GridOrigin",{value:a})},GridType:function(a){return this.createElementNSPlus("wcs:GridType",{value:a})},GridOffsets:function(a){return this.createElementNSPlus("wcs:GridOffsets",
{value:a})},GridCS:function(a){return this.createElementNSPlus("wcs:GridCS",{value:a})}},ows:OpenLayers.Format.OWSCommon.v1_1_0.prototype.writers.ows},CLASS_NAME:"OpenLayers.Format.WCSGetCoverage"});
OpenLayers.Date={toISOString:function(){if("toISOString"in Date.prototype)return function(b){return b.toISOString()};else{var a=function(b,c){for(var d=b+"";d.length<c;)d="0"+d;return d};return function(b){return isNaN(b.getTime())?"Invalid Date":b.getUTCFullYear()+"-"+a(b.getUTCMonth()+1,2)+"-"+a(b.getUTCDate(),2)+"T"+a(b.getUTCHours(),2)+":"+a(b.getUTCMinutes(),2)+":"+a(b.getUTCSeconds(),2)+"."+a(b.getUTCMilliseconds(),3)+"Z"}}}(),parse:function(a){var b;if((a=a.match(/^(?:(\d{4})(?:-(\d{2})(?:-(\d{2}))?)?)?(?:T(\d{1,2}):(\d{2}):(\d{2}(?:\.\d+)?)(Z|(?:[+-]\d{1,2}(?::(\d{2}))?)))?$/))&&
(a[1]||a[7])){b=parseInt(a[1],10)||0;var c=parseInt(a[2],10)-1||0,d=parseInt(a[3],10)||1;b=new Date(Date.UTC(b,c,d));if(c=a[7]){d=parseInt(a[4],10);var e=parseInt(a[5],10),f=parseFloat(a[6]),g=f|0;b.setUTCHours(d,e,g,Math.round(1E3*(f-g)));if(c!=="Z"){c=parseInt(c,10);a=parseInt(a[8],10)||0;b=new Date(b.getTime()+-1E3*(60*c*60+a*60))}}}else b=new Date("invalid");return b}};
(function(){function a(){this._object=f&&!j?new f:new window.ActiveXObject("Microsoft.XMLHTTP");this._listeners=[]}function b(){return new a}function c(i){b.onreadystatechange&&b.onreadystatechange.apply(i);i.dispatchEvent({type:"readystatechange",bubbles:false,cancelable:false,timeStamp:new Date+0})}function d(i){try{i.responseText=i._object.responseText}catch(k){}try{var l;a:{var m=i._object,n=m.responseXML,p=m.responseText;if(h&&p&&n&&!n.documentElement&&m.getResponseHeader("Content-Type").match(/[^\/]+\/[^\+]+\+xml/)){n=
new window.ActiveXObject("Microsoft.XMLDOM");n.async=false;n.validateOnParse=false;n.loadXML(p)}if(n)if(h&&n.parseError!=0||!n.documentElement||n.documentElement&&n.documentElement.tagName=="parsererror"){l=null;break a}l=n}i.responseXML=l}catch(r){}try{i.status=i._object.status}catch(t){}try{i.statusText=i._object.statusText}catch(s){}}function e(i){i._object.onreadystatechange=new window.Function}var f=window.XMLHttpRequest,g=!!window.controllers,h=window.document.all&&!window.opera,j=h&&window.navigator.userAgent.match(/MSIE 7.0/);
b.prototype=a.prototype;if(g&&f.wrapped)b.wrapped=f.wrapped;b.UNSENT=0;b.OPENED=1;b.HEADERS_RECEIVED=2;b.LOADING=3;b.DONE=4;b.prototype.readyState=b.UNSENT;b.prototype.responseText="";b.prototype.responseXML=null;b.prototype.status=0;b.prototype.statusText="";b.prototype.priority="NORMAL";b.prototype.onreadystatechange=null;b.onreadystatechange=null;b.onopen=null;b.onsend=null;b.onabort=null;b.prototype.open=function(i,k,l,m,n){delete this._headers;if(arguments.length<3)l=true;this._async=l;var p=
this,r=this.readyState,t;if(h&&l){t=function(){if(r!=b.DONE){e(p);p.abort()}};window.attachEvent("onunload",t)}b.onopen&&b.onopen.apply(this,arguments);if(arguments.length>4)this._object.open(i,k,l,m,n);else arguments.length>3?this._object.open(i,k,l,m):this._object.open(i,k,l);this.readyState=b.OPENED;c(this);this._object.onreadystatechange=function(){if(!(g&&!l)){p.readyState=p._object.readyState;d(p);if(p._aborted)p.readyState=b.UNSENT;else{if(p.readyState==b.DONE){delete p._data;e(p);h&&l&&window.detachEvent("onunload",
t)}r!=p.readyState&&c(p);r=p.readyState}}}};b.prototype.send=function(i){b.onsend&&b.onsend.apply(this,arguments);arguments.length||(i=null);if(i&&i.nodeType){i=window.XMLSerializer?(new window.XMLSerializer).serializeToString(i):i.xml;oRequest._headers["Content-Type"]||oRequest._object.setRequestHeader("Content-Type","application/xml")}this._data=i;this._object.send(this._data);if(g&&!this._async){this.readyState=b.OPENED;for(d(this);this.readyState<b.DONE;){this.readyState++;c(this);if(this._aborted)break}}};
b.prototype.abort=function(){b.onabort&&b.onabort.apply(this,arguments);if(this.readyState>b.UNSENT)this._aborted=true;this._object.abort();e(this);this.readyState=b.UNSENT;delete this._data};b.prototype.getAllResponseHeaders=function(){return this._object.getAllResponseHeaders()};b.prototype.getResponseHeader=function(i){return this._object.getResponseHeader(i)};b.prototype.setRequestHeader=function(i,k){if(!this._headers)this._headers={};this._headers[i]=k;return this._object.setRequestHeader(i,
k)};b.prototype.addEventListener=function(i,k,l){for(var m=0,n;n=this._listeners[m];m++)if(n[0]==i&&n[1]==k&&n[2]==l)return;this._listeners.push([i,k,l])};b.prototype.removeEventListener=function(i,k,l){for(var m=0,n;n=this._listeners[m];m++)if(n[0]==i&&n[1]==k&&n[2]==l)break;n&&this._listeners.splice(m,1)};b.prototype.dispatchEvent=function(i){i={type:i.type,target:this,currentTarget:this,eventPhase:2,bubbles:i.bubbles,cancelable:i.cancelable,timeStamp:i.timeStamp,stopPropagation:function(){},preventDefault:function(){},
initEvent:function(){}};if(i.type=="readystatechange"&&this.onreadystatechange)(this.onreadystatechange.handleEvent||this.onreadystatechange).apply(this,[i]);for(var k=0,l;l=this._listeners[k];k++)if(l[0]==i.type&&!l[2])(l[1].handleEvent||l[1]).apply(this,[i])};b.prototype.toString=function(){return"[object XMLHttpRequest]"};b.toString=function(){return"[XMLHttpRequest]"};if(!window.Function.prototype.apply)window.Function.prototype.apply=function(i,k){k||(k=[]);i.__func=this;i.__func(k[0],k[1],k[2],
k[3],k[4]);delete i.__func};OpenLayers.Request.XMLHttpRequest=b})();
OpenLayers.Format.KML=OpenLayers.Class(OpenLayers.Format.XML,{namespaces:{kml:"http://www.opengis.net/kml/2.2",gx:"http://www.google.com/kml/ext/2.2"},kmlns:"http://earth.google.com/kml/2.0",placemarksDesc:"No description available",foldersName:"OpenLayers export",foldersDesc:"Exported on "+new Date,extractAttributes:true,extractStyles:false,extractTracks:false,trackAttributes:null,internalns:null,features:null,styles:null,styleBaseUrl:"",fetched:null,maxDepth:0,initialize:function(a){this.regExes=
{trimSpace:/^\s*|\s*$/g,removeSpace:/\s*/g,splitSpace:/\s+/,trimComma:/\s*,\s*/g,kmlColor:/(\w{2})(\w{2})(\w{2})(\w{2})/,kmlIconPalette:/root:\/\/icons\/palette-(\d+)(\.\w+)/,straightBracket:/\$\[(.*?)\]/g};this.externalProjection=new OpenLayers.Projection("EPSG:4326");OpenLayers.Format.XML.prototype.initialize.apply(this,[a])},read:function(a){this.features=[];this.styles={};this.fetched={};return this.parseData(a,{depth:0,styleBaseUrl:this.styleBaseUrl})},parseData:function(a,b){if(typeof a=="string")a=
OpenLayers.Format.XML.prototype.read.apply(this,[a]);for(var c=["Link","NetworkLink","Style","StyleMap","Placemark"],d=0,e=c.length;d<e;++d){var f=c[d],g=this.getElementsByTagNameNS(a,"*",f);if(g.length!=0)switch(f.toLowerCase()){case "link":case "networklink":this.parseLinks(g,b);break;case "style":this.extractStyles&&this.parseStyles(g,b);break;case "stylemap":this.extractStyles&&this.parseStyleMaps(g,b);break;case "placemark":this.parseFeatures(g,b)}}return this.features},parseLinks:function(a,
b){if(b.depth>=this.maxDepth)return false;var c=OpenLayers.Util.extend({},b);c.depth++;for(var d=0,e=a.length;d<e;d++){var f=this.parseProperty(a[d],"*","href");if(f&&!this.fetched[f]){this.fetched[f]=true;(f=this.fetchLink(f))&&this.parseData(f,c)}}},fetchLink:function(a){if(a=OpenLayers.Request.GET({url:a,async:false}))return a.responseText},parseStyles:function(a,b){for(var c=0,d=a.length;c<d;c++){var e=this.parseStyle(a[c]);if(e)this.styles[(b.styleBaseUrl||"")+"#"+e.id]=e}},parseKmlColor:function(a){var b=
null;if(a)if(a=a.match(this.regExes.kmlColor))b={color:"#"+a[4]+a[3]+a[2],opacity:parseInt(a[1],16)/255};return b},parseStyle:function(a){for(var b={},c=["LineStyle","PolyStyle","IconStyle","BalloonStyle","LabelStyle"],d,e,f=0,g=c.length;f<g;++f){d=c[f];if(e=this.getElementsByTagNameNS(a,"*",d)[0])switch(d.toLowerCase()){case "linestyle":d=this.parseProperty(e,"*","color");if(d=this.parseKmlColor(d)){b.strokeColor=d.color;b.strokeOpacity=d.opacity}if(d=this.parseProperty(e,"*","width"))b.strokeWidth=
d;break;case "polystyle":d=this.parseProperty(e,"*","color");if(d=this.parseKmlColor(d)){b.fillOpacity=d.opacity;b.fillColor=d.color}if(this.parseProperty(e,"*","fill")=="0")b.fillColor="none";if(this.parseProperty(e,"*","outline")=="0")b.strokeWidth="0";break;case "iconstyle":var h=parseFloat(this.parseProperty(e,"*","scale")||1);d=32*h;var j=32*h,i=this.getElementsByTagNameNS(e,"*","Icon")[0];if(i){var k=this.parseProperty(i,"*","href");if(k){var l=this.parseProperty(i,"*","w"),m=this.parseProperty(i,
"*","h");if(OpenLayers.String.startsWith(k,"http://maps.google.com/mapfiles/kml")&&!l&&!m){m=l=64;h/=2}l=l||m;m=m||l;if(l)d=parseInt(l)*h;if(m)j=parseInt(m)*h;if(m=k.match(this.regExes.kmlIconPalette)){l=m[1];m=m[2];k=this.parseProperty(i,"*","x");i=this.parseProperty(i,"*","y");k="http://maps.google.com/mapfiles/kml/pal"+l+"/icon"+((i?7-i/32:7)*8+(k?k/32:0))+m}b.graphicOpacity=1;b.externalGraphic=k}}if(e=this.getElementsByTagNameNS(e,"*","hotSpot")[0]){k=parseFloat(e.getAttribute("x"));i=parseFloat(e.getAttribute("y"));
l=e.getAttribute("xunits");if(l=="pixels")b.graphicXOffset=-k*h;else if(l=="insetPixels")b.graphicXOffset=-d+k*h;else if(l=="fraction")b.graphicXOffset=-d*k;e=e.getAttribute("yunits");if(e=="pixels")b.graphicYOffset=-j+i*h+1;else if(e=="insetPixels")b.graphicYOffset=-(i*h)+1;else if(e=="fraction")b.graphicYOffset=-j*(1-i)+1}b.graphicWidth=d;b.graphicHeight=j;break;case "balloonstyle":if(e=OpenLayers.Util.getXmlNodeValue(e))b.balloonStyle=e.replace(this.regExes.straightBracket,"${$1}");break;case "labelstyle":d=
this.parseProperty(e,"*","color");if(d=this.parseKmlColor(d)){b.fontColor=d.color;b.fontOpacity=d.opacity}}}if(!b.strokeColor&&b.fillColor)b.strokeColor=b.fillColor;if((a=a.getAttribute("id"))&&b)b.id=a;return b},parseStyleMaps:function(a,b){for(var c=0,d=a.length;c<d;c++){var e=a[c],f=this.getElementsByTagNameNS(e,"*","Pair");e=e.getAttribute("id");for(var g=0,h=f.length;g<h;g++){var j=f[g],i=this.parseProperty(j,"*","key");if((j=this.parseProperty(j,"*","styleUrl"))&&i=="normal")this.styles[(b.styleBaseUrl||
"")+"#"+e]=this.styles[(b.styleBaseUrl||"")+j]}}},parseFeatures:function(a,b){for(var c=[],d=0,e=a.length;d<e;d++){var f=a[d],g=this.parseFeature.apply(this,[f]);if(g){if(this.extractStyles&&g.attributes&&g.attributes.styleUrl)g.style=this.getStyle(g.attributes.styleUrl,b);if(this.extractStyles){var h=this.getElementsByTagNameNS(f,"*","Style")[0];if(h)if(h=this.parseStyle(h))g.style=OpenLayers.Util.extend(g.style,h)}if(this.extractTracks){if((f=this.getElementsByTagNameNS(f,this.namespaces.gx,"Track"))&&
f.length>0){g={features:[],feature:g};this.readNode(f[0],g);g.features.length>0&&c.push.apply(c,g.features)}}else c.push(g)}else throw"Bad Placemark: "+d;}this.features=this.features.concat(c)},readers:{kml:{when:function(a,b){b.whens.push(OpenLayers.Date.parse(this.getChildValue(a)))},_trackPointAttribute:function(a,b){var c=a.nodeName.split(":").pop();b.attributes[c].push(this.getChildValue(a))}},gx:{Track:function(a,b){var c={whens:[],points:[],angles:[]};if(this.trackAttributes){var d;c.attributes=
{};for(var e=0,f=this.trackAttributes.length;e<f;++e){d=this.trackAttributes[e];c.attributes[d]=[];if(!(d in this.readers.kml))this.readers.kml[d]=this.readers.kml._trackPointAttribute}}this.readChildNodes(a,c);if(c.whens.length!==c.points.length)throw Error("gx:Track with unequal number of when ("+c.whens.length+") and gx:coord ("+c.points.length+") elements.");var g=c.angles.length>0;if(g&&c.whens.length!==c.angles.length)throw Error("gx:Track with unequal number of when ("+c.whens.length+") and gx:angles ("+
c.angles.length+") elements.");var h,j;e=0;for(f=c.whens.length;e<f;++e){h=b.feature.clone();h.fid=b.feature.fid||b.feature.id;j=c.points[e];h.geometry=j;if("z"in j)h.attributes.altitude=j.z;this.internalProjection&&this.externalProjection&&h.geometry.transform(this.externalProjection,this.internalProjection);if(this.trackAttributes){j=0;for(var i=this.trackAttributes.length;j<i;++j)h.attributes[d]=c.attributes[this.trackAttributes[j]][e]}h.attributes.when=c.whens[e];h.attributes.trackId=b.feature.id;
if(g){j=c.angles[e];h.attributes.heading=parseFloat(j[0]);h.attributes.tilt=parseFloat(j[1]);h.attributes.roll=parseFloat(j[2])}b.features.push(h)}},coord:function(a,b){var c=this.getChildValue(a).replace(this.regExes.trimSpace,"").split(/\s+/),d=new OpenLayers.Geometry.Point(c[0],c[1]);if(c.length>2)d.z=parseFloat(c[2]);b.points.push(d)},angles:function(a,b){var c=this.getChildValue(a).replace(this.regExes.trimSpace,"").split(/\s+/);b.angles.push(c)}}},parseFeature:function(a){for(var b=["MultiGeometry",
"Polygon","LineString","Point"],c,d,e,f=0,g=b.length;f<g;++f){c=b[f];this.internalns=a.namespaceURI?a.namespaceURI:this.kmlns;d=this.getElementsByTagNameNS(a,this.internalns,c);if(d.length>0){if(b=this.parseGeometry[c.toLowerCase()]){e=b.apply(this,[d[0]]);this.internalProjection&&this.externalProjection&&e.transform(this.externalProjection,this.internalProjection)}else OpenLayers.Console.error(OpenLayers.i18n("unsupportedGeometryType",{geomType:c}));break}}var h;if(this.extractAttributes)h=this.parseAttributes(a);
c=new OpenLayers.Feature.Vector(e,h);a=a.getAttribute("id")||a.getAttribute("name");if(a!=null)c.fid=a;return c},getStyle:function(a,b){var c=OpenLayers.Util.removeTail(a),d=OpenLayers.Util.extend({},b);d.depth++;d.styleBaseUrl=c;if(!this.styles[a]&&!OpenLayers.String.startsWith(a,"#")&&d.depth<=this.maxDepth&&!this.fetched[c])(c=this.fetchLink(c))&&this.parseData(c,d);return OpenLayers.Util.extend({},this.styles[a])},parseGeometry:{point:function(a){var b=this.getElementsByTagNameNS(a,this.internalns,
"coordinates");a=[];if(b.length>0){var c=b[0].firstChild.nodeValue;c=c.replace(this.regExes.removeSpace,"");a=c.split(",")}b=null;if(a.length>1){if(a.length==2)a[2]=null;b=new OpenLayers.Geometry.Point(a[0],a[1],a[2])}else throw"Bad coordinate string: "+c;return b},linestring:function(a,b){var c=this.getElementsByTagNameNS(a,this.internalns,"coordinates"),d=null;if(c.length>0){c=this.getChildValue(c[0]);c=c.replace(this.regExes.trimSpace,"");c=c.replace(this.regExes.trimComma,",");d=c.split(this.regExes.splitSpace);
for(var e=d.length,f=Array(e),g,h,j=0;j<e;++j){g=d[j].split(",");h=g.length;if(h>1){if(g.length==2)g[2]=null;f[j]=new OpenLayers.Geometry.Point(g[0],g[1],g[2])}else throw"Bad LineString point coordinates: "+d[j];}if(e)d=b?new OpenLayers.Geometry.LinearRing(f):new OpenLayers.Geometry.LineString(f);else throw"Bad LineString coordinates: "+c;}return d},polygon:function(a){a=this.getElementsByTagNameNS(a,this.internalns,"LinearRing");var b=a.length,c=Array(b);if(b>0)for(var d=0,e=a.length;d<e;++d)if(b=
this.parseGeometry.linestring.apply(this,[a[d],true]))c[d]=b;else throw"Bad LinearRing geometry: "+d;return new OpenLayers.Geometry.Polygon(c)},multigeometry:function(a){for(var b,c=[],d=a.childNodes,e=0,f=d.length;e<f;++e){a=d[e];if(a.nodeType==1)(b=this.parseGeometry[(a.prefix?a.nodeName.split(":")[1]:a.nodeName).toLowerCase()])&&c.push(b.apply(this,[a]))}return new OpenLayers.Geometry.Collection(c)}},parseAttributes:function(a){var b={},c=a.getElementsByTagName("ExtendedData");if(c.length)b=this.parseExtendedData(c[0]);
var d,e,f;a=a.childNodes;c=0;for(var g=a.length;c<g;++c){d=a[c];if(d.nodeType==1){e=d.childNodes;if(e.length>=1&&e.length<=3){switch(e.length){case 1:f=e[0];break;case 2:f=e[0];e=e[1];f=f.nodeType==3||f.nodeType==4?f:e;break;default:f=e[1]}if(f.nodeType==3||f.nodeType==4){d=d.prefix?d.nodeName.split(":")[1]:d.nodeName;if(f=OpenLayers.Util.getXmlNodeValue(f)){f=f.replace(this.regExes.trimSpace,"");b[d]=f}}}}}return b},parseExtendedData:function(a){var b={},c,d,e,f,g=a.getElementsByTagName("Data");
c=0;for(d=g.length;c<d;c++){e=g[c];f=e.getAttribute("name");var h={},j=e.getElementsByTagName("value");if(j.length)h.value=this.getChildValue(j[0]);e=e.getElementsByTagName("displayName");if(e.length)h.displayName=this.getChildValue(e[0]);b[f]=h}a=a.getElementsByTagName("SimpleData");c=0;for(d=a.length;c<d;c++){h={};e=a[c];f=e.getAttribute("name");h.value=this.getChildValue(e);h.displayName=f;b[f]=h}return b},parseProperty:function(a,b,c){var d;a=this.getElementsByTagNameNS(a,b,c);try{d=OpenLayers.Util.getXmlNodeValue(a[0])}catch(e){d=
null}return d},write:function(a){OpenLayers.Util.isArray(a)||(a=[a]);for(var b=this.createElementNS(this.kmlns,"kml"),c=this.createFolderXML(),d=0,e=a.length;d<e;++d)c.appendChild(this.createPlacemarkXML(a[d]));b.appendChild(c);return OpenLayers.Format.XML.prototype.write.apply(this,[b])},createFolderXML:function(){var a=this.createElementNS(this.kmlns,"Folder");if(this.foldersName){var b=this.createElementNS(this.kmlns,"name"),c=this.createTextNode(this.foldersName);b.appendChild(c);a.appendChild(b)}if(this.foldersDesc){b=
this.createElementNS(this.kmlns,"description");c=this.createTextNode(this.foldersDesc);b.appendChild(c);a.appendChild(b)}return a},createPlacemarkXML:function(a){var b=this.createElementNS(this.kmlns,"name");b.appendChild(this.createTextNode(a.style&&a.style.label?a.style.label:a.attributes.name||a.id));var c=this.createElementNS(this.kmlns,"description");c.appendChild(this.createTextNode(a.attributes.description||this.placemarksDesc));var d=this.createElementNS(this.kmlns,"Placemark");a.fid!=null&&
d.setAttribute("id",a.fid);d.appendChild(b);d.appendChild(c);a=this.buildGeometryNode(a.geometry);d.appendChild(a);return d},buildGeometryNode:function(a){var b=a.CLASS_NAME;b=this.buildGeometry[b.substring(b.lastIndexOf(".")+1).toLowerCase()];var c=null;if(b)c=b.apply(this,[a]);return c},buildGeometry:{point:function(a){var b=this.createElementNS(this.kmlns,"Point");b.appendChild(this.buildCoordinatesNode(a));return b},multipoint:function(a){return this.buildGeometry.collection.apply(this,[a])},
linestring:function(a){var b=this.createElementNS(this.kmlns,"LineString");b.appendChild(this.buildCoordinatesNode(a));return b},multilinestring:function(a){return this.buildGeometry.collection.apply(this,[a])},linearring:function(a){var b=this.createElementNS(this.kmlns,"LinearRing");b.appendChild(this.buildCoordinatesNode(a));return b},polygon:function(a){var b=this.createElementNS(this.kmlns,"Polygon");a=a.components;for(var c,d,e=0,f=a.length;e<f;++e){c=e==0?"outerBoundaryIs":"innerBoundaryIs";
c=this.createElementNS(this.kmlns,c);d=this.buildGeometry.linearring.apply(this,[a[e]]);c.appendChild(d);b.appendChild(c)}return b},multipolygon:function(a){return this.buildGeometry.collection.apply(this,[a])},collection:function(a){for(var b=this.createElementNS(this.kmlns,"MultiGeometry"),c,d=0,e=a.components.length;d<e;++d)(c=this.buildGeometryNode.apply(this,[a.components[d]]))&&b.appendChild(c);return b}},buildCoordinatesNode:function(a){var b=this.createElementNS(this.kmlns,"coordinates"),
c;if(c=a.components){for(var d=c.length,e=Array(d),f=0;f<d;++f){a=c[f];e[f]=this.buildCoordinates(a)}c=e.join(" ")}else c=this.buildCoordinates(a);c=this.createTextNode(c);b.appendChild(c);return b},buildCoordinates:function(a){if(this.internalProjection&&this.externalProjection){a=a.clone();a.transform(this.internalProjection,this.externalProjection)}return a.x+","+a.y},CLASS_NAME:"OpenLayers.Format.KML"});
OpenLayers.Popup=OpenLayers.Class({events:null,id:"",lonlat:null,div:null,contentSize:null,size:null,contentHTML:null,backgroundColor:"",opacity:"",border:"",contentDiv:null,groupDiv:null,closeDiv:null,autoSize:false,minSize:null,maxSize:null,displayClass:"olPopup",contentDisplayClass:"olPopupContent",padding:0,disableFirefoxOverflowHack:false,fixPadding:function(){if(typeof this.padding=="number")this.padding=new OpenLayers.Bounds(this.padding,this.padding,this.padding,this.padding)},panMapIfOutOfView:false,
keepInMap:false,closeOnMove:false,map:null,initialize:function(a,b,c,d,e,f){if(a==null)a=OpenLayers.Util.createUniqueID(this.CLASS_NAME+"_");this.id=a;this.lonlat=b;this.contentSize=c!=null?c:new OpenLayers.Size(OpenLayers.Popup.WIDTH,OpenLayers.Popup.HEIGHT);if(d!=null)this.contentHTML=d;this.backgroundColor=OpenLayers.Popup.COLOR;this.opacity=OpenLayers.Popup.OPACITY;this.border=OpenLayers.Popup.BORDER;this.div=OpenLayers.Util.createDiv(this.id,null,null,null,null,null,"hidden");this.div.className=
this.displayClass;this.groupDiv=OpenLayers.Util.createDiv(this.id+"_GroupDiv",null,null,null,"relative",null,"hidden");a=this.div.id+"_contentDiv";this.contentDiv=OpenLayers.Util.createDiv(a,null,this.contentSize.clone(),null,"relative");this.contentDiv.className=this.contentDisplayClass;this.groupDiv.appendChild(this.contentDiv);this.div.appendChild(this.groupDiv);e&&this.addCloseBox(f);this.registerEvents()},destroy:function(){this.border=this.opacity=this.backgroundColor=this.contentHTML=this.size=
this.lonlat=this.id=null;this.closeOnMove&&this.map&&this.map.events.unregister("movestart",this,this.hide);this.events.destroy();this.events=null;if(this.closeDiv){OpenLayers.Event.stopObservingElement(this.closeDiv);this.groupDiv.removeChild(this.closeDiv)}this.closeDiv=null;this.div.removeChild(this.groupDiv);this.groupDiv=null;this.map!=null&&this.map.removePopup(this);this.panMapIfOutOfView=this.padding=this.maxSize=this.minSize=this.autoSize=this.div=this.map=null},draw:function(a){if(a==null)if(this.lonlat!=
null&&this.map!=null)a=this.map.getLayerPxFromLonLat(this.lonlat);this.closeOnMove&&this.map.events.register("movestart",this,this.hide);if(!this.disableFirefoxOverflowHack&&OpenLayers.BROWSER_NAME=="firefox"){this.map.events.register("movestart",this,function(){var b=document.defaultView.getComputedStyle(this.contentDiv,null).getPropertyValue("overflow");if(b!="hidden"){this.contentDiv._oldOverflow=b;this.contentDiv.style.overflow="hidden"}});this.map.events.register("moveend",this,function(){var b=
this.contentDiv._oldOverflow;if(b){this.contentDiv.style.overflow=b;this.contentDiv._oldOverflow=null}})}this.moveTo(a);!this.autoSize&&!this.size&&this.setSize(this.contentSize);this.setBackgroundColor();this.setOpacity();this.setBorder();this.setContentHTML();this.panMapIfOutOfView&&this.panIntoView();return this.div},updatePosition:function(){if(this.lonlat&&this.map){var a=this.map.getLayerPxFromLonLat(this.lonlat);a&&this.moveTo(a)}},moveTo:function(a){if(a!=null&&this.div!=null){this.div.style.left=
a.x+"px";this.div.style.top=a.y+"px"}},visible:function(){return OpenLayers.Element.visible(this.div)},toggle:function(){this.visible()?this.hide():this.show()},show:function(){this.div.style.display="";this.panMapIfOutOfView&&this.panIntoView()},hide:function(){this.div.style.display="none"},setSize:function(a){this.size=a.clone();var b=this.getContentDivPadding(),c=b.left+b.right,d=b.top+b.bottom;this.fixPadding();c+=this.padding.left+this.padding.right;d+=this.padding.top+this.padding.bottom;if(this.closeDiv){var e=
parseInt(this.closeDiv.style.width);c+=e+b.right}this.size.w+=c;this.size.h+=d;if(OpenLayers.BROWSER_NAME=="msie"){this.contentSize.w+=b.left+b.right;this.contentSize.h+=b.bottom+b.top}if(this.div!=null){this.div.style.width=this.size.w+"px";this.div.style.height=this.size.h+"px"}if(this.contentDiv!=null){this.contentDiv.style.width=a.w+"px";this.contentDiv.style.height=a.h+"px"}},updateSize:function(){var a="<div class='"+this.contentDisplayClass+"'>"+this.contentDiv.innerHTML+"</div>",b=this.map?
this.map.layerContainerDiv:document.body,c=OpenLayers.Util.getRenderedDimensions(a,null,{displayClass:this.displayClass,containerElement:b}),d=this.getSafeContentSize(c),e=null;if(d.equals(c))e=c;else{e=new OpenLayers.Size;e.w=d.w<c.w?d.w:null;e.h=d.h<c.h?d.h:null;if(e.w&&e.h)e=d;else{a=OpenLayers.Util.getRenderedDimensions(a,e,{displayClass:this.contentDisplayClass,containerElement:b});if(OpenLayers.Element.getStyle(this.contentDiv,"overflow")!="hidden"&&a.equals(d)){d=OpenLayers.Util.getScrollbarWidth();
if(e.w)a.h+=d;else a.w+=d}e=this.getSafeContentSize(a)}}this.setSize(e)},setBackgroundColor:function(a){if(a!=undefined)this.backgroundColor=a;if(this.div!=null)this.div.style.backgroundColor=this.backgroundColor},setOpacity:function(a){if(a!=undefined)this.opacity=a;if(this.div!=null){this.div.style.opacity=this.opacity;this.div.style.filter="alpha(opacity="+this.opacity*100+")"}},setBorder:function(a){if(a!=undefined)this.border=a;if(this.div!=null)this.div.style.border=this.border},setContentHTML:function(a){if(a!=
null)this.contentHTML=a;if(this.contentDiv!=null&&this.contentHTML!=null&&this.contentHTML!=this.contentDiv.innerHTML){this.contentDiv.innerHTML=this.contentHTML;if(this.autoSize){this.registerImageListeners();this.updateSize()}}},registerImageListeners:function(){for(var a=function(){this.popup.updateSize();this.popup.visible()&&this.popup.panMapIfOutOfView&&this.popup.panIntoView();OpenLayers.Event.stopObserving(this.img,"load",this.img._onImageLoad)},b=this.contentDiv.getElementsByTagName("img"),
c=0,d=b.length;c<d;c++){var e=b[c];if(e.width==0||e.height==0){e._onImgLoad=OpenLayers.Function.bind(a,{popup:this,img:e});OpenLayers.Event.observe(e,"load",e._onImgLoad)}}},getSafeContentSize:function(a){a=a.clone();var b=this.getContentDivPadding(),c=b.left+b.right,d=b.top+b.bottom;this.fixPadding();c+=this.padding.left+this.padding.right;d+=this.padding.top+this.padding.bottom;if(this.closeDiv){var e=parseInt(this.closeDiv.style.width);c+=e+b.right}if(this.minSize){a.w=Math.max(a.w,this.minSize.w-
c);a.h=Math.max(a.h,this.minSize.h-d)}if(this.maxSize){a.w=Math.min(a.w,this.maxSize.w-c);a.h=Math.min(a.h,this.maxSize.h-d)}if(this.map&&this.map.size){e=b=0;if(this.keepInMap&&!this.panMapIfOutOfView){e=this.map.getPixelFromLonLat(this.lonlat);switch(this.relativePosition){case "tr":b=e.x;e=this.map.size.h-e.y;break;case "tl":b=this.map.size.w-e.x;e=this.map.size.h-e.y;break;case "bl":b=this.map.size.w-e.x;e=e.y;break;case "br":b=e.x;e=e.y;break;default:b=e.x;e=this.map.size.h-e.y}}d=this.map.size.h-
this.map.paddingForPopups.top-this.map.paddingForPopups.bottom-d-e;a.w=Math.min(a.w,this.map.size.w-this.map.paddingForPopups.left-this.map.paddingForPopups.right-c-b);a.h=Math.min(a.h,d)}return a},getContentDivPadding:function(){var a=this._contentDivPadding;if(!a){if(this.div.parentNode==null){this.div.style.display="none";document.body.appendChild(this.div)}this._contentDivPadding=a=new OpenLayers.Bounds(OpenLayers.Element.getStyle(this.contentDiv,"padding-left"),OpenLayers.Element.getStyle(this.contentDiv,
"padding-bottom"),OpenLayers.Element.getStyle(this.contentDiv,"padding-right"),OpenLayers.Element.getStyle(this.contentDiv,"padding-top"));if(this.div.parentNode==document.body){document.body.removeChild(this.div);this.div.style.display=""}}return a},addCloseBox:function(a){this.closeDiv=OpenLayers.Util.createDiv(this.id+"_close",null,new OpenLayers.Size(17,17));this.closeDiv.className="olPopupCloseBox";var b=this.getContentDivPadding();this.closeDiv.style.right=b.right+"px";this.closeDiv.style.top=
b.top+"px";this.groupDiv.appendChild(this.closeDiv);a=a||function(c){this.hide();OpenLayers.Event.stop(c)};OpenLayers.Event.observe(this.closeDiv,"touchend",OpenLayers.Function.bindAsEventListener(a,this));OpenLayers.Event.observe(this.closeDiv,"click",OpenLayers.Function.bindAsEventListener(a,this))},panIntoView:function(){var a=this.map.getSize(),b=this.map.getViewPortPxFromLayerPx(new OpenLayers.Pixel(parseInt(this.div.style.left),parseInt(this.div.style.top))),c=b.clone();if(b.x<this.map.paddingForPopups.left)c.x=
this.map.paddingForPopups.left;else if(b.x+this.size.w>a.w-this.map.paddingForPopups.right)c.x=a.w-this.map.paddingForPopups.right-this.size.w;if(b.y<this.map.paddingForPopups.top)c.y=this.map.paddingForPopups.top;else if(b.y+this.size.h>a.h-this.map.paddingForPopups.bottom)c.y=a.h-this.map.paddingForPopups.bottom-this.size.h;this.map.pan(b.x-c.x,b.y-c.y)},registerEvents:function(){this.events=new OpenLayers.Events(this,this.div,null,true);this.events.on({mousedown:this.onmousedown,mousemove:this.onmousemove,
mouseup:this.onmouseup,click:this.onclick,mouseout:this.onmouseout,dblclick:this.ondblclick,touchstart:function(a){OpenLayers.Event.stop(a,true)},scope:this})},onmousedown:function(a){this.mousedown=true;OpenLayers.Event.stop(a,true)},onmousemove:function(a){this.mousedown&&OpenLayers.Event.stop(a,true)},onmouseup:function(a){if(this.mousedown){this.mousedown=false;OpenLayers.Event.stop(a,true)}},onclick:function(a){OpenLayers.Event.stop(a,true)},onmouseout:function(){this.mousedown=false},ondblclick:function(a){OpenLayers.Event.stop(a,
true)},CLASS_NAME:"OpenLayers.Popup"});OpenLayers.Popup.WIDTH=200;OpenLayers.Popup.HEIGHT=200;OpenLayers.Popup.COLOR="white";OpenLayers.Popup.OPACITY=1;OpenLayers.Popup.BORDER="0px";
OpenLayers.Popup.Anchored=OpenLayers.Class(OpenLayers.Popup,{relativePosition:null,keepInMap:true,anchor:null,initialize:function(a,b,c,d,e,f,g){OpenLayers.Popup.prototype.initialize.apply(this,[a,b,c,d,f,g]);this.anchor=e!=null?e:{size:new OpenLayers.Size(0,0),offset:new OpenLayers.Pixel(0,0)}},destroy:function(){this.relativePosition=this.anchor=null;OpenLayers.Popup.prototype.destroy.apply(this,arguments)},show:function(){this.updatePosition();OpenLayers.Popup.prototype.show.apply(this,arguments)},
moveTo:function(a){var b=this.relativePosition;this.relativePosition=this.calculateRelativePosition(a);a=this.calculateNewPx(a);OpenLayers.Popup.prototype.moveTo.apply(this,Array(a));this.relativePosition!=b&&this.updateRelativePosition()},setSize:function(){OpenLayers.Popup.prototype.setSize.apply(this,arguments);this.lonlat&&this.map&&this.moveTo(this.map.getLayerPxFromLonLat(this.lonlat))},calculateRelativePosition:function(a){a=this.map.getLonLatFromLayerPx(a);a=this.map.getExtent().determineQuadrant(a);
return OpenLayers.Bounds.oppositeQuadrant(a)},updateRelativePosition:function(){},calculateNewPx:function(a){a=a.offset(this.anchor.offset);var b=this.size||this.contentSize,c=this.relativePosition.charAt(0)=="t";a.y+=c?-b.h:this.anchor.size.h;c=this.relativePosition.charAt(1)=="l";a.x+=c?-b.w:this.anchor.size.w;return a},CLASS_NAME:"OpenLayers.Popup.Anchored"});OpenLayers.Rico=OpenLayers.Rico||{};
OpenLayers.Rico.Color=OpenLayers.Class({initialize:function(a,b,c){this.rgb={r:a,g:b,b:c}},setRed:function(a){this.rgb.r=a},setGreen:function(a){this.rgb.g=a},setBlue:function(a){this.rgb.b=a},setHue:function(a){var b=this.asHSB();b.h=a;this.rgb=OpenLayers.Rico.Color.HSBtoRGB(b.h,b.s,b.b)},setSaturation:function(a){var b=this.asHSB();b.s=a;this.rgb=OpenLayers.Rico.Color.HSBtoRGB(b.h,b.s,b.b)},setBrightness:function(a){var b=this.asHSB();b.b=a;this.rgb=OpenLayers.Rico.Color.HSBtoRGB(b.h,b.s,b.b)},
darken:function(a){var b=this.asHSB();this.rgb=OpenLayers.Rico.Color.HSBtoRGB(b.h,b.s,Math.max(b.b-a,0))},brighten:function(a){var b=this.asHSB();this.rgb=OpenLayers.Rico.Color.HSBtoRGB(b.h,b.s,Math.min(b.b+a,1))},blend:function(a){this.rgb.r=Math.floor((this.rgb.r+a.rgb.r)/2);this.rgb.g=Math.floor((this.rgb.g+a.rgb.g)/2);this.rgb.b=Math.floor((this.rgb.b+a.rgb.b)/2)},isBright:function(){this.asHSB();return this.asHSB().b>0.5},isDark:function(){return!this.isBright()},asRGB:function(){return"rgb("+
this.rgb.r+","+this.rgb.g+","+this.rgb.b+")"},asHex:function(){return"#"+this.rgb.r.toColorPart()+this.rgb.g.toColorPart()+this.rgb.b.toColorPart()},asHSB:function(){return OpenLayers.Rico.Color.RGBtoHSB(this.rgb.r,this.rgb.g,this.rgb.b)},toString:function(){return this.asHex()}});
OpenLayers.Rico.Color.createFromHex=function(a){if(a.length==4){var b=a;a="#";for(var c=1;c<4;c++)a+=b.charAt(c)+b.charAt(c)}if(a.indexOf("#")==0)a=a.substring(1);b=a.substring(0,2);c=a.substring(2,4);a=a.substring(4,6);return new OpenLayers.Rico.Color(parseInt(b,16),parseInt(c,16),parseInt(a,16))};
OpenLayers.Rico.Color.createColorFromBackground=function(a){var b=OpenLayers.Element.getStyle(OpenLayers.Util.getElement(a),"backgroundColor");if(b=="transparent"&&a.parentNode)return OpenLayers.Rico.Color.createColorFromBackground(a.parentNode);if(b==null)return new OpenLayers.Rico.Color(255,255,255);if(b.indexOf("rgb(")==0){a=b.substring(4,b.length-1).split(",");return new OpenLayers.Rico.Color(parseInt(a[0]),parseInt(a[1]),parseInt(a[2]))}else return b.indexOf("#")==0?OpenLayers.Rico.Color.createFromHex(b):
new OpenLayers.Rico.Color(255,255,255)};
OpenLayers.Rico.Color.HSBtoRGB=function(a,b,c){var d=0,e=0,f=0;if(b==0)f=e=d=parseInt(c*255+0.5);else{a=(a-Math.floor(a))*6;var g=a-Math.floor(a),h=c*(1-b),j=c*(1-b*g);b=c*(1-b*(1-g));switch(parseInt(a)){case 0:d=c*255+0.5;e=b*255+0.5;f=h*255+0.5;break;case 1:d=j*255+0.5;e=c*255+0.5;f=h*255+0.5;break;case 2:d=h*255+0.5;e=c*255+0.5;f=b*255+0.5;break;case 3:d=h*255+0.5;e=j*255+0.5;f=c*255+0.5;break;case 4:d=b*255+0.5;e=h*255+0.5;f=c*255+0.5;break;case 5:d=c*255+0.5;e=h*255+0.5;f=j*255+0.5}}return{r:parseInt(d),
g:parseInt(e),b:parseInt(f)}};OpenLayers.Rico.Color.RGBtoHSB=function(a,b,c){var d,e=a>b?a:b;if(c>e)e=c;var f=a<b?a:b;if(c<f)f=c;d=e!=0?(e-f)/e:0;if(d==0)a=0;else{var g=(e-a)/(e-f),h=(e-b)/(e-f);c=(e-c)/(e-f);a=a==e?c-h:b==e?2+g-c:4+h-g;a/=6;if(a<0)a+=1}return{h:a,s:d,b:e/255}};OpenLayers.Rico=OpenLayers.Rico||{};
OpenLayers.Rico.Corner={round:function(a,b){a=OpenLayers.Util.getElement(a);this._setOptions(b);var c=this.options.color;if(this.options.color=="fromElement")c=this._background(a);var d=this.options.bgColor;if(this.options.bgColor=="fromParent")d=this._background(a.offsetParent);this._roundCornersImpl(a,c,d)},changeColor:function(a,b){a.style.backgroundColor=b;for(var c=a.parentNode.getElementsByTagName("span"),d=0;d<c.length;d++)c[d].style.backgroundColor=b},changeOpacity:function(a,b){var c="alpha(opacity="+
b*100+")";a.style.opacity=b;a.style.filter=c;for(var d=a.parentNode.getElementsByTagName("span"),e=0;e<d.length;e++){d[e].style.opacity=b;d[e].style.filter=c}},reRound:function(a,b){var c=a.parentNode.childNodes[2];a.parentNode.removeChild(a.parentNode.childNodes[0]);a.parentNode.removeChild(c);this.round(a.parentNode,b)},_roundCornersImpl:function(a,b,c){this.options.border&&this._renderBorder(a,c);this._isTopRounded()&&this._roundTopCorners(a,b,c);this._isBottomRounded()&&this._roundBottomCorners(a,
b,c)},_renderBorder:function(a,b){var c="1px solid "+this._borderColor(b);a.innerHTML="<div "+("style='"+("border-left: "+c)+";"+("border-right: "+c)+"'")+">"+a.innerHTML+"</div>"},_roundTopCorners:function(a,b,c){for(var d=this._createCorner(c),e=0;e<this.options.numSlices;e++)d.appendChild(this._createCornerSlice(b,c,e,"top"));a.style.paddingTop=0;a.insertBefore(d,a.firstChild)},_roundBottomCorners:function(a,b,c){for(var d=this._createCorner(c),e=this.options.numSlices-1;e>=0;e--)d.appendChild(this._createCornerSlice(b,
c,e,"bottom"));a.style.paddingBottom=0;a.appendChild(d)},_createCorner:function(a){var b=document.createElement("div");b.style.backgroundColor=this._isTransparent()?"transparent":a;return b},_createCornerSlice:function(a,b,c,d){var e=document.createElement("span"),f=e.style;f.backgroundColor=a;f.display="block";f.height="1px";f.overflow="hidden";f.fontSize="1px";a=this._borderColor(a,b);if(this.options.border&&c==0){f.borderTopStyle="solid";f.borderTopWidth="1px";f.borderLeftWidth="0px";f.borderRightWidth=
"0px";f.borderBottomWidth="0px";f.height="0px";f.borderColor=a}else if(a){f.borderColor=a;f.borderStyle="solid";f.borderWidth="0px 1px"}if(!this.options.compact&&c==this.options.numSlices-1)f.height="2px";this._setMargin(e,c,d);this._setBorder(e,c,d);return e},_setOptions:function(a){this.options={corners:"all",color:"fromElement",bgColor:"fromParent",blend:true,border:false,compact:false};OpenLayers.Util.extend(this.options,a||{});this.options.numSlices=this.options.compact?2:4;if(this._isTransparent())this.options.blend=
false},_whichSideTop:function(){if(this._hasString(this.options.corners,"all","top"))return"";if(this.options.corners.indexOf("tl")>=0&&this.options.corners.indexOf("tr")>=0)return"";if(this.options.corners.indexOf("tl")>=0)return"left";else if(this.options.corners.indexOf("tr")>=0)return"right";return""},_whichSideBottom:function(){if(this._hasString(this.options.corners,"all","bottom"))return"";if(this.options.corners.indexOf("bl")>=0&&this.options.corners.indexOf("br")>=0)return"";if(this.options.corners.indexOf("bl")>=
0)return"left";else if(this.options.corners.indexOf("br")>=0)return"right";return""},_borderColor:function(a,b){return a=="transparent"?b:this.options.border?this.options.border:this.options.blend?this._blend(b,a):""},_setMargin:function(a,b,c){b=this._marginSize(b);c=c=="top"?this._whichSideTop():this._whichSideBottom();if(c=="left"){a.style.marginLeft=b+"px";a.style.marginRight="0px"}else if(c=="right"){a.style.marginRight=b+"px";a.style.marginLeft="0px"}else{a.style.marginLeft=b+"px";a.style.marginRight=
b+"px"}},_setBorder:function(a,b,c){b=this._borderSize(b);c=c=="top"?this._whichSideTop():this._whichSideBottom();if(c=="left"){a.style.borderLeftWidth=b+"px";a.style.borderRightWidth="0px"}else if(c=="right"){a.style.borderRightWidth=b+"px";a.style.borderLeftWidth="0px"}else{a.style.borderLeftWidth=b+"px";a.style.borderRightWidth=b+"px"}if(this.options.border!=false){a.style.borderLeftWidth=b+"px";a.style.borderRightWidth=b+"px"}},_marginSize:function(a){if(this._isTransparent())return 0;var b=[5,
3,2,1],c=[3,2,1,0],d=[2,1],e=[1,0];return this.options.compact&&this.options.blend?e[a]:this.options.compact?d[a]:this.options.blend?c[a]:b[a]},_borderSize:function(a){var b=[5,3,2,1],c=[2,1,1,1],d=[1,0],e=[0,2,0,0];if(this.options.compact&&(this.options.blend||this._isTransparent()))return 1;else if(this.options.compact)return d[a];else if(this.options.blend)return c[a];else if(this.options.border)return e[a];else if(this._isTransparent())return b[a];return 0},_hasString:function(a){for(var b=1;b<
arguments.length;b++)if(a.indexOf(arguments[b])>=0)return true;return false},_blend:function(a,b){var c=OpenLayers.Rico.Color.createFromHex(a);c.blend(OpenLayers.Rico.Color.createFromHex(b));return c},_background:function(a){try{return OpenLayers.Rico.Color.createColorFromBackground(a).asHex()}catch(b){return"#ffffff"}},_isTransparent:function(){return this.options.color=="transparent"},_isTopRounded:function(){return this._hasString(this.options.corners,"all","top","tl","tr")},_isBottomRounded:function(){return this._hasString(this.options.corners,
"all","bottom","bl","br")},_hasSingleTextChild:function(a){return a.childNodes.length==1&&a.childNodes[0].nodeType==3}};
OpenLayers.Popup.AnchoredBubble=OpenLayers.Class(OpenLayers.Popup.Anchored,{rounded:false,initialize:function(){this.padding=new OpenLayers.Bounds(0,OpenLayers.Popup.AnchoredBubble.CORNER_SIZE,0,OpenLayers.Popup.AnchoredBubble.CORNER_SIZE);OpenLayers.Popup.Anchored.prototype.initialize.apply(this,arguments)},draw:function(){OpenLayers.Popup.Anchored.prototype.draw.apply(this,arguments);this.setContentHTML();this.setBackgroundColor();this.setOpacity();return this.div},updateRelativePosition:function(){this.setRicoCorners()},
setSize:function(){OpenLayers.Popup.Anchored.prototype.setSize.apply(this,arguments);this.setRicoCorners()},setBackgroundColor:function(a){if(a!=undefined)this.backgroundColor=a;if(this.div!=null)if(this.contentDiv!=null){this.div.style.background="transparent";OpenLayers.Rico.Corner.changeColor(this.groupDiv,this.backgroundColor)}},setOpacity:function(a){OpenLayers.Popup.Anchored.prototype.setOpacity.call(this,a);this.div!=null&&this.groupDiv!=null&&OpenLayers.Rico.Corner.changeOpacity(this.groupDiv,
this.opacity)},setBorder:function(){this.border=0},setRicoCorners:function(){var a={corners:this.getCornersToRound(this.relativePosition),color:this.backgroundColor,bgColor:"transparent",blend:false};if(this.rounded){OpenLayers.Rico.Corner.reRound(this.groupDiv,a);this.setBackgroundColor();this.setOpacity()}else{OpenLayers.Rico.Corner.round(this.div,a);this.rounded=true}},getCornersToRound:function(){var a=["tl","tr","bl","br"],b=OpenLayers.Bounds.oppositeQuadrant(this.relativePosition);OpenLayers.Util.removeItem(a,
b);return a.join(" ")},CLASS_NAME:"OpenLayers.Popup.AnchoredBubble"});OpenLayers.Popup.AnchoredBubble.CORNER_SIZE=5;
OpenLayers.Protocol.WFS.v1=OpenLayers.Class(OpenLayers.Protocol,{version:null,srsName:"EPSG:4326",featureType:null,featureNS:null,geometryName:"the_geom",schema:null,featurePrefix:"feature",formatOptions:null,readFormat:null,readOptions:null,initialize:function(a){OpenLayers.Protocol.prototype.initialize.apply(this,[a]);if(!a.format)this.format=OpenLayers.Format.WFST(OpenLayers.Util.extend({version:this.version,featureType:this.featureType,featureNS:this.featureNS,featurePrefix:this.featurePrefix,
geometryName:this.geometryName,srsName:this.srsName,schema:this.schema},this.formatOptions));!a.geometryName&&parseFloat(this.format.version)>1&&this.setGeometryName(null)},destroy:function(){this.options&&!this.options.format&&this.format.destroy();this.format=null;OpenLayers.Protocol.prototype.destroy.apply(this)},read:function(a){OpenLayers.Protocol.prototype.read.apply(this,arguments);a=OpenLayers.Util.extend({},a);OpenLayers.Util.applyDefaults(a,this.options||{});var b=new OpenLayers.Protocol.Response({requestType:"read"}),
c=OpenLayers.Format.XML.prototype.write.apply(this.format,[this.format.writeNode("wfs:GetFeature",a)]);b.priv=OpenLayers.Request.POST({url:a.url,callback:this.createCallback(this.handleRead,b,a),params:a.params,headers:a.headers,data:c});return b},setFeatureType:function(a){this.featureType=a;this.format.featureType=a},setGeometryName:function(a){this.geometryName=a;this.format.geometryName=a},handleRead:function(a,b){b=OpenLayers.Util.extend({},b);OpenLayers.Util.applyDefaults(b,this.options);if(b.callback){var c=
a.priv;if(c.status>=200&&c.status<300)if((c=this.parseResponse(c,b.readOptions))&&c.success!==false){if(b.readOptions&&b.readOptions.output=="object")OpenLayers.Util.extend(a,c);else a.features=c;a.code=OpenLayers.Protocol.Response.SUCCESS}else{a.code=OpenLayers.Protocol.Response.FAILURE;a.error=c}else a.code=OpenLayers.Protocol.Response.FAILURE;b.callback.call(b.scope,a)}},parseResponse:function(a,b){var c=a.responseXML;if(!c||!c.documentElement)c=a.responseText;if(!c||c.length<=0)return null;c=
this.readFormat!==null?this.readFormat.read(c):this.format.read(c,b);if(!this.featureNS){var d=this.readFormat||this.format;this.featureNS=d.featureNS;d.autoConfig=false;this.geometryName||this.setGeometryName(d.geometryName)}return c},commit:function(a,b){b=OpenLayers.Util.extend({},b);OpenLayers.Util.applyDefaults(b,this.options);var c=new OpenLayers.Protocol.Response({requestType:"commit",reqFeatures:a});c.priv=OpenLayers.Request.POST({url:b.url,headers:b.headers,data:this.format.write(a,b),callback:this.createCallback(this.handleCommit,
c,b)});return c},handleCommit:function(a,b){if(b.callback){var c=a.priv,d=c.responseXML;if(!d||!d.documentElement)d=c.responseText;c=this.format.read(d)||{};a.insertIds=c.insertIds||[];if(c.success)a.code=OpenLayers.Protocol.Response.SUCCESS;else{a.code=OpenLayers.Protocol.Response.FAILURE;a.error=c}b.callback.call(b.scope,a)}},filterDelete:function(a,b){b=OpenLayers.Util.extend({},b);OpenLayers.Util.applyDefaults(b,this.options);new OpenLayers.Protocol.Response({requestType:"commit"});var c=this.format.createElementNSPlus("wfs:Transaction",
{attributes:{service:"WFS",version:this.version}}),d=this.format.createElementNSPlus("wfs:Delete",{attributes:{typeName:(b.featureNS?this.featurePrefix+":":"")+b.featureType}});b.featureNS&&d.setAttribute("xmlns:"+this.featurePrefix,b.featureNS);var e=this.format.writeNode("ogc:Filter",a);d.appendChild(e);c.appendChild(d);c=OpenLayers.Format.XML.prototype.write.apply(this.format,[c]);return OpenLayers.Request.POST({url:this.url,callback:b.callback||function(){},data:c})},abort:function(a){a&&a.priv.abort()},
CLASS_NAME:"OpenLayers.Protocol.WFS.v1"});
OpenLayers.Handler.Point=OpenLayers.Class(OpenLayers.Handler,{point:null,layer:null,multi:false,mouseDown:false,stoppedDown:null,lastDown:null,lastUp:null,persist:false,stopDown:false,stopUp:false,layerOptions:null,pixelTolerance:5,touch:false,lastTouchPx:null,initialize:function(a,b,c){if(!(c&&c.layerOptions&&c.layerOptions.styleMap))this.style=OpenLayers.Util.extend(OpenLayers.Feature.Vector.style["default"],{});OpenLayers.Handler.prototype.initialize.apply(this,arguments)},activate:function(){if(!OpenLayers.Handler.prototype.activate.apply(this,
arguments))return false;var a=OpenLayers.Util.extend({displayInLayerSwitcher:false,calculateInRange:OpenLayers.Function.True},this.layerOptions);this.layer=new OpenLayers.Layer.Vector(this.CLASS_NAME,a);this.map.addLayer(this.layer);return true},createFeature:function(a){a=this.map.getLonLatFromPixel(a);a=new OpenLayers.Geometry.Point(a.lon,a.lat);this.point=new OpenLayers.Feature.Vector(a);this.callback("create",[this.point.geometry,this.point]);this.point.geometry.clearBounds();this.layer.addFeatures([this.point],
{silent:true})},deactivate:function(){if(!OpenLayers.Handler.prototype.deactivate.apply(this,arguments))return false;this.cancel();if(this.layer.map!=null){this.destroyFeature(true);this.layer.destroy(false)}this.layer=null;this.touch=false;return true},destroyFeature:function(a){if(this.layer&&(a||!this.persist))this.layer.destroyFeatures();this.point=null},destroyPersistedFeature:function(){var a=this.layer;a&&a.features.length>1&&this.layer.features[0].destroy()},finalize:function(a){this.mouseDown=
false;this.lastTouchPx=this.lastUp=this.lastDown=null;this.callback(a?"cancel":"done",[this.geometryClone()]);this.destroyFeature(a)},cancel:function(){this.finalize(true)},click:function(a){OpenLayers.Event.stop(a);return false},dblclick:function(a){OpenLayers.Event.stop(a);return false},modifyFeature:function(a){this.point||this.createFeature(a);a=this.map.getLonLatFromPixel(a);this.point.geometry.x=a.lon;this.point.geometry.y=a.lat;this.callback("modify",[this.point.geometry,this.point,false]);
this.point.geometry.clearBounds();this.drawFeature()},drawFeature:function(){this.layer.drawFeature(this.point,this.style)},getGeometry:function(){var a=this.point&&this.point.geometry;if(a&&this.multi)a=new OpenLayers.Geometry.MultiPoint([a]);return a},geometryClone:function(){var a=this.getGeometry();return a&&a.clone()},mousedown:function(a){return this.down(a)},touchstart:function(a){if(!this.touch){this.touch=true;this.map.events.un({mousedown:this.mousedown,mouseup:this.mouseup,mousemove:this.mousemove,
click:this.click,dblclick:this.dblclick,scope:this})}this.lastTouchPx=a.xy;return this.down(a)},mousemove:function(a){return this.move(a)},touchmove:function(a){this.lastTouchPx=a.xy;return this.move(a)},mouseup:function(a){return this.up(a)},touchend:function(a){a.xy=this.lastTouchPx;return this.up(a)},down:function(a){this.mouseDown=true;this.lastDown=a.xy;this.touch||this.modifyFeature(a.xy);this.stoppedDown=this.stopDown;return!this.stopDown},move:function(a){if(!this.touch&&(!this.mouseDown||
this.stoppedDown))this.modifyFeature(a.xy);return true},up:function(a){this.mouseDown=false;this.stoppedDown=this.stopDown;if(!this.checkModifiers(a))return true;if(this.lastUp&&this.lastUp.equals(a.xy))return true;if(this.lastDown&&this.passesTolerance(this.lastDown,a.xy,this.pixelTolerance)){this.touch&&this.modifyFeature(a.xy);this.persist&&this.destroyPersistedFeature();this.lastUp=a.xy;this.finalize();return!this.stopUp}else return true},mouseout:function(a){if(OpenLayers.Util.mouseLeft(a,this.map.eventsDiv)){this.stoppedDown=
this.stopDown;this.mouseDown=false}},passesTolerance:function(a,b,c){var d=true;if(c!=null&&a&&b)if(a.distanceTo(b)>c)d=false;return d},CLASS_NAME:"OpenLayers.Handler.Point"});
OpenLayers.Handler.Path=OpenLayers.Class(OpenLayers.Handler.Point,{line:null,maxVertices:null,doubleTouchTolerance:20,freehand:false,freehandToggle:"shiftKey",timerId:null,redoStack:null,initialize:function(){OpenLayers.Handler.Point.prototype.initialize.apply(this,arguments)},createFeature:function(a){a=this.map.getLonLatFromPixel(a);a=new OpenLayers.Geometry.Point(a.lon,a.lat);this.point=new OpenLayers.Feature.Vector(a);this.line=new OpenLayers.Feature.Vector(new OpenLayers.Geometry.LineString([this.point.geometry]));
this.callback("create",[this.point.geometry,this.getSketch()]);this.point.geometry.clearBounds();this.layer.addFeatures([this.line,this.point],{silent:true})},destroyFeature:function(a){OpenLayers.Handler.Point.prototype.destroyFeature.call(this,a);this.line=null},destroyPersistedFeature:function(){var a=this.layer;a&&a.features.length>2&&this.layer.features[0].destroy()},removePoint:function(){this.point&&this.layer.removeFeatures([this.point])},addPoint:function(a){this.layer.removeFeatures([this.point]);
a=this.control.map.getLonLatFromPixel(a);this.point=new OpenLayers.Feature.Vector(new OpenLayers.Geometry.Point(a.lon,a.lat));this.line.geometry.addComponent(this.point.geometry,this.line.geometry.components.length);this.layer.addFeatures([this.point]);this.callback("point",[this.point.geometry,this.getGeometry()]);this.callback("modify",[this.point.geometry,this.getSketch()]);this.drawFeature();delete this.redoStack},insertXY:function(a,b){this.line.geometry.addComponent(new OpenLayers.Geometry.Point(a,
b),this.getCurrentPointIndex());this.drawFeature();delete this.redoStack},insertDeltaXY:function(a,b){var c=this.line.geometry.components[this.getCurrentPointIndex()-1];c&&!isNaN(c.x)&&!isNaN(c.y)&&this.insertXY(c.x+a,c.y+b)},insertDirectionLength:function(a,b){a*=Math.PI/180;this.insertDeltaXY(b*Math.cos(a),b*Math.sin(a))},insertDeflectionLength:function(a,b){var c=this.getCurrentPointIndex()-1;if(c>0){var d=this.line.geometry.components[c];c=this.line.geometry.components[c-1];this.insertDirectionLength(Math.atan2(d.y-
c.y,d.x-c.x)*180/Math.PI+a,b)}},getCurrentPointIndex:function(){return this.line.geometry.components.length-1},undo:function(){var a=this.line.geometry,b=a.components,c=this.getCurrentPointIndex()-1;b=b[c];if(a=a.removeComponent(b)){if(!this.redoStack)this.redoStack=[];this.redoStack.push(b);this.drawFeature()}return a},redo:function(){var a=this.redoStack&&this.redoStack.pop();if(a){this.line.geometry.addComponent(a,this.getCurrentPointIndex());this.drawFeature()}return!!a},freehandMode:function(a){return this.freehandToggle&&
a[this.freehandToggle]?!this.freehand:this.freehand},modifyFeature:function(a,b){this.line||this.createFeature(a);var c=this.control.map.getLonLatFromPixel(a);this.point.geometry.x=c.lon;this.point.geometry.y=c.lat;this.callback("modify",[this.point.geometry,this.getSketch(),b]);this.point.geometry.clearBounds();this.drawFeature()},drawFeature:function(){this.layer.drawFeature(this.line,this.style);this.layer.drawFeature(this.point,this.style)},getSketch:function(){return this.line},getGeometry:function(){var a=
this.line&&this.line.geometry;if(a&&this.multi)a=new OpenLayers.Geometry.MultiLineString([a]);return a},touchstart:function(a){if(this.timerId&&this.passesTolerance(this.lastTouchPx,a.xy,this.doubleTouchTolerance)){this.finishGeometry();window.clearTimeout(this.timerId);this.timerId=null;return false}else{if(this.timerId){window.clearTimeout(this.timerId);this.timerId=null}this.timerId=window.setTimeout(OpenLayers.Function.bind(function(){this.timerId=null},this),300);return OpenLayers.Handler.Point.prototype.touchstart.call(this,
a)}},down:function(a){var b=this.stopDown;if(this.freehandMode(a)){b=true;if(this.touch){this.modifyFeature(a.xy,!!this.lastUp);OpenLayers.Event.stop(a)}}if(!this.touch&&(!this.lastDown||!this.passesTolerance(this.lastDown,a.xy,this.pixelTolerance)))this.modifyFeature(a.xy,!!this.lastUp);this.mouseDown=true;this.lastDown=a.xy;this.stoppedDown=b;return!b},move:function(a){if(this.stoppedDown&&this.freehandMode(a)){this.persist&&this.destroyPersistedFeature();this.addPoint(a.xy);return false}if(!this.touch&&
(!this.mouseDown||this.stoppedDown))this.modifyFeature(a.xy,!!this.lastUp);return true},up:function(a){if(this.mouseDown&&(!this.lastUp||!this.lastUp.equals(a.xy)))if(this.stoppedDown&&this.freehandMode(a)){this.persist&&this.destroyPersistedFeature();this.removePoint();this.finalize()}else if(this.passesTolerance(this.lastDown,a.xy,this.pixelTolerance)){this.touch&&this.modifyFeature(a.xy);this.lastUp==null&&this.persist&&this.destroyPersistedFeature();this.addPoint(a.xy);this.lastUp=a.xy;this.line.geometry.components.length===
this.maxVertices+1&&this.finishGeometry()}this.stoppedDown=this.stopDown;this.mouseDown=false;return!this.stopUp},finishGeometry:function(){this.line.geometry.removeComponent(this.line.geometry.components[this.line.geometry.components.length-1]);this.removePoint();this.finalize()},dblclick:function(a){this.freehandMode(a)||this.finishGeometry();return false},CLASS_NAME:"OpenLayers.Handler.Path"});
OpenLayers.Filter.Spatial=OpenLayers.Class(OpenLayers.Filter,{type:null,property:null,value:null,distance:null,distanceUnits:null,initialize:function(a){OpenLayers.Filter.prototype.initialize.apply(this,[a])},evaluate:function(a){var b=false;switch(this.type){case OpenLayers.Filter.Spatial.BBOX:case OpenLayers.Filter.Spatial.INTERSECTS:if(a.geometry){var c=this.value;if(this.value.CLASS_NAME=="OpenLayers.Bounds")c=this.value.toGeometry();if(a.geometry.intersects(c))b=true}break;default:OpenLayers.Console.error(OpenLayers.i18n("filterEvaluateNotImplemented"))}return b},
clone:function(){var a=OpenLayers.Util.applyDefaults({value:this.value&&this.value.clone&&this.value.clone()},this);return new OpenLayers.Filter.Spatial(a)},CLASS_NAME:"OpenLayers.Filter.Spatial"});OpenLayers.Filter.Spatial.BBOX="BBOX";OpenLayers.Filter.Spatial.INTERSECTS="INTERSECTS";OpenLayers.Filter.Spatial.DWITHIN="DWITHIN";OpenLayers.Filter.Spatial.WITHIN="WITHIN";OpenLayers.Filter.Spatial.CONTAINS="CONTAINS";
OpenLayers.Layer.GML=OpenLayers.Class(OpenLayers.Layer.Vector,{loaded:false,format:null,formatOptions:null,initialize:function(a,b,c){var d=[];d.push(a,c);OpenLayers.Layer.Vector.prototype.initialize.apply(this,d);this.url=b},setVisibility:function(){OpenLayers.Layer.Vector.prototype.setVisibility.apply(this,arguments);this.visibility&&!this.loaded&&this.loadGML()},moveTo:function(){OpenLayers.Layer.Vector.prototype.moveTo.apply(this,arguments);this.visibility&&!this.loaded&&this.loadGML()},loadGML:function(){if(!this.loaded){this.events.triggerEvent("loadstart");
OpenLayers.Request.GET({url:this.url,success:this.requestSuccess,failure:this.requestFailure,scope:this});this.loaded=true}},setUrl:function(a){this.url=a;this.destroyFeatures();this.loaded=false;this.loadGML()},requestSuccess:function(a){var b=a.responseXML;if(!b||!b.documentElement)b=a.responseText;a={};OpenLayers.Util.extend(a,this.formatOptions);if(this.map&&!this.projection.equals(this.map.getProjectionObject())){a.externalProjection=this.projection;a.internalProjection=this.map.getProjectionObject()}this.addFeatures((this.format?
new this.format(a):new OpenLayers.Format.GML(a)).read(b));this.events.triggerEvent("loadend")},requestFailure:function(){OpenLayers.Console.userError(OpenLayers.i18n("errorLoadingGML",{url:this.url}));this.events.triggerEvent("loadend")},CLASS_NAME:"OpenLayers.Layer.GML"});
OpenLayers.Tile.WFS=OpenLayers.Class(OpenLayers.Tile,{features:null,url:null,request:null,initialize:function(a,b,c,d){OpenLayers.Tile.prototype.initialize.apply(this,arguments);this.url=d;this.features=[]},destroy:function(){OpenLayers.Tile.prototype.destroy.apply(this,arguments);this.destroyAllFeatures();this.url=this.features=null;if(this.request){this.request.abort();this.request=null}},clear:function(){this.destroyAllFeatures()},draw:function(){if(OpenLayers.Tile.prototype.draw.apply(this,arguments)){if(this.isLoading)this.events.triggerEvent("reload");
else{this.isLoading=true;this.events.triggerEvent("loadstart")}this.loadFeaturesForRegion(this.requestSuccess)}},loadFeaturesForRegion:function(a,b){this.request&&this.request.abort();this.request=OpenLayers.Request.GET({url:this.url,success:a,failure:b,scope:this})},requestSuccess:function(a){if(this.features){var b=a.responseXML;if(!b||!b.documentElement)b=a.responseText;if(this.layer.vectorMode)this.layer.addFeatures(this.layer.formatObject.read(b));else{a=new OpenLayers.Format.XML;if(typeof b==
"string")b=a.read(b);this.addResults(a.getElementsByTagNameNS(b,"http://www.opengis.net/gml","featureMember"))}}this.events&&this.events.triggerEvent("loadend");this.request=null},addResults:function(a){for(var b=0;b<a.length;b++)this.features.push(new this.layer.featureClass(this.layer,a[b]))},destroyAllFeatures:function(){for(;this.features.length>0;)this.features.shift().destroy()},CLASS_NAME:"OpenLayers.Tile.WFS"});
OpenLayers.Format.Context=OpenLayers.Class(OpenLayers.Format.XML.VersionedOGC,{layerOptions:null,layerParams:null,read:function(a,b){var c=OpenLayers.Format.XML.VersionedOGC.prototype.read.apply(this,arguments);if(b&&b.map){this.context=c;if(b.map instanceof OpenLayers.Map)c=this.mergeContextToMap(c,b.map);else{var d=b.map;if(OpenLayers.Util.isElement(d)||typeof d=="string")d={div:d};c=this.contextToMap(c,d)}}return c},getLayerFromContext:function(a){var b,c,d={queryable:a.queryable,visibility:a.visibility,
maxExtent:a.maxExtent,metadata:OpenLayers.Util.applyDefaults(a.metadata,{styles:a.styles,formats:a.formats,"abstract":a["abstract"],dataURL:a.dataURL}),numZoomLevels:a.numZoomLevels,units:a.units,isBaseLayer:a.isBaseLayer,opacity:a.opacity,displayInLayerSwitcher:a.displayInLayerSwitcher,singleTile:a.singleTile,tileSize:a.tileSize?new OpenLayers.Size(a.tileSize.width,a.tileSize.height):undefined,minScale:a.minScale||a.maxScaleDenominator,maxScale:a.maxScale||a.minScaleDenominator,srs:a.srs,dimensions:a.dimensions,
metadataURL:a.metadataURL};this.layerOptions&&OpenLayers.Util.applyDefaults(d,this.layerOptions);var e={layers:a.name,transparent:a.transparent,version:a.version};if(a.formats&&a.formats.length>0){e.format=a.formats[0].value;b=0;for(c=a.formats.length;b<c;b++){var f=a.formats[b];if(f.current==true){e.format=f.value;break}}}if(a.styles&&a.styles.length>0){b=0;for(c=a.styles.length;b<c;b++){f=a.styles[b];if(f.current==true){if(f.href)e.sld=f.href;else if(f.body)e.sld_body=f.body;else e.styles=f.name;
break}}}this.layerParams&&OpenLayers.Util.applyDefaults(e,this.layerParams);b=null;c=a.service;if(c==OpenLayers.Format.Context.serviceTypes.WFS){d.strategies=[new OpenLayers.Strategy.BBOX];d.protocol=new OpenLayers.Protocol.WFS({url:a.url,featurePrefix:a.name.split(":")[0],featureType:a.name.split(":").pop()});b=new OpenLayers.Layer.Vector(a.title||a.name,d)}else if(c==OpenLayers.Format.Context.serviceTypes.KML){d.strategies=[new OpenLayers.Strategy.Fixed];d.protocol=new OpenLayers.Protocol.HTTP({url:a.url,
format:new OpenLayers.Format.KML});b=new OpenLayers.Layer.Vector(a.title||a.name,d)}else if(c==OpenLayers.Format.Context.serviceTypes.GML){d.strategies=[new OpenLayers.Strategy.Fixed];d.protocol=new OpenLayers.Protocol.HTTP({url:a.url,format:new OpenLayers.Format.GML});b=new OpenLayers.Layer.Vector(a.title||a.name,d)}else if(a.features){b=new OpenLayers.Layer.Vector(a.title||a.name,d);b.addFeatures(a.features)}else if(a.categoryLayer!==true)b=new OpenLayers.Layer.WMS(a.title||a.name,a.url,e,d);return b},
getLayersFromContext:function(a){for(var b=[],c=0,d=a.length;c<d;c++){var e=this.getLayerFromContext(a[c]);e!==null&&b.push(e)}return b},contextToMap:function(a,b){b=OpenLayers.Util.applyDefaults({maxExtent:a.maxExtent,projection:a.projection,units:a.units},b);if(b.maxExtent)b.maxResolution=b.maxExtent.getWidth()/OpenLayers.Map.TILE_WIDTH;b.metadata={contactInformation:a.contactInformation,"abstract":a["abstract"],keywords:a.keywords,logo:a.logo,descriptionURL:a.descriptionURL};var c=new OpenLayers.Map(b);
c.addLayers(this.getLayersFromContext(a.layersContext));c.setCenter(a.bounds.getCenterLonLat(),c.getZoomForExtent(a.bounds,true));return c},mergeContextToMap:function(a,b){b.addLayers(this.getLayersFromContext(a.layersContext));return b},write:function(a){a=this.toContext(a);return OpenLayers.Format.XML.VersionedOGC.prototype.write.apply(this,arguments)},CLASS_NAME:"OpenLayers.Format.Context"});
OpenLayers.Format.Context.serviceTypes={WMS:"urn:ogc:serviceType:WMS",WFS:"urn:ogc:serviceType:WFS",WCS:"urn:ogc:serviceType:WCS",GML:"urn:ogc:serviceType:GML",SLD:"urn:ogc:serviceType:SLD",FES:"urn:ogc:serviceType:FES",KML:"urn:ogc:serviceType:KML"};
OpenLayers.Format.WMC=OpenLayers.Class(OpenLayers.Format.Context,{defaultVersion:"1.1.0",layerToContext:function(a){var b=this.getParser(),c={queryable:a.queryable,visibility:a.visibility,name:a.params.LAYERS,title:a.name,"abstract":a.metadata["abstract"],dataURL:a.metadata.dataURL,metadataURL:a.metadataURL,server:{version:a.params.VERSION,url:a.url},maxExtent:a.maxExtent,transparent:a.params.TRANSPARENT,numZoomLevels:a.numZoomLevels,units:a.units,isBaseLayer:a.isBaseLayer,opacity:a.opacity==1?undefined:
a.opacity,displayInLayerSwitcher:a.displayInLayerSwitcher,singleTile:a.singleTile,tileSize:a.singleTile||!a.tileSize?undefined:{width:a.tileSize.w,height:a.tileSize.h},minScale:a.options.resolutions||a.options.scales||a.options.maxResolution||a.options.minScale?a.minScale:undefined,maxScale:a.options.resolutions||a.options.scales||a.options.minResolution||a.options.maxScale?a.maxScale:undefined,formats:[],styles:[],srs:a.srs,dimensions:a.dimensions};if(a.metadata.servertitle)c.server.title=a.metadata.servertitle;
if(a.metadata.formats&&a.metadata.formats.length>0)for(var d=0,e=a.metadata.formats.length;d<e;d++){var f=a.metadata.formats[d];c.formats.push({value:f.value,current:f.value==a.params.FORMAT})}else c.formats.push({value:a.params.FORMAT,current:true});if(a.metadata.styles&&a.metadata.styles.length>0){d=0;for(e=a.metadata.styles.length;d<e;d++){b=a.metadata.styles[d];b.current=b.href==a.params.SLD||b.body==a.params.SLD_BODY||b.name==a.params.STYLES?true:false;c.styles.push(b)}}else c.styles.push({href:a.params.SLD,
body:a.params.SLD_BODY,name:a.params.STYLES||b.defaultStyleName,title:b.defaultStyleTitle,current:true});return c},toContext:function(a){var b={},c=a.layers;if(a.CLASS_NAME=="OpenLayers.Map"){var d=a.metadata||{};b.size=a.getSize();b.bounds=a.getExtent();b.projection=a.projection;b.title=a.title;b.keywords=d.keywords;b["abstract"]=d["abstract"];b.logo=d.logo;b.descriptionURL=d.descriptionURL;b.contactInformation=d.contactInformation;b.maxExtent=a.maxExtent}else{OpenLayers.Util.applyDefaults(b,a);
b.layers!=undefined&&delete b.layers}if(b.layersContext==undefined)b.layersContext=[];if(c!=undefined&&OpenLayers.Util.isArray(c)){a=0;for(d=c.length;a<d;a++){var e=c[a];e instanceof OpenLayers.Layer.WMS&&b.layersContext.push(this.layerToContext(e))}}return b},CLASS_NAME:"OpenLayers.Format.WMC"});
OpenLayers.Format.WMC.v1=OpenLayers.Class(OpenLayers.Format.XML,{namespaces:{ol:"http://openlayers.org/context",wmc:"http://www.opengis.net/context",sld:"http://www.opengis.net/sld",xlink:"http://www.w3.org/1999/xlink",xsi:"http://www.w3.org/2001/XMLSchema-instance"},schemaLocation:"",getNamespacePrefix:function(a){var b=null;if(a==null)b=this.namespaces[this.defaultPrefix];else for(b in this.namespaces)if(this.namespaces[b]==a)break;return b},defaultPrefix:"wmc",rootPrefix:null,defaultStyleName:"",
defaultStyleTitle:"Default",initialize:function(a){OpenLayers.Format.XML.prototype.initialize.apply(this,[a])},read:function(a){if(typeof a=="string")a=OpenLayers.Format.XML.prototype.read.apply(this,[a]);a=a.documentElement;this.rootPrefix=a.prefix;var b={version:a.getAttribute("version")};this.runChildNodes(b,a);return b},runChildNodes:function(a,b){for(var c=b.childNodes,d,e,f,g=0,h=c.length;g<h;++g){d=c[g];if(d.nodeType==1){e=this.getNamespacePrefix(d.namespaceURI);f=d.nodeName.split(":").pop();
(e=this["read_"+e+"_"+f])&&e.apply(this,[a,d])}}},read_wmc_General:function(a,b){this.runChildNodes(a,b)},read_wmc_BoundingBox:function(a,b){a.projection=b.getAttribute("SRS");a.bounds=new OpenLayers.Bounds(parseFloat(b.getAttribute("minx")),parseFloat(b.getAttribute("miny")),parseFloat(b.getAttribute("maxx")),parseFloat(b.getAttribute("maxy")))},read_wmc_LayerList:function(a,b){a.layersContext=[];this.runChildNodes(a,b)},read_wmc_Layer:function(a,b){var c={visibility:b.getAttribute("hidden")!="1",
queryable:b.getAttribute("queryable")=="1",formats:[],styles:[],metadata:{}};this.runChildNodes(c,b);a.layersContext.push(c)},read_wmc_Extension:function(a,b){this.runChildNodes(a,b)},read_ol_units:function(a,b){a.units=this.getChildValue(b)},read_ol_maxExtent:function(a,b){var c=new OpenLayers.Bounds(b.getAttribute("minx"),b.getAttribute("miny"),b.getAttribute("maxx"),b.getAttribute("maxy"));a.maxExtent=c},read_ol_transparent:function(a,b){a.transparent=this.getChildValue(b)},read_ol_numZoomLevels:function(a,
b){a.numZoomLevels=parseInt(this.getChildValue(b))},read_ol_opacity:function(a,b){a.opacity=parseFloat(this.getChildValue(b))},read_ol_singleTile:function(a,b){a.singleTile=this.getChildValue(b)=="true"},read_ol_tileSize:function(a,b){var c={width:b.getAttribute("width"),height:b.getAttribute("height")};a.tileSize=c},read_ol_isBaseLayer:function(a,b){a.isBaseLayer=this.getChildValue(b)=="true"},read_ol_displayInLayerSwitcher:function(a,b){a.displayInLayerSwitcher=this.getChildValue(b)=="true"},read_wmc_Server:function(a,
b){a.version=b.getAttribute("version");a.url=this.getOnlineResource_href(b);a.metadata.servertitle=b.getAttribute("title")},read_wmc_FormatList:function(a,b){this.runChildNodes(a,b)},read_wmc_Format:function(a,b){var c={value:this.getChildValue(b)};if(b.getAttribute("current")=="1")c.current=true;a.formats.push(c)},read_wmc_StyleList:function(a,b){this.runChildNodes(a,b)},read_wmc_Style:function(a,b){var c={};this.runChildNodes(c,b);if(b.getAttribute("current")=="1")c.current=true;a.styles.push(c)},
read_wmc_SLD:function(a,b){this.runChildNodes(a,b)},read_sld_StyledLayerDescriptor:function(a,b){var c=OpenLayers.Format.XML.prototype.write.apply(this,[b]);a.body=c},read_sld_FeatureTypeStyle:function(a,b){var c=OpenLayers.Format.XML.prototype.write.apply(this,[b]);a.body=c},read_wmc_OnlineResource:function(a,b){a.href=this.getAttributeNS(b,this.namespaces.xlink,"href")},read_wmc_Name:function(a,b){var c=this.getChildValue(b);if(c)a.name=c},read_wmc_Title:function(a,b){var c=this.getChildValue(b);
if(c)a.title=c},read_wmc_MetadataURL:function(a,b){a.metadataURL=this.getOnlineResource_href(b)},read_wmc_KeywordList:function(a,b){a.keywords=[];this.runChildNodes(a.keywords,b)},read_wmc_Keyword:function(a,b){a.push(this.getChildValue(b))},read_wmc_Abstract:function(a,b){var c=this.getChildValue(b);if(c)a["abstract"]=c},read_wmc_LogoURL:function(a,b){a.logo={width:b.getAttribute("width"),height:b.getAttribute("height"),format:b.getAttribute("format"),href:this.getOnlineResource_href(b)}},read_wmc_DescriptionURL:function(a,
b){a.descriptionURL=this.getOnlineResource_href(b)},read_wmc_ContactInformation:function(a,b){var c={};this.runChildNodes(c,b);a.contactInformation=c},read_wmc_ContactPersonPrimary:function(a,b){var c={};this.runChildNodes(c,b);a.personPrimary=c},read_wmc_ContactPerson:function(a,b){var c=this.getChildValue(b);if(c)a.person=c},read_wmc_ContactOrganization:function(a,b){var c=this.getChildValue(b);if(c)a.organization=c},read_wmc_ContactPosition:function(a,b){var c=this.getChildValue(b);if(c)a.position=
c},read_wmc_ContactAddress:function(a,b){var c={};this.runChildNodes(c,b);a.contactAddress=c},read_wmc_AddressType:function(a,b){var c=this.getChildValue(b);if(c)a.type=c},read_wmc_Address:function(a,b){var c=this.getChildValue(b);if(c)a.address=c},read_wmc_City:function(a,b){var c=this.getChildValue(b);if(c)a.city=c},read_wmc_StateOrProvince:function(a,b){var c=this.getChildValue(b);if(c)a.stateOrProvince=c},read_wmc_PostCode:function(a,b){var c=this.getChildValue(b);if(c)a.postcode=c},read_wmc_Country:function(a,
b){var c=this.getChildValue(b);if(c)a.country=c},read_wmc_ContactVoiceTelephone:function(a,b){var c=this.getChildValue(b);if(c)a.phone=c},read_wmc_ContactFacsimileTelephone:function(a,b){var c=this.getChildValue(b);if(c)a.fax=c},read_wmc_ContactElectronicMailAddress:function(a,b){var c=this.getChildValue(b);if(c)a.email=c},read_wmc_DataURL:function(a,b){a.dataURL=this.getOnlineResource_href(b)},read_wmc_LegendURL:function(a,b){var c={width:b.getAttribute("width"),height:b.getAttribute("height"),format:b.getAttribute("format"),
href:this.getOnlineResource_href(b)};a.legend=c},read_wmc_DimensionList:function(a,b){a.dimensions={};this.runChildNodes(a.dimensions,b)},read_wmc_Dimension:function(a,b){var c={name:b.getAttribute("name").toLowerCase(),units:b.getAttribute("units")||"",unitSymbol:b.getAttribute("unitSymbol")||"",userValue:b.getAttribute("userValue")||"",nearestValue:b.getAttribute("nearestValue")==="1",multipleValues:b.getAttribute("multipleValues")==="1",current:b.getAttribute("current")==="1","default":b.getAttribute("default")||
""},d=this.getChildValue(b);c.values=d.split(",");a[c.name]=c},write:function(a,b){var c=this.createElementDefaultNS("ViewContext");this.setAttributes(c,{version:this.VERSION,id:b&&typeof b.id=="string"?b.id:OpenLayers.Util.createUniqueID("OpenLayers_Context_")});this.setAttributeNS(c,this.namespaces.xsi,"xsi:schemaLocation",this.schemaLocation);c.appendChild(this.write_wmc_General(a));c.appendChild(this.write_wmc_LayerList(a));return OpenLayers.Format.XML.prototype.write.apply(this,[c])},createElementDefaultNS:function(a,
b,c){a=this.createElementNS(this.namespaces[this.defaultPrefix],a);b&&a.appendChild(this.createTextNode(b));c&&this.setAttributes(a,c);return a},setAttributes:function(a,b){var c,d;for(d in b){c=b[d].toString();c.match(/[A-Z]/)?this.setAttributeNS(a,null,d,c):a.setAttribute(d,c)}},write_wmc_General:function(a){var b=this.createElementDefaultNS("General");a.size&&b.appendChild(this.createElementDefaultNS("Window",null,{width:a.size.w,height:a.size.h}));var c=a.bounds;b.appendChild(this.createElementDefaultNS("BoundingBox",
null,{minx:c.left.toPrecision(18),miny:c.bottom.toPrecision(18),maxx:c.right.toPrecision(18),maxy:c.top.toPrecision(18),SRS:a.projection}));b.appendChild(this.createElementDefaultNS("Title",a.title));a.keywords&&b.appendChild(this.write_wmc_KeywordList(a.keywords));a["abstract"]&&b.appendChild(this.createElementDefaultNS("Abstract",a["abstract"]));a.logo&&b.appendChild(this.write_wmc_URLType("LogoURL",a.logo.href,a.logo));a.descriptionURL&&b.appendChild(this.write_wmc_URLType("DescriptionURL",a.descriptionURL));
a.contactInformation&&b.appendChild(this.write_wmc_ContactInformation(a.contactInformation));b.appendChild(this.write_ol_MapExtension(a));return b},write_wmc_KeywordList:function(a){for(var b=this.createElementDefaultNS("KeywordList"),c=0,d=a.length;c<d;c++)b.appendChild(this.createElementDefaultNS("Keyword",a[c]));return b},write_wmc_ContactInformation:function(a){var b=this.createElementDefaultNS("ContactInformation");a.personPrimary&&b.appendChild(this.write_wmc_ContactPersonPrimary(a.personPrimary));
a.position&&b.appendChild(this.createElementDefaultNS("ContactPosition",a.position));a.contactAddress&&b.appendChild(this.write_wmc_ContactAddress(a.contactAddress));a.phone&&b.appendChild(this.createElementDefaultNS("ContactVoiceTelephone",a.phone));a.fax&&b.appendChild(this.createElementDefaultNS("ContactFacsimileTelephone",a.fax));a.email&&b.appendChild(this.createElementDefaultNS("ContactElectronicMailAddress",a.email));return b},write_wmc_ContactPersonPrimary:function(a){var b=this.createElementDefaultNS("ContactPersonPrimary");
a.person&&b.appendChild(this.createElementDefaultNS("ContactPerson",a.person));a.organization&&b.appendChild(this.createElementDefaultNS("ContactOrganization",a.organization));return b},write_wmc_ContactAddress:function(a){var b=this.createElementDefaultNS("ContactAddress");a.type&&b.appendChild(this.createElementDefaultNS("AddressType",a.type));a.address&&b.appendChild(this.createElementDefaultNS("Address",a.address));a.city&&b.appendChild(this.createElementDefaultNS("City",a.city));a.stateOrProvince&&
b.appendChild(this.createElementDefaultNS("StateOrProvince",a.stateOrProvince));a.postcode&&b.appendChild(this.createElementDefaultNS("PostCode",a.postcode));a.country&&b.appendChild(this.createElementDefaultNS("Country",a.country));return b},write_ol_MapExtension:function(a){var b=this.createElementDefaultNS("Extension");if(a=a.maxExtent){var c=this.createElementNS(this.namespaces.ol,"ol:maxExtent");this.setAttributes(c,{minx:a.left.toPrecision(18),miny:a.bottom.toPrecision(18),maxx:a.right.toPrecision(18),
maxy:a.top.toPrecision(18)});b.appendChild(c)}return b},write_wmc_LayerList:function(a){for(var b=this.createElementDefaultNS("LayerList"),c=0,d=a.layersContext.length;c<d;++c)b.appendChild(this.write_wmc_Layer(a.layersContext[c]));return b},write_wmc_Layer:function(a){var b=this.createElementDefaultNS("Layer",null,{queryable:a.queryable?"1":"0",hidden:a.visibility?"0":"1"});b.appendChild(this.write_wmc_Server(a));b.appendChild(this.createElementDefaultNS("Name",a.name));b.appendChild(this.createElementDefaultNS("Title",
a.title));a["abstract"]&&b.appendChild(this.createElementDefaultNS("Abstract",a["abstract"]));a.dataURL&&b.appendChild(this.write_wmc_URLType("DataURL",a.dataURL));a.metadataURL&&b.appendChild(this.write_wmc_URLType("MetadataURL",a.metadataURL));return b},write_wmc_LayerExtension:function(a){var b=this.createElementDefaultNS("Extension"),c=a.maxExtent,d=this.createElementNS(this.namespaces.ol,"ol:maxExtent");this.setAttributes(d,{minx:c.left.toPrecision(18),miny:c.bottom.toPrecision(18),maxx:c.right.toPrecision(18),
maxy:c.top.toPrecision(18)});b.appendChild(d);if(a.tileSize&&!a.singleTile){c=this.createElementNS(this.namespaces.ol,"ol:tileSize");this.setAttributes(c,a.tileSize);b.appendChild(c)}c=["transparent","numZoomLevels","units","isBaseLayer","opacity","displayInLayerSwitcher","singleTile"];for(var e=0,f=c.length;e<f;++e)(d=this.createOLPropertyNode(a,c[e]))&&b.appendChild(d);return b},createOLPropertyNode:function(a,b){var c=null;if(a[b]!=null){c=this.createElementNS(this.namespaces.ol,"ol:"+b);c.appendChild(this.createTextNode(a[b].toString()))}return c},
write_wmc_Server:function(a){a=a.server;var b=this.createElementDefaultNS("Server"),c={service:"OGC:WMS",version:a.version};if(a.title)c.title=a.title;this.setAttributes(b,c);b.appendChild(this.write_wmc_OnlineResource(a.url));return b},write_wmc_URLType:function(a,b,c){a=this.createElementDefaultNS(a);a.appendChild(this.write_wmc_OnlineResource(b));if(c){b=["width","height","format"];for(var d=0;d<b.length;d++)b[d]in c&&a.setAttribute(b[d],c[b[d]])}return a},write_wmc_DimensionList:function(a){var b=
this.createElementDefaultNS("DimensionList"),c;for(c in a.dimensions){var d={},e=a.dimensions[c],f;for(f in e)d[f]=typeof e[f]=="boolean"?Number(e[f]):e[f];e="";if(d.values){e=d.values.join(",");delete d.values}b.appendChild(this.createElementDefaultNS("Dimension",e,d))}return b},write_wmc_FormatList:function(a){for(var b=this.createElementDefaultNS("FormatList"),c=0,d=a.formats.length;c<d;c++){var e=a.formats[c];b.appendChild(this.createElementDefaultNS("Format",e.value,e.current&&e.current==true?
{current:"1"}:null))}return b},write_wmc_StyleList:function(a){var b=this.createElementDefaultNS("StyleList");if((a=a.styles)&&OpenLayers.Util.isArray(a))for(var c,d=0,e=a.length;d<e;d++){var f=a[d],g=this.createElementDefaultNS("Style",null,f.current&&f.current==true?{current:"1"}:null);if(f.href){c=this.createElementDefaultNS("SLD");f.name&&c.appendChild(this.createElementDefaultNS("Name",f.name));f.title&&c.appendChild(this.createElementDefaultNS("Title",f.title));f.legend&&c.appendChild(this.write_wmc_URLType("LegendURL",
f.legend.href,f.legend));f=this.write_wmc_OnlineResource(f.href);c.appendChild(f);g.appendChild(c)}else if(f.body){c=this.createElementDefaultNS("SLD");f.name&&c.appendChild(this.createElementDefaultNS("Name",f.name));f.title&&c.appendChild(this.createElementDefaultNS("Title",f.title));f.legend&&c.appendChild(this.write_wmc_URLType("LegendURL",f.legend.href,f.legend));f=OpenLayers.Format.XML.prototype.read.apply(this,[f.body]).documentElement;if(c.ownerDocument&&c.ownerDocument.importNode)f=c.ownerDocument.importNode(f,
true);c.appendChild(f);g.appendChild(c)}else{g.appendChild(this.createElementDefaultNS("Name",f.name));g.appendChild(this.createElementDefaultNS("Title",f.title));f["abstract"]&&g.appendChild(this.createElementDefaultNS("Abstract",f["abstract"]));f.legend&&g.appendChild(this.write_wmc_URLType("LegendURL",f.legend.href,f.legend))}b.appendChild(g)}return b},write_wmc_OnlineResource:function(a){var b=this.createElementDefaultNS("OnlineResource");this.setAttributeNS(b,this.namespaces.xlink,"xlink:type",
"simple");this.setAttributeNS(b,this.namespaces.xlink,"xlink:href",a);return b},getOnlineResource_href:function(a){var b={};a=a.getElementsByTagName("OnlineResource");a.length>0&&this.read_wmc_OnlineResource(b,a[0]);return b.href},CLASS_NAME:"OpenLayers.Format.WMC.v1"});
OpenLayers.Popup.Framed=OpenLayers.Class(OpenLayers.Popup.Anchored,{imageSrc:null,imageSize:null,isAlphaImage:false,positionBlocks:null,blocks:null,fixedRelativePosition:false,initialize:function(a,b,c,d,e,f){OpenLayers.Popup.Anchored.prototype.initialize.apply(this,arguments);if(this.fixedRelativePosition){this.updateRelativePosition();this.calculateRelativePosition=function(){return this.relativePosition}}this.contentDiv.style.position="absolute";this.contentDiv.style.zIndex=1;if(f)this.closeDiv.style.zIndex=
1;this.groupDiv.style.position="absolute";this.groupDiv.style.top="0px";this.groupDiv.style.left="0px";this.groupDiv.style.height="100%";this.groupDiv.style.width="100%"},destroy:function(){this.isAlphaImage=this.imageSize=this.imageSrc=null;this.fixedRelativePosition=false;this.positionBlocks=null;for(var a=0;a<this.blocks.length;a++){var b=this.blocks[a];b.image&&b.div.removeChild(b.image);b.image=null;b.div&&this.groupDiv.removeChild(b.div);b.div=null}this.blocks=null;OpenLayers.Popup.Anchored.prototype.destroy.apply(this,
arguments)},setBackgroundColor:function(){},setBorder:function(){},setOpacity:function(){},setSize:function(){OpenLayers.Popup.Anchored.prototype.setSize.apply(this,arguments);this.updateBlocks()},updateRelativePosition:function(){this.padding=this.positionBlocks[this.relativePosition].padding;if(this.closeDiv){var a=this.getContentDivPadding();this.closeDiv.style.right=a.right+this.padding.right+"px";this.closeDiv.style.top=a.top+this.padding.top+"px"}this.updateBlocks()},calculateNewPx:function(){var a=
OpenLayers.Popup.Anchored.prototype.calculateNewPx.apply(this,arguments);return a=a.offset(this.positionBlocks[this.relativePosition].offset)},createBlocks:function(){this.blocks=[];var a=null,b;for(b in this.positionBlocks){a=b;break}a=this.positionBlocks[a];for(b=0;b<a.blocks.length;b++){var c={};this.blocks.push(c);c.div=OpenLayers.Util.createDiv(this.id+"_FrameDecorationDiv_"+b,null,null,null,"absolute",null,"hidden",null);c.image=(this.isAlphaImage?OpenLayers.Util.createAlphaImageDiv:OpenLayers.Util.createImage)(this.id+
"_FrameDecorationImg_"+b,null,this.imageSize,this.imageSrc,"absolute",null,null,null);c.div.appendChild(c.image);this.groupDiv.appendChild(c.div)}},updateBlocks:function(){this.blocks||this.createBlocks();if(this.size&&this.relativePosition){for(var a=this.positionBlocks[this.relativePosition],b=0;b<a.blocks.length;b++){var c=a.blocks[b],d=this.blocks[b],e=c.anchor.left,f=c.anchor.bottom,g=c.anchor.right,h=c.anchor.top,j=isNaN(c.size.w)?this.size.w-(g+e):c.size.w,i=isNaN(c.size.h)?this.size.h-(f+
h):c.size.h;d.div.style.width=(j<0?0:j)+"px";d.div.style.height=(i<0?0:i)+"px";d.div.style.left=e!=null?e+"px":"";d.div.style.bottom=f!=null?f+"px":"";d.div.style.right=g!=null?g+"px":"";d.div.style.top=h!=null?h+"px":"";d.image.style.left=c.position.x+"px";d.image.style.top=c.position.y+"px"}this.contentDiv.style.left=this.padding.left+"px";this.contentDiv.style.top=this.padding.top+"px"}},CLASS_NAME:"OpenLayers.Popup.Framed"});
OpenLayers.Popup.FramedCloud=OpenLayers.Class(OpenLayers.Popup.Framed,{contentDisplayClass:"olFramedCloudPopupContent",autoSize:true,panMapIfOutOfView:true,imageSize:new OpenLayers.Size(1276,736),isAlphaImage:false,fixedRelativePosition:false,positionBlocks:{tl:{offset:new OpenLayers.Pixel(44,0),padding:new OpenLayers.Bounds(8,40,8,9),blocks:[{size:new OpenLayers.Size("auto","auto"),anchor:new OpenLayers.Bounds(0,51,22,0),position:new OpenLayers.Pixel(0,0)},{size:new OpenLayers.Size(22,"auto"),anchor:new OpenLayers.Bounds(null,
50,0,0),position:new OpenLayers.Pixel(-1238,0)},{size:new OpenLayers.Size("auto",19),anchor:new OpenLayers.Bounds(0,32,22,null),position:new OpenLayers.Pixel(0,-631)},{size:new OpenLayers.Size(22,18),anchor:new OpenLayers.Bounds(null,32,0,null),position:new OpenLayers.Pixel(-1238,-632)},{size:new OpenLayers.Size(81,35),anchor:new OpenLayers.Bounds(null,0,0,null),position:new OpenLayers.Pixel(0,-688)}]},tr:{offset:new OpenLayers.Pixel(-45,0),padding:new OpenLayers.Bounds(8,40,8,9),blocks:[{size:new OpenLayers.Size("auto",
"auto"),anchor:new OpenLayers.Bounds(0,51,22,0),position:new OpenLayers.Pixel(0,0)},{size:new OpenLayers.Size(22,"auto"),anchor:new OpenLayers.Bounds(null,50,0,0),position:new OpenLayers.Pixel(-1238,0)},{size:new OpenLayers.Size("auto",19),anchor:new OpenLayers.Bounds(0,32,22,null),position:new OpenLayers.Pixel(0,-631)},{size:new OpenLayers.Size(22,19),anchor:new OpenLayers.Bounds(null,32,0,null),position:new OpenLayers.Pixel(-1238,-631)},{size:new OpenLayers.Size(81,35),anchor:new OpenLayers.Bounds(0,
0,null,null),position:new OpenLayers.Pixel(-215,-687)}]},bl:{offset:new OpenLayers.Pixel(45,0),padding:new OpenLayers.Bounds(8,9,8,40),blocks:[{size:new OpenLayers.Size("auto","auto"),anchor:new OpenLayers.Bounds(0,21,22,32),position:new OpenLayers.Pixel(0,0)},{size:new OpenLayers.Size(22,"auto"),anchor:new OpenLayers.Bounds(null,21,0,32),position:new OpenLayers.Pixel(-1238,0)},{size:new OpenLayers.Size("auto",21),anchor:new OpenLayers.Bounds(0,0,22,null),position:new OpenLayers.Pixel(0,-629)},{size:new OpenLayers.Size(22,
21),anchor:new OpenLayers.Bounds(null,0,0,null),position:new OpenLayers.Pixel(-1238,-629)},{size:new OpenLayers.Size(81,33),anchor:new OpenLayers.Bounds(null,null,0,0),position:new OpenLayers.Pixel(-101,-674)}]},br:{offset:new OpenLayers.Pixel(-44,0),padding:new OpenLayers.Bounds(8,9,8,40),blocks:[{size:new OpenLayers.Size("auto","auto"),anchor:new OpenLayers.Bounds(0,21,22,32),position:new OpenLayers.Pixel(0,0)},{size:new OpenLayers.Size(22,"auto"),anchor:new OpenLayers.Bounds(null,21,0,32),position:new OpenLayers.Pixel(-1238,
0)},{size:new OpenLayers.Size("auto",21),anchor:new OpenLayers.Bounds(0,0,22,null),position:new OpenLayers.Pixel(0,-629)},{size:new OpenLayers.Size(22,21),anchor:new OpenLayers.Bounds(null,0,0,null),position:new OpenLayers.Pixel(-1238,-629)},{size:new OpenLayers.Size(81,33),anchor:new OpenLayers.Bounds(0,null,null,0),position:new OpenLayers.Pixel(-311,-674)}]}},minSize:new OpenLayers.Size(105,10),maxSize:new OpenLayers.Size(1200,660),initialize:function(){this.imageSrc=OpenLayers.Util.getImagesLocation()+
"cloud-popup-relative.png";OpenLayers.Popup.Framed.prototype.initialize.apply(this,arguments);this.contentDiv.className=this.contentDisplayClass},destroy:function(){OpenLayers.Popup.Framed.prototype.destroy.apply(this,arguments)},CLASS_NAME:"OpenLayers.Popup.FramedCloud"});
OpenLayers.Control.PanPanel=OpenLayers.Class(OpenLayers.Control.Panel,{slideFactor:50,slideRatio:null,initialize:function(a){OpenLayers.Control.Panel.prototype.initialize.apply(this,[a]);a={slideFactor:this.slideFactor,slideRatio:this.slideRatio};this.addControls([new OpenLayers.Control.Pan(OpenLayers.Control.Pan.NORTH,a),new OpenLayers.Control.Pan(OpenLayers.Control.Pan.SOUTH,a),new OpenLayers.Control.Pan(OpenLayers.Control.Pan.EAST,a),new OpenLayers.Control.Pan(OpenLayers.Control.Pan.WEST,a)])},
CLASS_NAME:"OpenLayers.Control.PanPanel"});
OpenLayers.Control.Attribution=OpenLayers.Class(OpenLayers.Control,{separator:", ",destroy:function(){this.map.events.un({removelayer:this.updateAttribution,addlayer:this.updateAttribution,changelayer:this.updateAttribution,changebaselayer:this.updateAttribution,scope:this});OpenLayers.Control.prototype.destroy.apply(this,arguments)},draw:function(){OpenLayers.Control.prototype.draw.apply(this,arguments);this.map.events.on({changebaselayer:this.updateAttribution,changelayer:this.updateAttribution,
addlayer:this.updateAttribution,removelayer:this.updateAttribution,scope:this});this.updateAttribution();return this.div},updateAttribution:function(){var a=[];if(this.map&&this.map.layers){for(var b=0,c=this.map.layers.length;b<c;b++){var d=this.map.layers[b];d.attribution&&d.getVisibility()&&OpenLayers.Util.indexOf(a,d.attribution)===-1&&a.push(d.attribution)}this.div.innerHTML=a.join(this.separator)}},CLASS_NAME:"OpenLayers.Control.Attribution"});
OpenLayers.Renderer.NG=OpenLayers.Class(OpenLayers.Renderer.Elements,{labelNodeType:null,updateDimensions:function(){var a=this.map.getExtent(),b=a.scale(3);this.setExtent(b,true);var c=this.getResolution(),d=this.rendererRoot.parentNode,e=parseFloat(d.parentNode.style.left),f=parseFloat(d.parentNode.style.top);d.style.left=(b.left-a.left)/c-e+"px";d.style.top=(a.top-b.top)/c-f+"px"},setSize:function(){this.map.getExtent()&&this.updateDimensions()},drawFeature:function(a,b){if(b==null)b=a.style;if(a.geometry){var c=
this.drawGeometry(a.geometry,b,a.id);if(c!==false&&b.label){var d=a.geometry.getCentroid();this.drawText(a.id,b,d)}else this.removeText(a.id);return c}},drawText:function(a,b,c){var d;if(typeof a!=="string")d=a;else{d=this.nodeFactory(a+this.LABEL_ID_SUFFIX,this.labelNodeType);d._featureId=a}d._style=b;d._x=c.x;d._y=c.y;if(b.labelXOffset||b.labelYOffset){a=isNaN(b.labelXOffset)?0:b.labelXOffset;b=isNaN(b.labelYOffset)?0:b.labelYOffset;var e=this.getResolution();c.move(a*e,b*e)}d.parentNode!==this.textRoot&&
this.textRoot.appendChild(d);return d},CLASS_NAME:"OpenLayers.Renderer.NG"});
OpenLayers.Renderer.SVG2=OpenLayers.Class(OpenLayers.Renderer.NG,{xmlns:"http://www.w3.org/2000/svg",xlinkns:"http://www.w3.org/1999/xlink",symbolMetrics:null,labelNodeType:"g",initialize:function(){if(this.supported()){OpenLayers.Renderer.Elements.prototype.initialize.apply(this,arguments);this.symbolMetrics={}}},supported:function(){return document.implementation&&(document.implementation.hasFeature("org.w3c.svg","1.0")||document.implementation.hasFeature("http://www.w3.org/TR/SVG11/feature#SVG",
"1.1")||document.implementation.hasFeature("http://www.w3.org/TR/SVG11/feature#BasicStructure","1.1"))},updateDimensions:function(a){OpenLayers.Renderer.NG.prototype.updateDimensions.apply(this,arguments);var b=this.getResolution(),c=this.extent.getWidth(),d=this.extent.getHeight();this.rendererRoot.setAttributeNS(null,"viewBox",[this.extent.left,-this.extent.top,c,d].join(" "));this.rendererRoot.setAttributeNS(null,"width",c/b);this.rendererRoot.setAttributeNS(null,"height",d/b);if(a===true){d=this.vectorRoot.childNodes;
b=0;for(c=d.length;b<c;++b)this.setStyle(d[b]);d=this.textRoot.childNodes;var e;b=0;for(c=d.length;b<c;++b){e=d[b];this.drawText(e,e._style,new OpenLayers.Geometry.Point(e._x,e._y))}}},getNodeType:function(a,b){var c=null;switch(a.CLASS_NAME){case "OpenLayers.Geometry.Point":c=b.externalGraphic?"image":this.isComplexSymbol(b.graphicName)?"svg":"circle";break;case "OpenLayers.Geometry.Rectangle":c="rect";break;case "OpenLayers.Geometry.LineString":c="polyline";break;case "OpenLayers.Geometry.LinearRing":c=
"polygon";break;case "OpenLayers.Geometry.Polygon":case "OpenLayers.Geometry.Curve":case "OpenLayers.Geometry.Surface":c="path"}return c},setStyle:function(a,b,c){b=b||a._style;c=c||a._options;var d=this.getResolution(),e=a._radius,f=d;if(a._geometryClass=="OpenLayers.Geometry.Point"&&e){a.style.visibility="";if(b.graphic===false)a.style.visibility="hidden";else if(b.externalGraphic){if(b.graphicTitle){a.setAttributeNS(null,"title",b.graphicTitle);e=this.nodeFactory(null,"title");e.textContent=b.graphicTitle;
a.appendChild(e)}b.graphicWidth&&b.graphicHeight&&a.setAttributeNS(null,"preserveAspectRatio","none");e=b.graphicWidth||b.graphicHeight;var g=b.graphicHeight||b.graphicWidth;e=e?e:b.pointRadius*2;g=g?g:b.pointRadius*2;e*=d;g*=d;var h=b.graphicYOffset!=undefined?b.graphicYOffset*d:-(0.5*g),j=b.graphicOpacity||b.fillOpacity;a.setAttributeNS(null,"x",a._x+(b.graphicXOffset!=undefined?b.graphicXOffset*d:-(0.5*e)));a.setAttributeNS(null,"y",a._y+h);a.setAttributeNS(null,"width",e);a.setAttributeNS(null,
"height",g);a.setAttributeNS(this.xlinkns,"href",b.externalGraphic);a.setAttributeNS(null,"style","opacity: "+j);a.onclick=OpenLayers.Renderer.SVG2.preventDefault}else if(this.isComplexSymbol(b.graphicName)){e=b.pointRadius*3*d;g=e*2;var i=this.importSymbol(b.graphicName);f=this.symbolMetrics[i.id].size*3/g*d;d=a.parentNode;h=a.nextSibling;d&&d.removeChild(a);a.firstChild&&a.removeChild(a.firstChild);a.appendChild(i.firstChild.cloneNode(true));a.setAttributeNS(null,"viewBox",i.getAttributeNS(null,
"viewBox"));a.setAttributeNS(null,"width",g);a.setAttributeNS(null,"height",g);a.setAttributeNS(null,"x",a._x-e);a.setAttributeNS(null,"y",a._y-e);if(h)d.insertBefore(a,h);else d&&d.appendChild(a)}else a.setAttributeNS(null,"r",b.pointRadius*d);d=b.rotation;if(d!==undefined||a._rotation!==undefined){a._rotation=d;d|=0;if(a.nodeName!=="svg")a.setAttributeNS(null,"transform",["rotate(",d,a._x,a._y,")"].join(" "));else{i=this.symbolMetrics[i.id];a.firstChild.setAttributeNS(null,"transform",["rotate(",
d,i.x,i.y,")"].join(" "))}}}if(c.isFilled){a.setAttributeNS(null,"fill",b.fillColor);a.setAttributeNS(null,"fill-opacity",b.fillOpacity)}else a.setAttributeNS(null,"fill","none");if(c.isStroked){a.setAttributeNS(null,"stroke",b.strokeColor);a.setAttributeNS(null,"stroke-opacity",b.strokeOpacity);a.setAttributeNS(null,"stroke-width",b.strokeWidth*f);a.setAttributeNS(null,"stroke-linecap",b.strokeLinecap||"round");a.setAttributeNS(null,"stroke-linejoin","round");b.strokeDashstyle&&a.setAttributeNS(null,
"stroke-dasharray",this.dashStyle(b,f))}else a.setAttributeNS(null,"stroke","none");b.pointerEvents&&a.setAttributeNS(null,"pointer-events",b.pointerEvents);b.cursor!=null&&a.setAttributeNS(null,"cursor",b.cursor);return a},dashStyle:function(a,b){var c=a.strokeWidth*b,d=a.strokeDashstyle;switch(d){case "solid":return"none";case "dot":return[b,4*c].join();case "dash":return[4*c,4*c].join();case "dashdot":return[4*c,4*c,b,4*c].join();case "longdash":return[8*c,4*c].join();case "longdashdot":return[8*
c,4*c,b,4*c].join();default:c=OpenLayers.String.trim(d).split(/\s+/g);d=0;for(var e=c.length;d<e;d++)c[d]*=b;return c.join()}},createNode:function(a,b){var c=document.createElementNS(this.xmlns,a);b&&c.setAttributeNS(null,"id",b);return c},nodeTypeCompare:function(a,b){return b==a.nodeName},createRenderRoot:function(){return this.nodeFactory(this.container.id+"_svgRoot","svg")},createRoot:function(a){return this.nodeFactory(this.container.id+a,"g")},createDefs:function(){var a=this.nodeFactory(this.container.id+
"_defs","defs");this.rendererRoot.appendChild(a);return a},drawPoint:function(a,b){return this.drawCircle(a,b,1)},drawCircle:function(a,b,c){var d=b.x;b=-b.y;a.setAttributeNS(null,"cx",d);a.setAttributeNS(null,"cy",b);a._x=d;a._y=b;a._radius=c;return a},drawLineString:function(a,b){var c=this.getComponentsString(b.components);a.setAttributeNS(null,"points",c);return a},drawLinearRing:function(a,b){var c=this.getComponentsString(b.components);a.setAttributeNS(null,"points",c);return a},drawPolygon:function(a,
b){for(var c=[],d,e=0,f=b.components.length;e<f;e++){c.push("M");d=this.getComponentsString(b.components[e].components," ");c.push(d)}c.push("z");a.setAttributeNS(null,"d",c.join(" "));a.setAttributeNS(null,"fill-rule","evenodd");return a},drawRectangle:function(a,b){a.setAttributeNS(null,"x",b.x);a.setAttributeNS(null,"y",-b.y);a.setAttributeNS(null,"width",b.width);a.setAttributeNS(null,"height",b.height);return a},drawSurface:function(a,b){for(var c=[],d=0,e=b.components.length;d<e;d++)if(d%3==
0&&d/3==0){var f=this.getShortString(b.components[d]);c.push("M",f)}else if(d%3==1){f=this.getShortString(b.components[d]);c.push("C",f)}else{f=this.getShortString(b.components[d]);c.push(f)}c.push("Z");a.setAttributeNS(null,"d",c.join(" "));return a},drawText:function(a,b,c){var d=OpenLayers.Renderer.NG.prototype.drawText.apply(this,arguments),e=d.firstChild||this.nodeFactory(a+this.LABEL_ID_SUFFIX+"_text","text"),f=this.getResolution();e.setAttributeNS(null,"x",c.x/f);e.setAttributeNS(null,"y",
-c.y/f);d.setAttributeNS(null,"transform","scale("+f+")");b.fontColor&&e.setAttributeNS(null,"fill",b.fontColor);b.fontOpacity&&e.setAttributeNS(null,"opacity",b.fontOpacity);b.fontFamily&&e.setAttributeNS(null,"font-family",b.fontFamily);b.fontSize&&e.setAttributeNS(null,"font-size",b.fontSize);b.fontWeight&&e.setAttributeNS(null,"font-weight",b.fontWeight);b.fontStyle&&e.setAttributeNS(null,"font-style",b.fontStyle);if(b.labelSelect===true){e.setAttributeNS(null,"pointer-events","visible");e._featureId=
a}else e.setAttributeNS(null,"pointer-events","none");var g=b.labelAlign||"cm";e.setAttributeNS(null,"text-anchor",OpenLayers.Renderer.SVG2.LABEL_ALIGN[g[0]]||"middle");if(OpenLayers.IS_GECKO===true)e.setAttributeNS(null,"dominant-baseline",OpenLayers.Renderer.SVG2.LABEL_ALIGN[g[1]]||"central");for(var h=b.label.split("\n"),j=h.length;e.childNodes.length>j;)e.removeChild(e.lastChild);for(var i=0;i<j;i++){var k=e.childNodes[i]||this.nodeFactory(a+this.LABEL_ID_SUFFIX+"_tspan_"+i,"tspan");if(b.labelSelect===
true)k._featureId=a;if(OpenLayers.IS_GECKO===false)k.setAttributeNS(null,"baseline-shift",OpenLayers.Renderer.SVG2.LABEL_VSHIFT[g[1]]||"-35%");k.setAttribute("x",c.x/f);if(i==0){var l=OpenLayers.Renderer.SVG2.LABEL_VFACTOR[g[1]];if(l==null)l=-0.5;k.setAttribute("dy",l*(j-1)+"em")}else k.setAttribute("dy","1em");k.textContent=h[i]===""?" ":h[i];k.parentNode||e.appendChild(k)}e.parentNode||d.appendChild(e);return d},getComponentsString:function(a,b){for(var c=a.length,d=Array(c),e=0;e<c;e++)d[e]=this.getShortString(a[e]);
return d.join(b||",")},getShortString:function(a){return a.x+","+-a.y},importSymbol:function(a){if(!this.defs)this.defs=this.createDefs();var b=this.container.id+"-"+a,c=document.getElementById(b);if(c!=null)return c;var d=OpenLayers.Renderer.symbol[a];if(!d)throw Error(a+" is not a valid symbol name");a=this.nodeFactory(b,"symbol");var e=this.nodeFactory(null,"polygon");a.appendChild(e);c=new OpenLayers.Bounds(Number.MAX_VALUE,Number.MAX_VALUE,0,0);for(var f=[],g,h,j=0,i=d.length;j<i;j+=2){g=d[j];
h=d[j+1];c.left=Math.min(c.left,g);c.bottom=Math.min(c.bottom,h);c.right=Math.max(c.right,g);c.top=Math.max(c.top,h);f.push(g,",",h)}e.setAttributeNS(null,"points",f.join(" "));d=c.getWidth();e=c.getHeight();a.setAttributeNS(null,"viewBox",[c.left-d,c.bottom-e,d*3,e*3].join(" "));this.symbolMetrics[b]={size:Math.max(d,e),x:c.getCenterLonLat().lon,y:c.getCenterLonLat().lat};this.defs.appendChild(a);return a},getFeatureIdFromEvent:function(a){var b=OpenLayers.Renderer.Elements.prototype.getFeatureIdFromEvent.apply(this,
arguments);if(!b){b=a.target;b=b.parentNode&&b!=this.rendererRoot&&b.parentNode._featureId}return b},CLASS_NAME:"OpenLayers.Renderer.SVG2"});OpenLayers.Renderer.SVG2.LABEL_ALIGN={l:"start",r:"end",b:"bottom",t:"hanging"};OpenLayers.Renderer.SVG2.LABEL_VSHIFT={t:"-70%",b:"0"};OpenLayers.Renderer.SVG2.LABEL_VFACTOR={t:0,b:-1};OpenLayers.Renderer.SVG2.preventDefault=function(a){a.preventDefault&&a.preventDefault()};
OpenLayers.Kinetic=OpenLayers.Class({threshold:0,interval:10,deceleration:0.0035,nbPoints:100,delay:200,points:undefined,timerId:undefined,initialize:function(a){OpenLayers.Util.extend(this,a)},begin:function(){clearInterval(this.timerId);this.timerId=undefined;this.points=[]},update:function(a){this.points.unshift({xy:a,tick:(new Date).getTime()});this.points.length>this.nbPoints&&this.points.pop()},end:function(a){for(var b,c=(new Date).getTime(),d=0,e=this.points.length,f;d<e;d++){f=this.points[d];
if(c-f.tick>this.delay)break;b=f}if(b){d=(new Date).getTime()-b.tick;c=Math.sqrt(Math.pow(a.x-b.xy.x,2)+Math.pow(a.y-b.xy.y,2));d=c/d;if(!(d==0||d<this.threshold)){c=Math.asin((a.y-b.xy.y)/c);if(b.xy.x<=a.x)c=Math.PI-c;return{speed:d,theta:c}}}},move:function(a,b){var c=a.speed,d=Math.cos(a.theta),e=-Math.sin(a.theta),f=0,g=(new Date).getTime(),h=0,j=0;this.timerId=window.setInterval(OpenLayers.Function.bind(function(){if(this.timerId!=null){f+=this.interval;var i=(new Date).getTime()-g;i=(f+i)/2;
var k=-this.deceleration*Math.pow(i,2)/2+c*i,l=k*d;k*=e;var m={};m.end=false;if(-this.deceleration*i+c<=0){clearInterval(this.timerId);this.timerId=null;m.end=true}m.x=l-h;m.y=k-j;h=l;j=k;b(m.x,m.y,m.end)}},this),this.interval)},CLASS_NAME:"OpenLayers.Kinetic"});OpenLayers.ProxyHost="";OpenLayers.nullHandler=function(a){OpenLayers.Console.userError(OpenLayers.i18n("unhandledRequest",{statusText:a.statusText}))};
OpenLayers.loadURL=function(a,b,c,d,e){if(typeof b=="string")b=OpenLayers.Util.getParameters(b);return OpenLayers.Request.GET({url:a,params:b,success:d?d:OpenLayers.nullHandler,failure:e?e:OpenLayers.nullHandler,scope:c})};
OpenLayers.parseXMLString=function(a){var b=a.indexOf("<");if(b>0)a=a.substring(b);return OpenLayers.Util.Try(function(){var c=new ActiveXObject("Microsoft.XMLDOM");c.loadXML(a);return c},function(){return(new DOMParser).parseFromString(a,"text/xml")},function(){var c=new XMLHttpRequest;c.open("GET","data:text/xml;charset=utf-8,"+encodeURIComponent(a),false);c.overrideMimeType&&c.overrideMimeType("text/xml");c.send(null);return c.responseXML})};
OpenLayers.Ajax={emptyFunction:function(){},getTransport:function(){return OpenLayers.Util.Try(function(){return new XMLHttpRequest},function(){return new ActiveXObject("Msxml2.XMLHTTP")},function(){return new ActiveXObject("Microsoft.XMLHTTP")})||false},activeRequestCount:0};
OpenLayers.Ajax.Responders={responders:[],register:function(a){for(var b=0;b<this.responders.length;b++)if(a==this.responders[b])return;this.responders.push(a)},unregister:function(a){OpenLayers.Util.removeItem(this.reponders,a)},dispatch:function(a,b,c){for(var d,e=0;e<this.responders.length;e++){d=this.responders[e];if(d[a]&&typeof d[a]=="function")try{d[a].apply(d,[b,c])}catch(f){}}}};OpenLayers.Ajax.Responders.register({onCreate:function(){OpenLayers.Ajax.activeRequestCount++},onComplete:function(){OpenLayers.Ajax.activeRequestCount--}});
OpenLayers.Ajax.Base=OpenLayers.Class({initialize:function(a){this.options={method:"post",asynchronous:true,contentType:"application/xml",parameters:""};OpenLayers.Util.extend(this.options,a||{});this.options.method=this.options.method.toLowerCase();if(typeof this.options.parameters=="string")this.options.parameters=OpenLayers.Util.getParameters(this.options.parameters)}});
OpenLayers.Ajax.Request=OpenLayers.Class(OpenLayers.Ajax.Base,{_complete:false,initialize:function(a,b){OpenLayers.Ajax.Base.prototype.initialize.apply(this,[b]);if(OpenLayers.ProxyHost&&OpenLayers.String.startsWith(a,"http"))a=OpenLayers.ProxyHost+encodeURIComponent(a);this.transport=OpenLayers.Ajax.getTransport();this.request(a)},request:function(a){this.url=a;this.method=this.options.method;a=OpenLayers.Util.extend({},this.options.parameters);if(this.method!="get"&&this.method!="post"){a._method=
this.method;this.method="post"}this.parameters=a;if(a=OpenLayers.Util.getParameterString(a))if(this.method=="get")this.url+=(this.url.indexOf("?")>-1?"&":"?")+a;else if(/Konqueror|Safari|KHTML/.test(navigator.userAgent))a+="&_=";try{var b=new OpenLayers.Ajax.Response(this);if(this.options.onCreate)this.options.onCreate(b);OpenLayers.Ajax.Responders.dispatch("onCreate",this,b);this.transport.open(this.method.toUpperCase(),this.url,this.options.asynchronous);this.options.asynchronous&&window.setTimeout(OpenLayers.Function.bind(this.respondToReadyState,
this,1),10);this.transport.onreadystatechange=OpenLayers.Function.bind(this.onStateChange,this);this.setRequestHeaders();this.body=this.method=="post"?this.options.postBody||a:null;this.transport.send(this.body);if(!this.options.asynchronous&&this.transport.overrideMimeType)this.onStateChange()}catch(c){this.dispatchException(c)}},onStateChange:function(){var a=this.transport.readyState;a>1&&!(a==4&&this._complete)&&this.respondToReadyState(this.transport.readyState)},setRequestHeaders:function(){var a=
{"X-Requested-With":"XMLHttpRequest",Accept:"text/javascript, text/html, application/xml, text/xml, */*",OpenLayers:true};if(this.method=="post"){a["Content-type"]=this.options.contentType+(this.options.encoding?"; charset="+this.options.encoding:"");if(this.transport.overrideMimeType&&(navigator.userAgent.match(/Gecko\/(\d{4})/)||[0,2005])[1]<2005)a.Connection="close"}if(typeof this.options.requestHeaders=="object"){var b=this.options.requestHeaders;if(typeof b.push=="function")for(var c=0,d=b.length;c<
d;c+=2)a[b[c]]=b[c+1];else for(c in b)a[c]=b[c]}for(var e in a)this.transport.setRequestHeader(e,a[e])},success:function(){var a=this.getStatus();return!a||a>=200&&a<300},getStatus:function(){try{return this.transport.status||0}catch(a){return 0}},respondToReadyState:function(a){a=OpenLayers.Ajax.Request.Events[a];var b=new OpenLayers.Ajax.Response(this);if(a=="Complete"){try{this._complete=true;(this.options["on"+b.status]||this.options["on"+(this.success()?"Success":"Failure")]||OpenLayers.Ajax.emptyFunction)(b)}catch(c){this.dispatchException(c)}b.getHeader("Content-type")}try{(this.options["on"+
a]||OpenLayers.Ajax.emptyFunction)(b);OpenLayers.Ajax.Responders.dispatch("on"+a,this,b)}catch(d){this.dispatchException(d)}if(a=="Complete")this.transport.onreadystatechange=OpenLayers.Ajax.emptyFunction},getHeader:function(a){try{return this.transport.getResponseHeader(a)}catch(b){return null}},dispatchException:function(a){var b=this.options.onException;if(b){b(this,a);OpenLayers.Ajax.Responders.dispatch("onException",this,a)}else{b=false;for(var c=OpenLayers.Ajax.Responders.responders,d=0;d<c.length;d++)if(c[d].onException){b=
true;break}if(b)OpenLayers.Ajax.Responders.dispatch("onException",this,a);else throw a;}}});OpenLayers.Ajax.Request.Events=["Uninitialized","Loading","Loaded","Interactive","Complete"];
OpenLayers.Ajax.Response=OpenLayers.Class({status:0,statusText:"",initialize:function(a){this.request=a;a=this.transport=a.transport;var b=this.readyState=a.readyState;if(b>2&&!(window.attachEvent&&!window.opera)||b==4){this.status=this.getStatus();this.statusText=this.getStatusText();this.responseText=a.responseText==null?"":String(a.responseText)}if(b==4){a=a.responseXML;this.responseXML=a===undefined?null:a}},getStatus:OpenLayers.Ajax.Request.prototype.getStatus,getStatusText:function(){try{return this.transport.statusText||
""}catch(a){return""}},getHeader:OpenLayers.Ajax.Request.prototype.getHeader,getResponseHeader:function(a){return this.transport.getResponseHeader(a)}});OpenLayers.Ajax.getElementsByTagNameNS=function(a,b,c,d){var e=null;return e=a.getElementsByTagNameNS?a.getElementsByTagNameNS(b,d):a.getElementsByTagName(c+":"+d)};OpenLayers.Ajax.serializeXMLToString=function(a){return(new XMLSerializer).serializeToString(a)};
OpenLayers.Format.WPSExecute=OpenLayers.Class(OpenLayers.Format.XML,{namespaces:{ows:"http://www.opengis.net/ows/1.1",gml:"http://www.opengis.net/gml",wps:"http://www.opengis.net/wps/1.0.0",wfs:"http://www.opengis.net/wfs",ogc:"http://www.opengis.net/ogc",wcs:"http://www.opengis.net/wcs",xlink:"http://www.w3.org/1999/xlink",xsi:"http://www.w3.org/2001/XMLSchema-instance"},regExes:{trimSpace:/^\s*|\s*$/g,removeSpace:/\s*/g,splitSpace:/\s+/,trimComma:/\s*,\s*/g},VERSION:"1.0.0",schemaLocation:"http://www.opengis.net/wps/1.0.0 http://schemas.opengis.net/wps/1.0.0/wpsAll.xsd",
schemaLocationAttr:function(){},write:function(a){var b;if(window.ActiveXObject)this.xmldom=b=new ActiveXObject("Microsoft.XMLDOM");else b=document.implementation.createDocument("","",null);a=this.writeNode("wps:Execute",a,b);this.setAttributeNS(a,this.namespaces.xsi,"xsi:schemaLocation",this.schemaLocation);return OpenLayers.Format.XML.prototype.write.apply(this,[a])},writers:{wps:{Execute:function(a){var b=this.createElementNSPlus("wps:Execute",{attributes:{version:this.VERSION,service:"WPS"}});
this.writeNode("ows:Identifier",a.identifier,b);this.writeNode("wps:DataInputs",a.dataInputs,b);this.writeNode("wps:ResponseForm",a.responseForm,b);return b},ResponseForm:function(a){var b=this.createElementNSPlus("wps:ResponseForm",{});a.rawDataOutput&&this.writeNode("wps:RawDataOutput",a.rawDataOutput,b);a.responseDocument&&this.writeNode("wps:ResponseDocument",a.responseDocument,b);return b},ResponseDocument:function(a){var b=this.createElementNSPlus("wps:ResponseDocument",{attributes:{storeExecuteResponse:a.storeExecuteResponse,
lineage:a.lineage,status:a.status}});a.output&&this.writeNode("wps:Output",a.output,b);return b},Output:function(a){var b=this.createElementNSPlus("wps:Output",{attributes:{asReference:a.asReference}});this.writeNode("ows:Identifier",a.identifier,b);this.writeNode("ows:Title",a.title,b);this.writeNode("ows:Abstract",a["abstract"],b);return b},RawDataOutput:function(a){var b=this.createElementNSPlus("wps:RawDataOutput",{attributes:{mimeType:a.mimeType}});this.writeNode("ows:Identifier",a.identifier,
b);return b},DataInputs:function(a){for(var b=this.createElementNSPlus("wps:DataInputs",{}),c=0,d=a.length;c<d;++c)this.writeNode("wps:Input",a[c],b);return b},Input:function(a){var b=this.createElementNSPlus("wps:Input",{});this.writeNode("ows:Identifier",a.identifier,b);a.title&&this.writeNode("ows:Title",a.title,b);a.data&&this.writeNode("wps:Data",a.data,b);a.reference&&this.writeNode("wps:Reference",a.reference,b);return b},Data:function(a){var b=this.createElementNSPlus("wps:Data",{});if(a.literalData)this.writeNode("wps:LiteralData",
a.literalData,b);else a.complexData&&this.writeNode("wps:ComplexData",a.complexData,b);return b},LiteralData:function(a){return this.createElementNSPlus("wps:LiteralData",{attributes:{uom:a.uom},value:a.value})},ComplexData:function(a){var b=this.createElementNSPlus("wps:ComplexData",{attributes:{mimeType:a.mimeType,encoding:a.encoding,schema:a.schema}});b.appendChild(this.getXMLDoc().createCDATASection(a.value));return b},Reference:function(a){var b=this.createElementNSPlus("wps:Reference",{attributes:{mimeType:a.mimeType,
"xlink:href":a.href,method:a.method,encoding:a.encoding,schema:a.schema}});a.body&&this.writeNode("wps:Body",a.body,b);return b},Body:function(a){var b=this.createElementNSPlus("wps:Body",{});if(a.wcs)this.writeNode("wcs:GetCoverage",a.wcs,b);else if(a.wfs){this.featureType=a.wfs.featureType;this.version=a.wfs.version;this.writeNode("wfs:GetFeature",a.wfs,b)}else this.writeNode("wps:Execute",a,b);return b}},wcs:OpenLayers.Format.WCSGetCoverage.prototype.writers.wcs,wfs:OpenLayers.Format.WFST.v1_1_0.prototype.writers.wfs,
ows:OpenLayers.Format.OWSCommon.v1_1_0.prototype.writers.ows},CLASS_NAME:"OpenLayers.Format.WPSExecute"});
OpenLayers.Layer.GeoRSS=OpenLayers.Class(OpenLayers.Layer.Markers,{location:null,features:null,formatOptions:null,selectedFeature:null,icon:null,popupSize:null,useFeedTitle:true,initialize:function(a,b,c){OpenLayers.Layer.Markers.prototype.initialize.apply(this,[a,c]);this.location=b;this.features=[]},destroy:function(){OpenLayers.Layer.Markers.prototype.destroy.apply(this,arguments);this.clearFeatures();this.features=null},loadRSS:function(){if(!this.loaded){this.events.triggerEvent("loadstart");
OpenLayers.Request.GET({url:this.location,success:this.parseData,scope:this});this.loaded=true}},moveTo:function(){OpenLayers.Layer.Markers.prototype.moveTo.apply(this,arguments);this.visibility&&!this.loaded&&this.loadRSS()},parseData:function(a){var b=a.responseXML;if(!b||!b.documentElement)b=OpenLayers.Format.XML.prototype.read(a.responseText);if(this.useFeedTitle){a=null;try{a=b.getElementsByTagNameNS("*","title")[0].firstChild.nodeValue}catch(c){a=b.getElementsByTagName("title")[0].firstChild.nodeValue}a&&
this.setName(a)}a={};OpenLayers.Util.extend(a,this.formatOptions);if(this.map&&!this.projection.equals(this.map.getProjectionObject())){a.externalProjection=this.projection;a.internalProjection=this.map.getProjectionObject()}b=(new OpenLayers.Format.GeoRSS(a)).read(b);a=0;for(var d=b.length;a<d;a++){var e={},f=b[a];if(f.geometry){var g=f.attributes.title?f.attributes.title:"Untitled",h=f.attributes.description?f.attributes.description:"No description.",j=f.attributes.link?f.attributes.link:"";f=f.geometry.getBounds().getCenterLonLat();
e.icon=this.icon==null?OpenLayers.Marker.defaultIcon():this.icon.clone();e.popupSize=this.popupSize?this.popupSize.clone():new OpenLayers.Size(250,120);if(g||h){e.title=g;e.description=h;var i='<div class="olLayerGeoRSSClose">[x]</div>';i+='<div class="olLayerGeoRSSTitle">';if(j)i+='<a class="link" href="'+j+'" target="_blank">';i+=g;if(j)i+="</a>";i+="</div>";i+='<div style="" class="olLayerGeoRSSDescription">';i+=h;i+="</div>";e.popupContentHTML=i}f=new OpenLayers.Feature(this,f,e);this.features.push(f);
e=f.createMarker();e.events.register("click",f,this.markerClick);this.addMarker(e)}}this.events.triggerEvent("loadend")},markerClick:function(a){var b=this==this.layer.selectedFeature;this.layer.selectedFeature=!b?this:null;for(var c=0,d=this.layer.map.popups.length;c<d;c++)this.layer.map.removePopup(this.layer.map.popups[c]);if(!b){b=this.createPopup();OpenLayers.Event.observe(b.div,"click",OpenLayers.Function.bind(function(){for(var e=0,f=this.layer.map.popups.length;e<f;e++)this.layer.map.removePopup(this.layer.map.popups[e])},
this));this.layer.map.addPopup(b)}OpenLayers.Event.stop(a)},clearFeatures:function(){if(this.features!=null)for(;this.features.length>0;){var a=this.features[0];OpenLayers.Util.removeItem(this.features,a);a.destroy()}},CLASS_NAME:"OpenLayers.Layer.GeoRSS"});
OpenLayers.Lang.br=OpenLayers.Util.applyDefaults({unhandledRequest:"Distro evel reked anveret ${statusText}",Permalink:"Peurliamm",Overlays:"Gwiskado\u00f9","Base Layer":"Gwiskad diazez",readNotImplemented:"N'eo ket emplementet al lenn.",writeNotImplemented:"N'eo ket emplementet ar skriva\u00f1.",noFID:"N'haller ket hizivaat un elfenn ma n'eus ket a niverenn-anaout (FID) eviti.",errorLoadingGML:"Fazi e-ser karga\u00f1 ar restr GML ${url}",browserNotSupported:"N'eo ket skoret an daskor vektorel gant ho merdeer. Setu aze an daskorerio\u00f9 skoret evit ar poent :\n${renderers}",
componentShouldBe:"addFeatures : bez' e tlefe ar parzh besa\u00f1 eus ar seurt ${geomType}",getFeatureError:"Galvet eo bet getFeatureFromEvent called war ur gwiskad hep daskorer. Kement-se a dalvez ez eus bet freuzet ur gwiskad hag hoc'h eus miret un embreger bennak stag outa\u00f1.",minZoomLevelError:"Ne zleer implijout ar perzh minZoomLevel nemet evit gwiskado\u00f9 FixedZoomLevels-descendent. Ar fed ma wiria ar gwiskad WHS-se hag-e\u00f1 ez eus eus minZoomLevel zo un aspadenn gozh. Koulskoude n'omp ket evit e ziverka\u00f1 kuit da derri\u00f1 arloado\u00f9 diazezet war OL a c'hallfe beza\u00f1 stag outa\u00f1. Setu perak eo dispredet -- Lamet kuit e vo ar gwiria\u00f1 minZoomLevel a-is er stumm 3.0. Ober gant an arventenno\u00f9 bihana\u00f1/brasa\u00f1 evel deskrivet ama\u00f1 e plas : http://trac.openlayers.org/wiki/SettingZoomLevels",
commitSuccess:"Treuzgread WFS : MAT EO ${response}",commitFailed:"Treuzgread WFS Transaction: C'HWITET ${response}",googleWarning:"N'eus ket bet gallet karga\u00f1 ar gwiskad Google ent reizh.<br><br>Evit en em zizober eus ar c'hemenn-ma\u00f1, dibabit ur BaseLayer nevez en diuzer gwiskado\u00f9 er c'horn deho\u00f9 el laez.<br><br>Sur a-walc'h eo peogwir n'eo ket bet ensoc'het levraoueg Google Maps pe neuze ne glot ket an alc'hwez API gant ho lec'hienn.<br><br>Diorroerien : Evit reizha\u00f1 an dra-se, <a href='http://trac.openlayers.org/wiki/Google' target='_blank'>click here</a>",
getLayerWarning:"N'haller ket karga\u00f1 ar gwiskad ${layerType} ent reizh.<br><br>Evit en em zizober eus ar c'hemenn-ma\u00f1, dibabit ur BaseLayer nevez en diuzer gwiskado\u00f9 er c'horn deho\u00f9 el laez.<br><br>Sur a-walc'h eo peogwir n'eo ket bet ensoc'het mat al levraoueg ${layerLib}.<br><br>Diorroerien : Evit gouzout penaos reizha\u00f1 an dra-se, <a href='http://trac.openlayers.org/wiki/${layerLib}' target='_blank'>click here</a>","Scale = 1 : ${scaleDenom}":"Skeul = 1 : ${scaleDenom}",
W:"K",E:"R",N:"N",S:"S",layerAlreadyAdded:"Klasket hoc'h eus ouzhpenna\u00f1 ar gwiskad : ${layerName} d'ar gartenn, met ouzhpennet e oa bet c'hoazh",reprojectDeprecated:"Emaoc'h oc'h implijout an dibarzh 'reproject' war ar gwiskad ${layerName}. Dispredet eo an dibarzh-ma\u00f1 : bet eo hag e talveze da ziskwel roadenno\u00f9 war-c'horre kartenno\u00f9 diazez kenwerzhel, un dra hag a c'haller ober brema\u00f1 gant an arc'hwel dre skor banndres boullek Mercator. Muioc'h a ditouro\u00f9 a c'haller da gaout war http://trac.openlayers.org/wiki/SphericalMercator.",
methodDeprecated:"Dispredet eo an daore-se ha tennet e vo kuit eus ar stumm 3.0. Grit gant ${newMethod} e plas.",boundsAddError:"Rekis eo tremen an div dalvoudenn x ha y d'an arc'hwel add.",lonlatAddError:"Rekis eo tremen an div dalvoudenn hedred ha ledred d'an arc'hwel add.",pixelAddError:"Rekis eo tremen an div dalvoudenn x ha y d'an arc'hwel add.",unsupportedGeometryType:"Seurt mentoniezh anskoret : ${geomType}",filterEvaluateNotImplemented:"N'eo ket bet emplementet ar prizia\u00f1 evit seurt silo\u00f9 c'hoazh."});
OpenLayers.Format.GML.v2=OpenLayers.Class(OpenLayers.Format.GML.Base,{schemaLocation:"http://www.opengis.net/gml http://schemas.opengis.net/gml/2.1.2/feature.xsd",initialize:function(a){OpenLayers.Format.GML.Base.prototype.initialize.apply(this,[a])},readers:{gml:OpenLayers.Util.applyDefaults({outerBoundaryIs:function(a,b){var c={};this.readChildNodes(a,c);b.outer=c.components[0]},innerBoundaryIs:function(a,b){var c={};this.readChildNodes(a,c);b.inner.push(c.components[0])},Box:function(a,b){var c=
{};this.readChildNodes(a,c);if(!b.components)b.components=[];var d=c.points[0];c=c.points[1];b.components.push(new OpenLayers.Bounds(d.x,d.y,c.x,c.y))}},OpenLayers.Format.GML.Base.prototype.readers.gml),feature:OpenLayers.Format.GML.Base.prototype.readers.feature,wfs:OpenLayers.Format.GML.Base.prototype.readers.wfs},write:function(a){a=this.writeNode(OpenLayers.Util.isArray(a)?"wfs:FeatureCollection":"gml:featureMember",a);this.setAttributeNS(a,this.namespaces.xsi,"xsi:schemaLocation",this.schemaLocation);
return OpenLayers.Format.XML.prototype.write.apply(this,[a])},writers:{gml:OpenLayers.Util.applyDefaults({Point:function(a){var b=this.createElementNSPlus("gml:Point");this.writeNode("coordinates",[a],b);return b},coordinates:function(a){for(var b=a.length,c=Array(b),d,e=0;e<b;++e){d=a[e];c[e]=this.xy?d.x+","+d.y:d.y+","+d.x;if(d.z!=undefined)c[e]+=","+d.z}return this.createElementNSPlus("gml:coordinates",{attributes:{decimal:".",cs:",",ts:" "},value:b==1?c[0]:c.join(" ")})},LineString:function(a){var b=
this.createElementNSPlus("gml:LineString");this.writeNode("coordinates",a.components,b);return b},Polygon:function(a){var b=this.createElementNSPlus("gml:Polygon");this.writeNode("outerBoundaryIs",a.components[0],b);for(var c=1;c<a.components.length;++c)this.writeNode("innerBoundaryIs",a.components[c],b);return b},outerBoundaryIs:function(a){var b=this.createElementNSPlus("gml:outerBoundaryIs");this.writeNode("LinearRing",a,b);return b},innerBoundaryIs:function(a){var b=this.createElementNSPlus("gml:innerBoundaryIs");
this.writeNode("LinearRing",a,b);return b},LinearRing:function(a){var b=this.createElementNSPlus("gml:LinearRing");this.writeNode("coordinates",a.components,b);return b},Box:function(a){var b=this.createElementNSPlus("gml:Box");this.writeNode("coordinates",[{x:a.left,y:a.bottom},{x:a.right,y:a.top}],b);this.srsName&&b.setAttribute("srsName",this.srsName);return b}},OpenLayers.Format.GML.Base.prototype.writers.gml),feature:OpenLayers.Format.GML.Base.prototype.writers.feature,wfs:OpenLayers.Format.GML.Base.prototype.writers.wfs},
CLASS_NAME:"OpenLayers.Format.GML.v2"});
OpenLayers.Tile.Google=OpenLayers.Class(OpenLayers.Tile,{node:null,initialize:function(a,b,c,d){OpenLayers.Tile.prototype.initialize.apply(this,[a,b,c,null,null,d])},destroy:function(){this.node&&this.clear();this.node=null;OpenLayers.Tile.prototype.destroy.apply(this,arguments)},clone:function(a){if(a==null)a=new OpenLayers.Tile.Google(this.layer,this.position,this.bounds);OpenLayers.Util.applyDefaults(a,this);a.node=null;return a},draw:function(){var a=OpenLayers.Layer.GoogleNG.mapObject.mapTypes[this.layer.type];if(a&&
OpenLayers.Tile.prototype.draw.apply(this,arguments)){var b=this.layer.getXYZ(this.bounds),c=new google.maps.Point(b.x,b.y),d;if(this.layer.type===google.maps.MapTypeId.HYBRID)d=a.getTile(c,b.z,document);this.node=a.getTile(c,b.z,document);this.isLoading=true;this.events.triggerEvent("loadstart");this.layer.div.appendChild(this.node);OpenLayers.Util.modifyDOMElement(this.node,null,this.position,null,"absolute");window.setTimeout(OpenLayers.Function.bind(function(){this.isLoading=false;this.events&&
this.events.triggerEvent("loadend");d&&a.releaseTile(d)},this),0)}return true},clear:function(){if(this.node){this.node.parentNode&&this.node.parentNode.removeChild(this.node);OpenLayers.Layer.GoogleNG.mapObject.mapTypes[this.layer.type].releaseTile(this.node)}},CLASS_NAME:"OpenLayers.Tile.Google"});
OpenLayers.Lang.ia=OpenLayers.Util.applyDefaults({unhandledRequest:"Le responsa a un requesta non esseva maneate: ${statusText}",Permalink:"Permaligamine",Overlays:"Superpositiones","Base Layer":"Strato de base",readNotImplemented:"Lectura non implementate.",writeNotImplemented:"Scriptura non implementate.",noFID:"Non pote actualisar un elemento sin FID.",errorLoadingGML:"Error al cargamento del file GML ${url}",browserNotSupported:"Tu navigator non supporta le rendition de vectores. Le renditores actualmente supportate es:\n${renderers}",
componentShouldBe:"addFeatures: le componente debe esser del typo ${geomType}",getFeatureError:"getFeatureFromEvent ha essite appellate in un strato sin renditor. Isto significa generalmente que tu ha destruite un strato, ma lassava un gestor associate con illo.",minZoomLevelError:"Le proprietate minZoomLevel es solmente pro uso con le stratos descendente de FixedZoomLevels. Le facto que iste strato WFS verifica minZoomLevel es un reliquia del passato. Nonobstante, si nos lo remove immediatemente, nos pote rumper applicationes a base de OL que depende de illo. Ergo nos lo declara obsolete; le verification de minZoomLevel in basso essera removite in version 3.0. Per favor usa in su loco le configuration de resolutiones min/max como describite a: http://trac.openlayers.org/wiki/SettingZoomLevels",
commitSuccess:"Transaction WFS: SUCCESSO ${response}",commitFailed:"Transaction WFS: FALLEVA ${response}",googleWarning:"Le strato Google non poteva esser cargate correctemente.<br><br>Pro disfacer te de iste message, selige un nove BaseLayer in le selector de strato in alto a dextra.<br><br>Multo probabilemente, isto es proque le script del libreria de Google Maps non esseva includite o non contine le clave API correcte pro tu sito.<br><br>Disveloppatores: Pro adjuta de corriger isto, <a href='http://trac.openlayers.org/wiki/Google' target='_blank'>clicca hic</a",
getLayerWarning:"Le strato ${layerType} non poteva esser cargate correctemente.<br><br>Pro disfacer te de iste message, selige un nove BaseLayer in le selector de strato in alto a dextra.<br><br>Multo probabilemente, isto es proque le script del libreria de ${layerLib} non esseva correctemente includite.<br><br>Disveloppatores: Pro adjuta de corriger isto, <a href='http://trac.openlayers.org/wiki/${layerLib}' target='_blank'>clicca hic</a>","Scale = 1 : ${scaleDenom}":"Scala = 1 : ${scaleDenom}",
W:"W",E:"E",N:"N",S:"S",layerAlreadyAdded:"Tu tentava adder le strato: ${layerName} al carta, ma illo es ja presente",reprojectDeprecated:"Tu usa le option 'reproject' in le strato ${layerName} layer. Iste option es obsolescente: illo esseva pro poter monstrar datos super cartas de base commercial, ma iste functionalitate pote ora esser attingite con le uso de Spherical Mercator. Ulterior information es disponibile a http://trac.openlayers.org/wiki/SphericalMercator.",methodDeprecated:"Iste methodo ha essite declarate obsolescente e essera removite in version 3.0. Per favor usa ${newMethod} in su loco.",
boundsAddError:"Tu debe passar le duo valores x e y al function add.",lonlatAddError:"Tu debe passar le duo valores lon e lat al function add.",pixelAddError:"Tu debe passar le duo valores x e y al function add.",unsupportedGeometryType:"Typo de geometria non supportate: ${geomType}",filterEvaluateNotImplemented:'"evaluate" non es implementate pro iste typo de filtro.'});
OpenLayers.Layer.KaMap=OpenLayers.Class(OpenLayers.Layer.Grid,{isBaseLayer:true,units:null,resolution:OpenLayers.DOTS_PER_INCH,DEFAULT_PARAMS:{i:"jpeg",map:""},initialize:function(a,b,c,d){var e=[];e.push(a,b,c,d);OpenLayers.Layer.Grid.prototype.initialize.apply(this,e);this.params=OpenLayers.Util.applyDefaults(this.params,this.DEFAULT_PARAMS)},getURL:function(a){a=this.adjustBounds(a);var b=this.map.getResolution(),c=Math.round(this.map.getScale()*1E4)/1E4;return this.getFullRequestString({t:-Math.round(a.top/
b),l:Math.round(a.left/b),s:c})},calculateGridLayout:function(a,b,c){b=c*this.tileSize.w;c*=this.tileSize.h;var d=a.left,e=Math.floor(d/b)-this.buffer;a=a.top;var f=Math.ceil(a/c)+this.buffer;return{tilelon:b,tilelat:c,tileoffsetlon:e*b,tileoffsetlat:f*c,tileoffsetx:-(d/b-e)*this.tileSize.w,tileoffsety:-(f-a/c+1)*this.tileSize.h}},clone:function(a){if(a==null)a=new OpenLayers.Layer.KaMap(this.name,this.url,this.params,this.getOptions());a=OpenLayers.Layer.Grid.prototype.clone.apply(this,[a]);if(this.tileSize!=
null)a.tileSize=this.tileSize.clone();a.grid=[];return a},getTileBounds:function(a){var b=this.getResolution(),c=b*this.tileSize.w;b*=this.tileSize.h;var d=this.getLonLatFromViewPortPx(a);a=c*Math.floor(d.lon/c);d=b*Math.floor(d.lat/b);return new OpenLayers.Bounds(a,d,a+c,d+b)},CLASS_NAME:"OpenLayers.Layer.KaMap"});
OpenLayers.Format.WMC.v1_1_0=OpenLayers.Class(OpenLayers.Format.WMC.v1,{VERSION:"1.1.0",schemaLocation:"http://www.opengis.net/context http://schemas.opengis.net/context/1.1.0/context.xsd",initialize:function(a){OpenLayers.Format.WMC.v1.prototype.initialize.apply(this,[a])},read_sld_MinScaleDenominator:function(a,b){var c=parseFloat(this.getChildValue(b));if(c>0)a.maxScale=c},read_sld_MaxScaleDenominator:function(a,b){a.minScale=parseFloat(this.getChildValue(b))},read_wmc_SRS:function(a,b){if(!("srs"in
a))a.srs={};a.srs[this.getChildValue(b)]=true},write_wmc_Layer:function(a){var b=OpenLayers.Format.WMC.v1.prototype.write_wmc_Layer.apply(this,[a]);if(a.maxScale){var c=this.createElementNS(this.namespaces.sld,"sld:MinScaleDenominator");c.appendChild(this.createTextNode(a.maxScale.toPrecision(16)));b.appendChild(c)}if(a.minScale){c=this.createElementNS(this.namespaces.sld,"sld:MaxScaleDenominator");c.appendChild(this.createTextNode(a.minScale.toPrecision(16)));b.appendChild(c)}if(a.srs)for(var d in a.srs)b.appendChild(this.createElementDefaultNS("SRS",
d));b.appendChild(this.write_wmc_FormatList(a));b.appendChild(this.write_wmc_StyleList(a));a.dimensions&&b.appendChild(this.write_wmc_DimensionList(a));b.appendChild(this.write_wmc_LayerExtension(a));return b},CLASS_NAME:"OpenLayers.Format.WMC.v1_1_0"});OpenLayers.Format.XLS=OpenLayers.Class(OpenLayers.Format.XML.VersionedOGC,{defaultVersion:"1.1.0",stringifyOutput:true,CLASS_NAME:"OpenLayers.Format.XLS"});
OpenLayers.Format.XLS.v1=OpenLayers.Class(OpenLayers.Format.XML,{namespaces:{xls:"http://www.opengis.net/xls",gml:"http://www.opengis.net/gml",xsi:"http://www.w3.org/2001/XMLSchema-instance"},regExes:{trimSpace:/^\s*|\s*$/g,removeSpace:/\s*/g,splitSpace:/\s+/,trimComma:/\s*,\s*/g},xy:true,defaultPrefix:"xls",schemaLocation:null,initialize:function(a){OpenLayers.Format.XML.prototype.initialize.apply(this,[a])},read:function(a,b){OpenLayers.Util.applyDefaults(b,this.options);var c={};this.readChildNodes(a,
c);return c},readers:{xls:{XLS:function(a,b){b.version=a.getAttribute("version");this.readChildNodes(a,b)},Response:function(a,b){this.readChildNodes(a,b)},GeocodeResponse:function(a,b){b.responseLists=[];this.readChildNodes(a,b)},GeocodeResponseList:function(a,b){var c={features:[],numberOfGeocodedAddresses:parseInt(a.getAttribute("numberOfGeocodedAddresses"))};b.responseLists.push(c);this.readChildNodes(a,c)},GeocodedAddress:function(a,b){var c=new OpenLayers.Feature.Vector;b.features.push(c);this.readChildNodes(a,
c);c.geometry=c.components[0]},GeocodeMatchCode:function(a,b){b.attributes.matchCode={accuracy:parseFloat(a.getAttribute("accuracy")),matchType:a.getAttribute("matchType")}},Address:function(a,b){var c={countryCode:a.getAttribute("countryCode"),addressee:a.getAttribute("addressee"),street:[],place:[]};b.attributes.address=c;this.readChildNodes(a,c)},freeFormAddress:function(a,b){b.freeFormAddress=this.getChildValue(a)},StreetAddress:function(a,b){this.readChildNodes(a,b)},Building:function(a,b){b.building=
{number:a.getAttribute("number"),subdivision:a.getAttribute("subdivision"),buildingName:a.getAttribute("buildingName")}},Street:function(a,b){b.street.push(this.getChildValue(a))},Place:function(a,b){b.place[a.getAttribute("type")]=this.getChildValue(a)},PostalCode:function(a,b){b.postalCode=this.getChildValue(a)}},gml:OpenLayers.Format.GML.v3.prototype.readers.gml},write:function(a){return this.writers.xls.XLS.apply(this,[a])},writers:{xls:{XLS:function(a){var b=this.createElementNSPlus("xls:XLS",
{attributes:{version:this.VERSION,"xsi:schemaLocation":this.schemaLocation}});this.writeNode("RequestHeader",a.header,b);this.writeNode("Request",a,b);return b},RequestHeader:function(){return this.createElementNSPlus("xls:RequestHeader")},Request:function(a){var b=this.createElementNSPlus("xls:Request",{attributes:{methodName:"GeocodeRequest",requestID:a.requestID||"",version:this.VERSION}});this.writeNode("GeocodeRequest",a.addresses,b);return b},GeocodeRequest:function(a){for(var b=this.createElementNSPlus("xls:GeocodeRequest"),
c=0,d=a.length;c<d;c++)this.writeNode("Address",a[c],b);return b},Address:function(a){var b=this.createElementNSPlus("xls:Address",{attributes:{countryCode:a.countryCode}});if(a.freeFormAddress)this.writeNode("freeFormAddess",a.freeFormAddress,b);else{a.street&&this.writeNode("StreetAddress",a,b);a.municipality&&this.writeNode("Municipality",a.municipality,b);a.countrySubdivision&&this.writeNode("CountrySubdivision",a.countrySubdivision,b);a.postalCode&&this.writeNode("PostalCode",a.postalCode,b)}return b},
freeFormAddress:function(a){return this.createElementNSPlus("freeFormAddress",{value:a})},StreetAddress:function(a){var b=this.createElementNSPlus("xls:StreetAddress");a.building&&this.writeNode(b,"Building",a.building);a=a.street;OpenLayers.Util.isArray(a)||(a=[a]);for(var c=0,d=a.length;c<d;c++)this.writeNode("Street",a[c],b);return b},Building:function(a){return this.createElementNSPlus("xls:Building",{attributes:{number:a.number,subdivision:a.subdivision,buildingName:a.buildingName}})},Street:function(a){return this.createElementNSPlus("xls:Street",
{value:a})},Municipality:function(a){return this.createElementNSPlus("xls:Place",{attributes:{type:"Municipality"},value:a})},CountrySubdivision:function(a){return this.createElementNSPlus("xls:Place",{attributes:{type:"CountrySubdivision"},value:a})},PostalCode:function(a){return this.createElementNSPlus("xls:PostalCode",{value:a})}}},CLASS_NAME:"OpenLayers.Format.XLS.v1"});
OpenLayers.Format.XLS.v1_1_0=OpenLayers.Class(OpenLayers.Format.XLS.v1,{VERSION:"1.1",schemaLocation:"http://www.opengis.net/xls http://schemas.opengis.net/ols/1.1.0/LocationUtilityService.xsd",initialize:function(a){OpenLayers.Format.XLS.v1.prototype.initialize.apply(this,[a])},CLASS_NAME:"OpenLayers.Format.XLS.v1_1_0"});OpenLayers.Format.XLS.v1_1=OpenLayers.Format.XLS.v1_1_0;
OpenLayers.Lang.sk=OpenLayers.Util.applyDefaults({unhandledRequest:"Neobsl\u00fa\u017een\u00e9 po\u017eiadavky vracaj\u00fa ${statusText}",Permalink:"Trval\u00fd odkaz",Overlays:"Prekrytia","Base Layer":"Z\u00e1kladn\u00e1 vrstva",readNotImplemented:"\u010c\u00edtanie nie je implementovan\u00e9.",writeNotImplemented:"Z\u00e1pis nie je implementovan\u00fd.",noFID:"Nie je mo\u017en\u00e9 aktualizova\u0165 vlastnos\u0165, pre ktor\u00fa neexistuje FID.",errorLoadingGML:"Chyba pri na\u010d\u00edtan\u00ed s\u00faboru GML ${url}",
browserNotSupported:"V\u00e1\u0161 prehliada\u010d nepodporuje vykres\u013eovanie vektorov. Moment\u00e1lne podporovan\u00e9 vykres\u013eova\u010de s\u00fa:\n${renderers}",componentShouldBe:"addFeatures: komponent by mal by\u0165 ${geomType}",getFeatureError:"getFeatureFromEvent bola zavolan\u00e1 na vrstve bez vykres\u013eova\u010da. To zvy\u010dajne znamen\u00e1, \u017ee ste odstr\u00e1nili vrstvu, ale nie niektor\u00fa z obsl\u00fah, ktor\u00e1 je s \u0148ou asociovan\u00e1.",minZoomLevelError:"Vlastnos\u0165 minZoomLevel je ur\u010den\u00fd iba na pou\u017eitie s vrstvami odvoden\u00fdmi od FixedZoomLevels. To, \u017ee t\u00e1to wfs vrstva kontroluje minZoomLevel je pozostatok z minulosti. Nem\u00f4\u017eeme ho v\u0161ak odstr\u00e1ni\u0165, aby sme sa vyhli mo\u017en\u00e9mu poru\u0161eniu aplik\u00e1ci\u00ed zalo\u017een\u00fdch na Open Layers, ktor\u00e9 na tomto m\u00f4\u017ee z\u00e1visie\u0165. Preto ho ozna\u010dujeme ako zavrhovan\u00fd - dolu uveden\u00e1 kontrola minZoomLevel bude odstr\u00e1nen\u00e1 vo verzii 3.0. Pou\u017eite pros\u00edm namiesto toho kontrolu min./max. rozl\u00ed\u0161enia pod\u013ea tu uveden\u00e9ho popisu: http://trac.openlayers.org/wiki/SettingZoomLevels",
commitSuccess:"Transakcia WFS: \u00daSPE\u0160N\u00c1 ${response}",commitFailed:"Transakcia WFS: ZLYHALA ${response}",googleWarning:"Vrstvu Google nebolo mo\u017en\u00e9 spr\u00e1vne na\u010d\u00edta\u0165.<br><br>Aby ste sa tejto spr\u00e1vy zbavili vyberte nov\u00fa BaseLayer v prep\u00edna\u010di vrstiev v pravom hornom rohu.<br><br>Toto sa stalo pravdepodobne preto, \u017ee skript kni\u017enice Google Maps bu\u010f nebol na\u010d\u00edtan\u00fd alebo neobsahuje spr\u00e1vny k\u013e\u00fa\u010d API pre va\u0161u lokalitu.<br><br>V\u00fdvoj\u00e1ri: Tu m\u00f4\u017eete z\u00edska\u0165 <a href='http://trac.openlayers.org/wiki/Google' target='_blank'>pomoc so sfunk\u010dnen\u00edm</a>",
getLayerWarning:"Vrstvu ${layerType} nebolo mo\u017en\u00e9 spr\u00e1vne na\u010d\u00edta\u0165.<br><br>Aby ste sa tejto spr\u00e1vy zbavili vyberte nov\u00fa BaseLayer v prep\u00edna\u010di vrstiev v pravom hornom rohu.<br><br>Toto sa stalo pravdepodobne preto, \u017ee skript kni\u017enice ${layerType} bu\u010f nebol na\u010d\u00edtan\u00fd alebo neobsahuje spr\u00e1vny k\u013e\u00fa\u010d API pre va\u0161u lokalitu.<br><br>V\u00fdvoj\u00e1ri: Tu m\u00f4\u017eete z\u00edska\u0165 <a href='http://trac.openlayers.org/wiki/${layerType}' target='_blank'>pomoc so sfunk\u010dnen\u00edm</a>",
"Scale = 1 : ${scaleDenom}":"Mierka = 1 : ${scaleDenom}",layerAlreadyAdded:"Pok\u00fasili ste sa do mapy prida\u0165 vrstvu ${layerName}, ale t\u00e1 u\u017e bola pridan\u00e1",reprojectDeprecated:"Pou\u017e\u00edvate vo\u013eby \u201ereproject\u201c vrstvy ${layerType}. T\u00e1to vo\u013eba je zzavrhovan\u00e1: jej pou\u017eitie bolo navrhnut\u00e9 na podporu zobrazovania \u00fadajov nad komer\u010dn\u00fdmi z\u00e1kladov\u00fdmi mapami, ale t\u00fato funkcionalitu je teraz mo\u017en\u00e9 dosiahnu\u0165 pomocou Spherical Mercator. \u010eal\u0161ie inform\u00e1cie z\u00edskate na str\u00e1nke http://trac.openlayers.org/wiki/SphericalMercator.",
methodDeprecated:"T\u00e1to met\u00f3da je zavrhovan\u00e1 a bude odstr\u00e1nen\u00e1 vo verzii 3.0. Pou\u017eite pros\u00edm namiesto nej met\u00f3du ${newMethod}.",boundsAddError:"S\u010d\u00edtacej funkcii mus\u00edte da\u0165 hodnoty x aj y.",lonlatAddError:"S\u010d\u00edtacej funkcii mus\u00edte da\u0165 hodnoty lon (zem. d\u013a\u017eka) aj lat (zem. \u0161\u00edrka).",pixelAddError:"S\u010d\u00edtacej funkcii mus\u00edte da\u0165 hodnoty x aj y.",unsupportedGeometryType:"Nepodporovan\u00fd typ geometrie: ${geomType}",
filterEvaluateNotImplemented:"evaluate nie je implementovan\u00fd pre tento typ filtra"});
OpenLayers.Renderer.SVG=OpenLayers.Class(OpenLayers.Renderer.Elements,{xmlns:"http://www.w3.org/2000/svg",xlinkns:"http://www.w3.org/1999/xlink",MAX_PIXEL:15E3,translationParameters:null,symbolMetrics:null,initialize:function(){if(this.supported()){OpenLayers.Renderer.Elements.prototype.initialize.apply(this,arguments);this.translationParameters={x:0,y:0};this.symbolMetrics={}}},supported:function(){return document.implementation&&(document.implementation.hasFeature("org.w3c.svg","1.0")||document.implementation.hasFeature("http://www.w3.org/TR/SVG11/feature#SVG",
"1.1")||document.implementation.hasFeature("http://www.w3.org/TR/SVG11/feature#BasicStructure","1.1"))},inValidRange:function(a,b,c){a+=c?0:this.translationParameters.x;b+=c?0:this.translationParameters.y;return a>=-this.MAX_PIXEL&&a<=this.MAX_PIXEL&&b>=-this.MAX_PIXEL&&b<=this.MAX_PIXEL},setExtent:function(a,b){OpenLayers.Renderer.Elements.prototype.setExtent.apply(this,arguments);var c=this.getResolution(),d=-a.left/c;c=a.top/c;if(b){this.left=d;this.top=c;this.rendererRoot.setAttributeNS(null,
"viewBox","0 0 "+this.size.w+" "+this.size.h);this.translate(0,0);return true}else{(d=this.translate(d-this.left,c-this.top))||this.setExtent(a,true);return d}},translate:function(a,b){if(this.inValidRange(a,b,true)){var c="";if(a||b)c="translate("+a+","+b+")";this.root.setAttributeNS(null,"transform",c);this.translationParameters={x:a,y:b};return true}else return false},setSize:function(){OpenLayers.Renderer.prototype.setSize.apply(this,arguments);this.rendererRoot.setAttributeNS(null,"width",this.size.w);
this.rendererRoot.setAttributeNS(null,"height",this.size.h)},getNodeType:function(a,b){var c=null;switch(a.CLASS_NAME){case "OpenLayers.Geometry.Point":c=b.externalGraphic?"image":this.isComplexSymbol(b.graphicName)?"svg":"circle";break;case "OpenLayers.Geometry.Rectangle":c="rect";break;case "OpenLayers.Geometry.LineString":c="polyline";break;case "OpenLayers.Geometry.LinearRing":c="polygon";break;case "OpenLayers.Geometry.Polygon":case "OpenLayers.Geometry.Curve":case "OpenLayers.Geometry.Surface":c=
"path"}return c},setStyle:function(a,b,c){b=b||a._style;c=c||a._options;var d=parseFloat(a.getAttributeNS(null,"r")),e=1,f;if(a._geometryClass=="OpenLayers.Geometry.Point"&&d){a.style.visibility="";if(b.graphic===false)a.style.visibility="hidden";else if(b.externalGraphic){f=this.getPosition(a);if(b.graphicTitle){a.setAttributeNS(null,"title",b.graphicTitle);d=this.nodeFactory(null,"title");d.textContent=b.graphicTitle;a.appendChild(d)}b.graphicWidth&&b.graphicHeight&&a.setAttributeNS(null,"preserveAspectRatio",
"none");d=b.graphicWidth||b.graphicHeight;var g=b.graphicHeight||b.graphicWidth;d=d?d:b.pointRadius*2;g=g?g:b.pointRadius*2;var h=b.graphicYOffset!=undefined?b.graphicYOffset:-(0.5*g),j=b.graphicOpacity||b.fillOpacity;a.setAttributeNS(null,"x",(f.x+(b.graphicXOffset!=undefined?b.graphicXOffset:-(0.5*d))).toFixed());a.setAttributeNS(null,"y",(f.y+h).toFixed());a.setAttributeNS(null,"width",d);a.setAttributeNS(null,"height",g);a.setAttributeNS(this.xlinkns,"href",b.externalGraphic);a.setAttributeNS(null,
"style","opacity: "+j);a.onclick=OpenLayers.Renderer.SVG.preventDefault}else if(this.isComplexSymbol(b.graphicName)){d=b.pointRadius*3;g=d*2;var i=this.importSymbol(b.graphicName);f=this.getPosition(a);e=this.symbolMetrics[i.id][0]*3/g;h=a.parentNode;j=a.nextSibling;h&&h.removeChild(a);a.firstChild&&a.removeChild(a.firstChild);a.appendChild(i.firstChild.cloneNode(true));a.setAttributeNS(null,"viewBox",i.getAttributeNS(null,"viewBox"));a.setAttributeNS(null,"width",g);a.setAttributeNS(null,"height",
g);a.setAttributeNS(null,"x",f.x-d);a.setAttributeNS(null,"y",f.y-d);if(j)h.insertBefore(a,j);else h&&h.appendChild(a)}else a.setAttributeNS(null,"r",b.pointRadius);d=b.rotation;if((d!==undefined||a._rotation!==undefined)&&f){a._rotation=d;d|=0;if(a.nodeName!=="svg")a.setAttributeNS(null,"transform","rotate("+d+" "+f.x+" "+f.y+")");else{f=this.symbolMetrics[i.id];a.firstChild.setAttributeNS(null,"transform","rotate("+d+" "+f[1]+" "+f[2]+")")}}}if(c.isFilled){a.setAttributeNS(null,"fill",b.fillColor);
a.setAttributeNS(null,"fill-opacity",b.fillOpacity)}else a.setAttributeNS(null,"fill","none");if(c.isStroked){a.setAttributeNS(null,"stroke",b.strokeColor);a.setAttributeNS(null,"stroke-opacity",b.strokeOpacity);a.setAttributeNS(null,"stroke-width",b.strokeWidth*e);a.setAttributeNS(null,"stroke-linecap",b.strokeLinecap||"round");a.setAttributeNS(null,"stroke-linejoin","round");b.strokeDashstyle&&a.setAttributeNS(null,"stroke-dasharray",this.dashStyle(b,e))}else a.setAttributeNS(null,"stroke","none");
b.pointerEvents&&a.setAttributeNS(null,"pointer-events",b.pointerEvents);b.cursor!=null&&a.setAttributeNS(null,"cursor",b.cursor);return a},dashStyle:function(a,b){var c=a.strokeWidth*b,d=a.strokeDashstyle;switch(d){case "solid":return"none";case "dot":return[1,4*c].join();case "dash":return[4*c,4*c].join();case "dashdot":return[4*c,4*c,1,4*c].join();case "longdash":return[8*c,4*c].join();case "longdashdot":return[8*c,4*c,1,4*c].join();default:return OpenLayers.String.trim(d).replace(/\s+/g,",")}},
createNode:function(a,b){var c=document.createElementNS(this.xmlns,a);b&&c.setAttributeNS(null,"id",b);return c},nodeTypeCompare:function(a,b){return b==a.nodeName},createRenderRoot:function(){return this.nodeFactory(this.container.id+"_svgRoot","svg")},createRoot:function(a){return this.nodeFactory(this.container.id+a,"g")},createDefs:function(){var a=this.nodeFactory(this.container.id+"_defs","defs");this.rendererRoot.appendChild(a);return a},drawPoint:function(a,b){return this.drawCircle(a,b,1)},
drawCircle:function(a,b,c){var d=this.getResolution(),e=b.x/d+this.left;b=this.top-b.y/d;if(this.inValidRange(e,b)){a.setAttributeNS(null,"cx",e);a.setAttributeNS(null,"cy",b);a.setAttributeNS(null,"r",c);return a}else return false},drawLineString:function(a,b){var c=this.getComponentsString(b.components);if(c.path){a.setAttributeNS(null,"points",c.path);return c.complete?a:null}else return false},drawLinearRing:function(a,b){var c=this.getComponentsString(b.components);if(c.path){a.setAttributeNS(null,
"points",c.path);return c.complete?a:null}else return false},drawPolygon:function(a,b){for(var c="",d=true,e=true,f,g,h=0,j=b.components.length;h<j;h++){c+=" M";f=this.getComponentsString(b.components[h].components," ");if(g=f.path){c+=" "+g;e=f.complete&&e}else d=false}c+=" z";if(d){a.setAttributeNS(null,"d",c);a.setAttributeNS(null,"fill-rule","evenodd");return e?a:null}else return false},drawRectangle:function(a,b){var c=this.getResolution(),d=b.x/c+this.left,e=this.top-b.y/c;if(this.inValidRange(d,
e)){a.setAttributeNS(null,"x",d);a.setAttributeNS(null,"y",e);a.setAttributeNS(null,"width",b.width/c);a.setAttributeNS(null,"height",b.height/c);return a}else return false},drawSurface:function(a,b){for(var c=null,d=true,e=0,f=b.components.length;e<f;e++)if(e%3==0&&e/3==0){var g=this.getShortString(b.components[e]);g||(d=false);c="M "+g}else if(e%3==1){(g=this.getShortString(b.components[e]))||(d=false);c+=" C "+g}else{(g=this.getShortString(b.components[e]))||(d=false);c+=" "+g}c+=" Z";if(d){a.setAttributeNS(null,
"d",c);return a}else return false},drawText:function(a,b,c){var d=this.getResolution(),e=c.x/d+this.left,f=c.y/d-this.top;d=this.nodeFactory(a+this.LABEL_ID_SUFFIX,"text");d.setAttributeNS(null,"x",e);d.setAttributeNS(null,"y",-f);b.fontColor&&d.setAttributeNS(null,"fill",b.fontColor);b.fontOpacity&&d.setAttributeNS(null,"opacity",b.fontOpacity);b.fontFamily&&d.setAttributeNS(null,"font-family",b.fontFamily);b.fontSize&&d.setAttributeNS(null,"font-size",b.fontSize);b.fontWeight&&d.setAttributeNS(null,
"font-weight",b.fontWeight);b.fontStyle&&d.setAttributeNS(null,"font-style",b.fontStyle);if(b.labelSelect===true){d.setAttributeNS(null,"pointer-events","visible");d._featureId=a}else d.setAttributeNS(null,"pointer-events","none");f=b.labelAlign||"cm";d.setAttributeNS(null,"text-anchor",OpenLayers.Renderer.SVG.LABEL_ALIGN[f[0]]||"middle");if(OpenLayers.IS_GECKO===true)d.setAttributeNS(null,"dominant-baseline",OpenLayers.Renderer.SVG.LABEL_ALIGN[f[1]]||"central");for(var g=b.label.split("\n"),h=g.length;d.childNodes.length>
h;)d.removeChild(d.lastChild);for(var j=0;j<h;j++){var i=this.nodeFactory(a+this.LABEL_ID_SUFFIX+"_tspan_"+j,"tspan");if(b.labelSelect===true){i._featureId=a;i._geometry=c;i._geometryClass=c.CLASS_NAME}if(OpenLayers.IS_GECKO===false)i.setAttributeNS(null,"baseline-shift",OpenLayers.Renderer.SVG.LABEL_VSHIFT[f[1]]||"-35%");i.setAttribute("x",e);if(j==0){var k=OpenLayers.Renderer.SVG.LABEL_VFACTOR[f[1]];if(k==null)k=-0.5;i.setAttribute("dy",k*(h-1)+"em")}else i.setAttribute("dy","1em");i.textContent=
g[j]===""?" ":g[j];i.parentNode||d.appendChild(i)}d.parentNode||this.textRoot.appendChild(d)},getComponentsString:function(a,b){for(var c=[],d=true,e=a.length,f=[],g,h=0;h<e;h++){g=a[h];c.push(g);if(g=this.getShortString(g))f.push(g);else{h>0&&this.getShortString(a[h-1])&&f.push(this.clipLine(a[h],a[h-1]));h<e-1&&this.getShortString(a[h+1])&&f.push(this.clipLine(a[h],a[h+1]));d=false}}return{path:f.join(b||","),complete:d}},clipLine:function(a,b){if(b.equals(a))return"";var c=this.getResolution(),
d=this.MAX_PIXEL-this.translationParameters.x,e=this.MAX_PIXEL-this.translationParameters.y,f=b.x/c+this.left,g=this.top-b.y/c,h=a.x/c+this.left;c=this.top-a.y/c;var j;if(h<-d||h>d){j=(c-g)/(h-f);h=h<0?-d:d;c=g+(h-f)*j}if(c<-e||c>e){j=(h-f)/(c-g);c=c<0?-e:e;h=f+(c-g)*j}return h+","+c},getShortString:function(a){var b=this.getResolution(),c=a.x/b+this.left;a=this.top-a.y/b;return this.inValidRange(c,a)?c+","+a:false},getPosition:function(a){return{x:parseFloat(a.getAttributeNS(null,"cx")),y:parseFloat(a.getAttributeNS(null,
"cy"))}},importSymbol:function(a){if(!this.defs)this.defs=this.createDefs();var b=this.container.id+"-"+a,c=document.getElementById(b);if(c!=null)return c;var d=OpenLayers.Renderer.symbol[a];if(!d)throw Error(a+" is not a valid symbol name");a=this.nodeFactory(b,"symbol");var e=this.nodeFactory(null,"polygon");a.appendChild(e);c=new OpenLayers.Bounds(Number.MAX_VALUE,Number.MAX_VALUE,0,0);for(var f=[],g,h,j=0;j<d.length;j+=2){g=d[j];h=d[j+1];c.left=Math.min(c.left,g);c.bottom=Math.min(c.bottom,h);
c.right=Math.max(c.right,g);c.top=Math.max(c.top,h);f.push(g,",",h)}e.setAttributeNS(null,"points",f.join(" "));d=c.getWidth();e=c.getHeight();a.setAttributeNS(null,"viewBox",[c.left-d,c.bottom-e,d*3,e*3].join(" "));this.symbolMetrics[b]=[Math.max(d,e),c.getCenterLonLat().lon,c.getCenterLonLat().lat];this.defs.appendChild(a);return a},getFeatureIdFromEvent:function(a){var b=OpenLayers.Renderer.Elements.prototype.getFeatureIdFromEvent.apply(this,arguments);if(!b){b=a.target;b=b.parentNode&&b!=this.rendererRoot&&
b.parentNode._featureId}return b},CLASS_NAME:"OpenLayers.Renderer.SVG"});OpenLayers.Renderer.SVG.LABEL_ALIGN={l:"start",r:"end",b:"bottom",t:"hanging"};OpenLayers.Renderer.SVG.LABEL_VSHIFT={t:"-70%",b:"0"};OpenLayers.Renderer.SVG.LABEL_VFACTOR={t:0,b:-1};OpenLayers.Renderer.SVG.preventDefault=function(a){a.preventDefault&&a.preventDefault()};OpenLayers.Symbolizer.Point=OpenLayers.Class(OpenLayers.Symbolizer,{initialize:function(){OpenLayers.Symbolizer.prototype.initialize.apply(this,arguments)},CLASS_NAME:"OpenLayers.Symbolizer.Point"});
OpenLayers.Symbolizer.Text=OpenLayers.Class(OpenLayers.Symbolizer,{initialize:function(){OpenLayers.Symbolizer.prototype.initialize.apply(this,arguments)},CLASS_NAME:"OpenLayers.Symbolizer.Text"});
OpenLayers.Rule=OpenLayers.Class({id:null,name:null,title:null,description:null,context:null,filter:null,elseFilter:false,symbolizer:null,symbolizers:null,minScaleDenominator:null,maxScaleDenominator:null,initialize:function(a){this.symbolizer={};OpenLayers.Util.extend(this,a);this.symbolizers&&delete this.symbolizer;this.id=OpenLayers.Util.createUniqueID(this.CLASS_NAME+"_")},destroy:function(){for(var a in this.symbolizer)this.symbolizer[a]=null;this.symbolizer=null;delete this.symbolizers},evaluate:function(a){var b=
this.getContext(a),c=true;if(this.minScaleDenominator||this.maxScaleDenominator)var d=a.layer.map.getScale();if(this.minScaleDenominator)c=d>=OpenLayers.Style.createLiteral(this.minScaleDenominator,b);if(c&&this.maxScaleDenominator)c=d<OpenLayers.Style.createLiteral(this.maxScaleDenominator,b);if(c&&this.filter)c=this.filter.CLASS_NAME=="OpenLayers.Filter.FeatureId"?this.filter.evaluate(a):this.filter.evaluate(b);return c},getContext:function(a){var b=this.context;b||(b=a.attributes||a.data);if(typeof this.context==
"function")b=this.context(a);return b},clone:function(){var a=OpenLayers.Util.extend({},this);if(this.symbolizers){var b=this.symbolizers.length;a.symbolizers=Array(b);for(var c=0;c<b;++c)a.symbolizers[c]=this.symbolizers[c].clone()}else{a.symbolizer={};for(var d in this.symbolizer){b=this.symbolizer[d];c=typeof b;if(c==="object")a.symbolizer[d]=OpenLayers.Util.extend({},b);else if(c==="string")a.symbolizer[d]=b}}a.filter=this.filter&&this.filter.clone();a.context=this.context&&OpenLayers.Util.extend({},
this.context);return new OpenLayers.Rule(a)},CLASS_NAME:"OpenLayers.Rule"});OpenLayers.Format.SLD=OpenLayers.Class(OpenLayers.Format.XML.VersionedOGC,{defaultVersion:"1.0.0",stringifyOutput:true,namedLayersAsArray:false,CLASS_NAME:"OpenLayers.Format.SLD"});
OpenLayers.Format.Filter.v1_0_0=OpenLayers.Class(OpenLayers.Format.GML.v2,OpenLayers.Format.Filter.v1,{VERSION:"1.0.0",schemaLocation:"http://www.opengis.net/ogc/filter/1.0.0/filter.xsd",initialize:function(a){OpenLayers.Format.GML.v2.prototype.initialize.apply(this,[a])},readers:{ogc:OpenLayers.Util.applyDefaults({PropertyIsEqualTo:function(a,b){var c=new OpenLayers.Filter.Comparison({type:OpenLayers.Filter.Comparison.EQUAL_TO});this.readChildNodes(a,c);b.filters.push(c)},PropertyIsNotEqualTo:function(a,
b){var c=new OpenLayers.Filter.Comparison({type:OpenLayers.Filter.Comparison.NOT_EQUAL_TO});this.readChildNodes(a,c);b.filters.push(c)},PropertyIsLike:function(a,b){var c=new OpenLayers.Filter.Comparison({type:OpenLayers.Filter.Comparison.LIKE});this.readChildNodes(a,c);var d=a.getAttribute("wildCard"),e=a.getAttribute("singleChar"),f=a.getAttribute("escape");c.value2regex(d,e,f);b.filters.push(c)}},OpenLayers.Format.Filter.v1.prototype.readers.ogc),gml:OpenLayers.Format.GML.v2.prototype.readers.gml,
feature:OpenLayers.Format.GML.v2.prototype.readers.feature},writers:{ogc:OpenLayers.Util.applyDefaults({PropertyIsEqualTo:function(a){var b=this.createElementNSPlus("ogc:PropertyIsEqualTo");this.writeNode("PropertyName",a,b);this.writeOgcExpression(a.value,b);return b},PropertyIsNotEqualTo:function(a){var b=this.createElementNSPlus("ogc:PropertyIsNotEqualTo");this.writeNode("PropertyName",a,b);this.writeOgcExpression(a.value,b);return b},PropertyIsLike:function(a){var b=this.createElementNSPlus("ogc:PropertyIsLike",
{attributes:{wildCard:"*",singleChar:".",escape:"!"}});this.writeNode("PropertyName",a,b);this.writeNode("Literal",a.regex2value(),b);return b},BBOX:function(a){var b=this.createElementNSPlus("ogc:BBOX");a.property&&this.writeNode("PropertyName",a,b);var c=this.writeNode("gml:Box",a.value,b);a.projection&&c.setAttribute("srsName",a.projection);return b}},OpenLayers.Format.Filter.v1.prototype.writers.ogc),gml:OpenLayers.Format.GML.v2.prototype.writers.gml,feature:OpenLayers.Format.GML.v2.prototype.writers.feature},
writeSpatial:function(a,b){var c=this.createElementNSPlus("ogc:"+b);this.writeNode("PropertyName",a,c);if(a.value instanceof OpenLayers.Filter.Function)this.writeNode("Function",a.value,c);else{var d;d=a.value instanceof OpenLayers.Geometry?this.writeNode("feature:_geometry",a.value).firstChild:this.writeNode("gml:Box",a.value);a.projection&&d.setAttribute("srsName",a.projection);c.appendChild(d)}return c},CLASS_NAME:"OpenLayers.Format.Filter.v1_0_0"});
OpenLayers.Format.SLD.v1=OpenLayers.Class(OpenLayers.Format.Filter.v1_0_0,{namespaces:{sld:"http://www.opengis.net/sld",ogc:"http://www.opengis.net/ogc",gml:"http://www.opengis.net/gml",xlink:"http://www.w3.org/1999/xlink",xsi:"http://www.w3.org/2001/XMLSchema-instance"},defaultPrefix:"sld",schemaLocation:null,multipleSymbolizers:false,featureTypeCounter:null,defaultSymbolizer:{fillColor:"#808080",fillOpacity:1,strokeColor:"#000000",strokeOpacity:1,strokeWidth:1,strokeDashstyle:"solid",pointRadius:3,
graphicName:"square"},initialize:function(a){OpenLayers.Format.Filter.v1_0_0.prototype.initialize.apply(this,[a])},read:function(a,b){b=OpenLayers.Util.applyDefaults(b,this.options);var c={namedLayers:b.namedLayersAsArray===true?[]:{}};this.readChildNodes(a,c);return c},readers:OpenLayers.Util.applyDefaults({sld:{StyledLayerDescriptor:function(a,b){b.version=a.getAttribute("version");this.readChildNodes(a,b)},Name:function(a,b){b.name=this.getChildValue(a)},Title:function(a,b){b.title=this.getChildValue(a)},
Abstract:function(a,b){b.description=this.getChildValue(a)},NamedLayer:function(a,b){var c={userStyles:[],namedStyles:[]};this.readChildNodes(a,c);for(var d=0,e=c.userStyles.length;d<e;++d)c.userStyles[d].layerName=c.name;if(OpenLayers.Util.isArray(b.namedLayers))b.namedLayers.push(c);else b.namedLayers[c.name]=c},NamedStyle:function(a,b){b.namedStyles.push(this.getChildName(a.firstChild))},UserStyle:function(a,b){var c={defaultsPerSymbolizer:true,rules:[]};this.featureTypeCounter=-1;this.readChildNodes(a,
c);if(this.multipleSymbolizers){delete c.defaultsPerSymbolizer;c=new OpenLayers.Style2(c)}else c=new OpenLayers.Style(this.defaultSymbolizer,c);b.userStyles.push(c)},IsDefault:function(a,b){if(this.getChildValue(a)=="1")b.isDefault=true},FeatureTypeStyle:function(a,b){++this.featureTypeCounter;var c={rules:this.multipleSymbolizers?b.rules:[]};this.readChildNodes(a,c);if(!this.multipleSymbolizers)b.rules=c.rules},Rule:function(a,b){var c;if(this.multipleSymbolizers)c={symbolizers:[]};c=new OpenLayers.Rule(c);
this.readChildNodes(a,c);b.rules.push(c)},ElseFilter:function(a,b){b.elseFilter=true},MinScaleDenominator:function(a,b){b.minScaleDenominator=parseFloat(this.getChildValue(a))},MaxScaleDenominator:function(a,b){b.maxScaleDenominator=parseFloat(this.getChildValue(a))},TextSymbolizer:function(a,b){var c={};this.readChildNodes(a,c);if(this.multipleSymbolizers){c.zIndex=this.featureTypeCounter;b.symbolizers.push(new OpenLayers.Symbolizer.Text(c))}else b.symbolizer.Text=OpenLayers.Util.applyDefaults(c,
b.symbolizer.Text)},Label:function(a,b){var c={};this.readChildNodes(a,c);if(c.property)b.label="${"+c.property+"}";else if(c=this.readOgcExpression(a))b.label=c},Font:function(a,b){this.readChildNodes(a,b)},Halo:function(a,b){var c={};this.readChildNodes(a,c);b.haloRadius=c.haloRadius;b.haloColor=c.fillColor;b.haloOpacity=c.fillOpacity},Radius:function(a,b){var c=this.readOgcExpression(a);if(c!=null)b.haloRadius=c},RasterSymbolizer:function(a,b){var c={};this.readChildNodes(a,c);if(this.multipleSymbolizers){c.zIndex=
this.featureTypeCounter;b.symbolizers.push(new OpenLayers.Symbolizer.Raster(c))}else b.symbolizer.Raster=OpenLayers.Util.applyDefaults(c,b.symbolizer.Raster)},Geometry:function(a,b){b.geometry={};this.readChildNodes(a,b.geometry)},ColorMap:function(a,b){b.colorMap=[];this.readChildNodes(a,b.colorMap)},ColorMapEntry:function(a,b){var c=a.getAttribute("quantity"),d=a.getAttribute("opacity");b.push({color:a.getAttribute("color"),quantity:c!==null?parseFloat(c):undefined,label:a.getAttribute("label")||
undefined,opacity:d!==null?parseFloat(d):undefined})},LineSymbolizer:function(a,b){var c={};this.readChildNodes(a,c);if(this.multipleSymbolizers){c.zIndex=this.featureTypeCounter;b.symbolizers.push(new OpenLayers.Symbolizer.Line(c))}else b.symbolizer.Line=OpenLayers.Util.applyDefaults(c,b.symbolizer.Line)},PolygonSymbolizer:function(a,b){var c={fill:false,stroke:false};this.multipleSymbolizers||(c=b.symbolizer.Polygon||c);this.readChildNodes(a,c);if(this.multipleSymbolizers){c.zIndex=this.featureTypeCounter;
b.symbolizers.push(new OpenLayers.Symbolizer.Polygon(c))}else b.symbolizer.Polygon=c},PointSymbolizer:function(a,b){var c={fill:false,stroke:false,graphic:false};this.multipleSymbolizers||(c=b.symbolizer.Point||c);this.readChildNodes(a,c);if(this.multipleSymbolizers){c.zIndex=this.featureTypeCounter;b.symbolizers.push(new OpenLayers.Symbolizer.Point(c))}else b.symbolizer.Point=c},Stroke:function(a,b){b.stroke=true;this.readChildNodes(a,b)},Fill:function(a,b){b.fill=true;this.readChildNodes(a,b)},
CssParameter:function(a,b){var c=this.cssMap[a.getAttribute("name")];if(c){var d=this.readOgcExpression(a);if(d)b[c]=d}},Graphic:function(a,b){b.graphic=true;var c={};this.readChildNodes(a,c);for(var d=["stroke","strokeColor","strokeWidth","strokeOpacity","strokeLinecap","fill","fillColor","fillOpacity","graphicName","rotation","graphicFormat"],e,f,g=0,h=d.length;g<h;++g){e=d[g];f=c[e];if(f!=undefined)b[e]=f}if(c.opacity!=undefined)b.graphicOpacity=c.opacity;if(c.size!=undefined)b.pointRadius=c.size/
2;if(c.href!=undefined)b.externalGraphic=c.href;if(c.rotation!=undefined)b.rotation=c.rotation},ExternalGraphic:function(a,b){this.readChildNodes(a,b)},Mark:function(a,b){this.readChildNodes(a,b)},WellKnownName:function(a,b){b.graphicName=this.getChildValue(a)},Opacity:function(a,b){var c=this.readOgcExpression(a);if(c)b.opacity=c},Size:function(a,b){var c=this.readOgcExpression(a);if(c)b.size=c},Rotation:function(a,b){var c=this.readOgcExpression(a);if(c)b.rotation=c},OnlineResource:function(a,b){b.href=
this.getAttributeNS(a,this.namespaces.xlink,"href")},Format:function(a,b){b.graphicFormat=this.getChildValue(a)}}},OpenLayers.Format.Filter.v1_0_0.prototype.readers),cssMap:{stroke:"strokeColor","stroke-opacity":"strokeOpacity","stroke-width":"strokeWidth","stroke-linecap":"strokeLinecap","stroke-dasharray":"strokeDashstyle",fill:"fillColor","fill-opacity":"fillOpacity","font-family":"fontFamily","font-size":"fontSize","font-weight":"fontWeight","font-style":"fontStyle"},getCssProperty:function(a){var b=
null,c;for(c in this.cssMap)if(this.cssMap[c]==a){b=c;break}return b},getGraphicFormat:function(a){var b,c;for(c in this.graphicFormats)if(this.graphicFormats[c].test(a)){b=c;break}return b||this.defautlGraphicFormat},defaultGraphicFormat:"image/png",graphicFormats:{"image/jpeg":/\.jpe?g$/i,"image/gif":/\.gif$/i,"image/png":/\.png$/i},write:function(a){return this.writers.sld.StyledLayerDescriptor.apply(this,[a])},writers:OpenLayers.Util.applyDefaults({sld:{StyledLayerDescriptor:function(a){var b=
this.createElementNSPlus("sld:StyledLayerDescriptor",{attributes:{version:this.VERSION,"xsi:schemaLocation":this.schemaLocation}});b.setAttribute("xmlns:ogc",this.namespaces.ogc);b.setAttribute("xmlns:gml",this.namespaces.gml);a.name&&this.writeNode("Name",a.name,b);a.title&&this.writeNode("Title",a.title,b);a.description&&this.writeNode("Abstract",a.description,b);if(OpenLayers.Util.isArray(a.namedLayers))for(var c=0,d=a.namedLayers.length;c<d;++c)this.writeNode("NamedLayer",a.namedLayers[c],b);
else for(c in a.namedLayers)this.writeNode("NamedLayer",a.namedLayers[c],b);return b},Name:function(a){return this.createElementNSPlus("sld:Name",{value:a})},Title:function(a){return this.createElementNSPlus("sld:Title",{value:a})},Abstract:function(a){return this.createElementNSPlus("sld:Abstract",{value:a})},NamedLayer:function(a){var b=this.createElementNSPlus("sld:NamedLayer");this.writeNode("Name",a.name,b);if(a.namedStyles)for(var c=0,d=a.namedStyles.length;c<d;++c)this.writeNode("NamedStyle",
a.namedStyles[c],b);if(a.userStyles){c=0;for(d=a.userStyles.length;c<d;++c)this.writeNode("UserStyle",a.userStyles[c],b)}return b},NamedStyle:function(a){var b=this.createElementNSPlus("sld:NamedStyle");this.writeNode("Name",a,b);return b},UserStyle:function(a){var b=this.createElementNSPlus("sld:UserStyle");a.name&&this.writeNode("Name",a.name,b);a.title&&this.writeNode("Title",a.title,b);a.description&&this.writeNode("Abstract",a.description,b);a.isDefault&&this.writeNode("IsDefault",a.isDefault,
b);if(this.multipleSymbolizers&&a.rules){for(var c={0:[]},d=[0],e,f,g,h,j,i=0,k=a.rules.length;i<k;++i){e=a.rules[i];if(e.symbolizers){f={};for(var l=0,m=e.symbolizers.length;l<m;++l){g=e.symbolizers[l];h=g.zIndex;if(!(h in f)){j=e.clone();j.symbolizers=[];f[h]=j}f[h].symbolizers.push(g.clone())}for(h in f){if(!(h in c)){d.push(h);c[h]=[]}c[h].push(f[h])}}else c[0].push(e.clone())}d.sort();i=0;for(k=d.length;i<k;++i){e=c[d[i]];if(e.length>0){j=a.clone();j.rules=c[d[i]];this.writeNode("FeatureTypeStyle",
j,b)}}}else this.writeNode("FeatureTypeStyle",a,b);return b},IsDefault:function(a){return this.createElementNSPlus("sld:IsDefault",{value:a?"1":"0"})},FeatureTypeStyle:function(a){for(var b=this.createElementNSPlus("sld:FeatureTypeStyle"),c=0,d=a.rules.length;c<d;++c)this.writeNode("Rule",a.rules[c],b);return b},Rule:function(a){var b=this.createElementNSPlus("sld:Rule");a.name&&this.writeNode("Name",a.name,b);a.title&&this.writeNode("Title",a.title,b);a.description&&this.writeNode("Abstract",a.description,
b);if(a.elseFilter)this.writeNode("ElseFilter",null,b);else a.filter&&this.writeNode("ogc:Filter",a.filter,b);a.minScaleDenominator!=undefined&&this.writeNode("MinScaleDenominator",a.minScaleDenominator,b);a.maxScaleDenominator!=undefined&&this.writeNode("MaxScaleDenominator",a.maxScaleDenominator,b);var c,d;if(this.multipleSymbolizers&&a.symbolizers)for(var e=0,f=a.symbolizers.length;e<f;++e){d=a.symbolizers[e];c=d.CLASS_NAME.split(".").pop();this.writeNode(c+"Symbolizer",d,b)}else{f=OpenLayers.Style.SYMBOLIZER_PREFIXES;
e=0;for(var g=f.length;e<g;++e){c=f[e];(d=a.symbolizer[c])&&this.writeNode(c+"Symbolizer",d,b)}}return b},ElseFilter:function(){return this.createElementNSPlus("sld:ElseFilter")},MinScaleDenominator:function(a){return this.createElementNSPlus("sld:MinScaleDenominator",{value:a})},MaxScaleDenominator:function(a){return this.createElementNSPlus("sld:MaxScaleDenominator",{value:a})},LineSymbolizer:function(a){var b=this.createElementNSPlus("sld:LineSymbolizer");this.writeNode("Stroke",a,b);return b},
Stroke:function(a){var b=this.createElementNSPlus("sld:Stroke");a.strokeColor!=undefined&&this.writeNode("CssParameter",{symbolizer:a,key:"strokeColor"},b);a.strokeOpacity!=undefined&&this.writeNode("CssParameter",{symbolizer:a,key:"strokeOpacity"},b);a.strokeWidth!=undefined&&this.writeNode("CssParameter",{symbolizer:a,key:"strokeWidth"},b);a.strokeDashstyle!=undefined&&a.strokeDashstyle!=="solid"&&this.writeNode("CssParameter",{symbolizer:a,key:"strokeDashstyle"},b);a.strokeLinecap!=undefined&&
this.writeNode("CssParameter",{symbolizer:a,key:"strokeLinecap"},b);return b},CssParameter:function(a){return this.createElementNSPlus("sld:CssParameter",{attributes:{name:this.getCssProperty(a.key)},value:a.symbolizer[a.key]})},TextSymbolizer:function(a){var b=this.createElementNSPlus("sld:TextSymbolizer");a.label!=null&&this.writeNode("Label",a.label,b);if(a.fontFamily!=null||a.fontSize!=null||a.fontWeight!=null||a.fontStyle!=null)this.writeNode("Font",a,b);if(a.haloRadius!=null||a.haloColor!=null||
a.haloOpacity!=null)this.writeNode("Halo",a,b);if(a.fillColor!=null||a.fillOpacity!=null)this.writeNode("Fill",a,b);return b},Font:function(a){var b=this.createElementNSPlus("sld:Font");a.fontFamily&&this.writeNode("CssParameter",{symbolizer:a,key:"fontFamily"},b);a.fontSize&&this.writeNode("CssParameter",{symbolizer:a,key:"fontSize"},b);a.fontWeight&&this.writeNode("CssParameter",{symbolizer:a,key:"fontWeight"},b);a.fontStyle&&this.writeNode("CssParameter",{symbolizer:a,key:"fontStyle"},b);return b},
Label:function(a){var b=this.createElementNSPlus("sld:Label");a=a.split("${");b.appendChild(this.createTextNode(a[0]));for(var c,d,e=1,f=a.length;e<f;e++){c=a[e];d=c.indexOf("}");if(d>0){this.writeNode("ogc:PropertyName",{property:c.substring(0,d)},b);b.appendChild(this.createTextNode(c.substring(++d)))}else b.appendChild(this.createTextNode("${"+c))}return b},Halo:function(a){var b=this.createElementNSPlus("sld:Halo");a.haloRadius&&this.writeNode("Radius",a.haloRadius,b);if(a.haloColor||a.haloOpacity)this.writeNode("Fill",
{fillColor:a.haloColor,fillOpacity:a.haloOpacity},b);return b},Radius:function(a){return this.createElementNSPlus("sld:Radius",{value:a})},RasterSymbolizer:function(a){var b=this.createElementNSPlus("sld:RasterSymbolizer");a.geometry&&this.writeNode("Geometry",a.geometry,b);a.opacity&&this.writeNode("Opacity",a.opacity,b);a.colorMap&&this.writeNode("ColorMap",a.colorMap,b);return b},Geometry:function(a){var b=this.createElementNSPlus("sld:Geometry");a.property&&this.writeNode("ogc:PropertyName",a,
b);return b},ColorMap:function(a){for(var b=this.createElementNSPlus("sld:ColorMap"),c=0,d=a.length;c<d;++c)this.writeNode("ColorMapEntry",a[c],b);return b},ColorMapEntry:function(a){var b=this.createElementNSPlus("sld:ColorMapEntry");b.setAttribute("color",a.color);a.opacity!==undefined&&b.setAttribute("opacity",parseFloat(a.opacity));a.quantity!==undefined&&b.setAttribute("quantity",parseFloat(a.quantity));a.label!==undefined&&b.setAttribute("label",a.label);return b},PolygonSymbolizer:function(a){var b=
this.createElementNSPlus("sld:PolygonSymbolizer");a.fill!==false&&this.writeNode("Fill",a,b);a.stroke!==false&&this.writeNode("Stroke",a,b);return b},Fill:function(a){var b=this.createElementNSPlus("sld:Fill");a.fillColor&&this.writeNode("CssParameter",{symbolizer:a,key:"fillColor"},b);a.fillOpacity!=null&&this.writeNode("CssParameter",{symbolizer:a,key:"fillOpacity"},b);return b},PointSymbolizer:function(a){var b=this.createElementNSPlus("sld:PointSymbolizer");this.writeNode("Graphic",a,b);return b},
Graphic:function(a){var b=this.createElementNSPlus("sld:Graphic");a.externalGraphic!=undefined?this.writeNode("ExternalGraphic",a,b):this.writeNode("Mark",a,b);a.graphicOpacity!=undefined&&this.writeNode("Opacity",a.graphicOpacity,b);a.pointRadius!=undefined&&this.writeNode("Size",a.pointRadius*2,b);a.rotation!=undefined&&this.writeNode("Rotation",a.rotation,b);return b},ExternalGraphic:function(a){var b=this.createElementNSPlus("sld:ExternalGraphic");this.writeNode("OnlineResource",a.externalGraphic,
b);this.writeNode("Format",a.graphicFormat||this.getGraphicFormat(a.externalGraphic),b);return b},Mark:function(a){var b=this.createElementNSPlus("sld:Mark");a.graphicName&&this.writeNode("WellKnownName",a.graphicName,b);a.fill!==false&&this.writeNode("Fill",a,b);a.stroke!==false&&this.writeNode("Stroke",a,b);return b},WellKnownName:function(a){return this.createElementNSPlus("sld:WellKnownName",{value:a})},Opacity:function(a){return this.createElementNSPlus("sld:Opacity",{value:a})},Size:function(a){return this.createElementNSPlus("sld:Size",
{value:a})},Rotation:function(a){return this.createElementNSPlus("sld:Rotation",{value:a})},OnlineResource:function(a){return this.createElementNSPlus("sld:OnlineResource",{attributes:{"xlink:type":"simple","xlink:href":a}})},Format:function(a){return this.createElementNSPlus("sld:Format",{value:a})}}},OpenLayers.Format.Filter.v1_0_0.prototype.writers),CLASS_NAME:"OpenLayers.Format.SLD.v1"});
OpenLayers.Format.SLD.v1_0_0=OpenLayers.Class(OpenLayers.Format.SLD.v1,{VERSION:"1.0.0",schemaLocation:"http://www.opengis.net/sld http://schemas.opengis.net/sld/1.0.0/StyledLayerDescriptor.xsd",initialize:function(a){OpenLayers.Format.SLD.v1.prototype.initialize.apply(this,[a])},CLASS_NAME:"OpenLayers.Format.SLD.v1_0_0"});
OpenLayers.Format.OWSContext=OpenLayers.Class(OpenLayers.Format.Context,{defaultVersion:"0.3.1",getVersion:function(){var a=OpenLayers.Format.XML.VersionedOGC.prototype.getVersion.apply(this,arguments);if(a==="0.3.0")a=this.defaultVersion;return a},toContext:function(a){var b={};if(a.CLASS_NAME=="OpenLayers.Map"){b.bounds=a.getExtent();b.maxExtent=a.maxExtent;b.projection=a.projection;b.size=a.getSize();b.layers=a.layers}return b},CLASS_NAME:"OpenLayers.Format.OWSContext"});
OpenLayers.Format.OWSContext.v0_3_1=OpenLayers.Class(OpenLayers.Format.XML,{namespaces:{owc:"http://www.opengis.net/ows-context",gml:"http://www.opengis.net/gml",kml:"http://www.opengis.net/kml/2.2",ogc:"http://www.opengis.net/ogc",ows:"http://www.opengis.net/ows",sld:"http://www.opengis.net/sld",xlink:"http://www.w3.org/1999/xlink",xsi:"http://www.w3.org/2001/XMLSchema-instance"},VERSION:"0.3.1",schemaLocation:"http://www.opengis.net/ows-context http://www.ogcnetwork.net/schemas/owc/0.3.1/owsContext.xsd",
defaultPrefix:"owc",extractAttributes:true,xy:true,regExes:{trimSpace:/^\s*|\s*$/g,removeSpace:/\s*/g,splitSpace:/\s+/,trimComma:/\s*,\s*/g},featureNS:"http://mapserver.gis.umn.edu/mapserver",featureType:"vector",geometryName:"geometry",nestingLayerLookup:null,initialize:function(a){OpenLayers.Format.XML.prototype.initialize.apply(this,[a]);OpenLayers.Format.GML.v2.prototype.setGeometryTypes.call(this)},setNestingPath:function(a){if(a.layersContext)for(var b=0,c=a.layersContext.length;b<c;b++){var d=
a.layersContext[b],e=[],f=a.title||"";if(a.metadata&&a.metadata.nestingPath)e=a.metadata.nestingPath.slice();f!=""&&e.push(f);d.metadata.nestingPath=e;d.layersContext&&this.setNestingPath(d)}},decomposeNestingPath:function(a){var b=[];if(OpenLayers.Util.isArray(a)){for(a=a.slice();a.length>0;){b.push(a.slice());a.pop()}b.reverse()}return b},read:function(a){if(typeof a=="string")a=OpenLayers.Format.XML.prototype.read.apply(this,[a]);if(a&&a.nodeType==9)a=a.documentElement;var b={};this.readNode(a,
b);this.setNestingPath({layersContext:b.layersContext});a=[];this.processLayer(a,b);delete b.layersContext;b.layersContext=a;return b},processLayer:function(a,b){if(b.layersContext)for(var c=0,d=b.layersContext.length;c<d;c++){var e=b.layersContext[c];a.push(e);e.layersContext&&this.processLayer(a,e)}},write:function(a,b){this.nestingLayerLookup={};b=b||{};OpenLayers.Util.applyDefaults(b,a);var c=this.writeNode("OWSContext",b);this.nestingLayerLookup=null;this.setAttributeNS(c,this.namespaces.xsi,
"xsi:schemaLocation",this.schemaLocation);return OpenLayers.Format.XML.prototype.write.apply(this,[c])},readers:{kml:{Document:function(a,b){b.features=(new OpenLayers.Format.KML({kmlns:this.namespaces.kml,extractStyles:true})).read(a)}},owc:{OWSContext:function(a,b){this.readChildNodes(a,b)},General:function(a,b){this.readChildNodes(a,b)},ResourceList:function(a,b){this.readChildNodes(a,b)},Layer:function(a,b){var c={metadata:{},visibility:a.getAttribute("hidden")!="1",queryable:a.getAttribute("queryable")==
"1",opacity:a.getAttribute("opacity")!=null?parseFloat(a.getAttribute("opacity")):null,name:a.getAttribute("name"),categoryLayer:a.getAttribute("name")==null,formats:[],styles:[]};if(!b.layersContext)b.layersContext=[];b.layersContext.push(c);this.readChildNodes(a,c)},InlineGeometry:function(a,b){b.features=[];var c=this.getElementsByTagNameNS(a,this.namespaces.gml,"featureMember"),d;if(c.length>=1)d=c[0];if(d&&d.firstChild){c=d.firstChild.nextSibling?d.firstChild.nextSibling:d.firstChild;this.setNamespace("feature",
c.namespaceURI);this.featureType=c.localName||c.nodeName.split(":").pop();this.readChildNodes(a,b)}},Server:function(a,b){if(!b.service&&!b.version||b.service!=OpenLayers.Format.Context.serviceTypes.WMS){b.service=a.getAttribute("service");b.version=a.getAttribute("version");this.readChildNodes(a,b)}},Name:function(a,b){b.name=this.getChildValue(a);this.readChildNodes(a,b)},Title:function(a,b){b.title=this.getChildValue(a);this.readChildNodes(a,b)},StyleList:function(a,b){this.readChildNodes(a,b.styles)},
Style:function(a,b){var c={};b.push(c);this.readChildNodes(a,c)},LegendURL:function(a,b){var c={};b.legend=c;this.readChildNodes(a,c)},OnlineResource:function(a,b){b.url=this.getAttributeNS(a,this.namespaces.xlink,"href");this.readChildNodes(a,b)}},ows:OpenLayers.Format.OWSCommon.v1_0_0.prototype.readers.ows,gml:OpenLayers.Format.GML.v2.prototype.readers.gml,sld:OpenLayers.Format.SLD.v1_0_0.prototype.readers.sld,feature:OpenLayers.Format.GML.v2.prototype.readers.feature},writers:{owc:{OWSContext:function(a){var b=
this.createElementNSPlus("OWSContext",{attributes:{version:this.VERSION,id:a.id||OpenLayers.Util.createUniqueID("OpenLayers_OWSContext_")}});this.writeNode("General",a,b);this.writeNode("ResourceList",a,b);return b},General:function(a){var b=this.createElementNSPlus("General");this.writeNode("ows:BoundingBox",a,b);this.writeNode("ows:Title",a.title||"OpenLayers OWSContext",b);return b},ResourceList:function(a){for(var b=this.createElementNSPlus("ResourceList"),c=0,d=a.layers.length;c<d;c++){var e=
a.layers[c],f=this.decomposeNestingPath(e.metadata.nestingPath);this.writeNode("_Layer",{layer:e,subPaths:f},b)}return b},Server:function(a){var b=this.createElementNSPlus("Server",{attributes:{version:a.version,service:a.service}});this.writeNode("OnlineResource",a,b);return b},OnlineResource:function(a){return this.createElementNSPlus("OnlineResource",{attributes:{"xlink:href":a.url}})},InlineGeometry:function(a){var b=this.createElementNSPlus("InlineGeometry");this.writeNode("gml:boundedBy",a.getDataExtent(),
b);for(var c=0,d=a.features.length;c<d;c++)this.writeNode("gml:featureMember",a.features[c],b);return b},StyleList:function(a){for(var b=this.createElementNSPlus("StyleList"),c=0,d=a.length;c<d;c++)this.writeNode("Style",a[c],b);return b},Style:function(a){var b=this.createElementNSPlus("Style");this.writeNode("Name",a,b);this.writeNode("Title",a,b);a.legend&&this.writeNode("LegendURL",a,b);return b},Name:function(a){return this.createElementNSPlus("Name",{value:a.name})},Title:function(a){return this.createElementNSPlus("Title",
{value:a.title})},LegendURL:function(a){var b=this.createElementNSPlus("LegendURL");this.writeNode("OnlineResource",a.legend,b);return b},_WMS:function(a){var b=this.createElementNSPlus("Layer",{attributes:{name:a.params.LAYERS,queryable:a.queryable?"1":"0",hidden:a.visibility?"0":"1",opacity:a.hasOwnProperty("opacity")?a.opacity:null}});this.writeNode("ows:Title",a.name,b);this.writeNode("ows:OutputFormat",a.params.FORMAT,b);this.writeNode("Server",{service:OpenLayers.Format.Context.serviceTypes.WMS,
version:a.params.VERSION,url:a.url},b);a.metadata.styles&&a.metadata.styles.length>0&&this.writeNode("StyleList",a.metadata.styles,b);return b},_Layer:function(a){var b,c,d;b=a.layer;c=a.subPaths;d=null;if(c.length>0){b=c[0].join("/");c=b.lastIndexOf("/");d=this.nestingLayerLookup[b];c=c>0?b.substring(c+1,b.length):b;if(!d){d=this.createElementNSPlus("Layer");this.writeNode("ows:Title",c,d);this.nestingLayerLookup[b]=d}a.subPaths.shift();this.writeNode("_Layer",a,d)}else{if(b instanceof OpenLayers.Layer.WMS)d=
this.writeNode("_WMS",b);else if(b instanceof OpenLayers.Layer.Vector)if(b.protocol instanceof OpenLayers.Protocol.WFS.v1)d=this.writeNode("_WFS",b);else if(b.protocol instanceof OpenLayers.Protocol.HTTP)if(b.protocol.format instanceof OpenLayers.Format.GML){b.protocol.format.version="2.1.2";d=this.writeNode("_GML",b)}else{if(b.protocol.format instanceof OpenLayers.Format.KML){b.protocol.format.version="2.2";d=this.writeNode("_KML",b)}}else{this.setNamespace("feature",this.featureNS);d=this.writeNode("_InlineGeometry",
b)}b.options.maxScale&&this.writeNode("sld:MinScaleDenominator",b.options.maxScale,d);b.options.minScale&&this.writeNode("sld:MaxScaleDenominator",b.options.minScale,d);this.nestingLayerLookup[b.name]=d}return d},_WFS:function(a){var b=this.createElementNSPlus("Layer",{attributes:{name:a.protocol.featurePrefix+":"+a.protocol.featureType,hidden:a.visibility?"0":"1"}});this.writeNode("ows:Title",a.name,b);this.writeNode("Server",{service:OpenLayers.Format.Context.serviceTypes.WFS,version:a.protocol.version,
url:a.protocol.url},b);return b},_InlineGeometry:function(a){var b=this.createElementNSPlus("Layer",{attributes:{name:this.featureType,hidden:a.visibility?"0":"1"}});this.writeNode("ows:Title",a.name,b);this.writeNode("InlineGeometry",a,b);return b},_GML:function(a){var b=this.createElementNSPlus("Layer");this.writeNode("ows:Title",a.name,b);this.writeNode("Server",{service:OpenLayers.Format.Context.serviceTypes.GML,url:a.protocol.url,version:a.protocol.format.version},b);return b},_KML:function(a){var b=
this.createElementNSPlus("Layer");this.writeNode("ows:Title",a.name,b);this.writeNode("Server",{service:OpenLayers.Format.Context.serviceTypes.KML,version:a.protocol.format.version,url:a.protocol.url},b);return b}},gml:OpenLayers.Util.applyDefaults({boundedBy:function(a){var b=this.createElementNSPlus("gml:boundedBy");this.writeNode("gml:Box",a,b);return b}},OpenLayers.Format.GML.v2.prototype.writers.gml),ows:OpenLayers.Format.OWSCommon.v1_0_0.prototype.writers.ows,sld:OpenLayers.Format.SLD.v1_0_0.prototype.writers.sld,
feature:OpenLayers.Format.GML.v2.prototype.writers.feature},CLASS_NAME:"OpenLayers.Format.OWSContext.v0_3_1"});
OpenLayers.Control.ScaleLine=OpenLayers.Class(OpenLayers.Control,{maxWidth:100,topOutUnits:"km",topInUnits:"m",bottomOutUnits:"mi",bottomInUnits:"ft",eTop:null,eBottom:null,geodesic:false,draw:function(){OpenLayers.Control.prototype.draw.apply(this,arguments);if(!this.eTop){this.eTop=document.createElement("div");this.eTop.className=this.displayClass+"Top";this.div.appendChild(this.eTop);this.eTop.style.visibility=this.topOutUnits==""||this.topInUnits==""?"hidden":"visible";this.eBottom=document.createElement("div");
this.eBottom.className=this.displayClass+"Bottom";this.div.appendChild(this.eBottom);this.eBottom.style.visibility=this.bottomOutUnits==""||this.bottomInUnits==""?"hidden":"visible"}this.map.events.register("moveend",this,this.update);this.update();return this.div},getBarLen:function(a){var b=parseInt(Math.log(a)/Math.log(10));b=Math.pow(10,b);a=parseInt(a/b);return(a>5?5:a>2?2:1)*b},update:function(){var a=this.map.getResolution();if(a){var b=this.map.getUnits(),c=OpenLayers.INCHES_PER_UNIT,d=this.maxWidth*
a*c[b],e=1;if(this.geodesic===true){e=(this.map.getGeodesicPixelSize().w||1.0E-6)*this.maxWidth/(d/c.km);d*=e}var f,g;if(d>1E5){f=this.topOutUnits;g=this.bottomOutUnits}else{f=this.topInUnits;g=this.bottomInUnits}var h=d/c[f];d/=c[g];var j=this.getBarLen(h),i=this.getBarLen(d);h=j/c[b]*c[f];d=i/c[b]*c[g];if(this.eBottom.style.visibility=="visible"){this.eBottom.style.width=Math.round(d/a/e)+"px";this.eBottom.innerHTML=i+" "+g}if(this.eTop.style.visibility=="visible"){this.eTop.style.width=Math.round(h/
a/e)+"px";this.eTop.innerHTML=j+" "+f}}},CLASS_NAME:"OpenLayers.Control.ScaleLine"});
OpenLayers.Icon=OpenLayers.Class({url:null,size:null,offset:null,calculateOffset:null,imageDiv:null,px:null,initialize:function(a,b,c,d){this.url=a;this.size=b?b:new OpenLayers.Size(20,20);this.offset=c?c:new OpenLayers.Pixel(-(this.size.w/2),-(this.size.h/2));this.calculateOffset=d;a=OpenLayers.Util.createUniqueID("OL_Icon_");this.imageDiv=OpenLayers.Util.createAlphaImageDiv(a)},destroy:function(){this.erase();OpenLayers.Event.stopObservingElement(this.imageDiv.firstChild);this.imageDiv.innerHTML=
"";this.imageDiv=null},clone:function(){return new OpenLayers.Icon(this.url,this.size,this.offset,this.calculateOffset)},setSize:function(a){if(a!=null)this.size=a;this.draw()},setUrl:function(a){if(a!=null)this.url=a;this.draw()},draw:function(a){OpenLayers.Util.modifyAlphaImageDiv(this.imageDiv,null,null,this.size,this.url,"absolute");this.moveTo(a);return this.imageDiv},erase:function(){this.imageDiv!=null&&this.imageDiv.parentNode!=null&&OpenLayers.Element.remove(this.imageDiv)},setOpacity:function(a){OpenLayers.Util.modifyAlphaImageDiv(this.imageDiv,
null,null,null,null,null,null,null,a)},moveTo:function(a){if(a!=null)this.px=a;if(this.imageDiv!=null)if(this.px==null)this.display(false);else{if(this.calculateOffset)this.offset=this.calculateOffset(this.size);a=this.px.offset(this.offset);OpenLayers.Util.modifyAlphaImageDiv(this.imageDiv,null,a)}},display:function(a){this.imageDiv.style.display=a?"":"none"},isDrawn:function(){return this.imageDiv&&this.imageDiv.parentNode&&this.imageDiv.parentNode.nodeType!=11},CLASS_NAME:"OpenLayers.Icon"});
OpenLayers.Marker=OpenLayers.Class({icon:null,lonlat:null,events:null,map:null,initialize:function(a,b){this.lonlat=a;var c=b?b:OpenLayers.Marker.defaultIcon();if(this.icon==null)this.icon=c;else{this.icon.url=c.url;this.icon.size=c.size;this.icon.offset=c.offset;this.icon.calculateOffset=c.calculateOffset}this.events=new OpenLayers.Events(this,this.icon.imageDiv,null)},destroy:function(){this.erase();this.map=null;this.events.destroy();this.events=null;if(this.icon!=null){this.icon.destroy();this.icon=
null}},draw:function(a){return this.icon.draw(a)},erase:function(){this.icon!=null&&this.icon.erase()},moveTo:function(a){a!=null&&this.icon!=null&&this.icon.moveTo(a);this.lonlat=this.map.getLonLatFromLayerPx(a)},isDrawn:function(){return this.icon&&this.icon.isDrawn()},onScreen:function(){var a=false;if(this.map)a=this.map.getExtent().containsLonLat(this.lonlat);return a},inflate:function(a){this.icon&&this.icon.setSize(new OpenLayers.Size(this.icon.size.w*a,this.icon.size.h*a))},setOpacity:function(a){this.icon.setOpacity(a)},
setUrl:function(a){this.icon.setUrl(a)},display:function(a){this.icon.display(a)},CLASS_NAME:"OpenLayers.Marker"});OpenLayers.Marker.defaultIcon=function(){var a=OpenLayers.Util.getImagesLocation()+"marker.png",b=new OpenLayers.Size(21,25);return new OpenLayers.Icon(a,b,null,function(c){return new OpenLayers.Pixel(-(c.w/2),-c.h)})};
OpenLayers.Layer.TileCache=OpenLayers.Class(OpenLayers.Layer.Grid,{isBaseLayer:true,format:"image/png",serverResolutions:null,initialize:function(a,b,c,d){this.layername=c;OpenLayers.Layer.Grid.prototype.initialize.apply(this,[a,b,{},d]);this.extension=this.format.split("/")[1].toLowerCase();this.extension=this.extension=="jpg"?"jpeg":this.extension},clone:function(a){if(a==null)a=new OpenLayers.Layer.TileCache(this.name,this.url,this.layername,this.getOptions());return a=OpenLayers.Layer.Grid.prototype.clone.apply(this,
[a])},getURL:function(a){function b(g,h){g=String(g);for(var j=[],i=0;i<h;++i)j.push("0");return j.join("").substring(0,h-g.length)+g}var c=this.map.getResolution(),d=this.maxExtent,e=this.tileSize,f=Math.round((a.left-d.left)/(c*e.w));a=Math.round((a.bottom-d.bottom)/(c*e.h));c=this.serverResolutions!=null?OpenLayers.Util.indexOf(this.serverResolutions,c):this.map.getZoom();f=[this.layername,b(c,2),b(parseInt(f/1E6),3),b(parseInt(f/1E3)%1E3,3),b(parseInt(f)%1E3,3),b(parseInt(a/1E6),3),b(parseInt(a/
1E3)%1E3,3),b(parseInt(a)%1E3,3)+"."+this.extension].join("/");c=this.url;if(OpenLayers.Util.isArray(c))c=this.selectUrl(f,c);c=c.charAt(c.length-1)=="/"?c:c+"/";return c+f},CLASS_NAME:"OpenLayers.Layer.TileCache"});
OpenLayers.Strategy.Paging=OpenLayers.Class(OpenLayers.Strategy,{features:null,length:10,num:null,paging:false,activate:function(){var a=OpenLayers.Strategy.prototype.activate.call(this);if(a)this.layer.events.on({beforefeaturesadded:this.cacheFeatures,scope:this});return a},deactivate:function(){var a=OpenLayers.Strategy.prototype.deactivate.call(this);if(a){this.clearCache();this.layer.events.un({beforefeaturesadded:this.cacheFeatures,scope:this})}return a},cacheFeatures:function(a){if(!this.paging){this.clearCache();
this.features=a.features;this.pageNext(a)}},clearCache:function(){if(this.features)for(var a=0;a<this.features.length;++a)this.features[a].destroy();this.num=this.features=null},pageCount:function(){return Math.ceil((this.features?this.features.length:0)/this.length)},pageNum:function(){return this.num},pageLength:function(a){if(a&&a>0)this.length=a;return this.length},pageNext:function(a){var b=false;if(this.features){if(this.num===null)this.num=-1;b=this.page((this.num+1)*this.length,a)}return b},
pagePrevious:function(){var a=false;if(this.features){if(this.num===null)this.num=this.pageCount();a=this.page((this.num-1)*this.length)}return a},page:function(a,b){var c=false;if(this.features)if(a>=0&&a<this.features.length){var d=Math.floor(a/this.length);if(d!=this.num){this.paging=true;c=this.features.slice(a,a+this.length);this.layer.removeFeatures(this.layer.features);this.num=d;if(b&&b.features)b.features=c;else this.layer.addFeatures(c);this.paging=false;c=true}}return c},CLASS_NAME:"OpenLayers.Strategy.Paging"});
OpenLayers.Layer.XYZ=OpenLayers.Class(OpenLayers.Layer.Grid,{isBaseLayer:true,sphericalMercator:false,zoomOffset:0,serverResolutions:null,initialize:function(a,b,c){if(c&&c.sphericalMercator||this.sphericalMercator)c=OpenLayers.Util.extend({maxExtent:new OpenLayers.Bounds(-2.003750834E7,-2.003750834E7,2.003750834E7,2.003750834E7),maxResolution:156543.03390625,numZoomLevels:19,units:"m",projection:"EPSG:900913"},c);b=b||this.url;a=a||this.name;OpenLayers.Layer.Grid.prototype.initialize.apply(this,
[a,b,{},c])},clone:function(a){if(a==null)a=new OpenLayers.Layer.XYZ(this.name,this.url,this.getOptions());return a=OpenLayers.Layer.Grid.prototype.clone.apply(this,[a])},getURL:function(a){a=this.getXYZ(a);var b=this.url;if(OpenLayers.Util.isArray(b))b=this.selectUrl(""+a.x+a.y+a.z,b);return OpenLayers.String.format(b,a)},getXYZ:function(a){var b=this.map.getResolution(),c=Math.round((a.left-this.maxExtent.left)/(b*this.tileSize.w));a=Math.round((this.maxExtent.top-a.top)/(b*this.tileSize.h));b=
this.serverResolutions!=null?OpenLayers.Util.indexOf(this.serverResolutions,b):this.map.getZoom()+this.zoomOffset;var d=Math.pow(2,b);if(this.wrapDateLine)c=(c%d+d)%d;return{x:c,y:a,z:b}},setMap:function(){OpenLayers.Layer.Grid.prototype.setMap.apply(this,arguments);if(!this.tileOrigin)this.tileOrigin=new OpenLayers.LonLat(this.maxExtent.left,this.maxExtent.bottom)},CLASS_NAME:"OpenLayers.Layer.XYZ"});
OpenLayers.Layer.OSM=OpenLayers.Class(OpenLayers.Layer.XYZ,{name:"OpenStreetMap",attribution:"Data CC-By-SA by <a href='http://openstreetmap.org/'>OpenStreetMap</a>",sphericalMercator:true,url:"http://tile.openstreetmap.org/${z}/${x}/${y}.png",clone:function(a){if(a==null)a=new OpenLayers.Layer.OSM(this.name,this.url,this.getOptions());return a=OpenLayers.Layer.XYZ.prototype.clone.apply(this,[a])},wrapDateLine:true,CLASS_NAME:"OpenLayers.Layer.OSM"});
OpenLayers.Handler.Box=OpenLayers.Class(OpenLayers.Handler,{dragHandler:null,boxDivClassName:"olHandlerBoxZoomBox",boxOffsets:null,initialize:function(){OpenLayers.Handler.prototype.initialize.apply(this,arguments);this.dragHandler=new OpenLayers.Handler.Drag(this,{down:this.startBox,move:this.moveBox,out:this.removeBox,up:this.endBox},{keyMask:this.keyMask})},destroy:function(){OpenLayers.Handler.prototype.destroy.apply(this,arguments);if(this.dragHandler){this.dragHandler.destroy();this.dragHandler=
null}},setMap:function(a){OpenLayers.Handler.prototype.setMap.apply(this,arguments);this.dragHandler&&this.dragHandler.setMap(a)},startBox:function(){this.callback("start",[]);this.zoomBox=OpenLayers.Util.createDiv("zoomBox",new OpenLayers.Pixel(-9999,-9999));this.zoomBox.className=this.boxDivClassName;this.zoomBox.style.zIndex=this.map.Z_INDEX_BASE.Popup-1;this.map.eventsDiv.appendChild(this.zoomBox);OpenLayers.Element.addClass(this.map.eventsDiv,"olDrawBox")},moveBox:function(a){var b=this.dragHandler.start.x,
c=this.dragHandler.start.y,d=Math.abs(b-a.x),e=Math.abs(c-a.y),f=this.getBoxOffsets();this.zoomBox.style.width=d+f.width+1+"px";this.zoomBox.style.height=e+f.height+1+"px";this.zoomBox.style.left=(a.x<b?b-d-f.left:b-f.left)+"px";this.zoomBox.style.top=(a.y<c?c-e-f.top:c-f.top)+"px"},endBox:function(a){if(Math.abs(this.dragHandler.start.x-a.x)>5||Math.abs(this.dragHandler.start.y-a.y)>5){var b=this.dragHandler.start;a=new OpenLayers.Bounds(Math.min(b.x,a.x),Math.max(b.y,a.y),Math.max(b.x,a.x),Math.min(b.y,
a.y))}else a=this.dragHandler.start.clone();this.removeBox();this.callback("done",[a])},removeBox:function(){this.map.eventsDiv.removeChild(this.zoomBox);this.boxOffsets=this.zoomBox=null;OpenLayers.Element.removeClass(this.map.eventsDiv,"olDrawBox")},activate:function(){if(OpenLayers.Handler.prototype.activate.apply(this,arguments)){this.dragHandler.activate();return true}else return false},deactivate:function(){if(OpenLayers.Handler.prototype.deactivate.apply(this,arguments)){this.dragHandler.deactivate()&&
this.zoomBox&&this.removeBox();return true}else return false},getBoxOffsets:function(){if(!this.boxOffsets){var a=document.createElement("div");a.style.position="absolute";a.style.border="1px solid black";a.style.width="3px";document.body.appendChild(a);var b=a.clientWidth==3;document.body.removeChild(a);a=parseInt(OpenLayers.Element.getStyle(this.zoomBox,"border-left-width"));var c=parseInt(OpenLayers.Element.getStyle(this.zoomBox,"border-right-width")),d=parseInt(OpenLayers.Element.getStyle(this.zoomBox,
"border-top-width")),e=parseInt(OpenLayers.Element.getStyle(this.zoomBox,"border-bottom-width"));this.boxOffsets={left:a,right:c,top:d,bottom:e,width:b===false?a+c:0,height:b===false?d+e:0}}return this.boxOffsets},CLASS_NAME:"OpenLayers.Handler.Box"});
OpenLayers.Control.ZoomBox=OpenLayers.Class(OpenLayers.Control,{type:OpenLayers.Control.TYPE_TOOL,out:false,alwaysZoom:false,draw:function(){this.handler=new OpenLayers.Handler.Box(this,{done:this.zoomBox},{keyMask:this.keyMask})},zoomBox:function(a){if(a instanceof OpenLayers.Bounds){var b;if(this.out){b=Math.min(this.map.size.h/Math.abs(a.top-a.bottom),this.map.size.w/Math.abs(a.right-a.left));var c=this.map.getExtent(),d=this.map.getLonLatFromPixel(a.getCenterPixel());a=d.lon-c.getWidth()/2*b;
var e=d.lon+c.getWidth()/2*b,f=d.lat-c.getHeight()/2*b;b=d.lat+c.getHeight()/2*b;b=new OpenLayers.Bounds(a,f,e,b)}else{b=this.map.getLonLatFromPixel(new OpenLayers.Pixel(a.left,a.bottom));c=this.map.getLonLatFromPixel(new OpenLayers.Pixel(a.right,a.top));b=new OpenLayers.Bounds(b.lon,b.lat,c.lon,c.lat)}c=this.map.getZoom();this.map.zoomToExtent(b);if(c==this.map.getZoom()&&this.alwaysZoom==true)this.map.zoomTo(c+(this.out?-1:1))}else this.out?this.map.setCenter(this.map.getLonLatFromPixel(a),this.map.getZoom()-
1):this.map.setCenter(this.map.getLonLatFromPixel(a),this.map.getZoom()+1)},CLASS_NAME:"OpenLayers.Control.ZoomBox"});
OpenLayers.Control.DragPan=OpenLayers.Class(OpenLayers.Control,{type:OpenLayers.Control.TYPE_TOOL,panned:false,interval:1,documentDrag:false,kinetic:null,enableKinetic:false,kineticInterval:10,draw:function(){if(this.enableKinetic){var a={interval:this.kineticInterval};if(typeof this.enableKinetic==="object")a=OpenLayers.Util.extend(a,this.enableKinetic);this.kinetic=new OpenLayers.Kinetic(a)}this.handler=new OpenLayers.Handler.Drag(this,{move:this.panMap,done:this.panMapDone,down:this.panMapStart},
{interval:this.interval,documentDrag:this.documentDrag})},panMapStart:function(){this.kinetic&&this.kinetic.begin()},panMap:function(a){this.kinetic&&this.kinetic.update(a);this.panned=true;this.map.pan(this.handler.last.x-a.x,this.handler.last.y-a.y,{dragging:true,animate:false})},panMapDone:function(a){if(this.panned){var b=null;if(this.kinetic)b=this.kinetic.end(a);this.map.pan(this.handler.last.x-a.x,this.handler.last.y-a.y,{dragging:!!b,animate:false});if(b){var c=this;this.kinetic.move(b,function(d,
e,f){c.map.pan(d,e,{dragging:!f,animate:false})})}this.panned=false}},CLASS_NAME:"OpenLayers.Control.DragPan"});
OpenLayers.Handler.Click=OpenLayers.Class(OpenLayers.Handler,{delay:300,single:true,"double":false,pixelTolerance:0,dblclickTolerance:13,stopSingle:false,stopDouble:false,timerId:null,touch:false,down:null,last:null,first:null,rightclickTimerId:null,initialize:function(){OpenLayers.Handler.prototype.initialize.apply(this,arguments)},touchstart:function(a){if(!this.touch){this.unregisterMouseListeners();this.touch=true}this.down=this.getEventInfo(a);this.last=this.getEventInfo(a);return true},touchmove:function(a){this.last=
this.getEventInfo(a);return true},touchend:function(a){if(this.down){a.xy=this.last.xy;a.lastTouches=this.last.touches;this.handleSingle(a);this.down=null}return true},unregisterMouseListeners:function(){this.map.events.un({mousedown:this.mousedown,mouseup:this.mouseup,click:this.click,dblclick:this.dblclick,scope:this})},mousedown:function(a){this.down=this.getEventInfo(a);this.last=this.getEventInfo(a);return true},mouseup:function(a){var b=true;if(this.checkModifiers(a)&&this.control.handleRightClicks&&
OpenLayers.Event.isRightClick(a))b=this.rightclick(a);return b},rightclick:function(a){if(this.passesTolerance(a))if(this.rightclickTimerId!=null){this.clearTimer();this.callback("dblrightclick",[a]);return!this.stopDouble}else{a=this["double"]?OpenLayers.Util.extend({},a):this.callback("rightclick",[a]);a=OpenLayers.Function.bind(this.delayedRightCall,this,a);this.rightclickTimerId=window.setTimeout(a,this.delay)}return!this.stopSingle},delayedRightCall:function(a){this.rightclickTimerId=null;a&&
this.callback("rightclick",[a])},click:function(a){if(!this.last)this.last=this.getEventInfo(a);this.handleSingle(a);return!this.stopSingle},dblclick:function(a){this.handleDouble(a);return!this.stopDouble},handleDouble:function(a){this["double"]&&this.passesDblclickTolerance(a)&&this.callback("dblclick",[a])},handleSingle:function(a){if(this.passesTolerance(a))if(this.timerId!=null){if(this.last.touches&&this.last.touches.length===1){this["double"]&&OpenLayers.Event.stop(a);this.handleDouble(a)}if(!this.last.touches||
this.last.touches.length!==2)this.clearTimer()}else{this.first=this.getEventInfo(a);this.queuePotentialClick(this.single?OpenLayers.Util.extend({},a):null)}},queuePotentialClick:function(a){this.timerId=window.setTimeout(OpenLayers.Function.bind(this.delayedCall,this,a),this.delay)},passesTolerance:function(a){var b=true;if(this.pixelTolerance!=null&&this.down&&this.down.xy)if((b=this.pixelTolerance>=this.down.xy.distanceTo(a.xy))&&this.touch&&this.down.touches.length===this.last.touches.length){a=
0;for(var c=this.down.touches.length;a<c;++a)if(this.getTouchDistance(this.down.touches[a],this.last.touches[a])>this.pixelTolerance){b=false;break}}return b},getTouchDistance:function(a,b){return Math.sqrt(Math.pow(a.clientX-b.clientX,2)+Math.pow(a.clientY-b.clientY,2))},passesDblclickTolerance:function(){var a=true;if(this.down&&this.first)a=this.down.xy.distanceTo(this.first.xy)<=this.dblclickTolerance;return a},clearTimer:function(){if(this.timerId!=null){window.clearTimeout(this.timerId);this.timerId=
null}if(this.rightclickTimerId!=null){window.clearTimeout(this.rightclickTimerId);this.rightclickTimerId=null}},delayedCall:function(a){this.timerId=null;a&&this.callback("click",[a])},getEventInfo:function(a){var b;if(a.touches){var c=a.touches.length;b=Array(c);for(var d,e=0;e<c;e++){d=a.touches[e];b[e]={clientX:d.clientX,clientY:d.clientY}}}return{xy:a.xy,touches:b}},deactivate:function(){var a=false;if(OpenLayers.Handler.prototype.deactivate.apply(this,arguments)){this.clearTimer();this.last=
this.first=this.down=null;this.touch=false;a=true}return a},CLASS_NAME:"OpenLayers.Handler.Click"});
OpenLayers.Control.Navigation=OpenLayers.Class(OpenLayers.Control,{dragPan:null,dragPanOptions:null,pinchZoom:null,pinchZoomOptions:null,documentDrag:false,zoomBox:null,zoomBoxEnabled:true,zoomWheelEnabled:true,mouseWheelOptions:null,handleRightClicks:false,zoomBoxKeyMask:OpenLayers.Handler.MOD_SHIFT,autoActivate:true,initialize:function(){this.handlers={};OpenLayers.Control.prototype.initialize.apply(this,arguments)},destroy:function(){this.deactivate();this.dragPan&&this.dragPan.destroy();this.dragPan=
null;this.zoomBox&&this.zoomBox.destroy();this.zoomBox=null;this.pinchZoom&&this.pinchZoom.destroy();this.pinchZoom=null;OpenLayers.Control.prototype.destroy.apply(this,arguments)},activate:function(){this.dragPan.activate();this.zoomWheelEnabled&&this.handlers.wheel.activate();this.handlers.click.activate();this.zoomBoxEnabled&&this.zoomBox.activate();this.pinchZoom&&this.pinchZoom.activate();return OpenLayers.Control.prototype.activate.apply(this,arguments)},deactivate:function(){this.pinchZoom&&
this.pinchZoom.deactivate();this.zoomBox.deactivate();this.dragPan.deactivate();this.handlers.click.deactivate();this.handlers.wheel.deactivate();return OpenLayers.Control.prototype.deactivate.apply(this,arguments)},draw:function(){if(this.handleRightClicks)this.map.viewPortDiv.oncontextmenu=OpenLayers.Function.False;this.handlers.click=new OpenLayers.Handler.Click(this,{click:this.defaultClick,dblclick:this.defaultDblClick,dblrightclick:this.defaultDblRightClick},{"double":true,stopDouble:true});
this.dragPan=new OpenLayers.Control.DragPan(OpenLayers.Util.extend({map:this.map,documentDrag:this.documentDrag},this.dragPanOptions));this.zoomBox=new OpenLayers.Control.ZoomBox({map:this.map,keyMask:this.zoomBoxKeyMask});this.dragPan.draw();this.zoomBox.draw();this.handlers.wheel=new OpenLayers.Handler.MouseWheel(this,{up:this.wheelUp,down:this.wheelDown},this.mouseWheelOptions);if(OpenLayers.Control.PinchZoom)this.pinchZoom=new OpenLayers.Control.PinchZoom(OpenLayers.Util.extend({map:this.map},
this.pinchZoomOptions))},defaultClick:function(a){a.lastTouches&&a.lastTouches.length==2&&this.map.zoomOut()},defaultDblClick:function(a){this.map.setCenter(this.map.getLonLatFromViewPortPx(a.xy),this.map.zoom+1)},defaultDblRightClick:function(a){this.map.setCenter(this.map.getLonLatFromViewPortPx(a.xy),this.map.zoom-1)},wheelChange:function(a,b){var c=this.map.getZoom(),d=this.map.getZoom()+Math.round(b);d=Math.max(d,0);d=Math.min(d,this.map.getNumZoomLevels());if(d!==c){var e=this.map.getSize();
c=e.w/2-a.xy.x;e=a.xy.y-e.h/2;var f=this.map.baseLayer.getResolutionForZoom(d),g=this.map.getLonLatFromPixel(a.xy);this.map.setCenter(new OpenLayers.LonLat(g.lon+c*f,g.lat+e*f),d)}},wheelUp:function(a,b){this.wheelChange(a,b||1)},wheelDown:function(a,b){this.wheelChange(a,b||-1)},disableZoomBox:function(){this.zoomBoxEnabled=false;this.zoomBox.deactivate()},enableZoomBox:function(){this.zoomBoxEnabled=true;this.active&&this.zoomBox.activate()},disableZoomWheel:function(){this.zoomWheelEnabled=false;
this.handlers.wheel.deactivate()},enableZoomWheel:function(){this.zoomWheelEnabled=true;this.active&&this.handlers.wheel.activate()},CLASS_NAME:"OpenLayers.Control.Navigation"});
OpenLayers.Control.DrawFeature=OpenLayers.Class(OpenLayers.Control,{layer:null,callbacks:null,EVENT_TYPES:["featureadded"],multi:false,featureAdded:function(){},handlerOptions:null,initialize:function(a,b,c){this.EVENT_TYPES=OpenLayers.Control.DrawFeature.prototype.EVENT_TYPES.concat(OpenLayers.Control.prototype.EVENT_TYPES);OpenLayers.Control.prototype.initialize.apply(this,[c]);this.callbacks=OpenLayers.Util.extend({done:this.drawFeature,modify:function(d,e){this.layer.events.triggerEvent("sketchmodified",
{vertex:d,feature:e})},create:function(d,e){this.layer.events.triggerEvent("sketchstarted",{vertex:d,feature:e})}},this.callbacks);this.layer=a;this.handlerOptions=this.handlerOptions||{};if(!("multi"in this.handlerOptions))this.handlerOptions.multi=this.multi;if(a=this.layer.styleMap&&this.layer.styleMap.styles.temporary)this.handlerOptions.layerOptions=OpenLayers.Util.applyDefaults(this.handlerOptions.layerOptions,{styleMap:new OpenLayers.StyleMap({"default":a})});this.handler=new b(this,this.callbacks,
this.handlerOptions)},drawFeature:function(a){a=new OpenLayers.Feature.Vector(a);if(this.layer.events.triggerEvent("sketchcomplete",{feature:a})!==false){a.state=OpenLayers.State.INSERT;this.layer.addFeatures([a]);this.featureAdded(a);this.events.triggerEvent("featureadded",{feature:a})}},insertXY:function(a,b){this.handler&&this.handler.line&&this.handler.insertXY(a,b)},insertDeltaXY:function(a,b){this.handler&&this.handler.line&&this.handler.insertDeltaXY(a,b)},insertDirectionLength:function(a,
b){this.handler&&this.handler.line&&this.handler.insertDirectionLength(a,b)},insertDeflectionLength:function(a,b){this.handler&&this.handler.line&&this.handler.insertDeflectionLength(a,b)},undo:function(){return this.handler.undo&&this.handler.undo()},redo:function(){return this.handler.redo&&this.handler.redo()},finishSketch:function(){this.handler.finishGeometry()},cancel:function(){this.handler.cancel()},CLASS_NAME:"OpenLayers.Control.DrawFeature"});
OpenLayers.Handler.Polygon=OpenLayers.Class(OpenLayers.Handler.Path,{holeModifier:null,drawingHole:false,polygon:null,initialize:function(){OpenLayers.Handler.Path.prototype.initialize.apply(this,arguments)},createFeature:function(a){a=this.map.getLonLatFromPixel(a);a=new OpenLayers.Geometry.Point(a.lon,a.lat);this.point=new OpenLayers.Feature.Vector(a);this.line=new OpenLayers.Feature.Vector(new OpenLayers.Geometry.LinearRing([this.point.geometry]));this.polygon=new OpenLayers.Feature.Vector(new OpenLayers.Geometry.Polygon([this.line.geometry]));
this.callback("create",[this.point.geometry,this.getSketch()]);this.point.geometry.clearBounds();this.layer.addFeatures([this.polygon,this.point],{silent:true})},addPoint:function(){if(!this.drawingHole&&this.holeModifier&&this.evt&&this.evt[this.holeModifier])for(var a=this.point.geometry,b=this.control.layer.features,c,d=b.length-1;d>=0;--d){c=b[d].geometry;if((c instanceof OpenLayers.Geometry.Polygon||c instanceof OpenLayers.Geometry.MultiPolygon)&&c.intersects(a)){a=b[d];this.control.layer.removeFeatures([a],
{silent:true});this.control.layer.events.registerPriority("sketchcomplete",this,this.finalizeInteriorRing);this.control.layer.events.registerPriority("sketchmodified",this,this.enforceTopology);a.geometry.addComponent(this.line.geometry);this.polygon=a;this.drawingHole=true;break}}OpenLayers.Handler.Path.prototype.addPoint.apply(this,arguments)},getCurrentPointIndex:function(){return this.line.geometry.components.length-2},enforceTopology:function(a){a=a.vertex;var b=this.line.geometry.components;
if(!this.polygon.geometry.intersects(a)){b=b[b.length-3];a.x=b.x;a.y=b.y}},finishGeometry:function(){this.line.geometry.removeComponent(this.line.geometry.components[this.line.geometry.components.length-2]);this.removePoint();this.finalize()},finalizeInteriorRing:function(){var a=this.line.geometry,b=a.getArea()!==0;if(b){for(var c=this.polygon.geometry.components,d=c.length-2;d>=0;--d)if(a.intersects(c[d])){b=false;break}if(b){d=c.length-2;a:for(;d>0;--d)for(var e=c[d].components,f=0,g=e.length;f<
g;++f)if(a.containsPoint(e[f])){b=false;break a}}}if(b){if(this.polygon.state!==OpenLayers.State.INSERT)this.polygon.state=OpenLayers.State.UPDATE}else this.polygon.geometry.removeComponent(a);this.restoreFeature();return false},cancel:function(){if(this.drawingHole){this.polygon.geometry.removeComponent(this.line.geometry);this.restoreFeature(true)}return OpenLayers.Handler.Path.prototype.cancel.apply(this,arguments)},restoreFeature:function(a){this.control.layer.events.unregister("sketchcomplete",
this,this.finalizeInteriorRing);this.control.layer.events.unregister("sketchmodified",this,this.enforceTopology);this.layer.removeFeatures([this.polygon],{silent:true});this.control.layer.addFeatures([this.polygon],{silent:true});this.drawingHole=false;a||this.control.layer.events.triggerEvent("sketchcomplete",{feature:this.polygon})},destroyFeature:function(a){OpenLayers.Handler.Path.prototype.destroyFeature.call(this,a);this.polygon=null},drawFeature:function(){this.layer.drawFeature(this.polygon,
this.style);this.layer.drawFeature(this.point,this.style)},getSketch:function(){return this.polygon},getGeometry:function(){var a=this.polygon&&this.polygon.geometry;if(a&&this.multi)a=new OpenLayers.Geometry.MultiPolygon([a]);return a},CLASS_NAME:"OpenLayers.Handler.Polygon"});
OpenLayers.Control.EditingToolbar=OpenLayers.Class(OpenLayers.Control.Panel,{initialize:function(a,b){OpenLayers.Control.Panel.prototype.initialize.apply(this,[b]);this.addControls([new OpenLayers.Control.Navigation]);this.addControls([new OpenLayers.Control.DrawFeature(a,OpenLayers.Handler.Point,{displayClass:"olControlDrawFeaturePoint"}),new OpenLayers.Control.DrawFeature(a,OpenLayers.Handler.Path,{displayClass:"olControlDrawFeaturePath"}),new OpenLayers.Control.DrawFeature(a,OpenLayers.Handler.Polygon,
{displayClass:"olControlDrawFeaturePolygon"})])},draw:function(){var a=OpenLayers.Control.Panel.prototype.draw.apply(this,arguments);if(this.defaultControl===null)this.defaultControl=this.controls[0];return a},CLASS_NAME:"OpenLayers.Control.EditingToolbar"});
OpenLayers.Strategy.BBOX=OpenLayers.Class(OpenLayers.Strategy,{bounds:null,resolution:null,ratio:2,resFactor:null,response:null,activate:function(){var a=OpenLayers.Strategy.prototype.activate.call(this);if(a){this.layer.events.on({moveend:this.update,scope:this});this.layer.events.on({refresh:this.update,scope:this});if(this.layer.visibility===true&&this.layer.inRange===true)this.update();else this.layer.events.on({visibilitychanged:this.update,scope:this})}return a},deactivate:function(){var a=
OpenLayers.Strategy.prototype.deactivate.call(this);a&&this.layer.events.un({moveend:this.update,refresh:this.update,visibilitychanged:this.update,scope:this});return a},update:function(a){var b=this.getMapBounds();if(b!==null&&(a&&a.force||this.invalidBounds(b))){this.calculateBounds(b);this.resolution=this.layer.map.getResolution();this.triggerRead(a)}},getMapBounds:function(){if(this.layer.map===null)return null;var a=this.layer.map.getExtent();if(a&&!this.layer.projection.equals(this.layer.map.getProjectionObject()))a=
a.clone().transform(this.layer.map.getProjectionObject(),this.layer.projection);return a},invalidBounds:function(a){a||(a=this.getMapBounds());a=!this.bounds||!this.bounds.containsBounds(a);if(!a&&this.resFactor){a=this.resolution/this.layer.map.getResolution();a=a>=this.resFactor||a<=1/this.resFactor}return a},calculateBounds:function(a){a||(a=this.getMapBounds());var b=a.getCenterLonLat(),c=a.getWidth()*this.ratio;a=a.getHeight()*this.ratio;this.bounds=new OpenLayers.Bounds(b.lon-c/2,b.lat-a/2,
b.lon+c/2,b.lat+a/2)},triggerRead:function(a){if(this.response){this.layer.protocol.abort(this.response);this.layer.events.triggerEvent("loadend")}this.layer.events.triggerEvent("loadstart");this.response=this.layer.protocol.read(OpenLayers.Util.applyDefaults({filter:this.createFilter(),callback:this.merge,scope:this},a))},createFilter:function(){var a=new OpenLayers.Filter.Spatial({type:OpenLayers.Filter.Spatial.BBOX,value:this.bounds,projection:this.layer.projection});if(this.layer.filter)a=new OpenLayers.Filter.Logical({type:OpenLayers.Filter.Logical.AND,
filters:[this.layer.filter,a]});return a},merge:function(a){this.layer.destroyFeatures();if((a=a.features)&&a.length>0){var b=this.layer.projection,c=this.layer.map.getProjectionObject();if(!c.equals(b))for(var d,e=0,f=a.length;e<f;++e)(d=a[e].geometry)&&d.transform(b,c);this.layer.addFeatures(a)}this.response=null;this.layer.events.triggerEvent("loadend")},CLASS_NAME:"OpenLayers.Strategy.BBOX"});
OpenLayers.Lang.nn=OpenLayers.Util.applyDefaults({"Scale = 1 : ${scaleDenom}":"Skala = 1 : ${scaleDenom}",layerAlreadyAdded:"Du freista \u00e5 leggja til laget \u00ab${layerName}\u00bb p\u00e5 kartet, men det har alt vorte lagt til.",boundsAddError:"Du er n\u00f8ydd til \u00e5 gje b\u00e5de ein x- og ein y-verdi til \u00abadd\u00bb-funksjonen.",lonlatAddError:"Du er n\u00f8ydd til \u00e5 gje b\u00e5de lon- og lat-verdiar til \u00abadd\u00bb-funksjonen.",pixelAddError:"Du er n\u00f8ydd til \u00e5 gje b\u00e5de ein x- og ein y-verdi til \u00abadd\u00bb-funksjonen."});
OpenLayers.Layer.GoogleNG=OpenLayers.Class(OpenLayers.Layer.XYZ,{SUPPORTED_TRANSITIONS:[],serverResolutions:[156543.03390625,78271.516953125,39135.7584765625,19567.87923828125,9783.939619140625,4891.9698095703125,2445.9849047851562,1222.9924523925781,611.4962261962891,305.74811309814453,152.87405654907226,76.43702827453613,38.218514137268066,19.109257068634033,9.554628534317017,4.777314267158508,2.388657133579254,1.194328566789627,0.5971642833948135,0.29858214169740677,0.14929107084870338,0.07464553542435169,
0.037322767712175846],attributionTemplate:'<span class="olGoogleAttribution ${mapType}"><div><a title="Click to see this area on Google Maps" target="_blank" href="http://maps.google.com/maps?ll=${center}&z=${zoom}&t=${t}"><img width="62" height="24" src="http://maps.gstatic.com/mapfiles/google_white.png"/></a></div>${mapData}<a style="white-space: nowrap" target="_blank" href="http://www.google.com/help/terms_maps.html">Terms of Use</a></span>',mapTypes:{roadmap:"m",satellite:"k",hybrid:"h",terrain:"p"},
type:null,initialize:function(a){a=OpenLayers.Util.applyDefaults({sphericalMercator:true},a);if(!a.type)a.type=google.maps.MapTypeId.ROADMAP;OpenLayers.Layer.XYZ.prototype.initialize.apply(this,[a.name,null,a]);if(!OpenLayers.Layer.GoogleNG.mapObject)OpenLayers.Layer.GoogleNG.mapObject=new google.maps.Map(document.createElement("div"));OpenLayers.Layer.GoogleNG.mapObject.mapTypes[this.type]?this.initLayer():google.maps.event.addListenerOnce(OpenLayers.Layer.GoogleNG.mapObject,"idle",OpenLayers.Function.bind(this.initLayer,
this))},initLayer:function(){var a=OpenLayers.Layer.GoogleNG.mapObject.mapTypes[this.type];this.name||this.setName("Google "+a.name);var b=a.minZoom||0;this.addOptions({maxResolution:Math.min(this.serverResolutions[b],this.maxResolution),zoomOffset:b,numZoomLevels:Math.min(a.maxZoom+1-b,this.numZoomLevels)},true)},addTile:function(a,b){return new OpenLayers.Tile.Google(this,b,a,this.tileOptions)},updateAttribution:function(a){if(this.type==google.maps.MapTypeId.HYBRID){var b=[].concat(a.h,a.k,a.m);
a=[];for(var c=b.length-1;c>=0;--c)OpenLayers.Util.indexOf(b,a)==-1&&a.push(b[c])}else a=a[this.mapTypes[this.type]];a=a.length==0?"":"Map Data &copy;"+(new Date).getFullYear()+" "+a.join(", ")+" - ";(b=this.map.getCenter())&&b.transform(this.map.getProjectionObject(),new OpenLayers.Projection("EPSG:4326"));this.map.getSize();this.attribution=OpenLayers.String.format(this.attributionTemplate,{t:this.mapTypes[this.type],zoom:this.map.getZoom(),center:b.lat+","+b.lon,mapType:this.type,mapData:a});this.map&&
this.map.events.triggerEvent("changelayer",{layer:this,property:"attribution"})},setMap:function(){OpenLayers.Layer.XYZ.prototype.setMap.apply(this,arguments);this.events.register("moveend",this,OpenLayers.Layer.GoogleNG.loadCopyrights)},removeMap:function(){OpenLayers.Layer.XYZ.prototype.removeMap.apply(this,arguments);this.events.unregister("moveend",this,OpenLayers.Layer.GoogleNG.loadCopyrights)},clone:function(a){if(a==null)a=new OpenLayers.Layer.GoogleNG(this.options);return a=OpenLayers.Layer.XYZ.prototype.clone.apply(this,
[a])},CLASS_NAME:"OpenLayers.Layer.GoogleNG"});OpenLayers.Layer.GoogleNG.mapObject=null;
OpenLayers.Layer.GoogleNG.loadCopyrights=function(){var a=OpenLayers.Layer.GoogleNG.loadCopyrights;if(a.numLoadingScripts==undefined){a.loadingScripts=[];a.numLoadingScripts=0;a.copyrights={m:[],k:[],h:[],p:[]};a.origGAddCopyright=window.GAddCopyright;a.origGVerify=window.GVerify;a.origGAppFeatures=window.GAppFeatures;window.GAddCopyright=function(e,f,g,h,j,i,k,l){e=a.copyrights[e];OpenLayers.Util.indexOf(e,l)==-1&&l&&e.push(l)};window.GVerify=OpenLayers.Function.True;window.GAppFeatures=OpenLayers.Function.bind(function(){a.numLoadingScripts--;
if(a.numLoadingScripts==0){for(var e,f=a.loadingScripts.length-1;f>=0;--f){e=a.loadingScripts[f][0];a.loadingScripts[f][1].updateAttribution(a.copyrights);e.parentNode.removeChild(e)}window.GAddCopyright=a.origGAddCopyright;delete a.origGAddCopyright;window.GVerify=a.origGVerify;delete a.origGVerify;window.GAppFeatures=a.origGAppFeatures;delete a.origGAppFeatures;delete a.loadingScripts;delete a.numLoadingScripts;delete a.copyrights}},this)}var b=this.map.getProjectionObject(),c=new OpenLayers.Projection("EPSG:4326"),
d=this.map.getCenter().transform(b,c);b=this.map.getExtent().transform(b,c);d={spn:b.getHeight()+","+b.getWidth(),z:this.map.getZoom(),t:this.mapTypes[this.type],vp:d.lat+","+d.lon};d="http://maps.google.com/maps?"+OpenLayers.Util.getParameterString(d);b=document.createElement("script");b.type="text/javascript";b.src=d;a.numLoadingScripts++;a.loadingScripts.push([b,this]);document.getElementsByTagName("head")[0].appendChild(b)};
OpenLayers.Layer.WorldWind=OpenLayers.Class(OpenLayers.Layer.Grid,{DEFAULT_PARAMS:{},isBaseLayer:true,lzd:null,zoomLevels:null,initialize:function(a,b,c,d,e,f){this.lzd=c;this.zoomLevels=d;c=[];c.push(a,b,e,f);OpenLayers.Layer.Grid.prototype.initialize.apply(this,c);this.params=OpenLayers.Util.applyDefaults(this.params,this.DEFAULT_PARAMS)},getZoom:function(){var a=this.map.getZoom();this.map.getMaxExtent();a-=Math.log(this.maxResolution/(this.lzd/512))/Math.log(2);return a},getURL:function(a){a=
this.adjustBounds(a);var b=this.getZoom(),c=this.map.getMaxExtent(),d=this.lzd/Math.pow(2,this.getZoom()),e=Math.floor((a.left-c.left)/d);a=Math.floor((a.bottom-c.bottom)/d);return this.map.getResolution()<=this.lzd/512&&this.getZoom()<=this.zoomLevels?this.getFullRequestString({L:b,X:e,Y:a}):OpenLayers.Util.getImagesLocation()+"blank.gif"},CLASS_NAME:"OpenLayers.Layer.WorldWind"});
OpenLayers.Format.WMTSCapabilities=OpenLayers.Class(OpenLayers.Format.XML.VersionedOGC,{defaultVersion:"1.0.0",yx:{"urn:ogc:def:crs:EPSG::4326":true},createLayer:function(a,b){var c,d={layer:true,matrixSet:true},e;for(e in d)if(!(e in b))throw Error("Missing property '"+e+"' in layer configuration.");d=a.contents;e=d.tileMatrixSets[b.matrixSet];for(var f,g=0,h=d.layers.length;g<h;++g)if(d.layers[g].identifier===b.layer){f=d.layers[g];break}if(f&&e){var j;g=0;for(h=f.styles.length;g<h;++g){j=f.styles[g];
if(j.isDefault)break}c=new OpenLayers.Layer.WMTS(OpenLayers.Util.applyDefaults(b,{url:a.operationsMetadata.GetTile.dcp.http.get,name:f.title,style:j.identifier,matrixIds:e.matrixIds}))}return c},CLASS_NAME:"OpenLayers.Format.WMTSCapabilities"});
OpenLayers.Lang.es={unhandledRequest:"Respuesta a petici\u00f3n no gestionada ${statusText}",Permalink:"Enlace permanente",Overlays:"Capas superpuestas","Base Layer":"Capa Base",readNotImplemented:"Lectura no implementada.",writeNotImplemented:"Escritura no implementada.",noFID:"No se puede actualizar un elemento para el que no existe FID.",errorLoadingGML:"Error cargando el fichero GML ${url}",browserNotSupported:"Su navegador no soporta renderizaci\u00f3n vectorial. Los renderizadores soportados actualmente son:\n${renderers}",
componentShouldBe:"addFeatures : el componente debe ser del tipo ${geomType}",getFeatureError:"getFeatureFromEvent se ha llamado desde una capa sin renderizador. Esto normalmente quiere decir que se ha destruido una capa, pero no el manejador asociado a ella.",minZoomLevelError:"La propiedad minZoomLevel debe s\u00f3lo utilizarse con las capas que tienen FixedZoomLevels. El hecho de que una capa wfs compruebe minZoomLevel es una reliquia del pasado. Sin embargo, no podemos eliminarla sin discontinuar probablemente las aplicaciones OL que puedan depender de ello. As\u00ed pues estamos haci\u00e9ndolo obsoleto --la comprobaci\u00f3n minZoomLevel se eliminar\u00e1 en la versi\u00f3n 3.0. Utilice el ajuste de resolution min/max en su lugar, tal como se describe aqu\u00ed: http://trac.openlayers.org/wiki/SettingZoomLevels",
commitSuccess:"Transacci\u00f3n WFS: \u00c9XITO ${response}",commitFailed:"Transacci\u00f3n WFS: FALL\u00d3 ${response}",googleWarning:"La capa Google no pudo ser cargada correctamente.<br><br>Para evitar este mensaje, seleccione una nueva Capa Base en el selector de capas en la esquina superior derecha.<br><br>Probablemente, esto se debe a que el script de la biblioteca de Google Maps no fue correctamente incluido en su p\u00e1gina, o no contiene la clave del API correcta para su sitio.<br><br>Desarrolladores: Para ayudar a hacer funcionar esto correctamente, <a href='http://trac.openlayers.org/wiki/Google' target='_blank'>haga clic aqu\u00ed</a>",
getLayerWarning:"La capa ${layerType} no pudo ser cargada correctamente.<br><br>Para evitar este mensaje, seleccione una nueva Capa Base en el selector de capas en la esquina superior derecha.<br><br>Probablemente, esto se debe a que el script de la biblioteca ${layerLib} no fue correctamente incluido en su p\u00e1gina.<br><br>Desarrolladores: Para ayudar a hacer funcionar esto correctamente, <a href='http://trac.openlayers.org/wiki/${layerLib}' target='_blank'>haga clic aqu\u00ed</a>","Scale = 1 : ${scaleDenom}":"Escala = 1 : ${scaleDenom}",
W:"O",E:"E",N:"N",S:"S",Graticule:"Ret\u00edcula",layerAlreadyAdded:"Intent\u00f3 a\u00f1adir la capa: ${layerName} al mapa, pero ya hab\u00eda sido a\u00f1adida previamente",reprojectDeprecated:"Est\u00e1 usando la opci\u00f3n 'reproject' en la capa ${layerName}. Esta opci\u00f3n es obsoleta: su uso fue dise\u00f1ado para soportar la visualizaci\u00f3n de datos sobre mapas base comerciales, pero ahora esa funcionalidad deber\u00eda conseguirse mediante el soporte de la proyecci\u00f3n Spherical Mercator. M\u00e1s informaci\u00f3n disponible en http://trac.openlayers.org/wiki/SphericalMercator.",
methodDeprecated:"Este m\u00e9todo es obsoleto y se eliminar\u00e1 en la versi\u00f3n 3.0. Por favor utilice el m\u00e9todo ${newMethod} en su lugar.",boundsAddError:"Debe proporcionar los valores x e y a la funci\u00f3n add.",lonlatAddError:"Debe proporcionar los valores lon y lat a la funci\u00f3n add.",pixelAddError:"Debe proporcionar los valores x e y a la funci\u00f3n add.",unsupportedGeometryType:"Tipo de geometr\u00eda no soportada: ${geomType}",filterEvaluateNotImplemented:"evaluate no est\u00e1 implementado para este tipo de filtro.",
end:""};
OpenLayers.Layer.Google.v3={DEFAULTS:{maxExtent:new OpenLayers.Bounds(-2.003750834E7,-2.003750834E7,2.003750834E7,2.003750834E7),sphericalMercator:true,maxResolution:156543.03390625,units:"m",projection:"EPSG:900913"},animationEnabled:true,loadMapObject:function(){if(!this.type)this.type=google.maps.MapTypeId.ROADMAP;var a,b=OpenLayers.Layer.Google.cache[this.map.id];if(b){a=b.mapObject;++b.count}else{b=this.map.viewPortDiv;a=document.createElement("div");a.id=this.map.id+"_GMapContainer";a.style.position=
"absolute";a.style.width="100%";a.style.height="100%";b.appendChild(a);b=this.map.getCenter();a=new google.maps.Map(a,{center:b?new google.maps.LatLng(b.lat,b.lon):new google.maps.LatLng(0,0),zoom:this.map.getZoom()||0,mapTypeId:this.type,disableDefaultUI:true,keyboardShortcuts:false,draggable:false,disableDoubleClickZoom:true,scrollwheel:false,streetViewControl:false});b={mapObject:a,count:1};OpenLayers.Layer.Google.cache[this.map.id]=b;this.repositionListener=google.maps.event.addListenerOnce(a,
"center_changed",OpenLayers.Function.bind(this.repositionMapElements,this))}this.mapObject=a;this.setGMapVisibility(this.visibility)},repositionMapElements:function(){google.maps.event.trigger(this.mapObject,"resize");var a=this.mapObject.getDiv().firstChild;if(!a||a.childNodes.length<3){this.repositionTimer=window.setTimeout(OpenLayers.Function.bind(this.repositionMapElements,this),250);return false}for(var b=OpenLayers.Layer.Google.cache[this.map.id],c=this.map.viewPortDiv;a.lastChild.style.display==
"none";)c.appendChild(a.lastChild);var d=a.lastChild;c.appendChild(d);d.style.zIndex="1100";d.style.bottom="";d.className="olLayerGoogleCopyright olLayerGoogleV3";d.style.display="";b.termsOfUse=d;a=a.lastChild;c.appendChild(a);a.style.zIndex="1100";a.style.bottom="";a.className="olLayerGooglePoweredBy olLayerGoogleV3 gmnoprint";a.style.display="";b.poweredBy=a;this.setGMapVisibility(this.visibility)},onMapResize:function(){if(this.visibility)google.maps.event.trigger(this.mapObject,"resize");else{var a=
OpenLayers.Layer.Google.cache[this.map.id];if(!a.resized){var b=this;google.maps.event.addListenerOnce(this.mapObject,"tilesloaded",function(){google.maps.event.trigger(b.mapObject,"resize");b.moveTo(b.map.getCenter(),b.map.getZoom());delete a.resized})}a.resized=true}},setGMapVisibility:function(a){var b=OpenLayers.Layer.Google.cache[this.map.id];if(b&&!b.resized){for(var c=this.type,d=this.map.layers,e,f=d.length-1;f>=0;--f){e=d[f];if(e instanceof OpenLayers.Layer.Google&&e.visibility===true&&e.inRange===
true){c=e.type;a=true;break}}d=this.mapObject.getDiv();if(a===true){this.mapObject.setMapTypeId(c);d.style.left="";if(b.termsOfUse&&b.termsOfUse.style){b.termsOfUse.style.left="";b.termsOfUse.style.display="";b.poweredBy.style.display=""}b.displayed=this.id}else{delete b.displayed;d.style.left="-9999px";if(b.termsOfUse&&b.termsOfUse.style){b.termsOfUse.style.display="none";b.termsOfUse.style.left="-9999px";b.poweredBy.style.display="none"}}}},getMapContainer:function(){return this.mapObject.getDiv()},
getMapObjectBoundsFromOLBounds:function(a){var b=null;if(a!=null){b=this.sphericalMercator?this.inverseMercator(a.bottom,a.left):new OpenLayers.LonLat(a.bottom,a.left);a=this.sphericalMercator?this.inverseMercator(a.top,a.right):new OpenLayers.LonLat(a.top,a.right);b=new google.maps.LatLngBounds(new google.maps.LatLng(b.lat,b.lon),new google.maps.LatLng(a.lat,a.lon))}return b},getMapObjectLonLatFromMapObjectPixel:function(a){var b=this.map.getSize(),c=this.getLongitudeFromMapObjectLonLat(this.mapObject.center),
d=this.getLatitudeFromMapObjectLonLat(this.mapObject.center),e=this.map.getResolution();a=new OpenLayers.LonLat(c+(a.x-b.w/2)*e,d-(a.y-b.h/2)*e);if(this.wrapDateLine)a=a.wrapDateLine(this.maxExtent);return this.getMapObjectLonLatFromLonLat(a.lon,a.lat)},getMapObjectPixelFromMapObjectLonLat:function(a){var b=this.getLongitudeFromMapObjectLonLat(a);a=this.getLatitudeFromMapObjectLonLat(a);var c=this.map.getResolution(),d=this.map.getExtent();b=new OpenLayers.Pixel(1/c*(b-d.left),1/c*(d.top-a));return this.getMapObjectPixelFromXY(b.x,
b.y)},setMapObjectCenter:function(a,b){if(this.animationEnabled===false&&b!=this.mapObject.zoom){var c=this.getMapContainer();google.maps.event.addListenerOnce(this.mapObject,"idle",function(){c.style.visibility=""});c.style.visibility="hidden"}this.mapObject.setOptions({center:a,zoom:b})},getMapObjectZoomFromMapObjectBounds:function(a){return this.mapObject.getBoundsZoomLevel(a)},getMapObjectLonLatFromLonLat:function(a,b){var c;if(this.sphericalMercator){c=this.inverseMercator(a,b);c=new google.maps.LatLng(c.lat,
c.lon)}else c=new google.maps.LatLng(b,a);return c},getMapObjectPixelFromXY:function(a,b){return new google.maps.Point(a,b)},destroy:function(){this.repositionListener&&google.maps.event.removeListener(this.repositionListener);this.repositionTimer&&window.clearTimeout(this.repositionTimer);OpenLayers.Layer.Google.prototype.destroy.apply(this,arguments)}};
OpenLayers.Format.WPSDescribeProcess=OpenLayers.Class(OpenLayers.Format.XML,{VERSION:"1.0.0",namespaces:{wps:"http://www.opengis.net/wps/1.0.0",ows:"http://www.opengis.net/ows/1.1",xsi:"http://www.w3.org/2001/XMLSchema-instance"},schemaLocation:"http://www.opengis.net/wps/1.0.0 http://schemas.opengis.net/wps/1.0.0/wpsAll.xsd",defaultPrefix:"wps",regExes:{trimSpace:/^\s*|\s*$/g,removeSpace:/\s*/g,splitSpace:/\s+/,trimComma:/\s*,\s*/g},read:function(a){if(typeof a=="string")a=OpenLayers.Format.XML.prototype.read.apply(this,
[a]);if(a&&a.nodeType==9)a=a.documentElement;var b={};this.readNode(a,b);return b},readers:{wps:{ProcessDescriptions:function(a,b){b.processDescriptions={};this.readChildNodes(a,b.processDescriptions)},ProcessDescription:function(a,b){var c={processVersion:this.getAttributeNS(a,this.namespaces.wps,"processVersion"),statusSupported:a.getAttribute("statusSupported")==="true",storeSupported:a.getAttribute("storeSupported")==="true"};this.readChildNodes(a,c);b[c.identifier]=c},DataInputs:function(a,b){b.dataInputs=
[];this.readChildNodes(a,b.dataInputs)},ProcessOutputs:function(a,b){b.processOutputs=[];this.readChildNodes(a,b.processOutputs)},Output:function(a,b){var c={};this.readChildNodes(a,c);b.push(c)},ComplexOutput:function(a,b){b.complexOutput={};this.readChildNodes(a,b.complexOutput)},Input:function(a,b){var c={maxOccurs:parseInt(a.getAttribute("maxOccurs")),minOccurs:parseInt(a.getAttribute("minOccurs"))};this.readChildNodes(a,c);b.push(c)},BoundingBoxData:function(a,b){b.boundingBoxData={};this.readChildNodes(a,
b.boundingBoxData)},CRS:function(a,b){if(!b.CRSs)b.CRSs={};b.CRSs[this.getChildValue(a)]=true},LiteralData:function(a,b){b.literalData={};this.readChildNodes(a,b.literalData)},ComplexData:function(a,b){b.complexData={};this.readChildNodes(a,b.complexData)},Default:function(a,b){b["default"]={};this.readChildNodes(a,b["default"])},Supported:function(a,b){b.supported={};this.readChildNodes(a,b.supported)},Format:function(a,b){var c={};this.readChildNodes(a,c);if(!b.formats)b.formats={};b.formats[c.mimeType]=
true},MimeType:function(a,b){b.mimeType=this.getChildValue(a)}},ows:OpenLayers.Format.OWSCommon.v1_1_0.prototype.readers.ows},CLASS_NAME:"OpenLayers.Format.WPSDescribeProcess"});
OpenLayers.Control.NavToolbar=OpenLayers.Class(OpenLayers.Control.Panel,{initialize:function(a){OpenLayers.Control.Panel.prototype.initialize.apply(this,[a]);this.addControls([new OpenLayers.Control.Navigation,new OpenLayers.Control.ZoomBox])},draw:function(){var a=OpenLayers.Control.Panel.prototype.draw.apply(this,arguments);if(this.defaultControl===null)this.defaultControl=this.controls[0];return a},CLASS_NAME:"OpenLayers.Control.NavToolbar"});
OpenLayers.Lang.ru=OpenLayers.Util.applyDefaults({unhandledRequest:"\u041d\u0435\u043e\u0431\u0440\u0430\u0431\u043e\u0442\u0430\u043d\u043d\u044b\u0439 \u0437\u0430\u043f\u0440\u043e\u0441 \u0432\u0435\u0440\u043d\u0443\u043b ${statusText}",Permalink:"\u041f\u043e\u0441\u0442\u043e\u044f\u043d\u043d\u0430\u044f \u0441\u0441\u044b\u043b\u043a\u0430",Overlays:"\u0421\u043b\u043e\u0438","Base Layer":"\u041e\u0441\u043d\u043e\u0432\u043d\u043e\u0439 \u0441\u043b\u043e\u0439",readNotImplemented:"\u0427\u0442\u0435\u043d\u0438\u0435 \u043d\u0435 \u0440\u0435\u0430\u043b\u0438\u0437\u043e\u0432\u0430\u043d\u043e.",
writeNotImplemented:"\u0417\u0430\u043f\u0438\u0441\u044c \u043d\u0435 \u0440\u0435\u0430\u043b\u0438\u0437\u043e\u0432\u0430\u043d\u0430.",noFID:"\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043e\u0431\u043d\u043e\u0432\u0438\u0442\u044c \u043e\u0431\u044a\u0435\u043a\u0442, \u0434\u043b\u044f \u043a\u043e\u0442\u043e\u0440\u043e\u0433\u043e \u043d\u0435\u0442 FID.",errorLoadingGML:"\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0435 \u0444\u0430\u0439\u043b\u0430 GML ${url}",
browserNotSupported:"\u0412\u0430\u0448 \u0431\u0440\u0430\u0443\u0437\u0435\u0440 \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442 \u0432\u0435\u043a\u0442\u043e\u0440\u043d\u0443\u044e \u0433\u0440\u0430\u0444\u0438\u043a\u0443. \u041d\u0430 \u0434\u0430\u043d\u043d\u044b\u0439 \u043c\u043e\u043c\u0435\u043d\u0442 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u044e\u0442\u0441\u044f:\n${renderers}",componentShouldBe:"addFeatures: \u043a\u043e\u043c\u043f\u043e\u043d\u0435\u043d\u0442 \u0434\u043e\u043b\u0436\u0435\u043d \u0431\u044b\u0442\u044c ${geomType}",
getFeatureError:"getFeatureFromEvent \u0432\u044b\u0437\u0432\u0430\u043d \u0434\u043b\u044f \u0441\u043b\u043e\u044f \u0431\u0435\u0437 \u0440\u0435\u043d\u0434\u0435\u0440\u0435\u0440\u0430. \u041e\u0431\u044b\u0447\u043d\u043e \u044d\u0442\u043e \u0433\u043e\u0432\u043e\u0440\u0438\u0442 \u043e \u0442\u043e\u043c, \u0447\u0442\u043e \u0432\u044b \u0443\u043d\u0438\u0447\u0442\u043e\u0436\u0438\u043b\u0438 \u0441\u043b\u043e\u0439, \u043d\u043e \u043e\u0441\u0442\u0430\u0432\u0438\u043b\u0438 \u0441\u0432\u044f\u0437\u0430\u043d\u043d\u044b\u0439 \u0441 \u043d\u0438\u043c \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u0447\u0438\u043a.",
minZoomLevelError:"\u0421\u0432\u043e\u0439\u0441\u0442\u0432\u043e minZoomLevel \u043f\u0440\u0435\u0434\u043d\u0430\u0437\u043d\u0430\u0447\u0435\u043d\u043e \u0442\u043e\u043b\u044c\u043a\u043e \u0434\u043b\u044f \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u044f \u0441\u043e \u0441\u043b\u043e\u044f\u043c\u0438, \u044f\u0432\u043b\u044f\u044e\u0449\u0438\u043c\u0438\u0441\u044f \u043f\u043e\u0442\u043e\u043c\u043a\u0430\u043c\u0438 FixedZoomLevels. \u0422\u043e, \u0447\u0442\u043e \u044d\u0442\u043e\u0442 WFS-\u0441\u043b\u043e\u0439 \u043f\u0440\u043e\u0432\u0435\u0440\u044f\u0435\u0442\u0441\u044f \u043d\u0430 minZoomLevel \u2014 \u0440\u0435\u043b\u0438\u043a\u0442 \u043f\u0440\u043e\u0448\u043b\u043e\u0433\u043e. \u041e\u0434\u043d\u0430\u043a\u043e \u043c\u044b \u043d\u0435 \u043c\u043e\u0436\u0435\u043c \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u044d\u0442\u0443 \u0444\u0443\u043d\u043a\u0446\u0438\u044e, \u0442\u0430\u043a \u043a\u0430\u043a, \u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e, \u043e\u0442 \u043d\u0435\u0451 \u0437\u0430\u0432\u0438\u0441\u044f\u0442 \u043d\u0435\u043a\u043e\u0442\u043e\u0440\u044b\u0435 \u043e\u0441\u043d\u043e\u0432\u0430\u043d\u043d\u044b\u0435 \u043d\u0430 OpenLayers \u043f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u044f. \u0424\u0443\u043d\u043a\u0446\u0438\u044f \u043e\u0431\u044a\u044f\u0432\u043b\u0435\u043d\u0430 \u0443\u0441\u0442\u0430\u0440\u0435\u0432\u0448\u0435\u0439 \u2014 \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 minZoomLevel \u0431\u0443\u0434\u0435\u0442 \u0443\u0434\u0430\u043b\u0435\u043d\u0430 \u0432 3.0. \u041f\u043e\u0436\u0430\u043b\u0443\u0439\u0441\u0442\u0430, \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0439\u0442\u0435 \u0432\u043c\u0435\u0441\u0442\u043e \u043d\u0435\u0451 \u043d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0443 \u043c\u0438\u043d/\u043c\u0430\u043a\u0441 \u0440\u0430\u0437\u0440\u0435\u0448\u0435\u043d\u0438\u044f, \u043e\u043f\u0438\u0441\u0430\u043d\u043d\u0443\u044e \u0437\u0434\u0435\u0441\u044c: http://trac.openlayers.org/wiki/SettingZoomLevels",
commitSuccess:"\u0422\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u044f WFS: \u0423\u0421\u041f\u0415\u0428\u041d\u041e ${response}",commitFailed:"\u0422\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u044f WFS: \u041e\u0428\u0418\u0411\u041a\u0410 ${response}",googleWarning:"\u0421\u043b\u043e\u0439 Google \u043d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043d\u043e\u0440\u043c\u0430\u043b\u044c\u043d\u043e \u0437\u0430\u0433\u0440\u0443\u0437\u0438\u0442\u044c.<br><br>\u0427\u0442\u043e\u0431\u044b \u0438\u0437\u0431\u0430\u0432\u0438\u0442\u044c\u0441\u044f \u043e\u0442 \u044d\u0442\u043e\u0433\u043e \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u044f, \u0432\u044b\u0431\u0438\u0442\u0435 \u0434\u0440\u0443\u0433\u043e\u0439 \u043e\u0441\u043d\u043e\u0432\u043d\u043e\u0439 \u0441\u043b\u043e\u0439 \u0432 \u043f\u0435\u0440\u0435\u043a\u043b\u044e\u0447\u0430\u0442\u0435\u043b\u0435 \u0432 \u043f\u0440\u0430\u0432\u043e\u043c \u0432\u0435\u0440\u0445\u043d\u0435\u043c \u0443\u0433\u043b\u0443.<br><br>\u0421\u043a\u043e\u0440\u0435\u0435 \u0432\u0441\u0435\u0433\u043e, \u043f\u0440\u0438\u0447\u0438\u043d\u0430 \u0432 \u0442\u043e\u043c, \u0447\u0442\u043e \u0431\u0438\u0431\u043b\u0438\u043e\u0442\u0435\u043a\u0430 Google Maps \u043d\u0435 \u0431\u044b\u043b\u0430 \u0432\u043a\u043b\u044e\u0447\u0435\u043d\u0430 \u0438\u043b\u0438 \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u043e\u0433\u043e API-\u043a\u043b\u044e\u0447\u0430 \u0434\u043b\u044f \u0432\u0430\u0448\u0435\u0433\u043e \u0441\u0430\u0439\u0442\u0430.<br><br>\u0420\u0430\u0437\u0440\u0430\u0431\u043e\u0442\u0447\u0438\u043a\u0430\u043c: \u0447\u0442\u043e\u0431\u044b \u0443\u0437\u043d\u0430\u0442\u044c, \u043a\u0430\u043a \u0441\u0434\u0435\u043b\u0430\u0442\u044c, \u0447\u0442\u043e\u0431\u044b \u0432\u0441\u0451 \u0437\u0430\u0440\u0430\u0431\u043e\u0442\u0430\u043b\u043e, <a href='http://trac.openlayers.org/wiki/Google' target='_blank'>\u0449\u0451\u043b\u043a\u043d\u0438\u0442\u0435 \u0442\u0443\u0442</a>",
getLayerWarning:"\u0421\u043b\u043e\u0439 ${layerType} \u043d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043d\u043e\u0440\u043c\u0430\u043b\u044c\u043d\u043e \u0437\u0430\u0433\u0440\u0443\u0437\u0438\u0442\u044c. <br><br>\u0427\u0442\u043e\u0431\u044b \u0438\u0437\u0431\u0430\u0432\u0438\u0442\u044c\u0441\u044f \u043e\u0442 \u044d\u0442\u043e\u0433\u043e \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u044f, \u0432\u044b\u0431\u0438\u0442\u0435 \u0434\u0440\u0443\u0433\u043e\u0439 \u043e\u0441\u043d\u043e\u0432\u043d\u043e\u0439 \u0441\u043b\u043e\u0439 \u0432 \u043f\u0435\u0440\u0435\u043a\u043b\u044e\u0447\u0430\u0442\u0435\u043b\u0435 \u0432 \u043f\u0440\u0430\u0432\u043e\u043c \u0432\u0435\u0440\u0445\u043d\u0435\u043c \u0443\u0433\u043b\u0443.<br><br>\u0421\u043a\u043e\u0440\u0435\u0435 \u0432\u0441\u0435\u0433\u043e, \u043f\u0440\u0438\u0447\u0438\u043d\u0430 \u0432 \u0442\u043e\u043c, \u0447\u0442\u043e \u0431\u0438\u0431\u043b\u0438\u043e\u0442\u0435\u043a\u0430 ${layerLib} \u043d\u0435 \u0431\u044b\u043b\u0430 \u0432\u043a\u043b\u044e\u0447\u0435\u043d\u0430 \u0438\u043b\u0438 \u0431\u044b\u043b\u0430 \u0432\u043a\u043b\u044e\u0447\u0435\u043d\u0430 \u043d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u043e.<br><br>\u0420\u0430\u0437\u0440\u0430\u0431\u043e\u0442\u0447\u0438\u043a\u0430\u043c: \u0447\u0442\u043e\u0431\u044b \u0443\u0437\u043d\u0430\u0442\u044c, \u043a\u0430\u043a \u0441\u0434\u0435\u043b\u0430\u0442\u044c, \u0447\u0442\u043e\u0431\u044b \u0432\u0441\u0451 \u0437\u0430\u0440\u0430\u0431\u043e\u0442\u0430\u043b\u043e, <a href='http://trac.openlayers.org/wiki/${layerLib}' target='_blank'>\u0449\u0451\u043b\u043a\u043d\u0438\u0442\u0435 \u0442\u0443\u0442</a>",
"Scale = 1 : ${scaleDenom}":"\u041c\u0430\u0441\u0448\u0442\u0430\u0431 = 1 : ${scaleDenom}",W:"\u0417",E:"\u0412",N:"\u0421",S:"\u042e",layerAlreadyAdded:"\u0412\u044b \u043f\u043e\u043f\u044b\u0442\u0430\u043b\u0438\u0441\u044c \u0434\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u0441\u043b\u043e\u0439 \u00ab${layerName}\u00bb \u043d\u0430 \u043a\u0430\u0440\u0442\u0443, \u043d\u043e \u043e\u043d \u0443\u0436\u0435 \u0431\u044b\u043b \u0434\u043e\u0431\u0430\u0432\u043b\u0435\u043d",reprojectDeprecated:"\u0412\u044b \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0435 \u043e\u043f\u0446\u0438\u044e 'reproject' \u0434\u043b\u044f \u0441\u043b\u043e\u044f ${layerName}. \u042d\u0442\u0430 \u043e\u043f\u0446\u0438\u044f \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u0443\u0441\u0442\u0430\u0440\u0435\u0432\u0448\u0435\u0439: \u0435\u0435 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u0435 \u043f\u0440\u0435\u0434\u043f\u043e\u043b\u0430\u0433\u0430\u043b\u043e\u0441\u044c \u0434\u043b\u044f \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u043a\u0438 \u043f\u043e\u043a\u0430\u0437\u0430 \u0434\u0430\u043d\u043d\u044b\u0445 \u043f\u043e\u0432\u0435\u0440\u0445 \u043a\u043e\u043c\u043c\u0435\u0440\u0447\u0435\u0441\u043a\u0438\u0445 \u0431\u0430\u0437\u043e\u0432\u044b\u0445 \u043a\u0430\u0440\u0442, \u043d\u043e \u0442\u0435\u043f\u0435\u0440\u044c \u044d\u0442\u043e\u0442 \u0444\u0443\u043d\u043a\u0446\u0438\u043e\u043d\u0430\u043b \u043d\u0435\u0441\u0451\u0442 \u0432\u0441\u0442\u0440\u043e\u0435\u043d\u043d\u0430\u044f \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u043a\u0430 \u0441\u0444\u0435\u0440\u0438\u0447\u0435\u0441\u043a\u043e\u0439 \u043f\u0440\u043e\u0435\u043a\u0446\u0438\u0438 \u041c\u0435\u0440\u043a\u0430\u0442\u043e\u0440\u0430. \u0411\u043e\u043b\u044c\u0448\u0435 \u0441\u0432\u0435\u0434\u0435\u043d\u0438\u0439 \u0434\u043e\u0441\u0442\u0443\u043f\u043d\u043e \u043d\u0430 http://trac.openlayers.org/wiki/SphericalMercator.",
methodDeprecated:"\u042d\u0442\u043e\u0442 \u043c\u0435\u0442\u043e\u0434 \u0441\u0447\u0438\u0442\u0430\u0435\u0442\u0441\u044f \u0443\u0441\u0442\u0430\u0440\u0435\u0432\u0448\u0438\u043c \u0438 \u0431\u0443\u0434\u0435\u0442 \u0443\u0434\u0430\u043b\u0451\u043d \u0432 \u0432\u0435\u0440\u0441\u0438\u0438 3.0. \u041f\u043e\u0436\u0430\u043b\u0443\u0439\u0441\u0442\u0430, \u043f\u043e\u043b\u044c\u0437\u0443\u0439\u0442\u0435\u0441\u044c ${newMethod}.",boundsAddError:"\u0424\u0443\u043d\u043a\u0446\u0438\u0438 add \u043d\u0430\u0434\u043e \u043f\u0435\u0440\u0435\u0434\u0430\u0432\u0430\u0442\u044c \u043e\u0431\u0430 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u044f, x \u0438 y.",
lonlatAddError:"\u0424\u0443\u043d\u043a\u0446\u0438\u0438 add \u043d\u0430\u0434\u043e \u043f\u0435\u0440\u0435\u0434\u0430\u0432\u0430\u0442\u044c \u043e\u0431\u0430 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u044f, lon \u0438 lat.",pixelAddError:"\u0424\u0443\u043d\u043a\u0446\u0438\u0438 add \u043d\u0430\u0434\u043e \u043f\u0435\u0440\u0435\u0434\u0430\u0432\u0430\u0442\u044c \u043e\u0431\u0430 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u044f, x \u0438 y.",unsupportedGeometryType:"\u041d\u0435\u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u043c\u044b\u0439 \u0442\u0438\u043f \u0433\u0435\u043e\u043c\u0435\u0442\u0440\u0438\u0438: ${geomType}",
filterEvaluateNotImplemented:"evaluate \u043d\u0435 \u0440\u0435\u0430\u043b\u0438\u0437\u043e\u0432\u0430\u043d\u043e \u0434\u043b\u044f \u0444\u0438\u043b\u044c\u0442\u0440\u0430 \u0434\u0430\u043d\u043d\u043e\u0433\u043e \u0442\u0438\u043f\u0430."});
OpenLayers.Format.CSWGetRecords.v2_0_2=OpenLayers.Class(OpenLayers.Format.XML,{namespaces:{csw:"http://www.opengis.net/cat/csw/2.0.2",dc:"http://purl.org/dc/elements/1.1/",dct:"http://purl.org/dc/terms/",geonet:"http://www.fao.org/geonetwork",ogc:"http://www.opengis.net/ogc",ows:"http://www.opengis.net/ows",xlink:"http://www.w3.org/1999/xlink",xsi:"http://www.w3.org/2001/XMLSchema-instance"},defaultPrefix:"csw",version:"2.0.2",schemaLocation:"http://www.opengis.net/cat/csw/2.0.2 http://schemas.opengis.net/csw/2.0.2/CSW-discovery.xsd",
requestId:null,resultType:null,outputFormat:null,outputSchema:null,startPosition:null,maxRecords:null,DistributedSearch:null,ResponseHandler:null,Query:null,regExes:{trimSpace:/^\s*|\s*$/g,removeSpace:/\s*/g,splitSpace:/\s+/,trimComma:/\s*,\s*/g},initialize:function(a){OpenLayers.Format.XML.prototype.initialize.apply(this,[a])},read:function(a){if(typeof a=="string")a=OpenLayers.Format.XML.prototype.read.apply(this,[a]);if(a&&a.nodeType==9)a=a.documentElement;var b={};this.readNode(a,b);return b},
readers:{csw:{GetRecordsResponse:function(a,b){b.records=[];this.readChildNodes(a,b);var c=this.getAttributeNS(a,"","version");if(c!="")b.version=c},RequestId:function(a,b){b.RequestId=this.getChildValue(a)},SearchStatus:function(a,b){b.SearchStatus={};var c=this.getAttributeNS(a,"","timestamp");if(c!="")b.SearchStatus.timestamp=c},SearchResults:function(a,b){this.readChildNodes(a,b);for(var c=a.attributes,d={},e=0,f=c.length;e<f;++e)d[c[e].name]=c[e].name=="numberOfRecordsMatched"||c[e].name=="numberOfRecordsReturned"||
c[e].name=="nextRecord"?parseInt(c[e].nodeValue):c[e].nodeValue;b.SearchResults=d},SummaryRecord:function(a,b){var c={type:"SummaryRecord"};this.readChildNodes(a,c);b.records.push(c)},BriefRecord:function(a,b){var c={type:"BriefRecord"};this.readChildNodes(a,c);b.records.push(c)},DCMIRecord:function(a,b){var c={type:"DCMIRecord"};this.readChildNodes(a,c);b.records.push(c)},Record:function(a,b){var c={type:"Record"};this.readChildNodes(a,c);b.records.push(c)},"*":function(a,b){var c=a.localName||a.nodeName.split(":").pop();
b[c]=this.getChildValue(a)}},geonet:{info:function(a,b){var c={};this.readChildNodes(a,c);b.gninfo=c}},dc:{"*":function(a,b){var c=a.localName||a.nodeName.split(":").pop();OpenLayers.Util.isArray(b[c])||(b[c]=[]);for(var d={},e=a.attributes,f=0,g=e.length;f<g;++f)d[e[f].name]=e[f].nodeValue;d.value=this.getChildValue(a);b[c].push(d)}},dct:{"*":function(a,b){var c=a.localName||a.nodeName.split(":").pop();OpenLayers.Util.isArray(b[c])||(b[c]=[]);b[c].push(this.getChildValue(a))}},ows:OpenLayers.Util.applyDefaults({BoundingBox:function(a,
b){if(b.bounds){b.BoundingBox=[{crs:b.projection,value:[b.bounds.left,b.bounds.bottom,b.bounds.right,b.bounds.top]}];delete b.projection;delete b.bounds}OpenLayers.Format.OWSCommon.v1_0_0.prototype.readers.ows.BoundingBox.apply(this,arguments)}},OpenLayers.Format.OWSCommon.v1_0_0.prototype.readers.ows)},write:function(a){a=this.writeNode("csw:GetRecords",a);return OpenLayers.Format.XML.prototype.write.apply(this,[a])},writers:{csw:{GetRecords:function(a){a||(a={});var b=this.createElementNSPlus("csw:GetRecords",
{attributes:{service:"CSW",version:this.version,requestId:a.requestId||this.requestId,resultType:a.resultType||this.resultType,outputFormat:a.outputFormat||this.outputFormat,outputSchema:a.outputSchema||this.outputSchema,startPosition:a.startPosition||this.startPosition,maxRecords:a.maxRecords||this.maxRecords}});if(a.DistributedSearch||this.DistributedSearch)this.writeNode("csw:DistributedSearch",a.DistributedSearch||this.DistributedSearch,b);var c=a.ResponseHandler||this.ResponseHandler;if(OpenLayers.Util.isArray(c)&&
c.length>0)for(var d=0,e=c.length;d<e;d++)this.writeNode("csw:ResponseHandler",c[d],b);this.writeNode("Query",a.Query||this.Query,b);return b},DistributedSearch:function(a){return this.createElementNSPlus("csw:DistributedSearch",{attributes:{hopCount:a.hopCount}})},ResponseHandler:function(a){return this.createElementNSPlus("csw:ResponseHandler",{value:a.value})},Query:function(a){a||(a={});var b=this.createElementNSPlus("csw:Query",{attributes:{typeNames:a.typeNames||"csw:Record"}}),c=a.ElementName;
if(OpenLayers.Util.isArray(c)&&c.length>0)for(var d=0,e=c.length;d<e;d++)this.writeNode("csw:ElementName",c[d],b);else this.writeNode("csw:ElementSetName",a.ElementSetName||{value:"summary"},b);a.Constraint&&this.writeNode("csw:Constraint",a.Constraint,b);a.SortBy&&this.writeNode("ogc:SortBy",a.SortBy,b);return b},ElementName:function(a){return this.createElementNSPlus("csw:ElementName",{value:a.value})},ElementSetName:function(a){return this.createElementNSPlus("csw:ElementSetName",{attributes:{typeNames:a.typeNames},
value:a.value})},Constraint:function(a){var b=this.createElementNSPlus("csw:Constraint",{attributes:{version:a.version}});if(a.Filter){var c=new OpenLayers.Format.Filter({version:a.version});b.appendChild(c.write(a.Filter))}else if(a.CqlText){a=this.createElementNSPlus("CqlText",{value:a.CqlText.value});b.appendChild(a)}return b}},ogc:OpenLayers.Format.Filter.v1_1_0.prototype.writers.ogc},CLASS_NAME:"OpenLayers.Format.CSWGetRecords.v2_0_2"});
OpenLayers.Lang.hsb=OpenLayers.Util.applyDefaults({unhandledRequest:"Wotmo\u0142wa njewobd\u017a\u011b\u0142aneho napra\u0161owanja ${statusText}",Permalink:"Trajny wotkaz",Overlays:"Nawor\u0161towanja","Base Layer":"Zak\u0142adna runina",readNotImplemented:"\u010citanje njeimplementowane.",writeNotImplemented:"Pisanje njeimplementowane.",noFID:"Funkcija, za kotru\u017e FID njeje, njeda so aktualizowa\u0107.",errorLoadingGML:"Zmylk p\u0159i za\u010ditowanju dataje ${url}",browserNotSupported:"Tw\u00f3j wobhladowak wektorowe rysowanje njepodp\u011bruje. Tuchwilu podp\u011browane rysowaki su:\n${renderers}",
componentShouldBe:"addFeatures: komponenta m\u011b\u0142a ${geomType} by\u0107",getFeatureError:"getFeatureFromEvent bu na wor\u0161\u0107e bjez rysowak zawo\u0142any. To zwjet\u0161a woznamjenja, zo sy wor\u0161tu zni\u010di\u0142, ale nic wobd\u017a\u011b\u0142ak, kotry\u017e je z njej zwjazany.",minZoomLevelError:"Kajkos\u0107 minZoomLevel je jeno\u017e za wu\u017eiwanje z wor\u0161tami myslena, kotre\u017e wot FixedZoomLevels pochad\u017aeja. Zo tuta wor\u0161ta wfs za minZoomLevel p\u0159epruwuje, je relikt za\u0144d\u017aenos\u0107e. Njem\u00f3\u017eemy w\u0161ak ju wotstroni\u0107, bjeztoho zo aplikacije, kotre\u017e na OpenLayers baz\u011bruja a snano tutu kajkos\u0107 wu\u017eiwaja, hi\u017eo njefunguja. Tohodla smy ju jako zestarjenu woznamjenili -- p\u0159epruwowanje za minZoomLevel budu so we wersiji 3.0 wotstronje\u0107. Pro\u0161u wu\u017eij m\u011bsto toho nastajenje min/max, ka\u017e je tu wopisane: http://trac.openlayers.org/wiki/SettingZoomLevels",
commitSuccess:"WFS-Transakcija: WUSP\u011a\u0160NA ${response}",commitFailed:"WFS-Transakcija: NJEPORAD\u0179ENA ${response}",googleWarning:"Wor\u0161ta Google njem\u00f3\u017ee\u0161e so korektnje za\u010dita\u0107.<br><br>Zo by tutu zd\u017a\u011blenku wotby\u0142, wubjer nowy BaseLayer z wub\u011bra wor\u0161tow horjeka naprawo.<br><br>Najskerje so to stawa, dokel\u017e skript biblioteki Google Maps pak njebu zap\u0159ijaty pak njewobsahuje korektny klu\u010d API za twoje syd\u0142o.<br><br>Wuwiwarjo: Za pomoc ke korektnemu fungowanju wor\u0161tow\n<a href='http://trac.openlayers.org/wiki/Google' target='_blank'>tu klikny\u0107</a>",
getLayerWarning:"Wor\u0161ta ${layerType} njem\u00f3\u017ee\u0161e so korektnje za\u010dita\u0107.<br><br>Zo by tutu zd\u017a\u011blenku wotby\u0142, wubjer nowy BaseLayer z wub\u011bra wor\u0161tow horjeka naprawo.<br><br>Najskerje so to stawa, dokel\u017e skript biblioteki ${layerLib} njebu korektnje zap\u0159ijaty.<br><br>Wuwiwarjo: Za pomoc ke korektnemu fungowanju wor\u0161tow\n<a href='http://trac.openlayers.org/wiki/${layerLib}' target='_blank'>tu klikny\u0107</a>","Scale = 1 : ${scaleDenom}":"M\u011britko = 1 : ${scaleDenom}",
W:"Z",E:"W",N:"S",S:"J",layerAlreadyAdded:"Sy spyta\u0142 runinu ${layerName} kar\u0107e doda\u0107, ale je so hi\u017eo doda\u0142a",reprojectDeprecated:'Wu\u017eiwa\u0161 opciju "reproject" wo\u0159\u0161ty ${layerName}. Tuta opcija je zestarjena: jeje wu\u017eiwanje b\u011b myslene, zo by zwobraznjenje datow nad komercielnymi bazowymi kartami podp\u011bra\u0142o, ale funkcionalnos\u0107 m\u011b\u0142a so n\u011btko z pomocu Sperical Mercator docp\u011b\u0107. Dal\u0161e informacije steja na http://trac.openlayers.org/wiki/SphericalMercator k dispoziciji.',
methodDeprecated:"Tuta metoda je so njeschwali\u0142a a bud\u017ae so w 3.0 wotstronje\u0107. Pro\u0161u wu\u017eij ${newMethod} m\u011bsto toho.",boundsAddError:'Dyrbi\u0161 h\u00f3dnotu x ka\u017e te\u017e y funkciji "add" p\u0159epoda\u0107.',lonlatAddError:'Dyrbi\u0161 h\u00f3dnotu lon ka\u017e te\u017e lat funkciji "add" p\u0159epoda\u0107.',pixelAddError:'Dyrbi\u0161 h\u00f3dnotu x ka\u017e te\u017e y funkciji "add" p\u0159epoda\u0107.',unsupportedGeometryType:"Njepodp\u011browany geometrijowy typ: ${geomType}",
filterEvaluateNotImplemented:"wuh\u00f3dno\u0107enje njeje za tut\u00f3n filtrowy typ implementowany."});
OpenLayers.Lang.de=OpenLayers.Util.applyDefaults({unhandledRequest:"Unbehandelte Anfrager\u00fcckmeldung ${statusText}",Permalink:"Permalink",Overlays:"Overlays","Base Layer":"Grundkarte",readNotImplemented:"Lesen nicht implementiert.",writeNotImplemented:"Schreiben nicht implementiert.",noFID:"Ein Feature, f\u00fcr das keine FID existiert, kann nicht aktualisiert werden.",errorLoadingGML:"Fehler beim Laden der GML-Datei ${url}",browserNotSupported:"Ihr Browser unterst\u00fctzt keine Vektordarstellung. Aktuell unterst\u00fctzte Renderer:\n${renderers}",
componentShouldBe:"addFeatures: Komponente muss vom Typ ${geomType} sein",getFeatureError:"getFeatureFromEvent wurde vom einem Layer ohne Renderer aufgerufen. Dies bedeutet normalerweise, dass ein Layer entfernt wurde, aber nicht Handler, die auf ihn verweisen.",minZoomLevelError:"Die <code>minZoomLevel</code>-Eigenschaft ist nur f\u00fcr die Verwendung mit <code>FixedZoomLevels</code>-untergeordneten Layers vorgesehen. Das dieser <tt>wfs</tt>-Layer die <code>minZoomLevel</code>-Eigenschaft \u00fcberpr\u00fcft ist ein Relikt der Vergangenheit. Wir k\u00f6nnen diese \u00dcberpr\u00fcfung nicht entfernen, ohne das OL basierende Applikationen nicht mehr funktionieren. Daher markieren wir es als veraltet - die <code>minZoomLevel</code>-\u00dcberpr\u00fcfung wird in Version 3.0 entfernt werden. Bitte verwenden Sie stattdessen die Min-/Max-L\u00f6sung, wie sie unter http://trac.openlayers.org/wiki/SettingZoomLevels beschrieben ist.",
commitSuccess:"WFS-Transaktion: Erfolgreich ${response}",commitFailed:"WFS-Transaktion: Fehlgeschlagen ${response}",googleWarning:"Der Google-Layer konnte nicht korrekt geladen werden.<br><br>Um diese Meldung nicht mehr zu erhalten, w\u00e4hlen Sie einen anderen Hintergrundlayer aus dem LayerSwitcher in der rechten oberen Ecke.<br><br>Sehr wahrscheinlich tritt dieser Fehler auf, weil das Skript der Google-Maps-Bibliothek nicht eingebunden wurde oder keinen g\u00fcltigen API-Schl\u00fcssel f\u00fcr Ihre URL enth\u00e4lt.<br><br>Entwickler: Besuche <a href='http://trac.openlayers.org/wiki/Google' target='_blank'>das Wiki</a> f\u00fcr Hilfe zum korrekten Einbinden des Google-Layers",
getLayerWarning:"Der ${layerType}-Layer konnte nicht korrekt geladen werden.<br><br>Um diese Meldung nicht mehr zu erhalten, w\u00e4hlen Sie einen anderen Hintergrundlayer aus dem LayerSwitcher in der rechten oberen Ecke.<br><br>Sehr wahrscheinlich tritt dieser Fehler auf, weil das Skript der '${layerLib}'-Bibliothek nicht eingebunden wurde.<br><br>Entwickler: Besuche <a href='http://trac.openlayers.org/wiki/${layerLib}' target='_blank'>das Wiki</a> f\u00fcr Hilfe zum korrekten Einbinden von Layern",
"Scale = 1 : ${scaleDenom}":"Ma\u00dfstab = 1 : ${scaleDenom}",W:"W",E:"O",N:"N",S:"S",layerAlreadyAdded:"Sie versuchen den Layer \u201e${layerName}\u201c zur Karte hinzuzuf\u00fcgen, er wurde aber bereits hinzugef\u00fcgt",reprojectDeprecated:"Sie verwenden die \u201eReproject\u201c-Option des Layers ${layerName}. Diese Option ist veraltet: Sie wurde entwickelt um die Anzeige von Daten auf kommerziellen Basiskarten zu unterst\u00fctzen, aber diese Funktion sollte jetzt durch Unterst\u00fctzung der \u201eSpherical Mercator\u201c erreicht werden. Weitere Informationen sind unter http://trac.openlayers.org/wiki/SphericalMercator verf\u00fcgbar.",
methodDeprecated:"Die Methode ist veraltet und wird in 3.0 entfernt. Bitte verwende stattdessen ${newMethod}.",boundsAddError:"Beide Werte (x und y) m\u00fcssen der add-Funktion \u00fcbergeben werden.",lonlatAddError:"Beide Werte (lon und lat) m\u00fcssen der add-Funktion \u00fcbergeben werden.",pixelAddError:"Beide Werte (x und y) m\u00fcssen der add-Funktion \u00fcbergeben werden.",unsupportedGeometryType:"Nicht unterst\u00fctzter Geometrie-Typ: ${geomType}",filterEvaluateNotImplemented:"\u201eevaluate\u201c ist f\u00fcr diesen Filter-Typ nicht implementiert."});
OpenLayers.Marker.Box=OpenLayers.Class(OpenLayers.Marker,{bounds:null,div:null,initialize:function(a,b,c){this.bounds=a;this.div=OpenLayers.Util.createDiv();this.div.style.overflow="hidden";this.events=new OpenLayers.Events(this,this.div,null);this.setBorder(b,c)},destroy:function(){this.div=this.bounds=null;OpenLayers.Marker.prototype.destroy.apply(this,arguments)},setBorder:function(a,b){a||(a="red");b||(b=2);this.div.style.border=b+"px solid "+a},draw:function(a,b){OpenLayers.Util.modifyDOMElement(this.div,
null,a,b);return this.div},onScreen:function(){var a=false;if(this.map)a=this.map.getExtent().containsBounds(this.bounds,true,true);return a},display:function(a){this.div.style.display=a?"":"none"},CLASS_NAME:"OpenLayers.Marker.Box"});
OpenLayers.Format.Text=OpenLayers.Class(OpenLayers.Format,{defaultStyle:null,extractStyles:true,initialize:function(a){a=a||{};if(a.extractStyles!==false)a.defaultStyle={externalGraphic:OpenLayers.Util.getImagesLocation()+"marker.png",graphicWidth:21,graphicHeight:25,graphicXOffset:-10.5,graphicYOffset:-12.5};OpenLayers.Format.prototype.initialize.apply(this,[a])},read:function(a){a=a.split("\n");for(var b,c=[],d=0;d<a.length-1;d++){var e=a[d].replace(/^\s*/,"").replace(/\s*$/,"");if(e.charAt(0)!=
"#")if(b){e=e.split("\t");for(var f=new OpenLayers.Geometry.Point(0,0),g={},h=this.defaultStyle?OpenLayers.Util.applyDefaults({},this.defaultStyle):null,j=false,i=0;i<e.length;i++)if(e[i])if(b[i]=="point"){j=e[i].split(",");f.y=parseFloat(j[0]);f.x=parseFloat(j[1]);j=true}else if(b[i]=="lat"){f.y=parseFloat(e[i]);j=true}else if(b[i]=="lon"){f.x=parseFloat(e[i]);j=true}else if(b[i]=="title")g.title=e[i];else if(b[i]=="image"||b[i]=="icon"&&h)h.externalGraphic=e[i];else if(b[i]=="iconSize"&&h){var k=
e[i].split(",");h.graphicWidth=parseFloat(k[0]);h.graphicHeight=parseFloat(k[1])}else if(b[i]=="iconOffset"&&h){k=e[i].split(",");h.graphicXOffset=parseFloat(k[0]);h.graphicYOffset=parseFloat(k[1])}else if(b[i]=="description")g.description=e[i];else if(b[i]=="overflow")g.overflow=e[i];else g[b[i]]=e[i];if(j){this.internalProjection&&this.externalProjection&&f.transform(this.externalProjection,this.internalProjection);e=new OpenLayers.Feature.Vector(f,g,h);c.push(e)}}else b=e.split("\t")}return c},
CLASS_NAME:"OpenLayers.Format.Text"});
OpenLayers.Layer.Text=OpenLayers.Class(OpenLayers.Layer.Markers,{location:null,features:null,formatOptions:null,selectedFeature:null,initialize:function(){OpenLayers.Layer.Markers.prototype.initialize.apply(this,arguments);this.features=[]},destroy:function(){OpenLayers.Layer.Markers.prototype.destroy.apply(this,arguments);this.clearFeatures();this.features=null},loadText:function(){if(!this.loaded)if(this.location!=null){this.events.triggerEvent("loadstart");OpenLayers.Request.GET({url:this.location,
success:this.parseData,failure:function(){this.events.triggerEvent("loadend")},scope:this});this.loaded=true}},moveTo:function(){OpenLayers.Layer.Markers.prototype.moveTo.apply(this,arguments);this.visibility&&!this.loaded&&this.loadText()},parseData:function(a){a=a.responseText;var b={};OpenLayers.Util.extend(b,this.formatOptions);if(this.map&&!this.projection.equals(this.map.getProjectionObject())){b.externalProjection=this.projection;b.internalProjection=this.map.getProjectionObject()}a=(new OpenLayers.Format.Text(b)).read(a);
b=0;for(var c=a.length;b<c;b++){var d={},e=a[b],f,g,h;f=new OpenLayers.LonLat(e.geometry.x,e.geometry.y);if(e.style.graphicWidth&&e.style.graphicHeight)g=new OpenLayers.Size(e.style.graphicWidth,e.style.graphicHeight);if(e.style.graphicXOffset!==undefined&&e.style.graphicYOffset!==undefined)h=new OpenLayers.Pixel(e.style.graphicXOffset,e.style.graphicYOffset);if(e.style.externalGraphic!=null)d.icon=new OpenLayers.Icon(e.style.externalGraphic,g,h);else{d.icon=OpenLayers.Marker.defaultIcon();g!=null&&
d.icon.setSize(g)}if(e.attributes.title!=null&&e.attributes.description!=null)d.popupContentHTML="<h2>"+e.attributes.title+"</h2><p>"+e.attributes.description+"</p>";d.overflow=e.attributes.overflow||"auto";d=new OpenLayers.Feature(this,f,d);this.features.push(d);f=d.createMarker();e.attributes.title!=null&&e.attributes.description!=null&&f.events.register("click",d,this.markerClick);this.addMarker(f)}this.events.triggerEvent("loadend")},markerClick:function(a){var b=this==this.layer.selectedFeature;
this.layer.selectedFeature=!b?this:null;for(var c=0,d=this.layer.map.popups.length;c<d;c++)this.layer.map.removePopup(this.layer.map.popups[c]);b||this.layer.map.addPopup(this.createPopup());OpenLayers.Event.stop(a)},clearFeatures:function(){if(this.features!=null)for(;this.features.length>0;){var a=this.features[0];OpenLayers.Util.removeItem(this.features,a);a.destroy()}},CLASS_NAME:"OpenLayers.Layer.Text"});
OpenLayers.Handler.RegularPolygon=OpenLayers.Class(OpenLayers.Handler.Drag,{sides:4,radius:null,snapAngle:null,snapToggle:"shiftKey",layerOptions:null,persist:false,irregular:false,angle:null,fixedRadius:false,feature:null,layer:null,origin:null,initialize:function(a,b,c){if(!(c&&c.layerOptions&&c.layerOptions.styleMap))this.style=OpenLayers.Util.extend(OpenLayers.Feature.Vector.style["default"],{});OpenLayers.Handler.Drag.prototype.initialize.apply(this,[a,b,c]);this.options=c?c:{}},setOptions:function(a){OpenLayers.Util.extend(this.options,
a);OpenLayers.Util.extend(this,a)},activate:function(){var a=false;if(OpenLayers.Handler.Drag.prototype.activate.apply(this,arguments)){a=OpenLayers.Util.extend({displayInLayerSwitcher:false,calculateInRange:OpenLayers.Function.True},this.layerOptions);this.layer=new OpenLayers.Layer.Vector(this.CLASS_NAME,a);this.map.addLayer(this.layer);a=true}return a},deactivate:function(){var a=false;if(OpenLayers.Handler.Drag.prototype.deactivate.apply(this,arguments)){this.dragging&&this.cancel();if(this.layer.map!=
null){this.layer.destroy(false);this.feature&&this.feature.destroy()}this.feature=this.layer=null;a=true}return a},down:function(a){this.fixedRadius=!!this.radius;a=this.map.getLonLatFromPixel(a.xy);this.origin=new OpenLayers.Geometry.Point(a.lon,a.lat);if(!this.fixedRadius||this.irregular)this.radius=this.map.getResolution();this.persist&&this.clear();this.feature=new OpenLayers.Feature.Vector;this.createGeometry();this.callback("create",[this.origin,this.feature]);this.layer.addFeatures([this.feature],
{silent:true});this.layer.drawFeature(this.feature,this.style)},move:function(a){var b=this.map.getLonLatFromPixel(a.xy);b=new OpenLayers.Geometry.Point(b.lon,b.lat);if(this.irregular){a=Math.sqrt(2)*Math.abs(b.y-this.origin.y)/2;this.radius=Math.max(this.map.getResolution()/2,a)}else if(this.fixedRadius)this.origin=b;else{this.calculateAngle(b,a);this.radius=Math.max(this.map.getResolution()/2,b.distanceTo(this.origin))}this.modifyGeometry();if(this.irregular){a=b.x-this.origin.x;b=b.y-this.origin.y;
this.feature.geometry.resize(1,this.origin,b==0?a/(this.radius*Math.sqrt(2)):a/b);this.feature.geometry.move(a/2,b/2)}this.layer.drawFeature(this.feature,this.style)},up:function(a){this.finalize();this.start==this.last&&this.callback("done",[a.xy])},out:function(){this.finalize()},createGeometry:function(){this.angle=Math.PI*(1/this.sides-0.5);if(this.snapAngle)this.angle+=this.snapAngle*(Math.PI/180);this.feature.geometry=OpenLayers.Geometry.Polygon.createRegularPolygon(this.origin,this.radius,
this.sides,this.snapAngle)},modifyGeometry:function(){var a,b,c=this.feature.geometry.components[0];if(c.components.length!=this.sides+1){this.createGeometry();c=this.feature.geometry.components[0]}for(var d=0;d<this.sides;++d){b=c.components[d];a=this.angle+d*2*Math.PI/this.sides;b.x=this.origin.x+this.radius*Math.cos(a);b.y=this.origin.y+this.radius*Math.sin(a);b.clearBounds()}},calculateAngle:function(a,b){var c=Math.atan2(a.y-this.origin.y,a.x-this.origin.x);if(this.snapAngle&&this.snapToggle&&
!b[this.snapToggle]){var d=Math.PI/180*this.snapAngle;this.angle=Math.round(c/d)*d}else this.angle=c},cancel:function(){this.callback("cancel",null);this.finalize()},finalize:function(){this.origin=null;this.radius=this.options.radius},clear:function(){if(this.layer){this.layer.renderer.clear();this.layer.destroyFeatures()}},callback:function(a){this.callbacks[a]&&this.callbacks[a].apply(this.control,[this.feature.geometry.clone()]);if(!this.persist&&(a=="done"||a=="cancel"))this.clear()},CLASS_NAME:"OpenLayers.Handler.RegularPolygon"});
OpenLayers.Control.SLDSelect=OpenLayers.Class(OpenLayers.Control,{EVENT_TYPES:["selected"],clearOnDeactivate:false,layers:null,callbacks:null,selectionSymbolizer:{Polygon:{fillColor:"#FF0000",stroke:false},Line:{strokeColor:"#FF0000",strokeWidth:2},Point:{graphicName:"square",fillColor:"#FF0000",pointRadius:5}},layerOptions:null,handlerOptions:null,sketchStyle:null,wfsCache:{},layerCache:{},initialize:function(a,b){this.EVENT_TYPES=OpenLayers.Control.SLDSelect.prototype.EVENT_TYPES.concat(OpenLayers.Control.prototype.EVENT_TYPES);
OpenLayers.Control.prototype.initialize.apply(this,[b]);this.callbacks=OpenLayers.Util.extend({done:this.select,click:this.select},this.callbacks);this.handlerOptions=this.handlerOptions||{};this.layerOptions=OpenLayers.Util.applyDefaults(this.layerOptions,{displayInLayerSwitcher:false,tileOptions:{maxGetUrlLength:2048}});if(this.sketchStyle)this.handlerOptions.layerOptions=OpenLayers.Util.applyDefaults(this.handlerOptions.layerOptions,{styleMap:new OpenLayers.StyleMap({"default":this.sketchStyle})});
this.handler=new a(this,this.callbacks,this.handlerOptions)},destroy:function(){for(var a in this.layerCache)delete this.layerCache[a];for(a in this.wfsCache)delete this.wfsCache[a];OpenLayers.Control.prototype.destroy.apply(this,arguments)},coupleLayerVisiblity:function(a){this.setVisibility(a.object.getVisibility())},createSelectionLayer:function(a){var b;if(this.layerCache[a.id])b=this.layerCache[a.id];else{b=new OpenLayers.Layer.WMS(a.name,a.url,a.params,OpenLayers.Util.applyDefaults(this.layerOptions,
a.getOptions()));this.layerCache[a.id]=b;if(this.layerOptions.displayInLayerSwitcher===false)a.events.on({visibilitychanged:this.coupleLayerVisiblity,scope:b});this.map.addLayer(b)}return b},createSLD:function(a,b,c){for(var d={version:"1.0.0",namedLayers:{}},e=(""+a.params.LAYERS).split(","),f=0,g=e.length;f<g;f++){var h=e[f];d.namedLayers[h]={name:h,userStyles:[]};var j=this.selectionSymbolizer,i=c[f];if(i.type.indexOf("Polygon")>=0)j={Polygon:this.selectionSymbolizer.Polygon};else if(i.type.indexOf("LineString")>=
0)j={Line:this.selectionSymbolizer.Line};else if(i.type.indexOf("Point")>=0)j={Point:this.selectionSymbolizer.Point};d.namedLayers[h].userStyles.push({name:"default",rules:[new OpenLayers.Rule({symbolizer:j,filter:b[f],maxScaleDenominator:a.options.minScale})]})}return(new OpenLayers.Format.SLD({srsName:this.map.getProjection()})).write(d)},parseDescribeLayer:function(a){var b=new OpenLayers.Format.WMSDescribeLayer,c=a.responseXML;if(!c||!c.documentElement)c=a.responseText;a=b.read(c);b=[];c=null;
for(var d=0,e=a.length;d<e;d++)if(a[d].owsType=="WFS"){b.push(a[d].typeName);c=a[d].owsURL}OpenLayers.Request.GET({url:c,params:{SERVICE:"WFS",TYPENAME:b.toString(),REQUEST:"DescribeFeatureType",VERSION:"1.0.0"},callback:function(f){var g=new OpenLayers.Format.WFSDescribeFeatureType,h=f.responseXML;if(!h||!h.documentElement)h=f.responseText;this.control.wfsCache[this.layer.id]=g.read(h);this.control._queue&&this.control.applySelection()},scope:this})},getGeometryAttributes:function(a){var b=[];a=
this.wfsCache[a.id];for(var c=0,d=a.featureTypes.length;c<d;c++)for(var e=a.featureTypes[c].properties,f=0,g=e.length;f<g;f++){var h=e[f],j=h.type;if(j.indexOf("LineString")>=0||j.indexOf("GeometryAssociationType")>=0||j.indexOf("GeometryPropertyType")>=0||j.indexOf("Point")>=0||j.indexOf("Polygon")>=0)b.push(h)}return b},activate:function(){var a=OpenLayers.Control.prototype.activate.call(this);if(a)for(var b=0,c=this.layers.length;b<c;b++){var d=this.layers[b];d&&!this.wfsCache[d.id]&&OpenLayers.Request.GET({url:d.url,
params:{SERVICE:"WMS",VERSION:d.params.VERSION,LAYERS:d.params.LAYERS,REQUEST:"DescribeLayer"},callback:this.parseDescribeLayer,scope:{layer:d,control:this}})}return a},deactivate:function(){var a=OpenLayers.Control.prototype.deactivate.call(this);if(a)for(var b=0,c=this.layers.length;b<c;b++){var d=this.layers[b];if(d&&this.clearOnDeactivate===true){var e=this.layerCache,f=e[d.id];if(f){d.events.un({visibilitychanged:this.coupleLayerVisiblity,scope:f});f.destroy();delete e[d.id]}}}return a},setLayers:function(a){if(this.active){this.deactivate();
this.layers=a;this.activate()}else this.layers=a},createFilter:function(a,b){var c=null;if(this.handler instanceof OpenLayers.Handler.RegularPolygon)c=this.handler.irregular===true?new OpenLayers.Filter.Spatial({type:OpenLayers.Filter.Spatial.BBOX,property:a.name,value:b.getBounds()}):new OpenLayers.Filter.Spatial({type:OpenLayers.Filter.Spatial.INTERSECTS,property:a.name,value:b});else if(this.handler instanceof OpenLayers.Handler.Polygon)c=new OpenLayers.Filter.Spatial({type:OpenLayers.Filter.Spatial.INTERSECTS,
property:a.name,value:b});else if(this.handler instanceof OpenLayers.Handler.Path)c=a.type.indexOf("Point")>=0?new OpenLayers.Filter.Spatial({type:OpenLayers.Filter.Spatial.DWITHIN,property:a.name,distance:this.map.getExtent().getWidth()*0.01,distanceUnits:this.map.getUnits(),value:b}):new OpenLayers.Filter.Spatial({type:OpenLayers.Filter.Spatial.INTERSECTS,property:a.name,value:b});else if(this.handler instanceof OpenLayers.Handler.Click)c=a.type.indexOf("Polygon")>=0?new OpenLayers.Filter.Spatial({type:OpenLayers.Filter.Spatial.INTERSECTS,
property:a.name,value:b}):new OpenLayers.Filter.Spatial({type:OpenLayers.Filter.Spatial.DWITHIN,property:a.name,distance:this.map.getExtent().getWidth()*0.01,distanceUnits:this.map.getUnits(),value:b});return c},select:function(a){this._queue=function(){for(var b=0,c=this.layers.length;b<c;b++){for(var d=this.layers[b],e=this.getGeometryAttributes(d),f=[],g=0,h=e.length;g<h;g++){var j=e[g];if(j!==null){if(!(a instanceof OpenLayers.Geometry)){var i=this.map.getLonLatFromPixel(a.xy);a=new OpenLayers.Geometry.Point(i.lon,
i.lat)}j=this.createFilter(j,a);j!==null&&f.push(j)}}g=this.createSelectionLayer(d);e=this.createSLD(d,f,e);this.events.triggerEvent("selected",{layer:d,filters:f});g.mergeNewParams({SLD_BODY:e});delete this._queue}};this.applySelection()},applySelection:function(){for(var a=true,b=0,c=this.layers.length;b<c;b++)if(!this.wfsCache[this.layers[b].id]){a=false;break}a&&this._queue.call(this)},CLASS_NAME:"OpenLayers.Control.SLDSelect"});
OpenLayers.Lang.fi=OpenLayers.Util.applyDefaults({Permalink:"Ikilinkki",Overlays:"Kerrokset","Base Layer":"Peruskerros",W:"L",E:"I",N:"P",S:"E"});
OpenLayers.Control.Scale=OpenLayers.Class(OpenLayers.Control,{element:null,geodesic:false,initialize:function(a,b){OpenLayers.Control.prototype.initialize.apply(this,[b]);this.element=OpenLayers.Util.getElement(a)},draw:function(){OpenLayers.Control.prototype.draw.apply(this,arguments);if(!this.element){this.element=document.createElement("div");this.div.appendChild(this.element)}this.map.events.register("moveend",this,this.updateScale);this.updateScale();return this.div},updateScale:function(){var a;
if(this.geodesic===true){if(!this.map.getUnits())return;a=OpenLayers.INCHES_PER_UNIT;a=(this.map.getGeodesicPixelSize().w||1.0E-6)*a.km*OpenLayers.DOTS_PER_INCH}else a=this.map.getScale();if(a){a=a>=9500&&a<=95E4?Math.round(a/1E3)+"K":a>=95E4?Math.round(a/1E6)+"M":Math.round(a);this.element.innerHTML=OpenLayers.i18n("Scale = 1 : ${scaleDenom}",{scaleDenom:a})}},CLASS_NAME:"OpenLayers.Control.Scale"});
OpenLayers.Control.Button=OpenLayers.Class(OpenLayers.Control,{type:OpenLayers.Control.TYPE_BUTTON,trigger:function(){},CLASS_NAME:"OpenLayers.Control.Button"});
OpenLayers.Layer.MapGuide=OpenLayers.Class(OpenLayers.Layer.Grid,{isBaseLayer:true,useHttpTile:false,singleTile:false,useOverlay:false,useAsyncOverlay:true,TILE_PARAMS:{operation:"GETTILEIMAGE",version:"1.2.0"},SINGLE_TILE_PARAMS:{operation:"GETMAPIMAGE",format:"PNG",locale:"en",clip:"1",version:"1.0.0"},OVERLAY_PARAMS:{operation:"GETDYNAMICMAPOVERLAYIMAGE",format:"PNG",locale:"en",clip:"1",version:"2.0.0"},FOLDER_PARAMS:{tileColumnsPerFolder:30,tileRowsPerFolder:30,format:"png",querystring:null},
defaultSize:new OpenLayers.Size(300,300),tileOriginCorner:"tl",initialize:function(a,b,c,d){OpenLayers.Layer.Grid.prototype.initialize.apply(this,arguments);if(d==null||d.isBaseLayer==null)this.isBaseLayer=this.transparent!="true"&&this.transparent!=true;if(d&&d.useOverlay!=null)this.useOverlay=d.useOverlay;if(this.singleTile)if(this.useOverlay){OpenLayers.Util.applyDefaults(this.params,this.OVERLAY_PARAMS);if(!this.useAsyncOverlay)this.params.version="1.0.0"}else OpenLayers.Util.applyDefaults(this.params,
this.SINGLE_TILE_PARAMS);else{this.useHttpTile?OpenLayers.Util.applyDefaults(this.params,this.FOLDER_PARAMS):OpenLayers.Util.applyDefaults(this.params,this.TILE_PARAMS);this.setTileSize(this.defaultSize)}},clone:function(a){if(a==null)a=new OpenLayers.Layer.MapGuide(this.name,this.url,this.params,this.getOptions());return a=OpenLayers.Layer.Grid.prototype.clone.apply(this,[a])},getURL:function(a){var b;b=a.getCenterLonLat();var c=this.map.getSize();if(this.singleTile){a={setdisplaydpi:OpenLayers.DOTS_PER_INCH,
setdisplayheight:c.h*this.ratio,setdisplaywidth:c.w*this.ratio,setviewcenterx:b.lon,setviewcentery:b.lat,setviewscale:this.map.getScale()};if(this.useOverlay&&!this.useAsyncOverlay){b={};b=OpenLayers.Util.extend(b,a);b.operation="GETVISIBLEMAPEXTENT";b.version="1.0.0";b.session=this.params.session;b.mapName=this.params.mapName;b.format="text/xml";b=this.getFullRequestString(b);OpenLayers.Request.GET({url:b,async:false})}b=this.getFullRequestString(a)}else{c=this.map.getResolution();b=Math.floor((a.left-
this.maxExtent.left)/c);b=Math.round(b/this.tileSize.w);a=Math.floor((this.maxExtent.top-a.top)/c);a=Math.round(a/this.tileSize.h);b=this.useHttpTile?this.getImageFilePath({tilecol:b,tilerow:a,scaleindex:this.resolutions.length-this.map.zoom-1}):this.getFullRequestString({tilecol:b,tilerow:a,scaleindex:this.resolutions.length-this.map.zoom-1})}return b},getFullRequestString:function(a,b){var c=b==null?this.url:b;if(typeof c=="object")c=c[Math.floor(Math.random()*c.length)];var d=c,e=OpenLayers.Util.extend({},
this.params);e=OpenLayers.Util.extend(e,a);var f=OpenLayers.Util.upperCaseObject(OpenLayers.Util.getParameters(c)),g;for(g in e)g.toUpperCase()in f&&delete e[g];e=OpenLayers.Util.getParameterString(e);e=e.replace(/,/g,"+");if(e!=""){f=c.charAt(c.length-1);d+=f=="&"||f=="?"?e:c.indexOf("?")==-1?"?"+e:"&"+e}return d},getImageFilePath:function(a,b){var c=b==null?this.url:b;if(typeof c=="object")c=c[Math.floor(Math.random()*c.length)];var d="",e="";if(a.tilerow<0)d="-";d+=a.tilerow==0?"0":Math.floor(Math.abs(a.tilerow/
this.params.tileRowsPerFolder))*this.params.tileRowsPerFolder;if(a.tilecol<0)e="-";e+=a.tilecol==0?"0":Math.floor(Math.abs(a.tilecol/this.params.tileColumnsPerFolder))*this.params.tileColumnsPerFolder;d="/S"+Math.floor(a.scaleindex)+"/"+this.params.basemaplayergroupname+"/R"+d+"/C"+e+"/"+a.tilerow%this.params.tileRowsPerFolder+"_"+a.tilecol%this.params.tileColumnsPerFolder+"."+this.params.format;if(this.params.querystring)d+="?"+this.params.querystring;c+=d;return c},calculateGridLayout:function(a,
b,c){var d=c*this.tileSize.w;c*=this.tileSize.h;var e=a.left-b.lon,f=Math.floor(e/d)-this.buffer;a=b.lat-a.top+c;var g=Math.floor(a/c)-this.buffer;return{tilelon:d,tilelat:c,tileoffsetlon:b.lon+f*d,tileoffsetlat:b.lat-c*g,tileoffsetx:-(e/d-f)*this.tileSize.w,tileoffsety:(g-a/c)*this.tileSize.h}},CLASS_NAME:"OpenLayers.Layer.MapGuide"});
OpenLayers.Control.Measure=OpenLayers.Class(OpenLayers.Control,{EVENT_TYPES:["measure","measurepartial"],handlerOptions:null,callbacks:null,displaySystem:"metric",geodesic:false,displaySystemUnits:{geographic:["dd"],english:["mi","ft","in"],metric:["km","m"]},partialDelay:300,delayedTrigger:null,persist:false,immediate:false,initialize:function(a,b){this.EVENT_TYPES=OpenLayers.Control.Measure.prototype.EVENT_TYPES.concat(OpenLayers.Control.prototype.EVENT_TYPES);OpenLayers.Control.prototype.initialize.apply(this,
[b]);var c={done:this.measureComplete,point:this.measurePartial};if(this.immediate)c.modify=this.measureImmediate;this.callbacks=OpenLayers.Util.extend(c,this.callbacks);this.handlerOptions=OpenLayers.Util.extend({persist:this.persist},this.handlerOptions);this.handler=new a(this,this.callbacks,this.handlerOptions)},deactivate:function(){this.cancelDelay();return OpenLayers.Control.prototype.deactivate.apply(this,arguments)},cancel:function(){this.cancelDelay();this.handler.cancel()},setImmediate:function(a){if(this.immediate=
a)this.callbacks.modify=this.measureImmediate;else delete this.callbacks.modify},updateHandler:function(a,b){var c=this.active;c&&this.deactivate();this.handler=new a(this,this.callbacks,b);c&&this.activate()},measureComplete:function(a){this.cancelDelay();this.measure(a,"measure")},measurePartial:function(a,b){this.cancelDelay();b=b.clone();if(this.handler.freehandMode(this.handler.evt))this.measure(b,"measurepartial");else this.delayedTrigger=window.setTimeout(OpenLayers.Function.bind(function(){this.delayedTrigger=
null;this.measure(b,"measurepartial")},this),this.partialDelay)},measureImmediate:function(a,b,c){c&&this.delayedTrigger===null&&!this.handler.freehandMode(this.handler.evt)&&this.measure(b.geometry,"measurepartial")},cancelDelay:function(){if(this.delayedTrigger!==null){window.clearTimeout(this.delayedTrigger);this.delayedTrigger=null}},measure:function(a,b){var c,d;if(a.CLASS_NAME.indexOf("LineString")>-1){c=this.getBestLength(a);d=1}else{c=this.getBestArea(a);d=2}this.events.triggerEvent(b,{measure:c[0],
units:c[1],order:d,geometry:a})},getBestArea:function(a){for(var b=this.displaySystemUnits[this.displaySystem],c,d,e=0,f=b.length;e<f;++e){c=b[e];d=this.getArea(a,c);if(d>1)break}return[d,c]},getArea:function(a,b){var c,d;if(this.geodesic){c=a.getGeodesicArea(this.map.getProjectionObject());d="m"}else{c=a.getArea();d=this.map.getUnits()}var e=OpenLayers.INCHES_PER_UNIT[b];if(e)c*=Math.pow(OpenLayers.INCHES_PER_UNIT[d]/e,2);return c},getBestLength:function(a){for(var b=this.displaySystemUnits[this.displaySystem],
c,d,e=0,f=b.length;e<f;++e){c=b[e];d=this.getLength(a,c);if(d>1)break}return[d,c]},getLength:function(a,b){var c,d;if(this.geodesic){c=a.getGeodesicLength(this.map.getProjectionObject());d="m"}else{c=a.getLength();d=this.map.getUnits()}var e=OpenLayers.INCHES_PER_UNIT[b];if(e)c*=OpenLayers.INCHES_PER_UNIT[d]/e;return c},CLASS_NAME:"OpenLayers.Control.Measure"});
OpenLayers.Format.WMC.v1_0_0=OpenLayers.Class(OpenLayers.Format.WMC.v1,{VERSION:"1.0.0",schemaLocation:"http://www.opengis.net/context http://schemas.opengis.net/context/1.0.0/context.xsd",initialize:function(a){OpenLayers.Format.WMC.v1.prototype.initialize.apply(this,[a])},read_wmc_SRS:function(a,b){var c=this.getChildValue(b);if(typeof a.projections!="object")a.projections={};c=c.split(/ +/);for(var d=0,e=c.length;d<e;d++)a.projections[c[d]]=true},write_wmc_Layer:function(a){var b=OpenLayers.Format.WMC.v1.prototype.write_wmc_Layer.apply(this,
[a]);if(a.srs){var c=[],d;for(d in a.srs)c.push(d);b.appendChild(this.createElementDefaultNS("SRS",c.join(" ")))}b.appendChild(this.write_wmc_FormatList(a));b.appendChild(this.write_wmc_StyleList(a));a.dimensions&&b.appendChild(this.write_wmc_DimensionList(a));b.appendChild(this.write_wmc_LayerExtension(a))},CLASS_NAME:"OpenLayers.Format.WMC.v1_0_0"});
OpenLayers.Lang["da-DK"]={unhandledRequest:"En ikke h\u00e5ndteret foresp\u00f8rgsel returnerede ${statusText}",Permalink:"Permalink",Overlays:"Kortlag","Base Layer":"Baggrundslag",readNotImplemented:"L\u00e6sning er ikke implementeret.",writeNotImplemented:"Skrivning er ikke implementeret.",noFID:"Kan ikke opdateret en feature (et objekt) der ikke har et FID.",errorLoadingGML:"Fejlede under indl\u00e6sning af GML fil ${url}",browserNotSupported:"Din browser underst\u00f8tter ikke vektor visning. F\u00f8lgende vektor visninger underst\u00f8ttes:\n${renderers}",
componentShouldBe:"addFeatures : komponenten skal v\u00e6re en ${geomType}",getFeatureError:"getFeatureFromEvent blev kaldt p\u00e5 et lag uden en visning. Dette betyder som regel at du har destrueret et lag, men ikke de h\u00e5ndteringer der var tilknyttet.",minZoomLevelError:"Egenskaben minZoomLevel er kun beregnet til brug med FixedZoomLevels. At dette WFS lag kontrollerer minZoomLevel egenskaben, er et levn fra en tidligere version. Vi kan desv\u00e6rre ikke fjerne dette uden at risikere at \u00f8del\u00e6gge eksisterende OL baserede programmer der  benytter denne funktionalitet. Egenskaben b\u00f8r derfor ikke anvendes, og minZoomLevel kontrollen herunder vil blive fjernet i version 3.0. Benyt istedet min/max opl\u00f8snings indstillingerne, som er beskrevet her: http://trac.openlayers.org/wiki/SettingZoomLevels",
commitSuccess:"WFS transaktion: LYKKEDES ${response}",commitFailed:"WFS transaktion: MISLYKKEDES ${response}",googleWarning:"Google laget kunne ikke indl\u00e6ses.<br><br>For at fjerne denne besked, v\u00e6lg et nyt bagrundskort i lagskifteren i \u00f8verste h\u00f8jre hj\u00f8rne.<br><br>Fejlen skyldes formentlig at Google Maps bibliotekts scriptet ikke er inkluderet, eller ikke indeholder den korrkte API n\u00f8gle for dit site.<br><br>Udviklere: For hj\u00e6lp til at f\u00e5 dette til at fungere, <a href='http://trac.openlayers.org/wiki/Google' target='_blank'>klik her</a>",
getLayerWarning:"${layerType}-laget kunne ikke indl\u00e6ses.<br><br>For at fjerne denne besked, v\u00e6lg et nyt bagrundskort i lagskifteren i \u00f8verste h\u00f8jre hj\u00f8rne.<br><br>Fejlen skyldes formentlig at ${layerLib} bibliotekts scriptet ikke er inkluderet.<br><br>Udviklere: For hj\u00e6lp til at f\u00e5 dette til at fungere, <a href='http://trac.openlayers.org/wiki/${layerLib}' target='_blank'>klik her</a>","Scale = 1 : ${scaleDenom}":"M\u00e5lforhold = 1 : ${scaleDenom}",layerAlreadyAdded:"Du har fors\u00f8gt at tilf\u00f8je laget: ${layerName} til kortet, men det er allerede tilf\u00f8jet",
reprojectDeprecated:"Du anvender indstillingen 'reproject' p\u00e5 laget ${layerName}.Denne indstilling b\u00f8r ikke l\u00e6ngere anvendes. Den var beregnet til at vise data ovenp\u00e5 kommercielle grundkort, men den funktionalitet b\u00f8r nu opn\u00e5s ved at anvende Spherical Mercator underst\u00f8ttelsen. Mere information er tilg\u00e6ngelig her: http://trac.openlayers.org/wiki/SphericalMercator.",methodDeprecated:"Denne funktion b\u00f8r ikke l\u00e6ngere anvendes, og vil blive fjernet i version 3.0. Anvend venligst funktionen ${newMethod} istedet.",
boundsAddError:"Du skal angive b\u00e5de x og y v\u00e6rdier i kaldet til add funktionen.",lonlatAddError:"Du skal angive b\u00e5de lon og lat v\u00e6rdier i kaldet til add funktionen.",pixelAddError:"Du skal angive b\u00e5de x og y v\u00e6rdier i kaldet til add funktionen.",unsupportedGeometryType:"Geometri typen: ${geomType} er ikke underst\u00f8ttet.",filterEvaluateNotImplemented:"evaluering er ikke implementeret for denne filter type."};
OpenLayers.Lang.en={unhandledRequest:"Unhandled request return ${statusText}",Permalink:"Permalink",Overlays:"Overlays","Base Layer":"Base Layer",readNotImplemented:"Read not implemented.",writeNotImplemented:"Write not implemented.",noFID:"Can't update a feature for which there is no FID.",errorLoadingGML:"Error in loading GML file ${url}",browserNotSupported:"Your browser does not support vector rendering. Currently supported renderers are:\n${renderers}",componentShouldBe:"addFeatures : component should be an ${geomType}",
getFeatureError:"getFeatureFromEvent called on layer with no renderer. This usually means you destroyed a layer, but not some handler which is associated with it.",minZoomLevelError:"The minZoomLevel property is only intended for use with the FixedZoomLevels-descendent layers. That this wfs layer checks for minZoomLevel is a relic of thepast. We cannot, however, remove it without possibly breaking OL based applications that may depend on it. Therefore we are deprecating it -- the minZoomLevel check below will be removed at 3.0. Please instead use min/max resolution setting as described here: http://trac.openlayers.org/wiki/SettingZoomLevels",
commitSuccess:"WFS Transaction: SUCCESS ${response}",commitFailed:"WFS Transaction: FAILED ${response}",googleWarning:"The Google Layer was unable to load correctly.<br><br>To get rid of this message, select a new BaseLayer in the layer switcher in the upper-right corner.<br><br>Most likely, this is because the Google Maps library script was either not included, or does not contain the correct API key for your site.<br><br>Developers: For help getting this working correctly, <a href='http://trac.openlayers.org/wiki/Google' target='_blank'>click here</a>",
getLayerWarning:"The ${layerType} Layer was unable to load correctly.<br><br>To get rid of this message, select a new BaseLayer in the layer switcher in the upper-right corner.<br><br>Most likely, this is because the ${layerLib} library script was not correctly included.<br><br>Developers: For help getting this working correctly, <a href='http://trac.openlayers.org/wiki/${layerLib}' target='_blank'>click here</a>","Scale = 1 : ${scaleDenom}":"Scale = 1 : ${scaleDenom}",W:"W",E:"E",N:"N",S:"S",Graticule:"Graticule",
layerAlreadyAdded:"You tried to add the layer: ${layerName} to the map, but it has already been added",reprojectDeprecated:"You are using the 'reproject' option on the ${layerName} layer. This option is deprecated: its use was designed to support displaying data over commercial basemaps, but that functionality should now be achieved by using Spherical Mercator support. More information is available from http://trac.openlayers.org/wiki/SphericalMercator.",methodDeprecated:"This method has been deprecated and will be removed in 3.0. Please use ${newMethod} instead.",
boundsAddError:"You must pass both x and y values to the add function.",lonlatAddError:"You must pass both lon and lat values to the add function.",pixelAddError:"You must pass both x and y values to the add function.",unsupportedGeometryType:"Unsupported geometry type: ${geomType}",filterEvaluateNotImplemented:"evaluate is not implemented for this filter type.",proxyNeeded:"You probably need to set OpenLayers.ProxyHost to access ${url}.See http://trac.osgeo.org/openlayers/wiki/FrequentlyAskedQuestions#ProxyHost",
end:""};
OpenLayers.Lang.hu=OpenLayers.Util.applyDefaults({unhandledRequest:"Nem kezelt k\u00e9r\u00e9s visszat\u00e9r\u00e9se ${statusText}",Permalink:"Permalink",Overlays:"R\u00e1vet\u00edt\u00e9sek","Base Layer":"Alapr\u00e9teg",readNotImplemented:"Olvas\u00e1s nincs v\u00e9grehajtva.",writeNotImplemented:"\u00cdr\u00e1s nincs v\u00e9grehajtva.",noFID:"Nem friss\u00edthet\u0151 olyan jellemz\u0151, amely nem rendelkezik FID-del.",errorLoadingGML:"Hiba GML-f\u00e1jl bet\u00f6lt\u00e9sekor ${url}",browserNotSupported:"A b\u00f6ng\u00e9sz\u0151je nem t\u00e1mogatja a vektoros renderel\u00e9st. A jelenleg t\u00e1mogatott renderel\u0151k:\n${renderers}",
componentShouldBe:"addFeatures : az \u00f6sszetev\u0151nek ilyen t\u00edpus\u00fanak kell lennie: ${geomType}",getFeatureError:"getFeatureFromEvent r\u00e9teget h\u00edvott meg renderel\u0151 n\u00e9lk\u00fcl. Ez rendszerint azt jelenti, hogy megsemmis\u00edtett egy f\u00f3li\u00e1t, de n\u00e9h\u00e1ny ahhoz t\u00e1rs\u00edtott kezel\u0151t nem.",minZoomLevelError:"A minZoomLevel tulajdons\u00e1got csak a k\u00f6vetkez\u0151vel val\u00f3 haszn\u00e1latra sz\u00e1nt\u00e1k: FixedZoomLevels-lesz\u00e1rmazott f\u00f3li\u00e1k. Ez azt jelenti, hogy a minZoomLevel wfs f\u00f3lia jel\u00f6l\u0151n\u00e9gyzetei m\u00e1r a m\u00falt\u00e9. Mi azonban nem t\u00e1vol\u00edthatjuk el annak a vesz\u00e9lye n\u00e9lk\u00fcl, hogy az esetlegesen ett\u0151l f\u00fcgg\u0151 OL alap\u00fa alkalmaz\u00e1sokat t\u00f6nkretenn\u00e9nk. Ez\u00e9rt ezt \u00e9rv\u00e9nytelen\u00edtj\u00fck -- a minZoomLevel az alul lev\u0151 jel\u00f6l\u0151n\u00e9gyzet a 3.0-s verzi\u00f3b\u00f3l el lesz t\u00e1vol\u00edtva. K\u00e9rj\u00fck, helyette haszn\u00e1lja a  min/max felbont\u00e1s be\u00e1ll\u00edt\u00e1st, amelyr\u0151l az al\u00e1bbi helyen tal\u00e1l le\u00edr\u00e1st: http://trac.openlayers.org/wiki/SettingZoomLevels",
commitSuccess:"WFS tranzakci\u00f3: SIKERES ${response}",commitFailed:"WFS tranzakci\u00f3: SIKERTELEN ${response}",googleWarning:"A Google f\u00f3lia bet\u00f6lt\u00e9se sikertelen.<br><br>Ahhoz, hogy ez az \u00fczenet elt\u0171nj\u00f6n, v\u00e1lasszon egy \u00faj BaseLayer f\u00f3li\u00e1t a jobb fels\u0151 sarokban tal\u00e1lhat\u00f3 f\u00f3liakapcsol\u00f3 seg\u00edts\u00e9g\u00e9vel.<br><br>Nagy val\u00f3sz\u00edn\u0171s\u00e9ggel ez az\u00e9rt van, mert a Google Maps k\u00f6nyvt\u00e1r parancsf\u00e1jlja nem tal\u00e1lhat\u00f3, vagy nem tartalmazza az \u00d6n oldal\u00e1hoz tartoz\u00f3 megfelel\u0151 API-kulcsot.<br><br>Fejleszt\u0151knek: A helyes m\u0171k\u00f6dtet\u00e9sre vonatkoz\u00f3 seg\u00edts\u00e9g az al\u00e1bbi helyen \u00e9rhet\u0151 el, <a href='http://trac.openlayers.org/wiki/Google' target='_blank'>kattintson ide</a>",
getLayerWarning:"A(z) ${layerType} f\u00f3lia nem t\u00f6lt\u0151d\u00f6tt be helyesen.<br><br>Ahhoz, hogy ez az \u00fczenet elt\u0171nj\u00f6n, v\u00e1lasszon egy \u00faj BaseLayer f\u00f3li\u00e1t a jobb fels\u0151 sarokban tal\u00e1lhat\u00f3 f\u00f3liakapcsol\u00f3 seg\u00edts\u00e9g\u00e9vel.<br><br>Nagy val\u00f3sz\u00edn\u0171s\u00e9ggel ez az\u00e9rt van, mert a(z) ${layerLib} k\u00f6nyvt\u00e1r parancsf\u00e1jlja helytelen.<br><br>Fejleszt\u0151knek: A helyes m\u0171k\u00f6dtet\u00e9sre vonatkoz\u00f3 seg\u00edts\u00e9g az al\u00e1bbi helyen \u00e9rhet\u0151 el, <a href='http://trac.openlayers.org/wiki/${layerLib}' target='_blank'>kattintson ide</a>",
"Scale = 1 : ${scaleDenom}":"L\u00e9pt\u00e9k = 1 : ${scaleDenom}",W:"Ny",E:"K",N:"\u00c9",S:"D",layerAlreadyAdded:"Megpr\u00f3b\u00e1lta hozz\u00e1adni a(z) ${layerName} f\u00f3li\u00e1t a t\u00e9rk\u00e9phez, de az m\u00e1r hozz\u00e1 van adva",reprojectDeprecated:"\u00d6n a 'reproject' be\u00e1ll\u00edt\u00e1st haszn\u00e1lja a(z) ${layerName} f\u00f3li\u00e1n. Ez a be\u00e1ll\u00edt\u00e1s \u00e9rv\u00e9nytelen: haszn\u00e1lata az \u00fczleti alapt\u00e9rk\u00e9pek f\u00f6l\u00f6tti adatok megjelen\u00edt\u00e9s\u00e9nek t\u00e1mogat\u00e1s\u00e1ra szolg\u00e1lt, de ezt a funkci\u00f3 ezent\u00fal a G\u00f6mbi Mercator haszn\u00e1lat\u00e1val \u00e9rhet\u0151 el. Tov\u00e1bbi inform\u00e1ci\u00f3 az al\u00e1bbi helyen \u00e9rhet\u0151 el: http://trac.openlayers.org/wiki/SphericalMercator",
methodDeprecated:"Ez a m\u00f3dszer \u00e9rv\u00e9nytelen\u00edtve lett \u00e9s a 3.0-s verzi\u00f3b\u00f3l el lesz t\u00e1vol\u00edtva. Haszn\u00e1lja a(z) ${newMethod} m\u00f3dszert helyette.",boundsAddError:"Az x \u00e9s y \u00e9rt\u00e9keknek egyar\u00e1nt meg kell felelnie, hogy a funkci\u00f3t hozz\u00e1adhassa.",lonlatAddError:"A hossz. \u00e9s sz\u00e9l. \u00e9rt\u00e9keknek egyar\u00e1nt meg kell felelnie, hogy a funkci\u00f3t hozz\u00e1adhassa.",pixelAddError:"Az x \u00e9s y \u00e9rt\u00e9keknek egyar\u00e1nt meg kell felelnie, hogy a funkci\u00f3t hozz\u00e1adhassa.",
unsupportedGeometryType:"Nem t\u00e1mogatott geometriat\u00edpus: ${geomType}",filterEvaluateNotImplemented:"enn\u00e9l a sz\u0171r\u0151t\u00edpusn\u00e1l ki\u00e9rt\u00e9kel\u00e9s nem hajt\u00f3dik v\u00e9gre."});
OpenLayers.Lang["zh-TW"]={unhandledRequest:"\u672a\u8655\u7406\u7684\u8acb\u6c42\uff0c\u50b3\u56de\u503c\u70ba ${statusText}\u3002",Permalink:"\u6c38\u4e45\u9023\u7d50",Overlays:"\u984d\u5916\u5716\u5c64","Base Layer":"\u57fa\u790e\u5716\u5c64",readNotImplemented:"\u6c92\u6709\u5be6\u4f5c\u8b80\u53d6\u7684\u529f\u80fd\u3002",writeNotImplemented:"\u6c92\u6709\u5be6\u4f5c\u5beb\u5165\u7684\u529f\u80fd\u3002",noFID:"\u56e0\u70ba\u6c92\u6709 FID \u6240\u4ee5\u7121\u6cd5\u66f4\u65b0 feature\u3002",errorLoadingGML:"\u8b80\u53d6GML\u6a94\u6848 ${url} \u932f\u8aa4\u3002",
browserNotSupported:"\u60a8\u7684\u700f\u89bd\u5668\u672a\u652f\u63f4\u5411\u91cf\u6e32\u67d3. \u76ee\u524d\u652f\u63f4\u7684\u6e32\u67d3\u65b9\u5f0f\u662f:\n${renderers}",componentShouldBe:"addFeatures : \u5143\u4ef6\u61c9\u8a72\u70ba ${geomType}",getFeatureError:"getFeatureFromEvent \u5728\u4e00\u500b\u6c92\u6709\u88ab\u6e32\u67d3\u7684\u5716\u5c64\u88e1\u88ab\u547c\u53eb\u3002\u9019\u901a\u5e38\u610f\u5473\u8457\u60a8 \u6467\u6bc0\u4e86\u4e00\u500b\u5716\u5c64\uff0c\u4f46\u4e26\u672a\u6467\u6bc0\u76f8\u95dc\u7684handler\u3002",
minZoomLevelError:"minZoomLevel \u5c6c\u6027\u50c5\u9069\u5408\u7528\u5728 FixedZoomLevels-descendent \u985e\u578b\u7684\u5716\u5c64. \u9019\u500bwfs layer \u7684 minZoomLevel \u662f\u904e\u53bb\u6240\u907a\u7559\u4e0b\u4f86\u7684\uff0c\u7136\u800c\u6211\u5011\u4e0d\u80fd\u79fb\u9664\u5b83\u800c\u4e0d\u8b93\u5b83\u5c07\u904e\u53bb\u7684\u7a0b\u5f0f\u76f8\u5bb9\u6027\u7d66\u7834\u58de\u6389\u3002\u56e0\u6b64\u6211\u5011\u5c07\u6703\u8ff4\u907f\u4f7f\u7528\u5b83 -- minZoomLevel \u6703\u57283.0\u88ab\u79fb\u9664\uff0c\u8acb\u6539\u7528\u5728\u9019\u908a\u63cf\u8ff0\u7684 min/max resolution \u8a2d\u5b9a: http://trac.openlayers.org/wiki/SettingZoomLevels",
commitSuccess:"WFS Transaction: \u6210\u529f ${response}",commitFailed:"WFS Transaction: \u5931\u6557 ${response}",googleWarning:"The Google Layer \u5716\u5c64\u7121\u6cd5\u88ab\u6b63\u78ba\u7684\u8f09\u5165\u3002<br><br>\u8981\u8ff4\u907f\u9019\u500b\u8a0a\u606f, \u8acb\u5728\u53f3\u4e0a\u89d2\u7684\u5716\u5c64\u6539\u8b8a\u5668\u88e1\uff0c\u9078\u4e00\u500b\u65b0\u7684\u57fa\u790e\u5716\u5c64\u3002<br><br>\u5f88\u6709\u53ef\u80fd\u662f\u56e0\u70ba Google Maps \u7684\u51fd\u5f0f\u5eab\u8173\u672c\u6c92\u6709\u88ab\u6b63\u78ba\u7684\u7f6e\u5165\uff0c\u6216\u6c92\u6709\u5305\u542b \u60a8\u7db2\u7ad9\u4e0a\u6b63\u78ba\u7684 API key <br><br>\u958b\u767c\u8005: \u8981\u5e6b\u52a9\u9019\u500b\u884c\u70ba\u6b63\u78ba\u5b8c\u6210\uff0c<a href='http://trac.openlayers.org/wiki/Google' target='_blank'>\u8acb\u6309\u9019\u88e1</a>",
getLayerWarning:"${layerType} \u5716\u5c64\u7121\u6cd5\u88ab\u6b63\u78ba\u7684\u8f09\u5165\u3002<br><br>\u8981\u8ff4\u907f\u9019\u500b\u8a0a\u606f, \u8acb\u5728\u53f3\u4e0a\u89d2\u7684\u5716\u5c64\u6539\u8b8a\u5668\u88e1\uff0c\u9078\u4e00\u500b\u65b0\u7684\u57fa\u790e\u5716\u5c64\u3002<br><br>\u5f88\u6709\u53ef\u80fd\u662f\u56e0\u70ba ${layerLib} \u7684\u51fd\u5f0f\u5eab\u8173\u672c\u6c92\u6709\u88ab\u6b63\u78ba\u7684\u7f6e\u5165\u3002<br><br>\u958b\u767c\u8005: \u8981\u5e6b\u52a9\u9019\u500b\u884c\u70ba\u6b63\u78ba\u5b8c\u6210\uff0c<a href='http://trac.openlayers.org/wiki/${layerLib}' target='_blank'>\u8acb\u6309\u9019\u88e1</a>",
"Scale = 1 : ${scaleDenom}":"Scale = 1 : ${scaleDenom}",layerAlreadyAdded:"\u4f60\u8a66\u8457\u65b0\u589e\u5716\u5c64: ${layerName} \u5230\u5730\u5716\u4e0a\uff0c\u4f46\u5716\u5c64\u4e4b\u524d\u5c31\u5df2\u7d93\u88ab\u65b0\u589e\u4e86\u3002",reprojectDeprecated:"\u4f60\u6b63\u4f7f\u7528 'reproject' \u9019\u500b\u9078\u9805 \u5728 ${layerName} \u5c64\u3002\u9019\u500b\u9078\u9805\u5df2\u7d93\u4e0d\u518d\u4f7f\u7528:\u5b83\u7684\u4f7f\u7528\u539f\u672c\u662f\u8a2d\u8a08\u7528\u4f86\u652f\u63f4\u5728\u5546\u696d\u5730\u5716\u4e0a\u79c0\u51fa\u8cc7\u6599\uff0c\u4f46\u9019\u500b\u529f\u80fd\u5df2\u7d93\u88abSpherical Mercator\u6240\u53d6\u4ee3\u3002\u66f4\u591a\u7684\u8cc7\u8a0a\u53ef\u4ee5\u5728 http://trac.openlayers.org/wiki/SphericalMercator \u627e\u5230\u3002",
methodDeprecated:"\u9019\u500b\u65b9\u6cd5\u5df2\u7d93\u4e0d\u518d\u4f7f\u7528\u4e14\u57283.0\u5c07\u6703\u88ab\u79fb\u9664\uff0c\u8acb\u4f7f\u7528 ${newMethod} \u4f86\u4ee3\u66ff\u3002",boundsAddError:"\u60a8\u5fc5\u9808\u50b3\u5165 x \u8ddf y \u5169\u8005\u7684\u503c\u9032 add \u51fd\u6578\u3002",lonlatAddError:"\u60a8\u5fc5\u9808\u50b3\u5165 lon \u8ddf lat \u5169\u8005\u7684\u503c\u9032 add \u51fd\u6578\u3002",pixelAddError:"\u60a8\u5fc5\u9808\u50b3\u5165 x \u8ddf y \u5169\u8005\u7684\u503c\u9032 add \u51fd\u6578\u3002",
unsupportedGeometryType:"\u672a\u652f\u63f4\u7684\u5e7e\u4f55\u578b\u5225: ${geomType}\u3002",end:""};
OpenLayers.Lang["pt-br"]=OpenLayers.Util.applyDefaults({unhandledRequest:"A requisi\u00e7\u00e3o retornou um erro n\u00e3o tratado: ${statusText}",Permalink:"Link para essa p\u00e1gina",Overlays:"Camadas de Sobreposi\u00e7\u00e3o","Base Layer":"Camada Base",readNotImplemented:"Leitura n\u00e3o implementada.",writeNotImplemented:"Escrita n\u00e3o implementada.",noFID:"N\u00e3o \u00e9 poss\u00edvel atualizar uma fei\u00e7\u00e3o que n\u00e3o tenha um FID.",errorLoadingGML:"Erro ao carregar o arquivo GML ${url}",
browserNotSupported:"Seu navegador n\u00e3o suporta renderiza\u00e7\u00e3o de vetores. Os renderizadores suportados atualmente s\u00e3o:\n${renderers}",componentShouldBe:"addFeatures: o componente deve ser do tipo ${geomType}",getFeatureError:"getFeatureFromEvent foi executado mas nenhum renderizador foi encontrado. Isso pode indicar que voc\u00ea destruiu uma camana, mas n\u00e3o o handler associado a ela.",minZoomLevelError:"A propriedade minZoomLevel \u00e9 de uso restrito das camadas descendentes de FixedZoomLevels. A verifica\u00e7\u00e3o dessa propriedade pelas camadas wfs \u00e9 um res\u00edduo do passado. N\u00e3o podemos, entretanto n\u00e3o \u00e9 poss\u00edvel remov\u00ea-la sem poss\u00edvelmente quebrar o funcionamento de aplica\u00e7\u00f5es OL que possuem dep\u00eancia com ela. Portanto estamos tornando seu uso obsoleto -- a verifica\u00e7\u00e3o desse atributo ser\u00e1 removida na vers\u00e3o 3.0. Ao inv\u00e9s, use as op\u00e7\u00f5es de resolu\u00e7\u00e3o min/max como descrito em: http://trac.openlayers.org/wiki/SettingZoomLevels",
commitSuccess:"Transa\u00e7\u00e3o WFS : SUCESSO ${response}",commitFailed:"Transa\u00e7\u00e3o WFS : ERRO ${response}",googleWarning:"N\u00e3o foi poss\u00edvel carregar a camada Google corretamente.<br><br>Para se livrar dessa mensagem, selecione uma nova Camada Base, na ferramenta de alterna\u00e7\u00e3o de camadas localiza\u00e7\u00e3o do canto superior direito.<br><br>Muito provavelmente, isso foi causado porque o script da biblioteca do Google Maps n\u00e3o foi inclu\u00eddo, ou porque ele n\u00e3o cont\u00e9m a chave correta da API para o seu site.<br><br>Desenvolvedores: Para obter ajuda em solucionar esse problema <a href='http://trac.openlayers.org/wiki/Google' target='_blank'>cliquem aqui</a>",
getLayerWarning:"N\u00e3o foi poss\u00edvel carregar a camada ${layerType} corretamente.<br><br>Para se livrar dessa mensagem, selecione uma nova Camada Base, na ferramenta de alterna\u00e7\u00e3o de camadas localiza\u00e7\u00e3o do canto superior direito.<br><br>Muito provavelmente, isso foi causado porque o script da biblioteca ${layerLib} n\u00e3o foi inclu\u00eddo corretamente.<br><br>Desenvolvedores: Para obter ajuda em solucionar esse problema <a href='http://trac.openlayers.org/wiki/${layerLib}' target='_blank'>cliquem aqui</a>",
"Scale = 1 : ${scaleDenom}":"Escala = 1 : ${scaleDenom}",W:"O",E:"L",N:"N",S:"S",layerAlreadyAdded:"Voc\u00ea tentou adicionar a camada: ${layerName} ao mapa, mas ela j\u00e1 foi adicionada",reprojectDeprecated:"Voc\u00ea est\u00e1 usando a op\u00e7\u00e3o 'reproject' na camada ${layerName}. Essa op\u00e7\u00e3o est\u00e1 obsoleta: seu uso foi projetado para suportar a visualiza\u00e7\u00e3o de dados sobre bases de mapas comerciais, entretanto essa funcionalidade deve agora ser alcan\u00e7ada usando o suporte \u00e0 proje\u00e7\u00e3o Mercator. Mais informa\u00e7\u00e3o est\u00e1 dispon\u00edvel em: http://trac.openlayers.org/wiki/SphericalMercator.",
methodDeprecated:"Esse m\u00e9todo est\u00e1 obsoleto e ser\u00e1 removido na vers\u00e3o 3.0. Ao inv\u00e9s, por favor use ${newMethod}.",boundsAddError:"Voc\u00ea deve informar ambos os valores x e y para a fun\u00e7\u00e3o add.",lonlatAddError:"Voc\u00ea deve informar ambos os valores lon e lat para a fun\u00e7\u00e3o add.",pixelAddError:"Voc\u00ea deve informar ambos os valores x e y para a fun\u00e7\u00e3o add.",unsupportedGeometryType:"Tipo geom\u00e9trico n\u00e3o suportado: ${geomType}.",
filterEvaluateNotImplemented:"evaluete n\u00e3o est\u00e1 implementado para este tipo de filtro."});
OpenLayers.Lang["zh-CN"]={unhandledRequest:"\u672a\u5904\u7406\u7684\u8bf7\u6c42\uff0c\u8fd4\u56de\u503c\u4e3a ${statusText}",Permalink:"\u6c38\u4e45\u94fe\u63a5",Overlays:"\u53e0\u52a0\u5c42","Base Layer":"\u57fa\u7840\u56fe\u5c42",readNotImplemented:"\u8bfb\u53d6\u529f\u80fd\u6ca1\u6709\u5b9e\u73b0\u3002",writeNotImplemented:"\u5199\u5165\u529f\u80fd\u6ca1\u6709\u5b9e\u73b0\u3002",noFID:"\u65e0\u6cd5\u66f4\u65b0feature\uff0c\u7f3a\u5c11FID\u3002",errorLoadingGML:"\u52a0\u8f7dGML\u6587\u4ef6 ${url} \u51fa\u73b0\u9519\u8bef\u3002",
browserNotSupported:"\u4f60\u4f7f\u7528\u7684\u6d4f\u89c8\u5668\u4e0d\u652f\u6301\u77e2\u91cf\u6e32\u67d3\u3002\u5f53\u524d\u652f\u6301\u7684\u6e32\u67d3\u65b9\u5f0f\u5305\u62ec\uff1a\n${renderers}",componentShouldBe:"addFeatures : \u7ec4\u4ef6\u7c7b\u578b\u5e94\u8be5\u662f ${geomType}",getFeatureError:"getFeatureFromEvent\u65b9\u6cd5\u5728\u4e00\u4e2a\u6ca1\u6709\u6e32\u67d3\u5668\u7684\u56fe\u5c42\u4e0a\u88ab\u8c03\u7528\u3002 \u8fd9\u901a\u5e38\u610f\u5473\u7740\u60a8\u9500\u6bc1\u4e86\u4e00\u4e2a\u56fe\u5c42\uff0c\u4f46\u5e76\u672a\u9500\u6bc1\u5176\u5173\u8054\u7684handler\u3002",
minZoomLevelError:"minZoomLevel\u5c5e\u6027\u4ec5\u9002\u5408\u7528\u4e8e\u4f7f\u7528\u4e86\u56fa\u5b9a\u7f29\u653e\u7ea7\u522b\u7684\u56fe\u5c42\u3002\u8fd9\u4e2a wfs \u56fe\u5c42\u68c0\u67e5 minZoomLevel \u662f\u8fc7\u53bb\u9057\u7559\u4e0b\u6765\u7684\u3002\u7136\u800c\uff0c\u6211\u4eec\u4e0d\u80fd\u79fb\u9664\u5b83\uff0c\u800c\u7834\u574f\u4f9d\u8d56\u4e8e\u5b83\u7684\u57fa\u4e8eOL\u7684\u5e94\u7528\u7a0b\u5e8f\u3002\u56e0\u6b64\uff0c\u6211\u4eec\u5e9f\u9664\u4e86\u5b83 -- minZoomLevel \u5c06\u4f1a\u57283.0\u4e2d\u88ab\u79fb\u9664\u3002\u8bf7\u6539\u7528 min/max resolution \u8bbe\u7f6e\uff0c\u53c2\u8003\uff1ahttp://trac.openlayers.org/wiki/SettingZoomLevels",
commitSuccess:"WFS Transaction: \u6210\u529f\u3002 ${response}",commitFailed:"WFS Transaction: \u5931\u8d25\u3002 ${response}",googleWarning:"Google\u56fe\u5c42\u4e0d\u80fd\u6b63\u786e\u52a0\u8f7d\u3002<br><br>\u8981\u6d88\u9664\u8fd9\u4e2a\u4fe1\u606f\uff0c\u8bf7\u5728\u53f3\u4e0a\u89d2\u7684\u56fe\u5c42\u63a7\u5236\u9762\u677f\u4e2d\u9009\u62e9\u5176\u4ed6\u7684\u57fa\u7840\u56fe\u5c42\u3002<br><br>\u8fd9\u79cd\u60c5\u51b5\u5f88\u53ef\u80fd\u662f\u6ca1\u6709\u6b63\u786e\u7684\u5305\u542bGoogle\u5730\u56fe\u811a\u672c\u5e93\uff0c\u6216\u8005\u662f\u6ca1\u6709\u5305\u542b\u5728\u4f60\u7684\u7ad9\u70b9\u4e0a\u4f7f\u7528\u7684\u6b63\u786e\u7684Google Maps API\u5bc6\u5319\u3002<br><br>\u5f00\u53d1\u8005\uff1a\u83b7\u53d6\u4f7f\u5176\u6b63\u786e\u5de5\u4f5c\u7684\u5e2e\u52a9\u4fe1\u606f\uff0c<a href='http://trac.openlayers.org/wiki/Google' target='_blank'>\u70b9\u51fb\u8fd9\u91cc</a>",
getLayerWarning:"${layerType} \u56fe\u5c42\u4e0d\u80fd\u6b63\u786e\u52a0\u8f7d\u3002<br><br>\u8981\u6d88\u9664\u8fd9\u4e2a\u4fe1\u606f\uff0c\u8bf7\u5728\u53f3\u4e0a\u89d2\u7684\u56fe\u5c42\u63a7\u5236\u9762\u677f\u4e2d\u9009\u62e9\u5176\u4ed6\u7684\u57fa\u7840\u56fe\u5c42\u3002<br><br>\u8fd9\u79cd\u60c5\u51b5\u5f88\u53ef\u80fd\u662f\u6ca1\u6709\u6b63\u786e\u7684\u5305\u542b${layerLib} \u811a\u672c\u5e93\u3002<br><br>\u5f00\u53d1\u8005\uff1a\u83b7\u53d6\u4f7f\u5176\u6b63\u786e\u5de5\u4f5c\u7684\u5e2e\u52a9\u4fe1\u606f\uff0c<a href='http://trac.openlayers.org/wiki/${layerLib}' target='_blank'>\u70b9\u51fb\u8fd9\u91cc</a>",
"Scale = 1 : ${scaleDenom}":"\u6bd4\u4f8b\u5c3a = 1 : ${scaleDenom}",layerAlreadyAdded:"\u4f60\u5c1d\u8bd5\u6dfb\u52a0\u56fe\u5c42\uff1a ${layerName} \u5230\u5730\u56fe\u4e2d\uff0c\u4f46\u662f\u5b83\u4e4b\u524d\u5c31\u5df2\u7ecf\u88ab\u6dfb\u52a0\u3002",reprojectDeprecated:"\u4f60\u6b63\u5728\u4f7f\u7528 ${layerName} \u56fe\u5c42\u4e0a\u7684'reproject'\u9009\u9879\u3002\u8fd9\u4e2a\u9009\u9879\u5df2\u7ecf\u4e0d\u518d\u4f7f\u7528\uff1a\u5b83\u662f\u88ab\u8bbe\u8ba1\u7528\u6765\u652f\u6301\u663e\u793a\u5546\u4e1a\u7684\u5730\u56fe\u6570\u636e\uff0c\u4e0d\u8fc7\u73b0\u5728\u8be5\u529f\u80fd\u53ef\u4ee5\u901a\u8fc7\u4f7f\u7528Spherical Mercator\u6765\u5b9e\u73b0\u3002\u66f4\u591a\u4fe1\u606f\u53ef\u4ee5\u53c2\u9605http://trac.openlayers.org/wiki/SphericalMercator.",
methodDeprecated:"\u8be5\u65b9\u6cd5\u5df2\u7ecf\u4e0d\u518d\u88ab\u652f\u6301\uff0c\u5e76\u4e14\u5c06\u57283.0\u4e2d\u88ab\u79fb\u9664\u3002\u8bf7\u4f7f\u7528 ${newMethod} \u65b9\u6cd5\u6765\u66ff\u4ee3\u3002",boundsAddError:"\u60a8\u5fc5\u987b\u4f20\u9012 x \u548c y \u4e24\u4e2a\u53c2\u6570\u503c\u5230 add \u65b9\u6cd5\u3002",lonlatAddError:"\u60a8\u5fc5\u987b\u4f20\u9012 lon \u548c lat \u4e24\u4e2a\u53c2\u6570\u503c\u5230 add \u65b9\u6cd5\u3002",pixelAddError:"\u60a8\u5fc5\u987b\u4f20\u9012 x and y \u4e24\u4e2a\u53c2\u6570\u503c\u5230 add \u65b9\u6cd5\u3002",
unsupportedGeometryType:"\u4e0d\u652f\u6301\u7684\u51e0\u4f55\u4f53\u7c7b\u578b\uff1a ${geomType}",end:""};
OpenLayers.Lang.pt=OpenLayers.Util.applyDefaults({unhandledRequest:"Servidor devolveu erro n\u00e3o contemplado ${statusText}",Permalink:"Liga\u00e7\u00e3o permanente",Overlays:"Sobreposi\u00e7\u00f5es","Base Layer":"Camada Base",readNotImplemented:"Leitura n\u00e3o implementada.",writeNotImplemented:"Escrita n\u00e3o implementada.",noFID:"N\u00e3o \u00e9 poss\u00edvel atualizar um elemento para a qual n\u00e3o h\u00e1 FID.",errorLoadingGML:"Erro ao carregar ficheiro GML ${url}",browserNotSupported:"O seu navegador n\u00e3o suporta renderiza\u00e7\u00e3o vetorial. Actualmente os renderizadores suportados s\u00e3o:\n${renderers}",
componentShouldBe:"addFeatures: componente deve ser um(a) ${geomType}",getFeatureError:"getFeatureFromEvent foi chamado numa camada sem renderizador. Isto normalmente significa que destruiu uma camada, mas n\u00e3o um manipulador ''(handler)'' que lhe est\u00e1 associado.",minZoomLevelError:"A propriedade minZoomLevel s\u00f3 deve ser usada com as camadas descendentes da FixedZoomLevels. A verifica\u00e7\u00e3o da propriedade por esta camada wfs \u00e9 uma rel\u00edquia do passado. No entanto, n\u00e3o podemos remov\u00ea-la sem correr o risco de afectar aplica\u00e7\u00f5es OL que dependam dela. Portanto, estamos a torn\u00e1-la obsoleta -- a verifica\u00e7\u00e3o minZoomLevel ser\u00e1 removida na vers\u00e3o 3.0. Em vez dela, por favor, use as op\u00e7\u00f5es de resolu\u00e7\u00e3o min/max descritas aqui: http://trac.openlayers.org/wiki/SettingZoomLevels",
commitSuccess:"Transac\u00e7\u00e3o WFS: SUCESSO ${response}",commitFailed:"Transac\u00e7\u00e3o WFS: FALHOU ${response}",googleWarning:"A Camada Google n\u00e3o foi correctamente carregada.<br><br>Para deixar de receber esta mensagem, seleccione uma nova Camada-Base no ''switcher'' de camadas no canto superior direito.<br><br>Provavelmente, isto acontece porque o ''script'' da biblioteca do Google Maps n\u00e3o foi inclu\u00eddo ou n\u00e3o cont\u00e9m a chave API correcta para o seu s\u00edtio.<br><br>Programadores: Para ajuda sobre como solucionar o problema <a href='http://trac.openlayers.org/wiki/Google' target='_blank'>clique aqui</a> .",
getLayerWarning:"A camada ${layerType} n\u00e3o foi correctamente carregada.<br><br>Para desactivar esta mensagem, seleccione uma nova Camada-Base no ''switcher'' de camadas no canto superior direito.<br><br>Provavelmente, isto acontece porque o ''script'' da biblioteca ${layerLib} n\u00e3o foi inclu\u00eddo correctamente.<br><br>Programadores: Para ajuda sobre como solucionar o problema <a href='http://trac.openlayers.org/wiki/${layerLib}' target='_blank'>clique aqui</a> .","Scale = 1 : ${scaleDenom}":"Escala = 1 : ${scaleDenom}",
W:"O",E:"E",N:"N",S:"S",layerAlreadyAdded:"Voc\u00ea tentou adicionar a camada: ${layerName} ao mapa, mas ela j\u00e1 tinha sido adicionada antes",reprojectDeprecated:"Est\u00e1 usando a op\u00e7\u00e3o 'reproject' na camada ${layerName}. Esta op\u00e7\u00e3o \u00e9 obsoleta: foi concebida para permitir a apresenta\u00e7\u00e3o de dados sobre mapas-base comerciais, mas esta funcionalidade \u00e9 agora suportada pelo Mercator Esf\u00e9rico. Mais informa\u00e7\u00e3o est\u00e1 dispon\u00edvel em http://trac.openlayers.org/wiki/SphericalMercator.",
methodDeprecated:"Este m\u00e9todo foi declarado obsoleto e ser\u00e1 removido na vers\u00e3o 3.0. Por favor, use ${newMethod} em vez disso.",boundsAddError:"Voc\u00ea deve passar tanto o valor x como o y \u00e0 fun\u00e7\u00e3o de adi\u00e7\u00e3o.",lonlatAddError:"Voc\u00ea deve passar tanto o valor lon como o lat \u00e0 fun\u00e7\u00e3o de adi\u00e7\u00e3o.",pixelAddError:"Voc\u00ea deve passar tanto o valor x como o y \u00e0 fun\u00e7\u00e3o de adi\u00e7\u00e3o.",unsupportedGeometryType:"Tipo de geometria n\u00e3o suportado: ${geomType}",
filterEvaluateNotImplemented:"avaliar n\u00e3o est\u00e1 implementado para este tipo de filtro."});
OpenLayers.Layer.MultiMap=OpenLayers.Class(OpenLayers.Layer.EventPane,OpenLayers.Layer.FixedZoomLevels,{MIN_ZOOM_LEVEL:1,MAX_ZOOM_LEVEL:17,RESOLUTIONS:[9,1.40625,0.703125,0.3515625,0.17578125,0.087890625,0.0439453125,0.02197265625,0.010986328125,0.0054931640625,0.00274658203125,0.001373291015625,6.866455078125E-4,3.4332275390625E-4,1.71661376953125E-4,8.58306884765625E-5,4.291534423828125E-5],type:null,initialize:function(){OpenLayers.Layer.EventPane.prototype.initialize.apply(this,arguments);OpenLayers.Layer.FixedZoomLevels.prototype.initialize.apply(this,
arguments);if(this.sphericalMercator){OpenLayers.Util.extend(this,OpenLayers.Layer.SphericalMercator);this.initMercatorParameters();this.RESOLUTIONS.unshift(10)}},loadMapObject:function(){try{this.mapObject=new MultimapViewer(this.div)}catch(a){}},getWarningHTML:function(){return OpenLayers.i18n("getLayerWarning",{layerType:"MM",layerLib:"MultiMap"})},setMapObjectCenter:function(a,b){this.mapObject.goToPosition(a,b)},getMapObjectCenter:function(){return this.mapObject.getCurrentPosition()},getMapObjectZoom:function(){return this.mapObject.getZoomFactor()},
getMapObjectLonLatFromMapObjectPixel:function(a){a.x-=this.map.getSize().w/2;a.y-=this.map.getSize().h/2;return this.mapObject.getMapPositionAt(a)},getMapObjectPixelFromMapObjectLonLat:function(a){return this.mapObject.geoPosToContainerPixels(a)},getLongitudeFromMapObjectLonLat:function(a){return this.sphericalMercator?this.forwardMercator(a.lon,a.lat).lon:a.lon},getLatitudeFromMapObjectLonLat:function(a){return this.sphericalMercator?this.forwardMercator(a.lon,a.lat).lat:a.lat},getMapObjectLonLatFromLonLat:function(a,
b){var c;if(this.sphericalMercator){c=this.inverseMercator(a,b);c=new MMLatLon(c.lat,c.lon)}else c=new MMLatLon(b,a);return c},getXFromMapObjectPixel:function(a){return a.x},getYFromMapObjectPixel:function(a){return a.y},getMapObjectPixelFromXY:function(a,b){return new MMPoint(a,b)},CLASS_NAME:"OpenLayers.Layer.MultiMap"});
OpenLayers.Lang.gl=OpenLayers.Util.applyDefaults({unhandledRequest:"Solicitude non xerada; a resposta foi: ${statusText}",Permalink:"Ligaz\u00f3n permanente",Overlays:"Capas superpostas","Base Layer":"Capa base",readNotImplemented:"Lectura non implementada.",writeNotImplemented:"Escritura non implementada.",noFID:"Non se pode actualizar a funcionalidade para a que non hai FID.",errorLoadingGML:"Erro ao cargar o ficheiro GML ${url}",browserNotSupported:"O seu navegador non soporta a renderizaci\u00f3n de vectores. Os renderizadores soportados actualmente son:\n${renderers}",
componentShouldBe:"addFeatures: o compo\u00f1ente debera ser de tipo ${geomType}",getFeatureError:"getFeatureFromEvent ten sido chamado a unha capa sen renderizador. Isto normalmente significa que destru\u00edu unha capa, mais non o executador que est\u00e1 asociado con ela.",minZoomLevelError:"A propiedade minZoomLevel \u00e9 s\u00f3 para uso conxuntamente coas capas FixedZoomLevels-descendent. O feito de que esa capa wfs verifique o minZoomLevel \u00e9 unha reliquia do pasado. Non podemos, con todo, eliminala sen a posibilidade de non romper as aplicaci\u00f3ns baseadas en OL que poidan depender dela. Por iso a estamos deixando obsoleta (a comprobaci\u00f3n minZoomLevel de embaixo ser\u00e1 eliminada na versi\u00f3n 3.0). Por favor, no canto diso use o axuste de resoluci\u00f3n m\u00edn/m\u00e1x tal e como est\u00e1 descrito aqu\u00ed: http://trac.openlayers.org/wiki/SettingZoomLevels",
commitSuccess:"Transacci\u00f3n WFS: \u00c9XITO ${response}",commitFailed:"Transacci\u00f3n WFS: FALLIDA ${response}",googleWarning:"A capa do Google non puido cargarse correctamente.<br><br>Para evitar esta mensaxe, escolla unha nova capa base no seleccionador de capas na marxe superior dereita.<br><br>Probablemente, isto acontece porque a escritura da librar\u00eda do Google Maps ou ben non foi inclu\u00edda ou ben non cont\u00e9n a clave API correcta para o seu sitio.<br><br>Desenvolvedores: para axudar a facer funcionar isto correctamente, <a href='http://trac.openlayers.org/wiki/Google' target='_blank'>premede aqu\u00ed</a>",
getLayerWarning:"A capa ${layerType} foi incapaz de cargarse correctamente.<br><br>Para evitar esta mensaxe, escolla unha nova capa base no seleccionador de capas na marxe superior dereita.<br><br>Probablemente, isto acontece porque a escritura da librar\u00eda ${layerLib} non foi ben inclu\u00edda.<br><br>Desenvolvedores: para axudar a facer funcionar isto correctamente, <a href='http://trac.openlayers.org/wiki/${layerLib}' target='_blank'>premede aqu\u00ed</a>","Scale = 1 : ${scaleDenom}":"Escala = 1 : ${scaleDenom}",
W:"O",E:"L",N:"N",S:"S",layerAlreadyAdded:"Intentou engadir a capa: ${layerName} ao mapa, pero xa fora engadida",reprojectDeprecated:'Est\u00e1 usando a opci\u00f3n "reproject" na capa ${layerName}. Esta opci\u00f3n est\u00e1 obsoleta: o seu uso foi dese\u00f1ado para a visualizaci\u00f3n de datos sobre mapas base comerciais, pero esta funcionalidade debera agora ser obtida utilizando a proxecci\u00f3n Spherical Mercator. Hai dispo\u00f1ible m\u00e1is informaci\u00f3n en http://trac.openlayers.org/wiki/SphericalMercator.',
methodDeprecated:"Este m\u00e9todo est\u00e1 obsoleto e ser\u00e1 eliminado na versi\u00f3n 3.0. Por favor, no canto deste use ${newMethod}.",boundsAddError:"Debe achegar os valores x e y \u00e1 funci\u00f3n add.",lonlatAddError:"Debe achegar tanto o valor lon coma o lat \u00e1 funci\u00f3n add.",pixelAddError:"Debe achegar os valores x e y \u00e1 funci\u00f3n add.",unsupportedGeometryType:"Tipo xeom\u00e9trico non soportado: ${geomType}",filterEvaluateNotImplemented:"avaliar non est\u00e1 implementado para este tipo de filtro."});
OpenLayers.Geometry.Rectangle=OpenLayers.Class(OpenLayers.Geometry,{x:null,y:null,width:null,height:null,initialize:function(a,b,c,d){OpenLayers.Geometry.prototype.initialize.apply(this,arguments);this.x=a;this.y=b;this.width=c;this.height=d},calculateBounds:function(){this.bounds=new OpenLayers.Bounds(this.x,this.y,this.x+this.width,this.y+this.height)},getLength:function(){return 2*this.width+2*this.height},getArea:function(){return this.width*this.height},CLASS_NAME:"OpenLayers.Geometry.Rectangle"});
OpenLayers.Lang.id=OpenLayers.Util.applyDefaults({unhandledRequest:"Permintaan yang tak tertangani menghasilkan ${statusText}",Permalink:"Pranala permanen",Overlays:"Hamparan","Base Layer":"Lapisan Dasar",readNotImplemented:"Membaca tidak diterapkan.",writeNotImplemented:"Menyimpan tidak diterapkan.",noFID:"Tidak dapat memperbarui fitur yang tidak memiliki FID.",errorLoadingGML:"Kesalahan dalam memuat berkas GML ${url}",browserNotSupported:"Peramban Anda tidak mendukung penggambaran vektor. Penggambar yang didukung saat ini adalah:\n${renderers}",
componentShouldBe:"addFeatures : komponen harus berupa ${geomType}",getFeatureError:"getFeatureFromEvent diterapkan pada lapisan tanpa penggambar. Ini biasanya berarti Anda menghapus sebuah lapisan, tetapi tidak menghapus penangan yang terkait dengannya.",minZoomLevelError:"Properti minZoomLevel hanya ditujukan bekerja dengan lapisan FixedZoomLevels-descendent. Pengecekan minZoomLevel oleh lapisan wfs adalah peninggalan masa lalu. Kami tidak dapat menghapusnya tanpa kemungkinan merusak aplikasi berbasis OL yang mungkin bergantung padanya. Karenanya, kami menganggapnya tidak berlaku -- Cek minZoomLevel di bawah ini akan dihapus pada 3.0. Silakan gunakan penyetelan resolusi min/maks seperti dijabarkan di sini: http://trac.openlayers.org/wiki/SettingZoomLevels",
commitSuccess:"WFS Transaksi: BERHASIL ${respon}",commitFailed:"WFS Transaksi: GAGAL ${respon}",googleWarning:"Lapisan Google tidak dapat dimuat dengan benar.<br><br>Untuk menghilangkan pesan ini, pilih suatu BaseLayer baru melalui penukar lapisan (layer switcher) di ujung kanan atas.<br><br>Kemungkinan besar ini karena pustaka skrip Google Maps tidak disertakan atau tidak mengandung kunci API yang tepat untuk situs Anda.<br><br>Pengembang: Untuk bantuan mengatasi masalah ini, <a href='http://trac.openlayers.org/wiki/Google' target='_blank'>klik di sini</a>",
getLayerWarning:"Lapisan ${layerType} tidak dapat dimuat dengan benar.<br><br>Untuk menghilangkan pesan ini, pilih suatu BaseLayer baru melalui penukar lapisan (layer switcher) di ujung kanan atas.<br><br>Kemungkinan besar ini karena pustaka skrip Google Maps tidak disertakan dengan benar.<br><br>Pengembang: Untuk bantuan mengatasi masalah ini, <a href='http://trac.openlayers.org/wiki/${layerLib}' target='_blank'>klik di sini</a>","Scale = 1 : ${scaleDenom}":"Sekala = 1 : ${scaleDenom}",W:"B",E:"T",
N:"U",S:"S",layerAlreadyAdded:"Anda mencoba menambahkan lapisan: ${layerName} ke dalam peta, tapi lapisan itu telah ditambahkan",reprojectDeprecated:"Anda menggunakan opsi 'reproject' pada lapisan ${layerName}. Opsi ini telah ditinggalkan: penggunaannya dirancang untuk mendukung tampilan data melalui peta dasar komersial, tapi fungsionalitas tersebut saat ini harus dilakukan dengan menggunakan dukungan Spherical Mercator. Informasi lebih lanjut tersedia di http://trac.openlayers.org/wiki/SphericalMercator.",
methodDeprecated:"Metode ini telah usang dan akan dihapus di 3.0. Sebaliknya, harap gunakan ${newMethod}.",boundsAddError:"Anda harus memberikan kedua nilai x dan y ke fungsi penambah.",lonlatAddError:"Anda harus memberikan kedua nilai lon dan lat ke fungsi penambah.",pixelAddError:"Anda harus memberikan kedua nilai x dan y ke fungsi penambah.",unsupportedGeometryType:"Tipe geometri tak didukung: ${geomType}",filterEvaluateNotImplemented:"evaluasi tidak tersedia untuk tipe filter ini."});
OpenLayers.Format.SOSCapabilities=OpenLayers.Class(OpenLayers.Format.XML.VersionedOGC,{defaultVersion:"1.0.0",CLASS_NAME:"OpenLayers.Format.SOSCapabilities"});
OpenLayers.Format.SOSCapabilities.v1_0_0=OpenLayers.Class(OpenLayers.Format.SOSCapabilities,{namespaces:{ows:"http://www.opengis.net/ows/1.1",sos:"http://www.opengis.net/sos/1.0",gml:"http://www.opengis.net/gml",xlink:"http://www.w3.org/1999/xlink"},regExes:{trimSpace:/^\s*|\s*$/g,removeSpace:/\s*/g,splitSpace:/\s+/,trimComma:/\s*,\s*/g},initialize:function(a){OpenLayers.Format.XML.prototype.initialize.apply(this,[a]);this.options=a},read:function(a){if(typeof a=="string")a=OpenLayers.Format.XML.prototype.read.apply(this,
[a]);if(a&&a.nodeType==9)a=a.documentElement;var b={};this.readNode(a,b);return b},readers:{gml:OpenLayers.Util.applyDefaults({name:function(a,b){b.name=this.getChildValue(a)},TimePeriod:function(a,b){b.timePeriod={};this.readChildNodes(a,b.timePeriod)},beginPosition:function(a,b){b.beginPosition=this.getChildValue(a)},endPosition:function(a,b){b.endPosition=this.getChildValue(a)}},OpenLayers.Format.GML.v3.prototype.readers.gml),sos:{Capabilities:function(a,b){this.readChildNodes(a,b)},Contents:function(a,
b){b.contents={};this.readChildNodes(a,b.contents)},ObservationOfferingList:function(a,b){b.offeringList={};this.readChildNodes(a,b.offeringList)},ObservationOffering:function(a,b){var c=this.getAttributeNS(a,this.namespaces.gml,"id");b[c]={procedures:[],observedProperties:[],featureOfInterestIds:[],responseFormats:[],resultModels:[],responseModes:[]};this.readChildNodes(a,b[c])},time:function(a,b){b.time={};this.readChildNodes(a,b.time)},procedure:function(a,b){b.procedures.push(this.getAttributeNS(a,
this.namespaces.xlink,"href"))},observedProperty:function(a,b){b.observedProperties.push(this.getAttributeNS(a,this.namespaces.xlink,"href"))},featureOfInterest:function(a,b){b.featureOfInterestIds.push(this.getAttributeNS(a,this.namespaces.xlink,"href"))},responseFormat:function(a,b){b.responseFormats.push(this.getChildValue(a))},resultModel:function(a,b){b.resultModels.push(this.getChildValue(a))},responseMode:function(a,b){b.responseModes.push(this.getChildValue(a))}},ows:OpenLayers.Format.OWSCommon.v1_1_0.prototype.readers.ows},
CLASS_NAME:"OpenLayers.Format.SOSCapabilities.v1_0_0"});
OpenLayers.Lang.ar=OpenLayers.Util.applyDefaults({Permalink:"\u0648\u0635\u0644\u0629 \u062f\u0627\u0626\u0645\u0629","Base Layer":"\u0627\u0644\u0637\u0628\u0642\u0629 \u0627\u0644\u0627\u0633\u0627\u0633\u064a\u0629",readNotImplemented:"\u0627\u0644\u0642\u0631\u0627\u0621\u0629 \u063a\u064a\u0631 \u0645\u062d\u0642\u0642\u0629.",writeNotImplemented:"\u0627\u0644\u0643\u062a\u0627\u0628\u0629 \u063a\u064a\u0631 \u0645\u062d\u0642\u0642\u0629",errorLoadingGML:"\u062e\u0637\u0623 \u0639\u0646\u062f \u062a\u062d\u0645\u064a\u0644 \u0627\u0644\u0645\u0644\u0641 \u062c\u064a \u0627\u0645 \u0627\u0644 ${url}",
"Scale = 1 : ${scaleDenom}":"\u0627\u0644\u0646\u0633\u0628\u0629 = 1 : ${scaleDenom}",W:"\u063a",E:"\u0634\u0631",N:"\u0634\u0645",S:"\u062c"});
OpenLayers.Handler.Pinch=OpenLayers.Class(OpenLayers.Handler,{started:false,stopDown:false,pinching:false,last:null,start:null,initialize:function(){OpenLayers.Handler.prototype.initialize.apply(this,arguments)},touchstart:function(a){var b=true;this.pinching=false;if(OpenLayers.Event.isMultiTouch(a)){this.started=true;this.last=this.start={distance:this.getDistance(a.touches),delta:0,scale:1};this.callback("start",[a,this.start]);b=!this.stopDown}else{this.started=false;this.last=this.start=null}OpenLayers.Event.stop(a);
return b},touchmove:function(a){if(this.started&&OpenLayers.Event.isMultiTouch(a)){this.pinching=true;var b=this.getPinchData(a);this.callback("move",[a,b]);this.last=b;OpenLayers.Event.stop(a)}return true},touchend:function(a){if(this.started){this.pinching=this.started=false;this.callback("done",[a,this.start,this.last]);this.last=this.start=null}return true},activate:function(){var a=false;if(OpenLayers.Handler.prototype.activate.apply(this,arguments)){this.pinching=false;a=true}return a},deactivate:function(){var a=
false;if(OpenLayers.Handler.prototype.deactivate.apply(this,arguments)){this.pinching=this.started=false;this.last=this.start=null;a=true}return a},getDistance:function(a){var b=a[0];a=a[1];return Math.sqrt(Math.pow(b.clientX-a.clientX,2)+Math.pow(b.clientY-a.clientY,2))},getPinchData:function(a){a=this.getDistance(a.touches);return{distance:a,delta:this.last.distance-a,scale:a/this.start.distance}},CLASS_NAME:"OpenLayers.Handler.Pinch"});
OpenLayers.Control.MouseDefaults=OpenLayers.Class(OpenLayers.Control,{performedDrag:false,wheelObserver:null,initialize:function(){OpenLayers.Control.prototype.initialize.apply(this,arguments)},destroy:function(){this.handler&&this.handler.destroy();this.handler=null;this.map.events.un({click:this.defaultClick,dblclick:this.defaultDblClick,mousedown:this.defaultMouseDown,mouseup:this.defaultMouseUp,mousemove:this.defaultMouseMove,mouseout:this.defaultMouseOut,scope:this});OpenLayers.Event.stopObserving(window,
"DOMMouseScroll",this.wheelObserver);OpenLayers.Event.stopObserving(window,"mousewheel",this.wheelObserver);OpenLayers.Event.stopObserving(document,"mousewheel",this.wheelObserver);this.wheelObserver=null;OpenLayers.Control.prototype.destroy.apply(this,arguments)},draw:function(){this.map.events.on({click:this.defaultClick,dblclick:this.defaultDblClick,mousedown:this.defaultMouseDown,mouseup:this.defaultMouseUp,mousemove:this.defaultMouseMove,mouseout:this.defaultMouseOut,scope:this});this.registerWheelEvents()},
registerWheelEvents:function(){this.wheelObserver=OpenLayers.Function.bindAsEventListener(this.onWheelEvent,this);OpenLayers.Event.observe(window,"DOMMouseScroll",this.wheelObserver);OpenLayers.Event.observe(window,"mousewheel",this.wheelObserver);OpenLayers.Event.observe(document,"mousewheel",this.wheelObserver)},defaultClick:function(a){if(OpenLayers.Event.isLeftClick(a)){a=!this.performedDrag;this.performedDrag=false;return a}},defaultDblClick:function(a){this.map.setCenter(this.map.getLonLatFromViewPortPx(a.xy),
this.map.zoom+1);OpenLayers.Event.stop(a);return false},defaultMouseDown:function(a){if(OpenLayers.Event.isLeftClick(a)){this.mouseDragStart=a.xy.clone();this.performedDrag=false;if(a.shiftKey){this.map.div.style.cursor="crosshair";this.zoomBox=OpenLayers.Util.createDiv("zoomBox",this.mouseDragStart,null,null,"absolute","2px solid red");this.zoomBox.style.backgroundColor="white";this.zoomBox.style.filter="alpha(opacity=50)";this.zoomBox.style.opacity="0.50";this.zoomBox.style.fontSize="1px";this.zoomBox.style.zIndex=
this.map.Z_INDEX_BASE.Popup-1;this.map.eventsDiv.appendChild(this.zoomBox)}document.onselectstart=OpenLayers.Function.False;OpenLayers.Event.stop(a)}},defaultMouseMove:function(a){this.mousePosition=a.xy.clone();if(this.mouseDragStart!=null){if(this.zoomBox){var b=Math.abs(this.mouseDragStart.x-a.xy.x),c=Math.abs(this.mouseDragStart.y-a.xy.y);this.zoomBox.style.width=Math.max(1,b)+"px";this.zoomBox.style.height=Math.max(1,c)+"px";if(a.xy.x<this.mouseDragStart.x)this.zoomBox.style.left=a.xy.x+"px";
if(a.xy.y<this.mouseDragStart.y)this.zoomBox.style.top=a.xy.y+"px"}else{b=this.mouseDragStart.x-a.xy.x;c=this.mouseDragStart.y-a.xy.y;var d=this.map.getSize();this.map.setCenter(this.map.getLonLatFromViewPortPx(new OpenLayers.Pixel(d.w/2+b,d.h/2+c)),null,true);this.mouseDragStart=a.xy.clone();this.map.div.style.cursor="move"}this.performedDrag=true}},defaultMouseUp:function(a){if(OpenLayers.Event.isLeftClick(a)){if(this.zoomBox)this.zoomBoxEnd(a);else this.performedDrag&&this.map.setCenter(this.map.center);
this.mouseDragStart=document.onselectstart=null;this.map.div.style.cursor=""}},defaultMouseOut:function(a){if(this.mouseDragStart!=null&&OpenLayers.Util.mouseLeft(a,this.map.eventsDiv)){this.zoomBox&&this.removeZoomBox();this.mouseDragStart=null}},defaultWheelUp:function(a){this.map.getZoom()<=this.map.getNumZoomLevels()&&this.map.setCenter(this.map.getLonLatFromPixel(a.xy),this.map.getZoom()+1)},defaultWheelDown:function(a){this.map.getZoom()>0&&this.map.setCenter(this.map.getLonLatFromPixel(a.xy),
this.map.getZoom()-1)},zoomBoxEnd:function(a){if(this.mouseDragStart!=null){if(Math.abs(this.mouseDragStart.x-a.xy.x)>5||Math.abs(this.mouseDragStart.y-a.xy.y)>5){var b=this.map.getLonLatFromViewPortPx(this.mouseDragStart);a=this.map.getLonLatFromViewPortPx(a.xy);this.map.zoomToExtent(new OpenLayers.Bounds(Math.min(b.lon,a.lon),Math.min(b.lat,a.lat),Math.max(b.lon,a.lon),Math.max(b.lat,a.lat)))}else{a=this.map.getLonLatFromViewPortPx(a.xy);this.map.setCenter(new OpenLayers.LonLat(a.lon,a.lat),this.map.getZoom()+
1)}this.removeZoomBox()}},removeZoomBox:function(){this.map.eventsDiv.removeChild(this.zoomBox);this.zoomBox=null},onWheelEvent:function(a){for(var b=false,c=OpenLayers.Event.element(a);c!=null;){if(this.map&&c==this.map.div){b=true;break}c=c.parentNode}if(b){b=0;if(!a)a=window.event;if(a.wheelDelta){b=a.wheelDelta/120;if(window.opera&&window.opera.version()<9.2)b=-b}else if(a.detail)b=-a.detail/3;if(b){a.xy=this.mousePosition;b<0?this.defaultWheelDown(a):this.defaultWheelUp(a)}OpenLayers.Event.stop(a)}},
CLASS_NAME:"OpenLayers.Control.MouseDefaults"});
OpenLayers.Lang.ca={unhandledRequest:"Resposta a petici\u00f3 no gestionada ${statusText}",Permalink:"Enlla\u00e7 permanent",Overlays:"Capes addicionals","Base Layer":"Capa Base",readNotImplemented:"Lectura no implementada.",writeNotImplemented:"Escriptura no implementada.",noFID:"No es pot actualitzar un element per al que no existeix FID.",errorLoadingGML:"Error carregant el fitxer GML ${url}",browserNotSupported:"El seu navegador no suporta renderitzaci\u00f3 vectorial. Els renderitzadors suportats actualment s\u00f3n:\n${renderers}",componentShouldBe:"addFeatures : el component ha de ser de tipus ${geomType}",
getFeatureError:"getFeatureFromEvent ha estat cridat des d'una capa sense renderizador. Aix\u00f2 normalment vol dir que s'ha eliminat una capa, per\u00f2 no el handler associat a ella.",minZoomLevelError:"La propietat minZoomLevel s'ha d'utilitzar nom\u00e9s amb les capes que tenen FixedZoomLevels. El fet que una capa wfs comprovi minZoomLevel \u00e9s una rel\u00edquia del passat. No podem, per\u00f2, eliminar-la sense trencar les aplicacions d'OpenLayers que en puguin dependre. Aix\u00ed doncs estem fent-la obsoleta -- la comprovaci\u00f3 minZoomLevel s'eliminar\u00e0 a la versi\u00f3 3.0. Feu servir els par\u00e0metres min/max resolution en substituci\u00f3, tal com es descriu aqu\u00ed: http://trac.openlayers.org/wiki/SettingZoomLevels",
commitSuccess:"Transacci\u00f3 WFS: CORRECTA ${response}",commitFailed:"Transacci\u00f3 WFS: HA FALLAT ${response}",googleWarning:"La capa Google no s'ha pogut carregar correctament.<br><br>Per evitar aquest missatge, seleccioneu una nova Capa Base al gestor de capes de la cantonada superior dreta.<br><br>Probablement aix\u00f2 \u00e9s degut a que l'script de la biblioteca de Google Maps no ha estat incl\u00f2s a la vostra p\u00e0gina, o no cont\u00e9 la clau de l'API correcta per a la vostra adre\u00e7a.<br><br>Desenvolupadors: Per obtenir consells sobre com fer anar aix\u00f2, <a href='http://trac.openlayers.org/wiki/Google' target='_blank'>f\u00e9u clic aqu\u00ed</a>",
getLayerWarning:"Per evitar aquest missatge, seleccioneu una nova Capa Base al gestor de capes de la cantonada superior dreta.<br><br>Probablement aix\u00f2 \u00e9s degut a que l'script de la biblioteca ${layerLib} no ha estat incl\u00f2s a la vostra p\u00e0gina.<br><br>Desenvolupadors: Per obtenir consells sobre com fer anar aix\u00f2, <a href='http://trac.openlayers.org/wiki/${layerLib}' target='_blank'>f\u00e9u clic aqu\u00ed</a>","Scale = 1 : ${scaleDenom}":"Escala = 1 : ${scaleDenom}",W:"O",
E:"E",N:"N",S:"S",Graticule:"Ret\u00edcula",layerAlreadyAdded:"Heu intentat afegir la capa: ${layerName} al mapa, per\u00f2 ja ha estat afegida anteriorment",reprojectDeprecated:"Esteu fent servir l'opci\u00f3 'reproject' a la capa ${layerName}. Aquesta opci\u00f3 \u00e9s obsoleta: el seu \u00fas fou concebut per suportar la visualitzaci\u00f3 de dades sobre mapes base comercials, per\u00f2 ara aquesta funcionalitat s'hauria d'assolir mitjan\u00e7ant el suport de la projecci\u00f3 Spherical Mercator. M\u00e9s informaci\u00f3 disponible a http://trac.openlayers.org/wiki/SphericalMercator.",
methodDeprecated:"Aquest m\u00e8tode \u00e9s obsolet i s'eliminar\u00e0 a la versi\u00f3 3.0. Si us plau feu servir em m\u00e8tode alternatiu ${newMethod}.",boundsAddError:"Ha de proporcionar els valors x i y a la funci\u00f3 add.",lonlatAddError:"Ha de proporcionar els valors lon i lat a la funci\u00f3 add.",pixelAddError:"Ha de proporcionar els valors x i y a la funci\u00f3 add.",unsupportedGeometryType:"Tipus de geometria no suportada: ${geomType}",filterEvaluateNotImplemented:"evaluate no est\u00e0 implementat per aquest tipus de filtre.",
end:""};
OpenLayers.Strategy.Refresh=OpenLayers.Class(OpenLayers.Strategy,{force:false,interval:0,timer:null,activate:function(){var a=OpenLayers.Strategy.prototype.activate.call(this);if(a){this.layer.visibility===true&&this.start();this.layer.events.on({visibilitychanged:this.reset,scope:this})}return a},deactivate:function(){var a=OpenLayers.Strategy.prototype.deactivate.call(this);a&&this.stop();return a},reset:function(){this.layer.visibility===true?this.start():this.stop()},start:function(){if(this.interval&&typeof this.interval===
"number"&&this.interval>0)this.timer=window.setInterval(OpenLayers.Function.bind(this.refresh,this),this.interval)},refresh:function(){this.layer&&this.layer.refresh&&typeof this.layer.refresh=="function"&&this.layer.refresh({force:this.force})},stop:function(){if(this.timer!==null){window.clearInterval(this.timer);this.timer=null}},CLASS_NAME:"OpenLayers.Strategy.Refresh"});
OpenLayers.Layer.ArcGIS93Rest=OpenLayers.Class(OpenLayers.Layer.Grid,{DEFAULT_PARAMS:{format:"png"},isBaseLayer:true,initialize:function(a,b,c,d){var e=[];c=OpenLayers.Util.upperCaseObject(c);e.push(a,b,c,d);OpenLayers.Layer.Grid.prototype.initialize.apply(this,e);OpenLayers.Util.applyDefaults(this.params,OpenLayers.Util.upperCaseObject(this.DEFAULT_PARAMS));if(this.params.TRANSPARENT&&this.params.TRANSPARENT.toString().toLowerCase()=="true"){if(d==null||!d.isBaseLayer)this.isBaseLayer=false;if(this.params.FORMAT==
"jpg")this.params.FORMAT=OpenLayers.Util.alphaHack()?"gif":"png"}},destroy:function(){OpenLayers.Layer.Grid.prototype.destroy.apply(this,arguments)},clone:function(a){if(a==null)a=new OpenLayers.Layer.ArcGIS93Rest(this.name,this.url,this.params,this.getOptions());return a=OpenLayers.Layer.Grid.prototype.clone.apply(this,[a])},getURL:function(a){a=this.adjustBounds(a);var b=this.projection.getCode().split(":");b=b[b.length-1];var c=this.getImageSize();a={BBOX:a.toBBOX(),SIZE:c.w+","+c.h,F:"image",
BBOXSR:b,IMAGESR:b};if(this.layerDefs){b=[];for(var d in this.layerDefs)if(this.layerDefs.hasOwnProperty(d))if(this.layerDefs[d]){b.push(d);b.push(":");b.push(this.layerDefs[d]);b.push(";")}if(b.length>0)a.LAYERDEFS=b.join("")}return this.getFullRequestString(a)},setLayerFilter:function(a,b){if(!this.layerDefs)this.layerDefs={};if(b)this.layerDefs[a]=b;else delete this.layerDefs[a]},clearLayerFilter:function(a){if(a)delete this.layerDefs[a];else delete this.layerDefs},mergeNewParams:function(a){a=
[OpenLayers.Util.upperCaseObject(a)];return OpenLayers.Layer.Grid.prototype.mergeNewParams.apply(this,a)},CLASS_NAME:"OpenLayers.Layer.ArcGIS93Rest"});
OpenLayers.Layer.MapServer=OpenLayers.Class(OpenLayers.Layer.Grid,{DEFAULT_PARAMS:{mode:"map",map_imagetype:"png"},initialize:function(a,b,c,d){var e=[];e.push(a,b,c,d);OpenLayers.Layer.Grid.prototype.initialize.apply(this,e);this.params=OpenLayers.Util.applyDefaults(this.params,this.DEFAULT_PARAMS);if(d==null||d.isBaseLayer==null)this.isBaseLayer=this.params.transparent!="true"&&this.params.transparent!=true},clone:function(a){if(a==null)a=new OpenLayers.Layer.MapServer(this.name,this.url,this.params,
this.getOptions());return a=OpenLayers.Layer.Grid.prototype.clone.apply(this,[a])},getURL:function(a){a=this.adjustBounds(a);a=[a.left,a.bottom,a.right,a.top];var b=this.getImageSize();return this.getFullRequestString({mapext:a,imgext:a,map_size:[b.w,b.h],imgx:b.w/2,imgy:b.h/2,imgxy:[b.w,b.h]})},getFullRequestString:function(a,b){var c=b==null?this.url:b,d=OpenLayers.Util.extend({},this.params);d=OpenLayers.Util.extend(d,a);var e=OpenLayers.Util.getParameterString(d);if(OpenLayers.Util.isArray(c))c=
this.selectUrl(e,c);e=OpenLayers.Util.upperCaseObject(OpenLayers.Util.getParameters(c));for(var f in d)f.toUpperCase()in e&&delete d[f];e=OpenLayers.Util.getParameterString(d);d=c;e=e.replace(/,/g,"+");if(e!=""){f=c.charAt(c.length-1);d+=f=="&"||f=="?"?e:c.indexOf("?")==-1?"?"+e:"&"+e}return d},CLASS_NAME:"OpenLayers.Layer.MapServer"});
OpenLayers.Layer.MapServer.Untiled=OpenLayers.Class(OpenLayers.Layer.MapServer,{singleTile:true,initialize:function(){OpenLayers.Layer.MapServer.prototype.initialize.apply(this,arguments);OpenLayers.Console.warn("The OpenLayers.Layer.MapServer.Untiled class is deprecated and will be removed in 3.0. Instead, you should use the normal OpenLayers.Layer.MapServer class, passing it the option 'singleTile' as true.")},clone:function(a){if(a==null)a=new OpenLayers.Layer.MapServer.Untiled(this.name,this.url,
this.params,this.getOptions());return a=OpenLayers.Layer.MapServer.prototype.clone.apply(this,[a])},CLASS_NAME:"OpenLayers.Layer.MapServer.Untiled"});
OpenLayers.Handler.Hover=OpenLayers.Class(OpenLayers.Handler,{delay:500,pixelTolerance:null,stopMove:false,px:null,timerId:null,initialize:function(){OpenLayers.Handler.prototype.initialize.apply(this,arguments)},mousemove:function(a){if(this.passesTolerance(a.xy)){this.clearTimer();this.callback("move",[a]);this.px=a.xy;a=OpenLayers.Util.extend({},a);this.timerId=window.setTimeout(OpenLayers.Function.bind(this.delayedCall,this,a),this.delay)}return!this.stopMove},mouseout:function(a){if(OpenLayers.Util.mouseLeft(a,
this.map.eventsDiv)){this.clearTimer();this.callback("move",[a])}return true},passesTolerance:function(a){var b=true;if(this.pixelTolerance&&this.px)if(Math.sqrt(Math.pow(this.px.x-a.x,2)+Math.pow(this.px.y-a.y,2))<this.pixelTolerance)b=false;return b},clearTimer:function(){if(this.timerId!=null){window.clearTimeout(this.timerId);this.timerId=null}},delayedCall:function(a){this.callback("pause",[a])},deactivate:function(){var a=false;if(OpenLayers.Handler.prototype.deactivate.apply(this,arguments)){this.clearTimer();
a=true}return a},CLASS_NAME:"OpenLayers.Handler.Hover"});
OpenLayers.Control.GetFeature=OpenLayers.Class(OpenLayers.Control,{protocol:null,multipleKey:null,toggleKey:null,modifiers:null,multiple:false,click:true,single:true,clickout:true,toggle:false,clickTolerance:5,hover:false,box:false,maxFeatures:10,features:null,hoverFeature:null,handlerOptions:null,handlers:null,hoverResponse:null,filterType:OpenLayers.Filter.Spatial.BBOX,EVENT_TYPES:["featureselected","featuresselected","featureunselected","clickout","beforefeatureselected","beforefeaturesselected",
"hoverfeature","outfeature"],initialize:function(a){this.EVENT_TYPES=OpenLayers.Control.GetFeature.prototype.EVENT_TYPES.concat(OpenLayers.Control.prototype.EVENT_TYPES);a.handlerOptions=a.handlerOptions||{};OpenLayers.Control.prototype.initialize.apply(this,[a]);this.features={};this.handlers={};if(this.click)this.handlers.click=new OpenLayers.Handler.Click(this,{click:this.selectClick},this.handlerOptions.click||{});if(this.box)this.handlers.box=new OpenLayers.Handler.Box(this,{done:this.selectBox},
OpenLayers.Util.extend(this.handlerOptions.box,{boxDivClassName:"olHandlerBoxSelectFeature"}));if(this.hover)this.handlers.hover=new OpenLayers.Handler.Hover(this,{move:this.cancelHover,pause:this.selectHover},OpenLayers.Util.extend(this.handlerOptions.hover,{delay:250}))},activate:function(){if(!this.active)for(var a in this.handlers)this.handlers[a].activate();return OpenLayers.Control.prototype.activate.apply(this,arguments)},deactivate:function(){if(this.active)for(var a in this.handlers)this.handlers[a].deactivate();
return OpenLayers.Control.prototype.deactivate.apply(this,arguments)},selectClick:function(a){var b=this.pixelToBounds(a.xy);this.setModifiers(a);this.request(b,{single:this.single})},selectBox:function(a){var b;if(a instanceof OpenLayers.Bounds){b=this.map.getLonLatFromPixel(new OpenLayers.Pixel(a.left,a.bottom));a=this.map.getLonLatFromPixel(new OpenLayers.Pixel(a.right,a.top));b=new OpenLayers.Bounds(b.lon,b.lat,a.lon,a.lat)}else{if(this.click)return;b=this.pixelToBounds(a)}this.setModifiers(this.handlers.box.dragHandler.evt);
this.request(b)},selectHover:function(a){this.request(this.pixelToBounds(a.xy),{single:true,hover:true})},cancelHover:function(){if(this.hoverResponse){this.protocol.abort(this.hoverResponse);this.hoverResponse=null;OpenLayers.Element.removeClass(this.map.viewPortDiv,"olCursorWait")}},request:function(a,b){b=b||{};var c=new OpenLayers.Filter.Spatial({type:this.filterType,value:a});OpenLayers.Element.addClass(this.map.viewPortDiv,"olCursorWait");c=this.protocol.read({maxFeatures:b.single==true?this.maxFeatures:
undefined,filter:c,callback:function(d){if(d.success())if(d.features.length)b.single==true?this.selectBestFeature(d.features,a.getCenterLonLat(),b):this.select(d.features);else if(b.hover)this.hoverSelect();else{this.events.triggerEvent("clickout");this.clickout&&this.unselectAll()}OpenLayers.Element.removeClass(this.map.viewPortDiv,"olCursorWait")},scope:this});if(b.hover==true)this.hoverResponse=c},selectBestFeature:function(a,b,c){c=c||{};if(a.length){b=new OpenLayers.Geometry.Point(b.lon,b.lat);
for(var d,e,f,g=Number.MAX_VALUE,h=0;h<a.length;++h){d=a[h];if(d.geometry){f=b.distanceTo(d.geometry,{edge:false});if(f<g){g=f;e=d;if(g==0)break}}}c.hover==true?this.hoverSelect(e):this.select(e||a)}},setModifiers:function(a){this.modifiers={multiple:this.multiple||this.multipleKey&&a[this.multipleKey],toggle:this.toggle||this.toggleKey&&a[this.toggleKey]}},select:function(a){!this.modifiers.multiple&&!this.modifiers.toggle&&this.unselectAll();OpenLayers.Util.isArray(a)||(a=[a]);var b=this.events.triggerEvent("beforefeaturesselected",
{features:a});if(b!==false){for(var c=[],d,e=0,f=a.length;e<f;++e){d=a[e];if(this.features[d.fid||d.id]){if(this.modifiers.toggle)this.unselect(this.features[d.fid||d.id])}else{b=this.events.triggerEvent("beforefeatureselected",{feature:d});if(b!==false){this.features[d.fid||d.id]=d;c.push(d);this.events.triggerEvent("featureselected",{feature:d})}}}this.events.triggerEvent("featuresselected",{features:c})}},hoverSelect:function(a){var b=a?a.fid||a.id:null,c=this.hoverFeature?this.hoverFeature.fid||
this.hoverFeature.id:null;if(c&&c!=b){this.events.triggerEvent("outfeature",{feature:this.hoverFeature});this.hoverFeature=null}if(b&&b!=c){this.events.triggerEvent("hoverfeature",{feature:a});this.hoverFeature=a}},unselect:function(a){delete this.features[a.fid||a.id];this.events.triggerEvent("featureunselected",{feature:a})},unselectAll:function(){for(var a in this.features)this.unselect(this.features[a])},setMap:function(a){for(var b in this.handlers)this.handlers[b].setMap(a);OpenLayers.Control.prototype.setMap.apply(this,
arguments)},pixelToBounds:function(a){var b=a.add(-this.clickTolerance/2,this.clickTolerance/2);a=a.add(this.clickTolerance/2,-this.clickTolerance/2);b=this.map.getLonLatFromPixel(b);a=this.map.getLonLatFromPixel(a);return new OpenLayers.Bounds(b.lon,b.lat,a.lon,a.lat)},CLASS_NAME:"OpenLayers.Control.GetFeature"});
if(!window.console||!console.firebug)(function(){function a(o){K=o||!K;if(y)y.style.visibility=K?"visible":"hidden";else b()}function b(){document.body?c():setTimeout(b,200)}function c(){if(!y){window.onFirebugReady=function(q){window.onFirebugReady=null;q.getElementById("toolbar").onmousedown=J;D=q.getElementById("commandLine");v(D,"keydown",R);v(q,Q||O?"keydown":"keypress",C);z=q.getElementById("log");e();q=P;P=[];for(var u=0;u<q.length;++u)g(q[u][0],q[u][1],q[u][2])};var o=d();y=document.createElement("iframe");
y.setAttribute("src",o+"/firebug.html");y.setAttribute("frameBorder","0");y.style.visibility=K?"visible":"hidden";y.style.zIndex="2147483583";y.style.position=document.all?"absolute":"fixed";y.style.width="100%";y.style.left="0";y.style.bottom="0";y.style.height="200px";document.body.appendChild(y)}}function d(){for(var o=document.getElementsByTagName("script"),q=0;q<o.length;++q)if(o[q].src.indexOf("firebug.js")!=-1){var u=o[q].src.lastIndexOf("/");return o[q].src.substr(0,u)}}function e(){var o=
z.ownerDocument.getElementById("toolbar"),q=y.offsetHeight-(o.offsetHeight+D.offsetHeight);q=Math.max(q,0);z.style.top=o.offsetHeight+"px";z.style.height=q+"px";D.style.top=y.offsetHeight-D.offsetHeight+"px"}function f(o,q,u){if(z)g(o,q,u);else{P.push([o,q,u]);b()}}function g(o,q,u){var w=z.scrollTop+z.offsetHeight>=z.scrollHeight;u||(u=h);u(o,q);if(w)z.scrollTop=z.scrollHeight-z.offsetHeight}function h(o,q){var u=z.ownerDocument.createElement("div");u.className="logRow"+(q?" logRow-"+q:"");u.innerHTML=
o.join("");(G.length?G[G.length-1]:z).appendChild(u)}function j(o,q){k(o,q);var u=z.ownerDocument.createElement("div");u.className="logGroup";var w=z.ownerDocument.createElement("div");w.className="logGroupBox";u.appendChild(w);(G.length?G[G.length-1]:z).appendChild(w);G.push(w)}function i(){G.pop()}function k(o,q){var u=[],w=o[0],H=0;if(typeof w!="string"){w="";H=-1}var A=w;w=[];for(var I=/((^%|[^\\]%)(\d+)?(\.)([a-zA-Z]))|((^%|[^\\]%)([a-zA-Z]))/,E={s:m,d:p,i:p,f:r},B=I.exec(A);B;B=I.exec(A)){var L=
B[8]?B[8]:B[5];L=L in E?E[L]:t;var S=B[3]?parseInt(B[3]):B[4]=="."?-1:0;w.push(A.substr(0,B[0][0]=="%"?B.index:B.index+1));w.push({appender:L,precision:S});A=A.substr(B.index+B[0].length)}w.push(A);for(A=0;A<w.length;++A)if((I=w[A])&&typeof I=="object"){E=o[++H];I.appender(E,u)}else m(I,u);for(A=H+1;A<o.length;++A){m(" ",u);E=o[A];typeof E=="string"?m(E,u):t(E,u)}f(u,q)}function l(o){return String(o).replace(/[<>&"']/g,function(q){switch(q){case "<":return"&lt;";case ">":return"&gt;";case "&":return"&amp;";
case "'":return"&#39;";case '"':return"&quot;"}return"?"})}function m(o,q){q.push(l(o+""))}function n(o,q){q.push('<span class="objectBox-null">',l(o+""),"</span>")}function p(o,q){q.push('<span class="objectBox-number">',l(o+""),"</span>")}function r(o,q){q.push('<span class="objectBox-number">',l(o+""),"</span>")}function t(o,q){try{if(o==undefined)n("undefined",q);else if(o==null)n("null",q);else if(typeof o=="string")q.push('<span class="objectBox-string">&quot;',l(o+""),"&quot;</span>");else if(typeof o==
"number")p(o,q);else if(typeof o=="function"){var u=/function ?(.*?)\(/.exec(o+"");q.push('<span class="objectBox-function">',l(u?u[1]:"function"),"()</span>")}else if(o.nodeType==1){q.push('<span class="objectBox-selector">');q.push('<span class="selectorTag">',l(o.nodeName.toLowerCase()),"</span>");o.id&&q.push('<span class="selectorId">#',l(o.id),"</span>");o.className&&q.push('<span class="selectorClass">.',l(o.className),"</span>");q.push("</span>")}else if(typeof o=="object"){u=o+"";var w=/\[object (.*?)\]/.exec(u);
q.push('<span class="objectBox-object">',w?w[1]:u,"</span>")}else m(o,q)}catch(H){}}function s(o,q){if(o.nodeType==1){q.push('<div class="objectBox-element">','&lt;<span class="nodeTag">',o.nodeName.toLowerCase(),"</span>");for(var u=0;u<o.attributes.length;++u){var w=o.attributes[u];w.specified&&q.push('&nbsp;<span class="nodeName">',w.nodeName.toLowerCase(),'</span>=&quot;<span class="nodeValue">',l(w.nodeValue),"</span>&quot;")}if(o.firstChild){q.push('&gt;</div><div class="nodeChildren">');for(u=
o.firstChild;u;u=u.nextSibling)s(u,q);q.push('</div><div class="objectBox-element">&lt;/<span class="nodeTag">',o.nodeName.toLowerCase(),"&gt;</span></div>")}else q.push("/&gt;</div>")}else o.nodeType==3&&q.push('<div class="nodeText">',l(o.nodeValue),"</div>")}function v(o,q,u){document.all?o.attachEvent("on"+q,u):o.addEventListener(q,u,false)}function x(o,q,u){document.all?o.detachEvent("on"+q,u):o.removeEventListener(q,u,false)}function C(o){if(o.keyCode==123)a();else if((o.keyCode==108||o.keyCode==
76)&&o.shiftKey&&(o.metaKey||o.ctrlKey)){a(true);D&&D.focus()}else return;if(document.all)o.cancelBubble=true;else o.stopPropagation()}function J(){if(!(O||T)){v(document,"mousemove",F);v(document,"mouseup",M);for(var o=0;o<frames.length;++o){v(frames[o].document,"mousemove",F);v(frames[o].document,"mouseup",M)}}}function F(o){var q=document.all?o.srcElement.ownerDocument.parentWindow:o.target.ownerDocument.defaultView;o=o.clientY;if(q!=q.parent)o+=q.frameElement?q.frameElement.offsetTop:0;q=y.offsetTop+
y.clientHeight;var u=z.ownerDocument.getElementById("toolbar");y.style.height=Math.max(q-o,u.offsetHeight+D.offsetHeight)+"px";e()}function M(){x(document,"mousemove",F);x(document,"mouseup",M);for(var o=0;o<frames.length;++o){x(frames[o].document,"mousemove",F);x(frames[o].document,"mouseup",M)}}function R(o){if(o.keyCode==13){o=D.value;D.value="";f([U,o],"command");var q;try{q=eval(o)}catch(u){}console.log(q)}else if(o.keyCode==27)D.value=""}window.console={log:function(){k(arguments,"")},debug:function(){k(arguments,
"debug")},info:function(){k(arguments,"info")},warn:function(){k(arguments,"warning")},error:function(){k(arguments,"error")},assert:function(o,q){if(!o){for(var u=[],w=1;w<arguments.length;++w)u.push(arguments[w]);k(u.length?u:["Assertion Failure"],"error");throw q?q:"Assertion Failure";}},dir:function(o){var q=[],u=[],w;for(w in o)try{u.push([w,o[w]])}catch(H){}u.sort(function(I,E){return I[0]<E[0]?-1:1});q.push("<table>");for(o=0;o<u.length;++o){w=u[o][0];var A=u[o][1];q.push("<tr>",'<td class="propertyNameCell"><span class="propertyName">',
l(w),"</span></td>",'<td><span class="propertyValue">');t(A,q);q.push("</span></td></tr>")}q.push("</table>");f(q,"dir")},dirxml:function(o){var q=[];s(o,q);f(q,"dirxml")},group:function(){f(arguments,"group",j)},groupEnd:function(){f(arguments,"",i)},time:function(o){N[o]=(new Date).getTime()},timeEnd:function(o){if(o in N){var q=(new Date).getTime()-N[o];k([o+":",q+"ms"]);delete N[o]}},count:function(){this.warn(["count() not supported."])},trace:function(){this.warn(["trace() not supported."])},
profile:function(){this.warn(["profile() not supported."])},profileEnd:function(){},clear:function(){z.innerHTML=""},open:function(){a(true)},close:function(){K&&a()}};var y=null,z=null,D=null,K=false,P=[],G=[],N={},U=">>> ";navigator.userAgent.indexOf("Firefox");var Q=navigator.userAgent.indexOf("MSIE")!=-1,T=navigator.userAgent.indexOf("Opera")!=-1,O=navigator.userAgent.indexOf("AppleWebKit")!=-1;window.onerror=function(o,q,u){var w=[],H=q.lastIndexOf("/");q=H==-1?q:q.substr(H+1);w.push('<span class="errorMessage">',
o,"</span>",'<div class="objectBox-sourceLink">',q," (line ",u,")</div>");f(w,"error")};v(document,Q||O?"keydown":"keypress",C);document.documentElement.getAttribute("debug")=="true"&&a(true)})();
OpenLayers.Control.MousePosition=OpenLayers.Class(OpenLayers.Control,{autoActivate:true,element:null,prefix:"",separator:", ",suffix:"",numDigits:5,granularity:10,emptyString:null,lastXy:null,displayProjection:null,destroy:function(){this.deactivate();OpenLayers.Control.prototype.destroy.apply(this,arguments)},activate:function(){if(OpenLayers.Control.prototype.activate.apply(this,arguments)){this.map.events.register("mousemove",this,this.redraw);this.map.events.register("mouseout",this,this.reset);
this.redraw();return true}else return false},deactivate:function(){if(OpenLayers.Control.prototype.deactivate.apply(this,arguments)){this.map.events.unregister("mousemove",this,this.redraw);this.map.events.unregister("mouseout",this,this.reset);this.element.innerHTML="";return true}else return false},draw:function(){OpenLayers.Control.prototype.draw.apply(this,arguments);if(!this.element){this.div.left="";this.div.top="";this.element=this.div}return this.div},redraw:function(a){var b;if(a==null)this.reset();
else if(this.lastXy==null||Math.abs(a.xy.x-this.lastXy.x)>this.granularity||Math.abs(a.xy.y-this.lastXy.y)>this.granularity)this.lastXy=a.xy;else if(b=this.map.getLonLatFromPixel(a.xy)){this.displayProjection&&b.transform(this.map.getProjectionObject(),this.displayProjection);this.lastXy=a.xy;a=this.formatOutput(b);if(a!=this.element.innerHTML)this.element.innerHTML=a}},reset:function(){if(this.emptyString!=null)this.element.innerHTML=this.emptyString},formatOutput:function(a){var b=parseInt(this.numDigits);
return this.prefix+a.lon.toFixed(b)+this.separator+a.lat.toFixed(b)+this.suffix},CLASS_NAME:"OpenLayers.Control.MousePosition"});
OpenLayers.Control.Geolocate=OpenLayers.Class(OpenLayers.Control,{EVENT_TYPES:["locationupdated","locationfailed","locationuncapable"],geolocation:navigator.geolocation,bind:true,watch:false,geolocationOptions:null,initialize:function(a){this.EVENT_TYPES=OpenLayers.Control.Geolocate.prototype.EVENT_TYPES.concat(OpenLayers.Control.prototype.EVENT_TYPES);this.geolocationOptions={};OpenLayers.Control.prototype.initialize.apply(this,[a])},destroy:function(){this.deactivate();OpenLayers.Control.prototype.destroy.apply(this,
arguments)},activate:function(){if(!this.geolocation){this.events.triggerEvent("locationuncapable");return false}if(OpenLayers.Control.prototype.activate.apply(this,arguments)){if(this.watch)this.watchId=this.geolocation.watchPosition(OpenLayers.Function.bind(this.geolocate,this),OpenLayers.Function.bind(this.failure,this),this.geolocationOptions);else this.getCurrentLocation();return true}return false},deactivate:function(){this.active&&this.watchId!==null&&this.geolocation.clearWatch(this.watchId);
return OpenLayers.Control.prototype.deactivate.apply(this,arguments)},geolocate:function(a){var b=(new OpenLayers.LonLat(a.coords.longitude,a.coords.latitude)).transform(new OpenLayers.Projection("EPSG:4326"),this.map.getProjectionObject());this.bind&&this.map.setCenter(b);this.events.triggerEvent("locationupdated",{position:a,point:new OpenLayers.Geometry.Point(b.lon,b.lat)})},getCurrentLocation:function(){if(!this.active||this.watch)return false;this.geolocation.getCurrentPosition(OpenLayers.Function.bind(this.geolocate,
this),OpenLayers.Function.bind(this.failure,this),this.geolocationOptions);return true},failure:function(a){this.events.triggerEvent("locationfailed",{error:a})},CLASS_NAME:"OpenLayers.Control.Geolocate"});
OpenLayers.Format.QueryStringFilter=function(){function a(c){c=c.replace(/%/g,"\\%");c=c.replace(/\\\\\.(\*)?/g,function(d,e){return e?d:"\\\\_"});c=c.replace(/\\\\\.\*/g,"\\\\%");c=c.replace(/(\\)?\.(\*)?/g,function(d,e,f){return e||f?d:"_"});c=c.replace(/(\\)?\.\*/g,function(d,e){return e?d:"%"});c=c.replace(/\\\./g,".");return c=c.replace(/(\\)?\\\*/g,function(d,e){return e?d:"*"})}var b={};b[OpenLayers.Filter.Comparison.EQUAL_TO]="eq";b[OpenLayers.Filter.Comparison.NOT_EQUAL_TO]="ne";b[OpenLayers.Filter.Comparison.LESS_THAN]=
"lt";b[OpenLayers.Filter.Comparison.LESS_THAN_OR_EQUAL_TO]="lte";b[OpenLayers.Filter.Comparison.GREATER_THAN]="gt";b[OpenLayers.Filter.Comparison.GREATER_THAN_OR_EQUAL_TO]="gte";b[OpenLayers.Filter.Comparison.LIKE]="ilike";return OpenLayers.Class(OpenLayers.Format,{wildcarded:false,srsInBBOX:false,write:function(c,d){d=d||{};var e=c.CLASS_NAME;e=e.substring(e.lastIndexOf(".")+1);switch(e){case "Spatial":switch(c.type){case OpenLayers.Filter.Spatial.BBOX:d.bbox=c.value.toArray();this.srsInBBOX&&c.projection&&
d.bbox.push(c.projection.getCode());break;case OpenLayers.Filter.Spatial.DWITHIN:d.tolerance=c.distance;case OpenLayers.Filter.Spatial.WITHIN:d.lon=c.value.x;d.lat=c.value.y;break;default:OpenLayers.Console.warn("Unknown spatial filter type "+c.type)}break;case "Comparison":e=b[c.type];if(e!==undefined){var f=c.value;if(c.type==OpenLayers.Filter.Comparison.LIKE){f=a(f);if(this.wildcarded)f="%"+f+"%"}d[c.property+"__"+e]=f;d.queryable=d.queryable||[];d.queryable.push(c.property)}else OpenLayers.Console.warn("Unknown comparison filter type "+
c.type);break;case "Logical":if(c.type===OpenLayers.Filter.Logical.AND){e=0;for(f=c.filters.length;e<f;e++)d=this.write(c.filters[e],d)}else OpenLayers.Console.warn("Unsupported logical filter type "+c.type);break;default:OpenLayers.Console.warn("Unknown filter type "+e)}return d},CLASS_NAME:"OpenLayers.Format.QueryStringFilter"})}();
OpenLayers.Protocol.HTTP=OpenLayers.Class(OpenLayers.Protocol,{url:null,headers:null,params:null,callback:null,scope:null,readWithPOST:false,wildcarded:false,srsInBBOX:false,initialize:function(){this.params={};this.headers={};OpenLayers.Protocol.prototype.initialize.apply(this,arguments);if(!this.filterToParams&&OpenLayers.Format.QueryStringFilter){var a=new OpenLayers.Format.QueryStringFilter({wildcarded:this.wildcarded,srsInBBOX:this.srsInBBOX});this.filterToParams=function(b,c){return a.write(b,
c)}}},destroy:function(){this.headers=this.params=null;OpenLayers.Protocol.prototype.destroy.apply(this)},read:function(a){OpenLayers.Protocol.prototype.read.apply(this,arguments);a=a||{};a.params=OpenLayers.Util.applyDefaults(a.params,this.options.params);a=OpenLayers.Util.applyDefaults(a,this.options);if(a.filter&&this.filterToParams)a.params=this.filterToParams(a.filter,a.params);var b=a.readWithPOST!==undefined?a.readWithPOST:this.readWithPOST,c=new OpenLayers.Protocol.Response({requestType:"read"});
c.priv=b?OpenLayers.Request.POST({url:a.url,callback:this.createCallback(this.handleRead,c,a),data:OpenLayers.Util.getParameterString(a.params),headers:{"Content-Type":"application/x-www-form-urlencoded"}}):OpenLayers.Request.GET({url:a.url,callback:this.createCallback(this.handleRead,c,a),params:a.params,headers:a.headers});return c},handleRead:function(a,b){this.handleResponse(a,b)},create:function(a,b){b=OpenLayers.Util.applyDefaults(b,this.options);var c=new OpenLayers.Protocol.Response({reqFeatures:a,
requestType:"create"});c.priv=OpenLayers.Request.POST({url:b.url,callback:this.createCallback(this.handleCreate,c,b),headers:b.headers,data:this.format.write(a)});return c},handleCreate:function(a,b){this.handleResponse(a,b)},update:function(a,b){b=b||{};var c=b.url||a.url||this.options.url+"/"+a.fid;b=OpenLayers.Util.applyDefaults(b,this.options);var d=new OpenLayers.Protocol.Response({reqFeatures:a,requestType:"update"});d.priv=OpenLayers.Request.PUT({url:c,callback:this.createCallback(this.handleUpdate,
d,b),headers:b.headers,data:this.format.write(a)});return d},handleUpdate:function(a,b){this.handleResponse(a,b)},"delete":function(a,b){b=b||{};var c=b.url||a.url||this.options.url+"/"+a.fid;b=OpenLayers.Util.applyDefaults(b,this.options);var d=new OpenLayers.Protocol.Response({reqFeatures:a,requestType:"delete"});d.priv=OpenLayers.Request.DELETE({url:c,callback:this.createCallback(this.handleDelete,d,b),headers:b.headers});return d},handleDelete:function(a,b){this.handleResponse(a,b)},handleResponse:function(a,
b){var c=a.priv;if(b.callback){if(c.status>=200&&c.status<300){if(a.requestType!="delete")a.features=this.parseFeatures(c);a.code=OpenLayers.Protocol.Response.SUCCESS}else a.code=OpenLayers.Protocol.Response.FAILURE;b.callback.call(b.scope,a)}},parseFeatures:function(a){var b=a.responseXML;if(!b||!b.documentElement)b=a.responseText;if(!b||b.length<=0)return null;return this.format.read(b)},commit:function(a,b){function c(r){for(var t=r.features?r.features.length:0,s=Array(t),v=0;v<t;++v)s[v]=r.features[v].fid;
p.insertIds=s;d.apply(this,[r])}function d(r){this.callUserCallback(r,b);n=n&&r.success();f++;if(f>=m)if(b.callback){p.code=n?OpenLayers.Protocol.Response.SUCCESS:OpenLayers.Protocol.Response.FAILURE;b.callback.apply(b.scope,[p])}}b=OpenLayers.Util.applyDefaults(b,this.options);var e=[],f=0,g={};g[OpenLayers.State.INSERT]=[];g[OpenLayers.State.UPDATE]=[];g[OpenLayers.State.DELETE]=[];for(var h,j,i=[],k=0,l=a.length;k<l;++k){h=a[k];if(j=g[h.state]){j.push(h);i.push(h)}}var m=(g[OpenLayers.State.INSERT].length>
0?1:0)+g[OpenLayers.State.UPDATE].length+g[OpenLayers.State.DELETE].length,n=true,p=new OpenLayers.Protocol.Response({reqFeatures:i});h=g[OpenLayers.State.INSERT];h.length>0&&e.push(this.create(h,OpenLayers.Util.applyDefaults({callback:c,scope:this},b.create)));h=g[OpenLayers.State.UPDATE];for(k=h.length-1;k>=0;--k)e.push(this.update(h[k],OpenLayers.Util.applyDefaults({callback:d,scope:this},b.update)));h=g[OpenLayers.State.DELETE];for(k=h.length-1;k>=0;--k)e.push(this["delete"](h[k],OpenLayers.Util.applyDefaults({callback:d,
scope:this},b["delete"])));return e},abort:function(a){a&&a.priv.abort()},callUserCallback:function(a,b){var c=b[a.requestType];c&&c.callback&&c.callback.call(c.scope,a)},CLASS_NAME:"OpenLayers.Protocol.HTTP"});OpenLayers.Format.CSWGetDomain=function(a){a=OpenLayers.Util.applyDefaults(a,OpenLayers.Format.CSWGetDomain.DEFAULTS);var b=OpenLayers.Format.CSWGetDomain["v"+a.version.replace(/\./g,"_")];if(!b)throw"Unsupported CSWGetDomain version: "+a.version;return new b(a)};
OpenLayers.Format.CSWGetDomain.DEFAULTS={version:"2.0.2"};
OpenLayers.Format.CSWGetDomain.v2_0_2=OpenLayers.Class(OpenLayers.Format.XML,{namespaces:{xlink:"http://www.w3.org/1999/xlink",xsi:"http://www.w3.org/2001/XMLSchema-instance",csw:"http://www.opengis.net/cat/csw/2.0.2"},defaultPrefix:"csw",version:"2.0.2",schemaLocation:"http://www.opengis.net/cat/csw/2.0.2 http://schemas.opengis.net/csw/2.0.2/CSW-discovery.xsd",PropertyName:null,ParameterName:null,initialize:function(a){OpenLayers.Format.XML.prototype.initialize.apply(this,[a])},read:function(a){if(typeof a==
"string")a=OpenLayers.Format.XML.prototype.read.apply(this,[a]);if(a&&a.nodeType==9)a=a.documentElement;var b={};this.readNode(a,b);return b},readers:{csw:{GetDomainResponse:function(a,b){this.readChildNodes(a,b)},DomainValues:function(a,b){if(!OpenLayers.Util.isArray(b.DomainValues))b.DomainValues=[];for(var c=a.attributes,d={},e=0,f=c.length;e<f;++e)d[c[e].name]=c[e].nodeValue;this.readChildNodes(a,d);b.DomainValues.push(d)},PropertyName:function(a,b){b.PropertyName=this.getChildValue(a)},ParameterName:function(a,
b){b.ParameterName=this.getChildValue(a)},ListOfValues:function(a,b){if(!OpenLayers.Util.isArray(b.ListOfValues))b.ListOfValues=[];this.readChildNodes(a,b.ListOfValues)},Value:function(a,b){for(var c=a.attributes,d={},e=0,f=c.length;e<f;++e)d[c[e].name]=c[e].nodeValue;d.value=this.getChildValue(a);b.push({Value:d})},ConceptualScheme:function(a,b){b.ConceptualScheme={};this.readChildNodes(a,b.ConceptualScheme)},Name:function(a,b){b.Name=this.getChildValue(a)},Document:function(a,b){b.Document=this.getChildValue(a)},
Authority:function(a,b){b.Authority=this.getChildValue(a)},RangeOfValues:function(a,b){b.RangeOfValues={};this.readChildNodes(a,b.RangeOfValues)},MinValue:function(a,b){for(var c=a.attributes,d={},e=0,f=c.length;e<f;++e)d[c[e].name]=c[e].nodeValue;d.value=this.getChildValue(a);b.MinValue=d},MaxValue:function(a,b){for(var c=a.attributes,d={},e=0,f=c.length;e<f;++e)d[c[e].name]=c[e].nodeValue;d.value=this.getChildValue(a);b.MaxValue=d}}},write:function(a){a=this.writeNode("csw:GetDomain",a);return OpenLayers.Format.XML.prototype.write.apply(this,
[a])},writers:{csw:{GetDomain:function(a){var b=this.createElementNSPlus("csw:GetDomain",{attributes:{service:"CSW",version:this.version}});if(a.PropertyName||this.PropertyName)this.writeNode("csw:PropertyName",a.PropertyName||this.PropertyName,b);else if(a.ParameterName||this.ParameterName)this.writeNode("csw:ParameterName",a.ParameterName||this.ParameterName,b);this.readChildNodes(b,a);return b},PropertyName:function(a){return this.createElementNSPlus("csw:PropertyName",{value:a})},ParameterName:function(a){return this.createElementNSPlus("csw:ParameterName",
{value:a})}}},CLASS_NAME:"OpenLayers.Format.CSWGetDomain.v2_0_2"});
OpenLayers.Lang.nl=OpenLayers.Util.applyDefaults({unhandledRequest:"Het verzoek is niet afgehandeld met de volgende melding: ${statusText}",Permalink:"Permanente verwijzing",Overlays:"Overlays","Base Layer":"Achtergrondkaart",readNotImplemented:"Lezen is niet ge\u00efmplementeerd.",writeNotImplemented:"Schrijven is niet ge\u00efmplementeerd.",noFID:"Een optie die geen FID heeft kan niet bijgewerkt worden.",errorLoadingGML:"Er is een fout opgetreden bij het laden van het GML bestand van ${url}",browserNotSupported:"Uw browser ondersteunt het weergeven van vectoren niet.\nMomenteel ondersteunde weergavemogelijkheden:\n${renderers}",
componentShouldBe:"addFeatures : component moet van het type ${geomType} zijn",getFeatureError:"getFeatureFromEvent is aangeroepen op een laag zonder rederer.\nDit betekent meestal dat u een laag hebt verwijderd, maar niet een handler die ermee geassocieerd was.",minZoomLevelError:"De eigenschap minZoomLevel is alleen bedoeld voor gebruik lagen met die afstammen van FixedZoomLevels-lagen.\nDat deze WFS-laag minZoomLevel controleert, is een overblijfsel uit het verleden.\nWe kunnen deze controle echter niet verwijderen zonder op OL gebaseerde applicaties die hervan afhankelijk zijn stuk te maken.\nDaarom heeft deze functionaliteit de eigenschap 'deprecated' gekregen - de minZoomLevel wordt verwijderd in versie 3.0.\nGebruik in plaats van deze functie de mogelijkheid om min/max voor resolutie in te stellen zoals op de volgende pagina wordt beschreven:\nhttp://trac.openlayers.org/wiki/SettingZoomLevels",
commitSuccess:"WFS-transactie: succesvol ${response}",commitFailed:"WFS-transactie: mislukt ${response}",googleWarning:"De Google-Layer kon niet correct geladen worden.<br /><br />\nOm deze melding niet meer te krijgen, moet u een andere achtergrondkaart kiezen in de laagwisselaar in de rechterbovenhoek.<br /><br />\nDit komt waarschijnlijk doordat de bibliotheek ${layerLib} niet correct ingevoegd is.<br /><br />\nOntwikkelaars: <a href='http://trac.openlayers.org/wiki/${layerLib}' target='_blank'>klik hier</a> om dit werkend te krijgen.",
getLayerWarning:"De laag ${layerType} kon niet goed geladen worden.<br /><br />\nOm deze melding niet meer te krijgen, moet u een andere achtergrondkaart kiezen in de laagwisselaar in de rechterbovenhoek.<br /><br />\nDit komt waarschijnlijk doordat de bibliotheek ${layerLib} niet correct is ingevoegd.<br /><br />\nOntwikkelaars: <a href='http://trac.openlayers.org/wiki/${layerLib}' target='_blank'>klik hier</a> om dit werkend te krijgen.","Scale = 1 : ${scaleDenom}":"Schaal = 1 : ${scaleDenom}",
W:"W",E:"O",N:"N",S:"Z",layerAlreadyAdded:"U hebt geprobeerd om de laag  ${layerName} aan de kaart toe te voegen, maar deze is al toegevoegd",reprojectDeprecated:"U gebruikt de optie 'reproject' op de laag ${layerName}.\nDeze optie is vervallen: deze optie was ontwikkeld om gegevens over commerci\u00eble basiskaarten weer te geven, maar deze functionaliteit wordt nu bereikt door ondersteuning van Spherical Mercator.\nMeer informatie is beschikbaar op http://trac.openlayers.org/wiki/SphericalMercator.",
methodDeprecated:"Deze methode is verouderd en wordt verwijderd in versie 3.0.\nGebruik ${newMethod}.",boundsAddError:"U moet zowel de x- als de y-waarde doorgeven aan de toevoegfunctie.",lonlatAddError:"U moet zowel de lengte- als de breedtewaarde doorgeven aan de toevoegfunctie.",pixelAddError:"U moet zowel de x- als de y-waarde doorgeven aan de toevoegfunctie.",unsupportedGeometryType:"Dit geometrietype wordt niet ondersteund: ${geomType}",filterEvaluateNotImplemented:"evalueren is niet ge\u00efmplementeerd voor dit filtertype."});
OpenLayers.Strategy.Cluster=OpenLayers.Class(OpenLayers.Strategy,{distance:20,threshold:null,features:null,clusters:null,clustering:false,resolution:null,activate:function(){var a=OpenLayers.Strategy.prototype.activate.call(this);if(a)this.layer.events.on({beforefeaturesadded:this.cacheFeatures,moveend:this.cluster,scope:this});return a},deactivate:function(){var a=OpenLayers.Strategy.prototype.deactivate.call(this);if(a){this.clearCache();this.layer.events.un({beforefeaturesadded:this.cacheFeatures,
moveend:this.cluster,scope:this})}return a},cacheFeatures:function(a){var b=true;if(!this.clustering){this.clearCache();this.features=a.features;this.cluster();b=false}return b},clearCache:function(){this.features=null},cluster:function(a){if((!a||a.zoomChanged)&&this.features){a=this.layer.map.getResolution();if(a!=this.resolution||!this.clustersExist()){this.resolution=a;a=[];for(var b,c,d,e=0;e<this.features.length;++e){b=this.features[e];if(b.geometry){c=false;for(var f=a.length-1;f>=0;--f){d=
a[f];if(this.shouldCluster(d,b)){this.addToCluster(d,b);c=true;break}}c||a.push(this.createCluster(this.features[e]))}}this.layer.removeAllFeatures();if(a.length>0){if(this.threshold>1){b=a.slice();a=[];e=0;for(d=b.length;e<d;++e){c=b[e];c.attributes.count<this.threshold?Array.prototype.push.apply(a,c.cluster):a.push(c)}}this.clustering=true;this.layer.addFeatures(a);this.clustering=false}this.clusters=a}}},clustersExist:function(){var a=false;if(this.clusters&&this.clusters.length>0&&this.clusters.length==
this.layer.features.length){a=true;for(var b=0;b<this.clusters.length;++b)if(this.clusters[b]!=this.layer.features[b]){a=false;break}}return a},shouldCluster:function(a,b){var c=a.geometry.getBounds().getCenterLonLat(),d=b.geometry.getBounds().getCenterLonLat();return Math.sqrt(Math.pow(c.lon-d.lon,2)+Math.pow(c.lat-d.lat,2))/this.resolution<=this.distance},addToCluster:function(a,b){a.cluster.push(b);a.attributes.count+=1},createCluster:function(a){var b=a.geometry.getBounds().getCenterLonLat();
b=new OpenLayers.Feature.Vector(new OpenLayers.Geometry.Point(b.lon,b.lat),{count:1});b.cluster=[a];return b},CLASS_NAME:"OpenLayers.Strategy.Cluster"});
OpenLayers.Strategy.Filter=OpenLayers.Class(OpenLayers.Strategy,{filter:null,cache:null,caching:false,activate:function(){var a=OpenLayers.Strategy.prototype.activate.apply(this,arguments);if(a){this.cache=[];this.layer.events.on({beforefeaturesadded:this.handleAdd,beforefeaturesremoved:this.handleRemove,scope:this})}return a},deactivate:function(){this.cache=null;this.layer&&this.layer.events&&this.layer.events.un({beforefeaturesadded:this.handleAdd,beforefeaturesremoved:this.handleRemove,scope:this});
return OpenLayers.Strategy.prototype.deactivate.apply(this,arguments)},handleAdd:function(a){if(!this.caching&&this.filter){var b=a.features;a.features=[];for(var c,d=0,e=b.length;d<e;++d){c=b[d];this.filter.evaluate(c)?a.features.push(c):this.cache.push(c)}}},handleRemove:function(){if(!this.caching)this.cache=[]},setFilter:function(a){this.filter=a;a=this.cache;this.cache=[];this.handleAdd({features:this.layer.features});if(this.cache.length>0){this.caching=true;this.layer.removeFeatures(this.cache.slice());
this.caching=false}if(a.length>0){a={features:a};this.handleAdd(a);if(a.features.length>0){this.caching=true;this.layer.addFeatures(a.features);this.caching=false}}},CLASS_NAME:"OpenLayers.Strategy.Filter"});OpenLayers.Protocol.SOS=function(a){a=OpenLayers.Util.applyDefaults(a,OpenLayers.Protocol.SOS.DEFAULTS);var b=OpenLayers.Protocol.SOS["v"+a.version.replace(/\./g,"_")];if(!b)throw"Unsupported SOS version: "+a.version;return new b(a)};OpenLayers.Protocol.SOS.DEFAULTS={version:"1.0.0"};
OpenLayers.Lang.fr=OpenLayers.Util.applyDefaults({unhandledRequest:"Requ\u00eate non g\u00e9r\u00e9e, retournant ${statusText}",Permalink:"Permalien",Overlays:"Calques","Base Layer":"Calque de base",readNotImplemented:"Lecture non impl\u00e9ment\u00e9e.",writeNotImplemented:"Ecriture non impl\u00e9ment\u00e9e.",noFID:"Impossible de mettre \u00e0 jour un objet sans identifiant (fid).",errorLoadingGML:"Erreur au chargement du fichier GML ${url}",browserNotSupported:"Votre navigateur ne supporte pas le rendu vectoriel. Les renderers actuellement support\u00e9s sont : \n${renderers}",
componentShouldBe:"addFeatures : le composant devrait \u00eatre de type ${geomType}",getFeatureError:"getFeatureFromEvent a \u00e9t\u00e9 appel\u00e9 sur un calque sans renderer. Cela signifie g\u00e9n\u00e9ralement que vous avez d\u00e9truit cette couche, mais que vous avez conserv\u00e9 un handler qui lui \u00e9tait associ\u00e9.",minZoomLevelError:"La propri\u00e9t\u00e9 minZoomLevel doit seulement \u00eatre utilis\u00e9e pour des couches FixedZoomLevels-descendent. Le fait que cette couche WFS v\u00e9rifie la pr\u00e9sence de minZoomLevel est une relique du pass\u00e9. Nous ne pouvons toutefois la supprimer sans casser des applications qui pourraient en d\u00e9pendre. C'est pourquoi nous la d\u00e9pr\u00e9cions -- la v\u00e9rification du minZoomLevel sera supprim\u00e9e en version 3.0. A la place, merci d'utiliser les param\u00e8tres de r\u00e9solutions min/max tel que d\u00e9crit sur : http://trac.openlayers.org/wiki/SettingZoomLevels",
commitSuccess:"Transaction WFS : SUCCES ${response}",commitFailed:"Transaction WFS : ECHEC ${response}",googleWarning:"La couche Google n'a pas \u00e9t\u00e9 en mesure de se charger correctement.<br><br>Pour supprimer ce message, choisissez une nouvelle BaseLayer dans le s\u00e9lecteur de couche en haut \u00e0 droite.<br><br>Cela est possiblement caus\u00e9 par la non-inclusion de la librairie Google Maps, ou alors parce que la cl\u00e9 de l'API ne correspond pas \u00e0 votre site.<br><br>D\u00e9veloppeurs : pour savoir comment corriger ceci, <a href='http://trac.openlayers.org/wiki/Google' target='_blank'>cliquez ici</a>",
getLayerWarning:"La couche ${layerType} n'est pas en mesure de se charger correctement.<br><br>Pour supprimer ce message, choisissez une nouvelle BaseLayer dans le s\u00e9lecteur de couche en haut \u00e0 droite.<br><br>Cela est possiblement caus\u00e9 par la non-inclusion de la librairie ${layerLib}.<br><br>D\u00e9veloppeurs : pour savoir comment corriger ceci, <a href='http://trac.openlayers.org/wiki/${layerLib}' target='_blank'>cliquez ici</a>","Scale = 1 : ${scaleDenom}":"Echelle ~ 1 : ${scaleDenom}",
W:"O",E:"E",N:"N",S:"S",layerAlreadyAdded:"Vous avez essay\u00e9 d'ajouter \u00e0 la carte le calque : ${layerName}, mais il est d\u00e9j\u00e0 pr\u00e9sent",reprojectDeprecated:"Vous utilisez l'option 'reproject' sur la couche ${layerName}. Cette option est d\u00e9pr\u00e9ci\u00e9e : Son usage permettait d'afficher des donn\u00e9es au dessus de couches raster commerciales.Cette fonctionalit\u00e9 est maintenant support\u00e9e en utilisant le support de la projection Mercator Sph\u00e9rique. Plus d'information est disponible sur http://trac.openlayers.org/wiki/SphericalMercator.",
methodDeprecated:"Cette m\u00e9thode est d\u00e9pr\u00e9ci\u00e9e, et sera supprim\u00e9e \u00e0 la version 3.0. Merci d'utiliser ${newMethod} \u00e0 la place.",boundsAddError:"Vous devez passer les deux valeurs x et y \u00e0 la fonction add.",lonlatAddError:"Vous devez passer les deux valeurs lon et lat \u00e0 la fonction add.",pixelAddError:"Vous devez passer les deux valeurs x et y \u00e0 la fonction add.",unsupportedGeometryType:"Type de g\u00e9om\u00e9trie non support\u00e9 : ${geomType}",filterEvaluateNotImplemented:"\u00e9valuer n'a pas encore \u00e9t\u00e9 impl\u00e9ment\u00e9 pour ce type de filtre.",
proxyNeeded:"Vous avez tr\u00e8s probablement besoin de renseigner OpenLayers.ProxyHost pour acc\u00e9der \u00e0 ${url}. Voir http://trac.osgeo.org/openlayers/wiki/FrequentlyAskedQuestions#ProxyHost"});
OpenLayers.Lang.ksh=OpenLayers.Util.applyDefaults({unhandledRequest:"Met d\u00e4 Antwoot op en Aanfrooch ham_mer nix aanjefange: ${statusText}",Permalink:"Lengk op Duuer",Overlays:"Dr\u00f6vver jelaat","Base Layer":"Jrund-Nivoh",readNotImplemented:'\u201e<code lang="en">read</code>\u201c is em Projramm nit f\u00fcrjesinn.',writeNotImplemented:'\u201e<code lang="en">write</code>\u201c is em Projramm nit f\u00fcrjesinn.',noFID:'En Saach, woh kein <i lang="en">FID</i> f\u00f6r doh es, l\u00f6ht sesch nit \u00e4ndere.',
errorLoadingGML:'F\u00e4hler beim <i lang="en">GML</i>-Datei-Laade vun <code>${url}</code>',browserNotSupported:"Dinge Brauser kann kein V\u00e4ktore u\u00dfj\u00e4vve. De Zoote U\u00dfjaabe, di em Momang jon, sen:\n${renderers}",componentShouldBe:'<code lang="en">addFeatures</code>: d\u00e4 Aandeil sullt vun d\u00e4 Zoot \u201e<code lang="en">${geomType}</code>\u201c sin.',getFeatureError:'<code lang="en">getFeatureFromEvent</code> es vun enem Nivoh opjeroofe woode, woh et kei Projramm zom U\u00dfj\u00e4vve jit. Dat bed\u00fcgg f\u00f6r jew\u00f6hnlesch, dat De e Nivoh kapott jemaat h\u00e4s, \u00e4vver nit e Projramm f\u00f6r domet \u00f6mzejonn, wat domet verbonge es.',
minZoomLevelError:'De Eijeschaff \u201e<code lang="en">minZoomLevel</code>\u201c es blo\u00df dof\u00f6r jedaach, dat mer se met d\u00e4 Nivvoh\u00df bruch, di vun <code lang="en">FixedZoomLevels</code> affhange don. Dat dat <i lang="en">WFS</i>-Nivvoh \u00f6vverhoup de Eijeschaff \u201e<code lang="en">minZoomLevel</code>\u201c pr\u00f6hfe deiht, es noch \u00f6vveresch vun fr\u00f6hjer. Mer k\u00fcnne dat \u00e4vver jez nit fott loh\u00dfe, oohne dat mer Jevaa loufe, dat Aanwendunge vun OpenLayers nit mieh loufe, di sesch doh velleijsch noch drop am verloh\u00dfe sin. Dr\u00f6m sare mer, dat mer et nit mieh han welle, un de \u201e<code lang="en">minZoomLevel</code>\u201c-Eijeschaff weed hee vun de Version 3.0 af nit mieh jepr\u00f6\u00f6f w\u00e4de. Nemm dof\u00f6r de Enstellung f\u00f6r de h\u00fch\u00dfte un de klein\u00dfte Opl\u00f6hsung, esu wi et en http://trac.openlayers.org/wiki/SettingZoomLevels opjeschrevve es.',
commitSuccess:'D\u00e4 <i lang="en">WFS</i>-V\u00f6rjang es joot jeloufe: ${response}',commitFailed:'D\u00e4 <i lang="en">WFS</i>-V\u00f6rjang es scheif jejange: ${response}',googleWarning:'Dat Nivvoh <code lang="en">Google</code> kunnt nit reschtesch jelaade w\u00e4\u00e4de.<br /><br />\u00d6m hee di Nohreesch lo\u00df ze krijje, donn en ander Jrund-Nivvoh u\u00dfs\u00f6hke, r\u00e4h\u00df bovve en de \u00c4k.<br /><br />Wascheinlesch es dat wiel dat <i lang="en">Google-Maps</i>-Skrepp entweeder nit reschtesch enjebonge wood, udder nit d\u00e4 reschtejje <i lang="en">API</i>-Schl\u00f6\u00dfel f\u00f6r Ding Web-\u00dfait scheke deiht.<br /><br />F\u00f6r Projrammierer jidd_et H\u00f6lp do_dr\u00f6vver, <a href="http://trac.openlayers.org/wiki/Google" target="_blank">wi mer dat aan et Loufe brengk</a>.',
getLayerWarning:'Dat Nivvoh <code>${layerType}</code> kunnt nit reschtesch jelaade w\u00e4\u00e4de.<br /><br />\u00d6m hee di Nohreesch lo\u00df ze krijje, donn en ander Jrund-Nivvoh u\u00dfs\u00f6hkre, r\u00e4h\u00df bovve en de \u00c4k.<br /><br />Wascheinlesch es dat, wiel dat Skrepp <code>${layerLib}</code> nit reschtesch enjebonge wood.<br /><br />F\u00f6r Projrammierer jidd_Et H\u00f6lp do_dr\u00f6vver, <a href="http://trac.openlayers.org/wiki/${layerLib}" target="_blank">wi mer dat aan et Loufe brengk</a>.',
"Scale = 1 : ${scaleDenom}":"Moh\u00dfshtaab = 1 : ${scaleDenom}",W:"W",E:"O",N:"N",S:"S",layerAlreadyAdded:"Do h\u00e4\u00df vers\u00f6hk, dat Nivvoh <code>${layerName}</code> en di Kaat eren ze br\u00e4nge, et wohr \u00e4vver ald do dren.",reprojectDeprecated:"Do bruchs de U\u00dfwahl <code>reproject</code> op d\u00e4m Nivvoh <code>${layerName}</code>. Di U\u00dfwahl es nit mieh j\u00e4hn jesinn. Se wohr dof\u00f6r jedaach, \u00f6m Date op jesch\u00e4\u00e4fsm\u00e4\u00dfesch eru\u00df jejovve Kaate bovve drop ze moole, wat \u00e4vver enzwesche besser met d\u00e4 \u00d6ngersht\u00f6zung f\u00f6r de \u00dff\u00e4\u00e4resche M\u00e4kaator Beldscher jeiht. Doh kanns De mieh dr\u00f6vver fenge op d\u00e4 Sigg: http://trac.openlayers.org/wiki/SphericalMercator.",
methodDeprecated:"Hee di Metood es nim_mih akto\u00e4ll un et weed se en d\u00e4 Version 3.0 nit mieh j\u00e4vve. Nemm <code>${newMethod}</code> dof\u00f6\u00f6r.",boundsAddError:"Do mo\u00df beeds vun de <code>x</code> un <code>y</code> W\u00e4\u00e4te aan de Fungk\u00dfjohn <code>add</code> j\u00e4vve.",lonlatAddError:"Do mo\u00df beeds <code>lon</code> un <code>lat</code> aan de Fungk\u00dfjohn <code>add</code> j\u00e4vve.",pixelAddError:"Do mo\u00df beeds <code>x</code> un <code>y</code> aan de Fungk\u00dfjohn <code>add</code> j\u00e4vve.",
unsupportedGeometryType:"De Zoot Jommetrii dom_mer nit ongersht\u00f6ze: <code>${geomType}</code>",filterEvaluateNotImplemented:'\u201e<code lang="en">evaluate</code>\u201c es f\u00f6r di Zoot Fellter nit enjereschdt.'});
OpenLayers.Lang.it={unhandledRequest:"Codice di ritorno della richiesta ${statusText}",Permalink:"Permalink",Overlays:"Overlays","Base Layer":"Livello base",readNotImplemented:"Lettura non implementata.",writeNotImplemented:"Scrittura non implementata.",noFID:"Impossibile aggiornare un elemento grafico che non abbia il FID.",errorLoadingGML:"Errore nel caricamento del file GML ${url}",browserNotSupported:"Il tuo browser non supporta il rendering vettoriale. I renderizzatore attualemnte supportati sono:\n${renderers}",
componentShouldBe:"addFeatures : il componente dovrebbe essere di tipo ${geomType}",getFeatureError:"getFeatureFromEvent chiamata su di un livello senza renderizzatore. Ci\u00f2 significa che il livello \u00e8 stato cancellato, ma non i gestori associati ad esso.",minZoomLevelError:"La propriet\u00e0 minZoomLevel \u00e8 da utilizzare solamente con livelli che abbiano FixedZoomLevels. Il fatto che questo livello wfs controlli la propriet\u00e0 minZoomLevel \u00e8 un retaggio del passato. Non possiamo comunque rimuoverla senza rompere le vecchie applicazioni che dipendono su di essa.Quindi siamo costretti a deprecarla -- minZoomLevel e sar\u00e0 rimossa dalla vesione 3.0. Si prega di utilizzare i settaggi di risoluzione min/max come descritto qui: http://trac.openlayers.org/wiki/SettingZoomLevels",
commitSuccess:"Transazione WFS: SUCCESS ${response}",commitFailed:"Transazione WFS: FAILED ${response}",googleWarning:"Il livello Google non \u00e8 riuscito a caricare correttamente.<br><br>Per evitare questo messaggio, seleziona un nuovo BaseLayer nel selettore di livelli nell'angolo in alto a destra.<br><br>Pi\u00f9 precisamente, ci\u00f2 accade perch\u00e8 la libreria Google Maps non \u00e8 stata inclusa nella pagina, oppure non contiene la corretta API key per il tuo sito.<br><br>Sviluppatori: Per aiuto su come farlo funzionare correttamente, <a href='http://trac.openlayers.org/wiki/Google' target='_blank'>clicca qui</a>",
getLayerWarning:"Il livello ${layerType} non \u00e8 riuscito a caricare correttamente.<br><br>Per evitare questo messaggio, seleziona un nuovo BaseLayer nel selettore di livelli nell'angolo in alto a destra.<br><br>Pi\u00f9 precisamente, ci\u00f2 accade perch\u00e8 la libreria ${layerLib} non \u00e8 stata inclusa nella pagina.<br><br>Sviluppatori: Per aiuto su come farlo funzionare correttamente, <a href='http://trac.openlayers.org/wiki/${layerLib}' target='_blank'>clicca qui</a>","Scale = 1 : ${scaleDenom}":"Scala = 1 : ${scaleDenom}",
layerAlreadyAdded:"Stai cercando di aggiungere il livello: ${layerName} alla mappa, ma tale livello \u00e8 gi\u00e0 stato aggiunto.",reprojectDeprecated:"Stai utilizzando l'opzione 'reproject' sul livello ${layerName}. Questa opzione \u00e8 deprecata: il suo utilizzo \u00e8 stato introdotto persupportare il disegno dei dati sopra mappe commerciali, ma tale funzionalit\u00e0 dovrebbe essere ottenuta tramite l'utilizzo della proiezione Spherical Mercator. Per maggiori informazioni consultare qui http://trac.openlayers.org/wiki/SphericalMercator.",
methodDeprecated:"Questo metodo \u00e8 stato deprecato e sar\u00e0 rimosso dalla versione 3.0. Si prega di utilizzare il metodo ${newMethod} in alternativa.",boundsAddError:"Devi specificare i valori di x e y alla funzione add.",lonlatAddError:"Devi specificare i valori di lon e lat alla funzione add.",pixelAddError:"Devi specificare i valori di x e y alla funzione add.",unsupportedGeometryType:"Tipo di geometria non supportata: ${geomType}",end:""};
OpenLayers.Format.WPSCapabilities=OpenLayers.Class(OpenLayers.Format.XML.VersionedOGC,{defaultVersion:"1.0.0",CLASS_NAME:"OpenLayers.Format.WPSCapabilities"});
OpenLayers.Format.WPSCapabilities.v1_0_0=OpenLayers.Class(OpenLayers.Format.XML,{namespaces:{ows:"http://www.opengis.net/ows/1.1",wps:"http://www.opengis.net/wps/1.0.0",xlink:"http://www.w3.org/1999/xlink"},regExes:{trimSpace:/^\s*|\s*$/g,removeSpace:/\s*/g,splitSpace:/\s+/,trimComma:/\s*,\s*/g},initialize:function(a){OpenLayers.Format.XML.prototype.initialize.apply(this,[a])},read:function(a){if(typeof a=="string")a=OpenLayers.Format.XML.prototype.read.apply(this,[a]);if(a&&a.nodeType==9)a=a.documentElement;
var b={};this.readNode(a,b);return b},readers:{wps:{Capabilities:function(a,b){this.readChildNodes(a,b)},ProcessOfferings:function(a,b){b.processOfferings={};this.readChildNodes(a,b.processOfferings)},Process:function(a,b){var c={processVersion:this.getAttributeNS(a,this.namespaces.wps,"processVersion")};this.readChildNodes(a,c);b[c.identifier]=c},Languages:function(a,b){b.languages=[];this.readChildNodes(a,b.languages)},Default:function(a,b){var c={isDefault:true};this.readChildNodes(a,c);b.push(c)},
Supported:function(a,b){var c={};this.readChildNodes(a,c);b.push(c)}},ows:OpenLayers.Format.OWSCommon.v1_1_0.prototype.readers.ows},CLASS_NAME:"OpenLayers.Format.WPSCapabilities.v1_0_0"});
OpenLayers.Control.PinchZoom=OpenLayers.Class(OpenLayers.Control,{type:OpenLayers.Control.TYPE_TOOL,containerOrigin:null,pinchOrigin:null,currentCenter:null,autoActivate:true,initialize:function(){OpenLayers.Control.prototype.initialize.apply(this,arguments);this.handler=new OpenLayers.Handler.Pinch(this,{start:this.pinchStart,move:this.pinchMove,done:this.pinchDone},this.handlerOptions)},activate:function(){var a=OpenLayers.Control.prototype.activate.apply(this,arguments);if(a){this.map.events.on({moveend:this.updateContainerOrigin,
scope:this});this.updateContainerOrigin()}return a},deactivate:function(){var a=OpenLayers.Control.prototype.deactivate.apply(this,arguments);this.map&&this.map.events&&this.map.events.un({moveend:this.updateContainerOrigin,scope:this});return a},updateContainerOrigin:function(){var a=this.map.layerContainerDiv;this.containerOrigin={x:parseInt(a.style.left,10),y:parseInt(a.style.top,10)}},pinchStart:function(a){this.currentCenter=this.pinchOrigin=a.xy},pinchMove:function(a,b){var c=b.scale,d=this.containerOrigin,
e=this.pinchOrigin,f=a.xy;this.applyTransform("translate("+Math.round(f.x-e.x+(c-1)*(d.x-e.x))+"px, "+Math.round(f.y-e.y+(c-1)*(d.y-e.y))+"px) scale("+c+")");this.currentCenter=f},applyTransform:function(a){var b=this.map.layerContainerDiv.style;b["-webkit-transform"]=a;b["-moz-transform"]=a},pinchDone:function(a,b,c){this.applyTransform("");a=this.map.getZoomForResolution(this.map.getResolution()/c.scale,true);if(a!==this.map.getZoom()||!this.currentCenter.equals(this.pinchOrigin)){b=this.map.getResolutionForZoom(a);
c=this.map.getLonLatFromPixel(this.pinchOrigin);var d=this.currentCenter,e=this.map.getSize();c.lon+=b*(e.w/2-d.x);c.lat-=b*(e.h/2-d.y);this.map.setCenter(c,a)}},CLASS_NAME:"OpenLayers.Control.PinchZoom"});
OpenLayers.Control.TouchNavigation=OpenLayers.Class(OpenLayers.Control,{dragPan:null,dragPanOptions:null,pinchZoom:null,pinchZoomOptions:null,clickHandlerOptions:null,documentDrag:false,autoActivate:true,initialize:function(){this.handlers={};OpenLayers.Control.prototype.initialize.apply(this,arguments)},destroy:function(){this.deactivate();this.dragPan&&this.dragPan.destroy();this.dragPan=null;if(this.pinchZoom){this.pinchZoom.destroy();delete this.pinchZoom}OpenLayers.Control.prototype.destroy.apply(this,
arguments)},activate:function(){if(OpenLayers.Control.prototype.activate.apply(this,arguments)){this.dragPan.activate();this.handlers.click.activate();this.pinchZoom.activate();return true}return false},deactivate:function(){if(OpenLayers.Control.prototype.deactivate.apply(this,arguments)){this.dragPan.deactivate();this.handlers.click.deactivate();this.pinchZoom.deactivate();return true}return false},draw:function(){var a={click:this.defaultClick,dblclick:this.defaultDblClick},b=OpenLayers.Util.extend({"double":true,
stopDouble:true,pixelTolerance:2},this.clickHandlerOptions);this.handlers.click=new OpenLayers.Handler.Click(this,a,b);this.dragPan=new OpenLayers.Control.DragPan(OpenLayers.Util.extend({map:this.map,documentDrag:this.documentDrag},this.dragPanOptions));this.dragPan.draw();this.pinchZoom=new OpenLayers.Control.PinchZoom(OpenLayers.Util.extend({map:this.map},this.pinchZoomOptions))},defaultClick:function(a){a.lastTouches&&a.lastTouches.length==2&&this.map.zoomOut()},defaultDblClick:function(a){this.map.setCenter(this.map.getLonLatFromViewPortPx(a.xy),
this.map.zoom+1)},CLASS_NAME:"OpenLayers.Control.TouchNavigation"});
OpenLayers.Style2=OpenLayers.Class({id:null,name:null,title:null,description:null,layerName:null,isDefault:false,rules:null,initialize:function(a){OpenLayers.Util.extend(this,a);this.id=OpenLayers.Util.createUniqueID(this.CLASS_NAME+"_")},destroy:function(){for(var a=0,b=this.rules.length;a<b;a++)this.rules[a].destroy();delete this.rules},clone:function(){var a=OpenLayers.Util.extend({},this);if(this.rules){a.rules=[];for(var b=0,c=this.rules.length;b<c;++b)a.rules.push(this.rules[b].clone())}return new OpenLayers.Style2(a)},
CLASS_NAME:"OpenLayers.Style2"});OpenLayers.Lang.fur=OpenLayers.Util.applyDefaults({Permalink:"Leam Permanent",Overlays:"Livei parsore","Base Layer":"Livel di base",browserNotSupported:"Il to sgarfad\u00f4r nol supuarte la renderizazion vetori\u00e2l. Al moment a son supuart\u00e2ts:\n${renderers}","Scale = 1 : ${scaleDenom}":"Scjale = 1 : ${scaleDenom}",W:"O",E:"E",N:"N",S:"S"});
OpenLayers.Layer.Boxes=OpenLayers.Class(OpenLayers.Layer.Markers,{initialize:function(){OpenLayers.Layer.Markers.prototype.initialize.apply(this,arguments)},drawMarker:function(a){var b=a.bounds,c=this.map.getLayerPxFromLonLat(new OpenLayers.LonLat(b.left,b.top));b=this.map.getLayerPxFromLonLat(new OpenLayers.LonLat(b.right,b.bottom));if(b==null||c==null)a.display(false);else{b=new OpenLayers.Size(Math.max(1,b.x-c.x),Math.max(1,b.y-c.y));c=a.draw(c,b);if(!a.drawn){this.div.appendChild(c);a.drawn=
true}}},removeMarker:function(a){OpenLayers.Util.removeItem(this.markers,a);a.div!=null&&a.div.parentNode==this.div&&this.div.removeChild(a.div)},CLASS_NAME:"OpenLayers.Layer.Boxes"});
OpenLayers.Format.WFSCapabilities.v1_0_0=OpenLayers.Class(OpenLayers.Format.WFSCapabilities.v1,{initialize:function(a){OpenLayers.Format.WFSCapabilities.v1.prototype.initialize.apply(this,[a])},read_cap_Service:function(a,b){var c={};this.runChildNodes(c,b);a.service=c},read_cap_Fees:function(a,b){var c=this.getChildValue(b);if(c&&c.toLowerCase()!="none")a.fees=c},read_cap_AccessConstraints:function(a,b){var c=this.getChildValue(b);if(c&&c.toLowerCase()!="none")a.accessConstraints=c},read_cap_OnlineResource:function(a,
b){var c=this.getChildValue(b);if(c&&c.toLowerCase()!="none")a.onlineResource=c},read_cap_Keywords:function(a,b){var c=this.getChildValue(b);if(c&&c.toLowerCase()!="none")a.keywords=c.split(", ")},read_cap_Capability:function(a,b){var c={};this.runChildNodes(c,b);a.capability=c},read_cap_Request:function(a,b){var c={};this.runChildNodes(c,b);a.request=c},read_cap_GetFeature:function(a,b){var c={href:{},formats:[]};this.runChildNodes(c,b);a.getfeature=c},read_cap_ResultFormat:function(a,b){for(var c=
b.childNodes,d,e=0;e<c.length;e++){d=c[e];d.nodeType==1&&a.formats.push(d.nodeName)}},read_cap_DCPType:function(a,b){this.runChildNodes(a,b)},read_cap_HTTP:function(a,b){this.runChildNodes(a.href,b)},read_cap_Get:function(a,b){a.get=b.getAttribute("onlineResource")},read_cap_Post:function(a,b){a.post=b.getAttribute("onlineResource")},read_cap_SRS:function(a,b){var c=this.getChildValue(b);if(c)a.srs=c},CLASS_NAME:"OpenLayers.Format.WFSCapabilities.v1_0_0"});
OpenLayers.Lang["en-CA"]=OpenLayers.Util.applyDefaults({},OpenLayers.Lang.en);
OpenLayers.Lang.ja=OpenLayers.Util.applyDefaults({unhandledRequest:"\u672a\u51e6\u7406\u306e\u8981\u6c42\u306f ${statusText} \u3092\u8fd4\u3057\u307e\u3059",Permalink:"\u30d1\u30fc\u30de\u30ea\u30f3\u30af",Overlays:"\u30aa\u30fc\u30d0\u30fc\u30ec\u30a4","Base Layer":"\u57fa\u5e95\u30ec\u30a4\u30e4\u30fc",readNotImplemented:"\u8aad\u307f\u8fbc\u307f\u306f\u5b9f\u88c5\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002",writeNotImplemented:"\u66f8\u304d\u8fbc\u307f\u306f\u5b9f\u88c5\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002",noFID:"FID \u306e\u306a\u3044\u5730\u7269\u306f\u66f4\u65b0\u3067\u304d\u307e\u305b\u3093\u3002",
errorLoadingGML:"GML \u30d5\u30a1\u30a4\u30eb ${url} \u306e\u8aad\u307f\u8fbc\u307f\u30a8\u30e9\u30fc",browserNotSupported:"\u3042\u306a\u305f\u306e\u30d6\u30e9\u30a6\u30b6\u306f\u30d9\u30af\u30bf\u30fc\u30b0\u30e9\u30d5\u30a3\u30c3\u30af\u30b9\u306e\u63cf\u5199\u306b\u5bfe\u5fdc\u3057\u3066\u3044\u307e\u305b\u3093\u3002\u73fe\u6642\u70b9\u3067\u5bfe\u5fdc\u3057\u3066\u3044\u308b\u30bd\u30d5\u30c8\u30a6\u30a7\u30a2\u306f\u4ee5\u4e0b\u306e\u3082\u306e\u3067\u3059\u3002\n${renderers}",componentShouldBe:"addFeatures: \u8981\u7d20\u306f ${geomType} \u3067\u3042\u308b\u3079\u304d\u3067\u3059",
getFeatureError:"getFeatureFromEvent \u304c\u30ec\u30f3\u30c0\u30e9\u30fc\u306e\u306a\u3044\u30ec\u30a4\u30e4\u30fc\u304b\u3089\u547c\u3070\u308c\u307e\u3057\u305f\u3002\u901a\u5e38\u3001\u3053\u308c\u306f\u3042\u306a\u305f\u304c\u30ec\u30a4\u30e4\u30fc\u3092\u3001\u305d\u308c\u306b\u95a2\u9023\u3065\u3051\u3089\u308c\u305f\u3044\u304f\u3064\u304b\u306e\u30cf\u30f3\u30c9\u30e9\u3092\u9664\u3044\u3066\u3001\u7834\u58ca\u3057\u3066\u3057\u307e\u3063\u305f\u3053\u3068\u3092\u610f\u5473\u3057\u307e\u3059\u3002",
minZoomLevelError:"minZoomLevel \u30d7\u30ed\u30d1\u30c6\u30a3\u306f FixedZoomLevels \u3092\u7d99\u627f\u3059\u308b\u30ec\u30a4\u30e4\u30fc\u3067\u306e\u4f7f\u7528\u306e\u307f\u3092\u60f3\u5b9a\u3057\u3066\u3044\u307e\u3059\u3002\u3053\u306e minZoomLevel \u306b\u5bfe\u3059\u308b WFS \u30ec\u30a4\u30e4\u30fc\u306e\u691c\u67fb\u306f\u6b74\u53f2\u7684\u306a\u3082\u306e\u3067\u3059\u3002\u3057\u304b\u3057\u306a\u304c\u3089\u3001\u3053\u306e\u691c\u67fb\u3092\u9664\u53bb\u3059\u308b\u3068\u305d\u308c\u306b\u4f9d\u5b58\u3059\u308b OpenLayers \u30d9\u30fc\u30b9\u306e\u30a2\u30d7\u30ea\u30b1\u30fc\u30b7\u30e7\u30f3\u3092\u7834\u58ca\u3057\u3066\u3057\u307e\u3046\u53ef\u80fd\u6027\u304c\u3042\u308a\u307e\u3059\u3002\u3088\u3063\u3066\u5ec3\u6b62\u304c\u4e88\u5b9a\u3055\u308c\u3066\u304a\u308a\u3001\u3053\u306e minZoomLevel \u691c\u67fb\u306f\u30d0\u30fc\u30b8\u30e7\u30f33.0\u3067\u9664\u53bb\u3055\u308c\u307e\u3059\u3002\u4ee3\u308f\u308a\u306b\u3001http://trac.openlayers.org/wiki/SettingZoomLevels \u3067\u89e3\u8aac\u3055\u308c\u3066\u3044\u308b\u3001\u6700\u5c0f\u304a\u3088\u3073\u6700\u5927\u89e3\u50cf\u5ea6\u8a2d\u5b9a\u3092\u4f7f\u7528\u3057\u3066\u304f\u3060\u3055\u3044\u3002",
commitSuccess:"WFS \u30c8\u30e9\u30f3\u30b6\u30af\u30b7\u30e7\u30f3: \u6210\u529f ${response}",commitFailed:"WFS \u30c8\u30e9\u30f3\u30b6\u30af\u30b7\u30e7\u30f3: \u5931\u6557 ${response}",googleWarning:"Google \u30ec\u30a4\u30e4\u30fc\u304c\u6b63\u3057\u304f\u8aad\u307f\u8fbc\u307f\u3092\u884c\u3048\u307e\u305b\u3093\u3067\u3057\u305f\u3002<br><br>\u3053\u306e\u30e1\u30c3\u30bb\u30fc\u30b8\u3092\u6d88\u3059\u306b\u306f\u3001\u53f3\u4e0a\u306e\u9685\u306b\u3042\u308b\u30ec\u30a4\u30e4\u30fc\u5207\u308a\u66ff\u3048\u90e8\u5206\u3067\u65b0\u3057\u3044\u57fa\u5e95\u30ec\u30a4\u30e4\u30fc\u3092\u9078\u3093\u3067\u304f\u3060\u3055\u3044\u3002<br><br>\u304a\u305d\u3089\u304f\u3001\u3053\u308c\u306f Google \u30de\u30c3\u30d7\u7528\u30e9\u30a4\u30d6\u30e9\u30ea\u306e\u30b9\u30af\u30ea\u30d7\u30c8\u304c\u7d44\u307f\u8fbc\u307e\u308c\u3066\u3044\u306a\u3044\u304b\u3001\u3042\u306a\u305f\u306e\u30b5\u30a4\u30c8\u306b\u5bfe\u5fdc\u3059\u308b\u6b63\u3057\u3044 API \u30ad\u30fc\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u306a\u3044\u305f\u3081\u3067\u3059\u3002<br><br>\u958b\u767a\u8005\u306e\u65b9\u3078: \u6b63\u3057\u3044\u52d5\u4f5c\u3092\u3055\u305b\u308b\u305f\u3081\u306b<a href='http://trac.openlayers.org/wiki/Google' target='_blank'>\u3053\u3061\u3089\u306e\u30a6\u30a3\u30ad</a>\u3092\u53c2\u7167\u3057\u3066\u304f\u3060\u3055\u3044\u3002",
getLayerWarning:"${layerType} \u30ec\u30a4\u30e4\u30fc\u304c\u6b63\u3057\u304f\u8aad\u307f\u8fbc\u307f\u3092\u884c\u3048\u307e\u305b\u3093\u3067\u3057\u305f\u3002<br><br>\u3053\u306e\u30e1\u30c3\u30bb\u30fc\u30b8\u3092\u6d88\u3059\u306b\u306f\u3001\u53f3\u4e0a\u306e\u9685\u306b\u3042\u308b\u30ec\u30a4\u30e4\u30fc\u5207\u308a\u66ff\u3048\u90e8\u5206\u3067\u65b0\u3057\u3044\u57fa\u5e95\u30ec\u30a4\u30e4\u30fc\u3092\u9078\u3093\u3067\u304f\u3060\u3055\u3044\u3002<br><br>\u304a\u305d\u3089\u304f\u3001\u3053\u308c\u306f ${layerLib} \u30e9\u30a4\u30d6\u30e9\u30ea\u306e\u30b9\u30af\u30ea\u30d7\u30c8\u304c\u6b63\u3057\u304f\u7d44\u307f\u8fbc\u307e\u308c\u3066\u3044\u306a\u3044\u305f\u3081\u3067\u3059\u3002<br><br>\u958b\u767a\u8005\u306e\u65b9\u3078: \u6b63\u3057\u3044\u52d5\u4f5c\u3092\u3055\u305b\u308b\u305f\u3081\u306b<a href='http://trac.openlayers.org/wiki/${layerLib}' target='_blank'>\u3053\u3061\u3089\u306e\u30a6\u30a3\u30ad</a>\u3092\u53c2\u7167\u3057\u3066\u304f\u3060\u3055\u3044\u3002",
"Scale = 1 : ${scaleDenom}":"\u7e2e\u5c3a = 1 : ${scaleDenom}",W:"\u897f",E:"\u6771",N:"\u5317",S:"\u5357",layerAlreadyAdded:"\u3042\u306a\u305f\u306f\u300c${layerName}\u300d\u3092\u5730\u56f3\u306b\u8ffd\u52a0\u3057\u3088\u3046\u3068\u8a66\u307f\u307e\u3057\u305f\u304c\u3001\u305d\u306e\u30ec\u30a4\u30e4\u30fc\u306f\u65e2\u306b\u8ffd\u52a0\u3055\u308c\u3066\u3044\u307e\u3059",reprojectDeprecated:"\u3042\u306a\u305f\u306f\u300c${layerName}\u300d\u30ec\u30a4\u30e4\u30fc\u3067 reproject \u30aa\u30d7\u30b7\u30e7\u30f3\u3092\u4f7f\u3063\u3066\u3044\u307e\u3059\u3002\u3053\u306e\u30aa\u30d7\u30b7\u30e7\u30f3\u306f\u5546\u7528\u306e\u57fa\u5e95\u5730\u56f3\u4e0a\u306b\u60c5\u5831\u3092\u8868\u793a\u3059\u308b\u76ee\u7684\u3067\u8a2d\u8a08\u3055\u308c\u307e\u3057\u305f\u304c\u3001\u73fe\u5728\u3067\u306f\u305d\u306e\u6a5f\u80fd\u306f Spherical Mercator \u30b5\u30dd\u30fc\u30c8\u3092\u5229\u7528\u3057\u3066\u5b9f\u73fe\u3055\u308c\u3066\u304a\u308a\u3001\u3053\u306e\u30aa\u30d7\u30b7\u30e7\u30f3\u306e\u4f7f\u7528\u306f\u975e\u63a8\u5968\u3067\u3059\u3002\u8ffd\u52a0\u306e\u60c5\u5831\u306f http://trac.openlayers.org/wiki/SphericalMercator \u3067\u5165\u624b\u3067\u304d\u307e\u3059\u3002",
methodDeprecated:"\u3053\u306e\u30e1\u30bd\u30c3\u30c9\u306f\u5ec3\u6b62\u304c\u4e88\u5b9a\u3055\u308c\u3066\u304a\u308a\u3001\u30d0\u30fc\u30b8\u30e7\u30f33.0\u3067\u9664\u53bb\u3055\u308c\u307e\u3059\u3002\u4ee3\u308f\u308a\u306b ${newMethod} \u3092\u4f7f\u7528\u3057\u3066\u304f\u3060\u3055\u3044\u3002",boundsAddError:"x \u3068 y \u4e21\u65b9\u306e\u5024\u3092 add \u95a2\u6570\u306b\u6e21\u3055\u306a\u3051\u308c\u3070\u306a\u308a\u307e\u305b\u3093\u3002",lonlatAddError:"lon \u3068 lat \u4e21\u65b9\u306e\u5024\u3092 add \u95a2\u6570\u306b\u6e21\u3055\u306a\u3051\u308c\u3070\u306a\u308a\u307e\u305b\u3093\u3002",
pixelAddError:"x \u3068 y \u306e\u5024\u4e21\u65b9\u3092 add \u95a2\u6570\u306b\u6e21\u3055\u306a\u3051\u308c\u3070\u306a\u308a\u307e\u305b\u3093\u3002",unsupportedGeometryType:"\u672a\u5bfe\u5fdc\u306e\u5f62\u72b6\u578b: ${geomType}",filterEvaluateNotImplemented:"\u3053\u306e\u30d5\u30a3\u30eb\u30bf\u30fc\u578b\u306b\u3064\u3044\u3066 evaluate \u306f\u5b9f\u88c5\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002"});
OpenLayers.Layer.Yahoo=OpenLayers.Class(OpenLayers.Layer.EventPane,OpenLayers.Layer.FixedZoomLevels,{MIN_ZOOM_LEVEL:0,MAX_ZOOM_LEVEL:17,RESOLUTIONS:[1.40625,0.703125,0.3515625,0.17578125,0.087890625,0.0439453125,0.02197265625,0.010986328125,0.0054931640625,0.00274658203125,0.001373291015625,6.866455078125E-4,3.4332275390625E-4,1.71661376953125E-4,8.58306884765625E-5,4.291534423828125E-5,2.145767211914062E-5,1.072883605957031E-5],type:null,wrapDateLine:true,sphericalMercator:false,initialize:function(){OpenLayers.Layer.EventPane.prototype.initialize.apply(this,
arguments);OpenLayers.Layer.FixedZoomLevels.prototype.initialize.apply(this,arguments);if(this.sphericalMercator){OpenLayers.Util.extend(this,OpenLayers.Layer.SphericalMercator);this.initMercatorParameters()}},loadMapObject:function(){try{var a=this.getMapObjectSizeFromOLSize(this.map.getSize());this.mapObject=new YMap(this.div,this.type,a);this.mapObject.disableKeyControls();this.mapObject.disableDragMap();if(!this.mapObject.moveByXY||typeof this.mapObject.moveByXY!="function")this.dragPanMapObject=
null}catch(b){}},onMapResize:function(){try{this.mapObject.resizeTo(this.getMapObjectSizeFromOLSize(this.map.getSize()))}catch(a){}},setMap:function(){OpenLayers.Layer.EventPane.prototype.setMap.apply(this,arguments);this.map.events.register("moveend",this,this.fixYahooEventPane)},fixYahooEventPane:function(){var a=OpenLayers.Util.getElement("ygddfdiv");if(a!=null){a.parentNode!=null&&a.parentNode.removeChild(a);this.map.events.unregister("moveend",this,this.fixYahooEventPane)}},getWarningHTML:function(){return OpenLayers.i18n("getLayerWarning",
{layerType:"Yahoo",layerLib:"Yahoo"})},getOLZoomFromMapObjectZoom:function(a){var b=null;if(a!=null){b=OpenLayers.Layer.FixedZoomLevels.prototype.getOLZoomFromMapObjectZoom.apply(this,[a]);b=18-b}return b},getMapObjectZoomFromOLZoom:function(a){var b=null;if(a!=null){b=OpenLayers.Layer.FixedZoomLevels.prototype.getMapObjectZoomFromOLZoom.apply(this,[a]);b=18-b}return b},setMapObjectCenter:function(a,b){this.mapObject.drawZoomAndCenter(a,b)},getMapObjectCenter:function(){return this.mapObject.getCenterLatLon()},
dragPanMapObject:function(a,b){this.mapObject.moveByXY({x:-a,y:b})},getMapObjectZoom:function(){return this.mapObject.getZoomLevel()},getMapObjectLonLatFromMapObjectPixel:function(a){return this.mapObject.convertXYLatLon(a)},getMapObjectPixelFromMapObjectLonLat:function(a){return this.mapObject.convertLatLonXY(a)},getLongitudeFromMapObjectLonLat:function(a){return this.sphericalMercator?this.forwardMercator(a.Lon,a.Lat).lon:a.Lon},getLatitudeFromMapObjectLonLat:function(a){return this.sphericalMercator?
this.forwardMercator(a.Lon,a.Lat).lat:a.Lat},getMapObjectLonLatFromLonLat:function(a,b){var c;if(this.sphericalMercator){c=this.inverseMercator(a,b);c=new YGeoPoint(c.lat,c.lon)}else c=new YGeoPoint(b,a);return c},getXFromMapObjectPixel:function(a){return a.x},getYFromMapObjectPixel:function(a){return a.y},getMapObjectPixelFromXY:function(a,b){return new YCoordPoint(a,b)},getMapObjectSizeFromOLSize:function(a){return new YSize(a.w,a.h)},CLASS_NAME:"OpenLayers.Layer.Yahoo"});
OpenLayers.Lang.nds=OpenLayers.Util.applyDefaults({unhandledRequest:"Unbehannelt Tr\u00fcchmellels f\u00f6r de Anfraag ${statusText}",Permalink:"Permalink",Overlays:"Overlays","Base Layer":"Achtergrundkoort",readNotImplemented:"Lesen is nich inricht.",writeNotImplemented:"Schrieven is nich inricht.",noFID:"En Feature, dat keen FID hett, kann nich aktuell maakt warrn.",errorLoadingGML:"Fehler bi\u2019t Laden vun de GML-Datei ${url}",browserNotSupported:"Dien Browser \u00fcnnerst\u00fctt keen Vektorbiller. \u00dcnnerst\u00fctt Renderers:\n${renderers}",
componentShouldBe:"addFeatures : Kumponent schull man den Typ ${geomType} hebben",getFeatureError:"getFeatureFromEvent is von en Laag ahn Render opropen worrn. Dat bed\u00fc\u00fcdt normalerwies, dat en Laag wegmaakt worrn is, aver nich de Handler, de dor op verwiest.",commitSuccess:"WFS-Transakschoon: hett klappt ${response}",commitFailed:"WFS-Transakschoon: hett nich klappt ${response}","Scale = 1 : ${scaleDenom}":"Skaal = 1 : ${scaleDenom}",layerAlreadyAdded:"Du vers\u00f6chst de Laag \u201e${layerName}\u201c to de Koort totof\u00f6gen, man de is al tof\u00f6\u00f6gt",
methodDeprecated:"Disse Methood is oold un schall dat in 3.0 nich mehr geven. Bruuk dor man beter ${newMethod} f\u00f6r.",boundsAddError:"De Weert x un y, de m\u00f6\u00f6t all beid an de add-Funkschoon \u00f6vergeven warrn.",lonlatAddError:"De Weert lon un lat, de m\u00f6\u00f6t all beid an de add-Funkschoon \u00f6vergeven warrn.",pixelAddError:"De Weert x un y, de m\u00f6\u00f6t all beid an de add-Funkschoon \u00f6vergeven warrn.",unsupportedGeometryType:"Nich \u00fcnnerst\u00fctt Geometrie-Typ: ${geomType}"});
OpenLayers.Layer.Zoomify=OpenLayers.Class(OpenLayers.Layer.Grid,{url:null,size:null,isBaseLayer:true,standardTileSize:256,tileOriginCorner:"tl",numberOfTiers:0,tileCountUpToTier:[],tierSizeInTiles:[],tierImageSize:[],initialize:function(a,b,c,d){this.initializeZoomify(c);var e=[];e.push(a,b,c,{},d);OpenLayers.Layer.Grid.prototype.initialize.apply(this,e)},initializeZoomify:function(a){a=a.clone();var b=new OpenLayers.Size(Math.ceil(a.w/this.standardTileSize),Math.ceil(a.h/this.standardTileSize));
this.tierSizeInTiles.push(b);for(this.tierImageSize.push(a);a.w>this.standardTileSize||a.h>this.standardTileSize;){a=new OpenLayers.Size(Math.floor(a.w/2),Math.floor(a.h/2));b=new OpenLayers.Size(Math.ceil(a.w/this.standardTileSize),Math.ceil(a.h/this.standardTileSize));this.tierSizeInTiles.push(b);this.tierImageSize.push(a)}this.tierSizeInTiles.reverse();this.tierImageSize.reverse();this.numberOfTiers=this.tierSizeInTiles.length;this.tileCountUpToTier[0]=0;for(a=1;a<this.numberOfTiers;a++)this.tileCountUpToTier.push(this.tierSizeInTiles[a-
1].w*this.tierSizeInTiles[a-1].h+this.tileCountUpToTier[a-1])},destroy:function(){OpenLayers.Layer.Grid.prototype.destroy.apply(this,arguments);this.tileCountUpToTier.length=0;this.tierSizeInTiles.length=0;this.tierImageSize.length=0},clone:function(a){if(a==null)a=new OpenLayers.Layer.Zoomify(this.name,this.url,this.size,this.options);return a=OpenLayers.Layer.Grid.prototype.clone.apply(this,[a])},getURL:function(a){a=this.adjustBounds(a);var b=this.map.getResolution(),c=Math.round((a.left-this.tileOrigin.lon)/
(b*this.tileSize.w));a=Math.round((this.tileOrigin.lat-a.top)/(b*this.tileSize.h));b=this.map.getZoom();c="TileGroup"+Math.floor((c+a*this.tierSizeInTiles[b].w+this.tileCountUpToTier[b])/256)+"/"+b+"-"+c+"-"+a+".jpg";a=this.url;if(OpenLayers.Util.isArray(a))a=this.selectUrl(c,a);return a+c},getImageSize:function(){if(arguments.length>0){var a=this.adjustBounds(arguments[0]),b=this.map.getResolution(),c=Math.round((a.left-this.tileOrigin.lon)/(b*this.tileSize.w));a=Math.round((this.tileOrigin.lat-
a.top)/(b*this.tileSize.h));b=this.map.getZoom();var d=this.standardTileSize,e=this.standardTileSize;if(c==this.tierSizeInTiles[b].w-1)d=this.tierImageSize[b].w%this.standardTileSize;if(a==this.tierSizeInTiles[b].h-1)e=this.tierImageSize[b].h%this.standardTileSize;return new OpenLayers.Size(d,e)}else return this.tileSize},setMap:function(){OpenLayers.Layer.Grid.prototype.setMap.apply(this,arguments);this.tileOrigin=new OpenLayers.LonLat(this.map.maxExtent.left,this.map.maxExtent.top)},calculateGridLayout:function(a,
b,c){var d=c*this.tileSize.w;c*=this.tileSize.h;var e=a.left-b.lon,f=Math.floor(e/d)-this.buffer;a=b.lat-a.top+c;var g=Math.floor(a/c)-this.buffer;return{tilelon:d,tilelat:c,tileoffsetlon:b.lon+f*d,tileoffsetlat:b.lat-c*g,tileoffsetx:-(e/d-f)*this.tileSize.w,tileoffsety:(g-a/c)*this.tileSize.h}},CLASS_NAME:"OpenLayers.Layer.Zoomify"});
OpenLayers.Renderer.VML=OpenLayers.Class(OpenLayers.Renderer.Elements,{xmlns:"urn:schemas-microsoft-com:vml",symbolCache:{},offset:null,initialize:function(){if(this.supported()){if(!document.namespaces.olv){document.namespaces.add("olv",this.xmlns);for(var a=document.createStyleSheet(),b=["shape","rect","oval","fill","stroke","imagedata","group","textbox"],c=0,d=b.length;c<d;c++)a.addRule("olv\\:"+b[c],"behavior: url(#default#VML); position: absolute; display: inline-block;")}OpenLayers.Renderer.Elements.prototype.initialize.apply(this,
arguments)}},supported:function(){return!!document.namespaces},setExtent:function(a,b){OpenLayers.Renderer.Elements.prototype.setExtent.apply(this,arguments);var c=this.getResolution(),d=a.left/c|0;c=a.top/c-this.size.h|0;if(b||!this.offset){this.offset={x:d,y:c};c=d=0}else{d-=this.offset.x;c-=this.offset.y}this.root.coordorigin=d+" "+c;d=[this.root,this.vectorRoot,this.textRoot];for(var e=0,f=d.length;e<f;++e){c=d[e];c.coordsize=this.size.w+" "+this.size.h}this.root.style.flip="y";return true},setSize:function(){OpenLayers.Renderer.prototype.setSize.apply(this,
arguments);for(var a=[this.rendererRoot,this.root,this.vectorRoot,this.textRoot],b=this.size.w+"px",c=this.size.h+"px",d,e=0,f=a.length;e<f;++e){d=a[e];d.style.width=b;d.style.height=c}},getNodeType:function(a,b){var c=null;switch(a.CLASS_NAME){case "OpenLayers.Geometry.Point":c=b.externalGraphic?"olv:rect":this.isComplexSymbol(b.graphicName)?"olv:shape":"olv:oval";break;case "OpenLayers.Geometry.Rectangle":c="olv:rect";break;case "OpenLayers.Geometry.LineString":case "OpenLayers.Geometry.LinearRing":case "OpenLayers.Geometry.Polygon":case "OpenLayers.Geometry.Curve":case "OpenLayers.Geometry.Surface":c=
"olv:shape"}return c},setStyle:function(a,b,c,d){b=b||a._style;c=c||a._options;var e=b.fillColor;if(a._geometryClass==="OpenLayers.Geometry.Point")if(b.externalGraphic){c.isFilled=true;if(b.graphicTitle)a.title=b.graphicTitle;e=b.graphicWidth||b.graphicHeight;var f=b.graphicHeight||b.graphicWidth;e=e?e:b.pointRadius*2;f=f?f:b.pointRadius*2;var g=this.getResolution(),h=b.graphicXOffset!=undefined?b.graphicXOffset:-(0.5*e),j=b.graphicYOffset!=undefined?b.graphicYOffset:-(0.5*f);a.style.left=(d.x/g-
this.offset.x+h|0)+"px";a.style.top=(d.y/g-this.offset.y-(j+f)|0)+"px";a.style.width=e+"px";a.style.height=f+"px";a.style.flip="y";e="none";c.isStroked=false}else if(this.isComplexSymbol(b.graphicName)){f=this.importSymbol(b.graphicName);a.path=f.path;a.coordorigin=f.left+","+f.bottom;f=f.size;a.coordsize=f+","+f;this.drawCircle(a,d,b.pointRadius);a.style.flip="y"}else this.drawCircle(a,d,b.pointRadius);if(c.isFilled)a.fillcolor=e;else a.filled="false";d=a.getElementsByTagName("fill");d=d.length==
0?null:d[0];if(c.isFilled){d||(d=this.createNode("olv:fill",a.id+"_fill"));d.opacity=b.fillOpacity;if(a._geometryClass==="OpenLayers.Geometry.Point"&&b.externalGraphic){if(b.graphicOpacity)d.opacity=b.graphicOpacity;d.src=b.externalGraphic;d.type="frame";if(!(b.graphicWidth&&b.graphicHeight))d.aspect="atmost"}d.parentNode!=a&&a.appendChild(d)}else d&&a.removeChild(d);e=b.rotation;if(e!==undefined||a._rotation!==undefined){a._rotation=e;if(b.externalGraphic){this.graphicRotate(a,h,j,b);d.opacity=0}else if(a._geometryClass===
"OpenLayers.Geometry.Point")a.style.rotation=e||0}h=a.getElementsByTagName("stroke");h=h.length==0?null:h[0];if(c.isStroked){if(!h){h=this.createNode("olv:stroke",a.id+"_stroke");a.appendChild(h)}h.on=true;h.color=b.strokeColor;h.weight=b.strokeWidth+"px";h.opacity=b.strokeOpacity;h.endcap=b.strokeLinecap=="butt"?"flat":b.strokeLinecap||"round";if(b.strokeDashstyle)h.dashstyle=this.dashStyle(b)}else{a.stroked=false;if(h)h.on=false}if(b.cursor!="inherit"&&b.cursor!=null)a.style.cursor=b.cursor;return a},
graphicRotate:function(a,b,c,d){d=d||a._style;var e=d.rotation||0,f,g;if(d.graphicWidth&&d.graphicHeight){g=Math.max(d.graphicWidth,d.graphicHeight);f=d.graphicWidth/d.graphicHeight;var h=Math.round(d.graphicWidth||g*f),j=Math.round(d.graphicHeight||g);a.style.width=h+"px";a.style.height=j+"px";var i=document.getElementById(a.id+"_image");if(!i){i=this.createNode("olv:imagedata",a.id+"_image");a.appendChild(i)}i.style.width=h+"px";i.style.height=j+"px";i.src=d.externalGraphic;i.style.filter="progid:DXImageTransform.Microsoft.AlphaImageLoader(src='', sizingMethod='scale')";
i=e*Math.PI/180;e=Math.sin(i);i=Math.cos(i);e="progid:DXImageTransform.Microsoft.Matrix(M11="+i+",M12="+-e+",M21="+e+",M22="+i+",SizingMethod='auto expand')\n";if((i=d.graphicOpacity||d.fillOpacity)&&i!=1)e+="progid:DXImageTransform.Microsoft.BasicImage(opacity="+i+")\n";a.style.filter=e;e=new OpenLayers.Geometry.Point(-b,-c);h=(new OpenLayers.Bounds(0,0,h,j)).toGeometry();h.rotate(d.rotation,e);h=h.getBounds();a.style.left=Math.round(parseInt(a.style.left)+h.left)+"px";a.style.top=Math.round(parseInt(a.style.top)-
h.bottom)+"px"}else{var k=new Image;k.onreadystatechange=OpenLayers.Function.bind(function(){if(k.readyState=="complete"||k.readyState=="interactive"){f=k.width/k.height;g=Math.max(d.pointRadius*2,d.graphicWidth||0,d.graphicHeight||0);b*=f;d.graphicWidth=g*f;d.graphicHeight=g;this.graphicRotate(a,b,c,d)}},this);k.src=d.externalGraphic}},postDraw:function(a){a.style.visibility="visible";var b=a._style.fillColor,c=a._style.strokeColor;if(b=="none"&&a.fillcolor!=b)a.fillcolor=b;if(c=="none"&&a.strokecolor!=
c)a.strokecolor=c},setNodeDimension:function(a,b){var c=b.getBounds();if(c){var d=this.getResolution();c=new OpenLayers.Bounds(c.left/d-this.offset.x|0,c.bottom/d-this.offset.y|0,c.right/d-this.offset.x|0,c.top/d-this.offset.y|0);a.style.left=c.left+"px";a.style.top=c.top+"px";a.style.width=c.getWidth()+"px";a.style.height=c.getHeight()+"px";a.coordorigin=c.left+" "+c.top;a.coordsize=c.getWidth()+" "+c.getHeight()}},dashStyle:function(a){a=a.strokeDashstyle;switch(a){case "solid":case "dot":case "dash":case "dashdot":case "longdash":case "longdashdot":return a;
default:a=a.split(/[ ,]/);if(a.length==2){if(1*a[0]>=2*a[1])return"longdash";return a[0]==1||a[1]==1?"dot":"dash"}else if(a.length==4)return 1*a[0]>=2*a[1]?"longdashdot":"dashdot";return"solid"}},createNode:function(a,b){var c=document.createElement(a);if(b)c.id=b;c.unselectable="on";c.onselectstart=OpenLayers.Function.False;return c},nodeTypeCompare:function(a,b){var c=b,d=c.indexOf(":");if(d!=-1)c=c.substr(d+1);var e=a.nodeName;d=e.indexOf(":");if(d!=-1)e=e.substr(d+1);return c==e},createRenderRoot:function(){return this.nodeFactory(this.container.id+
"_vmlRoot","div")},createRoot:function(a){return this.nodeFactory(this.container.id+a,"olv:group")},drawPoint:function(a,b){return this.drawCircle(a,b,1)},drawCircle:function(a,b,c){if(!isNaN(b.x)&&!isNaN(b.y)){var d=this.getResolution();a.style.left=(b.x/d-this.offset.x|0)-c+"px";a.style.top=(b.y/d-this.offset.y|0)-c+"px";b=c*2;a.style.width=b+"px";a.style.height=b+"px";return a}return false},drawLineString:function(a,b){return this.drawLine(a,b,false)},drawLinearRing:function(a,b){return this.drawLine(a,
b,true)},drawLine:function(a,b,c){this.setNodeDimension(a,b);for(var d=this.getResolution(),e=b.components.length,f=Array(e),g,h,j=0;j<e;j++){g=b.components[j];h=g.x/d-this.offset.x|0;g=g.y/d-this.offset.y|0;f[j]=" "+h+","+g+" l "}a.path="m"+f.join("")+(c?" x e":" e");return a},drawPolygon:function(a,b){this.setNodeDimension(a,b);var c=this.getResolution(),d=[],e,f,g,h,j,i,k,l,m,n;e=0;for(f=b.components.length;e<f;e++){d.push("m");g=b.components[e].components;h=e===0;i=j=null;k=0;for(l=g.length;k<
l;k++){m=g[k];n=m.x/c-this.offset.x|0;m=m.y/c-this.offset.y|0;n=" "+n+","+m;d.push(n);k==0&&d.push(" l");if(!h)if(j){if(j!=n)if(i){if(i!=n)h=true}else i=n}else j=n}d.push(h?" x ":" ")}d.push("e");a.path=d.join("");return a},drawRectangle:function(a,b){var c=this.getResolution();a.style.left=(b.x/c-this.offset.x|0)+"px";a.style.top=(b.y/c-this.offset.y|0)+"px";a.style.width=(b.width/c|0)+"px";a.style.height=(b.height/c|0)+"px";return a},drawText:function(a,b,c){var d=this.nodeFactory(a+this.LABEL_ID_SUFFIX,
"olv:rect"),e=this.nodeFactory(a+this.LABEL_ID_SUFFIX+"_textbox","olv:textbox"),f=this.getResolution();d.style.left=(c.x/f-this.offset.x|0)+"px";d.style.top=(c.y/f-this.offset.y|0)+"px";d.style.flip="y";e.innerText=b.label;if(b.cursor!="inherit"&&b.cursor!=null)e.style.cursor=b.cursor;if(b.fontColor)e.style.color=b.fontColor;if(b.fontOpacity)e.style.filter="alpha(opacity="+b.fontOpacity*100+")";if(b.fontFamily)e.style.fontFamily=b.fontFamily;if(b.fontSize)e.style.fontSize=b.fontSize;if(b.fontWeight)e.style.fontWeight=
b.fontWeight;if(b.fontStyle)e.style.fontStyle=b.fontStyle;if(b.labelSelect===true){d._featureId=a;e._featureId=a;e._geometry=c;e._geometryClass=c.CLASS_NAME}e.style.whiteSpace="nowrap";e.inset="1px,0px,0px,0px";if(!d.parentNode){d.appendChild(e);this.textRoot.appendChild(d)}b=b.labelAlign||"cm";if(b.length==1)b+="m";a=e.clientWidth*OpenLayers.Renderer.VML.LABEL_SHIFT[b.substr(0,1)];e=e.clientHeight*OpenLayers.Renderer.VML.LABEL_SHIFT[b.substr(1,1)];d.style.left=parseInt(d.style.left)-a-1+"px";d.style.top=
parseInt(d.style.top)+e+"px"},drawSurface:function(a,b){this.setNodeDimension(a,b);for(var c=this.getResolution(),d=[],e,f,g=0,h=b.components.length;g<h;g++){e=b.components[g];f=e.x/c-this.offset.x|0;e=e.y/c-this.offset.y|0;if(g%3==0&&g/3==0)d.push("m");else g%3==1&&d.push(" c");d.push(" "+f+","+e)}d.push(" x e");a.path=d.join("");return a},moveRoot:function(a){var b=this.map.getLayer(a.container.id);if(b instanceof OpenLayers.Layer.Vector.RootContainer)b=this.map.getLayer(this.container.id);b&&b.renderer.clear();
OpenLayers.Renderer.Elements.prototype.moveRoot.apply(this,arguments);b&&b.redraw()},importSymbol:function(a){var b=this.container.id+"-"+a,c=this.symbolCache[b];if(c)return c;c=OpenLayers.Renderer.symbol[a];if(!c)throw Error(a+" is not a valid symbol name");a=new OpenLayers.Bounds(Number.MAX_VALUE,Number.MAX_VALUE,0,0);for(var d=["m"],e=0;e<c.length;e+=2){var f=c[e],g=c[e+1];a.left=Math.min(a.left,f);a.bottom=Math.min(a.bottom,g);a.right=Math.max(a.right,f);a.top=Math.max(a.top,g);d.push(f);d.push(g);
e==0&&d.push("l")}d.push("x e");c=d.join(" ");d=(a.getWidth()-a.getHeight())/2;if(d>0){a.bottom-=d;a.top+=d}else{a.left+=d;a.right-=d}c={path:c,size:a.getWidth(),left:a.left,bottom:a.bottom};return this.symbolCache[b]=c},CLASS_NAME:"OpenLayers.Renderer.VML"});OpenLayers.Renderer.VML.LABEL_SHIFT={l:0,c:0.5,r:1,t:0,m:0.5,b:1};
OpenLayers.Lang.vi=OpenLayers.Util.applyDefaults({unhandledRequest:"Kh\u00f4ng x\u1eed l\u00fd \u0111\u01b0\u1ee3c ph\u1ea3n h\u1ed3i ${statusText} cho y\u00eau c\u1ea7u",Permalink:"Li\u00ean k\u1ebft th\u01b0\u1eddng tr\u1ef1c",Overlays:"L\u1ea5p b\u1ea3n \u0111\u1ed3","Base Layer":"L\u1edbp n\u1ec1n",readNotImplemented:"Ch\u01b0a h\u1ed7 tr\u1ee3 ch\u1ee9c n\u0103ng \u0111\u1ecdc.",writeNotImplemented:"Ch\u01b0a h\u1ed7 tr\u1ee3 ch\u1ee9c n\u0103ng vi\u1ebft.",noFID:"Kh\u00f4ng th\u1ec3 c\u1eadp nh\u1eadt t\u00ednh n\u0103ng thi\u1ebfu FID.",
errorLoadingGML:"L\u1ed7i t\u1ea3i t\u1eadp tin GML t\u1ea1i ${url}",browserNotSupported:"Tr\u00ecnh duy\u1ec7t c\u1ee7a b\u1ea1n kh\u00f4ng h\u1ed7 tr\u1ee3 ch\u1ee9c n\u0103ng v\u1ebd b\u1eb1ng vect\u01a1. Hi\u1ec7n h\u1ed7 tr\u1ee3 c\u00e1c b\u1ed9 k\u1ebft xu\u1ea5t:\n${renderers}",componentShouldBe:"addFeatures: b\u1ed9 ph\u1eadn c\u1ea7n ph\u1ea3i l\u00e0 ${geomType}",getFeatureError:"getFeatureFromEvent \u0111\u01b0\u1ee3c g\u1ecdi t\u1eeb l\u1edbp kh\u00f4ng c\u00f3 b\u1ed9 k\u1ebft xu\u1ea5t. Th\u01b0\u1eddng th\u00ec c\u00f3 l\u1ebd l\u1edbp b\u1ecb x\u00f3a nh\u01b0ng m\u1ed9t ph\u1ea7n x\u1eed l\u00fd c\u1ee7a n\u00f3 v\u1eabn c\u00f2n.",
minZoomLevelError:"Ch\u1ec9 n\u00ean s\u1eed d\u1ee5ng thu\u1ed9c t\u00ednh minZoomLevel v\u1edbi c\u00e1c l\u1edbp FixedZoomLevels-descendent. Vi\u1ec7c l\u1edbp wfs n\u00e0y t\u00ecm cho minZoomLevel l\u00e0 di t\u00edch c\u00f2n l\u1ea1i t\u1eeb x\u01b0a. Tuy nhi\u00ean, n\u1ebfu ch\u00fang t\u00f4i d\u1eddi n\u00f3 th\u00ec s\u1ebd v\u1ee1 c\u00e1c ch\u01b0\u01a1ng tr\u00ecnh OpenLayers m\u00e0 d\u1ef1a tr\u00ean n\u00f3. B\u1edfi v\u1eady ch\u00fang t\u00f4i ph\u1ea3n \u0111\u1ed1i s\u1eed d\u1ee5ng n\u00f3&nbsp;\u2013 b\u01b0\u1edbc t\u00ecm cho minZoomLevel s\u1ebd \u0111\u01b0\u1ee3c d\u1eddi v\u00e0o phi\u00ean b\u1ea3n 3.0. Xin s\u1eed d\u1ee5ng thi\u1ebft l\u1eadp \u0111\u1ed9 ph\u00e2n t\u00edch t\u1ed1i thi\u1ec3u / t\u1ed1i \u0111a thay th\u1ebf, theo h\u01b0\u1edbng d\u1eabn n\u00e0y: http://trac.openlayers.org/wiki/SettingZoomLevels",
commitSuccess:"Giao d\u1ecbch WFS: TH\u00c0NH C\u00d4NG ${response}",commitFailed:"Giao d\u1ecbch WFS: TH\u1ea4T B\u1ea0I ${response}",googleWarning:"Kh\u00f4ng th\u1ec3 t\u1ea3i l\u1edbp Google \u0111\u00fang \u0111\u1eafn.<br><br>\u0110\u1ec3 tr\u00e1nh th\u00f4ng b\u00e1o n\u00e0y l\u1ea7n sau, h\u00e3y ch\u1ecdn BaseLayer m\u1edbi d\u00f9ng \u0111i\u1ec1u khi\u1ec3n ch\u1ecdn l\u1edbp \u1edf g\u00f3c tr\u00ean ph\u1ea3i.<br><br>Ch\u1eafc script th\u01b0 vi\u1ec7n Google Maps ho\u1eb7c kh\u00f4ng \u0111\u01b0\u1ee3c bao g\u1ed3m ho\u1eb7c kh\u00f4ng ch\u1ee9a kh\u00f3a API h\u1ee3p v\u1edbi website c\u1ee7a b\u1ea1n.<br><br><a href='http://trac.openlayers.org/wiki/Google' target='_blank'>Tr\u1ee3 gi\u00fap v\u1ec1 t\u00ednh n\u0103ng n\u00e0y</a> cho ng\u01b0\u1eddi ph\u00e1t tri\u1ec3n.",
getLayerWarning:"Kh\u00f4ng th\u1ec3 t\u1ea3i l\u1edbp ${layerType} \u0111\u00fang \u0111\u1eafn.<br><br>\u0110\u1ec3 tr\u00e1nh th\u00f4ng b\u00e1o n\u00e0y l\u1ea7n sau, h\u00e3y ch\u1ecdn BaseLayer m\u1edbi d\u00f9ng \u0111i\u1ec1u khi\u1ec3n ch\u1ecdn l\u1edbp \u1edf g\u00f3c tr\u00ean ph\u1ea3i.<br><br>Ch\u1eafc script th\u01b0 vi\u1ec7n ${layerLib} kh\u00f4ng \u0111\u01b0\u1ee3c bao g\u1ed3m \u0111\u00fang ki\u1ec3u.<br><br><a href='http://trac.openlayers.org/wiki/${layerLib}' target='_blank'>Tr\u1ee3 gi\u00fap v\u1ec1 t\u00ednh n\u0103ng n\u00e0y</a> cho ng\u01b0\u1eddi ph\u00e1t tri\u1ec3n.",
"Scale = 1 : ${scaleDenom}":"T\u1ef7 l\u1ec7 = 1 : ${scaleDenom}",W:"T",E:"\u0110",N:"B",S:"N",layerAlreadyAdded:"B\u1ea1n mu\u1ed1n th\u00eam l\u1edbp ${layerName} v\u00e0o b\u1ea3n \u0111\u1ed3, nh\u01b0ng l\u1edbp n\u00e0y \u0111\u00e3 \u0111\u01b0\u1ee3c th\u00eam",reprojectDeprecated:"B\u1ea1n \u0111ang \u00e1p d\u1ee5ng ch\u1ebf \u0111\u1ed9 \u201creproject\u201d v\u00e0o l\u1edbp ${layerName}. Ch\u1ebf \u0111\u1ed9 n\u00e0y \u0111\u00e3 b\u1ecb ph\u1ea3n \u0111\u1ed1i: n\u00f3 c\u00f3 m\u1ee5c \u0111\u00edch h\u1ed7 tr\u1ee3 l\u1ea5p d\u1eef li\u1ec7u tr\u00ean c\u00e1c n\u1ec1n b\u1ea3n \u0111\u1ed3 th\u01b0\u01a1ng m\u1ea1i; n\u00ean th\u1ef1c hi\u1ec7n hi\u1ec7u \u1ee9ng \u0111\u00f3 d\u00f9ng t\u00ednh n\u0103ng Mercator H\u00ecnh c\u1ea7u. C\u00f3 s\u1eb5n th\u00eam chi ti\u1ebft t\u1ea1i http://trac.openlayers.org/wiki/SphericalMercator .",
methodDeprecated:"Ph\u01b0\u01a1ng th\u1ee9c n\u00e0y \u0111\u00e3 b\u1ecb ph\u1ea3n \u0111\u1ed1i v\u00e0 s\u1ebd b\u1ecb d\u1eddi v\u00e0o phi\u00ean b\u1ea3n 3.0. Xin h\u00e3y s\u1eed d\u1ee5ng ${newMethod} thay th\u1ebf.",boundsAddError:"C\u1ea7n ph\u1ea3i cho c\u1ea3 gi\u00e1 tr\u1ecb x v\u00e0 y v\u00e0o h\u00e0m add.",lonlatAddError:"C\u1ea7n ph\u1ea3i cho c\u1ea3 gi\u00e1 tr\u1ecb lon v\u00e0 lat v\u00e0o h\u00e0m add.",pixelAddError:"C\u1ea7n ph\u1ea3i cho c\u1ea3 gi\u00e1 tr\u1ecb x v\u00e0 y v\u00e0o h\u00e0m add.",
unsupportedGeometryType:"Kh\u00f4ng h\u1ed7 tr\u1ee3 ki\u1ec3u \u0111\u1ecba l\u00fd: ${geomType}",filterEvaluateNotImplemented:"ch\u01b0a h\u1ed7 tr\u1ee3 evaluate cho lo\u1ea1i b\u1ed9 l\u1ecdc n\u00e0y."});
OpenLayers.Control.MouseToolbar=OpenLayers.Class(OpenLayers.Control.MouseDefaults,{mode:null,buttons:null,direction:"vertical",buttonClicked:null,initialize:function(a,b){OpenLayers.Control.prototype.initialize.apply(this,arguments);this.position=new OpenLayers.Pixel(OpenLayers.Control.MouseToolbar.X,OpenLayers.Control.MouseToolbar.Y);if(a)this.position=a;if(b)this.direction=b;this.measureDivs=[]},destroy:function(){for(var a in this.buttons){var b=this.buttons[a];b.map=null;b.events.destroy()}OpenLayers.Control.MouseDefaults.prototype.destroy.apply(this,
arguments)},draw:function(){OpenLayers.Control.prototype.draw.apply(this,arguments);OpenLayers.Control.MouseDefaults.prototype.draw.apply(this,arguments);this.buttons={};var a=new OpenLayers.Size(28,28),b=new OpenLayers.Pixel(OpenLayers.Control.MouseToolbar.X,0);this._addButton("zoombox","drag-rectangle-off.png","drag-rectangle-on.png",b,a,"Shift->Drag to zoom to area");b=b.add(this.direction=="vertical"?0:a.w,this.direction=="vertical"?a.h:0);this._addButton("pan","panning-hand-off.png","panning-hand-on.png",
b,a,"Drag the map to pan.");b.add(this.direction=="vertical"?0:a.w,this.direction=="vertical"?a.h:0);this.switchModeTo("pan");return this.div},_addButton:function(a,b,c,d,e,f){b=OpenLayers.Util.getImagesLocation()+b;c=OpenLayers.Util.getImagesLocation()+c;d=OpenLayers.Util.createAlphaImageDiv("OpenLayers_Control_MouseToolbar_"+a,d,e,b,"absolute");this.div.appendChild(d);d.imgLocation=b;d.activeImgLocation=c;d.events=new OpenLayers.Events(this,d,null,true);d.events.on({mousedown:this.buttonDown,mouseup:this.buttonUp,
dblclick:OpenLayers.Event.stop,scope:this});d.action=a;d.title=f;d.alt=f;d.map=this.map;return this.buttons[a]=d},buttonDown:function(a){if(OpenLayers.Event.isLeftClick(a)){this.buttonClicked=a.element.action;OpenLayers.Event.stop(a)}},buttonUp:function(a){if(OpenLayers.Event.isLeftClick(a))if(this.buttonClicked!=null){this.buttonClicked==a.element.action&&this.switchModeTo(a.element.action);OpenLayers.Event.stop(a);this.buttonClicked=null}},defaultDblClick:function(a){this.switchModeTo("pan");this.performedDrag=
false;this.map.setCenter(this.map.getLonLatFromViewPortPx(a.xy),this.map.zoom+1);OpenLayers.Event.stop(a);return false},defaultMouseDown:function(a){if(OpenLayers.Event.isLeftClick(a)){this.mouseDragStart=a.xy.clone();this.startViaKeyboard=this.performedDrag=false;if(a.shiftKey&&this.mode!="zoombox"){this.switchModeTo("zoombox");this.startViaKeyboard=true}else if(a.altKey&&this.mode!="measure")this.switchModeTo("measure");else this.mode||this.switchModeTo("pan");switch(this.mode){case "zoombox":this.map.div.style.cursor=
"crosshair";this.zoomBox=OpenLayers.Util.createDiv("zoomBox",this.mouseDragStart,null,null,"absolute","2px solid red");this.zoomBox.style.backgroundColor="white";this.zoomBox.style.filter="alpha(opacity=50)";this.zoomBox.style.opacity="0.50";this.zoomBox.style.fontSize="1px";this.zoomBox.style.zIndex=this.map.Z_INDEX_BASE.Popup-1;this.map.eventsDiv.appendChild(this.zoomBox);this.performedDrag=true;break;case "measure":var b="";if(this.measureStart){b=this.map.getLonLatFromViewPortPx(this.mouseDragStart);
b=OpenLayers.Util.distVincenty(this.measureStart,b);b=Math.round(b*100)/100;b+="km";this.measureStartBox=this.measureBox}this.measureStart=this.map.getLonLatFromViewPortPx(this.mouseDragStart);this.measureBox=OpenLayers.Util.createDiv(null,this.mouseDragStart.add(-2-parseInt(this.map.layerContainerDiv.style.left),-2-parseInt(this.map.layerContainerDiv.style.top)),null,null,"absolute");this.measureBox.style.width="4px";this.measureBox.style.height="4px";this.measureBox.style.fontSize="1px";this.measureBox.style.backgroundColor=
"red";this.measureBox.style.zIndex=this.map.Z_INDEX_BASE.Popup-1;this.map.layerContainerDiv.appendChild(this.measureBox);if(b){this.measureBoxDistance=OpenLayers.Util.createDiv(null,this.mouseDragStart.add(-2-parseInt(this.map.layerContainerDiv.style.left),2-parseInt(this.map.layerContainerDiv.style.top)),null,null,"absolute");this.measureBoxDistance.innerHTML=b;this.measureBoxDistance.style.zIndex=this.map.Z_INDEX_BASE.Popup-1;this.map.layerContainerDiv.appendChild(this.measureBoxDistance);this.measureDivs.push(this.measureBoxDistance)}this.measureBox.style.zIndex=
this.map.Z_INDEX_BASE.Popup-1;this.map.layerContainerDiv.appendChild(this.measureBox);this.measureDivs.push(this.measureBox);break;default:this.map.div.style.cursor="move"}document.onselectstart=OpenLayers.Function.False;OpenLayers.Event.stop(a)}},switchModeTo:function(a){if(a!=this.mode){this.mode&&this.buttons[this.mode]&&OpenLayers.Util.modifyAlphaImageDiv(this.buttons[this.mode],null,null,null,this.buttons[this.mode].imgLocation);if(this.mode=="measure"&&a!="measure"){for(var b=0,c=this.measureDivs.length;b<
c;b++)this.measureDivs[b]&&this.map.layerContainerDiv.removeChild(this.measureDivs[b]);this.measureDivs=[];this.measureStart=null}this.mode=a;this.buttons[a]&&OpenLayers.Util.modifyAlphaImageDiv(this.buttons[a],null,null,null,this.buttons[a].activeImgLocation);switch(this.mode){case "zoombox":this.map.div.style.cursor="crosshair";break;default:this.map.div.style.cursor=""}}},leaveMode:function(){this.switchModeTo("pan")},defaultMouseMove:function(a){if(this.mouseDragStart!=null){switch(this.mode){case "zoombox":var b=
Math.abs(this.mouseDragStart.x-a.xy.x),c=Math.abs(this.mouseDragStart.y-a.xy.y);this.zoomBox.style.width=Math.max(1,b)+"px";this.zoomBox.style.height=Math.max(1,c)+"px";if(a.xy.x<this.mouseDragStart.x)this.zoomBox.style.left=a.xy.x+"px";if(a.xy.y<this.mouseDragStart.y)this.zoomBox.style.top=a.xy.y+"px";break;default:b=this.mouseDragStart.x-a.xy.x;c=this.mouseDragStart.y-a.xy.y;var d=this.map.getSize();this.map.setCenter(this.map.getLonLatFromViewPortPx(new OpenLayers.Pixel(d.w/2+b,d.h/2+c)),null,
true);this.mouseDragStart=a.xy.clone()}this.performedDrag=true}},defaultMouseUp:function(a){if(OpenLayers.Event.isLeftClick(a)){switch(this.mode){case "zoombox":this.zoomBoxEnd(a);this.startViaKeyboard&&this.leaveMode();break;case "pan":this.performedDrag&&this.map.setCenter(this.map.center)}this.mouseDragStart=document.onselectstart=null;this.map.div.style.cursor="default"}},defaultMouseOut:function(a){if(this.mouseDragStart!=null&&OpenLayers.Util.mouseLeft(a,this.map.eventsDiv)){if(this.zoomBox){this.removeZoomBox();
this.startViaKeyboard&&this.leaveMode()}this.mouseDragStart=null;this.map.div.style.cursor="default"}},defaultClick:function(){if(this.performedDrag)return this.performedDrag=false},CLASS_NAME:"OpenLayers.Control.MouseToolbar"});OpenLayers.Control.MouseToolbar.X=6;OpenLayers.Control.MouseToolbar.Y=300;
OpenLayers.Lang.km=OpenLayers.Util.applyDefaults({Permalink:"\u178f\u17c6\u178e\u1797\u17d2\u1787\u17b6\u1794\u17cb\u17a2\u1785\u17b7\u1793\u17d2\u178f\u17d2\u179a\u17c3\u1799\u17cd","Base Layer":"\u179f\u17d2\u179a\u1791\u17b6\u1794\u17cb\u1794\u17b6\u178f\u200b",errorLoadingGML:"\u1780\u17c6\u17a0\u17bb\u179f\u1780\u17c6\u17a1\u17bb\u1784\u1796\u17c1\u179b\u1795\u17d2\u1791\u17bb\u1780\u17af\u1780\u179f\u17b6\u179a GML ${url}","Scale = 1 : ${scaleDenom}":"\u1798\u17b6\u178f\u17d2\u179a\u178a\u17d2\u178b\u17b6\u1793 = \u17e1 \u17d6 ${scaleDenom}"});
OpenLayers.Format.WFST.v1_0_0=OpenLayers.Class(OpenLayers.Format.Filter.v1_0_0,OpenLayers.Format.WFST.v1,{version:"1.0.0",srsNameInQuery:false,schemaLocations:{wfs:"http://schemas.opengis.net/wfs/1.0.0/WFS-transaction.xsd"},initialize:function(a){OpenLayers.Format.Filter.v1_0_0.prototype.initialize.apply(this,[a]);OpenLayers.Format.WFST.v1.prototype.initialize.apply(this,[a])},readNode:function(a,b){return OpenLayers.Format.GML.v2.prototype.readNode.apply(this,[a,b])},readers:{wfs:OpenLayers.Util.applyDefaults({WFS_TransactionResponse:function(a,
b){b.insertIds=[];b.success=false;this.readChildNodes(a,b)},InsertResult:function(a,b){var c={fids:[]};this.readChildNodes(a,c);b.insertIds.push(c.fids[0])},TransactionResult:function(a,b){this.readChildNodes(a,b)},Status:function(a,b){this.readChildNodes(a,b)},SUCCESS:function(a,b){b.success=true}},OpenLayers.Format.WFST.v1.prototype.readers.wfs),gml:OpenLayers.Format.GML.v2.prototype.readers.gml,feature:OpenLayers.Format.GML.v2.prototype.readers.feature,ogc:OpenLayers.Format.Filter.v1_0_0.prototype.readers.ogc},
writers:{wfs:OpenLayers.Util.applyDefaults({Query:function(a){a=OpenLayers.Util.extend({featureNS:this.featureNS,featurePrefix:this.featurePrefix,featureType:this.featureType,srsName:this.srsName,srsNameInQuery:this.srsNameInQuery},a);var b=a.featurePrefix,c=this.createElementNSPlus("wfs:Query",{attributes:{typeName:(b?b+":":"")+a.featureType}});a.srsNameInQuery&&a.srsName&&c.setAttribute("srsName",a.srsName);a.featureNS&&c.setAttribute("xmlns:"+b,a.featureNS);if(a.propertyNames){b=0;for(var d=a.propertyNames.length;b<
d;b++)this.writeNode("ogc:PropertyName",{property:a.propertyNames[b]},c)}if(a.filter){this.setFilterProperty(a.filter);this.writeNode("ogc:Filter",a.filter,c)}return c}},OpenLayers.Format.WFST.v1.prototype.writers.wfs),gml:OpenLayers.Format.GML.v2.prototype.writers.gml,feature:OpenLayers.Format.GML.v2.prototype.writers.feature,ogc:OpenLayers.Format.Filter.v1_0_0.prototype.writers.ogc},CLASS_NAME:"OpenLayers.Format.WFST.v1_0_0"});
OpenLayers.Protocol.WFS.v1_0_0=OpenLayers.Class(OpenLayers.Protocol.WFS.v1,{version:"1.0.0",CLASS_NAME:"OpenLayers.Protocol.WFS.v1_0_0"});
OpenLayers.Format.WMSGetFeatureInfo=OpenLayers.Class(OpenLayers.Format.XML,{layerIdentifier:"_layer",featureIdentifier:"_feature",regExes:{trimSpace:/^\s*|\s*$/g,removeSpace:/\s*/g,splitSpace:/\s+/,trimComma:/\s*,\s*/g},gmlFormat:null,read:function(a){if(typeof a=="string")a=OpenLayers.Format.XML.prototype.read.apply(this,[a]);var b=a.documentElement;if(b){var c=this["read_"+b.nodeName];a=c?c.call(this,b):(new OpenLayers.Format.GML(this.options?this.options:{})).read(a)}return a},read_msGMLOutput:function(a){var b=
[];if(a=this.getSiblingNodesByTagCriteria(a,this.layerIdentifier))for(var c=0,d=a.length;c<d;++c){var e=a[c],f=e.nodeName;if(e.prefix)f=f.split(":")[1];f=f.replace(this.layerIdentifier,"");if(e=this.getSiblingNodesByTagCriteria(e,this.featureIdentifier))for(var g=0;g<e.length;g++){var h=e[g],j=this.parseGeometry(h);h=this.parseAttributes(h);h=new OpenLayers.Feature.Vector(j.geometry,h,null);h.bounds=j.bounds;h.type=f;b.push(h)}}return b},read_FeatureInfoResponse:function(a){var b=[];a=this.getElementsByTagNameNS(a,
"*","FIELDS");for(var c=0,d=a.length;c<d;c++){var e=a[c],f={},g,h=e.attributes.length;if(h>0)for(g=0;g<h;g++){var j=e.attributes[g];f[j.nodeName]=j.nodeValue}else{e=e.childNodes;g=0;for(h=e.length;g<h;++g){j=e[g];if(j.nodeType!=3)f[j.getAttribute("name")]=j.getAttribute("value")}}b.push(new OpenLayers.Feature.Vector(null,f,null))}return b},getSiblingNodesByTagCriteria:function(a,b){var c=[],d,e,f,g;if(a&&a.hasChildNodes()){d=a.childNodes;f=d.length;for(var h=0;h<f;h++){for(g=d[h];g&&g.nodeType!=1;){g=
g.nextSibling;h++}e=g?g.nodeName:"";if(e.length>0&&e.indexOf(b)>-1)c.push(g);else{e=this.getSiblingNodesByTagCriteria(g,b);if(e.length>0)c.length==0?c=e:c.push(e)}}}return c},parseAttributes:function(a){var b={};if(a.nodeType==1){a=a.childNodes;for(var c=a.length,d=0;d<c;++d){var e=a[d];if(e.nodeType==1){var f=e.childNodes;e=e.prefix?e.nodeName.split(":")[1]:e.nodeName;if(f.length==0)b[e]=null;else if(f.length==1){f=f[0];if(f.nodeType==3||f.nodeType==4){f=f.nodeValue.replace(this.regExes.trimSpace,
"");b[e]=f}}}}}return b},parseGeometry:function(a){if(!this.gmlFormat)this.gmlFormat=new OpenLayers.Format.GML;a=this.gmlFormat.parseFeature(a);var b,c=null;if(a){b=a.geometry&&a.geometry.clone();c=a.bounds&&a.bounds.clone();a.destroy()}return{geometry:b,bounds:c}},CLASS_NAME:"OpenLayers.Format.WMSGetFeatureInfo"});
OpenLayers.Control.WMTSGetFeatureInfo=OpenLayers.Class(OpenLayers.Control,{hover:false,requestEncoding:"KVP",drillDown:false,maxFeatures:10,clickCallback:"click",layers:null,queryVisible:true,infoFormat:"text/html",vendorParams:{},format:null,formatOptions:null,handlerOptions:null,handler:null,hoverRequest:null,EVENT_TYPES:["beforegetfeatureinfo","getfeatureinfo","exception"],pending:0,initialize:function(a){this.EVENT_TYPES=OpenLayers.Control.WMTSGetFeatureInfo.prototype.EVENT_TYPES.concat(OpenLayers.Control.prototype.EVENT_TYPES);
a=a||{};a.handlerOptions=a.handlerOptions||{};OpenLayers.Control.prototype.initialize.apply(this,[a]);if(!this.format)this.format=new OpenLayers.Format.WMSGetFeatureInfo(a.formatOptions);if(this.drillDown===true)this.hover=false;if(this.hover)this.handler=new OpenLayers.Handler.Hover(this,{move:this.cancelHover,pause:this.getInfoForHover},OpenLayers.Util.extend(this.handlerOptions.hover||{},{delay:250}));else{a={};a[this.clickCallback]=this.getInfoForClick;this.handler=new OpenLayers.Handler.Click(this,
a,this.handlerOptions.click||{})}},getInfoForClick:function(a){this.request(a.xy,{})},getInfoForHover:function(a){this.request(a.xy,{hover:true})},cancelHover:function(){if(this.hoverRequest){--this.pending;if(this.pending<=0){OpenLayers.Element.removeClass(this.map.viewPortDiv,"olCursorWait");this.pending=0}this.hoverRequest.abort();this.hoverRequest=null}},findLayers:function(){for(var a=this.layers||this.map.layers,b=[],c,d=a.length-1;d>=0;--d){c=a[d];if(c instanceof OpenLayers.Layer.WMTS&&c.requestEncoding===
this.requestEncoding&&(!this.queryVisible||c.getVisibility())){b.push(c);if(!this.drillDown||this.hover)break}}return b},buildRequestOptions:function(a,b){var c=this.map.getLonLatFromPixel(b),d=a.getURL(new OpenLayers.Bounds(c.lon,c.lat,c.lon,c.lat));d=OpenLayers.Util.getParameters(d);c=a.getTileInfo(c);OpenLayers.Util.extend(d,{service:"WMTS",version:a.version,request:"GetFeatureInfo",infoFormat:this.infoFormat,i:c.i,j:c.j});OpenLayers.Util.applyDefaults(d,this.vendorParams);return{url:OpenLayers.Util.isArray(a.url)?
a.url[0]:a.url,params:OpenLayers.Util.upperCaseObject(d),callback:function(e){this.handleResponse(b,e,a)},scope:this}},request:function(a,b){b=b||{};var c=this.findLayers();if(c.length>0){for(var d,e,f=0,g=c.length;f<g;f++){e=c[f];d=this.events.triggerEvent("beforegetfeatureinfo",{xy:a,layer:e});if(d!==false){++this.pending;d=this.buildRequestOptions(e,a);d=OpenLayers.Request.GET(d);if(b.hover===true)this.hoverRequest=d}}this.pending>0&&OpenLayers.Element.addClass(this.map.viewPortDiv,"olCursorWait")}},
handleResponse:function(a,b,c){--this.pending;if(this.pending<=0){OpenLayers.Element.removeClass(this.map.viewPortDiv,"olCursorWait");this.pending=0}if(b.status&&(b.status<200||b.status>=300))this.events.triggerEvent("exception",{xy:a,request:b,layer:c});else{var d=b.responseXML;if(!d||!d.documentElement)d=b.responseText;var e,f;try{e=this.format.read(d)}catch(g){f=true;this.events.triggerEvent("exception",{xy:a,request:b,error:g,layer:c})}f||this.events.triggerEvent("getfeatureinfo",{text:b.responseText,
features:e,request:b,xy:a,layer:c})}},CLASS_NAME:"OpenLayers.Control.WMTSGetFeatureInfo"});
OpenLayers.Lang.bg=OpenLayers.Util.applyDefaults({Permalink:"\u041f\u043e\u0441\u0442\u043e\u044f\u043d\u043d\u0430 \u043f\u0440\u0435\u043f\u0440\u0430\u0442\u043a\u0430","Base Layer":"\u041e\u0441\u043d\u043e\u0432\u0435\u043d \u0441\u043b\u043e\u0439",errorLoadingGML:"\u0413\u0440\u0435\u0448\u043a\u0430 \u043f\u0440\u0438 \u0437\u0430\u0440\u0435\u0436\u0434\u0430\u043d\u0435 \u043d\u0430 GML \u0444\u0430\u0439\u043b ${url}","Scale = 1 : ${scaleDenom}":"\u041c\u0430\u0449\u0430\u0431 = 1 : ${scaleDenom}",
layerAlreadyAdded:"\u041e\u043f\u0438\u0442\u0430\u0445\u0442\u0435 \u0434\u0430 \u0434\u043e\u0431\u0430\u0432\u0438\u0442\u0435 \u0441\u043b\u043e\u0439 ${layerName} \u0432 \u043a\u0430\u0440\u0442\u0430\u0442\u0430, \u043d\u043e \u0442\u043e\u0439 \u0432\u0435\u0447\u0435 \u0435 \u0434\u043e\u0431\u0430\u0432\u0435\u043d",methodDeprecated:"\u0422\u043e\u0437\u0438 \u043c\u0435\u0442\u043e\u0434 \u0435 \u043e\u0441\u0442\u0430\u0440\u044f\u043b \u0438 \u0449\u0435 \u0431\u044a\u0434\u0435 \u043f\u0440\u0435\u043c\u0430\u0445\u0432\u0430\u0442 \u0432 3.0. \u0412\u043c\u0435\u0441\u0442\u043e \u043d\u0435\u0433\u043e \u0438\u0437\u043f\u043e\u043b\u0437\u0432\u0430\u0439\u0442\u0435 ${newMethod}."});
OpenLayers.Format.WMSCapabilities.v1_1=OpenLayers.Class(OpenLayers.Format.WMSCapabilities.v1,{readers:{wms:OpenLayers.Util.applyDefaults({WMT_MS_Capabilities:function(a,b){this.readChildNodes(a,b)},Keyword:function(a,b){b.keywords&&b.keywords.push(this.getChildValue(a))},DescribeLayer:function(a,b){b.describelayer={formats:[]};this.readChildNodes(a,b.describelayer)},GetLegendGraphic:function(a,b){b.getlegendgraphic={formats:[]};this.readChildNodes(a,b.getlegendgraphic)},GetStyles:function(a,b){b.getstyles=
{formats:[]};this.readChildNodes(a,b.getstyles)},PutStyles:function(a,b){b.putstyles={formats:[]};this.readChildNodes(a,b.putstyles)},UserDefinedSymbolization:function(a,b){var c={supportSLD:parseInt(a.getAttribute("SupportSLD"))==1,userLayer:parseInt(a.getAttribute("UserLayer"))==1,userStyle:parseInt(a.getAttribute("UserStyle"))==1,remoteWFS:parseInt(a.getAttribute("RemoteWFS"))==1};b.userSymbols=c},LatLonBoundingBox:function(a,b){b.llbbox=[parseFloat(a.getAttribute("minx")),parseFloat(a.getAttribute("miny")),
parseFloat(a.getAttribute("maxx")),parseFloat(a.getAttribute("maxy"))]},BoundingBox:function(a,b){var c=OpenLayers.Format.WMSCapabilities.v1.prototype.readers.wms.BoundingBox.apply(this,[a,b]);c.srs=a.getAttribute("SRS");b.bbox[c.srs]=c},ScaleHint:function(a,b){var c=a.getAttribute("min"),d=a.getAttribute("max"),e=Math.pow(2,0.5),f=OpenLayers.INCHES_PER_UNIT.m;b.maxScale=parseFloat((c/e*f*OpenLayers.DOTS_PER_INCH).toPrecision(13));b.minScale=parseFloat((d/e*f*OpenLayers.DOTS_PER_INCH).toPrecision(13))},
Dimension:function(a,b){var c={name:a.getAttribute("name").toLowerCase(),units:a.getAttribute("units"),unitsymbol:a.getAttribute("unitSymbol")};b.dimensions[c.name]=c},Extent:function(a,b){var c=a.getAttribute("name").toLowerCase();if(c in b.dimensions){c=b.dimensions[c];c.nearestVal=a.getAttribute("nearestValue")==="1";c.multipleVal=a.getAttribute("multipleValues")==="1";c.current=a.getAttribute("current")==="1";c["default"]=a.getAttribute("default")||"";var d=this.getChildValue(a);c.values=d.split(",")}}},
OpenLayers.Format.WMSCapabilities.v1.prototype.readers.wms)},CLASS_NAME:"OpenLayers.Format.WMSCapabilities.v1_1"});
OpenLayers.Control.Graticule=OpenLayers.Class(OpenLayers.Control,{autoActivate:true,intervals:[45,30,20,10,5,2,1,0.5,0.2,0.1,0.05,0.01,0.005,0.002,0.001],displayInLayerSwitcher:true,visible:true,numPoints:50,targetSize:200,layerName:null,labelled:true,labelFormat:"dm",lineSymbolizer:{strokeColor:"#333",strokeWidth:1,strokeOpacity:0.5},labelSymbolizer:{},gratLayer:null,initialize:function(a){a=a||{};a.layerName=a.layerName||OpenLayers.i18n("Graticule");OpenLayers.Control.prototype.initialize.apply(this,
[a]);this.labelSymbolizer.stroke=false;this.labelSymbolizer.fill=false;this.labelSymbolizer.label="${label}";this.labelSymbolizer.labelAlign="${labelAlign}";this.labelSymbolizer.labelXOffset="${xOffset}";this.labelSymbolizer.labelYOffset="${yOffset}"},destroy:function(){this.deactivate();OpenLayers.Control.prototype.destroy.apply(this,arguments);if(this.gratLayer){this.gratLayer.destroy();this.gratLayer=null}},draw:function(){OpenLayers.Control.prototype.draw.apply(this,arguments);if(!this.gratLayer){var a=
new OpenLayers.Style({},{rules:[new OpenLayers.Rule({symbolizer:{Point:this.labelSymbolizer,Line:this.lineSymbolizer}})]});this.gratLayer=new OpenLayers.Layer.Vector(this.layerName,{styleMap:new OpenLayers.StyleMap({"default":a}),visibility:this.visible,displayInLayerSwitcher:this.displayInLayerSwitcher})}return this.div},activate:function(){if(OpenLayers.Control.prototype.activate.apply(this,arguments)){this.map.addLayer(this.gratLayer);this.map.events.register("moveend",this,this.update);this.update();
return true}else return false},deactivate:function(){if(OpenLayers.Control.prototype.deactivate.apply(this,arguments)){this.map.events.unregister("moveend",this,this.update);this.map.removeLayer(this.gratLayer);return true}else return false},update:function(){var a=this.map.getExtent();if(a){this.gratLayer.destroyFeatures();var b=new OpenLayers.Projection("EPSG:4326"),c=this.map.getProjectionObject(),d=this.map.getResolution();if(c.proj&&c.proj.projName=="longlat")this.numPoints=1;var e=this.map.getCenter(),
f=new OpenLayers.Pixel(e.lon,e.lat);OpenLayers.Projection.transform(f,c,b);e=this.targetSize*d;e*=e;var g;for(d=0;d<this.intervals.length;++d){g=this.intervals[d];var h=g/2,j=f.offset(new OpenLayers.Pixel(-h,-h));h=f.offset(new OpenLayers.Pixel(h,h));OpenLayers.Projection.transform(j,b,c);OpenLayers.Projection.transform(h,b,c);if((j.x-h.x)*(j.x-h.x)+(j.y-h.y)*(j.y-h.y)<=e)break}f.x=Math.floor(f.x/g)*g;f.y=Math.floor(f.y/g)*g;d=0;e=[f.clone()];h=f.clone();var i;do{h=h.offset(new OpenLayers.Pixel(0,
g));i=OpenLayers.Projection.transform(h.clone(),b,c);e.unshift(h)}while(a.containsPixel(i)&&++d<1E3);h=f.clone();do{h=h.offset(new OpenLayers.Pixel(0,-g));i=OpenLayers.Projection.transform(h.clone(),b,c);e.push(h)}while(a.containsPixel(i)&&++d<1E3);d=0;j=[f.clone()];h=f.clone();do{h=h.offset(new OpenLayers.Pixel(-g,0));i=OpenLayers.Projection.transform(h.clone(),b,c);j.unshift(h)}while(a.containsPixel(i)&&++d<1E3);h=f.clone();do{h=h.offset(new OpenLayers.Pixel(g,0));i=OpenLayers.Projection.transform(h.clone(),
b,c);j.push(h)}while(a.containsPixel(i)&&++d<1E3);g=[];for(d=0;d<j.length;++d){i=j[d].x;f=[];var k=null;h=Math.max(e[e.length-1].y,-90);var l=(Math.min(e[0].y,90)-h)/this.numPoints,m=h;for(h=0;h<=this.numPoints;++h){var n=new OpenLayers.Geometry.Point(i,m);n.transform(b,c);f.push(n);m+=l;if(n.y>=a.bottom&&!k)k=n}if(this.labelled){k=new OpenLayers.Geometry.Point(k.x,a.bottom);i={value:i,label:this.labelled?OpenLayers.Util.getFormattedLonLat(i,"lon",this.labelFormat):"",labelAlign:"cb",xOffset:0,yOffset:2};
this.gratLayer.addFeatures(new OpenLayers.Feature.Vector(k,i))}f=new OpenLayers.Geometry.LineString(f);g.push(new OpenLayers.Feature.Vector(f))}for(h=0;h<e.length;++h){m=e[h].y;if(!(m<-90||m>90)){f=[];d=j[0].x;l=(j[j.length-1].x-d)/this.numPoints;i=d;k=null;for(d=0;d<=this.numPoints;++d){n=new OpenLayers.Geometry.Point(i,m);n.transform(b,c);f.push(n);i+=l;if(n.x<a.right)k=n}if(this.labelled){k=new OpenLayers.Geometry.Point(a.right,k.y);i={value:m,label:this.labelled?OpenLayers.Util.getFormattedLonLat(m,
"lat",this.labelFormat):"",labelAlign:"rb",xOffset:-2,yOffset:2};this.gratLayer.addFeatures(new OpenLayers.Feature.Vector(k,i))}f=new OpenLayers.Geometry.LineString(f);g.push(new OpenLayers.Feature.Vector(f))}}this.gratLayer.addFeatures(g)}},CLASS_NAME:"OpenLayers.Control.Graticule"});
OpenLayers.Lang.hr=OpenLayers.Util.applyDefaults({unhandledRequest:"Nepodr\u017eani zahtjev ${statusText}",Permalink:"Permalink",Overlays:"Overlays","Base Layer":"Osnovna karta",readNotImplemented:"\u010citanje nije implementirano.",writeNotImplemented:"Pisanje nije implementirano.",noFID:"Ne mogu a\u017eurirati zna\u010dajku za koju ne postoji FID.",errorLoadingGML:"Gre\u0161ka u u\u010ditavanju GML datoteke ${url}",browserNotSupported:"Va\u0161 preglednik ne podr\u017eava vektorsko renderiranje. Trenutno podr\u017eani rendereri su: ${renderers}",
componentShouldBe:"addFeatures : komponenta bi trebala biti ${geomType}",getFeatureError:"getFeatureFromEvent je pozvao Layer bez renderera. Ovo obi\u010dno zna\u010di da ste uni\u0161tiili Layer, a ne neki Handler koji je povezan s njim.",commitSuccess:"WFS Transakcija: USPJE\u0160NA ${response}",commitFailed:"WFS Transakcija: NEUSPJE\u0160NA ${response}","Scale = 1 : ${scaleDenom}":"Mjerilo = 1 : ${scaleDenom}",layerAlreadyAdded:"Poku\u0161ali ste dodati layer:  ${layerName} na kartu, ali je ve\u0107 dodan",
methodDeprecated:"Ova metoda nije odobrena i biti \u0107e maknuta u 3.0. Koristite ${newMethod}.",boundsAddError:"Morate dati obje vrijednosti ,  x i y  da bi dodali funkciju.",lonlatAddError:"Morate dati obje vrijednosti , (lon i lat) da bi dodali funkciju.",pixelAddError:"Morate dati obje vrijednosti ,  x i y  da bi dodali funkciju.",unsupportedGeometryType:"Nepodr\u017eani tip geometrije: ${geomType}"});
OpenLayers.Control.NavigationHistory=OpenLayers.Class(OpenLayers.Control,{type:OpenLayers.Control.TYPE_TOGGLE,previous:null,previousOptions:null,next:null,nextOptions:null,limit:50,autoActivate:true,clearOnDeactivate:false,registry:null,nextStack:null,previousStack:null,listeners:null,restoring:false,initialize:function(a){OpenLayers.Control.prototype.initialize.apply(this,[a]);this.registry=OpenLayers.Util.extend({moveend:this.getState},this.registry);a={trigger:OpenLayers.Function.bind(this.previousTrigger,
this),displayClass:this.displayClass+" "+this.displayClass+"Previous"};OpenLayers.Util.extend(a,this.previousOptions);this.previous=new OpenLayers.Control.Button(a);a={trigger:OpenLayers.Function.bind(this.nextTrigger,this),displayClass:this.displayClass+" "+this.displayClass+"Next"};OpenLayers.Util.extend(a,this.nextOptions);this.next=new OpenLayers.Control.Button(a);this.clear()},onPreviousChange:function(a){if(a&&!this.previous.active)this.previous.activate();else!a&&this.previous.active&&this.previous.deactivate()},
onNextChange:function(a){if(a&&!this.next.active)this.next.activate();else!a&&this.next.active&&this.next.deactivate()},destroy:function(){OpenLayers.Control.prototype.destroy.apply(this);this.previous.destroy();this.next.destroy();this.deactivate();for(var a in this)this[a]=null},setMap:function(a){this.map=a;this.next.setMap(a);this.previous.setMap(a)},draw:function(){OpenLayers.Control.prototype.draw.apply(this,arguments);this.next.draw();this.previous.draw()},previousTrigger:function(){var a=
this.previousStack.shift(),b=this.previousStack.shift();if(b!=undefined){this.nextStack.unshift(a);this.previousStack.unshift(b);this.restoring=true;this.restore(b);this.restoring=false;this.onNextChange(this.nextStack[0],this.nextStack.length);this.onPreviousChange(this.previousStack[1],this.previousStack.length-1)}else this.previousStack.unshift(a);return b},nextTrigger:function(){var a=this.nextStack.shift();if(a!=undefined){this.previousStack.unshift(a);this.restoring=true;this.restore(a);this.restoring=
false;this.onNextChange(this.nextStack[0],this.nextStack.length);this.onPreviousChange(this.previousStack[1],this.previousStack.length-1)}return a},clear:function(){this.previousStack=[];this.previous.deactivate();this.nextStack=[];this.next.deactivate()},getState:function(){return{center:this.map.getCenter(),resolution:this.map.getResolution(),projection:this.map.getProjectionObject(),units:this.map.getProjectionObject().getUnits()||this.map.units||this.map.baseLayer.units}},restore:function(a){var b,
c;if(this.map.getProjectionObject()==a.projection){c=this.map.getZoomForResolution(a.resolution);b=a.center}else{b=a.center.clone();b.transform(a.projection,this.map.getProjectionObject());c=a.units;var d=this.map.getProjectionObject().getUnits()||this.map.units||this.map.baseLayer.units;c=this.map.getZoomForResolution((c&&d?OpenLayers.INCHES_PER_UNIT[c]/OpenLayers.INCHES_PER_UNIT[d]:1)*a.resolution)}this.map.setCenter(b,c)},setListeners:function(){this.listeners={};for(var a in this.registry)this.listeners[a]=
OpenLayers.Function.bind(function(){if(!this.restoring){this.previousStack.unshift(this.registry[a].apply(this,arguments));if(this.previousStack.length>1)this.onPreviousChange(this.previousStack[1],this.previousStack.length-1);this.previousStack.length>this.limit+1&&this.previousStack.pop();if(this.nextStack.length>0){this.nextStack=[];this.onNextChange(null,0)}}return true},this)},activate:function(){var a=false;if(this.map)if(OpenLayers.Control.prototype.activate.apply(this)){this.listeners==null&&
this.setListeners();for(var b in this.listeners)this.map.events.register(b,this,this.listeners[b]);a=true;this.previousStack.length==0&&this.initStack()}return a},initStack:function(){this.map.getCenter()&&this.listeners.moveend()},deactivate:function(){var a=false;if(this.map)if(OpenLayers.Control.prototype.deactivate.apply(this)){for(var b in this.listeners)this.map.events.unregister(b,this,this.listeners[b]);this.clearOnDeactivate&&this.clear();a=true}return a},CLASS_NAME:"OpenLayers.Control.NavigationHistory"});
OpenLayers.Lang.oc=OpenLayers.Util.applyDefaults({unhandledRequest:"Requ\u00e8sta pas gerida, retorna ${statusText}",Permalink:"Permaligam",Overlays:"Calques","Base Layer":"Calc de basa",readNotImplemented:"Lectura pas implementada.",writeNotImplemented:"Escritura pas implementada.",noFID:"Impossible de metre a jorn un obj\u00e8cte sens identificant (fid).",errorLoadingGML:"Error al cargament del fichi\u00e8r GML ${url}",browserNotSupported:"V\u00f2stre navegidor sup\u00f2rta pas lo rendut vectorial. Los renderers actualament suportats son : \n${renderers}",
componentShouldBe:"addFeatures : lo compausant deuri\u00e1 \u00e8sser de tipe ${geomType}",getFeatureError:"getFeatureFromEvent es estat apelat sus un calc sens renderer. Aqu\u00f2 significa generalament qu'av\u00e8tz destruch aqueste ja\u00e7, mas qu'av\u00e8tz conservat un handler que li \u00e8ra associat.",minZoomLevelError:"La proprietat minZoomLevel deu \u00e8sser utilizada solament per de jaces FixedZoomLevels-descendent. Lo fach qu'aqueste ja\u00e7 WFS verifique la pres\u00e9ncia de minZoomLevel es una relica del passat. \u00c7aquel\u00e0, la pod\u00e8m suprimir sens copar d'aplicacions que ne poiri\u00e1n dependre. Es per aqu\u00f2 que la depreciam -- la verificacion del minZoomLevel ser\u00e0 suprimida en version 3.0. A la pla\u00e7a, merc\u00e9s d'utilizar los param\u00e8tres de resolucions min/max tal coma descrich sus : http://trac.openlayers.org/wiki/SettingZoomLevels",
commitSuccess:"Transaccion WFS : SUCCES ${response}",commitFailed:"Transaccion WFS : FRACAS ${response}",googleWarning:"Lo ja\u00e7 Google es pas estat en mesura de se cargar corr\u00e8ctament.<br><br>Per suprimir aqueste messatge, causiss\u00e8tz una BaseLayer nov\u00e8la dins lo selector de ja\u00e7 en naut a drecha.<br><br>Aqu\u00f2 es possiblament causat par la non-inclusion de la librari\u00e1 Google Maps, o alara perque que la clau de l'API correspond pas a v\u00f2stre site.<br><br>Desvolopaires : per saber coss\u00ed corregir aqu\u00f2, <a href='http://trac.openlayers.org/wiki/Google' target='_blank'>clicatz aic\u00ed</a>",
getLayerWarning:"Lo ja\u00e7 ${layerType} es pas en mesura de se cargar corr\u00e8ctament.<br><br>Per suprimir aqueste messatge, causiss\u00e8tz una  BaseLayer nov\u00e8la dins lo selector de ja\u00e7 en naut a drecha.<br><br>Aqu\u00f2 es possiblament causat per la non-inclusion de la librari\u00e1 ${layerLib}.<br><br>Desvolopaires : per saber coss\u00ed corregir aqu\u00ed, <a href='http://trac.openlayers.org/wiki/${layerLib}' target='_blank'>clicatz aic\u00ed</a>","Scale = 1 : ${scaleDenom}":"Escala ~ 1 : ${scaleDenom}",
W:"O",E:"\u00c8",N:"N",S:"S",layerAlreadyAdded:"Av\u00e8tz ensajat d'apondre a la carta lo calc : ${layerName}, mas ja es present",reprojectDeprecated:"Utilizatz l'opcion 'reproject' sul ja\u00e7 ${layerName}. Aquesta opcion es despreciada : Son usatge permeti\u00e1 d'afichar de donadas al dess\u00fas de jaces raster comercials. Aquesta foncionalitat ara es suportada en utilizant lo sup\u00f2rt de la projeccion Mercator Esferica. Mai d'informacion es disponibla sus http://trac.openlayers.org/wiki/SphericalMercator.",
methodDeprecated:"Aqueste met\u00f2de es despreciada, e ser\u00e0 suprimida a la version 3.0. Merc\u00e9s d'utilizar ${newMethod} a la pla\u00e7a.",boundsAddError:"Vos cal passar las doas valors x e y a la foncion add.",lonlatAddError:"Vos cal passar las doas valors lon e lat a la foncion add.",pixelAddError:"Vos cal passar las doas valors x e y a la foncion add.",unsupportedGeometryType:"Tipe de geometria pas suportat : ${geomType}",filterEvaluateNotImplemented:"evaluar es pas encara estat implementat per aqueste tipe de filtre."});
OpenLayers.Tile.Image.IFrame={useIFrame:null,updateBackBuffer:function(){this.url=this.layer.getURL(this.bounds);var a=this.useIFrame;this.useIFrame=this.maxGetUrlLength!==null&&!this.layer.async&&this.url.length>this.maxGetUrlLength;var b=a&&!this.useIFrame;a=!a&&this.useIFrame;if(b||a){this.clear();this.imgDiv&&this.imgDiv.parentNode===this.frame&&this.frame.removeChild(this.imgDiv);this.imgDiv=null;if(b){this.frame.removeChild(this.frame.firstChild);this.resetBackBuffer()}}this.useIFrame||OpenLayers.Tile.Image.prototype.updateBackBuffer.apply(this,
arguments)},createImage:function(){if(this.useIFrame===true){if(!this.frame.childNodes.length){var a=document.createElement("div"),b=a.style;b.position="absolute";b.width="100%";b.height="100%";b.zIndex=1;b.backgroundImage="url("+this.blankImageUrl+")";this.frame.appendChild(a)}a=this.id+"_iFrame";if(parseFloat(navigator.appVersion.split("MSIE")[1])<9){b=document.createElement('<iframe name="'+a+'">');b.style.backgroundColor="#FFFFFF";b.style.filter="chroma(color=#FFFFFF)"}else{b=document.createElement("iframe");
b.style.backgroundColor="transparent";b.name=a}b.scrolling="no";b.marginWidth="0px";b.marginHeight="0px";b.frameBorder="0";b.style.position="absolute";b.style.width="100%";b.style.height="100%";this.layer.opacity<1&&OpenLayers.Util.modifyDOMElement(b,null,null,null,null,null,null,this.layer.opacity);this.frame.appendChild(b);return this.imgDiv=b}else return OpenLayers.Tile.Image.prototype.createImage.apply(this,arguments)},createRequestForm:function(){var a=document.createElement("form");a.method=
"POST";var b=this.layer.params._OLSALT;b=(b?b+"_":"")+this.bounds.toBBOX();a.action=OpenLayers.Util.urlAppend(this.layer.url,b);a.target=this.id+"_iFrame";this.layer.getImageSize();b=OpenLayers.Util.getParameters(this.url);var c,d;for(d in b){c=document.createElement("input");c.type="hidden";c.name=d;c.value=b[d];a.appendChild(c)}return a},setImgSrc:function(a){if(this.useIFrame===true)if(a){var b=this.createRequestForm();this.frame.appendChild(this.imgDiv);this.frame.appendChild(b);b.submit();this.frame.removeChild(b)}else{if(this.imgDiv.parentNode===
this.frame){this.frame.removeChild(this.imgDiv);this.imgDiv=null}}else OpenLayers.Tile.Image.prototype.setImgSrc.apply(this,arguments)}};
OpenLayers.Layer.WMS.Post=OpenLayers.Class(OpenLayers.Layer.WMS,{unsupportedBrowsers:["mozilla","firefox","opera"],SUPPORTED_TRANSITIONS:[],usePost:null,initialize:function(a,b,c,d){var e=[];e.push(a,b,c,d);OpenLayers.Layer.WMS.prototype.initialize.apply(this,e);this.usePost=OpenLayers.Util.indexOf(this.unsupportedBrowsers,OpenLayers.BROWSER_NAME)==-1},addTile:function(a,b){return new OpenLayers.Tile.Image(this,b,a,null,this.tileSize,{maxGetUrlLength:this.usePost?0:null})},CLASS_NAME:"OpenLayers.Layer.WMS.Post"});
OpenLayers.Control.TransformFeature=OpenLayers.Class(OpenLayers.Control,{EVENT_TYPES:["beforesetfeature","setfeature","beforetransform","transform","transformcomplete"],geometryTypes:null,layer:null,preserveAspectRatio:false,rotate:true,feature:null,renderIntent:"temporary",rotationHandleSymbolizer:null,box:null,center:null,scale:1,ratio:1,rotation:0,handles:null,rotationHandles:null,dragControl:null,initialize:function(a,b){this.EVENT_TYPES=OpenLayers.Control.TransformFeature.prototype.EVENT_TYPES.concat(OpenLayers.Control.prototype.EVENT_TYPES);
OpenLayers.Control.prototype.initialize.apply(this,[b]);this.layer=a;if(!this.rotationHandleSymbolizer)this.rotationHandleSymbolizer={stroke:false,pointRadius:10,fillOpacity:0,cursor:"pointer"};this.createBox();this.createControl()},activate:function(){var a=false;if(OpenLayers.Control.prototype.activate.apply(this,arguments)){this.dragControl.activate();this.layer.addFeatures([this.box]);this.rotate&&this.layer.addFeatures(this.rotationHandles);this.layer.addFeatures(this.handles);a=true}return a},
deactivate:function(){var a=false;if(OpenLayers.Control.prototype.deactivate.apply(this,arguments)){this.layer.removeFeatures(this.handles);this.rotate&&this.layer.removeFeatures(this.rotationHandles);this.layer.removeFeatures([this.box]);this.dragControl.deactivate();a=true}a&&this.unsetFeature();return a},setMap:function(a){this.dragControl.setMap(a);OpenLayers.Control.prototype.setMap.apply(this,arguments)},setFeature:function(a,b){b=OpenLayers.Util.applyDefaults(b,{rotation:0,scale:1,ratio:1});
var c=this.rotation,d=this.center;OpenLayers.Util.extend(this,b);if(this.events.triggerEvent("beforesetfeature",{feature:a})!==false){this.feature=a;this.activate();this._setfeature=true;var e=this.feature.geometry.getBounds();this.box.move(e.getCenterLonLat());this.box.geometry.rotate(-c,d);this._angle=0;if(this.rotation){c=a.geometry.clone();c.rotate(-this.rotation,this.center);c=new OpenLayers.Feature.Vector(c.getBounds().toGeometry());c.geometry.rotate(this.rotation,this.center);this.box.geometry.rotate(this.rotation,
this.center);this.box.move(c.geometry.getBounds().getCenterLonLat());c=c.geometry.components[0].components[0].getBounds().getCenterLonLat()}else c=new OpenLayers.LonLat(e.left,e.bottom);this.handles[0].move(c);delete this._setfeature;this.events.triggerEvent("setfeature",{feature:a})}},unsetFeature:function(){if(this.active)this.deactivate();else{this.feature=null;this.rotation=0;this.ratio=this.scale=1}},createBox:function(){var a=this;this.center=new OpenLayers.Geometry.Point(0,0);var b=new OpenLayers.Feature.Vector(new OpenLayers.Geometry.LineString([new OpenLayers.Geometry.Point(-1,
-1),new OpenLayers.Geometry.Point(0,-1),new OpenLayers.Geometry.Point(1,-1),new OpenLayers.Geometry.Point(1,0),new OpenLayers.Geometry.Point(1,1),new OpenLayers.Geometry.Point(0,1),new OpenLayers.Geometry.Point(-1,1),new OpenLayers.Geometry.Point(-1,0),new OpenLayers.Geometry.Point(-1,-1)]),null,typeof this.renderIntent=="string"?null:this.renderIntent);b.geometry.move=function(n,p){a._moving=true;OpenLayers.Geometry.LineString.prototype.move.apply(this,arguments);a.center.move(n,p);delete a._moving};
for(var c=function(n,p){OpenLayers.Geometry.Point.prototype.move.apply(this,arguments);this._rotationHandle&&this._rotationHandle.geometry.move(n,p);this._handle.geometry.move(n,p)},d=function(n,p,r){OpenLayers.Geometry.Point.prototype.resize.apply(this,arguments);this._rotationHandle&&this._rotationHandle.geometry.resize(n,p,r);this._handle.geometry.resize(n,p,r)},e=function(n,p){OpenLayers.Geometry.Point.prototype.rotate.apply(this,arguments);this._rotationHandle&&this._rotationHandle.geometry.rotate(n,
p);this._handle.geometry.rotate(n,p)},f=function(n,p){var r=this.x,t=this.y;OpenLayers.Geometry.Point.prototype.move.call(this,n,p);if(!a._moving){var s=a.dragControl.handlers.drag.evt,v=!(!a._setfeature&&a.preserveAspectRatio)&&!(s&&s.shiftKey),x=new OpenLayers.Geometry.Point(r,t);s=a.center;this.rotate(-a.rotation,s);x.rotate(-a.rotation,s);var C=this.x-s.x,J=this.y-s.y,F=C-(this.x-x.x);x=J-(this.y-x.y);this.x=r;this.y=t;r=1;if(v){t=Math.abs(x)<1.0E-5?1:J/x;r=(Math.abs(F)<1.0E-5?1:C/F)/t}else t=
Math.sqrt(C*C+J*J)/Math.sqrt(F*F+x*x);a._moving=true;a.box.geometry.rotate(-a.rotation,s);delete a._moving;a.box.geometry.resize(t,s,r);a.box.geometry.rotate(a.rotation,s);a.transformFeature({scale:t,ratio:r})}},g=function(n,p){var r=this.x,t=this.y;OpenLayers.Geometry.Point.prototype.move.call(this,n,p);if(!a._moving){var s=a.dragControl.handlers.drag.evt;s=s&&s.shiftKey?45:1;var v=a.center,x=this.x-v.x,C=this.y-v.y;this.x=r;this.y=t;r=Math.atan2(C,x)-Math.atan2(C-p,x-n);r*=180/Math.PI;a._angle=
(a._angle+r)%360;r=a.rotation%s;if(Math.abs(a._angle)>=s||r!==0){r=Math.round(a._angle/s)*s-r;a._angle=0;a.box.geometry.rotate(r,v);a.transformFeature({rotation:r})}}},h=Array(8),j=Array(4),i,k,l,m=0;m<8;++m){i=b.geometry.components[m];k=new OpenLayers.Feature.Vector(i.clone(),null,typeof this.renderIntent=="string"?null:this.renderIntent);if(m%2==0){l=new OpenLayers.Feature.Vector(i.clone(),null,typeof this.rotationHandleSymbolizer=="string"?null:this.rotationHandleSymbolizer);l.geometry.move=g;
i._rotationHandle=l;j[m/2]=l}i.move=c;i.resize=d;i.rotate=e;k.geometry.move=f;i._handle=k;h[m]=k}this.box=b;this.rotationHandles=j;this.handles=h},createControl:function(){var a=this;this.dragControl=new OpenLayers.Control.DragFeature(this.layer,{documentDrag:true,moveFeature:function(){if(this.feature===a.feature)this.feature=a.box;OpenLayers.Control.DragFeature.prototype.moveFeature.apply(this,arguments)},onDrag:function(b){if(b===a.box){a.transformFeature({center:a.center});a.drawHandles()}},onStart:function(b){var c=
!a.geometryTypes||OpenLayers.Util.indexOf(a.geometryTypes,b.geometry.CLASS_NAME)!==-1,d=OpenLayers.Util.indexOf(a.handles,b);d+=OpenLayers.Util.indexOf(a.rotationHandles,b);b!==a.feature&&b!==a.box&&d==-2&&c&&a.setFeature(b)},onComplete:function(){a.events.triggerEvent("transformcomplete",{feature:a.feature})}})},drawHandles:function(){for(var a=this.layer,b=0;b<8;++b){this.rotate&&b%2===0&&a.drawFeature(this.rotationHandles[b/2],this.rotationHandleSymbolizer);a.drawFeature(this.handles[b],this.renderIntent)}},
transformFeature:function(a){if(!this._setfeature){this.scale*=a.scale||1;this.ratio*=a.ratio||1;var b=this.rotation;this.rotation=(this.rotation+(a.rotation||0))%360;if(this.events.triggerEvent("beforetransform",a)!==false){var c=this.feature,d=c.geometry,e=this.center;d.rotate(-b,e);if(a.scale||a.ratio)d.resize(a.scale,e,a.ratio);else a.center&&c.move(a.center.getBounds().getCenterLonLat());d.rotate(this.rotation,e);this.layer.drawFeature(c);c.toState(OpenLayers.State.UPDATE);this.events.triggerEvent("transform",
a)}}this.layer.drawFeature(this.box,this.renderIntent);this.drawHandles()},destroy:function(){for(var a,b=0;b<8;++b){a=this.box.geometry.components[b];a._handle.destroy();a._handle=null;a._rotationHandle&&a._rotationHandle.destroy();a._rotationHandle=null}this.box.destroy();this.layer=this.box=null;this.dragControl.destroy();OpenLayers.Control.prototype.destroy.apply(this,arguments)},CLASS_NAME:"OpenLayers.Control.TransformFeature"});
OpenLayers.Layer.ArcGISCache=OpenLayers.Class(OpenLayers.Layer.XYZ,{url:null,tileOrigin:null,tileSize:new OpenLayers.Size(256,256),useArcGISServer:true,type:"png",useScales:false,overrideDPI:false,initialize:function(){OpenLayers.Layer.XYZ.prototype.initialize.apply(this,arguments);if(this.resolutions){this.serverResolutions=this.resolutions;this.maxExtent=this.getMaxExtentForResolution(this.resolutions[0])}if(this.layerInfo){var a=this.layerInfo,b=new OpenLayers.Bounds(a.fullExtent.xmin,a.fullExtent.ymin,
a.fullExtent.xmax,a.fullExtent.ymax);this.projection="EPSG:"+a.spatialReference.wkid;this.sphericalMercator=a.spatialReference.wkid==102100;this.units=a.units=="esriFeet"?"ft":"m";if(a.tileInfo){this.tileSize=new OpenLayers.Size(a.tileInfo.width||a.tileInfo.cols,a.tileInfo.height||a.tileInfo.rows);this.tileOrigin=new OpenLayers.LonLat(a.tileInfo.origin.x,a.tileInfo.origin.y);var c=new OpenLayers.Geometry.Point(b.left,b.top);b=new OpenLayers.Geometry.Point(b.right,b.bottom);if(this.useScales)this.scales=
[];else this.resolutions=[];this.lods=[];for(var d in a.tileInfo.lods){var e=a.tileInfo.lods[d];this.useScales?this.scales.push(e.scale):this.resolutions.push(e.resolution);var f=this.getContainingTileCoords(c,e.resolution);e.startTileCol=f.x;e.startTileRow=f.y;f=this.getContainingTileCoords(b,e.resolution);e.endTileCol=f.x;e.endTileRow=f.y;this.lods.push(e)}this.maxExtent=this.calculateMaxExtentWithLOD(this.lods[0]);this.serverResolutions=this.resolutions;if(this.overrideDPI&&a.tileInfo.dpi)OpenLayers.DOTS_PER_INCH=
a.tileInfo.dpi}}},getContainingTileCoords:function(a,b){return new OpenLayers.Pixel(Math.max(Math.floor((a.x-this.tileOrigin.lon)/(this.tileSize.w*b)),0),Math.max(Math.floor((this.tileOrigin.lat-a.y)/(this.tileSize.h*b)),0))},calculateMaxExtentWithLOD:function(a){var b=this.tileOrigin.lon+a.startTileCol*this.tileSize.w*a.resolution,c=this.tileOrigin.lat-a.startTileRow*this.tileSize.h*a.resolution;return new OpenLayers.Bounds(b,c-(a.endTileRow-a.startTileRow+1)*this.tileSize.h*a.resolution,b+(a.endTileCol-
a.startTileCol+1)*this.tileSize.w*a.resolution,c)},calculateMaxExtentWithExtent:function(a,b){var c=new OpenLayers.Geometry.Point(a.left,a.top),d=new OpenLayers.Geometry.Point(a.right,a.bottom);c=this.getContainingTileCoords(c,b);d=this.getContainingTileCoords(d,b);return this.calculateMaxExtentWithLOD({resolution:b,startTileCol:c.x,startTileRow:c.y,endTileCol:d.x,endTileRow:d.y})},getUpperLeftTileCoord:function(a){return this.getContainingTileCoords(new OpenLayers.Geometry.Point(this.maxExtent.left,
this.maxExtent.top),a)},getLowerRightTileCoord:function(a){return this.getContainingTileCoords(new OpenLayers.Geometry.Point(this.maxExtent.right,this.maxExtent.bottom),a)},getMaxExtentForResolution:function(a){var b=this.getUpperLeftTileCoord(a),c=this.getLowerRightTileCoord(a),d=this.tileOrigin.lon+b.x*this.tileSize.w*a,e=this.tileOrigin.lat-b.y*this.tileSize.h*a;return new OpenLayers.Bounds(d,e-(c.y-b.y+1)*this.tileSize.h*a,d+(c.x-b.x+1)*this.tileSize.w*a,e)},clone:function(a){if(a==null)a=new OpenLayers.Layer.ArcGISCache(this.name,
this.url,this.options);return OpenLayers.Layer.XYZ.prototype.clone.apply(this,[a])},getMaxExtent:function(){return this.maxExtent=this.getMaxExtentForResolution(this.map.getResolution())},getTileOrigin:function(){var a=this.getMaxExtent();return new OpenLayers.LonLat(a.left,a.bottom)},getURL:function(a){var b=this.getResolution(),c=this.tileOrigin.lon+b*this.tileSize.w/2,d=this.tileOrigin.lat-b*this.tileSize.h/2;a=a.getCenterLonLat();c=Math.round(Math.abs((a.lon-c)/(b*this.tileSize.w)));d=Math.round(Math.abs((d-
a.lat)/(b*this.tileSize.h)));a=this.map.getZoom();if(this.lods){b=this.lods[this.map.getZoom()];if(c<b.startTileCol||c>b.endTileCol||d<b.startTileRow||d>b.endTileRow)return null}else{var e=this.getUpperLeftTileCoord(b);b=this.getLowerRightTileCoord(b);if(c<e.x||c>=b.x||d<e.y||d>=b.y)return null}b=this.url;e=""+c+d+a;if(OpenLayers.Util.isArray(b))b=this.selectUrl(e,b);if(this.useArcGISServer)b+="/tile/${z}/${y}/${x}";else{c="C"+this.zeroPad(c,8,16);d="R"+this.zeroPad(d,8,16);a="L"+this.zeroPad(a,2,
16);b=b+"/${z}/${y}/${x}."+this.type}return b=OpenLayers.String.format(b,{x:c,y:d,z:a})},zeroPad:function(a,b,c){for(a=a.toString(c||10);a.length<b;)a="0"+a;return a},CLASS_NAME:"OpenLayers.Layer.ArcGISCache"});
OpenLayers.Lang["be-tarask"]=OpenLayers.Util.applyDefaults({unhandledRequest:"\u041d\u0435\u0430\u043f\u0440\u0430\u0446\u0430\u0432\u0430\u043d\u044b \u0432\u044b\u043d\u0456\u043a \u0437\u0430\u043f\u044b\u0442\u0443 ${statusText}",Permalink:"\u0421\u0442\u0430\u043b\u0430\u044f \u0441\u043f\u0430\u0441\u044b\u043b\u043a\u0430",Overlays:"\u0421\u043b\u0430\u0456","Base Layer":"\u0411\u0430\u0437\u0430\u0432\u044b \u0441\u043b\u043e\u0439",readNotImplemented:"\u0424\u0443\u043d\u043a\u0446\u044b\u044f\u043d\u0430\u043b\u044c\u043d\u0430\u0441\u044c\u0446\u044c \u0447\u044b\u0442\u0430\u043d\u044c\u043d\u044f \u043d\u044f \u0441\u0442\u0432\u043e\u0440\u0430\u043d\u0430\u044f.",
writeNotImplemented:"\u0424\u0443\u043d\u043a\u0446\u044b\u044f\u043d\u0430\u043b\u044c\u043d\u0430\u0441\u044c\u0446\u044c \u0437\u0430\u043f\u0456\u0441\u0443 \u043d\u044f \u0441\u0442\u0432\u043e\u0440\u0430\u043d\u0430\u044f.",noFID:"\u041d\u0435\u043c\u0430\u0433\u0447\u044b\u043c\u0430 \u0430\u0431\u043d\u0430\u0432\u0456\u0446\u044c \u043c\u0430\u0433\u0447\u044b\u043c\u0430\u0441\u044c\u0446\u044c, \u0434\u043b\u044f \u044f\u043a\u043e\u0433\u0430 \u043d\u0435 \u0456\u0441\u043d\u0443\u0435 FID.",
errorLoadingGML:"\u041f\u0430\u043c\u044b\u043b\u043a\u0430 \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0456 \u0444\u0430\u0439\u043b\u0430 GML ${url}",browserNotSupported:"\u0412\u0430\u0448 \u0431\u0440\u0430\u045e\u0437\u044d\u0440 \u043d\u0435 \u043f\u0430\u0434\u0442\u0440\u044b\u043c\u043b\u0456\u0432\u0430\u0435 \u0432\u044d\u043a\u0442\u0430\u0440\u043d\u0443\u044e \u0433\u0440\u0430\u0444\u0456\u043a\u0443. \u0423 \u0446\u044f\u043f\u0435\u0440\u0430\u0448\u043d\u0456 \u043c\u043e\u043c\u0430\u043d\u0442 \u043f\u0430\u0434\u0442\u0440\u044b\u043c\u043b\u0456\u0432\u0430\u044e\u0446\u0446\u0430: ${renderers}",
componentShouldBe:"addFeatures : \u043a\u0430\u043c\u043f\u0430\u043d\u044d\u043d\u0442 \u043f\u0430\u0432\u0456\u043d\u0435\u043d \u0431\u044b\u0446\u044c ${geomType}",getFeatureError:"getFeatureFromEvent \u0432\u044b\u043a\u043b\u0456\u043a\u0430\u043d\u044b \u0434\u043b\u044f \u0441\u043b\u043e\u044f \u0431\u044f\u0437 \u0440\u044d\u043d\u0434\u044d\u0440\u0443. \u0417\u0432\u044b\u0447\u0430\u0439\u043d\u0430 \u0433\u044d\u0442\u0430 \u0430\u0437\u043d\u0430\u0447\u0430\u0435, \u0448\u0442\u043e \u0412\u044b \u0437\u044c\u043d\u0456\u0448\u0447\u044b\u043b\u0456 \u0441\u043b\u043e\u0439, \u0430\u043b\u0435 \u043f\u0430\u043a\u0456\u043d\u0443\u043b\u0456 \u0437\u044c\u0432\u044f\u0437\u0430\u043d\u044b \u0437\u044c \u0456\u043c \u0430\u043f\u0440\u0430\u0446\u043e\u045e\u0448\u0447\u044b\u043a.",
minZoomLevelError:"\u0423\u043b\u0430\u0441\u044c\u0446\u0456\u0432\u0430\u0441\u044c\u0446\u044c minZoomLevel \u043f\u0440\u044b\u0437\u043d\u0430\u0447\u0430\u043d\u0430 \u0442\u043e\u043b\u044c\u043a\u0456 \u0434\u043b\u044f \u0432\u044b\u043a\u0430\u0440\u044b\u0441\u0442\u0430\u043d\u044c\u043d\u044f \u0441\u0430 \u0441\u043b\u0430\u044f\u043c\u0456 \u0432\u044b\u0442\u0432\u043e\u0440\u043d\u044b\u043c\u0456 \u0430\u0434 FixedZoomLevels. \u0422\u043e\u0435, \u0448\u0442\u043e  \u0433\u044d\u0442\u044b wfs-\u0441\u043b\u043e\u0439 \u043f\u0440\u0430\u0432\u044f\u0440\u0430\u0435\u0446\u0446\u0430 \u043d\u0430 minZoomLevel \u2014 \u0440\u044d\u0445\u0430 \u043f\u0440\u043e\u0448\u043b\u0430\u0433\u0430. \u0410\u043b\u0435 \u043c\u044b \u043d\u044f \u043c\u043e\u0436\u0430\u043c \u0432\u044b\u0434\u0430\u043b\u0456\u0446\u044c \u0433\u044d\u0442\u0443\u044e \u043c\u0430\u0433\u0447\u044b\u043c\u0430\u0441\u044c\u0446\u044c, \u0442\u0430\u043c\u0443 \u0448\u0442\u043e \u0430\u0434 \u044f\u0435 \u0437\u0430\u043b\u0435\u0436\u0430\u0446\u044c \u043d\u0435\u043a\u0430\u0442\u043e\u0440\u044b\u044f \u0437\u0430\u0441\u043d\u0430\u0432\u0430\u043d\u044b\u044f \u043d\u0430 OL \u0434\u0430\u0441\u0442\u0430\u0441\u0430\u0432\u0430\u043d\u044c\u043d\u0456. \u0422\u044b\u043c \u043d\u044f \u043c\u0435\u043d\u0448, \u043f\u0440\u0430\u0432\u0435\u0440\u043a\u0430 minZoomLevel \u0431\u0443\u0434\u0437\u0435 \u0432\u044b\u0434\u0430\u043b\u0435\u043d\u0430\u044f \u045e \u0432\u044d\u0440\u0441\u0456\u0456 3.0. \u041a\u0430\u043b\u0456 \u043b\u0430\u0441\u043a\u0430, \u0432\u044b\u043a\u0430\u0440\u044b\u0441\u0442\u043e\u045e\u0432\u0430\u0435\u0446\u0435 \u0437\u0430\u043c\u0435\u0441\u0442 \u044f\u0435 \u045e\u0441\u0442\u0430\u043d\u043e\u045e\u043a\u0456 \u043c\u0456\u043d\u0456\u043c\u0430\u043b\u044c\u043d\u0430\u0433\u0430/\u043c\u0430\u043a\u0441\u044b\u043c\u0430\u043b\u044c\u043d\u0430\u0433\u0430 \u043f\u0430\u043c\u0435\u0440\u0430\u045e, \u044f\u043a \u0430\u043f\u0456\u0441\u0430\u043d\u0430 \u0442\u0443\u0442: http://trac.openlayers.org/wiki/SettingZoomLevels",
commitSuccess:"WFS-\u0442\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u044b\u044f: \u041f\u041e\u0421\u042c\u041f\u0415\u0425 ${response}",commitFailed:"WFS-\u0442\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u044b\u044f: \u041f\u0410\u041c\u042b\u041b\u041a\u0410 ${response}",googleWarning:"\u041d\u0435 \u0430\u0442\u0440\u044b\u043c\u0430\u043b\u0430\u0441\u044f \u0437\u0430\u0433\u0440\u0443\u0437\u0456\u0446\u044c \u0441\u043b\u043e\u0439 Google. <br><br>\u041a\u0430\u0431 \u043f\u0430\u0437\u0431\u0430\u0432\u0456\u0446\u0446\u0430 \u0433\u044d\u0442\u0430\u0433\u0430 \u043f\u0430\u0432\u0435\u0434\u0430\u043c\u043b\u0435\u043d\u044c\u043d\u044f, \u0432\u044b\u0431\u0435\u0440\u044b\u0446\u0435 \u043d\u043e\u0432\u044b \u0431\u0430\u0437\u0430\u0432\u044b \u0441\u043b\u043e\u0439 \u0443 \u0441\u044c\u043f\u0456\u0441\u0435 \u045e \u0432\u0435\u0440\u0445\u043d\u0456\u043c \u043f\u0440\u0430\u0432\u044b\u043c \u043a\u0443\u0446\u0435.<br><br> \u0425\u0443\u0442\u0447\u044d\u0439 \u0437\u0430 \u045e\u0441\u0451, \u043f\u0440\u044b\u0447\u044b\u043d\u0430 \u045e \u0442\u044b\u043c, \u0448\u0442\u043e \u0441\u043a\u0440\u044b\u043f\u0442 \u0431\u0456\u0431\u043b\u0456\u044f\u0442\u044d\u043a\u0456 Google Maps \u043d\u044f \u0431\u044b\u045e \u0443\u043a\u043b\u044e\u0447\u0430\u043d\u044b\u044f \u0430\u043b\u044c\u0431\u043e \u043d\u0435 \u045e\u0442\u0440\u044b\u043c\u043b\u0456\u0432\u0430\u0435 \u0441\u043b\u0443\u0448\u043d\u044b API-\u043a\u043b\u044e\u0447 \u0434\u043b\u044f \u0412\u0430\u0448\u0430\u0433\u0430 \u0441\u0430\u0439\u0442\u0430.<br><br>\u0420\u0430\u0441\u043f\u0440\u0430\u0446\u043e\u045e\u0448\u0447\u044b\u043a\u0430\u043c: \u0414\u043b\u044f \u0442\u0430\u0433\u043e, \u043a\u0430\u0431 \u0434\u0430\u0432\u0435\u0434\u0430\u0446\u0446\u0430 \u044f\u043a \u0437\u0440\u0430\u0431\u0456\u0446\u044c \u0442\u0430\u043a, \u043a\u0430\u0431 \u0443\u0441\u0451 \u043f\u0440\u0430\u0446\u0430\u0432\u0430\u043b\u0430, <a href='http://trac.openlayers.org/wiki/Google' target='_blank'>\u043d\u0430\u0446\u0456\u0441\u044c\u043d\u0456\u0446\u0435 \u0442\u0443\u0442</a>",
getLayerWarning:"\u041d\u0435\u043c\u0430\u0433\u0447\u044b\u043c\u0430 \u0437\u0430\u0433\u0440\u0443\u0437\u0456\u0446\u044c \u0441\u043b\u043e\u0439 ${layerType}.<br><br>\u041a\u0430\u0431 \u043f\u0430\u0437\u0431\u0430\u0432\u0456\u0446\u0446\u0430 \u0433\u044d\u0442\u0430\u0433\u0430 \u043f\u0430\u0432\u0435\u0434\u0430\u043c\u043b\u0435\u043d\u044c\u043d\u044f, \u0432\u044b\u0431\u0435\u0440\u044b\u0446\u0435 \u043d\u043e\u0432\u044b \u0431\u0430\u0437\u0430\u0432\u044b \u0441\u043b\u043e\u0439 \u0443 \u0441\u044c\u043f\u0456\u0441\u0435 \u045e \u0432\u0435\u0440\u0445\u043d\u0456\u043c \u043f\u0440\u0430\u0432\u044b\u043c \u043a\u0443\u0446\u0435.<br><br>\u0425\u0443\u0442\u0447\u044d\u0439 \u0437\u0430 \u045e\u0441\u0451, \u043f\u0440\u044b\u0447\u044b\u043d\u0430 \u045e \u0442\u044b\u043c, \u0448\u0442\u043e \u0441\u043a\u0440\u044b\u043f\u0442 \u0431\u0456\u0431\u043b\u0456\u044f\u0442\u044d\u043a\u0456 ${layerLib} \u043d\u044f \u0431\u044b\u045e \u0441\u043b\u0443\u0448\u043d\u0430 \u045e\u043a\u043b\u044e\u0447\u0430\u043d\u044b.<br><br>\u0420\u0430\u0441\u043f\u0440\u0430\u0446\u043e\u045e\u0448\u0447\u044b\u043a\u0430\u043c: \u0414\u043b\u044f \u0442\u0430\u0433\u043e, \u043a\u0430\u0431 \u0434\u0430\u0432\u0435\u0434\u0430\u0446\u0446\u0430 \u044f\u043a \u0437\u0440\u0430\u0431\u0456\u0446\u044c \u0442\u0430\u043a, \u043a\u0430\u0431 \u0443\u0441\u0451 \u043f\u0440\u0430\u0446\u0430\u0432\u0430\u043b\u0430, <a href='http://trac.openlayers.org/wiki/${layerLib}' target='_blank'>\u043d\u0430\u0446\u0456\u0441\u044c\u043d\u0456\u0446\u0435 \u0442\u0443\u0442</a>",
"Scale = 1 : ${scaleDenom}":"\u041c\u0430\u0448\u0442\u0430\u0431 = 1 : ${scaleDenom}",W:"\u0417",E:"\u0423",N:"\u041f\u043d",S:"\u041f\u0434",layerAlreadyAdded:"\u0412\u044b \u043f\u0430\u0441\u043f\u0440\u0430\u0431\u0430\u0432\u0430\u043b\u0456 \u0434\u0430\u0434\u0430\u0446\u044c \u0441\u043b\u043e\u0439 ${layerName} \u043d\u0430 \u043c\u0430\u043f\u0443, \u0430\u043b\u0435 \u0451\u043d \u0443\u0436\u043e \u0434\u0430\u0434\u0430\u0434\u0437\u0435\u043d\u044b",reprojectDeprecated:"\u0412\u044b \u0432\u044b\u043a\u0430\u0440\u044b\u0441\u0442\u043e\u045e\u0432\u0430\u0435\u0446\u0435 \u045e\u0441\u0442\u0430\u043d\u043e\u045e\u043a\u0443 'reproject' \u0434\u043b\u044f \u0441\u043b\u043e\u044f ${layerName}. \u0413\u044d\u0442\u0430\u044f \u045e\u0441\u0442\u0430\u043d\u043e\u045e\u043a\u0430 \u0437\u044c\u044f\u045e\u043b\u044f\u0435\u0446\u0446\u0430 \u0441\u0430\u0441\u0442\u0430\u0440\u044d\u043b\u0430\u0439: \u044f\u043d\u0430 \u0432\u044b\u043a\u0430\u0440\u044b\u0441\u0442\u043e\u045e\u0432\u0430\u043b\u0430\u0441\u044f \u0434\u043b\u044f \u043f\u0430\u0434\u0442\u0440\u044b\u043c\u043a\u0456 \u043f\u0430\u043a\u0430\u0437\u0443 \u0437\u044c\u0432\u0435\u0441\u0442\u0430\u043a \u043d\u0430 \u043a\u0430\u043c\u044d\u0440\u0446\u044b\u0439\u043d\u044b\u0445 \u0431\u0430\u0437\u0430\u0432\u044b\u0445 \u043c\u0430\u043f\u0430\u0445, \u0430\u043b\u0435 \u0433\u044d\u0442\u0430 \u0444\u0443\u043d\u043a\u0446\u044b\u044f \u0446\u044f\u043f\u0435\u0440 \u0440\u044d\u0430\u043b\u0456\u0437\u0430\u0432\u0430\u043d\u0430\u044f \u045e \u0443\u0431\u0443\u0434\u0430\u0432\u0430\u043d\u0430\u0439 \u043f\u0430\u0434\u0442\u0440\u044b\u043c\u0446\u044b \u0441\u0444\u044d\u0440\u044b\u0447\u043d\u0430\u0439 \u043f\u0440\u0430\u0435\u043a\u0446\u044b\u0456 \u041c\u044d\u0440\u043a\u0430\u0442\u0430\u0440\u0430. \u0414\u0430\u0434\u0430\u0442\u043a\u043e\u0432\u0430\u044f \u0456\u043d\u0444\u0430\u0440\u043c\u0430\u0446\u044b\u044f \u0451\u0441\u044c\u0446\u044c \u043d\u0430 http://trac.openlayers.org/wiki/SphericalMercator.",
methodDeprecated:"\u0413\u044d\u0442\u044b \u043c\u044d\u0442\u0430\u0434 \u0441\u0430\u0441\u0442\u0430\u0440\u044d\u043b\u044b \u0456 \u0431\u0443\u0434\u0437\u0435 \u0432\u044b\u0434\u0430\u043b\u0435\u043d\u044b \u045e \u0432\u044d\u0440\u0441\u0456\u0456 3.0. \u041a\u0430\u043b\u0456 \u043b\u0430\u0441\u043a\u0430, \u0437\u0430\u043c\u0435\u0441\u0442 \u044f\u0433\u043e \u0432\u044b\u043a\u0430\u0440\u044b\u0441\u0442\u043e\u045e\u0432\u0430\u0439\u0446\u0435 ${newMethod}.",boundsAddError:"\u0412\u0430\u043c \u043d\u0435\u0430\u0431\u0445\u043e\u0434\u043d\u0430 \u043f\u0430\u0434\u0430\u0446\u044c \u0430\u0431\u043e\u0434\u0432\u0430 \u0437\u043d\u0430\u0447\u044d\u043d\u044c\u043d\u0456 x \u0456 y \u0434\u043b\u044f \u0444\u0443\u043d\u043a\u0446\u044b\u0456 \u0441\u043a\u043b\u0430\u0434\u0430\u043d\u044c\u043d\u044f.",
lonlatAddError:"\u0412\u0430\u043c \u043d\u0435\u0430\u0431\u0445\u043e\u0434\u043d\u0430 \u043f\u0430\u0434\u0430\u0446\u044c \u0430\u0431\u043e\u0434\u0432\u0430 \u0437\u043d\u0430\u0447\u044d\u043d\u044c\u043d\u0456 lon \u0456 lat \u0434\u043b\u044f \u0444\u0443\u043d\u043a\u0446\u044b\u0456 \u0441\u043a\u043b\u0430\u0434\u0430\u043d\u044c\u043d\u044f.",pixelAddError:"\u0412\u0430\u043c \u043d\u0435\u0430\u0431\u0445\u043e\u0434\u043d\u0430 \u043f\u0430\u0434\u0430\u0446\u044c \u0430\u0431\u043e\u0434\u0432\u0430 \u0437\u043d\u0430\u0447\u044d\u043d\u044c\u043d\u0456 x \u0456 y \u0434\u043b\u044f \u0444\u0443\u043d\u043a\u0446\u044b\u0456 \u0441\u043a\u043b\u0430\u0434\u0430\u043d\u044c\u043d\u044f.",
unsupportedGeometryType:"\u0422\u044b\u043f \u0433\u0435\u0430\u043c\u044d\u0442\u0440\u044b\u0456 \u043d\u0435 \u043f\u0430\u0434\u0442\u0440\u044b\u043c\u043b\u0456\u0432\u0430\u0435\u0446\u0446\u0430: ${geomType}",filterEvaluateNotImplemented:"evaluate \u043d\u0435 \u0440\u044d\u0430\u043b\u0456\u0437\u0430\u0432\u0430\u043d\u044b \u0434\u043b\u044f \u0433\u044d\u0442\u0430\u0433\u0430 \u0442\u044b\u043f\u0443 \u0444\u0456\u043b\u044c\u0442\u0440\u0443."});
OpenLayers.Control.WMSGetFeatureInfo=OpenLayers.Class(OpenLayers.Control,{hover:false,drillDown:false,maxFeatures:10,clickCallback:"click",output:"features",layers:null,queryVisible:false,url:null,layerUrls:null,infoFormat:"text/html",vendorParams:{},format:null,formatOptions:null,handlerOptions:null,handler:null,hoverRequest:null,EVENT_TYPES:["beforegetfeatureinfo","nogetfeatureinfo","getfeatureinfo"],initialize:function(a){this.EVENT_TYPES=OpenLayers.Control.WMSGetFeatureInfo.prototype.EVENT_TYPES.concat(OpenLayers.Control.prototype.EVENT_TYPES);
a=a||{};a.handlerOptions=a.handlerOptions||{};OpenLayers.Control.prototype.initialize.apply(this,[a]);if(!this.format)this.format=new OpenLayers.Format.WMSGetFeatureInfo(a.formatOptions);if(this.drillDown===true)this.hover=false;if(this.hover)this.handler=new OpenLayers.Handler.Hover(this,{move:this.cancelHover,pause:this.getInfoForHover},OpenLayers.Util.extend(this.handlerOptions.hover||{},{delay:250}));else{a={};a[this.clickCallback]=this.getInfoForClick;this.handler=new OpenLayers.Handler.Click(this,
a,this.handlerOptions.click||{})}},activate:function(){this.active||this.handler.activate();return OpenLayers.Control.prototype.activate.apply(this,arguments)},deactivate:function(){return OpenLayers.Control.prototype.deactivate.apply(this,arguments)},getInfoForClick:function(a){this.events.triggerEvent("beforegetfeatureinfo",{xy:a.xy});OpenLayers.Element.addClass(this.map.viewPortDiv,"olCursorWait");this.request(a.xy,{})},getInfoForHover:function(a){this.events.triggerEvent("beforegetfeatureinfo",
{xy:a.xy});this.request(a.xy,{hover:true})},cancelHover:function(){if(this.hoverRequest){this.hoverRequest.abort();this.hoverRequest=null}},findLayers:function(){for(var a=this.layers||this.map.layers,b=[],c,d,e=0,f=a.length;e<f;++e){c=a[e];if(c instanceof OpenLayers.Layer.WMS&&(!this.queryVisible||c.getVisibility())){d=OpenLayers.Util.isArray(c.url)?c.url[0]:c.url;if(this.drillDown===false&&!this.url)this.url=d;if(this.drillDown===true||this.urlMatches(d))b.push(c)}}return b},urlMatches:function(a){var b=
OpenLayers.Util.isEquivalentUrl(this.url,a);if(!b&&this.layerUrls)for(var c=0,d=this.layerUrls.length;c<d;++c)if(OpenLayers.Util.isEquivalentUrl(this.layerUrls[c],a)){b=true;break}return b},buildWMSOptions:function(a,b,c,d){for(var e=[],f=[],g=0,h=b.length;g<h;g++){e=e.concat(b[g].params.LAYERS);f=f.concat(this.getStyleNames(b[g]))}b=b[0];g=this.map.getProjection();if((h=b.projection)&&h.equals(this.map.getProjectionObject()))g=h.getCode();d=OpenLayers.Util.extend({service:"WMS",version:b.params.VERSION,
request:"GetFeatureInfo",layers:e,query_layers:e,styles:f,bbox:this.map.getExtent().toBBOX(null,b.reverseAxisOrder()),feature_count:this.maxFeatures,height:this.map.getSize().h,width:this.map.getSize().w,format:d,info_format:b.params.INFO_FORMAT||this.infoFormat},parseFloat(b.params.VERSION)>=1.3?{crs:g,i:parseInt(c.x),j:parseInt(c.y)}:{srs:g,x:parseInt(c.x),y:parseInt(c.y)});OpenLayers.Util.applyDefaults(d,this.vendorParams);return{url:a,params:OpenLayers.Util.upperCaseObject(d),callback:function(j){this.handleResponse(c,
j,a)},scope:this}},getStyleNames:function(a){return a.params.STYLES?a.params.STYLES:OpenLayers.Util.isArray(a.params.LAYERS)?Array(a.params.LAYERS.length):a.params.LAYERS.replace(/[^,]/g,"")},request:function(a,b){var c=this.findLayers();if(c.length==0){this.events.triggerEvent("nogetfeatureinfo");OpenLayers.Element.removeClass(this.map.viewPortDiv,"olCursorWait")}else{b=b||{};if(this.drillDown===false){c=this.buildWMSOptions(this.url,c,a,c[0].params.FORMAT);var d=OpenLayers.Request.GET(c);if(b.hover===
true)this.hoverRequest=d}else{this._numRequests=this._requestCount=0;this.features=[];d={};for(var e,f=0,g=c.length;f<g;f++){var h=c[f];e=OpenLayers.Util.isArray(h.url)?h.url[0]:h.url;if(e in d)d[e].push(h);else{this._numRequests++;d[e]=[h]}}for(e in d){c=d[e];c=this.buildWMSOptions(e,c,a,c[0].params.FORMAT);OpenLayers.Request.GET(c)}}}},triggerGetFeatureInfo:function(a,b,c){this.events.triggerEvent("getfeatureinfo",{text:a.responseText,features:c,request:a,xy:b});OpenLayers.Element.removeClass(this.map.viewPortDiv,
"olCursorWait")},handleResponse:function(a,b,c){var d=b.responseXML;if(!d||!d.documentElement)d=b.responseText;d=this.format.read(d);if(this.drillDown===false)this.triggerGetFeatureInfo(b,a,d);else{this._requestCount++;this._features=this.output==="object"?(this._features||[]).concat({url:c,features:d}):(this._features||[]).concat(d);if(this._requestCount===this._numRequests){this.triggerGetFeatureInfo(b,a,this._features.concat());delete this._features;delete this._requestCount;delete this._numRequests}}},
CLASS_NAME:"OpenLayers.Control.WMSGetFeatureInfo"});
OpenLayers.Format.SOSGetFeatureOfInterest=OpenLayers.Class(OpenLayers.Format.XML,{VERSION:"1.0.0",namespaces:{sos:"http://www.opengis.net/sos/1.0",gml:"http://www.opengis.net/gml",sa:"http://www.opengis.net/sampling/1.0",xsi:"http://www.w3.org/2001/XMLSchema-instance"},schemaLocation:"http://www.opengis.net/sos/1.0 http://schemas.opengis.net/sos/1.0.0/sosAll.xsd",defaultPrefix:"sos",regExes:{trimSpace:/^\s*|\s*$/g,removeSpace:/\s*/g,splitSpace:/\s+/,trimComma:/\s*,\s*/g},read:function(a){if(typeof a==
"string")a=OpenLayers.Format.XML.prototype.read.apply(this,[a]);if(a&&a.nodeType==9)a=a.documentElement;var b={features:[]};this.readNode(a,b);a=[];for(var c=0,d=b.features.length;c<d;c++){var e=b.features[c];this.internalProjection&&this.externalProjection&&e.components[0]&&e.components[0].transform(this.externalProjection,this.internalProjection);e=new OpenLayers.Feature.Vector(e.components[0],e.attributes);a.push(e)}return a},readers:{sa:{SamplingPoint:function(a,b){if(!b.attributes){var c={attributes:{}};
b.features.push(c);b=c}b.attributes.id=this.getAttributeNS(a,this.namespaces.gml,"id");this.readChildNodes(a,b)},position:function(a,b){this.readChildNodes(a,b)}},gml:OpenLayers.Util.applyDefaults({FeatureCollection:function(a,b){this.readChildNodes(a,b)},featureMember:function(a,b){var c={attributes:{}};b.features.push(c);this.readChildNodes(a,c)},name:function(a,b){b.attributes.name=this.getChildValue(a)},pos:function(a,b){if(!this.externalProjection)this.externalProjection=new OpenLayers.Projection(a.getAttribute("srsName"));
OpenLayers.Format.GML.v3.prototype.readers.gml.pos.apply(this,[a,b])}},OpenLayers.Format.GML.v3.prototype.readers.gml)},writers:{sos:{GetFeatureOfInterest:function(a){for(var b=this.createElementNSPlus("GetFeatureOfInterest",{attributes:{version:this.VERSION,service:"SOS","xsi:schemaLocation":this.schemaLocation}}),c=0,d=a.fois.length;c<d;c++)this.writeNode("FeatureOfInterestId",{foi:a.fois[c]},b);return b},FeatureOfInterestId:function(a){return this.createElementNSPlus("FeatureOfInterestId",{value:a.foi})}}},
CLASS_NAME:"OpenLayers.Format.SOSGetFeatureOfInterest"});
OpenLayers.Format.SOSGetObservation=OpenLayers.Class(OpenLayers.Format.XML,{namespaces:{ows:"http://www.opengis.net/ows",gml:"http://www.opengis.net/gml",sos:"http://www.opengis.net/sos/1.0",ogc:"http://www.opengis.net/ogc",om:"http://www.opengis.net/om/1.0",sa:"http://www.opengis.net/sampling/1.0",xlink:"http://www.w3.org/1999/xlink",xsi:"http://www.w3.org/2001/XMLSchema-instance"},regExes:{trimSpace:/^\s*|\s*$/g,removeSpace:/\s*/g,splitSpace:/\s+/,trimComma:/\s*,\s*/g},VERSION:"1.0.0",schemaLocation:"http://www.opengis.net/sos/1.0 http://schemas.opengis.net/sos/1.0.0/sosGetObservation.xsd",
defaultPrefix:"sos",read:function(a){if(typeof a=="string")a=OpenLayers.Format.XML.prototype.read.apply(this,[a]);if(a&&a.nodeType==9)a=a.documentElement;var b={measurements:[],observations:[]};this.readNode(a,b);return b},write:function(a){a=this.writeNode("sos:GetObservation",a);a.setAttribute("xmlns:om",this.namespaces.om);a.setAttribute("xmlns:ogc",this.namespaces.ogc);this.setAttributeNS(a,this.namespaces.xsi,"xsi:schemaLocation",this.schemaLocation);return OpenLayers.Format.XML.prototype.write.apply(this,
[a])},readers:{om:{ObservationCollection:function(a,b){b.id=this.getAttributeNS(a,this.namespaces.gml,"id");this.readChildNodes(a,b)},member:function(a,b){this.readChildNodes(a,b)},Measurement:function(a,b){var c={};b.measurements.push(c);this.readChildNodes(a,c)},Observation:function(a,b){var c={};b.observations.push(c);this.readChildNodes(a,c)},samplingTime:function(a,b){var c={};b.samplingTime=c;this.readChildNodes(a,c)},observedProperty:function(a,b){b.observedProperty=this.getAttributeNS(a,this.namespaces.xlink,
"href");this.readChildNodes(a,b)},procedure:function(a,b){b.procedure=this.getAttributeNS(a,this.namespaces.xlink,"href");this.readChildNodes(a,b)},featureOfInterest:function(a,b){var c={features:[]};b.fois=[];b.fois.push(c);this.readChildNodes(a,c);for(var d=[],e=0,f=c.features.length;e<f;e++){var g=c.features[e];d.push(new OpenLayers.Feature.Vector(g.components[0],g.attributes))}c.features=d},result:function(a,b){var c={};b.result=c;if(this.getChildValue(a)!==""){c.value=this.getChildValue(a);c.uom=
a.getAttribute("uom")}else this.readChildNodes(a,c)}},sa:OpenLayers.Format.SOSGetFeatureOfInterest.prototype.readers.sa,gml:OpenLayers.Util.applyDefaults({TimeInstant:function(a,b){var c={};b.timeInstant=c;this.readChildNodes(a,c)},timePosition:function(a,b){b.timePosition=this.getChildValue(a)}},OpenLayers.Format.SOSGetFeatureOfInterest.prototype.readers.gml)},writers:{sos:{GetObservation:function(a){var b=this.createElementNSPlus("GetObservation",{attributes:{version:this.VERSION,service:"SOS"}});
this.writeNode("offering",a,b);a.eventTime&&this.writeNode("eventTime",a,b);for(var c in a.procedures)this.writeNode("procedure",a.procedures[c],b);for(var d in a.observedProperties)this.writeNode("observedProperty",a.observedProperties[d],b);a.foi&&this.writeNode("featureOfInterest",a.foi,b);this.writeNode("responseFormat",a,b);a.resultModel&&this.writeNode("resultModel",a,b);a.responseMode&&this.writeNode("responseMode",a,b);return b},featureOfInterest:function(a){var b=this.createElementNSPlus("featureOfInterest");
this.writeNode("ObjectID",a.objectId,b);return b},ObjectID:function(a){return this.createElementNSPlus("ObjectID",{value:a})},responseFormat:function(a){return this.createElementNSPlus("responseFormat",{value:a.responseFormat})},procedure:function(a){return this.createElementNSPlus("procedure",{value:a})},offering:function(a){return this.createElementNSPlus("offering",{value:a.offering})},observedProperty:function(a){return this.createElementNSPlus("observedProperty",{value:a})},eventTime:function(a){var b=
this.createElementNSPlus("eventTime");a.eventTime==="latest"&&this.writeNode("ogc:TM_Equals",a,b);return b},resultModel:function(a){return this.createElementNSPlus("resultModel",{value:a.resultModel})},responseMode:function(a){return this.createElementNSPlus("responseMode",{value:a.responseMode})}},ogc:{TM_Equals:function(a){var b=this.createElementNSPlus("ogc:TM_Equals");this.writeNode("ogc:PropertyName",{property:"urn:ogc:data:time:iso8601"},b);a.eventTime==="latest"&&this.writeNode("gml:TimeInstant",
{value:"latest"},b);return b},PropertyName:function(a){return this.createElementNSPlus("ogc:PropertyName",{value:a.property})}},gml:{TimeInstant:function(a){var b=this.createElementNSPlus("gml:TimeInstant");this.writeNode("gml:timePosition",a,b);return b},timePosition:function(a){return this.createElementNSPlus("gml:timePosition",{value:a.value})}}},CLASS_NAME:"OpenLayers.Format.SOSGetObservation"});
OpenLayers.Lang["cs-CZ"]=OpenLayers.Util.applyDefaults({unhandledRequest:"Nezpracovan\u00e1 n\u00e1vratov\u00e1 hodnota ${statusText}",Permalink:"Trval\u00fd odkaz",Overlays:"P\u0159ekryvn\u00e9 vrstvy","Base Layer":"Podkladov\u00e9 vrstvy",readNotImplemented:"Read nen\u00ed implementov\u00e1no.",writeNotImplemented:"Write nen\u00ed implementov\u00e1no.",noFID:"Nelze aktualizovat prvek, pro kter\u00fd neexistuje FID.",errorLoadingGML:"Chyba p\u0159i na\u010d\u00edt\u00e1n\u00ed souboru GML ${url}",
browserNotSupported:"V\u00e1\u0161 prohl\u00ed\u017ee\u010d nepodporuje vykreslov\u00e1n\u00ed vektor\u016f. Moment\u00e1ln\u011b podporovan\u00e9 n\u00e1stroje jsou::\n${renderers}",componentShouldBe:"addFeatures : komponenta by m\u011bla b\u00fdt ${geomType}",getFeatureError:"getFeatureFromEvent bylo zavol\u00e1no na vrstv\u011b, kter\u00e1 nem\u00e1 vykreslova\u010d. To oby\u010dejn\u011b znamen\u00e1, \u017ee jste odstranil vrstvu, ale ne rutinu s n\u00ed asociovanou.",minZoomLevelError:"Vlastnost minZoomLevel by se m\u011bla pou\u017e\u00edvat pouze s potomky FixedZoomLevels vrstvami. To znamen\u00e1, \u017ee vrstva wfs kontroluje, zda-li minZoomLevel nen\u00ed zbytek z minulosti.Nelze to ov\u0161em vyjmout bez mo\u017enosti, \u017ee bychom rozbili aplikace postaven\u00e9 na OL, kter\u00e9 by na tom mohly z\u00e1viset. Proto tuto vlastnost nedoporu\u010dujeme pou\u017e\u00edvat --  kontrola minZoomLevel bude odstran\u011bna ve verzi 3.0. Pou\u017eijte pros\u00edm rad\u011bji nastaven\u00ed min/max podle p\u0159\u00edkaldu popsan\u00e9ho na: http://trac.openlayers.org/wiki/SettingZoomLevels",
commitSuccess:"WFS Transaction: \u00daSP\u011aCH ${response}",commitFailed:"WFS Transaction: CHYBA ${response}",googleWarning:"Nepoda\u0159ilo se spr\u00e1vn\u011b na\u010d\u00edst vrstvu Google.<br><br>Abyste se zbavili t\u00e9to zpr\u00e1vy, zvolte jinou z\u00e1kladn\u00ed vrstvu v p\u0159ep\u00edna\u010di vrstev.<br><br>To se v\u011bt\u0161inou st\u00e1v\u00e1, pokud nebyl na\u010dten skript, nebo neobsahuje spr\u00e1vn\u00fd kl\u00ed\u010d pro API pro tuto str\u00e1nku.<br><br>V\u00fdvoj\u00e1\u0159i: Pro pomoc, aby tohle fungovalo , <a href='http://trac.openlayers.org/wiki/Google' target='_blank'>klikn\u011bte sem</a>",
getLayerWarning:"The ${layerType} Layer was unable to load correctly.<br><br>To get rid of this message, select a new BaseLayer in the layer switcher in the upper-right corner.<br><br>Most likely, this is because the ${layerLib} library script was either not correctly included.<br><br>Developers: For help getting this working correctly, <a href='http://trac.openlayers.org/wiki/${layerLib}' target='_blank'>click here</a>","Scale = 1 : ${scaleDenom}":"M\u011b\u0159\u00edtko = 1 : ${scaleDenom}",layerAlreadyAdded:"Pokusili jste se p\u0159idat vrstvu: ${layerName} do mapy, ale tato vrstva je ji\u017e v map\u011b p\u0159\u00edtomna.",
reprojectDeprecated:"Pou\u017eil jste volbu 'reproject' ve vrstv\u011b ${layerName}. Tato volba nen\u00ed doporu\u010den\u00e1: byla zde proto, aby bylo mo\u017eno zobrazovat data z okomer\u010dn\u00edch server\u016f, ale tato funkce je nyn\u00ed zaji\u0161t\u011bna pomoc\u00ed podpory Spherical Mercator. V\u00edce informac\u00ed naleznete na http://trac.openlayers.org/wiki/SphericalMercator.",methodDeprecated:"Tato metoda je zavr\u017een\u00e1 a bude ve verzi 3.0 odstran\u011bna. Pros\u00edm, pou\u017eijte rad\u011bji ${newMethod}.",
boundsAddError:"Pro p\u0159\u00eddavnou funkci mus\u00edte zadat ob\u011b sou\u0159adnice x a y.",lonlatAddError:"Pro p\u0159\u00eddavnou funkci mus\u00edte zadat ob\u011b sou\u0159adnice lon a lat.",pixelAddError:"Pro p\u0159\u00eddavnou funkci mus\u00edte zadat ob\u011b sou\u0159adnice x a y.",unsupportedGeometryType:"Nepodporovan\u00fd typ geometrie: ${geomType}"});
OpenLayers.Format.CQL=function(){function a(i){function k(){var r=m.pop();switch(r.type){case "LOGICAL":var t=k(),s=k();return new OpenLayers.Filter.Logical({filters:[s,t],type:f[r.text.toUpperCase()]});case "NOT":t=k();return new OpenLayers.Filter.Logical({filters:[t],type:OpenLayers.Filter.Logical.NOT});case "BETWEEN":m.pop();s=k();r=k();t=k();return new OpenLayers.Filter.Comparison({property:t,lowerBoundary:r,upperBoundary:s,type:OpenLayers.Filter.Comparison.BETWEEN});case "COMPARISON":s=k();t=
k();return new OpenLayers.Filter.Comparison({property:t,value:s,type:d[r.text.toUpperCase()]});case "VALUE":return/^'.*'$/.test(r.text)?r.text.substr(1,r.text.length-2):Number(r.text);case "SPATIAL":switch(r.text.toUpperCase()){case "BBOX":t=k();r=k();s=k();var v=k(),x=k();return new OpenLayers.Filter.Spatial({type:OpenLayers.Filter.Spatial.BBOX,property:x,value:OpenLayers.Bounds.fromArray([v,s,r,t])});case "INTERSECTS":s=k();t=k();return new OpenLayers.Filter.Spatial({type:OpenLayers.Filter.Spatial.INTERSECTS,
property:t,value:s});case "WITHIN":s=k();t=k();return new OpenLayers.Filter.Spatial({type:OpenLayers.Filter.Spatial.WITHIN,property:t,value:s});case "CONTAINS":s=k();t=k();return new OpenLayers.Filter.Spatial({type:OpenLayers.Filter.Spatial.CONTAINS,property:t,value:s});case "DWITHIN":r=k();s=k();t=k();return new OpenLayers.Filter.Spatial({type:OpenLayers.Filter.Spatial.DWITHIN,value:s,property:t,distance:Number(r)})}case "GEOMETRY":return OpenLayers.Geometry.fromWKT(r.text);default:return r.text}}
for(var l=[],m=[];i.length;){var n=i.shift();switch(n.type){case "PROPERTY":case "GEOMETRY":case "VALUE":m.push(n);break;case "COMPARISON":case "BETWEEN":case "LOGICAL":for(var p=h[n.type];l.length>0&&h[l[l.length-1].type]<=p;)m.push(l.pop());l.push(n);break;case "SPATIAL":case "NOT":case "LPAREN":l.push(n);break;case "RPAREN":for(;l.length>0&&l[l.length-1].type!="LPAREN";)m.push(l.pop());l.pop();l.length>0&&l[l.length-1].type=="SPATIAL"&&m.push(l.pop());case "COMMA":case "END":break;default:throw Error("Unknown token type "+
n.type);}}for(;l.length>0;)m.push(l.pop());i=k();if(m.length>0){i="Remaining tokens after building AST: \n";for(l=m.length-1;l>=0;l--)i+=m[l].type+": "+m[l].text+"\n";throw Error(i);}return i}var b={PROPERTY:/^[_a-zA-Z]\w*/,COMPARISON:/^(=|<>|<=|<|>=|>|LIKE)/i,COMMA:/^,/,LOGICAL:/^(AND|OR)/i,VALUE:/^('\w+'|\d+(\.\d*)?|\.\d+)/,LPAREN:/^\(/,RPAREN:/^\)/,SPATIAL:/^(BBOX|INTERSECTS|DWITHIN|WITHIN|CONTAINS)/i,NOT:/^NOT/i,BETWEEN:/^BETWEEN/i,GEOMETRY:function(i){var k=/^(POINT|LINESTRING|POLYGON|MULTIPOINT|MULTILINESTRING|MULTIPOLYGON|GEOMETRYCOLLECTION)/.exec(i);
if(k){var l=i.length;k=i.indexOf("(",k[0].length);if(k>-1)for(var m=1;k<l&&m>0;){k++;switch(i.charAt(k)){case "(":m++;break;case ")":m--}}return[i.substr(0,k+1)]}},END:/^$/},c={LPAREN:["GEOMETRY","SPATIAL","PROPERTY","VALUE","LPAREN"],RPAREN:["NOT","LOGICAL","END","RPAREN"],PROPERTY:["COMPARISON","BETWEEN","COMMA"],BETWEEN:["VALUE"],COMPARISON:["VALUE"],COMMA:["GEOMETRY","VALUE","PROPERTY"],VALUE:["LOGICAL","COMMA","RPAREN","END"],SPATIAL:["LPAREN"],LOGICAL:["NOT","VALUE","SPATIAL","PROPERTY","LPAREN"],
NOT:["PROPERTY","LPAREN"],GEOMETRY:["COMMA","RPAREN"]},d={"=":OpenLayers.Filter.Comparison.EQUAL_TO,"<>":OpenLayers.Filter.Comparison.NOT_EQUAL_TO,"<":OpenLayers.Filter.Comparison.LESS_THAN,"<=":OpenLayers.Filter.Comparison.LESS_THAN_OR_EQUAL_TO,">":OpenLayers.Filter.Comparison.GREATER_THAN,">=":OpenLayers.Filter.Comparison.GREATER_THAN_OR_EQUAL_TO,LIKE:OpenLayers.Filter.Comparison.LIKE,BETWEEN:OpenLayers.Filter.Comparison.BETWEEN},e={},f={AND:OpenLayers.Filter.Logical.AND,OR:OpenLayers.Filter.Logical.OR},
g={},h={RPAREN:3,LOGICAL:2,COMPARISON:1},j;for(j in d)if(d.hasOwnProperty(j))e[d[j]]=j;for(j in f)if(f.hasOwnProperty(j))g[f[j]]=j;return OpenLayers.Class(OpenLayers.Format,{read:function(i){var k=i;i=[];var l,m=["NOT","GEOMETRY","SPATIAL","PROPERTY","LPAREN"];do{a:{l=m;var n=void 0;m=void 0;var p=l.length;for(n=0;n<p;n++){m=l[n];var r=b[m]instanceof RegExp?b[m].exec(k):(0,b[m])(k);if(r){l=r[0];k=k.substr(l.length).replace(/^\s*/,"");l={type:m,text:l,remainder:k};break a}}i="ERROR: In parsing: ["+
k+"], expected one of: ";for(n=0;n<p;n++){m=l[n];i+="\n    "+m+": "+b[m]}throw Error(i);}k=l.remainder;m=c[l.type];if(l.type!="END"&&!m)throw Error("No follows list for "+l.type);i.push(l)}while(l.type!="END");i=a(i);if(this.keepData)this.data=i;return i},write:function(i){if(i instanceof OpenLayers.Geometry)return i.toString();switch(i.CLASS_NAME){case "OpenLayers.Filter.Spatial":switch(i.type){case OpenLayers.Filter.Spatial.BBOX:return"BBOX("+i.property+","+i.value.toBBOX()+")";case OpenLayers.Filter.Spatial.DWITHIN:return"DWITHIN("+
i.property+", "+this.write(i.value)+", "+i.distance+")";case OpenLayers.Filter.Spatial.WITHIN:return"WITHIN("+i.property+", "+this.write(i.value)+")";case OpenLayers.Filter.Spatial.INTERSECTS:return"INTERSECTS("+i.property+", "+this.write(i.value)+")";case OpenLayers.Filter.Spatial.CONTAINS:return"CONTAINS("+i.property+", "+this.write(i.value)+")";default:throw Error("Unknown spatial filter type: "+i.type);}case "OpenLayers.Filter.Logical":if(i.type==OpenLayers.Filter.Logical.NOT)return"NOT ("+this.write(i.filters[0])+
")";else{for(var k="(",l=true,m=0;m<i.filters.length;m++){if(l)l=false;else k+=") "+g[i.type]+" (";k+=this.write(i.filters[m])}return k+")"}case "OpenLayers.Filter.Comparison":return i.type==OpenLayers.Filter.Comparison.BETWEEN?i.property+" BETWEEN "+this.write(i.lowerBoundary)+" AND "+this.write(i.upperBoundary):i.property+" "+e[i.type]+" "+this.write(i.value);case undefined:if(typeof i==="string")return"'"+i+"'";else if(typeof i==="number")return String(i);default:throw Error("Can't encode: "+i.CLASS_NAME+
" "+i);}},CLASS_NAME:"OpenLayers.Format.CQL"})}();
OpenLayers.Control.Split=OpenLayers.Class(OpenLayers.Control,{EVENT_TYPES:["beforesplit","split","aftersplit"],layer:null,source:null,sourceOptions:null,tolerance:null,edge:true,deferDelete:false,mutual:true,targetFilter:null,sourceFilter:null,handler:null,initialize:function(a){Array.prototype.push.apply(this.EVENT_TYPES,OpenLayers.Control.prototype.EVENT_TYPES);OpenLayers.Control.prototype.initialize.apply(this,[a]);this.options=a||{};this.options.source&&this.setSource(this.options.source)},setSource:function(a){if(this.active){this.deactivate();
if(this.handler){this.handler.destroy();delete this.handler}this.source=a;this.activate()}else this.source=a},activate:function(){var a=OpenLayers.Control.prototype.activate.call(this);if(a)if(this.source){if(this.source.events)this.source.events.on({sketchcomplete:this.onSketchComplete,afterfeaturemodified:this.afterFeatureModified,scope:this})}else{if(!this.handler)this.handler=new OpenLayers.Handler.Path(this,{done:function(b){this.onSketchComplete({feature:new OpenLayers.Feature.Vector(b)})}},
{layerOptions:this.sourceOptions});this.handler.activate()}return a},deactivate:function(){var a=OpenLayers.Control.prototype.deactivate.call(this);a&&this.source&&this.source.events&&this.layer.events.un({sketchcomplete:this.onSketchComplete,afterfeaturemodified:this.afterFeatureModified,scope:this});return a},onSketchComplete:function(a){this.feature=null;return!this.considerSplit(a.feature)},afterFeatureModified:function(a){if(a.modified){var b=a.feature;if(b.geometry instanceof OpenLayers.Geometry.LineString||
b.geometry instanceof OpenLayers.Geometry.MultiLineString){this.feature=a.feature;this.considerSplit(a.feature)}}},removeByGeometry:function(a,b){for(var c=0,d=a.length;c<d;++c)if(a[c].geometry===b){a.splice(c,1);break}},isEligible:function(a){return a.state!==OpenLayers.State.DELETE&&(a.geometry instanceof OpenLayers.Geometry.LineString||a.geometry instanceof OpenLayers.Geometry.MultiLineString)&&this.feature!==a&&(!this.targetFilter||this.targetFilter.evaluate(a.attributes))},considerSplit:function(a){var b=
false,c=false;if(!this.sourceFilter||this.sourceFilter.evaluate(a.attributes)){for(var d=this.layer&&this.layer.features||[],e,f,g=[],h=[],j=this.layer===this.source&&this.mutual,i={edge:this.edge,tolerance:this.tolerance,mutual:j},k=[a.geometry],l,m,n,p=0,r=d.length;p<r;++p){l=d[p];if(this.isEligible(l)){m=[l.geometry];for(var t=0;t<k.length;++t){n=k[t];for(var s=0;s<m.length;++s){e=m[s];if(n.getBounds().intersectsBounds(e.getBounds()))if(e=n.split(e,i)){f=this.events.triggerEvent("beforesplit",
{source:a,target:l});if(f!==false){if(j){f=e[0];if(f.length>1){f.unshift(t,1);Array.prototype.splice.apply(k,f);t+=f.length-3}e=e[1]}if(e.length>1){e.unshift(s,1);Array.prototype.splice.apply(m,e);s+=e.length-3}}}}}if(m&&m.length>1){this.geomsToFeatures(l,m);this.events.triggerEvent("split",{original:l,features:m});Array.prototype.push.apply(g,m);h.push(l);c=true}}}if(k&&k.length>1){this.geomsToFeatures(a,k);this.events.triggerEvent("split",{original:a,features:k});Array.prototype.push.apply(g,k);
h.push(a);b=true}if(b||c){if(this.deferDelete){d=[];p=0;for(r=h.length;p<r;++p){c=h[p];if(c.state===OpenLayers.State.INSERT)d.push(c);else{c.state=OpenLayers.State.DELETE;this.layer.drawFeature(c)}}this.layer.destroyFeatures(d,{silent:true});p=0;for(r=g.length;p<r;++p)g[p].state=OpenLayers.State.INSERT}else this.layer.destroyFeatures(h,{silent:true});this.layer.addFeatures(g,{silent:true});this.events.triggerEvent("aftersplit",{source:a,features:g})}}return b},geomsToFeatures:function(a,b){var c=
a.clone();delete c.geometry;for(var d,e=0,f=b.length;e<f;++e){d=c.clone();d.geometry=b[e];d.state=OpenLayers.State.INSERT;b[e]=d}},destroy:function(){this.active&&this.deactivate();OpenLayers.Control.prototype.destroy.call(this)},CLASS_NAME:"OpenLayers.Control.Split"});
OpenLayers.Layer.WMTS=OpenLayers.Class(OpenLayers.Layer.Grid,{isBaseLayer:true,version:"1.0.0",requestEncoding:"KVP",url:null,layer:null,matrixSet:null,style:null,format:"image/jpeg",tileOrigin:null,tileFullExtent:null,formatSuffix:null,matrixIds:null,dimensions:null,params:null,zoomOffset:0,formatSuffixMap:{"image/png":"png","image/png8":"png","image/png24":"png","image/png32":"png",png:"png","image/jpeg":"jpg","image/jpg":"jpg",jpeg:"jpg",jpg:"jpg"},matrix:null,initialize:function(a){var b={url:true,
layer:true,style:true,matrixSet:true},c;for(c in b)if(!(c in a))throw Error("Missing property '"+c+"' in layer configuration.");a.params=OpenLayers.Util.upperCaseObject(a.params);OpenLayers.Layer.Grid.prototype.initialize.apply(this,[a.name,a.url,a.params,a]);if(!this.formatSuffix)this.formatSuffix=this.formatSuffixMap[this.format]||this.format.split("/").pop();if(this.matrixIds)if((a=this.matrixIds.length)&&typeof this.matrixIds[0]==="string"){b=this.matrixIds;this.matrixIds=Array(a);for(c=0;c<a;++c)this.matrixIds[c]=
{identifier:b[c]}}},setMap:function(){OpenLayers.Layer.Grid.prototype.setMap.apply(this,arguments);this.updateMatrixProperties()},updateMatrixProperties:function(){if(this.matrix=this.getMatrix()){if(this.matrix.topLeftCorner)this.tileOrigin=this.matrix.topLeftCorner;if(this.matrix.tileWidth&&this.matrix.tileHeight)this.tileSize=new OpenLayers.Size(this.matrix.tileWidth,this.matrix.tileHeight);if(!this.tileOrigin)this.tileOrigin=new OpenLayers.LonLat(this.maxExtent.left,this.maxExtent.top);if(!this.tileFullExtent)this.tileFullExtent=
this.maxExtent}},moveTo:function(a,b){if(b||!this.matrix)this.updateMatrixProperties();return OpenLayers.Layer.Grid.prototype.moveTo.apply(this,arguments)},clone:function(a){if(a==null)a=new OpenLayers.Layer.WMTS(this.options);return a=OpenLayers.Layer.Grid.prototype.clone.apply(this,[a])},getMatrix:function(){var a;if(!this.matrixIds||this.matrixIds.length===0)a={identifier:this.map.getZoom()+this.zoomOffset};else if("scaleDenominator"in this.matrixIds[0])for(var b=OpenLayers.METERS_PER_INCH*OpenLayers.INCHES_PER_UNIT[this.units]*
this.map.getResolution()/2.8E-4,c=Number.POSITIVE_INFINITY,d,e=0,f=this.matrixIds.length;e<f;++e){d=Math.abs(1-this.matrixIds[e].scaleDenominator/b);if(d<c){c=d;a=this.matrixIds[e]}}else a=this.matrixIds[this.map.getZoom()+this.zoomOffset];return a},getTileInfo:function(a){var b=this.map.getResolution(),c=(a.lon-this.tileOrigin.lon)/(b*this.tileSize.w);a=(this.tileOrigin.lat-a.lat)/(b*this.tileSize.h);b=Math.floor(c);var d=Math.floor(a);return{col:b,row:d,i:Math.floor((c-b)*this.tileSize.w),j:Math.floor((a-
d)*this.tileSize.h)}},getURL:function(a){a=this.adjustBounds(a);var b="";if(!this.tileFullExtent||this.tileFullExtent.intersectsBounds(a)){a=this.getTileInfo(a.getCenterLonLat());if(this.requestEncoding.toUpperCase()==="REST"){var c=this.version+"/"+this.layer+"/"+this.style+"/";if(this.dimensions)for(b=0;b<this.dimensions.length;b++)if(this.params[this.dimensions[b]])c=c+this.params[this.dimensions[b]]+"/";c=c+this.matrixSet+"/"+this.matrix.identifier+"/"+a.row+"/"+a.col+"."+this.formatSuffix;b=
OpenLayers.Util.isArray(this.url)?this.selectUrl(c,this.url):this.url;b.match(/\/$/)||(b+="/");b+=c}else if(this.requestEncoding.toUpperCase()==="KVP")b=OpenLayers.Layer.Grid.prototype.getFullRequestString.apply(this,[{SERVICE:"WMTS",REQUEST:"GetTile",VERSION:this.version,LAYER:this.layer,STYLE:this.style,TILEMATRIXSET:this.matrixSet,TILEMATRIX:this.matrix.identifier,TILEROW:a.row,TILECOL:a.col,FORMAT:this.format}])}return b},mergeNewParams:function(a){if(this.requestEncoding.toUpperCase()==="KVP")return OpenLayers.Layer.Grid.prototype.mergeNewParams.apply(this,
[OpenLayers.Util.upperCaseObject(a)])},CLASS_NAME:"OpenLayers.Layer.WMTS"});
OpenLayers.Protocol.SOS.v1_0_0=OpenLayers.Class(OpenLayers.Protocol,{fois:null,formatOptions:null,initialize:function(a){OpenLayers.Protocol.prototype.initialize.apply(this,[a]);if(!a.format)this.format=new OpenLayers.Format.SOSGetFeatureOfInterest(this.formatOptions)},destroy:function(){this.options&&!this.options.format&&this.format.destroy();this.format=null;OpenLayers.Protocol.prototype.destroy.apply(this)},read:function(a){a=OpenLayers.Util.extend({},a);OpenLayers.Util.applyDefaults(a,this.options||
{});var b=new OpenLayers.Protocol.Response({requestType:"read"}),c=this.format;c=OpenLayers.Format.XML.prototype.write.apply(c,[c.writeNode("sos:GetFeatureOfInterest",{fois:this.fois})]);b.priv=OpenLayers.Request.POST({url:a.url,callback:this.createCallback(this.handleRead,b,a),data:c});return b},handleRead:function(a,b){if(b.callback){var c=a.priv;if(c.status>=200&&c.status<300){a.features=this.parseFeatures(c);a.code=OpenLayers.Protocol.Response.SUCCESS}else a.code=OpenLayers.Protocol.Response.FAILURE;
b.callback.call(b.scope,a)}},parseFeatures:function(a){var b=a.responseXML;if(!b||!b.documentElement)b=a.responseText;if(!b||b.length<=0)return null;return this.format.read(b)},CLASS_NAME:"OpenLayers.Protocol.SOS.v1_0_0"});
OpenLayers.Layer.KaMapCache=OpenLayers.Class(OpenLayers.Layer.KaMap,{IMAGE_EXTENSIONS:{jpeg:"jpg",gif:"gif",png:"png",png8:"png",png24:"png",dithered:"png"},DEFAULT_FORMAT:"jpeg",initialize:function(){OpenLayers.Layer.KaMap.prototype.initialize.apply(this,arguments);this.extension=this.IMAGE_EXTENSIONS[this.params.i.toLowerCase()||DEFAULT_FORMAT]},getURL:function(a){a=this.adjustBounds(a);var b=this.map.getResolution(),c=Math.round(this.map.getScale()*1E4)/1E4,d=Math.round(a.left/b);a=-Math.round(a.top/
b);b=Math.floor(d/this.tileSize.w/this.params.metaTileSize.w)*this.tileSize.w*this.params.metaTileSize.w;var e=Math.floor(a/this.tileSize.h/this.params.metaTileSize.h)*this.tileSize.h*this.params.metaTileSize.h,f=this.url;if(OpenLayers.Util.isArray(f))f=this.selectUrl(paramsString,f);return[f,"/",this.params.map,"/",c,"/",this.params.g.replace(/\s/g,"_"),"/def/t",e,"/l",b,"/t",a,"l",d,".",this.extension].join("")},CLASS_NAME:"OpenLayers.Layer.KaMapCache"});
OpenLayers.Protocol.WFS.v1_1_0=OpenLayers.Class(OpenLayers.Protocol.WFS.v1,{version:"1.1.0",initialize:function(){OpenLayers.Protocol.WFS.v1.prototype.initialize.apply(this,arguments);if(this.outputFormat&&!this.readFormat)if(this.outputFormat.toLowerCase()=="gml2")this.readFormat=new OpenLayers.Format.GML.v2({featureType:this.featureType,featureNS:this.featureNS,geometryName:this.geometryName});else if(this.outputFormat.toLowerCase()=="json")this.readFormat=new OpenLayers.Format.GeoJSON},CLASS_NAME:"OpenLayers.Protocol.WFS.v1_1_0"});
OpenLayers.Format.WMSCapabilities.v1_1_1=OpenLayers.Class(OpenLayers.Format.WMSCapabilities.v1_1,{version:"1.1.1",initialize:function(a){OpenLayers.Format.WMSCapabilities.v1_1.prototype.initialize.apply(this,[a])},readers:{wms:OpenLayers.Util.applyDefaults({SRS:function(a,b){b.srs[this.getChildValue(a)]=true}},OpenLayers.Format.WMSCapabilities.v1_1.prototype.readers.wms)},CLASS_NAME:"OpenLayers.Format.WMSCapabilities.v1_1_1"});
OpenLayers.Format.WMSCapabilities.v1_1_1_WMSC=OpenLayers.Class(OpenLayers.Format.WMSCapabilities.v1_1_1,{version:"1.1.1",profile:"WMSC",initialize:function(a){OpenLayers.Format.WMSCapabilities.v1_1_1.prototype.initialize.apply(this,[a])},readers:{wms:OpenLayers.Util.applyDefaults({VendorSpecificCapabilities:function(a,b){b.vendorSpecific={tileSets:[]};this.readChildNodes(a,b.vendorSpecific)},TileSet:function(a,b){var c={srs:{},bbox:{},resolutions:[]};this.readChildNodes(a,c);b.tileSets.push(c)},Resolutions:function(a,
b){for(var c=this.getChildValue(a).split(" "),d=0,e=c.length;d<e;d++)c[d]!=""&&b.resolutions.push(parseFloat(c[d]))},Width:function(a,b){b.width=parseInt(this.getChildValue(a))},Height:function(a,b){b.height=parseInt(this.getChildValue(a))},Layers:function(a,b){b.layers=this.getChildValue(a)},Styles:function(a,b){b.styles=this.getChildValue(a)}},OpenLayers.Format.WMSCapabilities.v1_1_1.prototype.readers.wms)},CLASS_NAME:"OpenLayers.Format.WMSCapabilities.v1_1_1_WMSC"});
OpenLayers.Lang.lt=OpenLayers.Util.applyDefaults({unhandledRequest:"Neapdorota u\u017eklausa gra\u017eino ${statusText}",Permalink:"Pastovi nuoroda",Overlays:"Papildomi sluoksniai","Base Layer":"Pagrindinis sluoksnis",readNotImplemented:"Skaitymas n\u0117ra \u012fgyvendintas.",writeNotImplemented:"Ra\u0161ymas n\u0117ra \u012fgyvendintas.",noFID:"Negaliu atnaujinti objekto, kuris neturi FID.",errorLoadingGML:"Klaida u\u017ekraunant GML fail\u0105 ${url}",browserNotSupported:"J\u016bs\u0173 nar\u0161ykl\u0117 nemoka parodyti vektori\u0173. \u0160iuo metu galima naudotis tokiais rodymo varikliais:\n{renderers}",
componentShouldBe:"addFeatures : komponentas turi b\u016bti ${geomType}",getFeatureError:"getFeatureFromEvent buvo i\u0161kviestas sluoksniui, kuris neturi priskirto pai\u0161ymo variklio. Tai paprastai nutinka, kai j\u016bs pa\u0161alinate sluoksn\u012f, bet paliekate su juo susijus\u012f [handler]",commitSuccess:"WFS Tranzakcija: PAVYKO ${response}",commitFailed:"WFS Tranzakcija: \u017dLUGO ${response}","Scale = 1 : ${scaleDenom}":"Mastelis = 1 : ${scaleDenom}",W:"V",E:"R",N:"\u0160",S:"P",Graticule:"Tinklelis",
layerAlreadyAdded:"Band\u0117te prid\u0117ti prie \u017eem\u0117lapio sluoksn\u012f ${layerName}, ta\u010diau jis jau yra prid\u0117tas",methodDeprecated:"\u0160is metodas yra pasen\u0119s ir 3.0 versijoje bus pa\u0161alintas. Pra\u0161ome naudoti ${newMethod}.",boundsAddError:"Add funkcijai reikia pateikti tiek x, tiek y reik\u0161mes.",lonlatAddError:"Add funkcijai reikia pateikti tiek lon, tiek lat reik\u0161mes",pixelAddError:"Add funkcijai b\u016btina perduoti tiek x, tiek y reik\u0161mes.",
unsupportedGeometryType:"Nepalaikomas geometrijos tipas: ${geomType}",end:""});
OpenLayers.Format.WMSCapabilities.v1_1_0=OpenLayers.Class(OpenLayers.Format.WMSCapabilities.v1_1,{version:"1.1.0",initialize:function(a){OpenLayers.Format.WMSCapabilities.v1_1.prototype.initialize.apply(this,[a])},readers:{wms:OpenLayers.Util.applyDefaults({SRS:function(a,b){for(var c=this.getChildValue(a).split(/ +/),d=0,e=c.length;d<e;d++)b.srs[c[d]]=true}},OpenLayers.Format.WMSCapabilities.v1_1.prototype.readers.wms)},CLASS_NAME:"OpenLayers.Format.WMSCapabilities.v1_1_0"});
OpenLayers.Layer.WFS=OpenLayers.Class(OpenLayers.Layer.Vector,OpenLayers.Layer.Markers,{isBaseLayer:false,tile:null,ratio:2,DEFAULT_PARAMS:{service:"WFS",version:"1.0.0",request:"GetFeature"},featureClass:null,format:null,formatObject:null,formatOptions:null,vectorMode:true,encodeBBOX:false,extractAttributes:false,initialize:function(a,b,c,d){if(d==undefined)d={};if(d.featureClass||!OpenLayers.Layer.Vector||!OpenLayers.Feature.Vector)this.vectorMode=false;c=OpenLayers.Util.upperCaseObject(c);OpenLayers.Util.extend(d,
{reportError:false});var e=[];e.push(a,d);OpenLayers.Layer.Vector.prototype.initialize.apply(this,e);if(!this.renderer||!this.vectorMode){this.vectorMode=false;if(!d.featureClass)d.featureClass=OpenLayers.Feature.WFS;OpenLayers.Layer.Markers.prototype.initialize.apply(this,e)}if(this.params&&this.params.typename&&!this.options.typename)this.options.typename=this.params.typename;if(!this.options.geometry_column)this.options.geometry_column="the_geom";this.params=OpenLayers.Util.applyDefaults(c,OpenLayers.Util.upperCaseObject(this.DEFAULT_PARAMS));
this.url=b},destroy:function(){this.vectorMode?OpenLayers.Layer.Vector.prototype.destroy.apply(this,arguments):OpenLayers.Layer.Markers.prototype.destroy.apply(this,arguments);this.tile&&this.tile.destroy();this.format=this.featureClass=this.ratio=this.tile=null;this.formatObject&&this.formatObject.destroy&&this.formatObject.destroy();this.extractAttributes=this.encodeBBOX=this.vectorMode=this.formatOptions=this.formatObject=null},setMap:function(){if(this.vectorMode){OpenLayers.Layer.Vector.prototype.setMap.apply(this,
arguments);var a={extractAttributes:this.extractAttributes};OpenLayers.Util.extend(a,this.formatOptions);if(this.map&&!this.projection.equals(this.map.getProjectionObject())){a.externalProjection=this.projection;a.internalProjection=this.map.getProjectionObject()}this.formatObject=this.format?new this.format(a):new OpenLayers.Format.GML(a)}else OpenLayers.Layer.Markers.prototype.setMap.apply(this,arguments)},moveTo:function(a,b,c){this.vectorMode?OpenLayers.Layer.Vector.prototype.moveTo.apply(this,
arguments):OpenLayers.Layer.Markers.prototype.moveTo.apply(this,arguments);if(c)return false;b&&this.vectorMode&&this.renderer.clear();if(this.options.minZoomLevel){OpenLayers.Console.warn(OpenLayers.i18n("minZoomLevelError"));if(this.map.getZoom()<this.options.minZoomLevel)return null}if(a==null)a=this.map.getExtent();var d=this.tile==null,e=!d&&!this.tile.bounds.containsBounds(a);if(b||d||!c&&e){d=a.getCenterLonLat();e=a.getWidth()*this.ratio;var f=a.getHeight()*this.ratio;d=new OpenLayers.Bounds(d.lon-
e/2,d.lat-f/2,d.lon+e/2,d.lat+f/2);e=this.map.getSize();e.w*=this.ratio;e.h*=this.ratio;f=this.map.getLayerPxFromLonLat(new OpenLayers.LonLat(d.left,d.top));var g=this.getFullRequestString(),h=null,j=this.params.filter||this.params.FILTER;h=j?{FILTER:j}:{BBOX:this.encodeBBOX?d.toBBOX():d.toArray()};if(this.map&&!this.projection.equals(this.map.getProjectionObject())){var i=d.clone();i.transform(this.map.getProjectionObject(),this.projection);if(!j)h.BBOX=this.encodeBBOX?i.toBBOX():i.toArray()}g+=
"&"+OpenLayers.Util.getParameterString(h);if(this.tile){if(this.vectorMode){this.destroyFeatures();this.renderer.clear()}else this.clearMarkers();this.removeTileMonitoringHooks(this.tile);this.tile.destroy();this.tile=null}this.tile=new OpenLayers.Tile.WFS(this,f,d,g,e);this.addTileMonitoringHooks(this.tile);this.tile.draw()}},addTileMonitoringHooks:function(a){a.onLoadStart=function(){this==this.layer.tile&&this.layer.events.triggerEvent("loadstart")};a.events.register("loadstart",a,a.onLoadStart);
a.onLoadEnd=function(){if(this==this.layer.tile){this.layer.events.triggerEvent("tileloaded");this.layer.events.triggerEvent("loadend")}};a.events.register("loadend",a,a.onLoadEnd);a.events.register("unload",a,a.onLoadEnd)},removeTileMonitoringHooks:function(a){a.unload();a.events.un({loadstart:a.onLoadStart,loadend:a.onLoadEnd,unload:a.onLoadEnd,scope:a})},onMapResize:function(){this.vectorMode?OpenLayers.Layer.Vector.prototype.onMapResize.apply(this,arguments):OpenLayers.Layer.Markers.prototype.onMapResize.apply(this,
arguments)},display:function(){this.vectorMode?OpenLayers.Layer.Vector.prototype.display.apply(this,arguments):OpenLayers.Layer.Markers.prototype.display.apply(this,arguments)},mergeNewParams:function(a){a=[OpenLayers.Util.upperCaseObject(a)];return OpenLayers.Layer.HTTPRequest.prototype.mergeNewParams.apply(this,a)},clone:function(a){if(a==null)a=new OpenLayers.Layer.WFS(this.name,this.url,this.params,this.getOptions());return a=this.vectorMode?OpenLayers.Layer.Vector.prototype.clone.apply(this,
[a]):OpenLayers.Layer.Markers.prototype.clone.apply(this,[a])},getFullRequestString:function(){var a=this.projection.getCode()||this.map.getProjection();this.params.SRS=a=="none"?null:a;return OpenLayers.Layer.Grid.prototype.getFullRequestString.apply(this,arguments)},commit:function(){if(!this.writer){var a={};if(this.map&&!this.projection.equals(this.map.getProjectionObject())){a.externalProjection=this.projection;a.internalProjection=this.map.getProjectionObject()}this.writer=new OpenLayers.Format.WFS(a,
this)}a=this.writer.write(this.features);OpenLayers.Request.POST({url:this.url,data:a,success:this.commitSuccess,failure:this.commitFailure,scope:this})},commitSuccess:function(a){a=a.responseText;if(a.indexOf("SUCCESS")!=-1){this.commitReport(OpenLayers.i18n("commitSuccess",{response:a}));for(a=0;a<this.features.length;a++)this.features[a].state=null}else if(a.indexOf("FAILED")!=-1||a.indexOf("Exception")!=-1)this.commitReport(OpenLayers.i18n("commitFailed",{response:a}))},commitFailure:function(){},
commitReport:function(a){OpenLayers.Console.userError(a)},refresh:function(){if(this.tile){if(this.vectorMode){this.renderer.clear();this.features.length=0}else{this.clearMarkers();this.markers.length=0}this.tile.draw()}},getDataExtent:function(){return this.vectorMode?OpenLayers.Layer.Vector.prototype.getDataExtent.apply(this):OpenLayers.Layer.Markers.prototype.getDataExtent.apply(this)},setOpacity:function(a){this.vectorMode?OpenLayers.Layer.Vector.prototype.setOpacity.apply(this,[a]):OpenLayers.Layer.Markers.prototype.setOpacity.apply(this,
[a])},CLASS_NAME:"OpenLayers.Layer.WFS"});OpenLayers.Lang.io=OpenLayers.Util.applyDefaults({"Scale = 1 : ${scaleDenom}":"Skalo = 1 : ${scaleDenom}"});
OpenLayers.Control.LayerSwitcher=OpenLayers.Class(OpenLayers.Control,{roundedCorner:true,roundedCornerColor:"darkblue",layerStates:null,layersDiv:null,baseLayersDiv:null,baseLayers:null,dataLbl:null,dataLayersDiv:null,dataLayers:null,minimizeDiv:null,maximizeDiv:null,ascending:true,initialize:function(){OpenLayers.Control.prototype.initialize.apply(this,arguments);this.layerStates=[]},destroy:function(){OpenLayers.Event.stopObservingElement(this.div);OpenLayers.Event.stopObservingElement(this.minimizeDiv);
OpenLayers.Event.stopObservingElement(this.maximizeDiv);this.clearLayersArray("base");this.clearLayersArray("data");this.map.events.un({addlayer:this.redraw,changelayer:this.redraw,removelayer:this.redraw,changebaselayer:this.redraw,scope:this});OpenLayers.Control.prototype.destroy.apply(this,arguments)},setMap:function(){OpenLayers.Control.prototype.setMap.apply(this,arguments);this.map.events.on({addlayer:this.redraw,changelayer:this.redraw,removelayer:this.redraw,changebaselayer:this.redraw,scope:this})},
draw:function(){OpenLayers.Control.prototype.draw.apply(this);this.loadContents();this.outsideViewport||this.minimizeControl();this.redraw();return this.div},clearLayersArray:function(a){var b=this[a+"Layers"];if(b)for(var c=0,d=b.length;c<d;c++){var e=b[c];OpenLayers.Event.stopObservingElement(e.inputElem);OpenLayers.Event.stopObservingElement(e.labelSpan)}this[a+"LayersDiv"].innerHTML="";this[a+"Layers"]=[]},checkRedraw:function(){var a=false;if(!this.layerStates.length||this.map.layers.length!=
this.layerStates.length)a=true;else for(var b=0,c=this.layerStates.length;b<c;b++){var d=this.layerStates[b],e=this.map.layers[b];if(d.name!=e.name||d.inRange!=e.inRange||d.id!=e.id||d.visibility!=e.visibility){a=true;break}}return a},redraw:function(){if(!this.checkRedraw())return this.div;this.clearLayersArray("base");this.clearLayersArray("data");var a=false,b=false,c=this.map.layers.length;this.layerStates=Array(c);for(var d=0;d<c;d++){var e=this.map.layers[d];this.layerStates[d]={name:e.name,
visibility:e.visibility,inRange:e.inRange,id:e.id}}var f=this.map.layers.slice();this.ascending||f.reverse();d=0;for(c=f.length;d<c;d++){e=f[d];var g=e.isBaseLayer;if(e.displayInLayerSwitcher){if(g)b=true;else a=true;var h=g?e==this.map.baseLayer:e.getVisibility(),j=document.createElement("input");j.id=this.id+"_input_"+e.name;j.name=g?this.id+"_baseLayers":e.name;j.type=g?"radio":"checkbox";j.value=e.name;j.checked=h;j.defaultChecked=h;if(!g&&!e.inRange)j.disabled=true;var i={inputElem:j,layer:e,
layerSwitcher:this};OpenLayers.Event.observe(j,"mouseup",OpenLayers.Function.bindAsEventListener(this.onInputClick,i));h=document.createElement("span");OpenLayers.Element.addClass(h,"labelSpan");if(!g&&!e.inRange)h.style.color="gray";h.innerHTML=e.name;h.style.verticalAlign=g?"bottom":"baseline";OpenLayers.Event.observe(h,"click",OpenLayers.Function.bindAsEventListener(this.onInputClick,i));i=document.createElement("br");(g?this.baseLayers:this.dataLayers).push({layer:e,inputElem:j,labelSpan:h});
e=g?this.baseLayersDiv:this.dataLayersDiv;e.appendChild(j);e.appendChild(h);e.appendChild(i)}}this.dataLbl.style.display=a?"":"none";this.baseLbl.style.display=b?"":"none";return this.div},onInputClick:function(a){if(!this.inputElem.disabled)if(this.inputElem.type=="radio"){this.inputElem.checked=true;this.layer.map.setBaseLayer(this.layer)}else{this.inputElem.checked=!this.inputElem.checked;this.layerSwitcher.updateMap()}OpenLayers.Event.stop(a)},onLayerClick:function(){this.updateMap()},updateMap:function(){for(var a=
0,b=this.baseLayers.length;a<b;a++){var c=this.baseLayers[a];c.inputElem.checked&&this.map.setBaseLayer(c.layer,false)}a=0;for(b=this.dataLayers.length;a<b;a++){c=this.dataLayers[a];c.layer.setVisibility(c.inputElem.checked)}},maximizeControl:function(a){this.div.style.width="";this.div.style.height="";this.showControls(false);a!=null&&OpenLayers.Event.stop(a)},minimizeControl:function(a){this.div.style.width="0px";this.div.style.height="0px";this.showControls(true);a!=null&&OpenLayers.Event.stop(a)},
showControls:function(a){this.maximizeDiv.style.display=a?"":"none";this.minimizeDiv.style.display=a?"none":"";this.layersDiv.style.display=a?"none":""},loadContents:function(){OpenLayers.Event.observe(this.div,"mouseup",OpenLayers.Function.bindAsEventListener(this.mouseUp,this));OpenLayers.Event.observe(this.div,"click",this.ignoreEvent);OpenLayers.Event.observe(this.div,"mousedown",OpenLayers.Function.bindAsEventListener(this.mouseDown,this));OpenLayers.Event.observe(this.div,"dblclick",this.ignoreEvent);
this.layersDiv=document.createElement("div");this.layersDiv.id=this.id+"_layersDiv";OpenLayers.Element.addClass(this.layersDiv,"layersDiv");this.baseLbl=document.createElement("div");this.baseLbl.innerHTML=OpenLayers.i18n("Base Layer");OpenLayers.Element.addClass(this.baseLbl,"baseLbl");this.baseLayersDiv=document.createElement("div");OpenLayers.Element.addClass(this.baseLayersDiv,"baseLayersDiv");this.dataLbl=document.createElement("div");this.dataLbl.innerHTML=OpenLayers.i18n("Overlays");OpenLayers.Element.addClass(this.dataLbl,
"dataLbl");this.dataLayersDiv=document.createElement("div");OpenLayers.Element.addClass(this.dataLayersDiv,"dataLayersDiv");if(this.ascending){this.layersDiv.appendChild(this.baseLbl);this.layersDiv.appendChild(this.baseLayersDiv);this.layersDiv.appendChild(this.dataLbl);this.layersDiv.appendChild(this.dataLayersDiv)}else{this.layersDiv.appendChild(this.dataLbl);this.layersDiv.appendChild(this.dataLayersDiv);this.layersDiv.appendChild(this.baseLbl);this.layersDiv.appendChild(this.baseLayersDiv)}this.div.appendChild(this.layersDiv);
if(this.roundedCorner){OpenLayers.Rico.Corner.round(this.div,{corners:"tl bl",bgColor:"transparent",color:this.roundedCornerColor,blend:false});OpenLayers.Rico.Corner.changeOpacity(this.layersDiv,0.75)}var a=OpenLayers.Util.getImagesLocation(),b=new OpenLayers.Size(18,18);this.maximizeDiv=OpenLayers.Util.createAlphaImageDiv("OpenLayers_Control_MaximizeDiv",null,b,a+"layer-switcher-maximize.png","absolute");OpenLayers.Element.addClass(this.maximizeDiv,"maximizeDiv");this.maximizeDiv.style.display=
"none";OpenLayers.Event.observe(this.maximizeDiv,"click",OpenLayers.Function.bindAsEventListener(this.maximizeControl,this));this.div.appendChild(this.maximizeDiv);a+="layer-switcher-minimize.png";b=new OpenLayers.Size(18,18);this.minimizeDiv=OpenLayers.Util.createAlphaImageDiv("OpenLayers_Control_MinimizeDiv",null,b,a,"absolute");OpenLayers.Element.addClass(this.minimizeDiv,"minimizeDiv");this.minimizeDiv.style.display="none";OpenLayers.Event.observe(this.minimizeDiv,"click",OpenLayers.Function.bindAsEventListener(this.minimizeControl,
this));this.div.appendChild(this.minimizeDiv)},ignoreEvent:function(a){OpenLayers.Event.stop(a)},mouseDown:function(a){this.isMouseDown=true;this.ignoreEvent(a)},mouseUp:function(a){if(this.isMouseDown){this.isMouseDown=false;this.ignoreEvent(a)}},CLASS_NAME:"OpenLayers.Control.LayerSwitcher"});
OpenLayers.Format.WFS=OpenLayers.Class(OpenLayers.Format.GML,{layer:null,wfsns:"http://www.opengis.net/wfs",ogcns:"http://www.opengis.net/ogc",initialize:function(a,b){OpenLayers.Format.GML.prototype.initialize.apply(this,[a]);this.layer=b;if(this.layer.featureNS)this.featureNS=this.layer.featureNS;if(this.layer.options.geometry_column)this.geometryName=this.layer.options.geometry_column;if(this.layer.options.typename)this.featureName=this.layer.options.typename},write:function(a){var b=this.createElementNS(this.wfsns,
"wfs:Transaction");b.setAttribute("version","1.0.0");b.setAttribute("service","WFS");for(var c=0;c<a.length;c++)switch(a[c].state){case OpenLayers.State.INSERT:b.appendChild(this.insert(a[c]));break;case OpenLayers.State.UPDATE:b.appendChild(this.update(a[c]));break;case OpenLayers.State.DELETE:b.appendChild(this.remove(a[c]))}return OpenLayers.Format.XML.prototype.write.apply(this,[b])},createFeatureXML:function(a){var b=this.buildGeometryNode(a.geometry),c=this.createElementNS(this.featureNS,"feature:"+
this.geometryName);c.appendChild(b);b=this.createElementNS(this.featureNS,"feature:"+this.featureName);b.appendChild(c);for(var d in a.attributes){c=this.createTextNode(a.attributes[d]);var e=d;if(d.search(":")!=-1)e=d.split(":")[1];e=this.createElementNS(this.featureNS,"feature:"+e);e.appendChild(c);b.appendChild(e)}return b},insert:function(a){var b=this.createElementNS(this.wfsns,"wfs:Insert");b.appendChild(this.createFeatureXML(a));return b},update:function(a){a.fid||OpenLayers.Console.userError(OpenLayers.i18n("noFID"));
var b=this.createElementNS(this.wfsns,"wfs:Update");b.setAttribute("typeName",this.featurePrefix+":"+this.featureName);b.setAttribute("xmlns:"+this.featurePrefix,this.featureNS);var c=this.createElementNS(this.wfsns,"wfs:Property"),d=this.createElementNS(this.wfsns,"wfs:Name"),e=this.createTextNode(this.geometryName);d.appendChild(e);c.appendChild(d);d=this.createElementNS(this.wfsns,"wfs:Value");e=this.buildGeometryNode(a.geometry);a.layer&&e.setAttribute("srsName",a.layer.projection.getCode());
d.appendChild(e);c.appendChild(d);b.appendChild(c);for(var f in a.attributes){c=this.createElementNS(this.wfsns,"wfs:Property");d=this.createElementNS(this.wfsns,"wfs:Name");d.appendChild(this.createTextNode(f));c.appendChild(d);d=this.createElementNS(this.wfsns,"wfs:Value");d.appendChild(this.createTextNode(a.attributes[f]));c.appendChild(d);b.appendChild(c)}c=this.createElementNS(this.ogcns,"ogc:Filter");f=this.createElementNS(this.ogcns,"ogc:FeatureId");f.setAttribute("fid",a.fid);c.appendChild(f);
b.appendChild(c);return b},remove:function(a){if(!a.fid){OpenLayers.Console.userError(OpenLayers.i18n("noFID"));return false}var b=this.createElementNS(this.wfsns,"wfs:Delete");b.setAttribute("typeName",this.featurePrefix+":"+this.featureName);b.setAttribute("xmlns:"+this.featurePrefix,this.featureNS);var c=this.createElementNS(this.ogcns,"ogc:Filter"),d=this.createElementNS(this.ogcns,"ogc:FeatureId");d.setAttribute("fid",a.fid);c.appendChild(d);b.appendChild(c);return b},destroy:function(){this.layer=
null},CLASS_NAME:"OpenLayers.Format.WFS"});OpenLayers.Lang.el=OpenLayers.Util.applyDefaults({"Scale = 1 : ${scaleDenom}":"\u039a\u03bb\u03af\u03bc\u03b1\u03ba\u03b1 ~ 1 : ${scaleDenom}"});(function(){if(!window.console||!console.firebug){var a=["log","debug","info","warn","error","assert","dir","dirxml","group","groupEnd","time","timeEnd","count","trace","profile","profileEnd"];window.console={};for(var b=0;b<a.length;++b)window.console[a[b]]=function(){}}})();
OpenLayers.Format.Atom=OpenLayers.Class(OpenLayers.Format.XML,{namespaces:{atom:"http://www.w3.org/2005/Atom",georss:"http://www.georss.org/georss"},feedTitle:"untitled",defaultEntryTitle:"untitled",gmlParser:null,xy:false,read:function(a){if(typeof a=="string")a=OpenLayers.Format.XML.prototype.read.apply(this,[a]);return this.parseFeatures(a)},write:function(a){var b;if(OpenLayers.Util.isArray(a)){b=this.createElementNSPlus("atom:feed");b.appendChild(this.createElementNSPlus("atom:title",{value:this.feedTitle}));
for(var c=0,d=a.length;c<d;c++)b.appendChild(this.buildEntryNode(a[c]))}else b=this.buildEntryNode(a);return OpenLayers.Format.XML.prototype.write.apply(this,[b])},buildContentNode:function(a){var b=this.createElementNSPlus("atom:content",{attributes:{type:a.type||null}});if(a.src)b.setAttribute("src",a.src);else if(a.type=="text"||a.type==null)b.appendChild(this.createTextNode(a.value));else if(a.type=="html"){if(typeof a.value!="string")throw"HTML content must be in form of an escaped string";b.appendChild(this.createTextNode(a.value))}else if(a.type==
"xhtml")b.appendChild(a.value);else a.type=="xhtml"||a.type.match(/(\+|\/)xml$/)?b.appendChild(a.value):b.appendChild(this.createTextNode(a.value));return b},buildEntryNode:function(a){var b=a.attributes,c=b.atom||{},d=this.createElementNSPlus("atom:entry");if(c.authors)for(var e=OpenLayers.Util.isArray(c.authors)?c.authors:[c.authors],f=0,g=e.length;f<g;f++)d.appendChild(this.buildPersonConstructNode("author",e[f]));if(c.categories){e=OpenLayers.Util.isArray(c.categories)?c.categories:[c.categories];
var h;f=0;for(g=e.length;f<g;f++){h=e[f];d.appendChild(this.createElementNSPlus("atom:category",{attributes:{term:h.term,scheme:h.scheme||null,label:h.label||null}}))}}c.content&&d.appendChild(this.buildContentNode(c.content));if(c.contributors){e=OpenLayers.Util.isArray(c.contributors)?c.contributors:[c.contributors];f=0;for(g=e.length;f<g;f++)d.appendChild(this.buildPersonConstructNode("contributor",e[f]))}a.fid&&d.appendChild(this.createElementNSPlus("atom:id",{value:a.fid}));if(c.links){e=OpenLayers.Util.isArray(c.links)?
c.links:[c.links];f=0;for(g=e.length;f<g;f++){h=e[f];d.appendChild(this.createElementNSPlus("atom:link",{attributes:{href:h.href,rel:h.rel||null,type:h.type||null,hreflang:h.hreflang||null,title:h.title||null,length:h.length||null}}))}}c.published&&d.appendChild(this.createElementNSPlus("atom:published",{value:c.published}));c.rights&&d.appendChild(this.createElementNSPlus("atom:rights",{value:c.rights}));if(c.summary||b.description)d.appendChild(this.createElementNSPlus("atom:summary",{value:c.summary||
b.description}));d.appendChild(this.createElementNSPlus("atom:title",{value:c.title||b.title||this.defaultEntryTitle}));c.updated&&d.appendChild(this.createElementNSPlus("atom:updated",{value:c.updated}));if(a.geometry){b=this.createElementNSPlus("georss:where");b.appendChild(this.buildGeometryNode(a.geometry));d.appendChild(b)}return d},initGmlParser:function(){this.gmlParser=new OpenLayers.Format.GML.v3({xy:this.xy,featureNS:"http://example.com#feature",internalProjection:this.internalProjection,
externalProjection:this.externalProjection})},buildGeometryNode:function(a){this.gmlParser||this.initGmlParser();return this.gmlParser.writeNode("feature:_geometry",a).firstChild},buildPersonConstructNode:function(a,b){var c=["uri","email"],d=this.createElementNSPlus("atom:"+a);d.appendChild(this.createElementNSPlus("atom:name",{value:b.name}));for(var e=0,f=c.length;e<f;e++)b[c[e]]&&d.appendChild(this.createElementNSPlus("atom:"+c[e],{value:b[c[e]]}));return d},getFirstChildValue:function(a,b,c,
d){return(a=this.getElementsByTagNameNS(a,b,c))&&a.length>0?this.getChildValue(a[0],d):d},parseFeature:function(a){var b={},c=null,d=null,e=null,f=this.namespaces.atom;this.parsePersonConstructs(a,"author",b);d=this.getElementsByTagNameNS(a,f,"category");if(d.length>0)b.categories=[];for(var g=0,h=d.length;g<h;g++){c={};c.term=d[g].getAttribute("term");if(e=d[g].getAttribute("scheme"))c.scheme=e;if(e=d[g].getAttribute("label"))c.label=e;b.categories.push(c)}d=this.getElementsByTagNameNS(a,f,"content");
if(d.length>0){c={};if(e=d[0].getAttribute("type"))c.type=e;if(e=d[0].getAttribute("src"))c.src=e;else{c.value=c.type=="text"||c.type=="html"||c.type==null?this.getFirstChildValue(a,f,"content",null):c.type=="xhtml"||c.type.match(/(\+|\/)xml$/)?this.getChildEl(d[0]):this.getFirstChildValue(a,f,"content",null);b.content=c}}this.parsePersonConstructs(a,"contributor",b);b.id=this.getFirstChildValue(a,f,"id",null);d=this.getElementsByTagNameNS(a,f,"link");if(d.length>0)b.links=Array(d.length);var j=["rel",
"type","hreflang","title","length"];g=0;for(h=d.length;g<h;g++){c={};c.href=d[g].getAttribute("href");for(var i=0,k=j.length;i<k;i++)if(e=d[g].getAttribute(j[i]))c[j[i]]=e;b.links[g]=c}if(c=this.getFirstChildValue(a,f,"published",null))b.published=c;if(c=this.getFirstChildValue(a,f,"rights",null))b.rights=c;if(c=this.getFirstChildValue(a,f,"summary",null))b.summary=c;b.title=this.getFirstChildValue(a,f,"title",null);b.updated=this.getFirstChildValue(a,f,"updated",null);c={title:b.title,description:b.summary,
atom:b};a=this.parseLocations(a)[0];a=new OpenLayers.Feature.Vector(a,c);a.fid=b.id;return a},parseFeatures:function(a){var b=[],c=this.getElementsByTagNameNS(a,this.namespaces.atom,"entry");if(c.length==0)c=[a];a=0;for(var d=c.length;a<d;a++)b.push(this.parseFeature(c[a]));return b},parseLocations:function(a){var b=this.namespaces.georss,c={components:[]},d=this.getElementsByTagNameNS(a,b,"where");if(d&&d.length>0){this.gmlParser||this.initGmlParser();for(var e=0,f=d.length;e<f;e++)this.gmlParser.readChildNodes(d[e],
c)}c=c.components;if((d=this.getElementsByTagNameNS(a,b,"point"))&&d.length>0){e=0;for(f=d.length;e<f;e++){var g=OpenLayers.String.trim(d[e].firstChild.nodeValue).split(/\s+/);if(g.length!=2)g=OpenLayers.String.trim(d[e].firstChild.nodeValue).split(/\s*,\s*/);c.push(new OpenLayers.Geometry.Point(parseFloat(g[1]),parseFloat(g[0])))}}var h=this.getElementsByTagNameNS(a,b,"line");if(h&&h.length>0){var j;e=0;for(f=h.length;e<f;e++){d=OpenLayers.String.trim(h[e].firstChild.nodeValue).split(/\s+/);j=[];
for(var i=0,k=d.length;i<k;i+=2){g=new OpenLayers.Geometry.Point(parseFloat(d[i+1]),parseFloat(d[i]));j.push(g)}c.push(new OpenLayers.Geometry.LineString(j))}}if((a=this.getElementsByTagNameNS(a,b,"polygon"))&&a.length>0){e=0;for(f=a.length;e<f;e++){d=OpenLayers.String.trim(a[e].firstChild.nodeValue).split(/\s+/);j=[];i=0;for(k=d.length;i<k;i+=2){g=new OpenLayers.Geometry.Point(parseFloat(d[i+1]),parseFloat(d[i]));j.push(g)}c.push(new OpenLayers.Geometry.Polygon([new OpenLayers.Geometry.LinearRing(c)]))}}if(this.internalProjection&&
this.externalProjection){e=0;for(f=c.length;e<f;e++)c[e]&&c[e].transform(this.externalProjection,this.internalProjection)}return c},parsePersonConstructs:function(a,b,c){var d=[],e=this.namespaces.atom;a=this.getElementsByTagNameNS(a,e,b);for(var f=["uri","email"],g=0,h=a.length;g<h;g++){var j={};j.name=this.getFirstChildValue(a[g],e,"name",null);for(var i=0,k=f.length;i<k;i++){var l=this.getFirstChildValue(a[g],e,f[i],null);if(l)j[f[i]]=l}d.push(j)}if(d.length>0)c[b+"s"]=d},CLASS_NAME:"OpenLayers.Format.Atom"});
OpenLayers.Control.KeyboardDefaults=OpenLayers.Class(OpenLayers.Control,{autoActivate:true,slideFactor:75,draw:function(){this.handler=new OpenLayers.Handler.Keyboard(this,{keydown:this.defaultKeyPress})},defaultKeyPress:function(a){switch(a.keyCode){case OpenLayers.Event.KEY_LEFT:this.map.pan(-this.slideFactor,0);break;case OpenLayers.Event.KEY_RIGHT:this.map.pan(this.slideFactor,0);break;case OpenLayers.Event.KEY_UP:this.map.pan(0,-this.slideFactor);break;case OpenLayers.Event.KEY_DOWN:this.map.pan(0,
this.slideFactor);break;case 33:a=this.map.getSize();this.map.pan(0,-0.75*a.h);break;case 34:a=this.map.getSize();this.map.pan(0,0.75*a.h);break;case 35:a=this.map.getSize();this.map.pan(0.75*a.w,0);break;case 36:a=this.map.getSize();this.map.pan(-0.75*a.w,0);break;case 43:case 61:case 187:case 107:this.map.zoomIn();break;case 45:case 109:case 189:case 95:this.map.zoomOut()}},CLASS_NAME:"OpenLayers.Control.KeyboardDefaults"});
OpenLayers.Feature.WFS=OpenLayers.Class(OpenLayers.Feature,{initialize:function(a,b){var c=arguments;c=this.processXMLNode(b);c=[a,c.lonlat,c];OpenLayers.Feature.prototype.initialize.apply(this,c);this.createMarker();this.layer.addMarker(this.marker)},destroy:function(){this.marker!=null&&this.layer.removeMarker(this.marker);OpenLayers.Feature.prototype.destroy.apply(this,arguments)},processXMLNode:function(a){a=OpenLayers.Ajax.getElementsByTagNameNS(a,"http://www.opengis.net/gml","gml","Point");
a=OpenLayers.Util.getXmlNodeValue(OpenLayers.Ajax.getElementsByTagNameNS(a[0],"http://www.opengis.net/gml","gml","coordinates")[0]).split(",");return{lonlat:new OpenLayers.LonLat(parseFloat(a[0]),parseFloat(a[1])),id:null}},CLASS_NAME:"OpenLayers.Feature.WFS"});
OpenLayers.Format.WMTSCapabilities.v1_0_0=OpenLayers.Class(OpenLayers.Format.OWSCommon.v1_1_0,{version:"1.0.0",namespaces:{ows:"http://www.opengis.net/ows/1.1",wmts:"http://www.opengis.net/wmts/1.0",xlink:"http://www.w3.org/1999/xlink"},yx:null,defaultPrefix:"wmts",initialize:function(a){OpenLayers.Format.XML.prototype.initialize.apply(this,[a]);this.options=a;a=OpenLayers.Util.extend({},OpenLayers.Format.WMTSCapabilities.prototype.yx);this.yx=OpenLayers.Util.extend(a,this.yx)},read:function(a){if(typeof a==
"string")a=OpenLayers.Format.XML.prototype.read.apply(this,[a]);if(a&&a.nodeType==9)a=a.documentElement;var b={};this.readNode(a,b);b.version=this.version;return b},readers:{wmts:{Capabilities:function(a,b){this.readChildNodes(a,b)},Contents:function(a,b){b.contents={};b.contents.layers=[];b.contents.tileMatrixSets={};this.readChildNodes(a,b.contents)},Layer:function(a,b){var c={styles:[],formats:[],tileMatrixSetLinks:[]};c.layers=[];this.readChildNodes(a,c);b.layers.push(c)},Style:function(a,b){var c=
{};c.isDefault=a.getAttribute("isDefault")==="true";this.readChildNodes(a,c);b.styles.push(c)},Format:function(a,b){b.formats.push(this.getChildValue(a))},TileMatrixSetLink:function(a,b){var c={};this.readChildNodes(a,c);b.tileMatrixSetLinks.push(c)},TileMatrixSet:function(a,b){if(b.layers){var c={matrixIds:[]};this.readChildNodes(a,c);b.tileMatrixSets[c.identifier]=c}else b.tileMatrixSet=this.getChildValue(a)},TileMatrix:function(a,b){var c={supportedCRS:b.supportedCRS};this.readChildNodes(a,c);
b.matrixIds.push(c)},ScaleDenominator:function(a,b){b.scaleDenominator=parseFloat(this.getChildValue(a))},TopLeftCorner:function(a,b){var c=this.getChildValue(a).split(" "),d;if(b.supportedCRS)d=!!this.yx[b.supportedCRS.replace(/urn:ogc:def:crs:(\w+):.+:(\w+)$/,"urn:ogc:def:crs:$1::$2")];b.topLeftCorner=d?new OpenLayers.LonLat(c[1],c[0]):new OpenLayers.LonLat(c[0],c[1])},TileWidth:function(a,b){b.tileWidth=parseInt(this.getChildValue(a))},TileHeight:function(a,b){b.tileHeight=parseInt(this.getChildValue(a))},
MatrixWidth:function(a,b){b.matrixWidth=parseInt(this.getChildValue(a))},MatrixHeight:function(a,b){b.matrixHeight=parseInt(this.getChildValue(a))},ResourceURL:function(a,b){b.resourceUrl=b.resourceUrl||{};b.resourceUrl[a.getAttribute("resourceType")]={format:a.getAttribute("format"),template:a.getAttribute("template")}},WSDL:function(a,b){b.wsdl={};b.wsdl.href=a.getAttribute("xlink:href")},ServiceMetadataURL:function(a,b){b.serviceMetadataUrl={};b.serviceMetadataUrl.href=a.getAttribute("xlink:href")}},
ows:OpenLayers.Format.OWSCommon.v1_1_0.prototype.readers.ows},CLASS_NAME:"OpenLayers.Format.WMTSCapabilities.v1_0_0"});
