// Uses zoomlevel en mouseposition to call the nodelist.py view. View returns nodes in json format which is read and printed in document element.
function getNodeList(zoomlevel, mousepos) {
  $.getJSON("/website/nodelist/" + zoomlevel + "," + mousepos.lat + "," + mousepos.lon, 
    function(json) {
      content = 'Wireless Leiden nodes on mouseposition:<br /><b>';
      $.each(json, function(i,json){
        content += json.fields.ssid;
      });
      content += '</br>';
      $("#node_list").html(content);
    }
  );
}

// set filter values
$(document).ready(function() {

  // Fastest?: http://stackoverflow.com/questions/170986/what-is-the-best-way-to-add-options-to-a-select-from-an-array-with-jquery
  $.getJSON("/website/foofilter/",
    function(json) {
      $.each(json, function(i,json){
        $("<option value='"  + json.gebruiker + "'>" + json.gebruiker + "</option>").appendTo("#select_user");
        $.each(json.meetrondje, function(m, meetrondje){
          $("<option class='" + json.gebruiker + "' value='" + meetrondje.naam + "'>"+ meetrondje.naam + "</option>").appendTo("#select_dataset");
          $.each(meetrondje.nodes, function(n, nodes){
            $("<option class='" + meetrondje.naam + "' value='" + nodes + "'>" + nodes + "</option>").appendTo("#select_node");
          });
//          $("<option>" + meetrondje.datum + "</option>").appendTo("#select_date");
        });
      });
// Initiate the chain
    $("#select_dataset").chained("#select_user");
    $("#select_node").chained("#select_dataset");
    }
  );
});

// add filter
$(function(){
  $('#add_filter').click(function(){

    user = $('#select_user option:selected').text();
    dataset = $('#select_dataset option:selected').text();
    wlnode = $('#select_node option:selected').text();
    enc = $('#select_enc option:selected').text();
    date = $('#select_date option:selected').text();
    colour = encodeURIComponent(document.getElementById("colour").value);
    lname = encodeURIComponent(document.getElementById("lname").value);

    if (user != 'All'){user='&meetrondje__gebruiker__naam='+user;}
    else{user='';}
    if (dataset != 'All'){dataset='&meetrondje__naam='+dataset;} 
    else{dataset='';}
    if (wlnode != 'All'){wlnode='&accespoint__ssid='+wlnode;} 
    else{wlnode='';}
    if (enc != ''){enc='&accespoint__encryptie='+enc;} 
    if (date != 'All'){date='&meetrondje__datum='+date;} 
    else{date='';}
    if (colour != ''){colour='colour='+colour;} 
    else {colour = '&colour='+Math.floor(Math.random()*256)+','+Math.floor(Math.random()*256)+','+Math.floor(Math.random()*256);}
    if (lname != ''){lname=lname;} 
    else {lname = 'Custom Filter';}

    var baseurl = "/website/tile/${z}/${x},${y}.png?";

    OpenLayers.Layer.OSM.Overlay = OpenLayers.Class(OpenLayers.Layer.OSM, {
      initialize: function(name, options) {
        var url = [
          baseurl + colour + user + dataset + wlnode + enc + date
        ];
        document.getElementById('filter_text').innerHTML+="<br />Added: " + url;
        options = OpenLayers.Util.extend({ numZoomLevels: 21 }, options);
        var newArguments = [name, url, options];
        OpenLayers.Layer.OSM.prototype.initialize.apply(this, newArguments);
      },
    CLASS_NAME: "OpenLayers.Layer.Overlay"
    });

    filterlayer = new OpenLayers.Layer.OSM.Overlay(lname, {isBaseLayer: false, visibility: true});
    map.addLayer(filterlayer);
  });
});
