#!/usr/bin/env python
#
# View serving available WirelessLeiden Nodes in list on mouseover.
#
# Dennis Wagenaar
# d.wagenaar@gmail.com

from django.core.management import setup_environ
from django.db.models import Max
from django.http import HttpResponse
from django.core import serializers
from gheat.models import *
import logging
import pygame
import sys
import tempfile

def make_list(swlat,swlon,nelat,nelon):
  import simplejson

  filter = {}
  filter.update({
    'accespoint__ssid__contains' : 'WirelessLeiden',
    'latitude__lt' : swlat,
    'longitude__lt' : swlon,
    'latitude__gt' : nelat,
    'longitude__gt' : nelon
  })

  html = Meting.objects.filter(**filter).values('accespoint__ssid').distinct()
  nodelist = simplejson.dumps(list(html))
  return HttpResponse(nodelist, content_type = 'application/javascript; charset=utf8')

def serve_nodelist(request,swlat,swlon,nelat,nelon):
  html = make_list(float(swlat),float(swlon),float(nelat),float(nelon))
  return HttpResponse(html)

