function init(){

	var projection_wgs = new OpenLayers.Projection("EPSG:4326"); // WGS 1984

	map = new OpenLayers.Map('heatmap', {
		controls: [
				new OpenLayers.Control.Navigation(),
				new OpenLayers.Control.PanZoomBar(),
				new OpenLayers.Control.ScaleLine(),
				new OpenLayers.Control.LayerSwitcher(),
				new OpenLayers.Control.MousePosition({ 'displayProjection' : projection_wgs }),
		],
		maxExtent: new OpenLayers.Bounds(-20037508.3427892,-20037508.3427892,20037508.3427892,20037508.3427892), 
		numZoomLevels:16, 
		maxResolution:156543.0339, 
		units:'m', 
		projection: "EPSG:900913",
		displayProjection: new OpenLayers.Projection("EPSG:4326")
	});

	map.events.register('click', map, GetMousePos);
	function GetMousePos(pos) {
		var pixel = new OpenLayers.Pixel(pos.xy.x,pos.xy.y);
		var lonlat = map.getLonLatFromPixel(pixel);
		var mousepos = OpenLayers.Layer.SphericalMercator.inverseMercator(lonlat.lon, lonlat.lat);
		loadNodeList(mousepos);
	}

	layerMapnik = new OpenLayers.Layer.OSM.Mapnik("Mapnik");
	map.addLayer(layerMapnik);
	layerHeatmap = new OpenLayers.Layer.OSM.Overlay1("Overlay 1", {isBaseLayer: false, visibility: true});
	map.addLayer(layerHeatmap);

	layerHeatmap2 = new OpenLayers.Layer.OSM.Overlay2("All Access points", {isBaseLayer: false, visibility: true});
	map.addLayer(layerHeatmap2);

	layerHeatmap3 = new OpenLayers.Layer.OSM.Overlay3("Wireless Leiden Only", {isBaseLayer: false, visibility: true});
	map.addLayer(layerHeatmap3);
	
	var lon   = 4.48907;
	var lat   = 52.158431;
	var zoom  = 16;

	var lonLat = new OpenLayers.LonLat(lon, lat).transform(new OpenLayers.Projection("EPSG:4326"), map.getProjectionObject());
	map.setCenter (lonLat, zoom);
}

function loadNodeList(mousepos){
  var nodelist;
  if (window.XMLHttpRequest){
    // code for IE7+, Firefox, Chrome, Opera, Safari
    nodelist=new XMLHttpRequest();
  }
  else{
    // code for IE6, IE5
    nodelist=new ActiveXObject("Microsoft.XMLHTTP");
  }

  nodelist.onreadystatechange=function(){
    if (nodelist.readyState==4 && nodelist.status==200){
      txt=eval("("+nodelist.responseText+")")
      document.getElementById('nodelist').innerHTML=txt;
    }
  }

  nodelist.open("GET","/website/nodelist/" + mousepos.lat + "," + mousepos.lon,true);
  nodelist.send();
}
