from django.db import models
from gheat import managers
import datetime

class Accespoint(models.Model):
  mac = models.CharField(max_length=17)
  ssid = models.CharField(max_length=64)
  encryptie = models.BooleanField()
  def __unicode__(self):
    return "%s - %s" % (self.mac, self.ssid)

class Gebruiker(models.Model):
  naam = models.CharField(max_length=64)
  email = models.CharField(max_length=64)
  def __unicode__(self):
    return "%s - %s" % (self.naam, self.email)

class Apparatuur(models.Model):
  antenne = models.CharField(max_length=64)
  kaart = models.CharField(max_length=64)
  def __unicode__(self):
    return "%s - %s" % (self.antenne, self.kaart)

class MeetRondje(models.Model):
  datum = models.DateTimeField()
  naam = models.CharField(max_length=64)
  gebruiker = models.ForeignKey(Gebruiker)
  apparatuur = models.ForeignKey(Apparatuur)
  def __unicode__(self):
    return "%s - %s" % (self.gebruiker.naam, self.naam)

class Meting(models.Model):
  meetrondje = models.ForeignKey(MeetRondje)
  accespoint = models.ForeignKey(Accespoint)
  latitude = models.FloatField(name='Latitude', db_column='lat')
  longitude = models.FloatField(name='Longitude', db_column='lng')
  signaal = models.IntegerField(max_length=3)
  objects = managers.MetingManager()
  def __unicode__(self):
    return "%s @ %s,%s : %s" % (self.accespoint.ssid, self.latitude, self.longitude, self.signaal)

class Node(models.Model):
  naam = models.CharField(max_length=64)
  ssid = models.CharField(max_length=64)
  latitude = models.FloatField(name='Latitude', db_column='lat')
  longitude = models.FloatField(name='Longitude', db_column='lon')
  def __unicode__(self):
    return "%s - %s - %s - %s" % (self.naam, self.ssid, self.latitude, self.longitude)
