from django.db import models
from gheat import managers
import datetime


class Accespoint(models.Model):
	mac = models.CharField(max_length=17)
	ssid = models.CharField(max_length=64)
	encryptie = models.BooleanField()
	def __unicode__(self):
		return (self.mac, self.ssid)


class Gebruiker(models.Model):
	gebruiker = models.CharField(max_length=64)
	apparatuur = models.CharField(max_length=64)
	def __unicode__(self):
		return (self.gebruiker, self.apparatuur)


class Meting(models.Model):
	accespoint = models.ForeignKey(Accespoint)
	gebruiker = models.ForeignKey(Gebruiker)
	latitude = models.FloatField(name='Latitude', db_column='lat')
	longitude = models.FloatField(name='Longitude', db_column='lng')
	signaal = models.IntegerField(max_length=3)
	datum = models.DateTimeField()

	objects = managers.MetingManager()
