#!/usr/bin/env python
#
# View serving available WirelessLeiden Nodes in list on mouseover.
#
# Dennis Wagenaar
# d.wagenaar@gmail.com

from django.core.management import setup_environ
from django.db.models import Max
from django.http import HttpResponse
from django.core import serializers
from gheat.models import *
from gheat import gmerc
import logging
import pygame
import sys
import tempfile
import simplejson


# todo: Create one single json file with all relevent info needed for filters.  datum - meetrondje - gebruiker
def serve_filter(request, ftype):
  filterlist = ''
  if (ftype == 'filter_node'):
    filterlist = get_node()
  elif (ftype == 'filter_user'):
    filterlist = get_user()
  elif (ftype == 'filter_dataset'):
    filterlist = get_dataset()
  else:
    print 'Invalid filter'
  
  return HttpResponse(filterlist, content_type = 'application/javascript; charset=utf8')


def get_node():

  nodes = Accespoint.objects.filter(ssid__contains='WirelessLeiden').distinct()
  nodelist = serializers.serialize('json', nodes, fields=('ssid'))
  return nodelist


def get_user():

  users = Gebruiker.objects.all()
  userlist = serializers.serialize('json', users, fields=('naam'))
  return userlist


def get_dataset():

  datasets = MeetRondje.objects.all()
  datasetlist = serializers.serialize('json', datasets, fields=('naam', 'gebruiker'))
  return datasetlist
