from django.conf.urls.defaults import *
from django.views.generic.simple import direct_to_template
from django.views.generic.base import TemplateView
from django.conf import settings

class HomeView(TemplateView):
    template_name = 'home.html'

urlpatterns = patterns('',
    ('^$', HomeView.as_view())
)

urlpatterns += patterns('website.tile',
    url(
        # Example : today/fire/12/3,2.png
        regex = r'^tile/(?P<zoom>\d+)/(?P<x>\d+),(?P<y>\d+).png$',
        view = 'serve_tile',
        name = 'serve_tile',
       ),
    )

urlpatterns += patterns('website.osm_proxy',
    url(
        # Example : today/fire/12/3,2.png
        regex = r'^osm-proxy/(?P<zoom>\d+)/(?P<x>\d+),(?P<y>\d+).png$',
        view = 'osm_proxy',
        name = 'osm_proxy',
       ),
    )

urlpatterns += patterns('website.nodelist',
    url(
        regex = r'^nodelist/(?P<zoom>\d+),(?P<lat>[0-9.]+),(?P<lon>[0-9.]+)$',
        view = 'serve_nodelist',
        name = 'serve_nodelist',
       ),
    )
