from django.http import HttpResponse
from gheat.models import Node

import json



def nodes_json(request):
  geojson = []
  for node in Node.objects.filter(**request.REQUEST):
    item = {
        "type": "Feature",
        "properties": {
          'name' : node.name,
          'color' : 'rgb(0,255,0)',
        },
        "geometry": {
            "type": "Point",
            "coordinates": [
                node.latitude,
                node.longitude,
            ]
        }
    }
    geojson.append(item)
  return HttpResponse(json.dumps({'type' : 'FeatureCollection', 'features' : geojson},indent=2), mimetype="text/plain")
