#!/usr/bin/env python
#
###########################################
#
# Script for importing .csv files
#
# In theory, only the -f option is needed, but for overview's sake, please use the others aswell.
# -f = location of the .csv, e.g. '/home/test.csv'
# -m = name of the dataset, e.g. 'Walk in park' or 'Trip with boat'
# -g = your name
# -e = your email address
# -a = antenna
# -k = network card
#
# (Run from project root)
# ./manage.py import_csv -f <file location> -m <dataset name> -g <username> -e <email> - a <antenna> -k <network card>
#
# Make sure the variables in this script match the column numbers in your file e.g.;
# Lat is read from the first column [0], if the lat in your file is in the 4th column, change
# 'lat = row[0]' to 'lat = row[3]'.
# Also, take note of the 'replace()' and 'strip()' functions. These should probably be edited aswell.
#
# Dennis Wagenaar
# d.wagenaar@gmail.com
#
###########################################

from django.core.management import setup_environ
from django.core.management.base import BaseCommand
from optparse import OptionParser, make_option
import settings
setup_environ(settings)
from gheat.models import *
import datetime
import csv

# Function that imports a csv and processes it.
def import_file(location, meetrondje, gebruiker, email, antenne, kaart):

  # Creating some objects that have to be created only once. Uses 'get_or_create' to rule out duplicates.
  # Creating user object. Depends on basecommand options.
  g, created = Gebruiker.objects.get_or_create(naam=gebruiker , email=email)
  # Creating equipment object. Depends on basecomand options.
  a, created = Apparatuur.objects.get_or_create(antenne=antenne , kaart=kaart)
  # Creating dataset object. Depends on baseommand options.
  mr = MeetRondje.objects.create(datum=datetime.datetime.now() , naam=meetrondje , gebruiker=g , apparatuur=a)

  # Open the csv.
  csvfile = csv.reader(open(location, 'rb'), delimiter='\t')
  # Read every row individually and extract the required data.
  for row in csvfile:
    # '.replace' & '.strip' are for replacing and stripping some unwished characters. Edit where necessary.
    lat = row[0].replace('N ', '')
    lon = row[1].replace('E ', '')
    ssid = row[2].strip('( )')
    bssid = row[4].strip('( )')
    enc = row[8]
    if enc[2] == '1': enc = True
    else: enc = False
    sig = 100 # Get's fix soon
    print lat, lon, ssid, bssid, enc, sig

    # Simple check for bad values
    if lat.startswith('0.'):
      print 'Bad lat'
      continue
    elif lon.startswith('0.'):
      print 'Bad lon'
      continue
    elif sig not in range(1,101):
      print 'Bad sig'
      continue
    else:
      print 'No bad values'

    # Creating accespoint objects. Avoiding duplicates.
    ap, created = Accespoint.objects.get_or_create(mac=bssid, ssid=ssid, encryptie=enc)
    # Creating the measurement objects.
    m = Meting.objects.create(meetrondje=mr, accespoint=ap, latitude=lat, longitude=lon, signaal=sig)

# Basecommand with options. This gives the user some control over the execution of this script.
class Command(BaseCommand):
  option_list = BaseCommand.option_list + (
    make_option('-f', '--location', dest='location', default='location'),
    make_option('-m', '--meetrondje', dest='meetrondje', default='rondje'),
    make_option('-g', '--gebruiker', dest='gebruiker', default='username'),
    make_option('-e', '--email', dest='email', default='foo@bar.org'),
    make_option('-a', '--antenne', dest='antenne', default='geen'),
    make_option('-k', '--kaart', dest='kaart', default='interne kaart'),
    )
  
  # The function 'import_file' will be executed with the default option values, or the values specified by the user.
  def handle(self, *args, **options):
    import_file(options['location'],options['meetrondje'],options['gebruiker'],options['email'],options['antenne'],options['kaart'])
