from django.conf.urls.defaults import *
from django.views.generic.simple import direct_to_template
from django.views.generic.base import TemplateView
from django.conf import settings

urlpatterns = patterns('',
    ('^about/$', TemplateView.as_view(template_name='about.html'))
)

class GoogleTemplateView(TemplateView):
  def get_context_data(self, **kwargs):
    context = super(GoogleTemplateView, self).get_context_data(**kwargs)
    context.update({ 'google_key':  settings.GOOGLE_MAPS_KEY })
    return context


urlpatterns = patterns('home.views',
    ('^$', GoogleTemplateView.as_view(template_name='home.html'))
)
