function init(){
	map = new OpenLayers.Map('heatmap', {
		controls: [
				new OpenLayers.Control.Navigation(),
				new OpenLayers.Control.PanZoomBar(),
				new OpenLayers.Control.ScaleLine(),
				new OpenLayers.Control.LayerSwitcher()
		],
		maxExtent: new OpenLayers.Bounds(-20037508.3427892,-20037508.3427892,20037508.3427892,20037508.3427892), 
		numZoomLevels:18, 
		maxResolution:156543.0339, 
		units:'m', 
		projection: "EPSG:900913",
		displayProjection: new OpenLayers.Projection("EPSG:4326")
	});
	
	layerMapnik = new OpenLayers.Layer.OSM.Mapnik("Mapnik");
	map.addLayer(layerMapnik);
	layerHeatmap = new OpenLayers.Layer.OSM.Heatmap("Heatmap", {isBaseLayer: false, visibility: true});
	map.addLayer(layerHeatmap);
	
	var lon   = 4.4585017;
	var lat   = 52.1406583;
	var zoom  = 13;

	var lonLat = new OpenLayers.LonLat(lon, lat).transform(new OpenLayers.Projection("EPSG:4326"), map.getProjectionObject());
	map.setCenter (lonLat, zoom);
}