#!/usr/bin/env python
#
# Reading NS1 files - http://www.stumbler.net/ns1files.html
#
# Rick van der Zwet <info@rickvanderzwet.nl>
#
import sys
import datetime

from struct import *

print ""
fh = open('meting2.ns1','rb')

def get_int32(size=1):
  return unpack('<' + 'i'*size,fh.read(4*size))

def get_uint32(size=1):
  return unpack('<' + 'I'*size,fh.read(4*size))

def get_uint64(size=1):
  return unpack('<' + 'Q'*size,fh.read(8*size))

def get_uint8(size=1):
  return unpack('<' + 'B'*size,fh.read(1*size))

def get_filetime():
  _FILETIME_null_date = datetime.datetime(1601, 1, 1, 0, 0, 0)
  ns = unpack('<Q',fh.read(8))[0] * 10
  sec = ns / 10**8
  d = datetime.timedelta(seconds=sec)
  return _FILETIME_null_date + d

def get_char(size):
  return fh.read(size)

def get_double(size=1):
  return unpack('<' + 'd'*size,fh.read(8*size))


print "dwSignature:", get_char(4)
print "dwFileVerunpack:", get_uint32()
ApCount = get_uint32()[0]
print "ApCount:", ApCount

for a in range(0,ApCount):
  SSIDLength = get_uint8()[0]
  print "SSIDLength:", SSIDLength
  print "SSID:", get_char(SSIDLength)
  print "BSSID:", map(hex,unpack('BBBBBB',fh.read(6)))
  print "MaxSignal:", get_int32()
  print "MinNoise:", get_int32()
  print "MaxSNR:", get_int32()
  print "Flags:", get_uint32()
  print "BeaconInterval:", get_uint32()
  print "FirstSeen:", get_filetime()
  print "LastSeen:", get_filetime()
  print "BestLat:", get_double()
  print "BestLong:", get_double()
  DataCount = get_uint32()[0]
  print "DataCount:", DataCount
  for c in range(0,DataCount):
    print "Time:", get_filetime()
    print "Signal:", get_int32()
    print "Noice:", get_int32()
    LocationSource = get_int32()[0]
    print "Location Source:", LocationSource
    if LocationSource == 1:
      print "Latitude:", get_double()
      print "Longitude:", get_double()
      print "Altitude:", get_double()
      print "NumStats:", get_uint32()
      print "Speed:", get_double()
      print "Track:", get_double()
      print "MagVariation:", get_double()
      print "Hdop:", get_double()
  NameLength = get_uint8()[0]
  print "NameLength:", NameLength
  print "Name:", get_char(NameLength)
  print "Channels:", get_uint64()
  print "LastChannel:", get_uint32()
  print "IPAddress:", get_uint32()
  print "MinSignal:", get_int32()
  print "MaxSignal:", get_int32()
  print "DataRate:", get_uint32()
  print "IPSubnet:", get_uint32()
  print "IPMask:", get_uint32()
  print "ApFlags:", get_uint32()
  IELength = get_uint32()[0]
  print "IELength:", IELength
  print "InformationElements:", get_uint8(IELength)
