/**
 * Var 'map' is set global, used in 'heatmap_extensions.js'.
 */
var map;

function init_heatmap(){
  var lat = getURLParameter('lat');
  var lon = getURLParameter('lon');
  var zoom = getURLParameter('zoom');

  if(lat=='null' || lon=='null' || zoom=='null'){
    var lat   = 52.15514;
    var lon   = 4.48959;
    var zoom  = 13;
  }
  var projection_wgs = new OpenLayers.Projection("EPSG:4326"); // WGS 1984

  map = new OpenLayers.Map('heatmap', {
    theme: null,
    controls: [
      new OpenLayers.Control.Navigation(),
      new OpenLayers.Control.Permalink(),
      new OpenLayers.Control.PanZoomBar(),
      new OpenLayers.Control.ZoomBox(),
      new OpenLayers.Control.OverviewMap({ 
        maximized : false,
        mapOptions: { theme: null, },
      }),
      new OpenLayers.Control.MousePosition({ 'displayProjection' : projection_wgs }),
      /**
       * Decided to disable these controls.
       * The layerswitcher has been replaced with a custom one. If you want the original back,
       * make sure to disable the custom one to prevent collision.
       */

      //new OpenLayers.Control.PanZoomBav(),
      //new OpenLayers.Control.ScaleLine(),
      //new OpenLayers.Control.LayerSwitcher(),
    ],
    maxExtent: new OpenLayers.Bounds(-20037508.3427892,-20037508.3427892,20037508.3427892,20037508.3427892), 
    numZoomLevels:16, 
    maxResolution:156543.0339, 
    units:'m', 
    projection: "EPSG:900913",
    displayProjection: new OpenLayers.Projection("EPSG:4326")
  });

  map.events.register('click', map, GetMousePos);
  function GetMousePos(pos) {
    var pix = map.getLonLatFromPixel(new OpenLayers.Pixel(pos.xy.x,pos.xy.y));
    var mousepos = OpenLayers.Layer.SphericalMercator.inverseMercator(pix.lon, pix.lat);
    var zoomlevel = map.getZoom();
    getNodeList(zoom, mousepos);
  }

  layerMapnik = new OpenLayers.Layer.OSM.Mapnik("Mapnik");
  map.addLayer(layerMapnik);

  layerHeatmap2 = new OpenLayers.Layer.OSM.Overlay2("All Access points", {isBaseLayer: false, visibility: false});
  //map.addLayer(layerHeatmap2);

  signallayer = new OpenLayers.Layer.OSM.Overlay4("signallayer", {isBaseLayer: false, visibility: false});
  map.addLayer(signallayer);

  layerHeatmap3 = new OpenLayers.Layer.OSM.Overlay3("Wireless Leiden Coverage", {isBaseLayer: false, visibility: true});
  map.addLayer(layerHeatmap3);

  layerHeatmap = new OpenLayers.Layer.OSM.Overlay1("Original Heatmap generator", {isBaseLayer: false, visibility: false});
  //map.addLayer(layerHeatmap);

  // create the layer styleMap by giving the default style a context
  var colors = ["red", "green", "blue"];
  var context = {
      getSize: function(feature) {
        var resolution = map.getResolution();
        var scale = map.getZoom();
        var base = 1;
        if (scale > 16) {
          base = 5;
        } else if (scale > 14) {
          base = 20;
        } else {
          base = 50;
        }
        return (base / map.getResolution());
      }
  };
  var template = {
      pointRadius: "${getSize}", // using context.getSize(feature)
      fillColor: "lightgreen", // using context.getColor(feature)
      strokeWidth: 0.5,
  };
  var style = new OpenLayers.Style(template, {context: context});
  var geojson = new OpenLayers.Layer.GML("GeoJSON", "feature/nodes.json", {
    projection: new OpenLayers.Projection("EPSG:4326"),
    styleMap: new OpenLayers.StyleMap(style),
    format: OpenLayers.Format.GeoJSON
      });
  map.addLayer(geojson);


  var lonLat = new OpenLayers.LonLat(lon, lat).transform(new OpenLayers.Projection("EPSG:4326"), map.getProjectionObject());
  map.setCenter (lonLat, zoom);


  /**
   * Layers above are put in switcher, category 'default', with code below.
   * TODO: Make process for putting layers into layerswitcher dynamic instead of putting every layer there manually.
   */

  //$("#default").append("<span id=\"" + layerHeatmap.name + "\"><div id='layer_switcher_colour' style='background-color:rgb(" + layerHeatmap.colour + ")' /><input type=checkbox id=togglelayer /><font>" + layerHeatmap.name + " </font><br /></span>");

  //$("#default").append("<span id=\"" + layerHeatmap2.name + "\"><div id='layer_switcher_colour' style='background-color:rgb(" + layerHeatmap2.colour + ")' /><input type=checkbox id=togglelayer /><font>" + layerHeatmap2.name + " </font><br /></span>");

  $("#default").append("<span id=\"" + signallayer.name + "\"><div id='layer_switcher_colour' style='background-color:rgb(" + signallayer.colour + ")' /><input type=checkbox id=togglelayer /><font>Replaced during init</font><br /></span>");

  $("#default").append("<span id=\"" + layerHeatmap3.name + "\"><div id='layer_switcher_colour' style='background-color:rgb(" + layerHeatmap3.colour + ")' /><input type=checkbox id=togglelayer checked/><font>" + layerHeatmap3.name + " </font><br /></span>");

}
