from gheat.models import Accespoint, Apparatuur, Gebruiker, MeetRondje, Meting, MeetBestand
from django.contrib import admin

class AccespointAdmin(admin.ModelAdmin):
  list_display = ['ssid','mac', 'organization']
  search_fields = ['ssid', 'mac', 'organization']
admin.site.register(Accespoint, AccespointAdmin)

class MeetBestandInline(admin.TabularInline):
  model = MeetBestand
class MeetRondjeAdmin(admin.ModelAdmin):
  inlines = [ MeetBestandInline, ]
admin.site.register(MeetRondje, MeetRondjeAdmin)

admin.site.register(Apparatuur)
admin.site.register(Gebruiker)

class MetingAdmin(admin.ModelAdmin):
  list_display = ['accespoint', 'latitude', 'longitude', 'signaal']
  search_fields = ['accespoint__ssid']
admin.site.register(Meting, MetingAdmin)
