// Uses zoomlevel and mouseposition to call the nodelist.py view. View returns nodes in json format which is read and printed in document element.
function getNodeList(zoomlevel, mousepos) {
  $.getJSON("/website/nodelist/" + zoomlevel + "," + mousepos.lat + "," + mousepos.lon, 
    function(json) {
      content = 'Wireless Leiden nodes on mouseposition:<br /><b>';
      $.each(json, function(i,json){
        content += json.fields.ssid + '<br />';
      });
      content += '</b>';
      $("#node_list").html(content);
    }
  );
}

// set filter values
$(document).ready(function() {

  // Fastest?: http://stackoverflow.com/questions/170986/what-is-the-best-way-to-add-options-to-a-select-from-an-array-with-jquery
  $.getJSON("/website/filters/",
    function(json) {
      $.each(json, function(i,json){
        $("#select_user").append($("<option/>").attr("value",json.gebruiker).text(json.gebruiker));
        $.each(json.meetrondje, function(m, meetrondje){
          $("#select_dataset").append($("<option/>").attr({"class":json.gebruiker, "value":meetrondje.naam}).text(meetrondje.naam));
          $.each(meetrondje.nodes, function(n, nodes){
            $("#select_node").append($("<option/>").attr({"class":meetrondje.naam, "value":nodes}).text(nodes));
          });
        });
      });
    // Initiate the chain
    $("#select_dataset").chained("#select_user");
    $("#select_node").chained("#select_dataset");
    }
  );
});

// add filter
$(function(){
  $('#add_filter').click(function(){

    user = $('#select_user option:selected').text();
    dataset = $('#select_dataset option:selected').text();
    wlnode = $('#select_node option:selected').text();
//    enc = $('#select_enc option:selected').text();
//    date = $('#select_date option:selected').text();
    start_date = $('#start_date').val();
    end_date = $('#end_date').val();
    colour = encodeURIComponent(document.getElementById("colour").value);
    lname = encodeURIComponent(document.getElementById("lname").value);

    // HEX to RGB: http://stackoverflow.com/questions/5798868/need-some-tips-with-how-to-convert-a-hexadecimal-color-value-to-a-rgb-one/5798900#5798900
    // '#' comes out as '%23', so substr() starts at char 3
    colour = parseInt((colour.substr(3, 2)),16) + ',' + parseInt((colour.substr(5, 2)),16) + ',' + parseInt((colour.substr(7, 2)),16);

    if (user != ''){user='&meetrondje__gebruiker__naam='+user;}
    if (dataset != ''){dataset='&meetrondje__naam='+dataset;} 
    if (wlnode != ''){wlnode='&accespoint__ssid='+wlnode;}
//    if (enc != ''){enc='&accespoint__encryptie='+enc;} 
//    if (date != ''){date='&meetrondje__datum='+date;} 
    if (start_date && end_date){
      sd_d=start_date.substr(0,2);
      sd_m=start_date.substr(3,2);
      sd_y=start_date.substr(6,4);

      ed_d=end_date.substr(0,2);
      ed_m=end_date.substr(3,2);
      ed_y=end_date.substr(6,4);

      start_date='&meetrondje__datum__gte=' + sd_y +'-'+ sd_m +'-'+ sd_d;
      end_date='&meetrondje__datum__lte=' + ed_y +'-'+ ed_m +'-'+ ed_d;
    }


    if (colour != 'NaN,NaN,NaN'){colour='colour='+colour;} 
    else {colour = '&colour='+Math.floor(Math.random()*256)+','+Math.floor(Math.random()*256)+','+Math.floor(Math.random()*256);}
    if (lname != ''){lname=lname;} 
    else {lname = 'Custom Filter';}

    var baseurl = "/website/tile/${z}/${x},${y}.png?";

    OpenLayers.Layer.OSM.Overlay = OpenLayers.Class(OpenLayers.Layer.OSM, {
      initialize: function(name, options) {
        var url = [
          baseurl + colour + user + dataset + wlnode + start_date + end_date /* + enc */ 
        ];
        document.getElementById('filter_text').innerHTML+="<br />Added: " + url;
        options = OpenLayers.Util.extend({ numZoomLevels: 21 }, options);
        var newArguments = [name, url, options];
        OpenLayers.Layer.OSM.prototype.initialize.apply(this, newArguments);
      },
    CLASS_NAME: "OpenLayers.Layer.Overlay"
    });

    filterlayer = new OpenLayers.Layer.OSM.Overlay(lname, {isBaseLayer: false, visibility: true});
    map.addLayer(filterlayer);
  });
});
