#!/usr/bin/env python
#
# View serving available WirelessLeiden Nodes in list on mouseover.
#
# Dennis Wagenaar
# d.wagenaar@gmail.com

from django.core.management import setup_environ
from django.db.models import Max
from django.http import HttpResponse
from django.core import serializers
from gheat.models import *
import logging
import pygame
import sys
import tempfile

def make_list(zoom,lat,lon):

  maxlat = (lat + 0.01)
  maxlon = (lon + 0.01)
  minlat = (lat - 0.01)
  minlon = (lon - 0.01)

  filter = {}
  filter.update({
    'ssid__contains' : 'WirelessLeiden',
    'meting__latitude__lt' : maxlat,
    'meting__longitude__lt' : maxlon,
    'meting__latitude__gt' : minlat,
    'meting__longitude__gt' : minlon
  })

  objquery = Accespoint.objects.filter(**filter).distinct()
  nodelist = serializers.serialize('json', objquery, fields=('fields','ssid'))

  return nodelist

def serve_nodelist(request,zoom,lat,lon,):
  html = make_list(int(zoom), float(lat), float(lon))
  return HttpResponse(html, content_type = 'application/javascript; charset=utf8')

