#!/usr/bin/env python
# -*- coding: utf-8 -*-
#
# Script for importing DroidStumbler .csv files
#
# Original by Dennis Wagenaar <d.wagenaar@gmail.com>
#
# Rick van der Zwet <info@rickvanderzwet.nl>
#
from django.core.management import setup_environ
from django.core.management.base import BaseCommand, CommandError
from optparse import OptionParser, make_option
from gheat.models import *
import csv
import datetime
import gzip
import logging
import os
import sys

def import_droidstumbler(location, meetrondje, gebruiker, email, datum,show_progres=False):

  g, created = Gebruiker.objects.get_or_create(naam=gebruiker , email=email)
  a, created = Apparatuur.objects.get_or_create(antenne='buildin' , kaart='mobilePhone')
  mr = MeetRondje.objects.create(datum=datum , naam=meetrondje , gebruiker=g , apparatuur=a)

  if location.endswith('.gz'):
    fh = gzip.open(location,'rb')
  else:
    fh = open(location,'rb')
  csvfile = csv.reader(fh, delimiter=',')
  count = 0
  ap_cache = {}
  for row in csvfile:
    try:
      epoch, msg_type, lat, lon, accuracy, ssid, bssid, level, frequency, capabilities = row
    except ValueError:
      logging.error("Unable to parse line:%i '%s'" % (csvfile.line_num, row))
      continue
    if msg_type == "data" and lat and lon:
      if not ap_cache.has_key(bssid):
        ap_cache[bssid], created = Accespoint.objects.get_or_create(mac=bssid, ssid=ssid, encryptie=capabilities)

      m = Meting.objects.create(meetrondje=mr, accespoint=ap_cache[bssid], latitude=lat, longitude=lon, signaal=(100 + int(level)))
      # Give some feedback to the user
      count += 1
      if show_progres:
        if (count % 1000) == 0:
          sys.stdout.write(str(count))
        elif (count % 100) == 0:
          sys.stdout.write(".")
        sys.stdout.flush()

  if show_progres:
    sys.stdout.write("%s\n" % count)


class Command(BaseCommand):
  args = '<csvfile>[.gz]'
  option_list = BaseCommand.option_list + (
    make_option('-m', '--meetrondje', dest='meetrondje', default=None),
    make_option('-g', '--gebruiker', dest='gebruiker', default=os.environ['USER']),
    make_option('-e', '--email', dest='email', default=os.environ['USER'] + '@example.org'),
    make_option('-d', '--datum', dest='datum', default=None, help="Provide date  \
      in following format: %Y-%m-%d-%H%M%S, by default it will be generated from \
      the filename"),)

  def handle(self, *args, **options):
    try:
      (csv_file,) = args
    except ValueError:
      self.print_help(sys.argv[0],sys.argv[1])
      raise CommandError("Not all arguments are provided")
    if not os.path.isfile(csv_file):
      raise CommandError("csv file '%s' does not exists" % csv_file)

    # Meetrondje from filename if needed
    if options['meetrondje'] == None:
      meetrondje = os.path.basename(csv_file).rstrip('.gz').rstrip('.csv') 
    else:
      meetrondje = options['meetrondje']
    # Date from filename if needed
    if options['datum'] == None:
       datum = os.path.basename(csv_file).lstrip('ScanResult-').rstrip('.csv.gz')
    else:
       datum = options['datum']
    try:
       datum = datetime.datetime.strptime(datum,'%Y-%m-%d-%H%M%S')
    except ValueError:
      logging.error("Invalid date '%s'" % options['datum'])
      sys.exit(1)

    self.stdout.write("Going to import '%s' for gebruiker '%s <%s>'\n" % (os.path.basename(csv_file), options['gebruiker'], options['email']))
    import_droidstumbler(csv_file,meetrondje,options['gebruiker'],options['email'], datum, True)
    self.stdout.writeln("All done, goodbye")
