#!/bin/sh
#
# Quick and dirty hack to import all data

if [ `id -un` != "www" ]; then
  echo "ERROR, run as www user: sudo -E -u www $0"
  exit 1
fi

DATAROOT="/usr/local/var/scan-data"
MAP_CACHE=/usr/local/var/httpd/cache/maps
MANAGE="`dirname $0`/manage.py"
SSH_USER=backup
SSH_KEY="`dirname $0`/id_rsa"
export PYTHON_EGG_CACHE=/tmp/

echo "# rsync webfolder"
rsync -e "ssh -i $SSH_KEY -l $SSH_USER -o StrictHostKeyChecking=no" -az tyan.wirelessleiden.nl:/usr/local/www/webfolder/scan-data/ $DATAROOT || exit 1


echo "# unzip compressed .tar.gz files"
for FILE in `find $DATAROOT -name '*.tar.gz'`; do
  TARDIR=`dirname $FILE`
  if [ \! -r "$TARDIR/`tar -tf $FILE | head -1`" ]; then
    tar -C $TARDIR -xzf $file
  fi
done

ADDED=0
# Import all data
for USERDIR in `find $DATAROOT -depth 1 -type d`; do
  for DEVICEDIR in `find $USERDIR -depth 1 -type d`; do
    USERNAME=`basename $USERDIR`
    DEVICE=`basename $DEVICEDIR`
    ARGS="-g $USERNAME -e $USERNAME@wirelessleiden.nl -k $DEVICE"
    # Kismet Imports
    for FILE in `find $DEVICEDIR -name 'Kismet*gpsxml*'`; do
      $MANAGE import_kismet $ARGS -m `basename $FILE` $FILE
    done
    
    # DroidStumber imports
    for FILE in `find $DEVICEDIR -name 'ScanResult-*'`; do
      $MANAGE import_droidstumbler $ARGS -m `basename $FILE` $FILE
      if [ $? -eq 0 ]; then
        ADDED=1
      fi
    done
  done
done

if [ "$ADDED" -eq 1 ]; then
  echo "# Clear cache $MAP_CACHE"
  htcacheclean -l10K -p$MAP_CACHE 
fi

