#!/usr/bin/env python
#
# View serving available WirelessLeiden Nodes in list on mouseover.
#
# Dennis Wagenaar
# d.wagenaar@gmail.com

from django.core.management import setup_environ
from django.db.models import Max
from django.http import HttpResponse
from django.core import serializers
from gheat.models import *
from gheat import gmerc
import logging
import pygame
import sys
import tempfile


# todo: Create one single json file with all relevent info needed for filters.
def get_filters():

  wlnodes = Accespoint.objects.filter(ssid__contains='WirelessLeiden').distinct()
  wlnodelist = serializers.serialize('json', wlnodes, fields=('ssid'))

  return wlnodelist


def serve_filters(request):

  filterlist = get_filters()
  return HttpResponse(filterlist, content_type = 'application/javascript; charset=utf8')
