from gheat.models import *
from django.contrib import admin

class AccespointAdmin(admin.ModelAdmin):
  list_display = ['ssid','mac', 'organization']
  search_fields = ['ssid', 'mac', 'organization']
  ordering = ['ssid']
admin.site.register(Accespoint, AccespointAdmin)

class MeetBestandInline(admin.TabularInline):
  model = MeetBestand
  readonly_fields = ['is_imported']

class MeetRondjeAdmin(admin.ModelAdmin):
  inlines = [ MeetBestandInline, ]
admin.site.register(MeetRondje, MeetRondjeAdmin)

class NodeAdmin(admin.ModelAdmin):
  list_display = ['name','latitude', 'longitude', 'organization']
  ordering = ['name']
admin.site.register(Node, NodeAdmin)

class OrganizationAdmin(admin.ModelAdmin):
  list_display = ['name', 'fullname']
  ordering = ['name']
admin.site.register(Organization, OrganizationAdmin)

class MeetBestandAdmin(admin.ModelAdmin):
  list_display = ['meetrondje', 'bestand', 'filetype', 'is_imported']
  readonly_fields = ['is_imported']
admin.site.register(MeetBestand, MeetBestandAdmin)

admin.site.register(Apparatuur)
admin.site.register(Gebruiker)

class MetingAdmin(admin.ModelAdmin):
  list_display = ['accespoint', 'latitude', 'longitude', 'signaal']
  search_fields = ['accespoint__ssid']
admin.site.register(Meting, MetingAdmin)
