/**
 * Var 'map' is set global, used in 'heatmap_extensions.js'.
 */
var map;

function init_heatmap(){
  var lat = getURLParameter('lat');
  var lon = getURLParameter('lon');
  var zoom = getURLParameter('zoom');

  if(lat=='null' || lon=='null' || zoom=='null'){
    var lat   = 52.15514;
    var lon   = 4.48959;
    var zoom  = 13;
  }
  var projection_wgs = new OpenLayers.Projection("EPSG:4326"); // WGS 1984

  map = new OpenLayers.Map('heatmap', {
    theme: null,
    controls: [
      new OpenLayers.Control.Navigation(),
      new OpenLayers.Control.Permalink(),
      new OpenLayers.Control.PanZoomBar(),
      new OpenLayers.Control.ZoomBox(),
      new OpenLayers.Control.OverviewMap({ 
        maximized : false,
        mapOptions: { theme: null, },
      }),
      new OpenLayers.Control.MousePosition({ 'displayProjection' : projection_wgs }),
      /**
       * Decided to disable these controls.
       * The layerswitcher has been replaced with a custom one. If you want the original back,
       * make sure to disable the custom one to prevent collision.
       */

      //new OpenLayers.Control.PanZoomBav(),
      //new OpenLayers.Control.ScaleLine(),
      //new OpenLayers.Control.LayerSwitcher(),
    ],
    maxExtent: new OpenLayers.Bounds(-20037508.3427892,-20037508.3427892,20037508.3427892,20037508.3427892), 
    numZoomLevels:16, 
    maxResolution:156543.0339, 
    units:'m', 
    projection: "EPSG:900913",
    displayProjection: new OpenLayers.Projection("EPSG:4326")
  });

  map.events.register('click', map, GetMousePos);
  function GetMousePos(pos) {
    var pix = map.getLonLatFromPixel(new OpenLayers.Pixel(pos.xy.x,pos.xy.y));
    var mousepos = OpenLayers.Layer.SphericalMercator.inverseMercator(pix.lon, pix.lat);
    var zoomlevel = map.getZoom();
    getNodeList(zoom, mousepos);
  }

  layerMapnik = new OpenLayers.Layer.OSM.Mapnik("Mapnik");
  map.addLayer(layerMapnik);

  var lonLat = new OpenLayers.LonLat(lon, lat).transform(new OpenLayers.Projection("EPSG:4326"), map.getProjectionObject());
  map.setCenter (lonLat, zoom);


  /**
   * Layers are created and put in switcher
   */
  function add_item(category, layer) {
    map.addLayer(layer);
    var checked = '';
    if (layer.getVisibility()) { checked = "checked='checked'"; };
    $("#" + category).append("<span id=\"" + layer.name + "\">" +
     " <div id='layer_switcher_colour' style='background-color:rgb(" + layer.colour + ")' />" +
     "<input type='checkbox' id='togglelayer' " + checked + " /><font>" + layer.name + " </font><br /></span>"
     );
  }

  var signallayer = new OpenLayers.Layer.OSM.Overlay4("signallayer", {isBaseLayer: false, visibility: false});
  var wlsignalLayer = new OpenLayers.Layer.OSM.Overlay3("Wireless Leiden Coverage", {isBaseLayer: false, visibility: true});
  var nodesLayer = new OpenLayers.Layer.GML.NodesOverlay("Node Locations", {isBaseLayer: false, visibility: false});

  add_item('default', signallayer);
  add_item('default', wlsignalLayer);
  add_item('features', nodesLayer);
}
