#!/bin/sh
#
# Quick and dirty hack to import all data

DATAROOT=${1:-"`pwd $0`/scan-data"}
MAP_CACHE=${MAP_CACHE:-"/usr/local/var/httpd/cache/maps"}
MANAGE="`dirname $0`/manage.py"
SSH_USER=backup
SSH_KEY="`dirname $0`/id_rsa"
export PYTHON_EGG_CACHE=/tmp/

echo "# rsync webfolder"
rsync -e "ssh -i $SSH_KEY -l $SSH_USER -o StrictHostKeyChecking=no" -az tyan.wirelessleiden.nl:/usr/local/www/webfolder/scan-data/ $DATAROOT


echo "# unzip compressed .tar.gz files"
for FILE in `find $DATAROOT -name '*.tar.gz' | sort`; do
  TARDIR=`dirname $FILE`
  tar -C $TARDIR -xkzf $FILE
done

#Kismet netxml Imports
FILES="`find $DATAROOT -name '*netxml*' | sort`"
[ -n "$FILES" ] && $MANAGE import_common $ARGS $FILES

# Import all measure data
for USERDIR in `find $DATAROOT -mindepth 1 -maxdepth 1 -type d | sort`; do
  for DEVICEDIR in `find $USERDIR -mindepth 1 -maxdepth 1 -type d | sort`; do
    USERNAME=`basename $USERDIR`
    DEVICE=`basename $DEVICEDIR`
    ARGS="-g $USERNAME -e $USERNAME@wirelessleiden.nl -k $DEVICE"

    echo $ARGS
    #Kismet gpsxml Imports
    FILES="`find $DEVICEDIR -name '*gpsxml*'`"
    [ -n "$FILES" ] && $MANAGE import_datafile $ARGS $FILES

    # DroidStumber imports
    FILES=`find $DEVICEDIR -name 'ScanResult-*'`
    [ -n "$FILES" ] && $MANAGE import_datafile $ARGS $FILES

    # Kismet imports
    FILES=`find $DEVICEDIR -name '*.ns1'`
    [ -n "$FILES" ] && $MANAGE import_datafile $ARGS $FILES
  done
done

if [ -r $MAP_CACHE ]; then
  echo "# Clear cache $MAP_CACHE"
  htcacheclean -v -l10K -p$MAP_CACHE 
fi

