var map;
function init(){

  var lat = getURLParameter('lat');
  var lon = getURLParameter('lon');
  var zoom = getURLParameter('zoom');

  if(lat=='null' || lon=='null' || zoom=='null'){
    var lat   = 52.14068;
    var lon   = 4.48319;
    var zoom  = 16;
  }
  var projection_wgs = new OpenLayers.Projection("EPSG:4326"); // WGS 1984

  map = new OpenLayers.Map('heatmap', {
    controls: [
      new OpenLayers.Control.Navigation(),
      //new OpenLayers.Control.PanZoomBar(),
      //new OpenLayers.Control.ScaleLine(),
      new OpenLayers.Control.Permalink(),
      //new OpenLayers.Control.LayerSwitcher(),
      new OpenLayers.Control.MousePosition({ 'displayProjection' : projection_wgs }),
    ],
    maxExtent: new OpenLayers.Bounds(-20037508.3427892,-20037508.3427892,20037508.3427892,20037508.3427892), 
    numZoomLevels:16, 
    maxResolution:156543.0339, 
    units:'m', 
    projection: "EPSG:900913",
    displayProjection: new OpenLayers.Projection("EPSG:4326")
  });

  map.events.register('click', map, GetMousePos);
  function GetMousePos(pos) {
    var pix = map.getLonLatFromPixel(new OpenLayers.Pixel(pos.xy.x,pos.xy.y));
    var mousepos = OpenLayers.Layer.SphericalMercator.inverseMercator(pix.lon, pix.lat);
    var zoomlevel = map.getZoom();
    getNodeList(zoom, mousepos);
  }

  layerMapnik = new OpenLayers.Layer.OSM.Mapnik("Mapnik");
  map.addLayer(layerMapnik);

  layerHeatmap2 = new OpenLayers.Layer.OSM.Overlay2("All Access points", {isBaseLayer: false, visibility: true});
  map.addLayer(layerHeatmap2);

  layerHeatmap3 = new OpenLayers.Layer.OSM.Overlay3("Wireless Leiden Only", {isBaseLayer: false, visibility: true});
  map.addLayer(layerHeatmap3);

  layerHeatmap = new OpenLayers.Layer.OSM.Overlay1("Original Heatmap generator", {isBaseLayer: false, visibility: false});
  map.addLayer(layerHeatmap);
	
  var lonLat = new OpenLayers.LonLat(lon, lat).transform(new OpenLayers.Projection("EPSG:4326"), map.getProjectionObject());
  map.setCenter (lonLat, zoom);

  signallayer = new OpenLayers.Layer.OSM.Overlay4("signallayer", {isBaseLayer: false, visibility: true});
  map.addLayer(signallayer);

  $("#default").append("<span id=\"" + layerHeatmap.name + "\"><input type=checkbox id=togglelayer /><div id='layer_switcher_colour' style='background-color:rgb(" + layerHeatmap.colour + ")' /><font>" + layerHeatmap.name + " </font><br /></span>");

  $("#default").append("<span id=\"" + layerHeatmap2.name + "\"><input type=checkbox id=togglelayer checked/><div id='layer_switcher_colour' style='background-color:rgb(" + layerHeatmap2.colour + ")' /><font>" + layerHeatmap2.name + " </font><br /></span>");

  $("#default").append("<span id=\"" + layerHeatmap3.name + "\"><input type=checkbox id=togglelayer checked/><div id='layer_switcher_colour' style='background-color:rgb(" + layerHeatmap3.colour + ")' /><font>" + layerHeatmap3.name + " </font><br /></span>");

  $("#default").append("<span id=\"" + signallayer.name + "\"><input type=checkbox id=togglelayer checked /><div id='layer_switcher_colour' style='background-color:rgb(" + signallayer.colour + ")' /><font>Signal strength: 0 - 100</font><br /></span>");
}
