function init(){

	var projection_wgs = new OpenLayers.Projection("EPSG:4326"); // WGS 1984

	map = new OpenLayers.Map('heatmap', {
		controls: [
				new OpenLayers.Control.Navigation(),
				new OpenLayers.Control.PanZoomBar(),
				new OpenLayers.Control.ScaleLine(),
				new OpenLayers.Control.LayerSwitcher(),
				new OpenLayers.Control.MousePosition({ 'displayProjection' : projection_wgs }),
		],
		maxExtent: new OpenLayers.Bounds(-20037508.3427892,-20037508.3427892,20037508.3427892,20037508.3427892), 
		numZoomLevels:16, 
		maxResolution:156543.0339, 
		units:'m', 
		projection: "EPSG:900913",
		displayProjection: new OpenLayers.Projection("EPSG:4326")
	});
	
	layerMapnik = new OpenLayers.Layer.OSM.Mapnik("Mapnik");
	map.addLayer(layerMapnik);
	layerHeatmap = new OpenLayers.Layer.OSM.Overlay1("Overlay 1", {isBaseLayer: false, visibility: true});
	map.addLayer(layerHeatmap);

	layerHeatmap2 = new OpenLayers.Layer.OSM.Overlay2("Overlay 2", {isBaseLayer: false, visibility: false});
	map.addLayer(layerHeatmap2);
	
	var lon   = 4.48907;
	var lat   = 52.158431;
	var zoom  = 16;

	var lonLat = new OpenLayers.LonLat(lon, lat).transform(new OpenLayers.Projection("EPSG:4326"), map.getProjectionObject());
	map.setCenter (lonLat, zoom);
}
