#!/usr/bin/env python
#
# Example code for random inserting points into the database.
#
# Rick van der Zwet <info@rickvanderzwet.nl>
import settings
from django.core.management import setup_environ
setup_environ(settings)


from django.db import connection, transaction
from gheat.models import *
import datetime
import os
import random
import sys

def add_random_measurements(count):
  # Create User/Equipment Objects
  username = os.getenv('USER', 'foobar')
  user, created = Gebruiker.objects.get_or_create(naam=username, email=username + '@example.org')
  equipment, created = Apparatuur.objects.get_or_create(antenne='itern', kaart='device')

  accespoint, created = Accespoint.objects.get_or_create(mac='00:11:22:33:44',
    ssid='ap-WirelessLeiden-Test', encryptie=True)

  # Mesurement run
  rondje = MeetRondje.objects.create(datum=datetime.datetime.now(), naam='Test Ronde',
    gebruiker=user, apparatuur=equipment)
  rondje.save()

  sql_insert = "INSERT INTO gheat_meting (meetrondje_id, accespoint_id, lat, lng, signaal) VALUES ";
  sql_insert_values = []
  for i in range(0,count):
    latitude = random.randint(140252,167846)
    longitude = random.randint(459019,514637)
    signal = random.randint(0,100)
    # This takes roughly 1 minute on 10000 items which logically cause it does
    # 10000 sql commits! So use the SQL INSERT hack, instead.
    #if (i % 1000) == 0:
    #  print "#Importing Random mesurements: %s/%s" % (i,count)
    #meting = Meting.objects.create(meetrondje=rondje,
    #    accespoint=accespoint,latitude=latitude,
    #    longitude=longitude,signaal=signal)
    #meting.save()
    sql_insert_values.append("('" + "','".join(map(str,[rondje.id, accespoint.id, latitude, longitude, signal])) + "')")

  sql_insert += ','.join(sql_insert_values) + ';';
  cursor = connection.cursor()
  cursor.execute(sql_insert)
  transaction.commit_unless_managed()


if __name__ == "__main__":
  # Awefull hack for argument parsing
  count = int(sys.argv[0]) if len(sys.argv) > 1 else 10000
  add_random_measurements(count)

