# (c) Roland van Laar 2006

import csv
from django.http import HttpResponse
from django.shortcuts import render_to_response
from django.template import RequestContext
from socket import gethostname 


from exodus.models import Node, Network, Location
import networkx as nx

# Views
def viewNode(request, node):
    node = Node.objects.get(name=node)
    return render_to_response('viewNode.html', {'node': node},
            context_instance=RequestContext(request))

def viewNodemapKML(request):
    nodes = Node.objects.all()
    return render_to_response('nodemap.kml', {'nodes' : nodes, 
        'linkStatus' : ['linkUp', 'linkDown', 'linkPlanned'],
        'nodeStatus' : ['nodeUp', 'nodeDown', 'nodePlanned'] }, mimetype='application/vnd.google-earth.kml+xml')

def viewNodelist(request):
    nodes = Node.objects.all()
    configFiles = (
        'rc.local',
        'rc.node.local',
        'dhcpd.conf',
        'named.conf',
        'resolv.conf' )
    return render_to_response('viewNodelist.html', {'nodes' : nodes, 
            'configFiles' : configFiles})

def viewNodesCSVlist(request):
    response = HttpResponse(mimetype='text/csv')
    response['Content-Disposition'] = 'attachment; filename=nodes.csv'
    nodes = Node.objects.all()

    writer = csv.writer(response)
    writer.writerow(['name', 'location', 'longitude', 'latitude', 'masterip'])
    for node in nodes:
        writer.writerow([node.name, node.location.description, 
                         node.location.longitude, node.location.latitude, 
                         node.masterip])
    return response


def viewInterfacesCSVlist(request):
    response = HttpResponse(mimetype='text/csv')
    response['Content-Disposition'] = 'attachment; filename=interfaces.csv'
    nodes = Node.objects.all()

    writer = csv.writer(response)
    writer.writerow(["iface","node","type","ssid","channel","antenna","polar",
                     "direction","mode","ip","netmask","linknode", 
                     "linkiface"])
    for node in nodes:
        for nic in node.interface_set.all():
            if nic == nic.link:
                mode = 'master'
            else:
                mode = 'slave'
            writer.writerow([nic.iface, node.name, nic.type, nic.ssid, 
                    nic.channel, nic.antenna, nic.get_polar_display(), 
                    nic.get_direction_display(), mode, nic.ip, nic.netmask, 
                    nic.link.node, nic.link.iface])
    return response

def configFile(request, version, node, file):
    node = Node.objects.get(name=node)
    
    # Extra statistics information for use of generation
    server = {}
    server['host'] = gethostname()
    
    templateFile = version + '/' + file
    return render_to_response(templateFile, {'node' : node, 'server' : server},
            mimetype='text/plain')

def viewNagios(request, monitor=None):
    nodes = Node.objects.all()
    networks = Network.objects.all()
    locations = Location.objects.all()
    #TODO monitors should be added to exodus (static hosts)
    # to get the viewpoint of the monitor
    #viewpoint = DhcpStatic.objects.filter(hostname=monitor).accespoint.node.name
    # for demo purpose the viewpoint is set to the monitor
    viewpoint=monitor
    # check if networkx is available
    G = nx.Graph()
    #only if monitor is set create a graph to work with
    if monitor:
        G.clear()
        for node in Node.objects.all():
            if node.status == 'up':
                    G.add_node(node.name)
                    for interface in node.interface_set.all():
                        if interface.mode == 'mn' and \
                                interface.link.node.status == 'up':
                            G.add_edge(node.name,interface.link.node.name)
    
    return render_to_response('nagios/exodus.cfg', 
                              {'nodes' : nodes, 'networks' : networks, 
                               'locations' : locations, 
                               'viewpoint' : viewpoint}, 
                              mimetype='text/plain')
