# (c) Roland van Laar

from django.conf.urls.defaults import patterns, url
#from exodus.models import *
from django.conf import settings
from django.views.generic.simple import direct_to_template
from django.contrib import databrowse
from exodus.admin import advanced_admin, plain_admin 

urlpatterns = patterns('',
    # generic view
    url(r'^$', 'exodus.urls.direct_to_template', {'template': 'index.html'}, \
            "root"),
    (r'^view/nodelist/$', 'exodus.views.viewNodelist'),
    (r'^view/node/(?P<node>.+)/$', 'exodus.views.viewNode'),

    # Content views
    (r'^view/nodemap.kml', 'exodus.views.viewNodemapKML'),

    # CSV 'export' views
    url(r'^view/csv/$', 'exodus.urls.direct_to_template', {'template': 'viewCSVlist.html'}, "csvIndex"),
    (r'^view/csv/nodes.csv$', 'exodus.views.viewNodesCSVlist'),
    (r'^view/csv/interfaces.csv$', 'exodus.views.viewInterfacesCSVlist'),

    # config urls
    (r'^config/(?P<version>.+)/(?P<node>.+)/(?P<file>.+)$', 'exodus.views.configFile'),
    
    # Nagios configuration
    url(r'^view/nagios/$', 'exodus.urls.direct_to_template', {'template': 'viewNagios.html'}, "nagios"),
    (r'^view/nagios/exodus.cfg$', 'exodus.views.viewNagios'),
    (r'^view/nagios/(?P<monitor>.+)/exodus.cfg$', 'exodus.views.viewNagios'),
    
    # 3th party/embedded database browser
    (r'^databrowse/(.*)', databrowse.site.root),

    url(r'^admin/(.*)', advanced_admin.root, name="advanced_admin"),
    (r'^plain-admin/(.*)', plain_admin.root),
)

if settings.DEBUG:
	urlpatterns += patterns('',
	url(r'^static/(?P<path>.*)$$', 'django.views.static.serve', 
            {'document_root': settings.EXODUS_STATIC_ROOT }, "static"),
	url(r'^media/(?P<path>.*)$$', 'django.views.static.serve', 
            {'document_root': settings.DJANGO_ADMIN_ROOT }, "admin"),
	)
