from django import template
from django.template.defaultfilters import stringfilter

from exodus.settings import G
if G != 'no_networkx':
    from networkx import shortest_path

register = template.Library()


@stringfilter
def getLocationName(description):
    return description.split(",")[0]

register.filter('getLocationName', getLocationName)

def getParents(node,viewpoint):
    if G != 'no_networkx':
        route = shortest_path(G,viewpoint,node)
        parents = [viewpoint]
        if route and len(route) > 2:
            for hop in route:
                if hop != node and hop != viewpoint:
                    bakhop = G.neighbors(hop)
                    G.remove_node(hop)
                    if not shortest_path(G,viewpoint,node):
                        parents.append(hop)
                    for link in bakhop:
                        G.add_edge(hop,link)
        return ' '.join(parents)
    else:
        return viewpoint
register.filter('getParents', getParents)