import unittest

from exodus.tests.base import BootstrapTestCase

class LocationFormTest(BootstrapTestCase):
    
    def test_location_form(self):
        from exodus.forms import LocationForm
        data = { 'description': 'Locatie Descriptie', 
            'latitude':12.34567, 'longitude':13.45676}
        form = LocationForm(data)
        self.assertTrue(form.is_valid())
        form.save()
        from exodus.models import Location
        loc = Location.objects.get(description='Locatie Descriptie')
        self.assertEquals(loc.pk, 4)
        import decimal as D
        self.assertEquals(loc.latitude, D.Decimal("12.34567"))
        self.assertEquals(loc.longitude, D.Decimal("13.45676"))

class NodeFormTest(BootstrapTestCase):
    pass

class InterfaceFormTest(BootstrapTestCase):
    pass

class DhcpStaticFormTest(BootstrapTestCase):
    pass

def suite():
    s = unittest.TestSuite()
    s.addTest(unittest.makeSuite(LocationFormTest))
    s.addTest(unittest.makeSuite(NodeFormTest))
    s.addTest(unittest.makeSuite(InterfaceFormTest))
    s.addTest(unittest.makeSuite(DhcpStaticFormTest))
    return s
