import unittest

class BootstrapTestCase(unittest.TestCase):

    def setUp(self):
        from django.test.client import Client
        self.client = Client()        
        from exodus import settings
        self.olddbname = settings.DATABASE_NAME
        from django.db import connection
        self.dbname = connection.creation.create_test_db(0)

        #create four locations
        from exodus.models import Location
        loc1 = Location.objects.create(description = 'ASW', 
                latitude = '15.12345', longitude = '16.12345')
        loc2 = Location.objects.create(description = 'Rapenburg', 
                latitude = '27.12345', longitude = '28.12345')
        loc3 = Location.objects.create(description = 'Lepelenburg', 
                latitude = '37.12345', longitude = '48.12345')

        # We assume the wleiden.net network is already created via initial_data.
        from exodus.models import Network
        network = Network.objects.get(pk=1)
        # create multiple nodes.
        from exodus.models import Node
        self.nod1 = Node.objects.create(name='Roland', location=loc1, 
            status='up', network=network, masterip='172.16.0.1')  
        self.nod2 = Node.objects.create(name='Rick', location=loc2, status='up',
            network=network, masterip='172.16.1.1')  
        self.nod3 = Node.objects.create(name='Andrea', location=loc3, 
            status='up', network=network, masterip='172.16.2.1')  

    def tearDown(self):
        from django.db import connection
        connection.creation.destroy_test_db(self.olddbname, 0)



