from exodus.tests.base import BootstrapTestCase

class IPCalcTest(BootstrapTestCase):

    def ipcalc(a): 
        from exodus.models import Node  
        node = Node.objects.get(pk=1)
        from exodus.wlipcalc import IPCalc
        return IPCalc(node, a)

    def test_ipcalc_ip_size(self):
        netmask = 25
        ip_size = self.ipcalc(netmask)._ip_size(25)
        self.failUnless(ip_size, 128) 

    def test_ipcalc_get_used_ips(self):
        list = set(['172.16.0.1', '172.16.0.2', '172.16.0.4', '172.16.0.5', 
                '172.16.0.6', '172.16.0.7'])
        used_list = self.ipcalc(30)._get_used_ips()
        self.failUnlessEqual(list, used_list)

    def test_ipcalc_get_used_ips_with_link(self):
        from exodus.models import Interface
        link_id = Interface.objects.get(pk=1).id
        list = set(['172.16.0.1', '172.16.0.2']) 
        from exodus.wlipcalc import IPCalc
        used_list = IPCalc(self.node, 30, link_id)._get_used_ips()
        self.failUnlessEqual(list, used_list)

    def test_ipcalc_get_free_network_addr(self):
        from exodus.wllogic import show_addr
        list = ['172.16.0.1', '172.16.0.2', '172.16.0.4', '172.16.0.5', 
                '172.16.0.6', '172.16.0.7']
        network_addr = show_addr(self.ipcalc(30)._get_free_network_addr(list))
        self.failUnlessEqual(network_addr, '172.16.0.8')

    def test_ipcalc_out_of_bounds(self):
        self.failUnlessRaises(ValueError, self.ipcalc, 33)
        self.failUnlessRaises(ValueError, self.ipcalc, 24)
    
    def test_ipcalc_raise_exception(self):
        from exodus.models import Interface
        iface = Interface.objects.create(
            node = self.node, type = 'eth', iface ='eth3',
            ip = '172.16.0.130', netmask = 25)
        
        self.failUnlessRaises(Exception, self.ipcalc, 25)
    
    def test_ipcalc_32(self):
        ip = '172.16.0.3'
        netmask = 32
        ipcalc = self.ipcalc(netmask)
        
        self.failUnlessEqual(ipcalc.network, ip) 
        self.failUnlessEqual(ipcalc.ips, ip) 
        self.failUnlessEqual(ipcalc.broadcast, ip) 
        self.failUnlessEqual(ipcalc.netmask, netmask)

    def test_ipcalc(self):
        from exodus import wllogic as wl
        netmask = 28
        network = '172.16.0.16'
        ipcalc = self.ipcalc(netmask)
        self.failUnlessEqual(ipcalc.network, network )
        self.failUnlessEqual(ipcalc.broadcast, '172.16.0.31')
       
        length = len(ipcalc.ips)
        self.failUnlessEqual(length, 14)
        parse = wl.parse_addr(network)
        ip_list = []
        for i in range(1, length + 1):
            ip_list.append(wl.show_addr(parse + i))

        self.failUnlessEqual(ipcalc.ips, ip_list)
