import unittest

class BootstrapTestCase(unittest.TestCase):
    def setUp(self):
        from django.test.client import Client
        self.client = Client()        
        from exodus import settings
        self.olddbname = settings.DATABASE_NAME
        from django.db import connection
        self.dbname = connection.creation.create_test_db(0)

        #create four locations
        from exodus.models import Location
        loc1 = Location.objects.create(description = 'ASW', 
                latitude = '15.12345',
                longitude = '16.12345')
        loc2 = Location.objects.create(description = 'Rapenburg', 
                latitude = '27.12345',
                longitude = '28.12345')
        loc3 = Location.objects.create(description = 'Lepelenburg', 
                latitude = '37.12345',
                longitude = '48.12345')
        loc4 = Location.objects.create(description = 'Neude', 
                latitude = '57.12345',
                longitude = '58.12345')
        import pdb; pdb.set_trace() ;

    def tearDown(self):
        from django.db import connection
        connection.creation.destroy_test_db(self.olddbname, 0)



