#(C) Roland van Laar
# WirelessLeiden License
# 
# Script to find which antennas with which gain we have in WL.
# So we can standardize it.
#
# Usage: python antenna.py --file=/PATH/TO/py.conf
# 
import sys
import ConfigParser

def run(filename):
    config = ConfigParser.SafeConfigParser()
    config.read(filename) 
    sections = config.sections()
    s = (s for s in sections if config.has_option(s, 'antenna') and \
            config.has_option(s, 'gain'))
    antenna_list = {}
    for i in s:
        antenna = config.get(i, 'antenna')
        gain = config.get(i, 'gain')
        ag_string = '%s/%s' % (antenna, gain)
        if not antenna_list.has_key(ag_string):
            antenna_list[ag_string] = 1
        else:
            antenna_list[ag_string] += 1

    for i in antenna_list:
        print "[%s]\t %s" % (antenna_list[i], i)

if __name__ == '__main__':
    [fn for fn in sys.argv if fn.startswith('--file=')]
    filename = fn.split('=')[1]
    run(filename)
