# (c) Roland van Laar 2006

import csv
from django.http import HttpResponse
from django.shortcuts import render_to_response
from django.template import RequestContext
from socket import gethostname 


from exodus.models import Node

# Views
def viewNode(request, node):
    node = Node.objects.get(name=node)
    return render_to_response('viewNode.html', {'node': node},
            context_instance=RequestContext(request))

def viewNodemapKML(request):
    nodes = Node.objects.all()
    return render_to_response('nodemap.kml', {'nodes' : nodes, 
        'linkStatus' : ['linkUp', 'linkDown', 'linkPlanned'],
        'nodeStatus' : ['nodeUp', 'nodeDown', 'nodePlanned'] }, mimetype='application/vnd.google-earth.kml+xml')

def viewNodelist(request):
    nodes = Node.objects.all()
    configFiles = (
        'rc.local',
        'rc.node.local',
        'dhcpd.conf',
        'named.conf',
        'resolv.conf' )
    return render_to_response('viewNodelist.html', {'nodes' : nodes, 
            'configFiles' : configFiles})

def viewNodesCSVlist(request):
    response = HttpResponse(mimetype='text/csv')
    response['Content-Disposition'] = 'attachment; filename=nodes.csv'
    nodes = Node.objects.all()

    writer = csv.writer(response)
    writer.writerow(['name', 'location', 'longitude', 'latitude', 'masterip'])
    for node in nodes:
        writer.writerow([node.name, node.location.description, node.location.longitude, node.location.latitude, node.masterip])

    return response


def viewInterfacesCSVlist(request):
    response = HttpResponse(mimetype='text/csv')
    response['Content-Disposition'] = 'attachment; filename=interfaces.csv'
    nodes = Node.objects.all()

    writer = csv.writer(response)
    writer.writerow(["iface","node","type","ssid","channel","antenna","polar","direction","mode","ip","netmask","linknode", "linkiface"])
    for node in nodes:
        for nic in node.interface_set.all():
            if nic == nic.link:
                mode = 'master'
            else:
                mode = 'slave'
            writer.writerow([nic.iface, node.name, nic.type, nic.ssid, nic.channel,
                nic.antenna, nic.get_polar_display(), nic.get_direction_display(),
                mode, nic.ip, nic.netmask, nic.link.node, nic.link.iface])
    return response

def configFile(request, version, node, file):
    node = Node.objects.get(name=node)
    
    # Extra statictics information for use of generation
    server = {}
    server['host'] = gethostname()
    
    templateFile = version + '/' + file
    return render_to_response(templateFile, {'node' : node, 'server' : server},\
            mimetype='text/plain')

def nagios(request):
    nodes = Node.objects.all()
    return render_to_response('nagios.txt', {'nodes' : nodes}, 
            mimetype='text/plain')

