# (c) Roland van Laar

from django.conf.urls.defaults import *
from exodus.models import *
from django.conf import settings
from django.views.generic.simple import direct_to_template
from django.contrib import databrowse
from exodus.admin import advanced_admin, plain_admin 

urlpatterns = patterns('',
    # generic view
    url(r'^$', 'exodus.urls.direct_to_template', {'template': 'index.html'}, \
            "root"),
    (r'^view/nodelist/$', 'exodus.views.viewNodelist'),
    (r'^view/node/(?P<node>.+)/$', 'exodus.views.viewNode'),

    # config urls
    (r'^config/(?P<version>.+)/(?P<node>.+)/(?P<file>.+)$', 'exodus.views.configFile'),

    # 3th party/embedded database browser
    (r'^databrowse/(.*)', databrowse.site.root),

    url(r'^admin/(.*)', advanced_admin.root, name="advanced_admin"),
    (r'^plain-admin/(.*)', plain_admin.root),
)

if settings.DEBUG:
	urlpatterns += patterns('',
	url(r'^static/(?P<path>.*)$$', 'django.views.static.serve', 
            {'document_root': settings.EXODUS_STATIC_ROOT }, "static"),
	url(r'^media/(?P<path>.*)$$', 'django.views.static.serve', 
            {'document_root': settings.DJANGO_ADMIN_ROOT }, "admin"),
	)
