# (c) Roland van Laar 2006

from django.shortcuts import render_to_response
from django.template import RequestContext
from socket import gethostname 

from exodus.models import Node

# Views
def viewNode(request, node):
    node = Node.objects.get(name=node)
    return render_to_response('viewNode.html', {'node': node},
            context_instance=RequestContext(request))

def viewNodelist(request):
    nodes = Node.objects.all()
    configFiles = (
        'rc.local',
        'rc.node.local',
        'dhcpd.conf',
        'named.conf',
        'resolv.conf' )
    return render_to_response('viewNodelist.html', {'nodes' : nodes, 
            'configFiles' : configFiles}) 

def configFile(request, version, node, file):
    node = Node.objects.get(name=node)
    
    # Extra statictics information for use of generation
    server = {}
    server['host'] = gethostname()
    
    templateFile = version + '/' + file
    return render_to_response(templateFile, {'node' : node, 'server' : server},\
            mimetype='text/plain')

