#
# Usage: django runscript genesis_to_exodus /path/to/nodes/py.conf
#

from exodus.forms import NodeForm, LocationForm, InterfaceForm
from exodus.models import Node, Location, Interface, Antenna
import ConfigParser
from sys import argv

def import_location(location):
    locsearch = Location.objects.filter(description__exact=location['descr'])
    if len(locsearch):
        locmodel = locsearch[0]
        # XXX - should we update an existing location with new lat/lon data ?
    else:
        # XXX: you were overwriting location, which meant that the dict
        #      location was overwritten.
        loc = LocationForm({ 'description': location['descr'],
            'latitude': location['lat'], 'longitude': location['lon'] })
        if not loc.is_valid():
            for i in loc.errors.keys():
                print loc.errors[i][0]
            return None
        locmodel = loc.save()
        print 'Location ' + location['descr'] + ' created'
    return locmodel.id

def import_node(node):
    nodesearch = Node.objects.filter(name__exact=node['name'])
    if len(nodesearch):
        # XXX: Add check that len == 1, else multiple nodes with the same
        # name could exist and the wrong one might be returned 
        print 'Node '+node['name']+' already exists'
        nodemodel = nodesearch[0]
    else:
        form = NodeForm(node)
        if form.is_valid():
            nodemodel = form.save()
            print 'Node '+node['name']+' created'
        else:
            for i in form.errors.keys():
                print form.errors[i][0]
            return None
    return nodemodel.id

def import_interface(interface):
    isearch = Interface.objects.filter(node__exact=interface['node'], \
            iface__exact=interface['iface'])
    if len(isearch):
        # XXX - should we update existing interfaces ??
        intfmodel = isearch[0]
        form = InterfaceForm(interface, instance=intfmodel)
    else:
        form = InterfaceForm(interface)
    if form.is_valid():
        intfmodel = form.save()
    else:
        print 'Can\'t import interface '+interface['iface']
        # XXX - outputs html but this is supposed to be a console script
        #       fixed output to text.
        for i in form.errors.keys():
            print form.errors[i][0]
        return None
    return intfmodel.id

def import_antenna(antenna):
    antsearch = Antenna.objects.filter(type__exact=antenna['type'], 
            gain__exact=antenna['gain'])
    if len(antsearch):
        return antsearch[0].id
    else:
        newantenna = Antenna(type=antenna['type'], gain=antenna['gain'])
        newantenna.save()
        return newantenna.id

def run():
    """Import script for genesis data."""
    print """Import script for genesis."""

    # Please do mind to keep all the entries valid, altough some get
    # values get updated (i.e. mastip, ip, ssid, netmask, mode, channel, 
    # shortdesc, desc 
    dataform ={'name' : 'Foo8', 'location' : '1', 'status' : 'up',  
            'network' : '1', 'masterip' : '127.0.0.1' }
    networks = { }
    config = ConfigParser.SafeConfigParser(dataform)
    # last cmdline argument is supposed to be the config file to use
    config.read(argv[len(argv)-1]) 
    sections = config.sections()
    sections.sort()
    for s in sections:
        # get only main node blocks (interface-specific blocks 
        # will be accessed later)
        if not '/' in s : 
            node = { }
            for key in dataform:
                node[key] = config.get(s, key)
            if config.has_option(s, 'location'):
                location = { }
                location['descr'] = config.get(s, 'location')
                if location.has_key('descr'):
                    location['lat'] = config.get(s, 'latitude')
                    location['lon'] = config.get(s, 'longitude')
                    node['location'] = import_location(location)
                else:
                    #XXX: Don't do this, an error should be raised.
                    # unknown/unconfigured location has id 1
                    node['location'] = 1 

            nodeid = import_node(node)
            if nodeid:
                interfaces = config.get(s, 'interfaces')
                for intf in interfaces.split(','):
                    if not ':' in intf: # discard alias interface
                        cfgsection = node['name']+'/'+intf
                        # check for an interface-specific block
                        if config.has_section(cfgsection): 
                            # interface defaults
                            interface = { 'iface': intf, 'netmask': 32,
                                    'ip': '127.0.0.1', 'mode': 'ms',
                                    'polar': '', 'type': 'eth',
                                    'accesspoint': False }

                            #XXX: this section can be discarded because
                            #     there is no need to import ips.
                            if config.has_option(cfgsection, 'ip'):
                                ip = config.get(cfgsection, 'ip')
                                if ip.find('/') >= 0:
                                    interface['ip'] = ip.split('/')[0]
                                    interface['netmask'] = ip.split('/')[1]
                                else:
                                    interface['ip'] = ip
                            
                            for key in [ 'type', 'desc', 'ssid', 'channel', 
                                    'mode', 'polar' ]:
                                if (config.has_option(cfgsection, key)):
                                    interface[key] = config.get(cfgsection, 
                                            key)
                            interface['node'] = nodeid

                            # key is named differently in genesis -> exodus
                            if config.has_option(cfgsection, \
                                    'compass-direction') and \
                                    config.has_option(cfgsection, 'mode') and \
                                    config.get(cfgsection, 'mode') == 'ms':
                                interface['direction'] = config.get(cfgsection, 'compass-direction')
                            else:
                                interface['direction'] = ''

                            # XXX: The genesis data is complete, the type of 
                            #      antenna needs to be passed on.
                            #      it's probably better to define the types
                            #      beforehand.

                            # handle Antenna
                            # XXX - disabled because it seems to me that genesis doesn't have complete info on equipped antennas
                            #if config.has_option(cfgsection, 'antenna') and config.has_option(cfgsection, 'gain'):
                            #    antenna = config.get(cfgsection, 'antenna')
                            #    gain = config.get(cfgsection, 'gain')
                            #    if antenna and gain: # ensure we have both antenna type and gain otherwise model will complain
                            #        interface['antenna'] = import_antenna({ 'type': antenna, 'gain': gain })

                            # handle wifi links
                            dhcp = config.get(cfgsection, 'dhcp')
                            if dhcp != 'no':
                                interface['accesspoint'] = True
                            if config.has_option(cfgsection, 'ssid'):
                                ssid = interface['ssid']
                                if ssid not in networks:
                                    networks[ssid] = { 'links': [] }
                                if interface['mode'] == 'ms':
                                    #XXX: if dhcp != 'no' accesspoint = 1
                                    # fixed this above.
                                    #interface['accesspoint'] = 1
                                    networks[ssid]['master'] = import_interface(interface)
                                else:
                                    networks[ssid]['links'].append(interface)
                            else: 
                                # XXX - should we handle links on not-wifi 
                                # interfaces?
                                # XXX: yes we should
                                import_interface(interface)
                                pass


    # now we have already created all nodes and master interfaces... 
    # let's continue configuring all wifi links!
    # XXX - Note we need to add links later to ensure having all 'master nodes' 
    #       already configured and their interfaces (id) can be used to define the link.
    #       if done while processing the input file , it could happens to process managed
    #       interfaces sooner than their master ones and it's more convenient to just add
    #       links later (once we have already configured all master interfaces) instead of
    #       trying to update interfaces progressively

    # XXX: my initial thought was that you defined the ssid here, but
    #      you use it to determine who is the master and this seems to work
    #      well.
    for ssid in networks:
        for interface in networks[ssid]['links']:
            if 'master' in networks[ssid]:
                interface['link'] = networks[ssid]['master']
                import_interface(interface)
            else:
                print "No master defined for network " + ssid
    pass
