from exodus.settings import MASTERIP_NETMASK
from exodus import wllogic as wl

class IPCalc(object):
    """Calculates an ip space given a node and a netmask. 

    Given a netmask, this class calculates what the network, broadcast
    and list of ipaddresses is.
    """

    def __init__(self, node, free_netmask, link_id = None, masterip = None):
        if free_netmask <= MASTERIP_NETMASK or free_netmask > 32:
            raise ValueError, 'Netmask out of bounds.'

        self.node = node
        #XXX: unittest masterip
        if masterip == None:
            self.master_ip = node.masterip
        else:
            self.master_ip = masterip
        master_netmask = MASTERIP_NETMASK
        self.master_network = wl.get_network(self.master_ip, master_netmask)
        self.link_id = link_id

        # calculate the number of ipaddresses in the subnetmask
        self.master_ip_size = self._ip_size(master_netmask)
        self.new_ip_size = self._ip_size(free_netmask)
        
        used_list = self._get_used_ips()
        network = self._get_free_network_addr(used_list)

        if not network:
            raise Exception, "Not enough space for a /%d subnet" % \
                (free_netmask)
        else:
            self.network = wl.show_addr(network)
  
        # variables for external calling
        self.netmask = free_netmask
        if free_netmask == 32:
            self.broadcast = self.network 
            self.ips = [self.network]
        else: 
            self.broadcast = wl.get_broadcast(self.network, self.netmask)
            # get all ips in network, but make compensate for network and 
            # broadcast addresses.
            self.ips = []
            for i in range(1, self.new_ip_size-1):
                self.ips.append(wl.show_addr(network + i))                    

    def _ip_size(self, netmask):
        return int(pow(2,32 - netmask))
    
    def _get_used_ips(self):
        """ Generate a list of all used_ipaddresses.

        we take only the ip addresses of the interfaces that are
        linked to itself, because they are 'master' and the slaves
        on other nodes fall in their subnet. 
        """
        used_list = [self.master_ip] 
        for i in self.node.interface_set.all():
            #XXX: rewrite to if i.ip in masterip??
            # not i.id == self.link_id, don't populate used_list
            # with ips from it's own netmask
            #if self.link:
                if i.id == i.link_id and not i.id == self.link_id:
                    ip_size = self._ip_size(i.netmask)
                    network_addr = wl.network(i.ip, i.netmask)
                    for j in xrange(ip_size):
                        used_list.append(wl.show_addr(network_addr + j))
        return set(used_list)

    def _get_free_network_addr(self, used_list):
        """Calculate a new network address with a used_list and given netmask.
        """
        for i in xrange(self.master_ip_size/self.new_ip_size):
            network_addr = wl.parse_addr(self.master_network) + \
                    (self.new_ip_size * i)
            k = 0
            for j in xrange(self.new_ip_size):
                new_ip = wl.show_addr(network_addr + j) 
                if new_ip not in used_list:
                    k += 1 
            if k == self.new_ip_size and \
                    wl.show_addr(network_addr) != self.master_network:
                    return  network_addr
        return None
