# (c) Roland van Laar

from exodus.models import Node, WIFI_MODE_CHOICES
from exodus.settings import MASTERIP_NETMASK, WIRELESS, COMPAT
from math import ceil, log

# define variables taken from CHOICES in models.py
MASTER = WIFI_MODE_CHOICES[0][0]
MANAGED = WIFI_MODE_CHOICES[1][0]

def new_ssid_for_save_iface(nic):
    return new_ssid(nic.node, nic.iface, nic.accesspoint, nic.direction)

def new_ssid(node, iface, accesspoint=False, direction=None):
    """Generates a new ssid name for a new wifi NIC.
    
    Don't use this for an accesspoint because it will generate a new
    ssid.
    """

    nodename = node.name 
    network = node.network.name

    if accesspoint: 
        ssid_list = set([i.ssid for i in \
                node.interface_set.filter(accesspoint=True)])
        ssid = "ap%%s.%s.%s" % ( nodename, network) 
    
        free_list = set()
        if (ssid % "") not in ssid_list:
            return (ssid % (""))

                
        # compensate for the first AP. First AP ssid is: ap.nodename.network
        # second AP is ap2.nodename.network
        free_list = ( ssid % (i) for i in range(2, len(ssid_list)+2) if not 
                (ssid %(i) in ssid_list))
        return free_list.next()

    else:
        ssid = "%%S.%s.%s" % (nodename, network)
        if direction:
            return ssid % (direction)
        else: 
            return ssid % (iface)
            
#
# Taken from lvoege@gmail.com's getrange.py
#
def parse_addr(s):
	"""Remember when using an address which has a section which is higher than
	255, such as 172.16.0.256, the ip address from show_addr turns out as
	172.16.1.0
	"""
	f = s.split('.')
	return (long(f[0]) << 24L) + \
		(long(f[1]) << 16L) + \
		(long(f[2]) << 8L) + \
		long(f[3])

def show_addr(a):
	return "%d.%d.%d.%d" % ((a >> 24) & 0xff, (a >> 16) & 0xff, (a >> 8) & 0xff, a & 0xff)

def netmask2subnet(s):
	"""IPv4 netmask to subnet"""
	if s < 0 :
		raise ValueError, 'subnet is too small'
	return (0xffffffff << (32 - s))

def get_subnet(netmask):
	return(show_addr(netmask2subnet(netmask)))

def network(address, netmask):
	"""IPv4 network address when address and netmask are given"""
	return(parse_addr(address) & netmask2subnet(netmask))

def broadcast(address, netmask):
	"""IPv4 network address when address and netmask are given"""
	if netmask > 32:
		raise ValueError, 'netmask too large'
	return(parse_addr(address) | 0xffffffff >> netmask)

def get_network(address, netmask):
	return(show_addr(network(address,netmask)))

def get_broadcast(address, netmask):
	return(show_addr(broadcast(address,netmask)))

def free_master_ip(city_network, netmask = MASTERIP_NETMASK):
	"""Calculates the next free masterip."""
	if netmask < 0 or netmask > 32:
		raise ValueError, 'netmask out of bounds'	

	taken = {}

	for node in Node.objects.all():
		addr = network(node.masterip, netmask)
		taken[addr] = 1
    
	numaddrs = 1 << (32 - netmask)

	#XXX: No out of bond checking done yet
	i = parse_addr(city_network.ipspacestart)
	while taken.has_key(i):
		i = i + numaddrs
    
    # go from network address to a valid ip.
	return show_addr(i+1)

def link_is_wireless(iface):
	"""Check if the interface is wireless"""
	return iface.type in WIRELESS

def link_has_compat_type(type1, type2):
	# link types must the same
	if type1 == type2:
		return True
	# or link types must be compatible
	if type1 in COMPAT and type2 in COMPAT:
		return True

def link_is_not_to_itself(link1, link2):
	"""check if a link referenced itself."""
	return link1.node != link2.node

def calc_subnet(number_ifaces):
    #XXX: rename this to calc_netmask
	"""Returns the netmask.

	We need the subnet with number_ifaces available in subnet. As such
	we correct for the broadcast and network address.
	"""
	if number_ifaces > 254 or number_ifaces < 1:
		raise ValueError, 'Number of ifaces is out of bounds' 
	if number_ifaces == 1:
		return 32	
	return int(32) - int(ceil(log(number_ifaces+2,2)))
