#(c) Roland van Laar 2006
# vi:et:ts=4
from django.db import models

#No need to formalize it; CHOICES don't change much

STATUS_CHOICES = ( 
         ('up', 'up'),
         ('dw', 'down'),
         ('pl', 'planned'),
         )

POLAR_CHOICES = (
         ('hr', 'horizontal'),
         ('vr', 'vertical'),
         )

INTERFACE_TYPE_CHOICES = (
         ('eth', 'eth'),
         ('11a', '11a'),
         ('11b', '11b'),
         ('11g', '11g'),
         )
WIFI_MODE_CHOICES = (
         ('ms', 'master'),
         ('mn', 'managed'),
         )

class Antenna(models.Model):
    type = models.CharField(max_length=20, unique=True)
    gain = models.IntegerField(max_length=3)

    class Meta:
        verbose_name = 'Antenna'

    def __unicode__(self):
        return self.type

class Location(models.Model):
    description = models.CharField(max_length=200, unique=True)
    latitude = models.DecimalField(max_digits=16,decimal_places=14)
    longitude = models.DecimalField(max_digits=16,decimal_places=14)

    class Meta:
        verbose_name = 'Location'

    def __unicode__(self):
        return self.description


#XXX: Name Domain perhaps?
class DnsServer(models.Model):
    ipaddress = models.IPAddressField()
    domainname = models.CharField(max_length=50, unique=True)
    
    class Meta:
        verbose_name = 'Dns Server'
    
    def __unicode__(self):
        return "%s, %s"% (self.domainname, self.ipaddress )

class Network(models.Model):
    name = models.CharField(max_length=50, unique=True)
    ipspacestart = models.IPAddressField()
    netmask = models.IntegerField()

    class Meta:
     verbose_name = 'Network'

    def __unicode__(self):
        return self.name

class Node(models.Model):
    name = models.CharField(max_length=30, unique=True)
    location = models.ForeignKey(Location)
    status = models.CharField(max_length=10, choices=STATUS_CHOICES , \
        default='up')
    network = models.ForeignKey(Network,default=1)
    masterip = models.IPAddressField(unique=True)
 
    class Meta:
        ordering = ['name']
        verbose_name = 'Node'

    def __unicode__(self):
        return self.name

class Interface(models.Model):
    node = models.ForeignKey(Node)
    type = models.CharField(max_length=10, choices=INTERFACE_TYPE_CHOICES, 
            default='eth')
    iface = models.CharField(max_length=10, verbose_name="interface", 
            default='eth0')
    accesspoint = models.BooleanField()
    polar = models.CharField(blank=True, max_length=10, choices=POLAR_CHOICES)
    antenna = models.ForeignKey(Antenna, blank=True, null=True)
    link = models.ForeignKey('self', blank=True, null=True)
    ip = models.IPAddressField(unique=True, blank=True)
    netmask = models.IntegerField(null=True, blank=True)
    ssid = models.CharField(max_length=50, blank=True, null=True)
    mode = models.CharField(max_length=10, choices=WIFI_MODE_CHOICES,
            blank=True)
    channel = models.IntegerField(blank=True, null=True)
    shortdesc = models.CharField(blank=True, max_length=10)
    desc = models.CharField(blank=True, max_length=100)
   
    class Meta:
        unique_together = ('node', 'iface')
        verbose_name = 'Interface'
   
    def __unicode__(self):
        return "%s/%s" % (self.node, self.iface)

    def save(self, force_insert=False, force_update=False):
        super(Interface, self).save(force_insert, force_update)
        # If link is not defined we link to self.
        if not self.link:
            self.link = self
            super(Interface, self).save(False, True)
        

class DhcpStatic(models.Model):
    hostname = models.CharField(max_length=10,unique=True)
    macaddress = models.CharField(max_length=17)
    address = models.IPAddressField()
    public_accesspoint = models.ForeignKey(Interface)

    class Meta:
        verbose_name = "Static host"

    def __unicode__(self):
        return self.hostname
